<p align="center">
	<img src="images/flexlayout-logo-2.png" alt="FlexLayout and PinLayout Performance" width=100/>
</p>


<h1 align="center" style="color: #376C9D; font-family: Arial Black, Gadget, sans-serif; font-size: 1.5em">FlexLayout Examples</h1>

The FlexLayout's Example exposes some usage example of FlexLayout.

The Example App is available in 2 versions:

* [SPM (using Swift Package Manager)](https://github.com/layoutBox/FlexLayout/tree/master/Example/SPM)
* [Cocoapods](https://github.com/layoutBox/FlexLayout/tree/master/Example/cocoapods) 

### Running the SPM (Swift Package Manager) Example app
1. Open the Xcode project `Example/SPM/FlexLayoutSample-SPM.xcodeproj`.
3. Select the `FlexLayoutSample-SPM` target.
4. Run the app on your device or simulator.

</br>

### Running the Cocoapods Example app
1. Do a `pod install` from the `Example/cocoapods` directory.
2. Open the newly generated `FlexLayout.xcworkspace` Xcode workspace.
3. Select the `FlexLayoutSample` target.
4. Run the app on your device or simulator.

</br>

## Intro Example
FlexLayout introduction example.  
[Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/Intro/IntroView.swift)

<a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/Intro/IntroView.swift"><img src="images/examples/flexlayout_exampleapp_intro_all.png" width=340/></a>

  
## Ray Wenderlich Yoga Tutorial
An implementation of the [Ray Wenderlich Yoga Tutorial](https://www.raywenderlich.com/161413/yoga-tutorial-using-cross-platform-layout-engine). This example is the most complete one.  
[Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/RaywenderlichTutorial)

<a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/RaywenderlichTutorial"><img src="images/examples/flexlayout_exampleapp_ray_wenderlich_tutorial.png" width=120/></a>

## UITableView with variable size cells.
This example show how FlexLayout can be used to layout UITableView cells that have variables sizes.  
[Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/TableViewExample)

<a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/TableViewExample"><img src="images/examples/flexlayout_exampleapp_uitableview.png" width=120/></a>

## UICollectionView with variable size cells
This example show how FlexLayout can be used to layout UICollectionView cells that have variables sizes.  
[Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/CollectionViewExample)

<a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/CollectionViewExample"><img src="images/examples/flexlayout_example_collectionview.png" width=120/></a>


## Yoga's examples Implementation 

Implementation of all [Yoga's examples](https://facebook.github.io/yoga/)

|  C | <a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleA/YogaExampleAView.swift"><img src="images/examples/flexlayout_exampleapp_yoga_c.png" width=120/></a> | [Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleA/YogaExampleAView.swift) |
|---------|:-:|:-:|
|  Obj-C | <a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleB/YogaExampleBView.swift"><img src="images/examples/flexlayout_exampleapp_yoga_objc.png" width=120/></a> | [Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleB/YogaExampleBView.swift) |
| Java | <a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleC/YogaExampleCView.swift"><img src="images/examples/flexlayout_exampleapp_yoga_java.png" width=120/></a> | [Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleC/YogaExampleCView.swift) |
|  C# | <a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleD/YogaExampleDView.swift"><img src="images/examples/flexlayout_exampleapp_yoga_csharp.png" width=120/></a> | [Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleD/YogaExampleDView.swift) |
|  Android | <a href="https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleE/YogaExampleEView.swift"><img src="images/examples/flexlayout_exampleapp_yoga_android.png" width=120/></a> | [Source code](https://github.com/layoutBox/FlexLayout/blob/master/Example/FlexLayoutSample/UI/Examples/YogaExampleE/YogaExampleEView.swift) |
