//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Weakify w/ Void-Returning Functions")
struct WeakifyVoidReturningTests {
    // MARK: Tests

    @Test("Void variant becomes a no-op after release")
    func voidVariantAfterRelease() {
        var wasCalled = false

        var fire: (() -> Void)!

        do {
            let tap = Tap {
                wasCalled = true
            }
            
            fire = weakify(Tap.fire, on: tap)
            fire()
            
            #expect(wasCalled)
            
            wasCalled = false
        }

        fire()
        
        #expect(wasCalled == false)
    }
    
    @Test("Void variant forwards to the method")
    func voidVariantWhileAlive() {
        let recorder = Recorder()
        
        let record = weakify(Recorder.record(_:), on: recorder)
        record("hello")
        
        #expect(recorder.last == "hello")
    }
}
