//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Weakify w/ Value-Returning Functions")
struct WeakifyValueReturningTests {
    // MARK: Tests

    @Test("Falls back to default after target is deallocated")
    func returnsDefaultAfterTargetReleased() {
        let box = WeakBox<Counter>()
        var add: ((Int) -> Int)!

        do {
            let counter = Counter()
            box.reference = counter
            
            add = weakify(Counter.add(_:), on: counter, default: -1)
        }

        #expect(box.reference == nil)
        #expect(add(42) == -1)
    }
    
    @Test("Returns the wrapped value while target lives")
    func returnsValueWhileTargetAlive() {
        let counter = Counter()
        
        let add = weakify(Counter.add(_:), on: counter, default: -1)
        
        #expect(add(3) == 3)
        #expect(counter.value == 3)
    }
}
