//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Synchronization
import Testing
@testable import Weakify

@Suite("Weakify w/ Sendable Void-Returning Functions")
struct WeakifySendableVoidReturningTests {
    // MARK: Tests

    @Test("Void variant becomes a no-op after release")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func voidVariantAfterRelease() {
        let wasCalled = Mutex(false)

        var fire: (@Sendable () -> Void)!

        do {
            let tap = SendableTap {
                wasCalled.withLock {
                    $0 = true
                }
            }
            
            fire = weakify(SendableTap.fire, on: tap)
            fire()
            
            #expect(
                wasCalled.withLock {
                    $0
                }
            )
            
            wasCalled.withLock {
                $0 = false
            }
        }

        fire()
        
        #expect(
            wasCalled.withLock {
                $0
            } == false
        )
    }
    
    @Test("Void variant forwards to the method")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func voidVariantWhileAlive() {
        let recorder = SendableRecorder()
        
        let record: @Sendable (String) -> Void = weakify(SendableRecorder.record(_:), on: recorder)
        record("hello")
        
        #expect(recorder.last == "hello")
    }
}
