//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Weakify w/ Sendable Parameter Packs & Optional Closures")
struct WeakifySendableOptionalParameterPackTests {
    // MARK: Tests
    
    @Test("Multiple heterogeneous arguments work")
    func heterogeneousArguments() {
        let formatter = SendableFormatter()
        
        let format: @Sendable (Int, String) -> String? = weakify(SendableFormatter.format(_:_:), on: formatter, default: nil)

        #expect(format(42, "answer") == "answer:42")
    }
    
    @Test("Multiple homogenous arguments work")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func homogenousArguments() {
        let counter = SendableCounter()
        
        let addPair: @Sendable (Int, Int) -> Int? = weakify(SendableCounter.add(_:_:), on: counter, default: nil)
        
        #expect(addPair(2, 5) == 7)
    }
    
    @Test("Multiple heterogeneous arguments work with non-nil default")
    func heterogeneousArgumentsWithNonNilDefault() {
        let formatter = SendableFormatter()
        
        let format: @Sendable (Int, String) -> String? = weakify(SendableFormatter.format(_:_:), on: formatter, default: "n/a")

        #expect(format(42, "answer") == "answer:42")
    }
    
    @Test("Multiple homogenous arguments work with non-nil default")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func homogenousArgumentsWithNonNilDefault() {
        let counter = SendableCounter()
        
        let addPair: @Sendable (Int, Int) -> Int? = weakify(SendableCounter.add(_:_:), on: counter, default: -1)
        
        #expect(addPair(2, 5) == 7)
    }
}
