//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Weakify w/ Parameter Packs")
struct WeakifyParameterPackTests {
    // MARK: Tests
    
    @Test("Multiple heterogeneous arguments work")
    func heterogeneousArguments() {
        let formatter = Formatter()
        
        let format = weakify(Formatter.format(_:_:), on: formatter, default: "n/a")

        #expect(format(42, "answer") == "answer:42")
    }
    
    @Test("Multiple homogenous arguments work")
    func homogenousArguments() {
        let counter = Counter()
        
        let addPair = weakify(Counter.add(_:_:), on: counter, default: -1)
        
        #expect(addPair(2, 5) == 7)
    }
}
