//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Void-Returning Functions")
struct DisownVoidReturningTests {
    // MARK: Tests

    @Test("Target is deallocated without extending lifetime")
    func targetDeallocatedWithoutExtendingLifetime() {
        let box = WeakBox<Tap>()
        var fire: (() -> Void)!

        do {
            let tap = Tap { }
            box.reference = tap
            
            fire = disown(Tap.fire, on: tap)
            fire()
        }

        #expect(box.reference == nil)
    }
    
    @Test("Void variant forwards to the method")
    func voidVariantWhileAlive() {
        let recorder = Recorder()
        
        let record = disown(Recorder.record(_:), on: recorder)
        record("hello")
        
        #expect(recorder.last == "hello")
    }
}
