//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Value-Returning Functions")
struct DisownValueReturningTests {
    // MARK: Tests

    @Test("Target is deallocated without extending lifetime")
    func targetDeallocatedWithoutExtendingLifetime() {
        let box = WeakBox<Counter>()
        var add: ((Int) -> Int)!

        do {
            let counter = Counter()
            box.reference = counter
            
            add = disown(Counter.add(_:), on: counter)
            
            #expect(add(3) == 3)
        }

        #expect(box.reference == nil)
    }
    
    @Test("Returns the wrapped value while target lives")
    func returnsValueWhileTargetAlive() {
        let counter = Counter()
        
        let add = disown(Counter.add(_:), on: counter)
        
        #expect(add(3) == 3)
        #expect(counter.value == 3)
    }
}
