//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Sendable Void-Returning Functions")
struct DisownSendableVoidReturningTests {
    // MARK: Tests

    @Test("Target is deallocated without extending lifetime")
    func targetDeallocatedWithoutExtendingLifetime() {
        let box = WeakBox<SendableTap>()
        var fire: (@Sendable () -> Void)!

        do {
            let tap = SendableTap { }
            box.reference = tap
            
            fire = disown(SendableTap.fire, on: tap)
            fire()
        }

        #expect(box.reference == nil)
    }
    
    @Test("Void variant forwards to the method")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func voidVariantWhileAlive() {
        let recorder = SendableRecorder()
        
        let record: @Sendable (String) -> Void = disown(SendableRecorder.record, on: recorder)
        record("hello")
        
        #expect(recorder.last == "hello")
    }
}
