//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Sendable Value-Returning Functions")
struct DisownSendableValueReturningTests {
    // MARK: Tests

    @Test("Target is deallocated without extending lifetime")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func targetDeallocatedWithoutExtendingLifetime() {
        let box = WeakBox<SendableCounter>()
        var add: (@Sendable (Int) -> Int)!

        do {
            let counter = SendableCounter()
            box.reference = counter
            
            add = disown(SendableCounter.add, on: counter)
            
            #expect(add(3) == 3)
        }

        #expect(box.reference == nil)
    }
    
    @Test("Returns the wrapped value while target lives")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func returnsValueWhileTargetAlive() {
        let counter = SendableCounter()
        
        let add: @Sendable (Int) -> Int = disown(SendableCounter.add, on: counter)
        
        #expect(add(3) == 3)
        #expect(counter.value == 3)
    }
}
