//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Sendable Parameter Packs")
struct DisownSendableParameterPackTests {
    // MARK: Tests
    
    @Test("Multiple heterogeneous arguments work")
    func heterogeneousArguments() {
        let formatter = SendableFormatter()
        
        let format: @Sendable (Int, String) -> String = disown(SendableFormatter.format, on: formatter)

        #expect(format(42, "answer") == "answer:42")
    }
    
    @Test("Multiple homogenous arguments work")
    @available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
    func homogenousArguments() {
        let counter = SendableCounter()
        
        let addPair: @Sendable (Int, Int) -> Int = disown(SendableCounter.add, on: counter)
        
        #expect(addPair(2, 5) == 7)
    }
}
