//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation
import Testing
@testable import Weakify

@Suite("Disown w/ Parameter Packs")
struct DisownParameterPackTests {
    // MARK: Tests
    
    @Test("Multiple heterogeneous arguments work")
    func heterogeneousArguments() {
        let formatter = Formatter()
        
        let format = disown(Formatter.format(_:_:), on: formatter)

        #expect(format(42, "answer") == "answer:42")
    }
    
    @Test("Multiple homogenous arguments work")
    func homogenousArguments() {
        let counter = Counter()
        
        let addPair = disown(Counter.add(_:_:), on: counter)
        
        #expect(addPair(2, 5) == 7)
    }
}
