#====================================================================
#
#          Winim - Windows API, COM, and CLR Module for Nim
#               Copyright (c) Chen Kai-Hung, Ward
#
#====================================================================
import winimbase
import windef
import winerror
import wingdi
import winuser
import objbase
import commdlg
import mmsystem
#include <vfw.h>
#include <msacm.h>
type
  HIC* = HANDLE
  HDRAWDIB* = HANDLE
  TWOCC* = WORD
  HVIDEO* = HANDLE
  HACMDRIVERID* = HANDLE
  HACMDRIVER* = HANDLE
  HACMSTREAM* = HANDLE
  HACMOBJ* = HANDLE
  COMPVARS* {.pure.} = object
    cbSize*: LONG
    dwFlags*: DWORD
    hic*: HIC
    fccType*: DWORD
    fccHandler*: DWORD
    lpbiIn*: LPBITMAPINFO
    lpbiOut*: LPBITMAPINFO
    lpBitsOut*: LPVOID
    lpBitsPrev*: LPVOID
    lFrame*: LONG
    lKey*: LONG
    lDataRate*: LONG
    lQ*: LONG
    lKeyCount*: LONG
    lpState*: LPVOID
    cbState*: LONG
  PCOMPVARS* = ptr COMPVARS
  TDRAWDIBTIME* {.pure.} = object
    timeCount*: LONG
    timeDraw*: LONG
    timeDecompress*: LONG
    timeDither*: LONG
    timeStretch*: LONG
    timeBlt*: LONG
    timeSetDIBits*: LONG
  LPDRAWDIBTIME* = ptr TDRAWDIBTIME
  TAVISTREAMINFOW* {.pure.} = object
    fccType*: DWORD
    fccHandler*: DWORD
    dwFlags*: DWORD
    dwCaps*: DWORD
    wPriority*: WORD
    wLanguage*: WORD
    dwScale*: DWORD
    dwRate*: DWORD
    dwStart*: DWORD
    dwLength*: DWORD
    dwInitialFrames*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwQuality*: DWORD
    dwSampleSize*: DWORD
    rcFrame*: RECT
    dwEditCount*: DWORD
    dwFormatChangeCount*: DWORD
    szName*: array[64, WCHAR]
  LPAVISTREAMINFOW* = ptr TAVISTREAMINFOW
  TAVISTREAMINFOA* {.pure.} = object
    fccType*: DWORD
    fccHandler*: DWORD
    dwFlags*: DWORD
    dwCaps*: DWORD
    wPriority*: WORD
    wLanguage*: WORD
    dwScale*: DWORD
    dwRate*: DWORD
    dwStart*: DWORD
    dwLength*: DWORD
    dwInitialFrames*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwQuality*: DWORD
    dwSampleSize*: DWORD
    rcFrame*: RECT
    dwEditCount*: DWORD
    dwFormatChangeCount*: DWORD
    szName*: array[64, char]
  LPAVISTREAMINFOA* = ptr TAVISTREAMINFOA
  TAVIFILEINFOW* {.pure.} = object
    dwMaxBytesPerSec*: DWORD
    dwFlags*: DWORD
    dwCaps*: DWORD
    dwStreams*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwWidth*: DWORD
    dwHeight*: DWORD
    dwScale*: DWORD
    dwRate*: DWORD
    dwLength*: DWORD
    dwEditCount*: DWORD
    szFileType*: array[64, WCHAR]
  LPAVIFILEINFOW* = ptr TAVIFILEINFOW
  TAVIFILEINFOA* {.pure.} = object
    dwMaxBytesPerSec*: DWORD
    dwFlags*: DWORD
    dwCaps*: DWORD
    dwStreams*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwWidth*: DWORD
    dwHeight*: DWORD
    dwScale*: DWORD
    dwRate*: DWORD
    dwLength*: DWORD
    dwEditCount*: DWORD
    szFileType*: array[64, char]
  LPAVIFILEINFOA* = ptr TAVIFILEINFOA
  AVICOMPRESSOPTIONS* {.pure.} = object
    fccType*: DWORD
    fccHandler*: DWORD
    dwKeyFrameEvery*: DWORD
    dwQuality*: DWORD
    dwBytesPerSecond*: DWORD
    dwFlags*: DWORD
    lpFormat*: LPVOID
    cbFormat*: DWORD
    lpParms*: LPVOID
    cbParms*: DWORD
    dwInterleaveEvery*: DWORD
  LPAVICOMPRESSOPTIONS* = ptr AVICOMPRESSOPTIONS
  IAVIStream* {.pure.} = object
    lpVtbl*: ptr IAVIStreamVtbl
  IAVIStreamVtbl* {.pure, inheritable.} = object of IUnknownVtbl
    Create*: proc(self: ptr IAVIStream, lParam1: LPARAM, lParam2: LPARAM): HRESULT {.stdcall.}
    Info*: proc(self: ptr IAVIStream, psi: ptr TAVISTREAMINFOW, lSize: LONG): HRESULT {.stdcall.}
    FindSample*: proc(self: ptr IAVIStream, lPos: LONG, lFlags: LONG): LONG {.stdcall.}
    ReadFormat*: proc(self: ptr IAVIStream, lPos: LONG, lpFormat: LPVOID, lpcbFormat: ptr LONG): HRESULT {.stdcall.}
    SetFormat*: proc(self: ptr IAVIStream, lPos: LONG, lpFormat: LPVOID, cbFormat: LONG): HRESULT {.stdcall.}
    Read*: proc(self: ptr IAVIStream, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, plBytes: ptr LONG, plSamples: ptr LONG): HRESULT {.stdcall.}
    Write*: proc(self: ptr IAVIStream, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, dwFlags: DWORD, plSampWritten: ptr LONG, plBytesWritten: ptr LONG): HRESULT {.stdcall.}
    Delete*: proc(self: ptr IAVIStream, lStart: LONG, lSamples: LONG): HRESULT {.stdcall.}
    ReadData*: proc(self: ptr IAVIStream, fcc: DWORD, lp: LPVOID, lpcb: ptr LONG): HRESULT {.stdcall.}
    WriteData*: proc(self: ptr IAVIStream, fcc: DWORD, lp: LPVOID, cb: LONG): HRESULT {.stdcall.}
    SetInfo*: proc(self: ptr IAVIStream, lpInfo: ptr TAVISTREAMINFOW, cbInfo: LONG): HRESULT {.stdcall.}
  PAVISTREAM* = ptr IAVIStream
  IAVIStreaming* {.pure.} = object
    lpVtbl*: ptr IAVIStreamingVtbl
  IAVIStreamingVtbl* {.pure, inheritable.} = object of IUnknownVtbl
    Begin*: proc(self: ptr IAVIStreaming, lStart: LONG, lEnd: LONG, lRate: LONG): HRESULT {.stdcall.}
    End*: proc(self: ptr IAVIStreaming): HRESULT {.stdcall.}
  PAVISTREAMING* = ptr IAVIStreaming
  IAVIEditStream* {.pure.} = object
    lpVtbl*: ptr IAVIEditStreamVtbl
  IAVIEditStreamVtbl* {.pure, inheritable.} = object of IUnknownVtbl
    Cut*: proc(self: ptr IAVIEditStream, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.stdcall.}
    Copy*: proc(self: ptr IAVIEditStream, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.stdcall.}
    Paste*: proc(self: ptr IAVIEditStream, plPos: ptr LONG, plLength: ptr LONG, pstream: PAVISTREAM, lStart: LONG, lEnd: LONG): HRESULT {.stdcall.}
    Clone*: proc(self: ptr IAVIEditStream, ppResult: ptr PAVISTREAM): HRESULT {.stdcall.}
    SetInfo*: proc(self: ptr IAVIEditStream, lpInfo: ptr TAVISTREAMINFOW, cbInfo: LONG): HRESULT {.stdcall.}
  PAVIEDITSTREAM* = ptr IAVIEditStream
  IAVIPersistFile* {.pure.} = object
    lpVtbl*: ptr IAVIPersistFileVtbl
  IAVIPersistFileVtbl* {.pure, inheritable.} = object of IPersistFileVtbl
    Reserved1*: proc(self: ptr IAVIPersistFile): HRESULT {.stdcall.}
  PAVIPERSISTFILE* = ptr IAVIPersistFile
  IAVIFile* {.pure.} = object
    lpVtbl*: ptr IAVIFileVtbl
  IAVIFileVtbl* {.pure, inheritable.} = object of IUnknownVtbl
    Info*: proc(self: ptr IAVIFile, pfi: ptr TAVIFILEINFOW, lSize: LONG): HRESULT {.stdcall.}
    GetStream*: proc(self: ptr IAVIFile, ppStream: ptr PAVISTREAM, fccType: DWORD, lParam: LONG): HRESULT {.stdcall.}
    CreateStream*: proc(self: ptr IAVIFile, ppStream: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOW): HRESULT {.stdcall.}
    WriteData*: proc(self: ptr IAVIFile, ckid: DWORD, lpData: LPVOID, cbData: LONG): HRESULT {.stdcall.}
    ReadData*: proc(self: ptr IAVIFile, ckid: DWORD, lpData: LPVOID, lpcbData: ptr LONG): HRESULT {.stdcall.}
    EndRecord*: proc(self: ptr IAVIFile): HRESULT {.stdcall.}
    DeleteStream*: proc(self: ptr IAVIFile, fccType: DWORD, lParam: LONG): HRESULT {.stdcall.}
  PAVIFILE* = ptr IAVIFile
  IGetFrame* {.pure.} = object
    lpVtbl*: ptr IGetFrameVtbl
  IGetFrameVtbl* {.pure, inheritable.} = object of IUnknownVtbl
    GetFrame*: proc(self: ptr IGetFrame, lPos: LONG): LPVOID {.stdcall.}
    Begin*: proc(self: ptr IGetFrame, lStart: LONG, lEnd: LONG, lRate: LONG): HRESULT {.stdcall.}
    End*: proc(self: ptr IGetFrame): HRESULT {.stdcall.}
    SetFormat*: proc(self: ptr IGetFrame, lpbi: LPBITMAPINFOHEADER, lpBits: LPVOID, x: int32, y: int32, dx: int32, dy: int32): HRESULT {.stdcall.}
  PGETFRAME* = ptr IGetFrame
  LPHVIDEO* = ptr HVIDEO
  VIDEOHDR* {.pure.} = object
    lpData*: LPBYTE
    dwBufferLength*: DWORD
    dwBytesUsed*: DWORD
    dwTimeCaptured*: DWORD
    dwUser*: DWORD_PTR
    dwFlags*: DWORD
    dwReserved*: array[4, DWORD_PTR]
  PVIDEOHDR* = ptr VIDEOHDR
  LPVIDEOHDR* = ptr VIDEOHDR
  CHANNEL_CAPS* {.pure.} = object
    dwFlags*: DWORD
    dwSrcRectXMod*: DWORD
    dwSrcRectYMod*: DWORD
    dwSrcRectWidthMod*: DWORD
    dwSrcRectHeightMod*: DWORD
    dwDstRectXMod*: DWORD
    dwDstRectYMod*: DWORD
    dwDstRectWidthMod*: DWORD
    dwDstRectHeightMod*: DWORD
  PCHANNEL_CAPS* = ptr CHANNEL_CAPS
  LPCHANNEL_CAPS* = ptr CHANNEL_CAPS
  CAPDRIVERCAPS* {.pure.} = object
    wDeviceIndex*: UINT
    fHasOverlay*: WINBOOL
    fHasDlgVideoSource*: WINBOOL
    fHasDlgVideoFormat*: WINBOOL
    fHasDlgVideoDisplay*: WINBOOL
    fCaptureInitialized*: WINBOOL
    fDriverSuppliesPalettes*: WINBOOL
    hVideoIn*: HANDLE
    hVideoOut*: HANDLE
    hVideoExtIn*: HANDLE
    hVideoExtOut*: HANDLE
  PCAPDRIVERCAPS* = ptr CAPDRIVERCAPS
  LPCAPDRIVERCAPS* = ptr CAPDRIVERCAPS
  CAPSTATUS* {.pure.} = object
    uiImageWidth*: UINT
    uiImageHeight*: UINT
    fLiveWindow*: WINBOOL
    fOverlayWindow*: WINBOOL
    fScale*: WINBOOL
    ptScroll*: POINT
    fUsingDefaultPalette*: WINBOOL
    fAudioHardware*: WINBOOL
    fCapFileExists*: WINBOOL
    dwCurrentVideoFrame*: DWORD
    dwCurrentVideoFramesDropped*: DWORD
    dwCurrentWaveSamples*: DWORD
    dwCurrentTimeElapsedMS*: DWORD
    hPalCurrent*: HPALETTE
    fCapturingNow*: WINBOOL
    dwReturn*: DWORD
    wNumVideoAllocated*: UINT
    wNumAudioAllocated*: UINT
  PCAPSTATUS* = ptr CAPSTATUS
  LPCAPSTATUS* = ptr CAPSTATUS
  CAPTUREPARMS* {.pure.} = object
    dwRequestMicroSecPerFrame*: DWORD
    fMakeUserHitOKToCapture*: WINBOOL
    wPercentDropForError*: UINT
    fYield*: WINBOOL
    dwIndexSize*: DWORD
    wChunkGranularity*: UINT
    fUsingDOSMemory*: WINBOOL
    wNumVideoRequested*: UINT
    fCaptureAudio*: WINBOOL
    wNumAudioRequested*: UINT
    vKeyAbort*: UINT
    fAbortLeftMouse*: WINBOOL
    fAbortRightMouse*: WINBOOL
    fLimitEnabled*: WINBOOL
    wTimeLimit*: UINT
    fMCIControl*: WINBOOL
    fStepMCIDevice*: WINBOOL
    dwMCIStartTime*: DWORD
    dwMCIStopTime*: DWORD
    fStepCaptureAt2x*: WINBOOL
    wStepCaptureAverageFrames*: UINT
    dwAudioBufferSize*: DWORD
    fDisableWriteCache*: WINBOOL
    AVStreamMaster*: UINT
  PCAPTUREPARMS* = ptr CAPTUREPARMS
  LPCAPTUREPARMS* = ptr CAPTUREPARMS
  CAPINFOCHUNK* {.pure.} = object
    fccInfoID*: FOURCC
    lpData*: LPVOID
    cbData*: LONG
  PCAPINFOCHUNK* = ptr CAPINFOCHUNK
  LPCAPINFOCHUNK* = ptr CAPINFOCHUNK
  PHACMDRIVERID* = ptr HACMDRIVERID
  LPHACMDRIVERID* = ptr HACMDRIVERID
  PHACMDRIVER* = ptr HACMDRIVER
  LPHACMDRIVER* = ptr HACMDRIVER
  PHACMSTREAM* = ptr HACMSTREAM
  LPHACMSTREAM* = ptr HACMSTREAM
  PHACMOBJ* = ptr HACMOBJ
  LPHACMOBJ* = ptr HACMOBJ
  ACMDRIVERPROC* = proc (P1: DWORD_PTR, P2: HACMDRIVERID, P3: UINT, P4: LPARAM, P5: LPARAM): LRESULT {.stdcall.}
  LPACMDRIVERPROC* = ptr ACMDRIVERPROC
const
  ACMDRIVERDETAILS_SHORTNAME_CHARS* = 32
  ACMDRIVERDETAILS_LONGNAME_CHARS* = 128
  ACMDRIVERDETAILS_COPYRIGHT_CHARS* = 80
  ACMDRIVERDETAILS_LICENSING_CHARS* = 128
  ACMDRIVERDETAILS_FEATURES_CHARS* = 512
type
  ACMDRIVERDETAILSA* {.pure, packed.} = object
    cbStruct*: DWORD
    fccType*: FOURCC
    fccComp*: FOURCC
    wMid*: WORD
    wPid*: WORD
    vdwACM*: DWORD
    vdwDriver*: DWORD
    fdwSupport*: DWORD
    cFormatTags*: DWORD
    cFilterTags*: DWORD
    hicon*: HICON
    szShortName*: array[ACMDRIVERDETAILS_SHORTNAME_CHARS, char]
    szLongName*: array[ACMDRIVERDETAILS_LONGNAME_CHARS, char]
    szCopyright*: array[ACMDRIVERDETAILS_COPYRIGHT_CHARS, char]
    szLicensing*: array[ACMDRIVERDETAILS_LICENSING_CHARS, char]
    szFeatures*: array[ACMDRIVERDETAILS_FEATURES_CHARS, char]
  PACMDRIVERDETAILSA* = ptr ACMDRIVERDETAILSA
  LPACMDRIVERDETAILSA* = ptr ACMDRIVERDETAILSA
  ACMDRIVERDETAILSW* {.pure, packed.} = object
    cbStruct*: DWORD
    fccType*: FOURCC
    fccComp*: FOURCC
    wMid*: WORD
    wPid*: WORD
    vdwACM*: DWORD
    vdwDriver*: DWORD
    fdwSupport*: DWORD
    cFormatTags*: DWORD
    cFilterTags*: DWORD
    hicon*: HICON
    szShortName*: array[ACMDRIVERDETAILS_SHORTNAME_CHARS, WCHAR]
    szLongName*: array[ACMDRIVERDETAILS_LONGNAME_CHARS, WCHAR]
    szCopyright*: array[ACMDRIVERDETAILS_COPYRIGHT_CHARS, WCHAR]
    szLicensing*: array[ACMDRIVERDETAILS_LICENSING_CHARS, WCHAR]
    szFeatures*: array[ACMDRIVERDETAILS_FEATURES_CHARS, WCHAR]
  PACMDRIVERDETAILSW* = ptr ACMDRIVERDETAILSW
  LPACMDRIVERDETAILSW* = ptr ACMDRIVERDETAILSW
const
  ACMFORMATTAGDETAILS_FORMATTAG_CHARS* = 48
type
  ACMFORMATTAGDETAILSA* {.pure.} = object
    cbStruct*: DWORD
    dwFormatTagIndex*: DWORD
    dwFormatTag*: DWORD
    cbFormatSize*: DWORD
    fdwSupport*: DWORD
    cStandardFormats*: DWORD
    szFormatTag*: array[ACMFORMATTAGDETAILS_FORMATTAG_CHARS, char]
  PACMFORMATTAGDETAILSA* = ptr ACMFORMATTAGDETAILSA
  LPACMFORMATTAGDETAILSA* = ptr ACMFORMATTAGDETAILSA
  ACMFORMATTAGDETAILSW* {.pure.} = object
    cbStruct*: DWORD
    dwFormatTagIndex*: DWORD
    dwFormatTag*: DWORD
    cbFormatSize*: DWORD
    fdwSupport*: DWORD
    cStandardFormats*: DWORD
    szFormatTag*: array[ACMFORMATTAGDETAILS_FORMATTAG_CHARS, WCHAR]
  PACMFORMATTAGDETAILSW* = ptr ACMFORMATTAGDETAILSW
  LPACMFORMATTAGDETAILSW* = ptr ACMFORMATTAGDETAILSW
const
  ACMFORMATDETAILS_FORMAT_CHARS* = 128
type
  ACMFORMATDETAILSA* {.pure, packed.} = object
    cbStruct*: DWORD
    dwFormatIndex*: DWORD
    dwFormatTag*: DWORD
    fdwSupport*: DWORD
    pwfx*: LPWAVEFORMATEX
    cbwfx*: DWORD
    szFormat*: array[ACMFORMATDETAILS_FORMAT_CHARS, char]
  PACMFORMATDETAILSA* = ptr ACMFORMATDETAILSA
  LPACMFORMATDETAILSA* = ptr ACMFORMATDETAILSA
  ACMFORMATDETAILSW* {.pure, packed.} = object
    cbStruct*: DWORD
    dwFormatIndex*: DWORD
    dwFormatTag*: DWORD
    fdwSupport*: DWORD
    pwfx*: LPWAVEFORMATEX
    cbwfx*: DWORD
    szFormat*: array[ACMFORMATDETAILS_FORMAT_CHARS, WCHAR]
  PACMFORMATDETAILSW* = ptr ACMFORMATDETAILSW
  LPACMFORMATDETAILSW* = ptr ACMFORMATDETAILSW
  ACMFORMATCHOOSEHOOKPROCA* = proc (hwnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM): UINT {.stdcall.}
  ACMFORMATCHOOSEA* {.pure, packed.} = object
    cbStruct*: DWORD
    fdwStyle*: DWORD
    hwndOwner*: HWND
    pwfx*: LPWAVEFORMATEX
    cbwfx*: DWORD
    pszTitle*: LPCSTR
    szFormatTag*: array[ACMFORMATTAGDETAILS_FORMATTAG_CHARS, char]
    szFormat*: array[ACMFORMATDETAILS_FORMAT_CHARS, char]
    pszName*: LPSTR
    cchName*: DWORD
    fdwEnum*: DWORD
    pwfxEnum*: LPWAVEFORMATEX
    hInstance*: HINSTANCE
    pszTemplateName*: LPCSTR
    lCustData*: LPARAM
    pfnHook*: ACMFORMATCHOOSEHOOKPROCA
  PACMFORMATCHOOSEA* = ptr ACMFORMATCHOOSEA
  LPACMFORMATCHOOSEA* = ptr ACMFORMATCHOOSEA
  ACMFORMATCHOOSEHOOKPROCW* = proc (hwnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM): UINT {.stdcall.}
  ACMFORMATCHOOSEW* {.pure, packed.} = object
    cbStruct*: DWORD
    fdwStyle*: DWORD
    hwndOwner*: HWND
    pwfx*: LPWAVEFORMATEX
    cbwfx*: DWORD
    pszTitle*: LPCWSTR
    szFormatTag*: array[ACMFORMATTAGDETAILS_FORMATTAG_CHARS, WCHAR]
    szFormat*: array[ACMFORMATDETAILS_FORMAT_CHARS, WCHAR]
    pszName*: LPWSTR
    cchName*: DWORD
    fdwEnum*: DWORD
    pwfxEnum*: LPWAVEFORMATEX
    hInstance*: HINSTANCE
    pszTemplateName*: LPCWSTR
    lCustData*: LPARAM
    pfnHook*: ACMFORMATCHOOSEHOOKPROCW
  PACMFORMATCHOOSEW* = ptr ACMFORMATCHOOSEW
  LPACMFORMATCHOOSEW* = ptr ACMFORMATCHOOSEW
const
  ACMFILTERTAGDETAILS_FILTERTAG_CHARS* = 48
type
  ACMFILTERTAGDETAILSA* {.pure.} = object
    cbStruct*: DWORD
    dwFilterTagIndex*: DWORD
    dwFilterTag*: DWORD
    cbFilterSize*: DWORD
    fdwSupport*: DWORD
    cStandardFilters*: DWORD
    szFilterTag*: array[ACMFILTERTAGDETAILS_FILTERTAG_CHARS, char]
  PACMFILTERTAGDETAILSA* = ptr ACMFILTERTAGDETAILSA
  LPACMFILTERTAGDETAILSA* = ptr ACMFILTERTAGDETAILSA
  ACMFILTERTAGDETAILSW* {.pure.} = object
    cbStruct*: DWORD
    dwFilterTagIndex*: DWORD
    dwFilterTag*: DWORD
    cbFilterSize*: DWORD
    fdwSupport*: DWORD
    cStandardFilters*: DWORD
    szFilterTag*: array[ACMFILTERTAGDETAILS_FILTERTAG_CHARS, WCHAR]
  PACMFILTERTAGDETAILSW* = ptr ACMFILTERTAGDETAILSW
  LPACMFILTERTAGDETAILSW* = ptr ACMFILTERTAGDETAILSW
const
  ACMFILTERDETAILS_FILTER_CHARS* = 128
type
  ACMFILTERDETAILSA* {.pure, packed.} = object
    cbStruct*: DWORD
    dwFilterIndex*: DWORD
    dwFilterTag*: DWORD
    fdwSupport*: DWORD
    pwfltr*: LPWAVEFILTER
    cbwfltr*: DWORD
    szFilter*: array[ACMFILTERDETAILS_FILTER_CHARS, char]
  PACMFILTERDETAILSA* = ptr ACMFILTERDETAILSA
  LPACMFILTERDETAILSA* = ptr ACMFILTERDETAILSA
  ACMFILTERDETAILSW* {.pure, packed.} = object
    cbStruct*: DWORD
    dwFilterIndex*: DWORD
    dwFilterTag*: DWORD
    fdwSupport*: DWORD
    pwfltr*: LPWAVEFILTER
    cbwfltr*: DWORD
    szFilter*: array[ACMFILTERDETAILS_FILTER_CHARS, WCHAR]
  PACMFILTERDETAILSW* = ptr ACMFILTERDETAILSW
  LPACMFILTERDETAILSW* = ptr ACMFILTERDETAILSW
  ACMFILTERCHOOSEHOOKPROCA* = proc (hwnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM): UINT {.stdcall.}
  ACMFILTERCHOOSEA* {.pure, packed.} = object
    cbStruct*: DWORD
    fdwStyle*: DWORD
    hwndOwner*: HWND
    pwfltr*: LPWAVEFILTER
    cbwfltr*: DWORD
    pszTitle*: LPCSTR
    szFilterTag*: array[ACMFILTERTAGDETAILS_FILTERTAG_CHARS, char]
    szFilter*: array[ACMFILTERDETAILS_FILTER_CHARS, char]
    pszName*: LPSTR
    cchName*: DWORD
    fdwEnum*: DWORD
    pwfltrEnum*: LPWAVEFILTER
    hInstance*: HINSTANCE
    pszTemplateName*: LPCSTR
    lCustData*: LPARAM
    pfnHook*: ACMFILTERCHOOSEHOOKPROCA
  PACMFILTERCHOOSEA* = ptr ACMFILTERCHOOSEA
  LPACMFILTERCHOOSEA* = ptr ACMFILTERCHOOSEA
  ACMFILTERCHOOSEHOOKPROCW* = proc (hwnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM): UINT {.stdcall.}
  ACMFILTERCHOOSEW* {.pure, packed.} = object
    cbStruct*: DWORD
    fdwStyle*: DWORD
    hwndOwner*: HWND
    pwfltr*: LPWAVEFILTER
    cbwfltr*: DWORD
    pszTitle*: LPCWSTR
    szFilterTag*: array[ACMFILTERTAGDETAILS_FILTERTAG_CHARS, WCHAR]
    szFilter*: array[ACMFILTERDETAILS_FILTER_CHARS, WCHAR]
    pszName*: LPWSTR
    cchName*: DWORD
    fdwEnum*: DWORD
    pwfltrEnum*: LPWAVEFILTER
    hInstance*: HINSTANCE
    pszTemplateName*: LPCWSTR
    lCustData*: LPARAM
    pfnHook*: ACMFILTERCHOOSEHOOKPROCW
  PACMFILTERCHOOSEW* = ptr ACMFILTERCHOOSEW
  LPACMFILTERCHOOSEW* = ptr ACMFILTERCHOOSEW
when winimCpu64:
  const
    VFW_DRVRESERVED* = 15
when winimCpu32:
  const
    VFW_DRVRESERVED* = 10
type
  ACMSTREAMHEADER* {.pure, packed.} = object
    cbStruct*: DWORD
    fdwStatus*: DWORD
    dwUser*: DWORD_PTR
    pbSrc*: LPBYTE
    cbSrcLength*: DWORD
    cbSrcLengthUsed*: DWORD
    dwSrcUser*: DWORD_PTR
    pbDst*: LPBYTE
    cbDstLength*: DWORD
    cbDstLengthUsed*: DWORD
    dwDstUser*: DWORD_PTR
    dwReservedDriver*: array[VFW_DRVRESERVED, DWORD]
  PACMSTREAMHEADER* = ptr ACMSTREAMHEADER
  LPACMSTREAMHEADER* = ptr ACMSTREAMHEADER
const
  ICVERSION* = 0x0104
  BI_1632* = 0x32333631
  ICERR_OK* = 0
  ICERR_DONTDRAW* = 1
  ICERR_NEWPALETTE* = 2
  ICERR_GOTOKEYFRAME* = 3
  ICERR_STOPDRAWING* = 4
  ICERR_UNSUPPORTED* = -1
  ICERR_BADFORMAT* = -2
  ICERR_MEMORY* = -3
  ICERR_INTERNAL* = -4
  ICERR_BADFLAGS* = -5
  ICERR_BADPARAM* = -6
  ICERR_BADSIZE* = -7
  ICERR_BADHANDLE* = -8
  ICERR_CANTUPDATE* = -9
  ICERR_ABORT* = -10
  ICERR_ERROR* = -100
  ICERR_BADBITDEPTH* = -200
  ICERR_BADIMAGESIZE* = -201
  ICERR_CUSTOM* = -400
  ICMODE_COMPRESS* = 1
  ICMODE_DECOMPRESS* = 2
  ICMODE_FASTDECOMPRESS* = 3
  ICMODE_QUERY* = 4
  ICMODE_FASTCOMPRESS* = 5
  ICMODE_DRAW* = 8
  AVIIF_LIST* = 0x00000001
  AVIIF_TWOCC* = 0x00000002
  AVIIF_KEYFRAME* = 0x00000010
  ICQUALITY_LOW* = 0
  ICQUALITY_HIGH* = 10000
  ICQUALITY_DEFAULT* = -1
  ICM_USER* = DRV_USER+0x0000
  ICM_RESERVED_LOW* = DRV_USER+0x1000
  ICM_RESERVED* = ICM_RESERVED_LOW
  ICM_RESERVED_HIGH* = DRV_USER+0x2000
  ICM_GETSTATE* = ICM_RESERVED+0
  ICM_SETSTATE* = ICM_RESERVED+1
  ICM_GETINFO* = ICM_RESERVED+2
  ICM_CONFIGURE* = ICM_RESERVED+10
  ICM_ABOUT* = ICM_RESERVED+11
  ICM_GETERRORTEXT* = ICM_RESERVED+12
  ICM_GETFORMATNAME* = ICM_RESERVED+20
  ICM_ENUMFORMATS* = ICM_RESERVED+21
  ICM_GETDEFAULTQUALITY* = ICM_RESERVED+30
  ICM_GETQUALITY* = ICM_RESERVED+31
  ICM_SETQUALITY* = ICM_RESERVED+32
  ICM_SET* = ICM_RESERVED+40
  ICM_GET* = ICM_RESERVED+41
  ICM_FRAMERATE* = mmioFOURCC('F','r','m','R')
  ICM_KEYFRAMERATE* = mmioFOURCC('K','e','y','R')
  ICM_COMPRESS_GET_FORMAT* = ICM_USER+4
  ICM_COMPRESS_GET_SIZE* = ICM_USER+5
  ICM_COMPRESS_QUERY* = ICM_USER+6
  ICM_COMPRESS_BEGIN* = ICM_USER+7
  ICM_COMPRESS* = ICM_USER+8
  ICM_COMPRESS_END* = ICM_USER+9
  ICM_DECOMPRESS_GET_FORMAT* = ICM_USER+10
  ICM_DECOMPRESS_QUERY* = ICM_USER+11
  ICM_DECOMPRESS_BEGIN* = ICM_USER+12
  ICM_DECOMPRESS* = ICM_USER+13
  ICM_DECOMPRESS_END* = ICM_USER+14
  ICM_DECOMPRESS_SET_PALETTE* = ICM_USER+29
  ICM_DECOMPRESS_GET_PALETTE* = ICM_USER+30
  ICM_DRAW_QUERY* = ICM_USER+31
  ICM_DRAW_BEGIN* = ICM_USER+15
  ICM_DRAW_GET_PALETTE* = ICM_USER+16
  ICM_DRAW_UPDATE* = ICM_USER+17
  ICM_DRAW_START* = ICM_USER+18
  ICM_DRAW_STOP* = ICM_USER+19
  ICM_DRAW_BITS* = ICM_USER+20
  ICM_DRAW_END* = ICM_USER+21
  ICM_DRAW_GETTIME* = ICM_USER+32
  ICM_DRAW* = ICM_USER+33
  ICM_DRAW_WINDOW* = ICM_USER+34
  ICM_DRAW_SETTIME* = ICM_USER+35
  ICM_DRAW_REALIZE* = ICM_USER+36
  ICM_DRAW_FLUSH* = ICM_USER+37
  ICM_DRAW_RENDERBUFFER* = ICM_USER+38
  ICM_DRAW_START_PLAY* = ICM_USER+39
  ICM_DRAW_STOP_PLAY* = ICM_USER+40
  ICM_DRAW_SUGGESTFORMAT* = ICM_USER+50
  ICM_DRAW_CHANGEPALETTE* = ICM_USER+51
  ICM_DRAW_IDLE* = ICM_USER+52
  ICM_GETBUFFERSWANTED* = ICM_USER+41
  ICM_GETDEFAULTKEYFRAMERATE* = ICM_USER+42
  ICM_DECOMPRESSEX_BEGIN* = ICM_USER+60
  ICM_DECOMPRESSEX_QUERY* = ICM_USER+61
  ICM_DECOMPRESSEX* = ICM_USER+62
  ICM_DECOMPRESSEX_END* = ICM_USER+63
  ICM_COMPRESS_FRAMES_INFO* = ICM_USER+70
  ICM_COMPRESS_FRAMES* = ICM_USER+71
  ICM_SET_STATUS_PROC* = ICM_USER+72
  VIDCF_QUALITY* = 0x0001
  VIDCF_CRUNCH* = 0x0002
  VIDCF_TEMPORAL* = 0x0004
  VIDCF_COMPRESSFRAMES* = 0x0008
  VIDCF_DRAW* = 0x0010
  VIDCF_FASTTEMPORALC* = 0x0020
  VIDCF_QUALITYTIME* = 0x0040
  VIDCF_FASTTEMPORALD* = 0x0080
  VIDCF_FASTTEMPORAL* = VIDCF_FASTTEMPORALC or VIDCF_FASTTEMPORALD
  ICCOMPRESS_KEYFRAME* = 0x00000001
  ICCOMPRESSFRAMES_PADDING* = 0x00000001
  ICSTATUS_START* = 0
  ICSTATUS_STATUS* = 1
  ICSTATUS_END* = 2
  ICSTATUS_ERROR* = 3
  ICSTATUS_YIELD* = 4
  ICDECOMPRESS_HURRYUP* = 0x80000000'i32
  ICDECOMPRESS_UPDATE* = 0x40000000
  ICDECOMPRESS_PREROLL* = 0x20000000
  ICDECOMPRESS_NULLFRAME* = 0x10000000
  ICDECOMPRESS_NOTKEYFRAME* = 0x08000000
  ICDRAW_QUERY* = 0x00000001
  ICDRAW_FULLSCREEN* = 0x00000002
  ICDRAW_HDC* = 0x00000004
  ICDRAW_ANIMATE* = 0x00000008
  ICDRAW_CONTINUE* = 0x00000010
  ICDRAW_MEMORYDC* = 0x00000020
  ICDRAW_UPDATING* = 0x00000040
  ICDRAW_RENDER* = 0x00000080
  ICDRAW_BUFFER* = 0x00000100
  ICDRAW_HURRYUP* = 0x80000000'i32
  ICDRAW_UPDATE* = 0x40000000
  ICDRAW_PREROLL* = 0x20000000
  ICDRAW_NULLFRAME* = 0x10000000
  ICDRAW_NOTKEYFRAME* = 0x08000000
  ICINSTALL_UNICODE* = 0x8000
  ICINSTALL_FUNCTION* = 0x0001
  ICINSTALL_DRIVER* = 0x0002
  ICINSTALL_HDRV* = 0x0004
  ICINSTALL_DRIVERW* = 0x8002
  ICMF_CONFIGURE_QUERY* = 0x00000001
  ICMF_ABOUT_QUERY* = 0x00000001
  ICMF_COMPVARS_VALID* = 0x00000001
  ICMF_CHOOSE_KEYFRAME* = 0x0001
  ICMF_CHOOSE_DATARATE* = 0x0002
  ICMF_CHOOSE_PREVIEW* = 0x0004
  ICMF_CHOOSE_ALLCOMPRESSORS* = 0x0008
  DDF_0001* = 0x0001
  DDF_UPDATE* = 0x0002
  DDF_SAME_HDC* = 0x0004
  DDF_SAME_DRAW* = 0x0008
  DDF_DONTDRAW* = 0x0010
  DDF_ANIMATE* = 0x0020
  DDF_BUFFER* = 0x0040
  DDF_JUSTDRAWIT* = 0x0080
  DDF_FULLSCREEN* = 0x0100
  DDF_BACKGROUNDPAL* = 0x0200
  DDF_NOTKEYFRAME* = 0x0400
  DDF_HURRYUP* = 0x0800
  DDF_HALFTONE* = 0x1000
  DDF_2000* = 0x2000
  DDF_PREROLL* = DDF_DONTDRAW
  DDF_SAME_DIB* = DDF_SAME_DRAW
  DDF_SAME_SIZE* = DDF_SAME_DRAW
  PD_CAN_DRAW_DIB* = 0x0001
  PD_CAN_STRETCHDIB* = 0x0002
  PD_STRETCHDIB_1_1_OK* = 0x0004
  PD_STRETCHDIB_1_2_OK* = 0x0008
  PD_STRETCHDIB_1_N_OK* = 0x0010
  formtypeAVI* = mmioFOURCC('A','V','I',' ')
  listtypeAVIHEADER* = mmioFOURCC('h','d','r','l')
  ckidAVIMAINHDR* = mmioFOURCC('a','v','i','h')
  listtypeSTREAMHEADER* = mmioFOURCC('s','t','r','l')
  ckidSTREAMHEADER* = mmioFOURCC('s','t','r','h')
  ckidSTREAMFORMAT* = mmioFOURCC('s','t','r','f')
  ckidSTREAMHANDLERDATA* = mmioFOURCC('s','t','r','d')
  ckidSTREAMNAME* = mmioFOURCC('s','t','r','n')
  listtypeAVIMOVIE* = mmioFOURCC('m','o','v','i')
  listtypeAVIRECORD* = mmioFOURCC('r','e','c',' ')
  ckidAVINEWINDEX* = mmioFOURCC('i','d','x','1')
  streamtypeANY* = 0
  streamtypeVIDEO* = mmioFOURCC('v','i','d','s')
  streamtypeAUDIO* = mmioFOURCC('a','u','d','s')
  streamtypeMIDI* = mmioFOURCC('m','i','d','s')
  streamtypeTEXT* = mmioFOURCC('t','x','t','s')
template aviTWOCC*(c0: untyped, c1: untyped): untyped = c0.DWORD or (c1.DWORD shl 8)
const
  cktypeDIBbits* = aviTWOCC('d','b')
  cktypeDIBcompressed* = aviTWOCC('d','c')
  cktypePALchange* = aviTWOCC('p','c')
  cktypeWAVEbytes* = aviTWOCC('w','b')
  ckidAVIPADDING* = mmioFOURCC('J','U','N','K')
  AVIF_HASINDEX* = 0x00000010
  AVIF_MUSTUSEINDEX* = 0x00000020
  AVIF_ISINTERLEAVED* = 0x00000100
  AVIF_TRUSTCKTYPE* = 0x00000800
  AVIF_WASCAPTUREFILE* = 0x00010000
  AVIF_COPYRIGHTED* = 0x00020000
  AVI_HEADERSIZE* = 2048
  AVISF_DISABLED* = 0x00000001
  AVISF_VIDEO_PALCHANGES* = 0x00010000
  AVIIF_FIRSTPART* = 0x00000020
  AVIIF_LASTPART* = 0x00000040
  AVIIF_MIDPART* = AVIIF_LASTPART or AVIIF_FIRSTPART
  AVIIF_NOTIME* = 0x00000100
  AVIIF_COMPUSE* = 0x0FFF0000
  AVIGETFRAMEF_BESTDISPLAYFMT* = 1
  AVISTREAMINFO_DISABLED* = 0x00000001
  AVISTREAMINFO_FORMATCHANGES* = 0x00010000
  AVIFILEINFO_HASINDEX* = 0x00000010
  AVIFILEINFO_MUSTUSEINDEX* = 0x00000020
  AVIFILEINFO_ISINTERLEAVED* = 0x00000100
  AVIFILEINFO_TRUSTCKTYPE* = 0x00000800
  AVIFILEINFO_WASCAPTUREFILE* = 0x00010000
  AVIFILEINFO_COPYRIGHTED* = 0x00020000
  AVIFILECAPS_CANREAD* = 0x00000001
  AVIFILECAPS_CANWRITE* = 0x00000002
  AVIFILECAPS_ALLKEYFRAMES* = 0x00000010
  AVIFILECAPS_NOCOMPRESSION* = 0x00000020
  AVICOMPRESSF_INTERLEAVE* = 0x00000001
  AVICOMPRESSF_DATARATE* = 0x00000002
  AVICOMPRESSF_KEYFRAMES* = 0x00000004
  AVICOMPRESSF_VALID* = 0x00000008
  IID_IAVIFile* = DEFINE_GUID("00020020-0000-0000-c000-000000000046")
  IID_IAVIStream* = DEFINE_GUID("00020021-0000-0000-c000-000000000046")
  IID_IAVIStreaming* = DEFINE_GUID("00020022-0000-0000-c000-000000000046")
  IID_IGetFrame* = DEFINE_GUID("00020023-0000-0000-c000-000000000046")
  IID_IAVIEditStream* = DEFINE_GUID("00020024-0000-0000-c000-000000000046")
  IID_IAVIPersistFile* = DEFINE_GUID("00020025-0000-0000-c000-000000000046")
  CLSID_AVIFile* = DEFINE_GUID("00020000-0000-0000-c000-000000000046")
  AVIFILEHANDLER_CANREAD* = 0x0001
  AVIFILEHANDLER_CANWRITE* = 0x0002
  AVIFILEHANDLER_CANACCEPTNONRGB* = 0x0004
  AVISTREAMREAD_CONVENIENT* = -1
  FIND_DIR* = 0x0000000F
  FIND_NEXT* = 0x00000001
  FIND_PREV* = 0x00000004
  VFW_FIND_FROM_START* = 0x00000008
  FIND_TYPE* = 0x000000F0
  FIND_KEY* = 0x00000010
  FIND_ANY* = 0x00000020
  FIND_FORMAT* = 0x00000040
  FIND_RET* = 0x0000F000
  FIND_POS* = 0x00000000
  FIND_LENGTH* = 0x00001000
  FIND_OFFSET* = 0x00002000
  FIND_SIZE* = 0x00003000
  FIND_INDEX* = 0x00004000
  SEARCH_NEAREST* = FIND_PREV
  SEARCH_BACKWARD* = FIND_PREV
  SEARCH_FORWARD* = FIND_NEXT
  SEARCH_KEY* = FIND_KEY
  SEARCH_ANY* = FIND_ANY
  comptypeDIB* = mmioFOURCC('D','I','B',' ')
  AVIERR_OK* = 0
template MAKE_AVIERR*(error: untyped): SCODE = MAKE_SCODE(SEVERITY_ERROR, FACILITY_ITF, error + 0x4000)
const
  AVIERR_UNSUPPORTED* = MAKE_AVIERR(101)
  AVIERR_BADFORMAT* = MAKE_AVIERR(102)
  AVIERR_MEMORY* = MAKE_AVIERR(103)
  AVIERR_INTERNAL* = MAKE_AVIERR(104)
  AVIERR_BADFLAGS* = MAKE_AVIERR(105)
  AVIERR_BADPARAM* = MAKE_AVIERR(106)
  AVIERR_BADSIZE* = MAKE_AVIERR(107)
  AVIERR_BADHANDLE* = MAKE_AVIERR(108)
  AVIERR_FILEREAD* = MAKE_AVIERR(109)
  AVIERR_FILEWRITE* = MAKE_AVIERR(110)
  AVIERR_FILEOPEN* = MAKE_AVIERR(111)
  AVIERR_COMPRESSOR* = MAKE_AVIERR(112)
  AVIERR_NOCOMPRESSOR* = MAKE_AVIERR(113)
  AVIERR_READONLY* = MAKE_AVIERR(114)
  AVIERR_NODATA* = MAKE_AVIERR(115)
  AVIERR_BUFFERTOOSMALL* = MAKE_AVIERR(116)
  AVIERR_CANTCOMPRESS* = MAKE_AVIERR(117)
  AVIERR_USERABORT* = MAKE_AVIERR(198)
  AVIERR_ERROR* = MAKE_AVIERR(199)
  MCIWND_WINDOW_CLASS* = "MCIWndClass"
  MCIWNDOPENF_NEW* = 0x0001
  MCIWNDF_NOAUTOSIZEWINDOW* = 0x0001
  MCIWNDF_NOPLAYBAR* = 0x0002
  MCIWNDF_NOAUTOSIZEMOVIE* = 0x0004
  MCIWNDF_NOMENU* = 0x0008
  MCIWNDF_SHOWNAME* = 0x0010
  MCIWNDF_SHOWPOS* = 0x0020
  MCIWNDF_SHOWMODE* = 0x0040
  MCIWNDF_SHOWALL* = 0x0070
  MCIWNDF_NOTIFYMODE* = 0x0100
  MCIWNDF_NOTIFYPOS* = 0x0200
  MCIWNDF_NOTIFYSIZE* = 0x0400
  MCIWNDF_NOTIFYERROR* = 0x1000
  MCIWNDF_NOTIFYALL* = 0x1F00
  MCIWNDF_NOTIFYANSI* = 0x0080
  MCIWNDF_NOTIFYMEDIAA* = 0x0880
  MCIWNDF_NOTIFYMEDIAW* = 0x0800
  MCIWNDF_RECORD* = 0x2000
  MCIWNDF_NOERRORDLG* = 0x4000
  MCIWNDF_NOOPEN* = 0x8000
  MCIWNDM_GETDEVICEID* = WM_USER+100
  MCIWNDM_GETSTART* = WM_USER+103
  MCIWNDM_GETLENGTH* = WM_USER+104
  MCIWNDM_GETEND* = WM_USER+105
  MCIWNDM_EJECT* = WM_USER+107
  MCIWNDM_SETZOOM* = WM_USER+108
  MCIWNDM_GETZOOM* = WM_USER+109
  MCIWNDM_SETVOLUME* = WM_USER+110
  MCIWNDM_GETVOLUME* = WM_USER+111
  MCIWNDM_SETSPEED* = WM_USER+112
  MCIWNDM_GETSPEED* = WM_USER+113
  MCIWNDM_SETREPEAT* = WM_USER+114
  MCIWNDM_GETREPEAT* = WM_USER+115
  MCIWNDM_REALIZE* = WM_USER+118
  MCIWNDM_VALIDATEMEDIA* = WM_USER+121
  MCIWNDM_PLAYFROM* = WM_USER+122
  MCIWNDM_PLAYTO* = WM_USER+123
  MCIWNDM_GETPALETTE* = WM_USER+126
  MCIWNDM_SETPALETTE* = WM_USER+127
  MCIWNDM_SETTIMERS* = WM_USER+129
  MCIWNDM_SETACTIVETIMER* = WM_USER+130
  MCIWNDM_SETINACTIVETIMER* = WM_USER+131
  MCIWNDM_GETACTIVETIMER* = WM_USER+132
  MCIWNDM_GETINACTIVETIMER* = WM_USER+133
  MCIWNDM_CHANGESTYLES* = WM_USER+135
  MCIWNDM_GETSTYLES* = WM_USER+136
  MCIWNDM_GETALIAS* = WM_USER+137
  MCIWNDM_PLAYREVERSE* = WM_USER+139
  MCIWNDM_GET_SOURCE* = WM_USER+140
  MCIWNDM_PUT_SOURCE* = WM_USER+141
  MCIWNDM_GET_DEST* = WM_USER+142
  MCIWNDM_PUT_DEST* = WM_USER+143
  MCIWNDM_CAN_PLAY* = WM_USER+144
  MCIWNDM_CAN_WINDOW* = WM_USER+145
  MCIWNDM_CAN_RECORD* = WM_USER+146
  MCIWNDM_CAN_SAVE* = WM_USER+147
  MCIWNDM_CAN_EJECT* = WM_USER+148
  MCIWNDM_CAN_CONFIG* = WM_USER+149
  MCIWNDM_PALETTEKICK* = WM_USER+150
  MCIWNDM_OPENINTERFACE* = WM_USER+151
  MCIWNDM_SETOWNER* = WM_USER+152
  MCIWNDM_SENDSTRINGA* = WM_USER+101
  MCIWNDM_GETPOSITIONA* = WM_USER+102
  MCIWNDM_GETMODEA* = WM_USER+106
  MCIWNDM_SETTIMEFORMATA* = WM_USER+119
  MCIWNDM_GETTIMEFORMATA* = WM_USER+120
  MCIWNDM_GETFILENAMEA* = WM_USER+124
  MCIWNDM_GETDEVICEA* = WM_USER+125
  MCIWNDM_GETERRORA* = WM_USER+128
  MCIWNDM_NEWA* = WM_USER+134
  MCIWNDM_RETURNSTRINGA* = WM_USER+138
  MCIWNDM_OPENA* = WM_USER+153
  MCIWNDM_SENDSTRINGW* = WM_USER+201
  MCIWNDM_GETPOSITIONW* = WM_USER+202
  MCIWNDM_GETMODEW* = WM_USER+206
  MCIWNDM_SETTIMEFORMATW* = WM_USER+219
  MCIWNDM_GETTIMEFORMATW* = WM_USER+220
  MCIWNDM_GETFILENAMEW* = WM_USER+224
  MCIWNDM_GETDEVICEW* = WM_USER+225
  MCIWNDM_GETERRORW* = WM_USER+228
  MCIWNDM_NEWW* = WM_USER+234
  MCIWNDM_RETURNSTRINGW* = WM_USER+238
  MCIWNDM_OPENW* = WM_USER+252
  MCIWNDM_NOTIFYMODE* = WM_USER+200
  MCIWNDM_NOTIFYPOS* = WM_USER+201
  MCIWNDM_NOTIFYSIZE* = WM_USER+202
  MCIWNDM_NOTIFYMEDIA* = WM_USER+203
  MCIWNDM_NOTIFYERROR* = WM_USER+205
  MCIWND_START* = -1
  MCIWND_END* = -2
  DV_ERR_OK* = 0
  DV_ERR_BASE* = 1
  DV_ERR_NONSPECIFIC* = DV_ERR_BASE
  DV_ERR_BADFORMAT* = DV_ERR_BASE+1
  DV_ERR_STILLPLAYING* = DV_ERR_BASE+2
  DV_ERR_UNPREPARED* = DV_ERR_BASE+3
  DV_ERR_SYNC* = DV_ERR_BASE+4
  DV_ERR_TOOMANYCHANNELS* = DV_ERR_BASE+5
  DV_ERR_NOTDETECTED* = DV_ERR_BASE+6
  DV_ERR_BADINSTALL* = DV_ERR_BASE+7
  DV_ERR_CREATEPALETTE* = DV_ERR_BASE+8
  DV_ERR_SIZEFIELD* = DV_ERR_BASE+9
  DV_ERR_PARAM1* = DV_ERR_BASE+10
  DV_ERR_PARAM2* = DV_ERR_BASE+11
  DV_ERR_CONFIG1* = DV_ERR_BASE+12
  DV_ERR_CONFIG2* = DV_ERR_BASE+13
  DV_ERR_FLAGS* = DV_ERR_BASE+14
  DV_ERR_13* = DV_ERR_BASE+15
  DV_ERR_NOTSUPPORTED* = DV_ERR_BASE+16
  DV_ERR_NOMEM* = DV_ERR_BASE+17
  DV_ERR_ALLOCATED* = DV_ERR_BASE+18
  DV_ERR_BADDEVICEID* = DV_ERR_BASE+19
  DV_ERR_INVALHANDLE* = DV_ERR_BASE+20
  DV_ERR_BADERRNUM* = DV_ERR_BASE+21
  DV_ERR_NO_BUFFERS* = DV_ERR_BASE+22
  DV_ERR_MEM_CONFLICT* = DV_ERR_BASE+23
  DV_ERR_IO_CONFLICT* = DV_ERR_BASE+24
  DV_ERR_DMA_CONFLICT* = DV_ERR_BASE+25
  DV_ERR_INT_CONFLICT* = DV_ERR_BASE+26
  DV_ERR_PROTECT_ONLY* = DV_ERR_BASE+27
  DV_ERR_LASTERROR* = DV_ERR_BASE+27
  DV_ERR_USER_MSG* = DV_ERR_BASE+1000
  DV_VM_OPEN* = MM_DRVM_OPEN
  DV_VM_CLOSE* = MM_DRVM_CLOSE
  DV_VM_DATA* = MM_DRVM_DATA
  DV_VM_ERROR* = MM_DRVM_ERROR
  VHDR_DONE* = 0x00000001
  VHDR_PREPARED* = 0x00000002
  VHDR_INQUEUE* = 0x00000004
  VHDR_KEYFRAME* = 0x00000008
  VHDR_VALID* = 0x0000000F
  VCAPS_OVERLAY* = 0x00000001
  VCAPS_SRC_CAN_CLIP* = 0x00000002
  VCAPS_DST_CAN_CLIP* = 0x00000004
  VCAPS_CAN_SCALE* = 0x00000008
  VIDEO_EXTERNALIN* = 0x0001
  VIDEO_EXTERNALOUT* = 0x0002
  VIDEO_IN* = 0x0004
  VIDEO_OUT* = 0x0008
  VIDEO_DLG_QUERY* = 0x0010
  VIDEO_CONFIGURE_QUERY* = 0x8000
  VIDEO_CONFIGURE_SET* = 0x1000
  VIDEO_CONFIGURE_GET* = 0x2000
  VIDEO_CONFIGURE_QUERYSIZE* = 0x0001
  VIDEO_CONFIGURE_CURRENT* = 0x0010
  VIDEO_CONFIGURE_NOMINAL* = 0x0020
  VIDEO_CONFIGURE_MIN* = 0x0040
  VIDEO_CONFIGURE_MAX* = 0x0080
  DVM_USER* = 0X4000
  DVM_CONFIGURE_START* = 0x1000
  DVM_CONFIGURE_END* = 0x1FFF
  DVM_PALETTE* = DVM_CONFIGURE_START+1
  DVM_FORMAT* = DVM_CONFIGURE_START+2
  DVM_PALETTERGB555* = DVM_CONFIGURE_START+3
  DVM_SRC_RECT* = DVM_CONFIGURE_START+4
  DVM_DST_RECT* = DVM_CONFIGURE_START+5
  WM_CAP_START* = WM_USER
  WM_CAP_UNICODE_START* = WM_USER+100
  WM_CAP_GET_CAPSTREAMPTR* = WM_CAP_START+1
  WM_CAP_SET_CALLBACK_ERRORW* = WM_CAP_UNICODE_START+2
  WM_CAP_SET_CALLBACK_STATUSW* = WM_CAP_UNICODE_START+3
  WM_CAP_SET_CALLBACK_ERRORA* = WM_CAP_START+2
  WM_CAP_SET_CALLBACK_STATUSA* = WM_CAP_START+3
  WM_CAP_SET_CALLBACK_YIELD* = WM_CAP_START+4
  WM_CAP_SET_CALLBACK_FRAME* = WM_CAP_START+5
  WM_CAP_SET_CALLBACK_VIDEOSTREAM* = WM_CAP_START+6
  WM_CAP_SET_CALLBACK_WAVESTREAM* = WM_CAP_START+7
  WM_CAP_GET_USER_DATA* = WM_CAP_START+8
  WM_CAP_SET_USER_DATA* = WM_CAP_START+9
  WM_CAP_DRIVER_CONNECT* = WM_CAP_START+10
  WM_CAP_DRIVER_DISCONNECT* = WM_CAP_START+11
  WM_CAP_DRIVER_GET_NAMEA* = WM_CAP_START+12
  WM_CAP_DRIVER_GET_VERSIONA* = WM_CAP_START+13
  WM_CAP_DRIVER_GET_NAMEW* = WM_CAP_UNICODE_START+12
  WM_CAP_DRIVER_GET_VERSIONW* = WM_CAP_UNICODE_START+13
  WM_CAP_DRIVER_GET_CAPS* = WM_CAP_START+14
  WM_CAP_FILE_SET_CAPTURE_FILEA* = WM_CAP_START+20
  WM_CAP_FILE_GET_CAPTURE_FILEA* = WM_CAP_START+21
  WM_CAP_FILE_SAVEASA* = WM_CAP_START+23
  WM_CAP_FILE_SAVEDIBA* = WM_CAP_START+25
  WM_CAP_FILE_SET_CAPTURE_FILEW* = WM_CAP_UNICODE_START+20
  WM_CAP_FILE_GET_CAPTURE_FILEW* = WM_CAP_UNICODE_START+21
  WM_CAP_FILE_SAVEASW* = WM_CAP_UNICODE_START+23
  WM_CAP_FILE_SAVEDIBW* = WM_CAP_UNICODE_START+25
  WM_CAP_FILE_ALLOCATE* = WM_CAP_START+22
  WM_CAP_FILE_SET_INFOCHUNK* = WM_CAP_START+24
  WM_CAP_EDIT_COPY* = WM_CAP_START+30
  WM_CAP_SET_AUDIOFORMAT* = WM_CAP_START+35
  WM_CAP_GET_AUDIOFORMAT* = WM_CAP_START+36
  WM_CAP_DLG_VIDEOFORMAT* = WM_CAP_START+41
  WM_CAP_DLG_VIDEOSOURCE* = WM_CAP_START+42
  WM_CAP_DLG_VIDEODISPLAY* = WM_CAP_START+43
  WM_CAP_GET_VIDEOFORMAT* = WM_CAP_START+44
  WM_CAP_SET_VIDEOFORMAT* = WM_CAP_START+45
  WM_CAP_DLG_VIDEOCOMPRESSION* = WM_CAP_START+46
  WM_CAP_SET_PREVIEW* = WM_CAP_START+50
  WM_CAP_SET_OVERLAY* = WM_CAP_START+51
  WM_CAP_SET_PREVIEWRATE* = WM_CAP_START+52
  WM_CAP_SET_SCALE* = WM_CAP_START+53
  WM_CAP_GET_STATUS* = WM_CAP_START+54
  WM_CAP_SET_SCROLL* = WM_CAP_START+55
  WM_CAP_GRAB_FRAME* = WM_CAP_START+60
  WM_CAP_GRAB_FRAME_NOSTOP* = WM_CAP_START+61
  WM_CAP_SEQUENCE* = WM_CAP_START+62
  WM_CAP_SEQUENCE_NOFILE* = WM_CAP_START+63
  WM_CAP_SET_SEQUENCE_SETUP* = WM_CAP_START+64
  WM_CAP_GET_SEQUENCE_SETUP* = WM_CAP_START+65
  WM_CAP_SET_MCI_DEVICEA* = WM_CAP_START+66
  WM_CAP_GET_MCI_DEVICEA* = WM_CAP_START+67
  WM_CAP_SET_MCI_DEVICEW* = WM_CAP_UNICODE_START+66
  WM_CAP_GET_MCI_DEVICEW* = WM_CAP_UNICODE_START+67
  WM_CAP_STOP* = WM_CAP_START+68
  WM_CAP_ABORT* = WM_CAP_START+69
  WM_CAP_SINGLE_FRAME_OPEN* = WM_CAP_START+70
  WM_CAP_SINGLE_FRAME_CLOSE* = WM_CAP_START+71
  WM_CAP_SINGLE_FRAME* = WM_CAP_START+72
  WM_CAP_PAL_OPENA* = WM_CAP_START+80
  WM_CAP_PAL_SAVEA* = WM_CAP_START+81
  WM_CAP_PAL_OPENW* = WM_CAP_UNICODE_START+80
  WM_CAP_PAL_SAVEW* = WM_CAP_UNICODE_START+81
  WM_CAP_PAL_PASTE* = WM_CAP_START+82
  WM_CAP_PAL_AUTOCREATE* = WM_CAP_START+83
  WM_CAP_PAL_MANUALCREATE* = WM_CAP_START+84
  WM_CAP_SET_CALLBACK_CAPCONTROL* = WM_CAP_START+85
  WM_CAP_UNICODE_END* = WM_CAP_PAL_SAVEW
  WM_CAP_END* = WM_CAP_UNICODE_END
  AVSTREAMMASTER_AUDIO* = 0
  AVSTREAMMASTER_NONE* = 1
  CONTROLCALLBACK_PREROLL* = 1
  CONTROLCALLBACK_CAPTURING* = 2
  infotypeDIGITIZATION_TIME* = mmioFOURCC('I','D','I','T')
  infotypeSMPTE_TIME* = mmioFOURCC('I','S','M','P')
  IDS_CAP_BEGIN* = 300
  IDS_CAP_END* = 301
  IDS_CAP_INFO* = 401
  IDS_CAP_OUTOFMEM* = 402
  IDS_CAP_FILEEXISTS* = 403
  IDS_CAP_ERRORPALOPEN* = 404
  IDS_CAP_ERRORPALSAVE* = 405
  IDS_CAP_ERRORDIBSAVE* = 406
  IDS_CAP_DEFAVIEXT* = 407
  IDS_CAP_DEFPALEXT* = 408
  IDS_CAP_CANTOPEN* = 409
  IDS_CAP_SEQ_MSGSTART* = 410
  IDS_CAP_SEQ_MSGSTOP* = 411
  IDS_CAP_VIDEDITERR* = 412
  IDS_CAP_READONLYFILE* = 413
  IDS_CAP_WRITEERROR* = 414
  IDS_CAP_NODISKSPACE* = 415
  IDS_CAP_SETFILESIZE* = 416
  IDS_CAP_SAVEASPERCENT* = 417
  IDS_CAP_DRIVER_ERROR* = 418
  IDS_CAP_WAVE_OPEN_ERROR* = 419
  IDS_CAP_WAVE_ALLOC_ERROR* = 420
  IDS_CAP_WAVE_PREPARE_ERROR* = 421
  IDS_CAP_WAVE_ADD_ERROR* = 422
  IDS_CAP_WAVE_SIZE_ERROR* = 423
  IDS_CAP_VIDEO_OPEN_ERROR* = 424
  IDS_CAP_VIDEO_ALLOC_ERROR* = 425
  IDS_CAP_VIDEO_PREPARE_ERROR* = 426
  IDS_CAP_VIDEO_ADD_ERROR* = 427
  IDS_CAP_VIDEO_SIZE_ERROR* = 428
  IDS_CAP_FILE_OPEN_ERROR* = 429
  IDS_CAP_FILE_WRITE_ERROR* = 430
  IDS_CAP_RECORDING_ERROR* = 431
  IDS_CAP_RECORDING_ERROR2* = 432
  IDS_CAP_AVI_INIT_ERROR* = 433
  IDS_CAP_NO_FRAME_CAP_ERROR* = 434
  IDS_CAP_NO_PALETTE_WARN* = 435
  IDS_CAP_MCI_CONTROL_ERROR* = 436
  IDS_CAP_MCI_CANT_STEP_ERROR* = 437
  IDS_CAP_NO_AUDIO_CAP_ERROR* = 438
  IDS_CAP_AVI_DRAWDIB_ERROR* = 439
  IDS_CAP_COMPRESSOR_ERROR* = 440
  IDS_CAP_AUDIO_DROP_ERROR* = 441
  IDS_CAP_AUDIO_DROP_COMPERROR* = 442
  IDS_CAP_STAT_LIVE_MODE* = 500
  IDS_CAP_STAT_OVERLAY_MODE* = 501
  IDS_CAP_STAT_CAP_INIT* = 502
  IDS_CAP_STAT_CAP_FINI* = 503
  IDS_CAP_STAT_PALETTE_BUILD* = 504
  IDS_CAP_STAT_OPTPAL_BUILD* = 505
  IDS_CAP_STAT_I_FRAMES* = 506
  IDS_CAP_STAT_L_FRAMES* = 507
  IDS_CAP_STAT_CAP_L_FRAMES* = 508
  IDS_CAP_STAT_CAP_AUDIO* = 509
  IDS_CAP_STAT_VIDEOCURRENT* = 510
  IDS_CAP_STAT_VIDEOAUDIO* = 511
  IDS_CAP_STAT_VIDEOONLY* = 512
  IDS_CAP_STAT_FRAMESDROPPED* = 513
  DRV_MAPPER_PREFERRED_INPUT_GET* = DRV_USER+0
  DRV_MAPPER_PREFERRED_OUTPUT_GET* = DRV_USER+2
  DRVM_MAPPER* = 0x2000
  DRVM_MAPPER_STATUS* = DRVM_MAPPER+0
  WIDM_MAPPER_STATUS* = DRVM_MAPPER_STATUS+0
  WAVEIN_MAPPER_STATUS_DEVICE* = 0
  WAVEIN_MAPPER_STATUS_MAPPED* = 1
  WAVEIN_MAPPER_STATUS_FORMAT* = 2
  WODM_MAPPER_STATUS* = DRVM_MAPPER_STATUS+0
  WAVEOUT_MAPPER_STATUS_DEVICE* = 0
  WAVEOUT_MAPPER_STATUS_MAPPED* = 1
  WAVEOUT_MAPPER_STATUS_FORMAT* = 2
  ACMERR_BASE* = 512
  ACMERR_NOTPOSSIBLE* = ACMERR_BASE+0
  ACMERR_BUSY* = ACMERR_BASE+1
  ACMERR_UNPREPARED* = ACMERR_BASE+2
  ACMERR_CANCELED* = ACMERR_BASE+3
  MM_ACM_OPEN* = MM_STREAM_OPEN
  MM_ACM_CLOSE* = MM_STREAM_CLOSE
  MM_ACM_DONE* = MM_STREAM_DONE
  ACM_METRIC_COUNT_DRIVERS* = 1
  ACM_METRIC_COUNT_CODECS* = 2
  ACM_METRIC_COUNT_CONVERTERS* = 3
  ACM_METRIC_COUNT_FILTERS* = 4
  ACM_METRIC_COUNT_DISABLED* = 5
  ACM_METRIC_COUNT_HARDWARE* = 6
  ACM_METRIC_COUNT_LOCAL_DRIVERS* = 20
  ACM_METRIC_COUNT_LOCAL_CODECS* = 21
  ACM_METRIC_COUNT_LOCAL_CONVERTERS* = 22
  ACM_METRIC_COUNT_LOCAL_FILTERS* = 23
  ACM_METRIC_COUNT_LOCAL_DISABLED* = 24
  ACM_METRIC_HARDWARE_WAVE_INPUT* = 30
  ACM_METRIC_HARDWARE_WAVE_OUTPUT* = 31
  ACM_METRIC_MAX_SIZE_FORMAT* = 50
  ACM_METRIC_MAX_SIZE_FILTER* = 51
  ACM_METRIC_DRIVER_SUPPORT* = 100
  ACM_METRIC_DRIVER_PRIORITY* = 101
  ACM_DRIVERENUMF_NOLOCAL* = 0x40000000
  ACM_DRIVERENUMF_DISABLED* = 0x80000000'i32
  ACM_DRIVERADDF_NAME* = 0x00000001
  ACM_DRIVERADDF_FUNCTION* = 0x00000003
  ACM_DRIVERADDF_NOTIFYHWND* = 0x00000004
  ACM_DRIVERADDF_TYPEMASK* = 0x00000007
  ACM_DRIVERADDF_LOCAL* = 0x00000000
  ACM_DRIVERADDF_GLOBAL* = 0x00000008
  ACMDM_USER* = DRV_USER+0x0000
  ACMDM_RESERVED_LOW* = DRV_USER+0x2000
  ACMDM_RESERVED_HIGH* = DRV_USER+0x2FFF
  ACMDM_BASE* = ACMDM_RESERVED_LOW
  ACMDM_DRIVER_ABOUT* = ACMDM_BASE+11
  ACM_DRIVERPRIORITYF_ENABLE* = 0x00000001
  ACM_DRIVERPRIORITYF_DISABLE* = 0x00000002
  ACM_DRIVERPRIORITYF_ABLEMASK* = 0x00000003
  ACM_DRIVERPRIORITYF_BEGIN* = 0x00010000
  ACM_DRIVERPRIORITYF_END* = 0x00020000
  ACM_DRIVERPRIORITYF_DEFERMASK* = 0x00030000
  ACMDRIVERDETAILS_FCCTYPE_AUDIOCODEC* = mmioFOURCC('a','u','d','c')
  ACMDRIVERDETAILS_FCCCOMP_UNDEFINED* = mmioFOURCC('\0','\0','\0','\0')
  ACMDRIVERDETAILS_SUPPORTF_CODEC* = 0x00000001
  ACMDRIVERDETAILS_SUPPORTF_CONVERTER* = 0x00000002
  ACMDRIVERDETAILS_SUPPORTF_FILTER* = 0x00000004
  ACMDRIVERDETAILS_SUPPORTF_HARDWARE* = 0x00000008
  ACMDRIVERDETAILS_SUPPORTF_ASYNC* = 0x00000010
  ACMDRIVERDETAILS_SUPPORTF_LOCAL* = 0x40000000
  ACMDRIVERDETAILS_SUPPORTF_DISABLED* = 0x80000000'i32
  ACM_FORMATTAGDETAILSF_INDEX* = 0x00000000
  ACM_FORMATTAGDETAILSF_FORMATTAG* = 0x00000001
  ACM_FORMATTAGDETAILSF_LARGESTSIZE* = 0x00000002
  ACM_FORMATTAGDETAILSF_QUERYMASK* = 0x0000000F
  ACM_FORMATDETAILSF_INDEX* = 0x00000000
  ACM_FORMATDETAILSF_FORMAT* = 0x00000001
  ACM_FORMATDETAILSF_QUERYMASK* = 0x0000000F
  ACM_FORMATENUMF_WFORMATTAG* = 0x00010000
  ACM_FORMATENUMF_NCHANNELS* = 0x00020000
  ACM_FORMATENUMF_NSAMPLESPERSEC* = 0x00040000
  ACM_FORMATENUMF_WBITSPERSAMPLE* = 0x00080000
  ACM_FORMATENUMF_CONVERT* = 0x00100000
  ACM_FORMATENUMF_SUGGEST* = 0x00200000
  ACM_FORMATENUMF_HARDWARE* = 0x00400000
  ACM_FORMATENUMF_INPUT* = 0x00800000
  ACM_FORMATENUMF_OUTPUT* = 0x01000000
  ACM_FORMATSUGGESTF_WFORMATTAG* = 0x00010000
  ACM_FORMATSUGGESTF_NCHANNELS* = 0x00020000
  ACM_FORMATSUGGESTF_NSAMPLESPERSEC* = 0x00040000
  ACM_FORMATSUGGESTF_WBITSPERSAMPLE* = 0x00080000
  ACM_FORMATSUGGESTF_TYPEMASK* = 0x00FF0000
  ACMHELPMSGSTRINGA* = "acmchoose_help"
  ACMHELPMSGSTRINGW* = "acmchoose_help"
  ACMHELPMSGCONTEXTMENUA* = "acmchoose_contextmenu"
  ACMHELPMSGCONTEXTMENUW* = "acmchoose_contextmenu"
  ACMHELPMSGCONTEXTHELPA* = "acmchoose_contexthelp"
  ACMHELPMSGCONTEXTHELPW* = "acmchoose_contexthelp"
  MM_ACM_FORMATCHOOSE* = 0x8000
  FORMATCHOOSE_MESSAGE* = 0
  FORMATCHOOSE_FORMATTAG_VERIFY* = FORMATCHOOSE_MESSAGE+0
  FORMATCHOOSE_FORMAT_VERIFY* = FORMATCHOOSE_MESSAGE+1
  FORMATCHOOSE_CUSTOM_VERIFY* = FORMATCHOOSE_MESSAGE+2
  ACMFORMATCHOOSE_STYLEF_SHOWHELP* = 0x00000004
  ACMFORMATCHOOSE_STYLEF_ENABLEHOOK* = 0x00000008
  ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATE* = 0x00000010
  ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATEHANDLE* = 0x00000020
  ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT* = 0x00000040
  ACMFORMATCHOOSE_STYLEF_CONTEXTHELP* = 0x00000080
  ACM_FILTERTAGDETAILSF_INDEX* = 0x00000000
  ACM_FILTERTAGDETAILSF_FILTERTAG* = 0x00000001
  ACM_FILTERTAGDETAILSF_LARGESTSIZE* = 0x00000002
  ACM_FILTERTAGDETAILSF_QUERYMASK* = 0x0000000F
  ACM_FILTERDETAILSF_INDEX* = 0x00000000
  ACM_FILTERDETAILSF_FILTER* = 0x00000001
  ACM_FILTERDETAILSF_QUERYMASK* = 0x0000000F
  ACM_FILTERENUMF_DWFILTERTAG* = 0x00010000
  MM_ACM_FILTERCHOOSE* = 0x8000
  FILTERCHOOSE_MESSAGE* = 0
  FILTERCHOOSE_FILTERTAG_VERIFY* = FILTERCHOOSE_MESSAGE+0
  FILTERCHOOSE_FILTER_VERIFY* = FILTERCHOOSE_MESSAGE+1
  FILTERCHOOSE_CUSTOM_VERIFY* = FILTERCHOOSE_MESSAGE+2
  ACMFILTERCHOOSE_STYLEF_SHOWHELP* = 0x00000004
  ACMFILTERCHOOSE_STYLEF_ENABLEHOOK* = 0x00000008
  ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATE* = 0x00000010
  ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATEHANDLE* = 0x00000020
  ACMFILTERCHOOSE_STYLEF_INITTOFILTERSTRUCT* = 0x00000040
  ACMFILTERCHOOSE_STYLEF_CONTEXTHELP* = 0x00000080
  ACMSTREAMHEADER_STATUSF_DONE* = 0x00010000
  ACMSTREAMHEADER_STATUSF_PREPARED* = 0x00020000
  ACMSTREAMHEADER_STATUSF_INQUEUE* = 0x00100000
  ACM_STREAMOPENF_QUERY* = 0x00000001
  ACM_STREAMOPENF_ASYNC* = 0x00000002
  ACM_STREAMOPENF_NONREALTIME* = 0x00000004
  ACM_STREAMSIZEF_SOURCE* = 0x00000000
  ACM_STREAMSIZEF_DESTINATION* = 0x00000001
  ACM_STREAMSIZEF_QUERYMASK* = 0x0000000F
  ACM_STREAMCONVERTF_BLOCKALIGN* = 0x00000004
  ACM_STREAMCONVERTF_START* = 0x00000010
  ACM_STREAMCONVERTF_END* = 0x00000020
type
  AVISAVECALLBACK* = proc (P1: int32): WINBOOL {.stdcall.}
  CAPYIELDCALLBACK* = proc (hWnd: HWND): LRESULT {.stdcall.}
  CAPSTATUSCALLBACKW* = proc (hWnd: HWND, nID: int32, lpsz: LPCWSTR): LRESULT {.stdcall.}
  CAPERRORCALLBACKW* = proc (hWnd: HWND, nID: int32, lpsz: LPCWSTR): LRESULT {.stdcall.}
  CAPSTATUSCALLBACKA* = proc (hWnd: HWND, nID: int32, lpsz: LPCSTR): LRESULT {.stdcall.}
  CAPERRORCALLBACKA* = proc (hWnd: HWND, nID: int32, lpsz: LPCSTR): LRESULT {.stdcall.}
  CAPVIDEOCALLBACK* = proc (hWnd: HWND, lpVHdr: LPVIDEOHDR): LRESULT {.stdcall.}
  CAPWAVECALLBACK* = proc (hWnd: HWND, lpWHdr: LPWAVEHDR): LRESULT {.stdcall.}
  CAPCONTROLCALLBACK* = proc (hWnd: HWND, nState: int32): LRESULT {.stdcall.}
  ACMDRIVERENUMCB* = proc (hadid: HACMDRIVERID, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFORMATTAGENUMCBA* = proc (hadid: HACMDRIVERID, paftd: LPACMFORMATTAGDETAILSA, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFORMATTAGENUMCBW* = proc (hadid: HACMDRIVERID, paftd: LPACMFORMATTAGDETAILSW, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFORMATENUMCBA* = proc (hadid: HACMDRIVERID, pafd: LPACMFORMATDETAILSA, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFORMATENUMCBW* = proc (hadid: HACMDRIVERID, pafd: LPACMFORMATDETAILSW, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFILTERTAGENUMCBA* = proc (hadid: HACMDRIVERID, paftd: LPACMFILTERTAGDETAILSA, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFILTERTAGENUMCBW* = proc (hadid: HACMDRIVERID, paftd: LPACMFILTERTAGDETAILSW, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFILTERENUMCBA* = proc (hadid: HACMDRIVERID, pafd: LPACMFILTERDETAILSA, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  ACMFILTERENUMCBW* = proc (hadid: HACMDRIVERID, pafd: LPACMFILTERDETAILSW, dwInstance: DWORD_PTR, fdwSupport: DWORD): WINBOOL {.stdcall.}
  TICOPEN* {.pure.} = object
    dwSize*: DWORD
    fccType*: DWORD
    fccHandler*: DWORD
    dwVersion*: DWORD
    dwFlags*: DWORD
    dwError*: LRESULT
    pV1Reserved*: LPVOID
    pV2Reserved*: LPVOID
    dnDevNode*: DWORD
  TICINFO* {.pure.} = object
    dwSize*: DWORD
    fccType*: DWORD
    fccHandler*: DWORD
    dwFlags*: DWORD
    dwVersion*: DWORD
    dwVersionICM*: DWORD
    szName*: array[16, WCHAR]
    szDescription*: array[128, WCHAR]
    szDriver*: array[128, WCHAR]
  TICCOMPRESS* {.pure.} = object
    dwFlags*: DWORD
    lpbiOutput*: LPBITMAPINFOHEADER
    lpOutput*: LPVOID
    lpbiInput*: LPBITMAPINFOHEADER
    lpInput*: LPVOID
    lpckid*: LPDWORD
    lpdwFlags*: LPDWORD
    lFrameNum*: LONG
    dwFrameSize*: DWORD
    dwQuality*: DWORD
    lpbiPrev*: LPBITMAPINFOHEADER
    lpPrev*: LPVOID
  ICCOMPRESSFRAMES* {.pure.} = object
    dwFlags*: DWORD
    lpbiOutput*: LPBITMAPINFOHEADER
    lOutput*: LPARAM
    lpbiInput*: LPBITMAPINFOHEADER
    lInput*: LPARAM
    lStartFrame*: LONG
    lFrameCount*: LONG
    lQuality*: LONG
    lDataRate*: LONG
    lKeyRate*: LONG
    dwRate*: DWORD
    dwScale*: DWORD
    dwOverheadPerFrame*: DWORD
    dwReserved2*: DWORD
    GetData*: proc(lInput: LPARAM, lFrame: LONG, lpBits: LPVOID, len: LONG): LONG {.stdcall.}
    PutData*: proc(lOutput: LPARAM, lFrame: LONG, lpBits: LPVOID, len: LONG): LONG {.stdcall.}
  ICSETSTATUSPROC* {.pure.} = object
    dwFlags*: DWORD
    lParam*: LPARAM
    Status*: proc(lParam: LPARAM, message: UINT, l: LONG): LONG {.stdcall.}
  TICDECOMPRESS* {.pure.} = object
    dwFlags*: DWORD
    lpbiInput*: LPBITMAPINFOHEADER
    lpInput*: LPVOID
    lpbiOutput*: LPBITMAPINFOHEADER
    lpOutput*: LPVOID
    ckid*: DWORD
  ICDECOMPRESSEX* {.pure.} = object
    dwFlags*: DWORD
    lpbiSrc*: LPBITMAPINFOHEADER
    lpSrc*: LPVOID
    lpbiDst*: LPBITMAPINFOHEADER
    lpDst*: LPVOID
    xDst*: int32
    yDst*: int32
    dxDst*: int32
    dyDst*: int32
    xSrc*: int32
    ySrc*: int32
    dxSrc*: int32
    dySrc*: int32
  TICDRAWBEGIN* {.pure.} = object
    dwFlags*: DWORD
    hpal*: HPALETTE
    hwnd*: HWND
    hdc*: HDC
    xDst*: int32
    yDst*: int32
    dxDst*: int32
    dyDst*: int32
    lpbi*: LPBITMAPINFOHEADER
    xSrc*: int32
    ySrc*: int32
    dxSrc*: int32
    dySrc*: int32
    dwRate*: DWORD
    dwScale*: DWORD
  TICDRAW* {.pure.} = object
    dwFlags*: DWORD
    lpFormat*: LPVOID
    lpData*: LPVOID
    cbData*: DWORD
    lTime*: LONG
  ICDRAWSUGGEST* {.pure.} = object
    lpbiIn*: LPBITMAPINFOHEADER
    lpbiSuggest*: LPBITMAPINFOHEADER
    dxSrc*: int32
    dySrc*: int32
    dxDst*: int32
    dyDst*: int32
    hicDecompressor*: HIC
  ICPALETTE* {.pure.} = object
    dwFlags*: DWORD
    iStart*: int32
    iLen*: int32
    lppe*: LPPALETTEENTRY
  MainAVIHeader* {.pure.} = object
    dwMicroSecPerFrame*: DWORD
    dwMaxBytesPerSec*: DWORD
    dwPaddingGranularity*: DWORD
    dwFlags*: DWORD
    dwTotalFrames*: DWORD
    dwInitialFrames*: DWORD
    dwStreams*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwWidth*: DWORD
    dwHeight*: DWORD
    dwReserved*: array[4, DWORD]
  AVIStreamHeader* {.pure.} = object
    fccType*: FOURCC
    fccHandler*: FOURCC
    dwFlags*: DWORD
    wPriority*: WORD
    wLanguage*: WORD
    dwInitialFrames*: DWORD
    dwScale*: DWORD
    dwRate*: DWORD
    dwStart*: DWORD
    dwLength*: DWORD
    dwSuggestedBufferSize*: DWORD
    dwQuality*: DWORD
    dwSampleSize*: DWORD
    rcFrame*: RECT
  AVIINDEXENTRY* {.pure.} = object
    ckid*: DWORD
    dwFlags*: DWORD
    dwChunkOffset*: DWORD
    dwChunkLength*: DWORD
  AVIPALCHANGE* {.pure.} = object
    bFirstEntry*: BYTE
    bNumEntries*: BYTE
    wFlags*: WORD
    peNew*: UncheckedArray[PALETTEENTRY]
proc VideoForWindowsVersion*(): DWORD {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICInfo*(fccType: DWORD, fccHandler: DWORD, lpicinfo: ptr TICINFO): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICInstall*(fccType: DWORD, fccHandler: DWORD, lParam: LPARAM, szDesc: LPSTR, wFlags: UINT): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICRemove*(fccType: DWORD, fccHandler: DWORD, wFlags: UINT): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICGetInfo*(hic: HIC, picinfo: ptr TICINFO, cb: DWORD): LRESULT {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICOpen*(fccType: DWORD, fccHandler: DWORD, wMode: UINT): HIC {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICOpenFunction*(fccType: DWORD, fccHandler: DWORD, wMode: UINT, lpfnHandler: FARPROC): HIC {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICClose*(hic: HIC): LRESULT {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICSendMessage*(hic: HIC, msg: UINT, dw1: DWORD_PTR, dw2: DWORD_PTR): LRESULT {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICCompress*(hic: HIC, dwFlags: DWORD, lpbiOutput: LPBITMAPINFOHEADER, lpData: LPVOID, lpbiInput: LPBITMAPINFOHEADER, lpBits: LPVOID, lpckid: LPDWORD, lpdwFlags: LPDWORD, lFrameNum: LONG, dwFrameSize: DWORD, dwQuality: DWORD, lpbiPrev: LPBITMAPINFOHEADER, lpPrev: LPVOID): DWORD {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc ICDecompress*(hic: HIC, dwFlags: DWORD, lpbiFormat: LPBITMAPINFOHEADER, lpData: LPVOID, lpbi: LPBITMAPINFOHEADER, lpBits: LPVOID): DWORD {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc ICDrawBegin*(hic: HIC, dwFlags: DWORD, hpal: HPALETTE, hwnd: HWND, hdc: HDC, xDst: int32, yDst: int32, dxDst: int32, dyDst: int32, lpbi: LPBITMAPINFOHEADER, xSrc: int32, ySrc: int32, dxSrc: int32, dySrc: int32, dwRate: DWORD, dwScale: DWORD): DWORD {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc ICDraw*(hic: HIC, dwFlags: DWORD, lpFormat: LPVOID, lpData: LPVOID, cbData: DWORD, lTime: LONG): DWORD {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc ICLocate*(fccType: DWORD, fccHandler: DWORD, lpbiIn: LPBITMAPINFOHEADER, lpbiOut: LPBITMAPINFOHEADER, wFlags: WORD): HIC {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICGetDisplayFormat*(hic: HIC, lpbiIn: LPBITMAPINFOHEADER, lpbiOut: LPBITMAPINFOHEADER, BitDepth: int32, dx: int32, dy: int32): HIC {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICImageCompress*(hic: HIC, uiFlags: UINT, lpbiIn: LPBITMAPINFO, lpBits: LPVOID, lpbiOut: LPBITMAPINFO, lQuality: LONG, plSize: ptr LONG): HANDLE {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICImageDecompress*(hic: HIC, uiFlags: UINT, lpbiIn: LPBITMAPINFO, lpBits: LPVOID, lpbiOut: LPBITMAPINFO): HANDLE {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICCompressorChoose*(hwnd: HWND, uiFlags: UINT, pvIn: LPVOID, lpData: LPVOID, pc: PCOMPVARS, lpszTitle: LPSTR): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICSeqCompressFrameStart*(pc: PCOMPVARS, lpbiIn: LPBITMAPINFO): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICSeqCompressFrameEnd*(pc: PCOMPVARS): void {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICSeqCompressFrame*(pc: PCOMPVARS, uiFlags: UINT, lpBits: LPVOID, pfKey: ptr WINBOOL, plSize: ptr LONG): LPVOID {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc ICCompressorFree*(pc: PCOMPVARS): void {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibOpen*(): HDRAWDIB {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibClose*(hdd: HDRAWDIB): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibGetBuffer*(hdd: HDRAWDIB, lpbi: LPBITMAPINFOHEADER, dwSize: DWORD, dwFlags: DWORD): LPVOID {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibGetPalette*(hdd: HDRAWDIB): HPALETTE {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibSetPalette*(hdd: HDRAWDIB, hpal: HPALETTE): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibChangePalette*(hdd: HDRAWDIB, iStart: int32, iLen: int32, lppe: LPPALETTEENTRY): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibRealize*(hdd: HDRAWDIB, hdc: HDC, fBackground: WINBOOL): UINT {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibStart*(hdd: HDRAWDIB, rate: DWORD): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibStop*(hdd: HDRAWDIB): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibBegin*(hdd: HDRAWDIB, hdc: HDC, dxDst: int32, dyDst: int32, lpbi: LPBITMAPINFOHEADER, dxSrc: int32, dySrc: int32, wFlags: UINT): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibDraw*(hdd: HDRAWDIB, hdc: HDC, xDst: int32, yDst: int32, dxDst: int32, dyDst: int32, lpbi: LPBITMAPINFOHEADER, lpBits: LPVOID, xSrc: int32, ySrc: int32, dxSrc: int32, dySrc: int32, wFlags: UINT): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibEnd*(hdd: HDRAWDIB): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibTime*(hdd: HDRAWDIB, lpddtime: LPDRAWDIBTIME): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc DrawDibProfileDisplay*(lpbi: LPBITMAPINFOHEADER): LRESULT {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc StretchDIB*(biDst: LPBITMAPINFOHEADER, lpDst: LPVOID, DstX: int32, DstY: int32, DstXE: int32, DstYE: int32, biSrc: LPBITMAPINFOHEADER, lpSrc: LPVOID, SrcX: int32, SrcY: int32, SrcXE: int32, SrcYE: int32): void {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc AVIFileInit*(): void {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileExit*(): void {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileAddRef*(pfile: PAVIFILE): ULONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileRelease*(pfile: PAVIFILE): ULONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileOpenA*(ppfile: ptr PAVIFILE, szFile: LPCSTR, uMode: UINT, lpHandler: LPCLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileOpenW*(ppfile: ptr PAVIFILE, szFile: LPCWSTR, uMode: UINT, lpHandler: LPCLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileInfoW*(pfile: PAVIFILE, pfi: LPAVIFILEINFOW, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileInfoA*(pfile: PAVIFILE, pfi: LPAVIFILEINFOA, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileGetStream*(pfile: PAVIFILE, ppavi: ptr PAVISTREAM, fccType: DWORD, lParam: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileCreateStreamW*(pfile: PAVIFILE, ppavi: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOW): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileCreateStreamA*(pfile: PAVIFILE, ppavi: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOA): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileWriteData*(pfile: PAVIFILE, ckid: DWORD, lpData: LPVOID, cbData: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileReadData*(pfile: PAVIFILE, ckid: DWORD, lpData: LPVOID, lpcbData: ptr LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIFileEndRecord*(pfile: PAVIFILE): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamAddRef*(pavi: PAVISTREAM): ULONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamRelease*(pavi: PAVISTREAM): ULONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamInfoW*(pavi: PAVISTREAM, psi: LPAVISTREAMINFOW, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamInfoA*(pavi: PAVISTREAM, psi: LPAVISTREAMINFOA, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamFindSample*(pavi: PAVISTREAM, lPos: LONG, lFlags: LONG): LONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamReadFormat*(pavi: PAVISTREAM, lPos: LONG, lpFormat: LPVOID, lpcbFormat: ptr LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamSetFormat*(pavi: PAVISTREAM, lPos: LONG, lpFormat: LPVOID, cbFormat: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamReadData*(pavi: PAVISTREAM, fcc: DWORD, lp: LPVOID, lpcb: ptr LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamWriteData*(pavi: PAVISTREAM, fcc: DWORD, lp: LPVOID, cb: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamRead*(pavi: PAVISTREAM, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, plBytes: ptr LONG, plSamples: ptr LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamWrite*(pavi: PAVISTREAM, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, dwFlags: DWORD, plSampWritten: ptr LONG, plBytesWritten: ptr LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamStart*(pavi: PAVISTREAM): LONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamLength*(pavi: PAVISTREAM): LONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamTimeToSample*(pavi: PAVISTREAM, lTime: LONG): LONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamSampleToTime*(pavi: PAVISTREAM, lSample: LONG): LONG {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamBeginStreaming*(pavi: PAVISTREAM, lStart: LONG, lEnd: LONG, lRate: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamEndStreaming*(pavi: PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamGetFrameOpen*(pavi: PAVISTREAM, lpbiWanted: LPBITMAPINFOHEADER): PGETFRAME {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamGetFrame*(pg: PGETFRAME, lPos: LONG): LPVOID {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamGetFrameClose*(pg: PGETFRAME): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamOpenFromFileA*(ppavi: ptr PAVISTREAM, szFile: LPCSTR, fccType: DWORD, lParam: LONG, mode: UINT, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamOpenFromFileW*(ppavi: ptr PAVISTREAM, szFile: LPCWSTR, fccType: DWORD, lParam: LONG, mode: UINT, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamCreate*(ppavi: ptr PAVISTREAM, lParam1: LONG, lParam2: LONG, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIStreamFindKeyFrame*(pavi: PAVISTREAM, lPos: LONG, lFlags: LONG): LONG {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamFindSample".}
proc AVIStreamClose*(pavi: PAVISTREAM): ULONG {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamRelease".}
proc AVIFileClose*(pfile: PAVIFILE): ULONG {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileRelease".}
proc AVIStreamInit*(): void {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileInit".}
proc AVIStreamExit*(): void {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileExit".}
proc AVIMakeCompressedStream*(ppsCompressed: ptr PAVISTREAM, ppsSource: PAVISTREAM, lpOptions: ptr AVICOMPRESSOPTIONS, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVISaveVA*(szFile: LPCSTR, pclsidHandler: ptr CLSID, lpfnCallback: AVISAVECALLBACK, nStreams: int32, ppavi: ptr PAVISTREAM, plpOptions: ptr LPAVICOMPRESSOPTIONS): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVISaveVW*(szFile: LPCWSTR, pclsidHandler: ptr CLSID, lpfnCallback: AVISAVECALLBACK, nStreams: int32, ppavi: ptr PAVISTREAM, plpOptions: ptr LPAVICOMPRESSOPTIONS): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVISaveOptions*(hwnd: HWND, uiFlags: UINT, nStreams: int32, ppavi: ptr PAVISTREAM, plpOptions: ptr LPAVICOMPRESSOPTIONS): INT_PTR {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVISaveOptionsFree*(nStreams: int32, plpOptions: ptr LPAVICOMPRESSOPTIONS): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIBuildFilterW*(lpszFilter: LPWSTR, cbFilter: LONG, fSaving: WINBOOL): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIBuildFilterA*(lpszFilter: LPSTR, cbFilter: LONG, fSaving: WINBOOL): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIMakeFileFromStreams*(ppfile: ptr PAVIFILE, nStreams: int32, papStreams: ptr PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIMakeStreamFromClipboard*(cfFormat: UINT, hGlobal: HANDLE, ppstream: ptr PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIPutFileOnClipboard*(pf: PAVIFILE): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIGetFromClipboard*(lppf: ptr PAVIFILE): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc AVIClearClipboard*(): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc CreateEditableStream*(ppsEditable: ptr PAVISTREAM, psSource: PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamCut*(pavi: PAVISTREAM, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamCopy*(pavi: PAVISTREAM, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamPaste*(pavi: PAVISTREAM, plPos: ptr LONG, plLength: ptr LONG, pstream: PAVISTREAM, lStart: LONG, lEnd: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamClone*(pavi: PAVISTREAM, ppResult: ptr PAVISTREAM): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamSetNameA*(pavi: PAVISTREAM, lpszName: LPCSTR): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamSetNameW*(pavi: PAVISTREAM, lpszName: LPCWSTR): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamSetInfoW*(pavi: PAVISTREAM, lpInfo: LPAVISTREAMINFOW, cbInfo: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc EditStreamSetInfoA*(pavi: PAVISTREAM, lpInfo: LPAVISTREAMINFOA, cbInfo: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc.}
proc MCIWndCreateA*(hwndParent: HWND, hInstance: HINSTANCE, dwStyle: DWORD, szFile: LPCSTR): HWND {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc MCIWndCreateW*(hwndParent: HWND, hInstance: HINSTANCE, dwStyle: DWORD, szFile: LPCWSTR): HWND {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc MCIWndRegisterClass*(): WINBOOL {.winapi, cdecl, dynlib: "msvfw32", importc.}
proc capCreateCaptureWindowA*(lpszWindowName: LPCSTR, dwStyle: DWORD, x: int32, y: int32, nWidth: int32, nHeight: int32, hwndParent: HWND, nID: int32): HWND {.winapi, stdcall, dynlib: "avicap32", importc.}
proc capGetDriverDescriptionA*(wDriverIndex: UINT, lpszName: LPSTR, cbName: int32, lpszVer: LPSTR, cbVer: int32): WINBOOL {.winapi, stdcall, dynlib: "avicap32", importc.}
proc capCreateCaptureWindowW*(lpszWindowName: LPCWSTR, dwStyle: DWORD, x: int32, y: int32, nWidth: int32, nHeight: int32, hwndParent: HWND, nID: int32): HWND {.winapi, stdcall, dynlib: "avicap32", importc.}
proc capGetDriverDescriptionW*(wDriverIndex: UINT, lpszName: LPWSTR, cbName: int32, lpszVer: LPWSTR, cbVer: int32): WINBOOL {.winapi, stdcall, dynlib: "avicap32", importc.}
proc acmGetVersion*(): DWORD {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmMetrics*(hao: HACMOBJ, uMetric: UINT, pMetric: LPVOID): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverEnum*(fnCallback: ACMDRIVERENUMCB, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverID*(hao: HACMOBJ, phadid: LPHACMDRIVERID, fdwDriverID: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverAddA*(phadid: LPHACMDRIVERID, hinstModule: HINSTANCE, lParam: LPARAM, dwPriority: DWORD, fdwAdd: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverAddW*(phadid: LPHACMDRIVERID, hinstModule: HINSTANCE, lParam: LPARAM, dwPriority: DWORD, fdwAdd: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverRemove*(hadid: HACMDRIVERID, fdwRemove: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverOpen*(phad: LPHACMDRIVER, hadid: HACMDRIVERID, fdwOpen: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverClose*(had: HACMDRIVER, fdwClose: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverMessage*(had: HACMDRIVER, uMsg: UINT, lParam1: LPARAM, lParam2: LPARAM): LRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverPriority*(hadid: HACMDRIVERID, dwPriority: DWORD, fdwPriority: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverDetailsA*(hadid: HACMDRIVERID, padd: LPACMDRIVERDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmDriverDetailsW*(hadid: HACMDRIVERID, padd: LPACMDRIVERDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatTagDetailsA*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatTagDetailsW*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatTagEnumA*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSA, fnCallback: ACMFORMATTAGENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatTagEnumW*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSW, fnCallback: ACMFORMATTAGENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatDetailsA*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatDetailsW*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatEnumA*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSA, fnCallback: ACMFORMATENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatEnumW*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSW, fnCallback: ACMFORMATENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatSuggest*(had: HACMDRIVER, pwfxSrc: LPWAVEFORMATEX, pwfxDst: LPWAVEFORMATEX, cbwfxDst: DWORD, fdwSuggest: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatChooseA*(pafmtc: LPACMFORMATCHOOSEA): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFormatChooseW*(pafmtc: LPACMFORMATCHOOSEW): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterTagDetailsA*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterTagDetailsW*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterTagEnumA*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSA, fnCallback: ACMFILTERTAGENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterTagEnumW*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSW, fnCallback: ACMFILTERTAGENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterDetailsA*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterDetailsW*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterEnumA*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSA, fnCallback: ACMFILTERENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterEnumW*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSW, fnCallback: ACMFILTERENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterChooseA*(pafltrc: LPACMFILTERCHOOSEA): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmFilterChooseW*(pafltrc: LPACMFILTERCHOOSEW): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamOpen*(phas: LPHACMSTREAM, had: HACMDRIVER, pwfxSrc: LPWAVEFORMATEX, pwfxDst: LPWAVEFORMATEX, pwfltr: LPWAVEFILTER, dwCallback: DWORD_PTR, dwInstance: DWORD_PTR, fdwOpen: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamClose*(has: HACMSTREAM, fdwClose: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamSize*(has: HACMSTREAM, cbInput: DWORD, pdwOutputBytes: LPDWORD, fdwSize: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamReset*(has: HACMSTREAM, fdwReset: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamMessage*(has: HACMSTREAM, uMsg: UINT, lParam1: LPARAM, lParam2: LPARAM): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamConvert*(has: HACMSTREAM, pash: LPACMSTREAMHEADER, fdwConvert: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamPrepareHeader*(has: HACMSTREAM, pash: LPACMSTREAMHEADER, fdwPrepare: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc acmStreamUnprepareHeader*(has: HACMSTREAM, pash: LPACMSTREAMHEADER, fdwUnprepare: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc.}
proc GetOpenFileNamePreviewA*(lpofn: LPOPENFILENAMEA): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc GetSaveFileNamePreviewA*(lpofn: LPOPENFILENAMEA): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc GetOpenFileNamePreviewW*(lpofn: LPOPENFILENAMEW): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
proc GetSaveFileNamePreviewW*(lpofn: LPOPENFILENAMEW): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc.}
template MCIWndCanPlay*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_PLAY, 0, 0)
template MCIWndCanRecord*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_RECORD, 0, 0)
template MCIWndCanSave*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_SAVE, 0, 0)
template MCIWndCanWindow*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_WINDOW, 0, 0)
template MCIWndCanEject*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_EJECT, 0, 0)
template MCIWndCanConfig*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_CAN_CONFIG, 0, 0)
template MCIWndPaletteKick*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_PALETTEKICK, 0, 0)
template MCIWndSave*(hwnd: HWND, szFile: PCWSTR): LONG = discardable LONG SendMessage(hwnd, MCI_SAVE, 0, cast[LPARAM](szFile))
template MCIWndSaveDialog*(hwnd: HWND): LONG = discardable MCIWndSave(hwnd, cast[PCWSTR](-1))
when winimUnicode:
  const
    MCIWNDM_NEW* = MCIWNDM_NEWW
when winimAnsi:
  const
    MCIWNDM_NEW* = MCIWNDM_NEWA
template MCIWndNew*(hwnd: HWND, lp: LPVOID): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_NEW, 0, cast[LPARAM](lp))
template MCIWndRecord*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_RECORD, 0, 0)
when winimUnicode:
  const
    MCIWNDM_OPEN* = MCIWNDM_OPENW
when winimAnsi:
  const
    MCIWNDM_OPEN* = MCIWNDM_OPENA
template MCIWndOpen*(hwnd: HWND, sz: LPVOID, f: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_OPEN, cast[WPARAM](f), cast[LPARAM](sz))
template MCIWndOpenDialog*(hwnd: HWND): LONG = discardable MCIWndOpen(hwnd, cast[LPVOID](-1), 0)
template MCIWndClose*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_CLOSE, 0, 0)
template MCIWndPlay*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_PLAY, 0, 0)
template MCIWndStop*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_STOP, 0, 0)
template MCIWndPause*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_PAUSE, 0, 0)
template MCIWndResume*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCI_RESUME, 0, 0)
template MCIWndSeek*(hwnd: HWND, lPos: LONG): LONG = discardable LONG SendMessage(hwnd, MCI_SEEK, 0, cast[LPARAM](lPos))
template MCIWndEject*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_EJECT, 0, 0)
template MCIWndHome*(hwnd: HWND): LONG = discardable MCIWndSeek(hwnd, MCIWND_START)
template MCIWndToEnd*(hwnd: HWND): LONG = discardable MCIWndSeek(hwnd, MCIWND_END)
template MCIWndGetSource*(hwnd: HWND, prc: LPRECT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GET_SOURCE, 0, cast[LPARAM](prc))
template MCIWndPutSource*(hwnd: HWND, prc: LPRECT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_PUT_SOURCE, 0, cast[LPARAM](prc))
template MCIWndGetDest*(hwnd: HWND, prc: LPRECT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GET_DEST, 0, cast[LPARAM](prc))
template MCIWndPutDest*(hwnd: HWND, prc: LPRECT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_PUT_DEST, 0, cast[LPARAM](prc))
template MCIWndPlayReverse*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_PLAYREVERSE, 0, 0)
template MCIWndPlayFrom*(hwnd: HWND, lPos: LONG): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_PLAYFROM, 0, cast[LPARAM](lPos))
template MCIWndPlayTo*(hwnd: HWND, lPos: LONG): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_PLAYTO, 0, cast[LPARAM](lPos))
template MCIWndPlayFromTo*(hwnd: HWND, lStart: LONG, lEnd: LONG): LONG = MCIWndSeek(hwnd, lStart); discardable MCIWndPlayTo(hwnd, lEnd)
template MCIWndGetDeviceID*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETDEVICEID, 0, 0)
template MCIWndGetAlias*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETALIAS, 0, 0)
when winimUnicode:
  const
    MCIWNDM_GETMODE* = MCIWNDM_GETMODEW
when winimAnsi:
  const
    MCIWNDM_GETMODE* = MCIWNDM_GETMODEA
template MCIWndGetMode*(hwnd: HWND, lp: LPTSTR, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETMODE, cast[WPARAM](L), cast[LPARAM](lp))
when winimUnicode:
  const
    MCIWNDM_GETPOSITION* = MCIWNDM_GETPOSITIONW
when winimAnsi:
  const
    MCIWNDM_GETPOSITION* = MCIWNDM_GETPOSITIONA
template MCIWndGetPosition*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETPOSITION, 0, 0)
template MCIWndGetPositionString*(hwnd: HWND, lp: LPTSTR, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETPOSITION, cast[WPARAM](L), cast[LPARAM](lp))
template MCIWndGetStart*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETSTART, 0, 0)
template MCIWndGetLength*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETLENGTH, 0, 0)
template MCIWndGetEnd*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETEND, 0, 0)
template MCIWndStep*(hwnd: HWND, n: LONG): LONG = discardable LONG SendMessage(hwnd, MCI_STEP, 0, cast[LPARAM](n))
template MCIWndDestroy*(hwnd: HWND): void = SendMessage(hwnd, WM_CLOSE, 0, 0)
template MCIWndSetZoom*(hwnd: HWND, iZoom: UINT): void = SendMessage(hwnd, MCIWNDM_SETZOOM, 0, cast[LPARAM](iZoom))
template MCIWndGetZoom*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETZOOM, 0, 0)
template MCIWndSetVolume*(hwnd: HWND, iVol: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SETVOLUME, 0, cast[LPARAM](iVol))
template MCIWndGetVolume*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETVOLUME, 0, 0)
template MCIWndSetSpeed*(hwnd: HWND, iSpeed: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SETSPEED, 0, cast[LPARAM](iSpeed))
template MCIWndGetSpeed*(hwnd: HWND): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETSPEED, 0, 0)
when winimUnicode:
  const
    MCIWNDM_SETTIMEFORMAT* = MCIWNDM_SETTIMEFORMATW
when winimAnsi:
  const
    MCIWNDM_SETTIMEFORMAT* = MCIWNDM_SETTIMEFORMATA
template MCIWndSetTimeFormat*(hwnd: HWND, lp: LPTSTR): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SETTIMEFORMAT, 0, cast[LPARAM](lp))
when winimUnicode:
  const
    MCIWNDM_GETTIMEFORMAT* = MCIWNDM_GETTIMEFORMATW
when winimAnsi:
  const
    MCIWNDM_GETTIMEFORMAT* = MCIWNDM_GETTIMEFORMATA
template MCIWndGetTimeFormat*(hwnd: HWND, lp: LPTSTR, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETTIMEFORMAT, cast[WPARAM](L), cast[LPARAM](lp))
template MCIWndValidateMedia*(hwnd: HWND): void = SendMessage(hwnd, MCIWNDM_VALIDATEMEDIA, 0, 0)
template MCIWndSetRepeat*(hwnd: HWND, f: BOOL): void = SendMessage(hwnd, MCIWNDM_SETREPEAT, 0, cast[LPARAM](f))
template MCIWndGetRepeat*(hwnd: HWND): BOOL = discardable BOOL SendMessage(hwnd, MCIWNDM_GETREPEAT, 0, 0)
template MCIWndSetActiveTimer*(hwnd: HWND, active: UINT): void = SendMessage(hwnd, MCIWNDM_SETACTIVETIMER, cast[WPARAM](active), 0)
template MCIWndSetInactiveTimer*(hwnd: HWND, inactive: UINT): void = SendMessage(hwnd, MCIWNDM_SETINACTIVETIMER, cast[WPARAM](inactive), 0)
template MCIWndSetTimers*(hwnd: HWND, active: UINT, inactive: UINT): void = SendMessage(hwnd, MCIWNDM_SETTIMERS, cast[WPARAM](active), cast[LPARAM](inactive))
template MCIWndGetActiveTimer*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETACTIVETIMER, 0, 0)
template MCIWndGetInactiveTimer*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETINACTIVETIMER, 0, 0)
template MCIWndRealize*(hwnd: HWND, fBkgnd: BOOL): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_REALIZE, cast[WPARAM](fBkgnd), 0)
when winimUnicode:
  const
    MCIWNDM_SENDSTRING* = MCIWNDM_SENDSTRINGW
when winimAnsi:
  const
    MCIWNDM_SENDSTRING* = MCIWNDM_SENDSTRINGA
template MCIWndSendString*(hwnd: HWND, sz: LPTSTR): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SENDSTRING, 0, cast[LPARAM](sz))
when winimUnicode:
  const
    MCIWNDM_RETURNSTRING* = MCIWNDM_RETURNSTRINGW
when winimAnsi:
  const
    MCIWNDM_RETURNSTRING* = MCIWNDM_RETURNSTRINGA
template MCIWndReturnString*(hwnd: HWND, lp: LPVOID, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_RETURNSTRING, cast[WPARAM](L), cast[LPARAM](lp))
when winimUnicode:
  const
    MCIWNDM_GETERROR* = MCIWNDM_GETERRORW
when winimAnsi:
  const
    MCIWNDM_GETERROR* = MCIWNDM_GETERRORA
template MCIWndGetError*(hwnd: HWND, lp: LPVOID, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETERROR, cast[WPARAM](L), cast[LPARAM](lp))
template MCIWndGetPalette*(hwnd: HWND): HPALETTE = discardable HPALETTE SendMessage(hwnd, MCIWNDM_GETPALETTE, 0, 0)
template MCIWndSetPalette*(hwnd: HWND, hpal: HPALETTE): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SETPALETTE, cast[WPARAM](hpal), 0)
when winimUnicode:
  const
    MCIWNDM_GETFILENAME* = MCIWNDM_GETFILENAMEW
when winimAnsi:
  const
    MCIWNDM_GETFILENAME* = MCIWNDM_GETFILENAMEA
template MCIWndGetFileName*(hwnd: HWND, lp: LPVOID, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETFILENAME, cast[WPARAM](L), cast[LPARAM](lp))
when winimUnicode:
  const
    MCIWNDM_GETDEVICE* = MCIWNDM_GETDEVICEW
when winimAnsi:
  const
    MCIWNDM_GETDEVICE* = MCIWNDM_GETDEVICEA
template MCIWndGetDevice*(hwnd: HWND, lp: LPVOID, L: UINT): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_GETDEVICE, cast[WPARAM](L), cast[LPARAM](lp))
template MCIWndGetStyles*(hwnd: HWND): UINT = discardable UINT SendMessage(hwnd, MCIWNDM_GETSTYLES, 0, 0)
template MCIWndChangeStyles*(hwnd: HWND, mask: UINT, value: LONG): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_CHANGESTYLES, cast[WPARAM](mask), cast[LPARAM](value))
template MCIWndOpenInterface*(hwnd: HWND, pUnk): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_OPENINTERFACE, 0, cast[LPARAM](pUnk))
template MCIWndSetOwner*(hwnd: HWND, hwndP): LONG = discardable LONG SendMessage(hwnd, MCIWNDM_SETOWNER, cast[WPARAM](hwndP), 0)
template ICQueryAbout*(hic: HIC): bool = discardable ICSendMessage(hic, ICM_ABOUT, cast[DWORD_PTR](-1), ICMF_ABOUT_QUERY) == ICERR_OK
template ICAbout*(hic: HIC, hwnd: HWND): LRESULT = discardable ICSendMessage(hic, ICM_ABOUT, cast[DWORD_PTR](hwnd), 0)
template ICQueryConfigure*(hic: HIC): bool = discardable ICSendMessage(hic, ICM_CONFIGURE, cast[DWORD_PTR](-1), ICMF_CONFIGURE_QUERY) == ICERR_OK
template ICConfigure*(hic: HIC, hwnd: HWND): LRESULT = discardable ICSendMessage(hic, ICM_CONFIGURE, cast[DWORD_PTR](hwnd), 0)
template ICGetState*(hic: HIC, pv: LPVOID, cb: DWORD_PTR): LRESULT = discardable ICSendMessage(hic, ICM_GETSTATE, cast[DWORD_PTR](pv), cb)
template ICSetState*(hic: HIC, pv: LPVOID, cb: DWORD_PTR): LRESULT = discardable ICSendMessage(hic, ICM_SETSTATE, cast[DWORD_PTR](pv), cb)
template ICGetStateSize*(hic: HIC): DWORD = discardable DWORD ICGetState(hic, 0, 0)
template ICDrawWindow*(hic: HIC, prc: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_WINDOW, cast[DWORD_PTR](prc), cast[DWORD_PTR](sizeof(RECT)))
template ICCompressBegin*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_COMPRESS_BEGIN, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICCompressQuery*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_COMPRESS_QUERY, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICCompressGetFormat*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_COMPRESS_GET_FORMAT, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICCompressGetFormatSize*(hic: HIC, lpbi: LPVOID): DWORD = discardable DWORD ICCompressGetFormat(hic, lpbi, nil)
template ICCompressGetSize*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): DWORD = discardable DWORD ICSendMessage(hic, ICM_COMPRESS_GET_SIZE, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICCompressEnd*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_COMPRESS_END, 0, 0)
template ICDecompressBegin*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESS_BEGIN, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICDecompressQuery*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESS_QUERY, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICDecompressGetFormat*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LONG = discardable LONG ICSendMessage(hic, ICM_DECOMPRESS_GET_FORMAT, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICDecompressGetFormatSize*(hic: HIC, lpbi: LPVOID): LRESULT = discardable ICDecompressGetFormat(hic, lpbi, nil)
template ICDecompressGetPalette*(hic: HIC, lpbiInput: LPVOID, lpbiOutput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESS_GET_PALETTE, cast[DWORD_PTR](lpbiInput), cast[DWORD_PTR](lpbiOutput))
template ICDecompressSetPalette*(hic: HIC, lpbiPalette: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESS_SET_PALETTE, cast[DWORD_PTR](lpbiPalette), 0)
template ICDecompressEnd*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESS_END, 0, 0)
template ICDecompressExEnd*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DECOMPRESSEX_END, 0, 0)
template ICDrawQuery2*(hic: HIC, lpbiInput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_QUERY, cast[DWORD_PTR](lpbiInput), 0)
template ICDrawChangePalette*(hic: HIC, lpbiInput: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_CHANGEPALETTE, cast[DWORD_PTR](lpbiInput), 0)
template ICGetBuffersWanted*(hic: HIC, lpdwBuffers: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_GETBUFFERSWANTED, cast[DWORD_PTR](lpdwBuffers), 0)
template ICDrawEnd*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_END, 0, 0)
template ICDrawStart*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_START, 0, 0)
template ICDrawStartPlay*(hic: HIC, lFrom: LONG, lTo: LONG): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_START_PLAY, cast[DWORD_PTR](lFrom), cast[DWORD_PTR](lTo))
template ICDrawStop*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_STOP, 0, 0)
template ICDrawStopPlay*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_STOP_PLAY, 0, 0)
template ICDrawGetTime*(hic: HIC, lplTime: LPVOID): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_GETTIME, cast[DWORD_PTR](lplTime), 0)
template ICDrawSetTime*(hic: HIC, lTime: LONG): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_SETTIME, cast[DWORD_PTR](lTime), 0)
template ICDrawRealize*(hic: HIC, hdc: HDC, fBackground: BOOL): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_REALIZE, cast[DWORD_PTR](hdc), cast[DWORD_PTR](fBackground))
template ICDrawFlush*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_FLUSH, 0, 0)
template ICDrawRenderBuffer*(hic: HIC): LRESULT = discardable ICSendMessage(hic, ICM_DRAW_RENDERBUFFER, 0, 0)
template ICDecompressOpen*(fccType: DWORD, fccHandler: DWORD, lpbiIn: LPVOID, lpbiOut: LPVOID): HIC = discardable ICLocate(fccType, fccHandler, lpbiIn, lpbiOut, ICMODE_DECOMPRESS)
template ICDrawOpen*(fccType: DWORD, fccHandler: DWORD, lpbiIn: LPVOID): HIC = discardable ICLocate(fccType, fccHandler, lpbiIn, nil, ICMODE_DRAW)
template DrawDibUpdate*(hdd: HDRAWDIB, hdc: HDC, x: int32, y: int32): WINBOOL = discardable DrawDibDraw(hdd, hdc, x, y, 0, 0, nil, nil, 0, 0, 0, 0, DDF_UPDATE)
template AVIStreamSampleToSample*(pavi1: PAVISTREAM, pavi2: PAVISTREAM, l: LONG): LONG = discardable AVIStreamTimeToSample(pavi1, AVIStreamSampleToTime(pavi2, l))
template AVIStreamNextSample*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l+1, FIND_NEXT or FIND_ANY)
template AVIStreamPrevSample*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l-1, FIND_PREV or FIND_ANY)
template AVIStreamNearestSample*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l, FIND_PREV or FIND_ANY)
template AVIStreamNextKeyFrame*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l+1, FIND_NEXT or FIND_KEY)
template AVIStreamPrevKeyFrame*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l-1, FIND_PREV or FIND_KEY)
template AVIStreamNearestKeyFrame*(pavi: PAVISTREAM, l: LONG): LONG = discardable AVIStreamFindSample(pavi, l, FIND_PREV or FIND_KEY)
template AVIStreamIsKeyFrame*(pavi: PAVISTREAM, l: LONG): bool = AVIStreamNearestKeyFrame(pavi, l) == l
template AVIStreamPrevSampleTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamPrevSample(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamNextSampleTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamNextSample(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamNearestSampleTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamNearestSample(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamNextKeyFrameTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamNextKeyFrame(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamPrevKeyFrameTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamPrevKeyFrame(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamNearestKeyFrameTime*(pavi: PAVISTREAM, t: LONG): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamNearestKeyFrame(pavi, AVIStreamTimeToSample(pavi, t)))
template AVIStreamStartTime*(pavi: PAVISTREAM): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamStart(pavi))
template AVIStreamLengthTime*(pavi: PAVISTREAM): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamLength(pavi))
template AVIStreamEnd*(pavi: PAVISTREAM): LONG = discardable(AVIStreamStart(pavi) + AVIStreamLength(pavi))
template AVIStreamEndTime*(pavi: PAVISTREAM): LONG = discardable AVIStreamSampleToTime(pavi, AVIStreamEnd(pavi))
template AVIStreamSampleSize*(pavi: PAVISTREAM, lPos: LONG, plSize: ptr LONG): HRESULT = discardable AVIStreamRead(pavi, lPos, 1, nil, 0, plSize, nil)
template AVIStreamFormatSize*(pavi: PAVISTREAM, lPos: LONG, plSize: ptr LONG): HRESULT = discardable AVIStreamReadFormat(pavi, lPos, nil, plSize)
template AVIStreamDataSize*(pavi: PAVISTREAM, fcc: DWORD, plSize: ptr LONG): HRESULT = discardable AVIStreamReadData(pavi, fcc, nil, plSize)
template AVStreamNextKeyFrame*(pavi: PAVISTREAM, pos: LONG): LONG = discardable AVIStreamFindSample(pavi, pos+1, FIND_NEXT or FIND_KEY)
template AVStreamPrevKeyFrame*(pavi: PAVISTREAM, pos: LONG): LONG = discardable AVIStreamFindSample(pavi, pos-1, FIND_NEXT or FIND_KEY)
template AVICapSM*(hwnd: HWND, msg: UINT, wparam: untyped, lparam: untyped): LRESULT = (if IsWindow(hwnd) != FALSE: SendMessage(hwnd, msg, cast[WPARAM](wparam), cast[LPARAM](lparam)) else: 0)
when winimUnicode:
  const
    WM_CAP_SET_CALLBACK_ERROR* = WM_CAP_SET_CALLBACK_ERRORW
when winimAnsi:
  const
    WM_CAP_SET_CALLBACK_ERROR* = WM_CAP_SET_CALLBACK_ERRORA
template capSetCallbackOnError*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_ERROR, 0, fpProc)
when winimUnicode:
  const
    WM_CAP_SET_CALLBACK_STATUS* = WM_CAP_SET_CALLBACK_STATUSW
when winimAnsi:
  const
    WM_CAP_SET_CALLBACK_STATUS* = WM_CAP_SET_CALLBACK_STATUSA
template capSetCallbackOnStatus*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_STATUS, 0, fpProc)
template capSetCallbackOnYield*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_YIELD, 0, fpProc)
template capSetCallbackOnFrame*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_FRAME, 0, fpProc)
template capSetCallbackOnVideoStream*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_VIDEOSTREAM, 0, fpProc)
template capSetCallbackOnWaveStream*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_WAVESTREAM, 0, fpProc)
template capSetCallbackOnCapControl*(hwnd: HWND, fpProc: LPVOID): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_CALLBACK_CAPCONTROL, 0, fpProc)
template capSetUserData*(hwnd: HWND, lUser: LPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_USER_DATA, 0, lUser)
template capGetUserData*(hwnd: HWND): LPARAM = discardable LPARAM AVICapSM(hwnd, WM_CAP_GET_USER_DATA, 0, 0)
template capDriverConnect*(hwnd: HWND, i: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DRIVER_CONNECT, i, 0)
template capDriverDisconnect*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DRIVER_DISCONNECT, 0, 0)
when winimUnicode:
  const
    WM_CAP_DRIVER_GET_NAME* = WM_CAP_DRIVER_GET_NAMEW
when winimAnsi:
  const
    WM_CAP_DRIVER_GET_NAME* = WM_CAP_DRIVER_GET_NAMEA
template capDriverGetName*(hwnd: HWND, szName: LPTSTR, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DRIVER_GET_NAME, wSize, szName)
when winimUnicode:
  const
    WM_CAP_DRIVER_GET_VERSION* = WM_CAP_DRIVER_GET_VERSIONW
when winimAnsi:
  const
    WM_CAP_DRIVER_GET_VERSION* = WM_CAP_DRIVER_GET_VERSIONA
template capDriverGetVersion*(hwnd: HWND, szVer: LPTSTR, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DRIVER_GET_VERSION, wSize, szVer)
template capDriverGetCaps*(hwnd: HWND, s: LPCAPDRIVERCAPS, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DRIVER_GET_CAPS, wSize, s)
when winimUnicode:
  const
    WM_CAP_FILE_SET_CAPTURE_FILE* = WM_CAP_FILE_SET_CAPTURE_FILEW
when winimAnsi:
  const
    WM_CAP_FILE_SET_CAPTURE_FILE* = WM_CAP_FILE_SET_CAPTURE_FILEA
template capFileSetCaptureFile*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_SET_CAPTURE_FILE, 0, szName)
when winimUnicode:
  const
    WM_CAP_FILE_GET_CAPTURE_FILE* = WM_CAP_FILE_GET_CAPTURE_FILEW
when winimAnsi:
  const
    WM_CAP_FILE_GET_CAPTURE_FILE* = WM_CAP_FILE_GET_CAPTURE_FILEA
template capFileGetCaptureFile*(hwnd: HWND, szName: LPTSTR, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_GET_CAPTURE_FILE, wSize, szName)
template capFileAlloc*(hwnd: HWND, dwSize: DWORD): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_ALLOCATE, 0, dwSize)
when winimUnicode:
  const
    WM_CAP_FILE_SAVEAS* = WM_CAP_FILE_SAVEASW
when winimAnsi:
  const
    WM_CAP_FILE_SAVEAS* = WM_CAP_FILE_SAVEASA
template capFileSaveAs*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_SAVEAS, 0, szName)
template capFileSetInfoChunk*(hwnd: HWND, lpInfoChunk: LPCAPINFOCHUNK): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_SET_INFOCHUNK, 0, lpInfoChunk)
when winimUnicode:
  const
    WM_CAP_FILE_SAVEDIB* = WM_CAP_FILE_SAVEDIBW
when winimAnsi:
  const
    WM_CAP_FILE_SAVEDIB* = WM_CAP_FILE_SAVEDIBA
template capFileSaveDIB*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_FILE_SAVEDIB, 0, szName)
template capEditCopy*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_EDIT_COPY, 0, 0)
template capSetAudioFormat*(hwnd: HWND, s: LPWAVEFORMATEX, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_AUDIOFORMAT, wSize, s)
template capGetAudioFormat*(hwnd: HWND, s: LPWAVEFORMATEX, wSize: WPARAM): DWORD = discardable DWORD AVICapSM(hwnd, WM_CAP_GET_AUDIOFORMAT, wSize, s)
template capGetAudioFormatSize*(hwnd: HWND): DWORD = discardable DWORD AVICapSM(hwnd, WM_CAP_GET_AUDIOFORMAT, 0, 0)
template capDlgVideoFormat*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DLG_VIDEOFORMAT, 0, 0)
template capDlgVideoSource*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DLG_VIDEOSOURCE, 0, 0)
template capDlgVideoDisplay*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DLG_VIDEODISPLAY, 0, 0)
template capDlgVideoCompression*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_DLG_VIDEOCOMPRESSION, 0, 0)
template capGetVideoFormat*(hwnd: HWND, s: LPVOID, wSize: WPARAM): DWORD = discardable DWORD AVICapSM(hwnd, WM_CAP_GET_VIDEOFORMAT, wSize, s)
template capGetVideoFormatSize*(hwnd: HWND): DWORD = discardable DWORD AVICapSM(hwnd, WM_CAP_GET_VIDEOFORMAT, 0, 0)
template capSetVideoFormat*(hwnd: HWND, s: LPVOID, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_VIDEOFORMAT, wSize, s)
template capPreview*(hwnd: HWND, f: BOOL): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_PREVIEW, f, 0)
template capPreviewRate*(hwnd: HWND, wMS: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_PREVIEWRATE, wMS, 0)
template capOverlay*(hwnd: HWND, f: BOOL): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_OVERLAY, f, 0)
template capPreviewScale*(hwnd: HWND, f: BOOL): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_SCALE, f, 0)
template capGetStatus*(hwnd: HWND, s: LPCAPSTATUS, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_GET_STATUS, wSize, s)
template capSetScrollPos*(hwnd: HWND, lpP: LPPOINT): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_SCROLL, 0, lpP)
template capGrabFrame*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_GRAB_FRAME, 0, 0)
template capGrabFrameNoStop*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_GRAB_FRAME_NOSTOP, 0, 0)
template capCaptureSequence*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SEQUENCE, 0, 0)
template capCaptureSequenceNoFile*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SEQUENCE_NOFILE, 0, 0)
template capCaptureStop*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_STOP, 0, 0)
template capCaptureAbort*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_ABORT, 0, 0)
template capCaptureSingleFrameOpen*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SINGLE_FRAME_OPEN, 0, 0)
template capCaptureSingleFrameClose*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SINGLE_FRAME_CLOSE, 0, 0)
template capCaptureSingleFrame*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SINGLE_FRAME, 0, 0)
template capCaptureGetSetup*(hwnd: HWND, s: LPCAPTUREPARMS, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_GET_SEQUENCE_SETUP, wSize, s)
template capCaptureSetSetup*(hwnd: HWND, s: LPCAPTUREPARMS, wSize: WPARAM): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_SEQUENCE_SETUP, wSize, s)
when winimUnicode:
  const
    WM_CAP_SET_MCI_DEVICE* = WM_CAP_SET_MCI_DEVICEW
when winimAnsi:
  const
    WM_CAP_SET_MCI_DEVICE* = WM_CAP_SET_MCI_DEVICEA
template capSetMCIDeviceName*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_SET_MCI_DEVICE, 0, szName)
when winimUnicode:
  const
    WM_CAP_GET_MCI_DEVICE* = WM_CAP_GET_MCI_DEVICEW
when winimAnsi:
  const
    WM_CAP_GET_MCI_DEVICE* = WM_CAP_GET_MCI_DEVICEA
template capGetMCIDeviceName*(hwnd: HWND, szName: LPTSTR, wSize): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_GET_MCI_DEVICE, wSize, szName)
when winimUnicode:
  const
    WM_CAP_PAL_OPEN* = WM_CAP_PAL_OPENW
when winimAnsi:
  const
    WM_CAP_PAL_OPEN* = WM_CAP_PAL_OPENA
template capPaletteOpen*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_PAL_OPEN, 0, szName)
when winimUnicode:
  const
    WM_CAP_PAL_SAVE* = WM_CAP_PAL_SAVEW
when winimAnsi:
  const
    WM_CAP_PAL_SAVE* = WM_CAP_PAL_SAVEA
template capPaletteSave*(hwnd: HWND, szName: LPTSTR): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_PAL_SAVE, 0, szName)
template capPalettePaste*(hwnd: HWND): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_PAL_PASTE, 0, 0)
template capPaletteAuto*(hwnd: HWND, iFrames: WPARAM, iColors: DWORD): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_PAL_AUTOCREATE, iFrames, iColors)
template capPaletteManual*(hwnd: HWND, fGrab: WPARAM, iColors: DWORD): BOOL = discardable BOOL AVICapSM(hwnd, WM_CAP_PAL_MANUALCREATE, fGrab, iColors)
proc ICGetDefaultQuality*(hic: HIC): DWORD {.winapi, inline.} = discard ICSendMessage(hic, ICM_GETDEFAULTQUALITY, cast[DWORD_PTR](addr result), cast[DWORD_PTR](sizeof(DWORD))); result
proc ICGetDefaultKeyFrameRate*(hic: HIC): DWORD {.winapi, inline.} = discard ICSendMessage(hic, ICM_GETDEFAULTKEYFRAMERATE, cast[DWORD_PTR](addr result), cast[DWORD_PTR](sizeof(DWORD))); result
proc Create*(self: ptr IAVIStream, lParam1: LPARAM, lParam2: LPARAM): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Create(self, lParam1, lParam2)
proc Info*(self: ptr IAVIStream, psi: ptr TAVISTREAMINFOW, lSize: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Info(self, psi, lSize)
proc FindSample*(self: ptr IAVIStream, lPos: LONG, lFlags: LONG): LONG {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.FindSample(self, lPos, lFlags)
proc ReadFormat*(self: ptr IAVIStream, lPos: LONG, lpFormat: LPVOID, lpcbFormat: ptr LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.ReadFormat(self, lPos, lpFormat, lpcbFormat)
proc SetFormat*(self: ptr IAVIStream, lPos: LONG, lpFormat: LPVOID, cbFormat: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.SetFormat(self, lPos, lpFormat, cbFormat)
proc Read*(self: ptr IAVIStream, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, plBytes: ptr LONG, plSamples: ptr LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Read(self, lStart, lSamples, lpBuffer, cbBuffer, plBytes, plSamples)
proc Write*(self: ptr IAVIStream, lStart: LONG, lSamples: LONG, lpBuffer: LPVOID, cbBuffer: LONG, dwFlags: DWORD, plSampWritten: ptr LONG, plBytesWritten: ptr LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Write(self, lStart, lSamples, lpBuffer, cbBuffer, dwFlags, plSampWritten, plBytesWritten)
proc mDelete*(self: ptr IAVIStream, lStart: LONG, lSamples: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Delete(self, lStart, lSamples)
proc ReadData*(self: ptr IAVIStream, fcc: DWORD, lp: LPVOID, lpcb: ptr LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.ReadData(self, fcc, lp, lpcb)
proc WriteData*(self: ptr IAVIStream, fcc: DWORD, lp: LPVOID, cb: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.WriteData(self, fcc, lp, cb)
proc SetInfo*(self: ptr IAVIStream, lpInfo: ptr TAVISTREAMINFOW, cbInfo: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.SetInfo(self, lpInfo, cbInfo)
proc Begin*(self: ptr IAVIStreaming, lStart: LONG, lEnd: LONG, lRate: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Begin(self, lStart, lEnd, lRate)
proc End*(self: ptr IAVIStreaming): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.End(self)
proc Cut*(self: ptr IAVIEditStream, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Cut(self, plStart, plLength, ppResult)
proc Copy*(self: ptr IAVIEditStream, plStart: ptr LONG, plLength: ptr LONG, ppResult: ptr PAVISTREAM): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Copy(self, plStart, plLength, ppResult)
proc Paste*(self: ptr IAVIEditStream, plPos: ptr LONG, plLength: ptr LONG, pstream: PAVISTREAM, lStart: LONG, lEnd: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Paste(self, plPos, plLength, pstream, lStart, lEnd)
proc Clone*(self: ptr IAVIEditStream, ppResult: ptr PAVISTREAM): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Clone(self, ppResult)
proc SetInfo*(self: ptr IAVIEditStream, lpInfo: ptr TAVISTREAMINFOW, cbInfo: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.SetInfo(self, lpInfo, cbInfo)
proc Reserved1*(self: ptr IAVIPersistFile): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Reserved1(self)
proc Info*(self: ptr IAVIFile, pfi: ptr TAVIFILEINFOW, lSize: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Info(self, pfi, lSize)
proc GetStream*(self: ptr IAVIFile, ppStream: ptr PAVISTREAM, fccType: DWORD, lParam: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.GetStream(self, ppStream, fccType, lParam)
proc CreateStream*(self: ptr IAVIFile, ppStream: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOW): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.CreateStream(self, ppStream, psi)
proc WriteData*(self: ptr IAVIFile, ckid: DWORD, lpData: LPVOID, cbData: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.WriteData(self, ckid, lpData, cbData)
proc ReadData*(self: ptr IAVIFile, ckid: DWORD, lpData: LPVOID, lpcbData: ptr LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.ReadData(self, ckid, lpData, lpcbData)
proc EndRecord*(self: ptr IAVIFile): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.EndRecord(self)
proc DeleteStream*(self: ptr IAVIFile, fccType: DWORD, lParam: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.DeleteStream(self, fccType, lParam)
proc GetFrame*(self: ptr IGetFrame, lPos: LONG): LPVOID {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.GetFrame(self, lPos)
proc Begin*(self: ptr IGetFrame, lStart: LONG, lEnd: LONG, lRate: LONG): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.Begin(self, lStart, lEnd, lRate)
proc End*(self: ptr IGetFrame): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.End(self)
proc SetFormat*(self: ptr IGetFrame, lpbi: LPBITMAPINFOHEADER, lpBits: LPVOID, x: int32, y: int32, dx: int32, dy: int32): HRESULT {.winapi, inline.} = {.gcsafe.}: self.lpVtbl.SetFormat(self, lpbi, lpBits, x, y, dx, dy)
converter winimConverterIAVIStreamToIUnknown*(x: ptr IAVIStream): ptr IUnknown = cast[ptr IUnknown](x)
converter winimConverterIAVIStreamingToIUnknown*(x: ptr IAVIStreaming): ptr IUnknown = cast[ptr IUnknown](x)
converter winimConverterIAVIEditStreamToIUnknown*(x: ptr IAVIEditStream): ptr IUnknown = cast[ptr IUnknown](x)
converter winimConverterIAVIPersistFileToIPersistFile*(x: ptr IAVIPersistFile): ptr IPersistFile = cast[ptr IPersistFile](x)
converter winimConverterIAVIPersistFileToIPersist*(x: ptr IAVIPersistFile): ptr IPersist = cast[ptr IPersist](x)
converter winimConverterIAVIPersistFileToIUnknown*(x: ptr IAVIPersistFile): ptr IUnknown = cast[ptr IUnknown](x)
converter winimConverterIAVIFileToIUnknown*(x: ptr IAVIFile): ptr IUnknown = cast[ptr IUnknown](x)
converter winimConverterIGetFrameToIUnknown*(x: ptr IGetFrame): ptr IUnknown = cast[ptr IUnknown](x)
when winimUnicode:
  type
    ACMDRIVERDETAILS* = ACMDRIVERDETAILSW
    PACMDRIVERDETAILS* = PACMDRIVERDETAILSW
    LPACMDRIVERDETAILS* = LPACMDRIVERDETAILSW
    ACMFORMATTAGDETAILS* = ACMFORMATTAGDETAILSW
    PACMFORMATTAGDETAILS* = PACMFORMATTAGDETAILSW
    LPACMFORMATTAGDETAILS* = LPACMFORMATTAGDETAILSW
    ACMFORMATTAGENUMCB* = ACMFORMATTAGENUMCBW
    ACMFORMATDETAILS* = ACMFORMATDETAILSW
    PACMFORMATDETAILS* = PACMFORMATDETAILSW
    LPACMFORMATDETAILS* = LPACMFORMATDETAILSW
    ACMFORMATENUMCB* = ACMFORMATENUMCBW
    ACMFORMATCHOOSEHOOKPROC* = ACMFORMATCHOOSEHOOKPROCW
    ACMFORMATCHOOSE* = ACMFORMATCHOOSEW
    PACMFORMATCHOOSE* = PACMFORMATCHOOSEW
    LPACMFORMATCHOOSE* = LPACMFORMATCHOOSEW
    ACMFILTERTAGDETAILS* = ACMFILTERTAGDETAILSW
    PACMFILTERTAGDETAILS* = PACMFILTERTAGDETAILSW
    LPACMFILTERTAGDETAILS* = LPACMFILTERTAGDETAILSW
    ACMFILTERTAGENUMCB* = ACMFILTERTAGENUMCBW
    ACMFILTERDETAILS* = ACMFILTERDETAILSW
    PACMFILTERDETAILS* = PACMFILTERDETAILSW
    LPACMFILTERDETAILS* = LPACMFILTERDETAILSW
    ACMFILTERENUMCB* = ACMFILTERENUMCBW
    ACMFILTERCHOOSEHOOKPROC* = ACMFILTERCHOOSEHOOKPROCW
    ACMFILTERCHOOSE* = ACMFILTERCHOOSEW
    PACMFILTERCHOOSE* = PACMFILTERCHOOSEW
    LPACMFILTERCHOOSE* = LPACMFILTERCHOOSEW
    TAVISTREAMINFO* = TAVISTREAMINFOW
    LPAVISTREAMINFO* = LPAVISTREAMINFOW
    TAVIFILEINFO* = TAVIFILEINFOW
    LPAVIFILEINFO* = LPAVIFILEINFOW
    CAPSTATUSCALLBACK* = CAPSTATUSCALLBACKW
    CAPERRORCALLBACK* = CAPERRORCALLBACKW
  const
    ACMHELPMSGSTRING* = ACMHELPMSGSTRINGW
    ACMHELPMSGCONTEXTMENU* = ACMHELPMSGCONTEXTMENUW
    ACMHELPMSGCONTEXTHELP* = ACMHELPMSGCONTEXTHELPW
    MCIWNDF_NOTIFYMEDIA* = MCIWNDF_NOTIFYMEDIAW
  proc acmDriverAdd*(phadid: LPHACMDRIVERID, hinstModule: HINSTANCE, lParam: LPARAM, dwPriority: DWORD, fdwAdd: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmDriverAddW".}
  proc acmDriverDetails*(hadid: HACMDRIVERID, padd: LPACMDRIVERDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmDriverDetailsW".}
  proc acmFormatTagDetails*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatTagDetailsW".}
  proc acmFormatTagEnum*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSW, fnCallback: ACMFORMATTAGENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatTagEnumW".}
  proc acmFormatDetails*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatDetailsW".}
  proc acmFormatEnum*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSW, fnCallback: ACMFORMATENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatEnumW".}
  proc acmFormatChoose*(pafmtc: LPACMFORMATCHOOSEW): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatChooseW".}
  proc acmFilterTagDetails*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterTagDetailsW".}
  proc acmFilterTagEnum*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSW, fnCallback: ACMFILTERTAGENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterTagEnumW".}
  proc acmFilterDetails*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSW, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterDetailsW".}
  proc acmFilterEnum*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSW, fnCallback: ACMFILTERENUMCBW, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterEnumW".}
  proc acmFilterChoose*(pafltrc: LPACMFILTERCHOOSEW): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterChooseW".}
  proc AVIFileOpen*(ppfile: ptr PAVIFILE, szFile: LPCWSTR, uMode: UINT, lpHandler: LPCLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileOpenW".}
  proc AVIFileInfo*(pfile: PAVIFILE, pfi: LPAVIFILEINFOW, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileInfoW".}
  proc AVIFileCreateStream*(pfile: PAVIFILE, ppavi: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOW): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileCreateStreamW".}
  proc AVIStreamInfo*(pavi: PAVISTREAM, psi: LPAVISTREAMINFOW, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamInfoW".}
  proc AVIStreamOpenFromFile*(ppavi: ptr PAVISTREAM, szFile: LPCWSTR, fccType: DWORD, lParam: LONG, mode: UINT, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamOpenFromFileW".}
  proc AVISaveV*(szFile: LPCWSTR, pclsidHandler: ptr CLSID, lpfnCallback: AVISAVECALLBACK, nStreams: int32, ppavi: ptr PAVISTREAM, plpOptions: ptr LPAVICOMPRESSOPTIONS): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVISaveVW".}
  proc AVIBuildFilter*(lpszFilter: LPWSTR, cbFilter: LONG, fSaving: WINBOOL): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIBuildFilterW".}
  proc EditStreamSetInfo*(pavi: PAVISTREAM, lpInfo: LPAVISTREAMINFOW, cbInfo: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "EditStreamSetInfoW".}
  proc EditStreamSetName*(pavi: PAVISTREAM, lpszName: LPCWSTR): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "EditStreamSetNameW".}
  proc MCIWndCreate*(hwndParent: HWND, hInstance: HINSTANCE, dwStyle: DWORD, szFile: LPCWSTR): HWND {.winapi, stdcall, dynlib: "msvfw32", importc: "MCIWndCreateW".}
  proc capCreateCaptureWindow*(lpszWindowName: LPCWSTR, dwStyle: DWORD, x: int32, y: int32, nWidth: int32, nHeight: int32, hwndParent: HWND, nID: int32): HWND {.winapi, stdcall, dynlib: "avicap32", importc: "capCreateCaptureWindowW".}
  proc capGetDriverDescription*(wDriverIndex: UINT, lpszName: LPWSTR, cbName: int32, lpszVer: LPWSTR, cbVer: int32): WINBOOL {.winapi, stdcall, dynlib: "avicap32", importc: "capGetDriverDescriptionW".}
  proc GetOpenFileNamePreview*(lpofn: LPOPENFILENAMEW): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc: "GetOpenFileNamePreviewW".}
  proc GetSaveFileNamePreview*(lpofn: LPOPENFILENAMEW): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc: "GetSaveFileNamePreviewW".}
when winimAnsi:
  type
    ACMDRIVERDETAILS* = ACMDRIVERDETAILSA
    PACMDRIVERDETAILS* = PACMDRIVERDETAILSA
    LPACMDRIVERDETAILS* = LPACMDRIVERDETAILSA
    ACMFORMATTAGDETAILS* = ACMFORMATTAGDETAILSA
    PACMFORMATTAGDETAILS* = PACMFORMATTAGDETAILSA
    LPACMFORMATTAGDETAILS* = LPACMFORMATTAGDETAILSA
    ACMFORMATTAGENUMCB* = ACMFORMATTAGENUMCBA
    ACMFORMATDETAILS* = ACMFORMATDETAILSA
    PACMFORMATDETAILS* = PACMFORMATDETAILSA
    LPACMFORMATDETAILS* = LPACMFORMATDETAILSA
    ACMFORMATENUMCB* = ACMFORMATENUMCBA
    ACMFORMATCHOOSEHOOKPROC* = ACMFORMATCHOOSEHOOKPROCA
    ACMFORMATCHOOSE* = ACMFORMATCHOOSEA
    PACMFORMATCHOOSE* = PACMFORMATCHOOSEA
    LPACMFORMATCHOOSE* = LPACMFORMATCHOOSEA
    ACMFILTERTAGDETAILS* = ACMFILTERTAGDETAILSA
    PACMFILTERTAGDETAILS* = PACMFILTERTAGDETAILSA
    LPACMFILTERTAGDETAILS* = LPACMFILTERTAGDETAILSA
    ACMFILTERTAGENUMCB* = ACMFILTERTAGENUMCBA
    ACMFILTERDETAILS* = ACMFILTERDETAILSA
    PACMFILTERDETAILS* = PACMFILTERDETAILSA
    LPACMFILTERDETAILS* = LPACMFILTERDETAILSA
    ACMFILTERENUMCB* = ACMFILTERENUMCBA
    ACMFILTERCHOOSEHOOKPROC* = ACMFILTERCHOOSEHOOKPROCA
    ACMFILTERCHOOSE* = ACMFILTERCHOOSEA
    PACMFILTERCHOOSE* = PACMFILTERCHOOSEA
    LPACMFILTERCHOOSE* = LPACMFILTERCHOOSEA
    TAVISTREAMINFO* = TAVISTREAMINFOA
    LPAVISTREAMINFO* = LPAVISTREAMINFOA
    TAVIFILEINFO* = TAVIFILEINFOA
    LPAVIFILEINFO* = LPAVIFILEINFOA
    CAPSTATUSCALLBACK* = CAPSTATUSCALLBACKA
    CAPERRORCALLBACK* = CAPERRORCALLBACKA
  const
    CLSID_AVISimpleUnMarshal* = DEFINE_GUID("00020009-0000-0000-c000-000000000046")
    ACMHELPMSGSTRING* = ACMHELPMSGSTRINGA
    ACMHELPMSGCONTEXTMENU* = ACMHELPMSGCONTEXTMENUA
    ACMHELPMSGCONTEXTHELP* = ACMHELPMSGCONTEXTHELPA
    MCIWNDF_NOTIFYMEDIA* = MCIWNDF_NOTIFYMEDIAA
  proc acmDriverAdd*(phadid: LPHACMDRIVERID, hinstModule: HINSTANCE, lParam: LPARAM, dwPriority: DWORD, fdwAdd: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmDriverAddA".}
  proc acmDriverDetails*(hadid: HACMDRIVERID, padd: LPACMDRIVERDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmDriverDetailsA".}
  proc acmFormatTagDetails*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatTagDetailsA".}
  proc acmFormatTagEnum*(had: HACMDRIVER, paftd: LPACMFORMATTAGDETAILSA, fnCallback: ACMFORMATTAGENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatTagEnumA".}
  proc acmFormatDetails*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatDetailsA".}
  proc acmFormatEnum*(had: HACMDRIVER, pafd: LPACMFORMATDETAILSA, fnCallback: ACMFORMATENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatEnumA".}
  proc acmFormatChoose*(pafmtc: LPACMFORMATCHOOSEA): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFormatChooseA".}
  proc acmFilterTagDetails*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterTagDetailsA".}
  proc acmFilterTagEnum*(had: HACMDRIVER, paftd: LPACMFILTERTAGDETAILSA, fnCallback: ACMFILTERTAGENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterTagEnumA".}
  proc acmFilterDetails*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSA, fdwDetails: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterDetailsA".}
  proc acmFilterEnum*(had: HACMDRIVER, pafd: LPACMFILTERDETAILSA, fnCallback: ACMFILTERENUMCBA, dwInstance: DWORD_PTR, fdwEnum: DWORD): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterEnumA".}
  proc acmFilterChoose*(pafltrc: LPACMFILTERCHOOSEA): MMRESULT {.winapi, stdcall, dynlib: "msacm32", importc: "acmFilterChooseA".}
  proc AVIFileOpen*(ppfile: ptr PAVIFILE, szFile: LPCSTR, uMode: UINT, lpHandler: LPCLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileOpenA".}
  proc AVIFileInfo*(pfile: PAVIFILE, pfi: LPAVIFILEINFOA, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileInfoA".}
  proc AVIFileCreateStream*(pfile: PAVIFILE, ppavi: ptr PAVISTREAM, psi: ptr TAVISTREAMINFOA): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIFileCreateStreamA".}
  proc AVIStreamInfo*(pavi: PAVISTREAM, psi: LPAVISTREAMINFOA, lSize: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamInfoA".}
  proc AVIStreamOpenFromFile*(ppavi: ptr PAVISTREAM, szFile: LPCSTR, fccType: DWORD, lParam: LONG, mode: UINT, pclsidHandler: ptr CLSID): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIStreamOpenFromFileA".}
  proc AVISaveV*(szFile: LPCSTR, pclsidHandler: ptr CLSID, lpfnCallback: AVISAVECALLBACK, nStreams: int32, ppavi: ptr PAVISTREAM, plpOptions: ptr LPAVICOMPRESSOPTIONS): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVISaveVA".}
  proc AVIBuildFilter*(lpszFilter: LPSTR, cbFilter: LONG, fSaving: WINBOOL): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "AVIBuildFilterA".}
  proc EditStreamSetInfo*(pavi: PAVISTREAM, lpInfo: LPAVISTREAMINFOA, cbInfo: LONG): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "EditStreamSetInfoA".}
  proc EditStreamSetName*(pavi: PAVISTREAM, lpszName: LPCSTR): HRESULT {.winapi, stdcall, dynlib: "avifil32", importc: "EditStreamSetNameA".}
  proc MCIWndCreate*(hwndParent: HWND, hInstance: HINSTANCE, dwStyle: DWORD, szFile: LPCSTR): HWND {.winapi, stdcall, dynlib: "msvfw32", importc: "MCIWndCreateA".}
  proc capCreateCaptureWindow*(lpszWindowName: LPCSTR, dwStyle: DWORD, x: int32, y: int32, nWidth: int32, nHeight: int32, hwndParent: HWND, nID: int32): HWND {.winapi, stdcall, dynlib: "avicap32", importc: "capCreateCaptureWindowA".}
  proc capGetDriverDescription*(wDriverIndex: UINT, lpszName: LPSTR, cbName: int32, lpszVer: LPSTR, cbVer: int32): WINBOOL {.winapi, stdcall, dynlib: "avicap32", importc: "capGetDriverDescriptionA".}
  proc GetOpenFileNamePreview*(lpofn: LPOPENFILENAMEA): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc: "GetOpenFileNamePreviewA".}
  proc GetSaveFileNamePreview*(lpofn: LPOPENFILENAMEA): WINBOOL {.winapi, stdcall, dynlib: "msvfw32", importc: "GetSaveFileNamePreviewA".}
