#====================================================================
#
#          Winim - Windows API, COM, and CLR Module for Nim
#               Copyright (c) Chen Kai-Hung, Ward
#
#====================================================================
import windef
#include <regstr.h>
type
  DSKTLSYSTEMTIME* {.pure.} = object
    wYear*: WORD
    wMonth*: WORD
    wDayOfWeek*: WORD
    wDay*: WORD
    wHour*: WORD
    wMinute*: WORD
    wSecond*: WORD
    wMilliseconds*: WORD
    wResult*: WORD
  PDSKTLSYSTEMTIME* = ptr DSKTLSYSTEMTIME
  LPDSKTLSYSTEMTIME* = ptr DSKTLSYSTEMTIME
const
  REGSTR_KEY_CLASS* = "Class"
  REGSTR_KEY_CONFIG* = "Config"
  REGSTR_KEY_ENUM* = "Enum"
  REGSTR_KEY_ROOTENUM* = "Root"
  REGSTR_KEY_BIOSENUM* = "BIOS"
  REGSTR_KEY_ACPIENUM* = "ACPI"
  REGSTR_KEY_PCMCIAENUM* = "PCMCIA"
  REGSTR_KEY_PCIENUM* = "PCI"
  REGSTR_KEY_VPOWERDENUM* = "VPOWERD"
  REGSTR_KEY_ISAENUM* = "ISAPnP"
  REGSTR_KEY_EISAENUM* = "EISA"
  REGSTR_KEY_LOGCONFIG* = "LogConfig"
  REGSTR_KEY_SYSTEMBOARD* = "*PNP0C01"
  REGSTR_KEY_APM* = "*PNP0C05"
  REGSTR_KEY_INIUPDATE* = "IniUpdate"
  REG_KEY_INSTDEV* = "Installed"
  REGSTR_KEY_DOSOPTCDROM* = "CD-ROM"
  REGSTR_KEY_DOSOPTMOUSE* = "MOUSE"
  REGSTR_KEY_KNOWNDOCKINGSTATES* = "Hardware Profiles"
  REGSTR_KEY_DEVICEPARAMETERS* = "Device Parameters"
  REGSTR_DEFAULT_INSTANCE* = "0000"
  REGSTR_PATH_MOTHERBOARD* = REGSTR_KEY_SYSTEMBOARD & "\\"
  REGSTR_PATH_SETUP* = "Software\\Microsoft\\Windows\\CurrentVersion"
  REGSTR_PATH_DRIVERSIGN* = "Software\\Microsoft\\Driver Signing"
  REGSTR_PATH_NONDRIVERSIGN* = "Software\\Microsoft\\Non-Driver Signing"
  REGSTR_PATH_DRIVERSIGN_POLICY* = "Software\\Policies\\Microsoft\\Windows NT\\Driver Signing"
  REGSTR_PATH_NONDRIVERSIGN_POLICY* = "Software\\Policies\\Microsoft\\Windows NT\\Non-Driver Signing"
  REGSTR_PATH_PIFCONVERT* = "Software\\Microsoft\\Windows\\CurrentVersion\\PIFConvert"
  REGSTR_PATH_MSDOSOPTS* = "Software\\Microsoft\\Windows\\CurrentVersion\\MS-DOSOptions"
  REGSTR_PATH_NOSUGGMSDOS* = "Software\\Microsoft\\Windows\\CurrentVersion\\NoMSDOSWarn"
  REGSTR_PATH_NEWDOSBOX* = "Software\\Microsoft\\Windows\\CurrentVersion\\MS-DOSSpecialConfig"
  REGSTR_PATH_RUNONCE* = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce"
  REGSTR_PATH_RUNONCEEX* = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx"
  REGSTR_PATH_RUN* = "Software\\Microsoft\\Windows\\CurrentVersion\\Run"
  REGSTR_PATH_RUNSERVICESONCE* = "Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce"
  REGSTR_PATH_RUNSERVICES* = "Software\\Microsoft\\Windows\\CurrentVersion\\RunServices"
  REGSTR_PATH_EXPLORER* = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer"
  REGSTR_PATH_PROPERTYSYSTEM* = "Software\\Microsoft\\Windows\\CurrentVersion\\PropertySystem"
  REGSTR_PATH_DETECT* = "Software\\Microsoft\\Windows\\CurrentVersion\\Detect"
  REGSTR_PATH_APPPATHS* = "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths"
  REGSTR_PATH_UNINSTALL* = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall"
  REGSTR_PATH_REALMODENET* = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\Real Mode Net"
  REGSTR_PATH_NETEQUIV* = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\Equivalent"
  REGSTR_PATH_CVNETWORK* = "Software\\Microsoft\\Windows\\CurrentVersion\\Network"
  REGSTR_PATH_WMI_SECURITY* = "System\\CurrentControlSet\\Control\\Wmi\\Security"
  REGSTR_PATH_RELIABILITY* = "Software\\Microsoft\\Windows\\CurrentVersion\\Reliability"
  REGSTR_PATH_RELIABILITY_POLICY* = "Software\\Policies\\Microsoft\\Windows NT\\Reliability"
  REGSTR_PATH_RELIABILITY_POLICY_SHUTDOWNREASONUI* = "ShutdownReasonUI"
  REGSTR_PATH_RELIABILITY_POLICY_SNAPSHOT* = "Snapshot"
  REGSTR_PATH_RELIABILITY_POLICY_REPORTSNAPSHOT* = "ReportSnapshot"
  REGSTR_PATH_REINSTALL* = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Reinstall"
  REGSTR_PATH_NT_CURRENTVERSION* = "Software\\Microsoft\\Windows NT\\CurrentVersion"
  REGSTR_PATH_VOLUMECACHE* = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\VolumeCaches"
  REGSTR_VAL_DISPLAY* = "display"
  REGSTR_PATH_IDCONFIGDB* = "System\\CurrentControlSet\\Control\\IDConfigDB"
  REGSTR_PATH_CRITICALDEVICEDATABASE* = "System\\CurrentControlSet\\Control\\CriticalDeviceDatabase"
  REGSTR_PATH_CLASS* = "System\\CurrentControlSet\\Services\\Class"
  REGSTR_PATH_DISPLAYSETTINGS* = "Display\\Settings"
  REGSTR_PATH_FONTS* = "Display\\Fonts"
  REGSTR_PATH_ENUM* = "Enum"
  REGSTR_PATH_ROOT* = "Enum\\Root"
  REGSTR_PATH_CURRENTCONTROLSET* = "System\\CurrentControlSet"
  REGSTR_PATH_SYSTEMENUM* = "System\\CurrentControlSet\\Enum"
  REGSTR_PATH_HWPROFILES* = "System\\CurrentControlSet\\Hardware Profiles"
  REGSTR_PATH_HWPROFILESCURRENT* = "System\\CurrentControlSet\\Hardware Profiles\\Current"
  REGSTR_PATH_CLASS_NT* = "System\\CurrentControlSet\\Control\\Class"
  REGSTR_PATH_PER_HW_ID_STORAGE* = "Software\\Microsoft\\Windows NT\\CurrentVersion\\PerHwIdStorage"
  REGSTR_PATH_DEVICE_CLASSES* = "System\\CurrentControlSet\\Control\\DeviceClasses"
  REGSTR_PATH_CODEVICEINSTALLERS* = "System\\CurrentControlSet\\Control\\CoDeviceInstallers"
  REGSTR_PATH_BUSINFORMATION* = "System\\CurrentControlSet\\Control\\PnP\\BusInformation"
  REGSTR_PATH_SERVICES* = "System\\CurrentControlSet\\Services"
  REGSTR_PATH_VXD* = "System\\CurrentControlSet\\Services\\VxD"
  REGSTR_PATH_IOS* = "System\\CurrentControlSet\\Services\\VxD\\IOS"
  REGSTR_PATH_VMM* = "System\\CurrentControlSet\\Services\\VxD\\VMM"
  REGSTR_PATH_VPOWERD* = "System\\CurrentControlSet\\Services\\VxD\\VPOWERD"
  REGSTR_PATH_VNETSUP* = "System\\CurrentControlSet\\Services\\VxD\\VNETSUP"
  REGSTR_PATH_NWREDIR* = "System\\CurrentControlSet\\Services\\VxD\\NWREDIR"
  REGSTR_PATH_NCPSERVER* = "System\\CurrentControlSet\\Services\\NcpServer\\Parameters"
  REGSTR_PATH_VCOMM* = "System\\CurrentControlSet\\Services\\VxD\\VCOMM"
  REGSTR_PATH_IOARB* = "System\\CurrentControlSet\\Services\\Arbitrators\\IOArb"
  REGSTR_PATH_ADDRARB* = "System\\CurrentControlSet\\Services\\Arbitrators\\AddrArb"
  REGSTR_PATH_DMAARB* = "System\\CurrentControlSet\\Services\\Arbitrators\\DMAArb"
  REGSTR_PATH_IRQARB* = "System\\CurrentControlSet\\Services\\Arbitrators\\IRQArb"
  REGSTR_PATH_CODEPAGE* = "System\\CurrentControlSet\\Control\\Nls\\Codepage"
  REGSTR_PATH_FILESYSTEM* = "System\\CurrentControlSet\\Control\\FileSystem"
  REGSTR_PATH_FILESYSTEM_NOVOLTRACK* = "System\\CurrentControlSet\\Control\\FileSystem\\NoVolTrack"
  REGSTR_PATH_CDFS* = "System\\CurrentControlSet\\Control\\FileSystem\\CDFS"
  REGSTR_PATH_WINBOOT* = "System\\CurrentControlSet\\Control\\WinBoot"
  REGSTR_PATH_INSTALLEDFILES* = "System\\CurrentControlSet\\Control\\InstalledFiles"
  REGSTR_PATH_VMM32FILES* = "System\\CurrentControlSet\\Control\\VMM32Files"
  REGSTR_MAX_VALUE_LENGTH* = 256
  REGSTR_KEY_DEVICE_PROPERTIES* = "Properties"
  REGSTR_VAL_SLOTNUMBER* = "SlotNumber"
  REGSTR_VAL_ATTACHEDCOMPONENTS* = "AttachedComponents"
  REGSTR_VAL_BASEDEVICEPATH* = "BaseDevicePath"
  REGSTR_VAL_SYSTEMBUSNUMBER* = "SystemBusNumber"
  REGSTR_VAL_BUSDATATYPE* = "BusDataType"
  REGSTR_VAL_INTERFACETYPE* = "InterfaceType"
  REGSTR_VAL_SERVICE* = "Service"
  REGSTR_VAL_DETECTSIGNATURE* = "DetectSignature"
  REGSTR_VAL_CLASSGUID* = "ClassGUID"
  REGSTR_VAL_INSTANCEIDENTIFIER* = "InstanceIdentifier"
  REGSTR_VAL_DUPLICATEOF* = "DuplicateOf"
  REGSTR_VAL_STATUSFLAGS* = "StatusFlags"
  REGSTR_VAL_DISABLECOUNT* = "DisableCount"
  REGSTR_VAL_UNKNOWNPROBLEMS* = "UnknownProblem"
  REGSTR_VAL_DOCKSTATE* = "DockState"
  REGSTR_VAL_PREFERENCEORDER* = "PreferenceOrder"
  REGSTR_VAL_USERWAITINTERVAL* = "UserWaitInterval"
  REGSTR_VAL_DEVICE_INSTANCE* = "DeviceInstance"
  REGSTR_VAL_SYMBOLIC_LINK* = "SymbolicLink"
  REGSTR_VAL_DEFAULT* = "Default"
  REGSTR_VAL_LOWERFILTERS* = "LowerFilters"
  REGSTR_VAL_UPPERFILTERS* = "UpperFilters"
  REGSTR_VAL_LOCATION_INFORMATION* = "LocationInformation"
  REGSTR_VAL_UI_NUMBER* = "UINumber"
  REGSTR_VAL_UI_NUMBER_DESC_FORMAT* = "UINumberDescFormat"
  REGSTR_VAL_CAPABILITIES* = "Capabilities"
  REGSTR_VAL_DEVICE_TYPE* = "DeviceType"
  REGSTR_VAL_DEVICE_CHARACTERISTICS* = "DeviceCharacteristics"
  REGSTR_VAL_DEVICE_SECURITY_DESCRIPTOR* = "Security"
  REGSTR_VAL_DEVICE_EXCLUSIVE* = "Exclusive"
  REGSTR_VAL_RESOURCE_PICKER_TAGS* = "ResourcePickerTags"
  REGSTR_VAL_RESOURCE_PICKER_EXCEPTIONS* = "ResourcePickerExceptions"
  REGSTR_VAL_CUSTOM_PROPERTY_CACHE_DATE* = "CustomPropertyCacheDate"
  REGSTR_VAL_CUSTOM_PROPERTY_HW_ID_KEY* = "CustomPropertyHwIdKey"
  REGSTR_VAL_LAST_UPDATE_TIME* = "LastUpdateTime"
  REGSTR_VAL_CONTAINERID* = "ContainerID"
  REGSTR_VAL_EJECT_PRIORITY* = "EjectPriority"
  REGSTR_KEY_CONTROL* = "Control"
  REGSTR_VAL_ACTIVESERVICE* = "ActiveService"
  REGSTR_VAL_LINKED* = "Linked"
  REGSTR_VAL_PHYSICALDEVICEOBJECT* = "PhysicalDeviceObject"
  REGSTR_VAL_REMOVAL_POLICY* = "RemovalPolicy"
  REGSTR_VAL_CURRENT_VERSION* = "CurrentVersion"
  REGSTR_VAL_CURRENT_BUILD* = "CurrentBuildNumber"
  REGSTR_VAL_CURRENT_CSDVERSION* = "CSDVersion"
  REGSTR_VAL_CURRENT_TYPE* = "CurrentType"
  REGSTR_VAL_BITSPERPIXEL* = "BitsPerPixel"
  REGSTR_VAL_RESOLUTION* = "Resolution"
  REGSTR_VAL_DPILOGICALX* = "DPILogicalX"
  REGSTR_VAL_DPILOGICALY* = "DPILogicalY"
  REGSTR_VAL_DPIPHYSICALX* = "DPIPhysicalX"
  REGSTR_VAL_DPIPHYSICALY* = "DPIPhysicalY"
  REGSTR_VAL_REFRESHRATE* = "RefreshRate"
  REGSTR_VAL_DISPLAYFLAGS* = "DisplayFlags"
  REGSTR_PATH_CONTROLPANEL* = "Control Panel"
  REGSTR_PATH_CONTROLSFOLDER* = "Software\\Microsoft\\Windows\\CurrentVersion\\Controls Folder"
  REGSTR_VAL_DOSCP* = "OEMCP"
  REGSTR_VAL_WINCP* = "ACP"
  REGSTR_PATH_DYNA_ENUM* = "Config Manager\\Enum"
  REGSTR_VAL_HARDWARE_KEY* = "HardWareKey"
  REGSTR_VAL_ALLOCATION* = "Allocation"
  REGSTR_VAL_PROBLEM* = "Problem"
  REGSTR_VAL_STATUS* = "Status"
  REGSTR_VAL_DONTUSEMEM* = "DontAllocLastMem"
  REGSTR_VAL_SYSTEMROOT* = "SystemRoot"
  REGSTR_VAL_BOOTCOUNT* = "BootCount"
  REGSTR_VAL_REALNETSTART* = "RealNetStart"
  REGSTR_VAL_MEDIA* = "MediaPath"
  REGSTR_VAL_CONFIG* = "ConfigPath"
  REGSTR_VAL_DEVICEPATH* = "DevicePath"
  REGSTR_VAL_SRCPATH* = "SourcePath"
  REGSTR_VAL_SVCPAKSRCPATH* = "ServicePackSourcePath"
  REGSTR_VAL_DRIVERCACHEPATH* = "DriverCachePath"
  REGSTR_VAL_OLDWINDIR* = "OldWinDir"
  REGSTR_VAL_SETUPFLAGS* = "SetupFlags"
  REGSTR_VAL_REGOWNER* = "RegisteredOwner"
  REGSTR_VAL_REGORGANIZATION* = "RegisteredOrganization"
  REGSTR_VAL_LICENSINGINFO* = "LicensingInfo"
  REGSTR_VAL_OLDMSDOSVER* = "OldMSDOSVer"
  REGSTR_VAL_FIRSTINSTALLDATETIME* = "FirstInstallDateTime"
  REGSTR_VAL_INSTALLTYPE* = "InstallType"
  IT_COMPACT* = 0x0000
  IT_TYPICAL* = 0x0001
  IT_PORTABLE* = 0x0002
  IT_CUSTOM* = 0x0003
  REGSTR_VAL_WRAPPER* = "Wrapper"
  REGSTR_KEY_RUNHISTORY* = "RunHistory"
  REGSTR_VAL_LASTALIVEINTERVAL* = "TimeStampInterval"
  REGSTR_VAL_DIRTYSHUTDOWN* = "DirtyShutdown"
  REGSTR_VAL_DIRTYSHUTDOWNTIME* = "DirtyShutdownTime"
  REGSTR_VAL_BT* = "6005BT"
  REGSTR_VAL_LASTCOMPUTERNAME* = "LastComputerName"
  REGSTR_VAL_LASTALIVEBT* = "LastAliveBT"
  REGSTR_VAL_LASTALIVESTAMP* = "LastAliveStamp"
  REGSTR_VAL_LASTALIVESTAMPFORCED* = "LastAliveStampForced"
  REGSTR_VAL_LASTALIVESTAMPINTERVAL* = "LastAliveStampInterval"
  REGSTR_VAL_LASTALIVESTAMPPOLICYINTERVAL* = "LastAliveStampPolicyInterval"
  REGSTR_VAL_LASTALIVEUPTIME* = "LastAliveUptime"
  REGSTR_VAL_LASTALIVEPMPOLICY* = "LastAlivePMPolicy"
  REGSTR_VAL_REASONCODE* = "ReasonCode"
  REGSTR_VAL_COMMENT* = "Comment"
  REGSTR_VAL_SHUTDOWNREASON* = "ShutdownReason"
  REGSTR_VAL_SHUTDOWNREASON_CODE* = "ShutdownReasonCode"
  REGSTR_VAL_SHUTDOWNREASON_COMMENT* = "ShutdownReasonComment"
  REGSTR_VAL_SHUTDOWNREASON_PROCESS* = "ShutdownReasonProcess"
  REGSTR_VAL_SHUTDOWNREASON_USERNAME* = "ShutdownReasonUserName"
  REGSTR_VAL_SHOWREASONUI* = "ShutdownReasonUI"
  REGSTR_VAL_SHUTDOWN_IGNORE_PREDEFINED* = "ShutdownIgnorePredefinedReasons"
  REGSTR_VAL_SHUTDOWN_STATE_SNAPSHOT* = "ShutdownStateSnapshot"
  REGSTR_KEY_SETUP* = "\\Setup"
  REGSTR_VAL_BOOTDIR* = "BootDir"
  REGSTR_VAL_WINBOOTDIR* = "WinbootDir"
  REGSTR_VAL_WINDIR* = "WinDir"
  REGSTR_VAL_APPINSTPATH* = "AppInstallPath"
  REGSTR_KEY_EBDFILESLOCAL* = "EBDFilesLocale"
  REGSTR_KEY_EBDFILESKEYBOARD* = "EBDFilesKeyboard"
  REGSTR_KEY_EBDAUTOEXECBATLOCAL* = "EBDAutoexecBatLocale"
  REGSTR_KEY_EBDAUTOEXECBATKEYBOARD* = "EBDAutoexecBatKeyboard"
  REGSTR_KEY_EBDCONFIGSYSLOCAL* = "EBDConfigSysLocale"
  REGSTR_KEY_EBDCONFIGSYSKEYBOARD* = "EBDConfigSysKeyboard"
  REGSTR_VAL_POLICY* = "Policy"
  REGSTR_VAL_BEHAVIOR_ON_FAILED_VERIFY* = "BehaviorOnFailedVerify"
  DRIVERSIGN_NONE* = 0x00000000
  DRIVERSIGN_WARNING* = 0x00000001
  DRIVERSIGN_BLOCKING* = 0x00000002
  REGSTR_VAL_MSDOSMODE* = "MSDOSMode"
  REGSTR_VAL_MSDOSMODEDISCARD* = "Discard"
  REGSTR_VAL_DOSOPTGLOBALFLAGS* = "GlobalFlags"
  DOSOPTGF_DEFCLEAN* = 0x00000001
  REGSTR_VAL_DOSOPTFLAGS* = "Flags"
  REGSTR_VAL_OPTORDER* = "Order"
  REGSTR_VAL_CONFIGSYS* = "Config.Sys"
  REGSTR_VAL_AUTOEXEC* = "Autoexec.Bat"
  REGSTR_VAL_STDDOSOPTION* = "StdOption"
  REGSTR_VAL_DOSOPTTIP* = "TipText"
  DOSOPTF_DEFAULT* = 0x00000001
  DOSOPTF_SUPPORTED* = 0x00000002
  DOSOPTF_ALWAYSUSE* = 0x00000004
  DOSOPTF_USESPMODE* = 0x00000008
  DOSOPTF_PROVIDESUMB* = 0x00000010
  DOSOPTF_NEEDSETUP* = 0x00000020
  DOSOPTF_INDOSSTART* = 0x00000040
  DOSOPTF_MULTIPLE* = 0x00000080
  SUF_FIRSTTIME* = 0x00000001
  SUF_EXPRESS* = 0x00000002
  SUF_BATCHINF* = 0x00000004
  SUF_CLEAN* = 0x00000008
  SUF_INSETUP* = 0x00000010
  SUF_NETSETUP* = 0x00000020
  SUF_NETHDBOOT* = 0x00000040
  SUF_NETRPLBOOT* = 0x00000080
  SUF_SBSCOPYOK* = 0x00000100
  REGSTR_VAL_DOSPAGER* = "DOSPager"
  REGSTR_VAL_VXDGROUPS* = "VXDGroups"
  REGSTR_VAL_VPOWERDFLAGS* = "Flags"
  VPDF_DISABLEPWRMGMT* = 0x00000001
  VPDF_FORCEAPM10MODE* = 0x00000002
  VPDF_SKIPINTELSLCHECK* = 0x00000004
  VPDF_DISABLEPWRSTATUSPOLL* = 0x00000008
  VPDF_DISABLERINGRESUME* = 0x00000010
  VPDF_SHOWMULTIBATT* = 0x00000020
  BIF_SHOWSIMILARDRIVERS* = 0x00000001
  BIF_RAWDEVICENEEDSDRIVER* = 0x00000002
  REGSTR_VAL_WORKGROUP* = "Workgroup"
  REGSTR_VAL_DIRECTHOST* = "DirectHost"
  REGSTR_VAL_FILESHARING* = "FileSharing"
  REGSTR_VAL_PRINTSHARING* = "PrintSharing"
  REGSTR_VAL_FIRSTNETDRIVE* = "FirstNetworkDrive"
  REGSTR_VAL_MAXCONNECTIONS* = "MaxConnections"
  REGSTR_VAL_APISUPPORT* = "APISupport"
  REGSTR_VAL_MAXRETRY* = "MaxRetry"
  REGSTR_VAL_MINRETRY* = "MinRetry"
  REGSTR_VAL_SUPPORTLFN* = "SupportLFN"
  REGSTR_VAL_SUPPORTBURST* = "SupportBurst"
  REGSTR_VAL_SUPPORTTUNNELLING* = "SupportTunnelling"
  REGSTR_VAL_FULLTRACE* = "FullTrace"
  REGSTR_VAL_READCACHING* = "ReadCaching"
  REGSTR_VAL_SHOWDOTS* = "ShowDots"
  REGSTR_VAL_GAPTIME* = "GapTime"
  REGSTR_VAL_SEARCHMODE* = "SearchMode"
  REGSTR_VAL_SHELLVERSION* = "ShellVersion"
  REGSTR_VAL_MAXLIP* = "MaxLIP"
  REGSTR_VAL_PRESERVECASE* = "PreserveCase"
  REGSTR_VAL_OPTIMIZESFN* = "OptimizeSFN"
  REGSTR_VAL_NCP_BROWSEMASTER* = "BrowseMaster"
  REGSTR_VAL_NCP_USEPEERBROWSING* = "Use_PeerBrowsing"
  REGSTR_VAL_NCP_USESAP* = "Use_Sap"
  REGSTR_VAL_PCCARD_POWER* = "EnablePowerManagement"
  REGSTR_VAL_WIN31FILESYSTEM* = "Win31FileSystem"
  REGSTR_VAL_PRESERVELONGNAMES* = "PreserveLongNames"
  REGSTR_VAL_DRIVEWRITEBEHIND* = "DriveWriteBehind"
  REGSTR_VAL_ASYNCFILECOMMIT* = "AsyncFileCommit"
  REGSTR_VAL_PATHCACHECOUNT* = "PathCache"
  REGSTR_VAL_NAMECACHECOUNT* = "NameCache"
  REGSTR_VAL_CONTIGFILEALLOC* = "ContigFileAllocSize"
  REGSTR_VAL_FREESPACERATIO* = "FreeSpaceRatio"
  REGSTR_VAL_VOLIDLETIMEOUT* = "VolumeIdleTimeout"
  REGSTR_VAL_BUFFIDLETIMEOUT* = "BufferIdleTimeout"
  REGSTR_VAL_BUFFAGETIMEOUT* = "BufferAgeTimeout"
  REGSTR_VAL_NAMENUMERICTAIL* = "NameNumericTail"
  REGSTR_VAL_READAHEADTHRESHOLD* = "ReadAheadThreshold"
  REGSTR_VAL_DOUBLEBUFFER* = "DoubleBuffer"
  REGSTR_VAL_SOFTCOMPATMODE* = "SoftCompatMode"
  REGSTR_VAL_DRIVESPINDOWN* = "DriveSpinDown"
  REGSTR_VAL_FORCEPMIO* = "ForcePMIO"
  REGSTR_VAL_FORCERMIO* = "ForceRMIO"
  REGSTR_VAL_LASTBOOTPMDRVS* = "LastBootPMDrvs"
  REGSTR_VAL_ACSPINDOWNPREVIOUS* = "ACSpinDownPrevious"
  REGSTR_VAL_BATSPINDOWNPREVIOUS* = "BatSpinDownPrevious"
  REGSTR_VAL_VIRTUALHDIRQ* = "VirtualHDIRQ"
  REGSTR_VAL_SRVNAMECACHECOUNT* = "ServerNameCacheMax"
  REGSTR_VAL_SRVNAMECACHE* = "ServerNameCache"
  REGSTR_VAL_SRVNAMECACHENETPROV* = "ServerNameCacheNumNets"
  REGSTR_VAL_AUTOMOUNT* = "AutoMountDrives"
  REGSTR_VAL_COMPRESSIONMETHOD* = "CompressionAlgorithm"
  REGSTR_VAL_COMPRESSIONTHRESHOLD* = "CompressionThreshold"
  REGSTR_VAL_ACDRIVESPINDOWN* = "ACDriveSpinDown"
  REGSTR_VAL_BATDRIVESPINDOWN* = "BatDriveSpinDown"
  REGSTR_VAL_CDCACHESIZE* = "CacheSize"
  REGSTR_VAL_CDPREFETCH* = "Prefetch"
  REGSTR_VAL_CDPREFETCHTAIL* = "PrefetchTail"
  REGSTR_VAL_CDRAWCACHE* = "RawCache"
  REGSTR_VAL_CDEXTERRORS* = "ExtendedErrors"
  REGSTR_VAL_CDSVDSENSE* = "SVDSense"
  REGSTR_VAL_CDSHOWVERSIONS* = "ShowVersions"
  REGSTR_VAL_CDCOMPATNAMES* = "MSCDEXCompatNames"
  REGSTR_VAL_CDNOREADAHEAD* = "NoReadAhead"
  REGSTR_VAL_SCSI* = "SCSI\\"
  REGSTR_VAL_ESDI* = "ESDI\\"
  REGSTR_VAL_FLOP* = "FLOP\\"
  REGSTR_VAL_DISK* = "GenDisk"
  REGSTR_VAL_CDROM* = "GenCD"
  REGSTR_VAL_TAPE* = "TAPE"
  REGSTR_VAL_SCANNER* = "SCANNER"
  REGSTR_VAL_FLOPPY* = "FLOPPY"
  REGSTR_VAL_SCSITID* = "SCSITargetID"
  REGSTR_VAL_SCSILUN* = "SCSILUN"
  REGSTR_VAL_REVLEVEL* = "RevisionLevel"
  REGSTR_VAL_PRODUCTID* = "ProductId"
  REGSTR_VAL_PRODUCTTYPE* = "ProductType"
  REGSTR_VAL_DEVTYPE* = "DeviceType"
  REGSTR_VAL_REMOVABLE* = "Removable"
  REGSTR_VAL_CURDRVLET* = "CurrentDriveLetterAssignment"
  REGSTR_VAL_USRDRVLET* = "UserDriveLetterAssignment"
  REGSTR_VAL_SYNCDATAXFER* = "SyncDataXfer"
  REGSTR_VAL_AUTOINSNOTE* = "AutoInsertNotification"
  REGSTR_VAL_DISCONNECT* = "Disconnect"
  REGSTR_VAL_INT13* = "Int13"
  REGSTR_VAL_PMODE_INT13* = "PModeInt13"
  REGSTR_VAL_USERSETTINGS* = "AdapterSettings"
  REGSTR_VAL_NOIDE* = "NoIDE"
  REGSTR_VAL_DISKCLASSNAME* = "DiskDrive"
  REGSTR_VAL_CDROMCLASSNAME* = "CDROM"
  REGSTR_VAL_FORCELOAD* = "ForceLoadPD"
  REGSTR_VAL_FORCEFIFO* = "ForceFIFO"
  REGSTR_VAL_FORCECL* = "ForceChangeLine"
  REGSTR_VAL_NOUSECLASS* = "NoUseClass"
  REGSTR_VAL_NOINSTALLCLASS* = "NoInstallClass"
  REGSTR_VAL_NODISPLAYCLASS* = "NoDisplayClass"
  REGSTR_VAL_SILENTINSTALL* = "SilentInstall"
  REGSTR_KEY_PCMCIA_CLASS* = "PCMCIA"
  REGSTR_KEY_SCSI_CLASS* = "SCSIAdapter"
  REGSTR_KEY_PORTS_CLASS* = "ports"
  REGSTR_KEY_MEDIA_CLASS* = "MEDIA"
  REGSTR_KEY_DISPLAY_CLASS* = "Display"
  REGSTR_KEY_KEYBOARD_CLASS* = "Keyboard"
  REGSTR_KEY_MOUSE_CLASS* = "Mouse"
  REGSTR_KEY_MONITOR_CLASS* = "Monitor"
  REGSTR_KEY_MODEM_CLASS* = "Modem"
  REGSTR_VAL_PCMCIA_OPT* = "Options"
  PCMCIA_OPT_HAVE_SOCKET* = 0x00000001
  PCMCIA_OPT_AUTOMEM* = 0x00000004
  PCMCIA_OPT_NO_SOUND* = 0x00000008
  PCMCIA_OPT_NO_AUDIO* = 0x00000010
  PCMCIA_OPT_NO_APMREMOVE* = 0x00000020
  REGSTR_VAL_PCMCIA_MEM* = "Memory"
  PCMCIA_DEF_MEMBEGIN* = 0x000c0000
  PCMCIA_DEF_MEMEND* = 0x00ffffff
  PCMCIA_DEF_MEMLEN* = 0x00001000
  REGSTR_VAL_PCMCIA_ALLOC* = "AllocMemWin"
  REGSTR_VAL_PCMCIA_ATAD* = "ATADelay"
  REGSTR_VAL_PCMCIA_SIZ* = "MinRegionSize"
  PCMCIA_DEF_MIN_REGION* = 0x00010000
  REGSTR_VAL_P1284MDL* = "Model"
  REGSTR_VAL_P1284MFG* = "Manufacturer"
  REGSTR_VAL_ISAPNP* = "ISAPNP"
  REGSTR_VAL_ISAPNP_RDP_OVERRIDE* = "RDPOverRide"
  REGSTR_VAL_PCI* = "PCI"
  REGSTR_PCI_OPTIONS* = "Options"
  REGSTR_PCI_DUAL_IDE* = "PCIDualIDE"
  PCI_OPTIONS_USE_BIOS* = 0x00000001
  PCI_OPTIONS_USE_IRQ_STEERING* = 0x00000002
  AGP_FLAG_NO_1X_RATE* = 0x00000001
  AGP_FLAG_NO_2X_RATE* = 0x00000002
  AGP_FLAG_NO_4X_RATE* = 0x00000004
  AGP_FLAG_NO_8X_RATE* = 0x00000008
  AGP_FLAG_REVERSE_INITIALIZATION* = 0x00000080
  AGP_FLAG_NO_SBA_ENABLE* = 0x00000100
  AGP_FLAG_NO_FW_ENABLE* = 0x00000200
  AGP_FLAG_SPECIAL_TARGET* = 0x000fffff
  AGP_FLAG_SPECIAL_RESERVE* = 0x000f8000
  REGSTR_KEY_CRASHES* = "Crashes"
  REGSTR_KEY_DANGERS* = "Dangers"
  REGSTR_KEY_DETMODVARS* = "DetModVars"
  REGSTR_KEY_NDISINFO* = "NDISInfo"
  REGSTR_VAL_PROTINIPATH* = "ProtIniPath"
  REGSTR_VAL_RESOURCES* = "Resources"
  REGSTR_VAL_CRASHFUNCS* = "CrashFuncs"
  REGSTR_VAL_CLASS* = "Class"
  REGSTR_VAL_CLASSDESC* = "ClassDesc"
  REGSTR_VAL_DEVDESC* = "DeviceDesc"
  REGSTR_VAL_BOOTCONFIG* = "BootConfig"
  REGSTR_VAL_DETFUNC* = "DetFunc"
  REGSTR_VAL_DETFLAGS* = "DetFlags"
  REGSTR_VAL_COMPATIBLEIDS* = "CompatibleIDs"
  REGSTR_VAL_DETCONFIG* = "DetConfig"
  REGSTR_VAL_VERIFYKEY* = "VerifyKey"
  REGSTR_VAL_COMINFO* = "ComInfo"
  REGSTR_VAL_INFNAME* = "InfName"
  REGSTR_VAL_CARDSPECIFIC* = "CardSpecific"
  REGSTR_VAL_NETOSTYPE* = "NetOSType"
  REGSTR_DATA_NETOS_NDIS* = "NDIS"
  REGSTR_DATA_NETOS_ODI* = "ODI"
  REGSTR_DATA_NETOS_IPX* = "IPX"
  REGSTR_VAL_MFG* = "Mfg"
  REGSTR_VAL_SCAN_ONLY_FIRST* = "ScanOnlyFirstDrive"
  REGSTR_VAL_SHARE_IRQ* = "ForceIRQSharing"
  REGSTR_VAL_NONSTANDARD_ATAPI* = "NonStandardATAPI"
  REGSTR_VAL_IDE_FORCE_SERIALIZE* = "ForceSerialization"
  REGSTR_VAL_MAX_HCID_LEN* = 1024
  REGSTR_VAL_HWREV* = "HWRevision"
  REGSTR_VAL_ENABLEINTS* = "EnableInts"
  REGDF_NOTDETIO* = 0x00000001
  REGDF_NOTDETMEM* = 0x00000002
  REGDF_NOTDETIRQ* = 0x00000004
  REGDF_NOTDETDMA* = 0x00000008
  REGDF_NOTDETALL* = REGDF_NOTDETIO or REGDF_NOTDETMEM or REGDF_NOTDETIRQ or REGDF_NOTDETDMA
  REGDF_NEEDFULLCONFIG* = 0x00000010
  REGDF_GENFORCEDCONFIG* = 0x00000020
  REGDF_NODETCONFIG* = 0x00008000
  REGDF_CONFLICTIO* = 0x00010000
  REGDF_CONFLICTMEM* = 0x00020000
  REGDF_CONFLICTIRQ* = 0x00040000
  REGDF_CONFLICTDMA* = 0x00080000
  REGDF_CONFLICTALL* = REGDF_CONFLICTIO or REGDF_CONFLICTMEM or REGDF_CONFLICTIRQ or REGDF_CONFLICTDMA
  REGDF_MAPIRQ2TO9* = 0x00100000
  REGDF_NOTVERIFIED* = 0x80000000'i32
  REGSTR_VAL_APMBIOSVER* = "APMBiosVer"
  REGSTR_VAL_APMFLAGS* = "APMFlags"
  REGSTR_VAL_SLSUPPORT* = "SLSupport"
  REGSTR_VAL_MACHINETYPE* = "MachineType"
  REGSTR_VAL_SETUPMACHINETYPE* = "SetupMachineType"
  REGSTR_MACHTYPE_UNKNOWN* = "Unknown"
  REGSTR_MACHTYPE_IBMPC* = "IBM PC"
  REGSTR_MACHTYPE_IBMPCJR* = "IBM PCjr"
  REGSTR_MACHTYPE_IBMPCCONV* = "IBM PC Convertible"
  REGSTR_MACHTYPE_IBMPCXT* = "IBM PC/XT"
  REGSTR_MACHTYPE_IBMPCXT_286* = "IBM PC/XT 286"
  REGSTR_MACHTYPE_IBMPCAT* = "IBM PC/AT"
  REGSTR_MACHTYPE_IBMPS2_25* = "IBM PS/2-25"
  REGSTR_MACHTYPE_IBMPS2_30_286* = "IBM PS/2-30 286"
  REGSTR_MACHTYPE_IBMPS2_30* = "IBM PS/2-30"
  REGSTR_MACHTYPE_IBMPS2_50* = "IBM PS/2-50"
  REGSTR_MACHTYPE_IBMPS2_50Z* = "IBM PS/2-50Z"
  REGSTR_MACHTYPE_IBMPS2_55SX* = "IBM PS/2-55SX"
  REGSTR_MACHTYPE_IBMPS2_60* = "IBM PS/2-60"
  REGSTR_MACHTYPE_IBMPS2_65SX* = "IBM PS/2-65SX"
  REGSTR_MACHTYPE_IBMPS2_70* = "IBM PS/2-70"
  REGSTR_MACHTYPE_IBMPS2_P70* = "IBM PS/2-P70"
  REGSTR_MACHTYPE_IBMPS2_70_80* = "IBM PS/2-70/80"
  REGSTR_MACHTYPE_IBMPS2_80* = "IBM PS/2-80"
  REGSTR_MACHTYPE_IBMPS2_90* = "IBM PS/2-90"
  REGSTR_MACHTYPE_IBMPS1* = "IBM PS/1"
  REGSTR_MACHTYPE_PHOENIX_PCAT* = "Phoenix PC/AT Compatible"
  REGSTR_MACHTYPE_HP_VECTRA* = "HP Vectra"
  REGSTR_MACHTYPE_ATT_PC* = "AT and T PC"
  REGSTR_MACHTYPE_ZENITH_PC* = "Zenith PC"
  REGSTR_VAL_APMMENUSUSPEND* = "APMMenuSuspend"
  APMMENUSUSPEND_DISABLED* = 0
  APMMENUSUSPEND_ENABLED* = 1
  APMMENUSUSPEND_UNDOCKED* = 2
  APMMENUSUSPEND_NOCHANGE* = 0x80
  REGSTR_VAL_APMACTIMEOUT* = "APMACTimeout"
  REGSTR_VAL_APMBATTIMEOUT* = "APMBatTimeout"
  APMTIMEOUT_DISABLED* = 0
  REGSTR_VAL_APMSHUTDOWNPOWER* = "APMShutDownPower"
  REGSTR_VAL_BUSTYPE* = "BusType"
  REGSTR_VAL_CPU* = "CPU"
  REGSTR_VAL_NDP* = "NDP"
  REGSTR_VAL_PNPBIOSVER* = "PnPBIOSVer"
  REGSTR_VAL_PNPSTRUCOFFSET* = "PnPStrucOffset"
  REGSTR_VAL_PCIBIOSVER* = "PCIBIOSVer"
  REGSTR_VAL_HWMECHANISM* = "HWMechanism"
  REGSTR_VAL_LASTPCIBUSNUM* = "LastPCIBusNum"
  REGSTR_VAL_CONVMEM* = "ConvMem"
  REGSTR_VAL_EXTMEM* = "ExtMem"
  REGSTR_VAL_COMPUTERNAME* = "ComputerName"
  REGSTR_VAL_BIOSNAME* = "BIOSName"
  REGSTR_VAL_BIOSVERSION* = "BIOSVersion"
  REGSTR_VAL_BIOSDATE* = "BIOSDate"
  REGSTR_VAL_MODEL* = "Model"
  REGSTR_VAL_SUBMODEL* = "Submodel"
  REGSTR_VAL_REVISION* = "Revision"
  REGSTR_VAL_FIFODEPTH* = "FIFODepth"
  REGSTR_VAL_RDINTTHRESHOLD* = "RDIntThreshold"
  REGSTR_VAL_WRINTTHRESHOLD* = "WRIntThreshold"
  REGSTR_VAL_PRIORITY* = "Priority"
  REGSTR_VAL_DRIVER* = "Driver"
  REGSTR_VAL_FUNCDESC* = "FunctionDesc"
  REGSTR_VAL_FORCEDCONFIG* = "ForcedConfig"
  REGSTR_VAL_CONFIGFLAGS* = "ConfigFlags"
  REGSTR_VAL_CSCONFIGFLAGS* = "CSConfigFlags"
  CONFIGFLAG_DISABLED* = 0x00000001
  CONFIGFLAG_REMOVED* = 0x00000002
  CONFIGFLAG_MANUAL_INSTALL* = 0x00000004
  CONFIGFLAG_IGNORE_BOOT_LC* = 0x00000008
  CONFIGFLAG_NET_BOOT* = 0x00000010
  CONFIGFLAG_REINSTALL* = 0x00000020
  CONFIGFLAG_FAILEDINSTALL* = 0x00000040
  CONFIGFLAG_CANTSTOPACHILD* = 0x00000080
  CONFIGFLAG_OKREMOVEROM* = 0x00000100
  CONFIGFLAG_NOREMOVEEXIT* = 0x00000200
  CONFIGFLAG_FINISH_INSTALL* = 0x00000400
  CONFIGFLAG_NEEDS_FORCED_CONFIG* = 0x00000800
  CONFIGFLAG_NETBOOT_CARD* = 0x00001000
  CONFIGFLAG_PARTIAL_LOG_CONF* = 0x00002000
  CONFIGFLAG_SUPPRESS_SURPRISE* = 0x00004000
  CONFIGFLAG_VERIFY_HARDWARE* = 0x00008000
  CONFIGFLAG_FINISHINSTALL_UI* = 0x00010000
  CONFIGFLAG_FINISHINSTALL_ACTION* = 0x00020000
  CONFIGFLAG_BOOT_DEVICE* = 0x00040000
  CSCONFIGFLAG_BITS* = 0x00000007
  CSCONFIGFLAG_DISABLED* = 0x00000001
  CSCONFIGFLAG_DO_NOT_CREATE* = 0x00000002
  CSCONFIGFLAG_DO_NOT_START* = 0x00000004
  DMSTATEFLAG_APPLYTOALL* = 0x00000001
  REGSTR_VAL_ROOT_DEVNODE* = "HTREE\\ROOT\\0"
  REGSTR_VAL_RESERVED_DEVNODE* = "HTREE\\RESERVED\\0"
  REGSTR_PATH_READDATAPORT* = REGSTR_KEY_ISAENUM & "\\ReadDataPort\\0"
  REGSTR_PATH_MULTI_FUNCTION* = "MF"
  REGSTR_VAL_RESOURCE_MAP* = "ResourceMap"
  REGSTR_PATH_CHILD_PREFIX* = "Child"
  NUM_RESOURCE_MAP* = 256
  REGSTR_VAL_MF_FLAGS* = "MFFlags"
  MF_FLAGS_EVEN_IF_NO_RESOURCE* = 0x00000001
  MF_FLAGS_NO_CREATE_IF_NO_RESOURCE* = 0x00000002
  MF_FLAGS_FILL_IN_UNKNOWN_RESOURCE* = 0x00000004
  MF_FLAGS_CREATE_BUT_NO_SHOW_DISABLED* = 0x00000008
  REGSTR_VAL_EISA_RANGES* = "EISARanges"
  REGSTR_VAL_EISA_FUNCTIONS* = "EISAFunctions"
  REGSTR_VAL_EISA_FUNCTIONS_MASK* = "EISAFunctionsMask"
  REGSTR_VAL_EISA_FLAGS* = "EISAFlags"
  REGSTR_VAL_EISA_SIMULATE_INT15* = "EISASimulateInt15"
  EISAFLAG_NO_IO_MERGE* = 0x00000001
  EISAFLAG_SLOT_IO_FIRST* = 0x00000002
  EISA_NO_MAX_FUNCTION* = 0xff
  NUM_EISA_RANGES* = 4
  REGSTR_VAL_DRVDESC* = "DriverDesc"
  REGSTR_VAL_DEVLOADER* = "DevLoader"
  REGSTR_VAL_STATICVXD* = "StaticVxD"
  REGSTR_VAL_PROPERTIES* = "Properties"
  REGSTR_VAL_MANUFACTURER* = "Manufacturer"
  REGSTR_VAL_EXISTS* = "Exists"
  REGSTR_VAL_CMENUMFLAGS* = "CMEnumFlags"
  REGSTR_VAL_CMDRIVFLAGS* = "CMDrivFlags"
  REGSTR_VAL_ENUMERATOR* = "Enumerator"
  REGSTR_VAL_DEVICEDRIVER* = "DeviceDriver"
  REGSTR_VAL_PORTNAME* = "PortName"
  REGSTR_VAL_INFPATH* = "InfPath"
  REGSTR_VAL_INFSECTION* = "InfSection"
  REGSTR_VAL_INFSECTIONEXT* = "InfSectionExt"
  REGSTR_VAL_POLLING* = "Polling"
  REGSTR_VAL_DONTLOADIFCONFLICT* = "DontLoadIfConflict"
  REGSTR_VAL_PORTSUBCLASS* = "PortSubClass"
  REGSTR_VAL_NETCLEAN* = "NetClean"
  REGSTR_VAL_IDE_NO_SERIALIZE* = "IDENoSerialize"
  REGSTR_VAL_NOCMOSORFDPT* = "NoCMOSorFDPT"
  REGSTR_VAL_COMVERIFYBASE* = "COMVerifyBase"
  REGSTR_VAL_MATCHINGDEVID* = "MatchingDeviceId"
  REGSTR_VAL_DRIVERDATE* = "DriverDate"
  REGSTR_VAL_DRIVERDATEDATA* = "DriverDateData"
  REGSTR_VAL_DRIVERVERSION* = "DriverVersion"
  REGSTR_VAL_LOCATION_INFORMATION_OVERRIDE* = "LocationInformationOverride"
  REGSTR_KEY_OVERRIDE* = "Override"
  REGSTR_VAL_CONFIGMG* = "CONFIGMG"
  REGSTR_VAL_SYSDM* = "SysDM"
  REGSTR_VAL_SYSDMFUNC* = "SysDMFunc"
  REGSTR_VAL_PRIVATE* = "Private"
  REGSTR_VAL_PRIVATEFUNC* = "PrivateFunc"
  REGSTR_VAL_DETECT* = "Detect"
  REGSTR_VAL_DETECTFUNC* = "DetectFunc"
  REGSTR_VAL_ASKFORCONFIG* = "AskForConfig"
  REGSTR_VAL_ASKFORCONFIGFUNC* = "AskForConfigFunc"
  REGSTR_VAL_WAITFORUNDOCK* = "WaitForUndock"
  REGSTR_VAL_WAITFORUNDOCKFUNC* = "WaitForUndockFunc"
  REGSTR_VAL_REMOVEROMOKAY* = "RemoveRomOkay"
  REGSTR_VAL_REMOVEROMOKAYFUNC* = "RemoveRomOkayFunc"
  REGSTR_VAL_CURCONFIG* = "CurrentConfig"
  REGSTR_VAL_FRIENDLYNAME* = "FriendlyName"
  REGSTR_VAL_CURRENTCONFIG* = "CurrentConfig"
  REGSTR_VAL_MAP* = "Map"
  REGSTR_VAL_ID* = "CurrentID"
  REGSTR_VAL_DOCKED* = "CurrentDockedState"
  REGSTR_VAL_CHECKSUM* = "CurrentChecksum"
  REGSTR_VAL_HWDETECT* = "HardwareDetect"
  REGSTR_VAL_INHIBITRESULTS* = "InhibitResults"
  REGSTR_VAL_PROFILEFLAGS* = "ProfileFlags"
  REGSTR_KEY_PCMCIA* = "PCMCIA\\"
  REGSTR_KEY_PCUNKNOWN* = "UNKNOWN_MANUFACTURER"
  REGSTR_VAL_PCSSDRIVER* = "Driver"
  REGSTR_KEY_PCMTD* = "MTD-"
  REGSTR_VAL_PCMTDRIVER* = "MTD"
  REGSTR_VAL_HARDWAREID* = "HardwareID"
  REGSTR_VAL_INSTALLER* = "Installer"
  REGSTR_VAL_INSTALLER_32* = "Installer32"
  REGSTR_VAL_INSICON* = "Icon"
  REGSTR_VAL_ENUMPROPPAGES* = "EnumPropPages"
  REGSTR_VAL_ENUMPROPPAGES_32* = "EnumPropPages32"
  REGSTR_VAL_BASICPROPERTIES* = "BasicProperties"
  REGSTR_VAL_BASICPROPERTIES_32* = "BasicProperties32"
  REGSTR_VAL_COINSTALLERS_32* = "CoInstallers32"
  REGSTR_VAL_PRIVATEPROBLEM* = "PrivateProblem"
  REGSTR_KEY_CURRENT* = "Current"
  REGSTR_KEY_DEFAULT* = "Default"
  REGSTR_KEY_MODES* = "Modes"
  REGSTR_VAL_MODE* = "Mode"
  REGSTR_VAL_BPP* = "BPP"
  REGSTR_VAL_HRES* = "HRes"
  REGSTR_VAL_VRES* = "VRes"
  REGSTR_VAL_FONTSIZE* = "FontSize"
  REGSTR_VAL_DRV* = "drv"
  REGSTR_VAL_GRB* = "grb"
  REGSTR_VAL_VDD* = "vdd"
  REGSTR_VAL_VER* = "Ver"
  REGSTR_VAL_MAXRES* = "MaxResolution"
  REGSTR_VAL_DPMS* = "DPMS"
  REGSTR_VAL_RESUMERESET* = "ResumeReset"
  REGSTR_VAL_DESCRIPTION* = "Description"
  REGSTR_KEY_SYSTEM* = "System"
  REGSTR_KEY_USER* = "User"
  REGSTR_VAL_DPI* = "dpi"
  REGSTR_VAL_PCICOPTIONS* = "PCICOptions"
  PCIC_DEFAULT_IRQMASK* = 0x4eb8
  PCIC_DEFAULT_NUMSOCKETS* = 0
  REGSTR_VAL_PCICIRQMAP* = "PCICIRQMap"
  REGSTR_PATH_APPEARANCE* = "Control Panel\\Appearance"
  REGSTR_PATH_LOOKSCHEMES* = "Control Panel\\Appearance\\Schemes"
  REGSTR_VAL_CUSTOMCOLORS* = "CustomColors"
  REGSTR_PATH_SCREENSAVE* = "Control Panel\\Desktop"
  REGSTR_VALUE_USESCRPASSWORD* = "ScreenSaveUsePassword"
  REGSTR_VALUE_SCRPASSWORD* = "ScreenSave_Data"
  REGSTR_VALUE_LOWPOWERTIMEOUT* = "ScreenSaveLowPowerTimeout"
  REGSTR_VALUE_POWEROFFTIMEOUT* = "ScreenSavePowerOffTimeout"
  REGSTR_VALUE_LOWPOWERACTIVE* = "ScreenSaveLowPowerActive"
  REGSTR_VALUE_POWEROFFACTIVE* = "ScreenSavePowerOffActive"
  REGSTR_PATH_WINDOWSAPPLETS* = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets"
  REGSTR_PATH_SYSTRAY* = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\SysTray"
  REGSTR_VAL_SYSTRAYSVCS* = "Services"
  REGSTR_VAL_SYSTRAYBATFLAGS* = "PowerFlags"
  REGSTR_VAL_SYSTRAYPCCARDFLAGS* = "PCMCIAFlags"
  REGSTR_PATH_NETWORK_USERSETTINGS* = "Network"
  REGSTR_KEY_NETWORK_PERSISTENT* = "\\Persistent"
  REGSTR_KEY_NETWORK_RECENT* = "\\Recent"
  REGSTR_VAL_REMOTE_PATH* = "RemotePath"
  REGSTR_VAL_USER_NAME* = "UserName"
  REGSTR_VAL_PROVIDER_NAME* = "ProviderName"
  REGSTR_VAL_CONNECTION_TYPE* = "ConnectionType"
  REGSTR_VAL_UPGRADE* = "Upgrade"
  REGSTR_KEY_LOGON* = "\\Logon"
  REGSTR_VAL_MUSTBEVALIDATED* = "MustBeValidated"
  REGSTR_VAL_RUNLOGINSCRIPT* = "ProcessLoginScript"
  REGSTR_KEY_NETWORKPROVIDER* = "\\NetworkProvider"
  REGSTR_PATH_NW32NETPROVIDER* = REGSTR_PATH_SERVICES & "\\NWNP32"
  REGSTR_PATH_MS32NETPROVIDER* = REGSTR_PATH_SERVICES & "\\MSNP32"
  REGSTR_VAL_AUTHENT_AGENT* = "AuthenticatingAgent"
  REGSTR_VAL_PREFREDIR* = "PreferredRedir"
  REGSTR_VAL_AUTOSTART* = "AutoStart"
  REGSTR_VAL_AUTOLOGON* = "AutoLogon"
  REGSTR_VAL_NETCARD* = "Netcard"
  REGSTR_VAL_TRANSPORT* = "Transport"
  REGSTR_VAL_DYNAMIC* = "Dynamic"
  REGSTR_VAL_TRANSITION* = "Transition"
  REGSTR_VAL_STATICDRIVE* = "StaticDrive"
  REGSTR_VAL_LOADHI* = "LoadHi"
  REGSTR_VAL_LOADRMDRIVERS* = "LoadRMDrivers"
  REGSTR_VAL_SETUPN* = "SetupN"
  REGSTR_VAL_SETUPNPATH* = "SetupNPath"
  REGSTR_VAL_WRKGRP_FORCEMAPPING* = "WrkgrpForceMapping"
  REGSTR_VAL_WRKGRP_REQUIRED* = "WrkgrpRequired"
  REGSTR_VAL_CURRENT_USER* = "Current User"
  REGSTR_PATH_PWDPROVIDER* = "System\\CurrentControlSet\\Control\\PwdProvider"
  REGSTR_VAL_PWDPROVIDER_PATH* = "ProviderPath"
  REGSTR_VAL_PWDPROVIDER_DESC* = "Description"
  REGSTR_VAL_PWDPROVIDER_CHANGEPWD* = "ChangePassword"
  REGSTR_VAL_PWDPROVIDER_CHANGEPWDHWND* = "ChangePasswordHwnd"
  REGSTR_VAL_PWDPROVIDER_GETPWDSTATUS* = "GetPasswordStatus"
  REGSTR_VAL_PWDPROVIDER_ISNP* = "NetworkProvider"
  REGSTR_VAL_PWDPROVIDER_CHANGEORDER* = "ChangeOrder"
  REGSTR_PATH_POLICIES* = "Software\\Microsoft\\Windows\\CurrentVersion\\Policies"
  REGSTR_PATH_UPDATE* = "System\\CurrentControlSet\\Control\\Update"
  REGSTR_VALUE_ENABLE* = "Enable"
  REGSTR_VALUE_VERBOSE* = "Verbose"
  REGSTR_VALUE_NETPATH* = "NetworkPath"
  REGSTR_VALUE_DEFAULTLOC* = "UseDefaultNetLocation"
  REGSTR_KEY_NETWORK* = "Network"
  REGSTR_KEY_PRINTERS* = "Printers"
  REGSTR_KEY_WINOLDAPP* = "WinOldApp"
  REGSTR_KEY_EXPLORER* = "Explorer"
  REGSTR_PATH_RUN_POLICY* = REGSTR_PATH_POLICIES & "\\Explorer\\Run"
  REGSTR_VAL_NOFILESHARING* = "NoFileSharing"
  REGSTR_VAL_NOPRINTSHARING* = "NoPrintSharing"
  REGSTR_VAL_NOFILESHARINGCTRL* = "NoFileSharingControl"
  REGSTR_VAL_NOPRINTSHARINGCTRL* = "NoPrintSharingControl"
  REGSTR_VAL_HIDESHAREPWDS* = "HideSharePwds"
  REGSTR_VAL_DISABLEPWDCACHING* = "DisablePwdCaching"
  REGSTR_VAL_ALPHANUMPWDS* = "AlphanumPwds"
  REGSTR_VAL_NETSETUP_DISABLE* = "NoNetSetup"
  REGSTR_VAL_NETSETUP_NOCONFIGPAGE* = "NoNetSetupConfigPage"
  REGSTR_VAL_NETSETUP_NOIDPAGE* = "NoNetSetupIDPage"
  REGSTR_VAL_NETSETUP_NOSECURITYPAGE* = "NoNetSetupSecurityPage"
  REGSTR_VAL_SYSTEMCPL_NOVIRTMEMPAGE* = "NoVirtMemPage"
  REGSTR_VAL_SYSTEMCPL_NODEVMGRPAGE* = "NoDevMgrPage"
  REGSTR_VAL_SYSTEMCPL_NOCONFIGPAGE* = "NoConfigPage"
  REGSTR_VAL_SYSTEMCPL_NOFILESYSPAGE* = "NoFileSysPage"
  REGSTR_VAL_DISPCPL_NODISPCPL* = "NoDispCP"
  REGSTR_VAL_DISPCPL_NOBACKGROUNDPAGE* = "NoDispBackgroundPage"
  REGSTR_VAL_DISPCPL_NOSCRSAVPAGE* = "NoDispScrSavPage"
  REGSTR_VAL_DISPCPL_NOAPPEARANCEPAGE* = "NoDispAppearancePage"
  REGSTR_VAL_DISPCPL_NOSETTINGSPAGE* = "NoDispSettingsPage"
  REGSTR_VAL_SECCPL_NOSECCPL* = "NoSecCP"
  REGSTR_VAL_SECCPL_NOPWDPAGE* = "NoPwdPage"
  REGSTR_VAL_SECCPL_NOADMINPAGE* = "NoAdminPage"
  REGSTR_VAL_SECCPL_NOPROFILEPAGE* = "NoProfilePage"
  REGSTR_VAL_PRINTERS_HIDETABS* = "NoPrinterTabs"
  REGSTR_VAL_PRINTERS_NODELETE* = "NoDeletePrinter"
  REGSTR_VAL_PRINTERS_NOADD* = "NoAddPrinter"
  REGSTR_VAL_WINOLDAPP_DISABLED* = "Disabled"
  REGSTR_VAL_WINOLDAPP_NOREALMODE* = "NoRealMode"
  REGSTR_VAL_NOENTIRENETWORK* = "NoEntireNetwork"
  REGSTR_VAL_NOWORKGROUPCONTENTS* = "NoWorkgroupContents"
  REGSTR_VAL_UNDOCK_WITHOUT_LOGON* = "UndockWithoutLogon"
  REGSTR_VAL_MINPWDLEN* = "MinPwdLen"
  REGSTR_VAL_PWDEXPIRATION* = "PwdExpiration"
  REGSTR_VAL_WIN31PROVIDER* = "Win31Provider"
  REGSTR_VAL_DISABLEREGTOOLS* = "DisableRegistryTools"
  REGSTR_PATH_WINLOGON* = "Software\\Microsoft\\Windows\\CurrentVersion\\Winlogon"
  REGSTR_VAL_LEGALNOTICECAPTION* = "LegalNoticeCaption"
  REGSTR_VAL_LEGALNOTICETEXT* = "LegalNoticeText"
  REGSTR_VAL_SHUTDOWN_FLAGS* = "ShutdownFlags"
  REGSTR_VAL_RESTRICTRUN* = "RestrictRun"
  REGSTR_KEY_POL_USERS* = "Users"
  REGSTR_KEY_POL_COMPUTERS* = "Computers"
  REGSTR_KEY_POL_USERGROUPS* = "UserGroups"
  REGSTR_KEY_POL_DEFAULT* = ".default"
  REGSTR_KEY_POL_USERGROUPDATA* = "GroupData\\UserGroups\\Priority"
  REGSTR_PATH_TIMEZONE* = "System\\CurrentControlSet\\Control\\TimeZoneInformation"
  REGSTR_VAL_TZBIAS* = "Bias"
  REGSTR_VAL_TZDLTBIAS* = "DaylightBias"
  REGSTR_VAL_TZSTDBIAS* = "StandardBias"
  REGSTR_VAL_TZACTBIAS* = "ActiveTimeBias"
  REGSTR_VAL_TZDLTFLAG* = "DaylightFlag"
  REGSTR_VAL_TZSTDSTART* = "StandardStart"
  REGSTR_VAL_TZDLTSTART* = "DaylightStart"
  REGSTR_VAL_TZDLTNAME* = "DaylightName"
  REGSTR_VAL_TZSTDNAME* = "StandardName"
  REGSTR_VAL_TZNOCHANGESTART* = "NoChangeStart"
  REGSTR_VAL_TZNOCHANGEEND* = "NoChangeEnd"
  REGSTR_VAL_TZNOAUTOTIME* = "DisableAutoDaylightTimeSet"
  REGSTR_PATH_FLOATINGPOINTPROCESSOR* = "HARDWARE\\DESCRIPTION\\System\\FloatingPointProcessor"
  REGSTR_PATH_FLOATINGPOINTPROCESSOR0* = "HARDWARE\\DESCRIPTION\\System\\FloatingPointProcessor\\0"
  REGSTR_PATH_COMPUTRNAME* = "System\\CurrentControlSet\\Control\\ComputerName\\ComputerName"
  REGSTR_VAL_COMPUTRNAME* = "ComputerName"
  REGSTR_PATH_SHUTDOWN* = "System\\CurrentControlSet\\Control\\Shutdown"
  REGSTR_VAL_FORCEREBOOT* = "ForceReboot"
  REGSTR_VAL_SETUPPROGRAMRAN* = "SetupProgramRan"
  REGSTR_VAL_DOES_POLLING* = "PollingSupportNeeded"
  REGSTR_PATH_KNOWNDLLS* = "System\\CurrentControlSet\\Control\\SessionManager\\KnownDLLs"
  REGSTR_PATH_KNOWN16DLLS* = "System\\CurrentControlSet\\Control\\SessionManager\\Known16DLLs"
  REGSTR_PATH_CHECKVERDLLS* = "System\\CurrentControlSet\\Control\\SessionManager\\CheckVerDLLs"
  REGSTR_PATH_WARNVERDLLS* = "System\\CurrentControlSet\\Control\\SessionManager\\WarnVerDLLs"
  REGSTR_PATH_HACKINIFILE* = "System\\CurrentControlSet\\Control\\SessionManager\\HackIniFiles"
  REGSTR_PATH_CHECKBADAPPS* = "System\\CurrentControlSet\\Control\\SessionManager\\CheckBadApps"
  REGSTR_PATH_APPPATCH* = "System\\CurrentControlSet\\Control\\SessionManager\\AppPatches"
  REGSTR_PATH_CHECKBADAPPS400* = "System\\CurrentControlSet\\Control\\SessionManager\\CheckBadApps400"
  REGSTR_PATH_SHELLSERVICEOBJECT* = "Software\\Microsoft\\Windows\\CurrentVersion\\ShellServiceObject"
  REGSTR_PATH_SHELLSERVICEOBJECTDELAYED* = "Software\\Microsoft\\Windows\\CurrentVersion\\ShellServiceObjectDelayLoad"
  REGSTR_PATH_KNOWNVXDS* = "System\\CurrentControlSet\\Control\\SessionManager\\KnownVxDs"
  REGSTR_VAL_UNINSTALLER_DISPLAYNAME* = "DisplayName"
  REGSTR_VAL_UNINSTALLER_COMMANDLINE* = "UninstallString"
  REGSTR_VAL_REINSTALL_DISPLAYNAME* = "DisplayName"
  REGSTR_VAL_REINSTALL_STRING* = "ReinstallString"
  REGSTR_VAL_REINSTALL_DEVICEINSTANCEIDS* = "DeviceInstanceIds"
  REGSTR_PATH_DESKTOP* = REGSTR_PATH_SCREENSAVE
  REGSTR_PATH_MOUSE* = "Control Panel\\Mouse"
  REGSTR_PATH_KEYBOARD* = "Control Panel\\Keyboard"
  REGSTR_PATH_COLORS* = "Control Panel\\Colors"
  REGSTR_PATH_SOUND* = "Control Panel\\Sound"
  REGSTR_PATH_METRICS* = "Control Panel\\Desktop\\WindowMetrics"
  REGSTR_PATH_ICONS* = "Control Panel\\Icons"
  REGSTR_PATH_CURSORS* = "Control Panel\\Cursors"
  REGSTR_PATH_CHECKDISK* = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive"
  REGSTR_PATH_CHECKDISKSET* = "Settings"
  REGSTR_PATH_CHECKDISKUDRVS* = "NoUnknownDDErrDrvs"
  REGSTR_PATH_FAULT* = "Software\\Microsoft\\Windows\\CurrentVersion\\Fault"
  REGSTR_VAL_FAULT_LOGFILE* = "LogFile"
  REGSTR_PATH_AEDEBUG* = "Software\\Microsoft\\Windows NT\\CurrentVersion\\AeDebug"
  REGSTR_VAL_AEDEBUG_DEBUGGER* = "Debugger"
  REGSTR_VAL_AEDEBUG_AUTO* = "Auto"
  REGSTR_PATH_GRPCONV* = "Software\\Microsoft\\Windows\\CurrentVersion\\GrpConv"
  REGSTR_VAL_REGITEMDELETEMESSAGE* = "Removal Message"
  REGSTR_PATH_LASTCHECK* = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastCheck"
  REGSTR_PATH_LASTOPTIMIZE* = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastOptimize"
  REGSTR_PATH_LASTBACKUP* = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastBackup"
  REGSTR_PATH_CHKLASTCHECK* = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive\\LastCheck"
  REGSTR_PATH_CHKLASTSURFAN* = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive\\LastSurfaceAnalysis"
  DTRESULTOK* = 0
  DTRESULTFIX* = 1
  DTRESULTPROB* = 2
  DTRESULTPART* = 3
  REGSTR_KEY_SHARES* = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\LanMan"
  REGSTR_VAL_SHARES_FLAGS* = "Flags"
  REGSTR_VAL_SHARES_TYPE* = "Type"
  REGSTR_VAL_SHARES_PATH* = "Path"
  REGSTR_VAL_SHARES_REMARK* = "Remark"
  REGSTR_VAL_SHARES_RW_PASS* = "Parm1"
  REGSTR_VAL_SHARES_RO_PASS* = "Parm2"
  REGSTR_PATH_PRINT* = "System\\CurrentControlSet\\Control\\Print"
  REGSTR_PATH_PRINTERS* = "System\\CurrentControlSet\\Control\\Print\\Printers"
  REGSTR_PATH_PROVIDERS* = "System\\CurrentControlSet\\Control\\Print\\Providers"
  REGSTR_PATH_MONITORS* = "System\\CurrentControlSet\\Control\\Print\\Monitors"
  REGSTR_PATH_ENVIRONMENTS* = "System\\CurrentControlSet\\Control\\Print\\Environments"
  REGSTR_VAL_START_ON_BOOT* = "StartOnBoot"
  REGSTR_VAL_PRINTERS_MASK* = "PrintersMask"
  REGSTR_VAL_DOS_SPOOL_MASK* = "DOSSpoolMask"
  REGSTR_KEY_CURRENT_ENV* = "\\Windows 4.0"
  REGSTR_KEY_DRIVERS* = "\\Drivers"
  REGSTR_KEY_PRINT_PROC* = "\\Print Processors"
  REGSTR_PATH_EVENTLABELS* = "AppEvents\\EventLabels"
  REGSTR_PATH_SCHEMES* = "AppEvents\\Schemes"
  REGSTR_PATH_APPS* = REGSTR_PATH_SCHEMES & "\\Apps"
  REGSTR_PATH_APPS_DEFAULT* = REGSTR_PATH_SCHEMES & "\\Apps\\.Default"
  REGSTR_PATH_NAMES* = REGSTR_PATH_SCHEMES & "\\Names"
  REGSTR_PATH_MULTIMEDIA* = REGSTR_PATH_SETUP & "\\Multimedia"
  REGSTR_PATH_MULTIMEDIA_AUDIO* = "Software\\Microsoft\\Multimedia\\Audio"
  REGSTR_PATH_MULTIMEDIA_AUDIO_IMAGES* = REGSTR_PATH_MULTIMEDIA_AUDIO & "\\Images"
  REGSTR_PATH_MEDIARESOURCES* = REGSTR_PATH_CURRENT_CONTROL_SET & "\\MediaResources"
  REGSTR_PATH_MEDIAPROPERTIES* = REGSTR_PATH_CURRENT_CONTROL_SET & "\\MediaProperties"
  REGSTR_PATH_PRIVATEPROPERTIES* = REGSTR_PATH_MEDIAPROPERTIES & "\\PrivateProperties"
  REGSTR_PATH_PUBLICPROPERTIES* = REGSTR_PATH_MEDIAPROPERTIES & "\\PublicProperties"
  REGSTR_PATH_JOYOEM* = REGSTR_PATH_PRIVATEPROPERTIES & "\\Joystick\\OEM"
  REGSTR_PATH_JOYCONFIG* = REGSTR_PATH_MEDIARESOURCES & "\\Joystick"
  REGSTR_KEY_JOYCURR* = "CurrentJoystickSettings"
  REGSTR_KEY_JOYSETTINGS* = "JoystickSettings"
  REGSTR_VAL_JOYUSERVALUES* = "JoystickUserValues"
  REGSTR_VAL_JOYCALLOUT* = "JoystickCallout"
  REGSTR_VAL_JOYNCONFIG* = "Joystick%dConfiguration"
  REGSTR_VAL_JOYNOEMNAME* = "Joystick%dOEMName"
  REGSTR_VAL_JOYNOEMCALLOUT* = "Joystick%dOEMCallout"
  REGSTR_VAL_JOYOEMCALLOUT* = "OEMCallout"
  REGSTR_VAL_JOYOEMNAME* = "OEMName"
  REGSTR_VAL_JOYOEMDATA* = "OEMData"
  REGSTR_VAL_JOYOEMXYLABEL* = "OEMXYLabel"
  REGSTR_VAL_JOYOEMZLABEL* = "OEMZLabel"
  REGSTR_VAL_JOYOEMRLABEL* = "OEMRLabel"
  REGSTR_VAL_JOYOEMPOVLABEL* = "OEMPOVLabel"
  REGSTR_VAL_JOYOEMULABEL* = "OEMULabel"
  REGSTR_VAL_JOYOEMVLABEL* = "OEMVLabel"
  REGSTR_VAL_JOYOEMTESTMOVEDESC* = "OEMTestMoveDesc"
  REGSTR_VAL_JOYOEMTESTBUTTONDESC* = "OEMTestButtonDesc"
  REGSTR_VAL_JOYOEMTESTMOVECAP* = "OEMTestMoveCap"
  REGSTR_VAL_JOYOEMTESTBUTTONCAP* = "OEMTestButtonCap"
  REGSTR_VAL_JOYOEMTESTWINCAP* = "OEMTestWinCap"
  REGSTR_VAL_JOYOEMCALCAP* = "OEMCalCap"
  REGSTR_VAL_JOYOEMCALWINCAP* = "OEMCalWinCap"
  REGSTR_VAL_JOYOEMCAL1* = "OEMCal1"
  REGSTR_VAL_JOYOEMCAL2* = "OEMCal2"
  REGSTR_VAL_JOYOEMCAL3* = "OEMCal3"
  REGSTR_VAL_JOYOEMCAL4* = "OEMCal4"
  REGSTR_VAL_JOYOEMCAL5* = "OEMCal5"
  REGSTR_VAL_JOYOEMCAL6* = "OEMCal6"
  REGSTR_VAL_JOYOEMCAL7* = "OEMCal7"
  REGSTR_VAL_JOYOEMCAL8* = "OEMCal8"
  REGSTR_VAL_JOYOEMCAL9* = "OEMCal9"
  REGSTR_VAL_JOYOEMCAL10* = "OEMCal10"
  REGSTR_VAL_JOYOEMCAL11* = "OEMCal11"
  REGSTR_VAL_JOYOEMCAL12* = "OEMCal12"
  REGSTR_VAL_AUDIO_BITMAP* = "bitmap"
  REGSTR_VAL_AUDIO_ICON* = "icon"
  REGSTR_PATH_DEVICEINSTALLER* = "Software\\Microsoft\\Windows\\CurrentVersion\\Device Installer"
  REGSTR_PATH_DIFX* = "Software\\Microsoft\\Windows\\CurrentVersion\\DIFX"
  REGSTR_VAL_SEARCHOPTIONS* = "SearchOptions"
  REGSTR_PATH_BIOSINFO* = "System\\CurrentControlSet\\Control\\BiosInfo"
  REGSTR_PATH_PCIIR* = "System\\CurrentControlSet\\Control\\Pnp\\PciIrqRouting"
  REGSTR_VAL_OPTIONS* = "Options"
  REGSTR_VAL_STAT* = "Status"
  REGSTR_VAL_TABLE_STAT* = "TableStatus"
  REGSTR_VAL_MINIPORT_STAT* = "MiniportStatus"
  PIR_OPTION_ENABLED* = 0x00000001
  PIR_OPTION_REGISTRY* = 0x00000002
  PIR_OPTION_MSSPEC* = 0x00000004
  PIR_OPTION_REALMODE* = 0x00000008
  PIR_OPTION_DEFAULT* = 0x0000000f
  PIR_STATUS_ERROR* = 0x00000000
  PIR_STATUS_ENABLED* = 0x00000001
  PIR_STATUS_DISABLED* = 0x00000002
  PIR_STATUS_MAX* = 0x00000003
  PIR_STATUS_TABLE_REGISTRY* = 0x00000000
  PIR_STATUS_TABLE_MSSPEC* = 0x00000001
  PIR_STATUS_TABLE_REALMODE* = 0x00000002
  PIR_STATUS_TABLE_NONE* = 0x00000003
  PIR_STATUS_TABLE_ERROR* = 0x00000004
  PIR_STATUS_TABLE_BAD* = 0x00000005
  PIR_STATUS_TABLE_SUCCESS* = 0x00000006
  PIR_STATUS_TABLE_MAX* = 0x00000007
  PIR_STATUS_MINIPORT_NORMAL* = 0x00000000
  PIR_STATUS_MINIPORT_COMPATIBLE* = 0x00000001
  PIR_STATUS_MINIPORT_OVERRIDE* = 0x00000002
  PIR_STATUS_MINIPORT_NONE* = 0x00000003
  PIR_STATUS_MINIPORT_ERROR* = 0x00000004
  PIR_STATUS_MINIPORT_NOKEY* = 0x00000005
  PIR_STATUS_MINIPORT_SUCCESS* = 0x00000006
  PIR_STATUS_MINIPORT_INVALID* = 0x00000007
  PIR_STATUS_MINIPORT_MAX* = 0x00000008
  REGSTR_PATH_LASTGOOD* = "System\\LastKnownGoodRecovery\\LastGood"
  REGSTR_PATH_LASTGOODTMP* = "System\\LastKnownGoodRecovery\\LastGood.Tmp"
  LASTGOOD_OPERATION* = 0x000000ff
  LASTGOOD_OPERATION_NOPOSTPROC* = 0x00000000
  LASTGOOD_OPERATION_DELETE* = 0x00000001
  REGSTR_PATH_EBD* = REGSTR_PATH_SETUP & REGSTR_KEY_SETUP & "\\EBD"
