#====================================================================
#
#          Winim - Windows API, COM, and CLR Module for Nim
#               Copyright (c) Chen Kai-Hung, Ward
#
#====================================================================
import winimbase
import windef
#include <sql.h>
#include <sqltypes.h>
#include <sqlext.h>
#include <sqlucode.h>
#include <odbcinst.h>
type
  TSQLCHAR* = uint8
  TSQLSCHAR* = int8
  TSQLDATE* = uint8
  TSQLDECIMAL* = uint8
  TSQLINTEGER* = int32
  TSQLUINTEGER* = int32
  TSQLNUMERIC* = uint8
  TSQLPOINTER* = pointer
  TSQLUSMALLINT* = uint16
  TSQLTIME* = uint8
  TSQLTIMESTAMP* = uint8
  TSQLVARCHAR* = uint8
  SDWORD* = int32
  UDWORD* = int32
  UWORD* = uint16
  SLONG* = int32
  PTR* = pointer
  TSQLINTERVAL* = int32
  ODBCINT64* = int64
  TSQLWCHAR* = uint16
  TSQLUBIGINT* = int64
  TSQLHANDLE* = HANDLE
  TSQLHENV* = HANDLE
  TSQLHDBC* = HANDLE
  TSQLHSTMT* = HANDLE
  HENV* = HANDLE
  HDBC* = HANDLE
  HSTMT* = HANDLE
  TSQLDOUBLE* = float64
  TSQLFLOAT* = float64
when winimCpu64:
  type
    TSQLULEN* = UINT64
when winimCpu32:
  type
    TSQLULEN* = TSQLUINTEGER
type
  TSQLROWCOUNT* = TSQLULEN
  TSQLROWSETSIZE* = TSQLULEN
  TSQLTRANSID* = TSQLULEN
when winimCpu64:
  type
    TSQLLEN* = INT64
when winimCpu32:
  type
    TSQLLEN* = TSQLINTEGER
type
  TSQLROWOFFSET* = TSQLLEN
  TSQLREAL* = float32
  TSQLSMALLINT* = int16
  TSQLRETURN* = TSQLSMALLINT
  TSQLHDESC* = TSQLHANDLE
  SWORD* = int16
  SSHORT* = int16
  SDOUBLE* = float64
  LDOUBLE* = float64
  SFLOAT* = float32
  RETCODE* = int16
  TSQLHWND* = HWND
  DATE_STRUCT* {.pure.} = object
    year*: TSQLSMALLINT
    month*: TSQLUSMALLINT
    day*: TSQLUSMALLINT
  TSQL_DATE_STRUCT* = DATE_STRUCT
  TIME_STRUCT* {.pure.} = object
    hour*: TSQLUSMALLINT
    minute*: TSQLUSMALLINT
    second*: TSQLUSMALLINT
  TSQL_TIME_STRUCT* = TIME_STRUCT
  TIMESTAMP_STRUCT* {.pure.} = object
    year*: TSQLSMALLINT
    month*: TSQLUSMALLINT
    day*: TSQLUSMALLINT
    hour*: TSQLUSMALLINT
    minute*: TSQLUSMALLINT
    second*: TSQLUSMALLINT
    fraction*: TSQLUINTEGER
  TSQL_TIMESTAMP_STRUCT* = TIMESTAMP_STRUCT
  TSQLBIGINT* = ODBCINT64
  TSQLGUID* = GUID
  BOOKMARK* = TSQLULEN
  ODBC_VS_ARGS_UNION1* {.pure, union.} = object
    wszArg*: ptr WCHAR
    szArg*: ptr CHAR
  ODBC_VS_ARGS_UNION2* {.pure, union.} = object
    wszCorrelation*: ptr WCHAR
    szCorrelation*: ptr CHAR
  ODBC_VS_ARGS* {.pure.} = object
    pguidEvent*: ptr GUID
    dwFlags*: DWORD
    union1*: ODBC_VS_ARGS_UNION1
    union2*: ODBC_VS_ARGS_UNION2
    RetCode*: RETCODE
  PODBC_VS_ARGS* = ptr ODBC_VS_ARGS
const
  ODBCVER* = 0x0351
  SQL_IS_YEAR* = 1
  SQL_IS_MONTH* = 2
  SQL_IS_DAY* = 3
  SQL_IS_HOUR* = 4
  SQL_IS_MINUTE* = 5
  SQL_IS_SECOND* = 6
  SQL_IS_YEAR_TO_MONTH* = 7
  SQL_IS_DAY_TO_HOUR* = 8
  SQL_IS_DAY_TO_MINUTE* = 9
  SQL_IS_DAY_TO_SECOND* = 10
  SQL_IS_HOUR_TO_MINUTE* = 11
  SQL_IS_HOUR_TO_SECOND* = 12
  SQL_IS_MINUTE_TO_SECOND* = 13
  SQL_MAX_NUMERIC_LEN* = 16
  SQL_NULL_DATA* = -1
  SQL_DATA_AT_EXEC* = -2
  SQL_SUCCESS* = 0
  SQL_SUCCESS_WITH_INFO* = 1
  SQL_NO_DATA* = 100
  SQL_INVALID_HANDLE* = -2
  SQL_STILL_EXECUTING* = 2
  SQL_NEED_DATA* = 99
  SQL_NTS* = -3
  SQL_NTSL* = -3
  SQL_MAX_MESSAGE_LENGTH* = 512
  SQL_DATE_LEN* = 10
  SQL_TIME_LEN* = 8
  SQL_TIMESTAMP_LEN* = 19
  SQL_HANDLE_ENV* = 1
  SQL_HANDLE_DBC* = 2
  SQL_HANDLE_STMT* = 3
  SQL_HANDLE_DESC* = 4
  SQL_ATTR_OUTPUT_NTS* = 10001
  SQL_ATTR_AUTO_IPD* = 10001
  SQL_ATTR_METADATA_ID* = 10014
  SQL_ATTR_APP_ROW_DESC* = 10010
  SQL_ATTR_APP_PARAM_DESC* = 10011
  SQL_ATTR_IMP_ROW_DESC* = 10012
  SQL_ATTR_IMP_PARAM_DESC* = 10013
  SQL_ATTR_CURSOR_SCROLLABLE* = -1
  SQL_ATTR_CURSOR_SENSITIVITY* = -2
  SQL_NONSCROLLABLE* = 0
  SQL_SCROLLABLE* = 1
  SQL_DESC_COUNT* = 1001
  SQL_DESC_TYPE* = 1002
  SQL_DESC_LENGTH* = 1003
  SQL_DESC_OCTET_LENGTH_PTR* = 1004
  SQL_DESC_PRECISION* = 1005
  SQL_DESC_SCALE* = 1006
  SQL_DESC_DATETIME_INTERVAL_CODE* = 1007
  SQL_DESC_NULLABLE* = 1008
  SQL_DESC_INDICATOR_PTR* = 1009
  SQL_DESC_DATA_PTR* = 1010
  SQL_DESC_NAME* = 1011
  SQL_DESC_UNNAMED* = 1012
  SQL_DESC_OCTET_LENGTH* = 1013
  SQL_DESC_ALLOC_TYPE* = 1099
  SQL_DIAG_RETURNCODE* = 1
  SQL_DIAG_NUMBER* = 2
  SQL_DIAG_ROW_COUNT* = 3
  SQL_DIAG_SQLSTATE* = 4
  SQL_DIAG_NATIVE* = 5
  SQL_DIAG_MESSAGE_TEXT* = 6
  SQL_DIAG_DYNAMIC_FUNCTION* = 7
  SQL_DIAG_CLASS_ORIGIN* = 8
  SQL_DIAG_SUBCLASS_ORIGIN* = 9
  SQL_DIAG_CONNECTION_NAME* = 10
  SQL_DIAG_SERVER_NAME* = 11
  SQL_DIAG_DYNAMIC_FUNCTION_CODE* = 12
  SQL_DIAG_ALTER_DOMAIN* = 3
  SQL_DIAG_ALTER_TABLE* = 4
  SQL_DIAG_CALL* = 7
  SQL_DIAG_CREATE_ASSERTION* = 6
  SQL_DIAG_CREATE_CHARACTER_SET* = 8
  SQL_DIAG_CREATE_COLLATION* = 10
  SQL_DIAG_CREATE_DOMAIN* = 23
  SQL_DIAG_CREATE_INDEX* = -1
  SQL_DIAG_CREATE_SCHEMA* = 64
  SQL_DIAG_CREATE_TABLE* = 77
  SQL_DIAG_CREATE_TRANSLATION* = 79
  SQL_DIAG_CREATE_VIEW* = 84
  SQL_DIAG_DELETE_WHERE* = 19
  SQL_DIAG_DROP_ASSERTION* = 24
  SQL_DIAG_DROP_CHARACTER_SET* = 25
  SQL_DIAG_DROP_COLLATION* = 26
  SQL_DIAG_DROP_DOMAIN* = 27
  SQL_DIAG_DROP_INDEX* = -2
  SQL_DIAG_DROP_SCHEMA* = 31
  SQL_DIAG_DROP_TABLE* = 32
  SQL_DIAG_DROP_TRANSLATION* = 33
  SQL_DIAG_DROP_VIEW* = 36
  SQL_DIAG_DYNAMIC_DELETE_CURSOR* = 38
  SQL_DIAG_DYNAMIC_UPDATE_CURSOR* = 81
  SQL_DIAG_GRANT* = 48
  SQL_DIAG_INSERT* = 50
  SQL_DIAG_REVOKE* = 59
  SQL_DIAG_SELECT_CURSOR* = 85
  SQL_DIAG_UNKNOWN_STATEMENT* = 0
  SQL_DIAG_UPDATE_WHERE* = 82
  SQL_UNKNOWN_TYPE* = 0
  SQL_CHAR* = 1
  SQL_NUMERIC* = 2
  SQL_DECIMAL* = 3
  SQL_INTEGER* = 4
  SQL_SMALLINT* = 5
  SQL_FLOAT* = 6
  SQL_REAL* = 7
  SQL_DOUBLE* = 8
  SQL_DATETIME* = 9
  SQL_VARCHAR* = 12
  SQL_TYPE_DATE* = 91
  SQL_TYPE_TIME* = 92
  SQL_TYPE_TIMESTAMP* = 93
  SQL_UNSPECIFIED* = 0
  SQL_INSENSITIVE* = 1
  SQL_SENSITIVE* = 2
  SQL_ALL_TYPES* = 0
  SQL_DEFAULT* = 99
  SQL_ARD_TYPE* = -99
  SQL_CODE_DATE* = 1
  SQL_CODE_TIME* = 2
  SQL_CODE_TIMESTAMP* = 3
  SQL_FALSE* = 0
  SQL_TRUE* = 1
  SQL_NO_NULLS* = 0
  SQL_NULLABLE* = 1
  SQL_NULLABLE_UNKNOWN* = 2
  SQL_PRED_NONE* = 0
  SQL_PRED_CHAR* = 1
  SQL_PRED_BASIC* = 2
  SQL_NAMED* = 0
  SQL_UNNAMED* = 1
  SQL_DESC_ALLOC_AUTO* = 1
  SQL_DESC_ALLOC_USER* = 2
  SQL_CLOSE* = 0
  SQL_DROP* = 1
  SQL_UNBIND* = 2
  SQL_RESET_PARAMS* = 3
  SQL_FETCH_NEXT* = 1
  SQL_FETCH_FIRST* = 2
  SQL_FETCH_LAST* = 3
  SQL_FETCH_PRIOR* = 4
  SQL_FETCH_ABSOLUTE* = 5
  SQL_FETCH_RELATIVE* = 6
  SQL_COMMIT* = 0
  SQL_ROLLBACK* = 1
  SQL_NULL_HENV* = 0
  SQL_NULL_HDBC* = 0
  SQL_NULL_HSTMT* = 0
  SQL_NULL_HDESC* = 0
  SQL_NULL_HANDLE* = 0
  SQL_SCOPE_CURROW* = 0
  SQL_SCOPE_TRANSACTION* = 1
  SQL_SCOPE_SESSION* = 2
  SQL_PC_UNKNOWN* = 0
  SQL_PC_NON_PSEUDO* = 1
  SQL_PC_PSEUDO* = 2
  SQL_ROW_IDENTIFIER* = 1
  SQL_INDEX_UNIQUE* = 0
  SQL_INDEX_ALL* = 1
  SQL_INDEX_CLUSTERED* = 1
  SQL_INDEX_HASHED* = 2
  SQL_INDEX_OTHER* = 3
  SQL_API_SQLALLOCCONNECT* = 1
  SQL_API_SQLALLOCENV* = 2
  SQL_API_SQLALLOCHANDLE* = 1001
  SQL_API_SQLALLOCSTMT* = 3
  SQL_API_SQLBINDCOL* = 4
  SQL_API_SQLBINDPARAM* = 1002
  SQL_API_SQLCANCEL* = 5
  SQL_API_SQLCLOSECURSOR* = 1003
  SQL_API_SQLCOLATTRIBUTE* = 6
  SQL_API_SQLCOLUMNS* = 40
  SQL_API_SQLCONNECT* = 7
  SQL_API_SQLCOPYDESC* = 1004
  SQL_API_SQLDATASOURCES* = 57
  SQL_API_SQLDESCRIBECOL* = 8
  SQL_API_SQLDISCONNECT* = 9
  SQL_API_SQLENDTRAN* = 1005
  SQL_API_SQLERROR* = 10
  SQL_API_SQLEXECDIRECT* = 11
  SQL_API_SQLEXECUTE* = 12
  SQL_API_SQLFETCH* = 13
  SQL_API_SQLFETCHSCROLL* = 1021
  SQL_API_SQLFREECONNECT* = 14
  SQL_API_SQLFREEENV* = 15
  SQL_API_SQLFREEHANDLE* = 1006
  SQL_API_SQLFREESTMT* = 16
  SQL_API_SQLGETCONNECTATTR* = 1007
  SQL_API_SQLGETCONNECTOPTION* = 42
  SQL_API_SQLGETCURSORNAME* = 17
  SQL_API_SQLGETDATA* = 43
  SQL_API_SQLGETDESCFIELD* = 1008
  SQL_API_SQLGETDESCREC* = 1009
  SQL_API_SQLGETDIAGFIELD* = 1010
  SQL_API_SQLGETDIAGREC* = 1011
  SQL_API_SQLGETENVATTR* = 1012
  SQL_API_SQLGETFUNCTIONS* = 44
  SQL_API_SQLGETINFO* = 45
  SQL_API_SQLGETSTMTATTR* = 1014
  SQL_API_SQLGETSTMTOPTION* = 46
  SQL_API_SQLGETTYPEINFO* = 47
  SQL_API_SQLNUMRESULTCOLS* = 18
  SQL_API_SQLPARAMDATA* = 48
  SQL_API_SQLPREPARE* = 19
  SQL_API_SQLPUTDATA* = 49
  SQL_API_SQLROWCOUNT* = 20
  SQL_API_SQLSETCONNECTATTR* = 1016
  SQL_API_SQLSETCONNECTOPTION* = 50
  SQL_API_SQLSETCURSORNAME* = 21
  SQL_API_SQLSETDESCFIELD* = 1017
  SQL_API_SQLSETDESCREC* = 1018
  SQL_API_SQLSETENVATTR* = 1019
  SQL_API_SQLSETPARAM* = 22
  SQL_API_SQLSETSTMTATTR* = 1020
  SQL_API_SQLSETSTMTOPTION* = 51
  SQL_API_SQLSPECIALCOLUMNS* = 52
  SQL_API_SQLSTATISTICS* = 53
  SQL_API_SQLTABLES* = 54
  SQL_API_SQLTRANSACT* = 23
  SQL_MAX_DRIVER_CONNECTIONS* = 0
  SQL_MAXIMUM_DRIVER_CONNECTIONS* = SQL_MAX_DRIVER_CONNECTIONS
  SQL_MAX_CONCURRENT_ACTIVITIES* = 1
  SQL_MAXIMUM_CONCURRENT_ACTIVITIES* = SQL_MAX_CONCURRENT_ACTIVITIES
  SQL_DATA_SOURCE_NAME* = 2
  SQL_FETCH_DIRECTION* = 8
  SQL_SERVER_NAME* = 13
  SQL_SEARCH_PATTERN_ESCAPE* = 14
  SQL_DBMS_NAME* = 17
  SQL_DBMS_VER* = 18
  SQL_ACCESSIBLE_TABLES* = 19
  SQL_ACCESSIBLE_PROCEDURES* = 20
  SQL_CURSOR_COMMIT_BEHAVIOR* = 23
  SQL_DATA_SOURCE_READ_ONLY* = 25
  SQL_DEFAULT_TXN_ISOLATION* = 26
  SQL_IDENTIFIER_CASE* = 28
  SQL_IDENTIFIER_QUOTE_CHAR* = 29
  SQL_MAX_COLUMN_NAME_LEN* = 30
  SQL_MAXIMUM_COLUMN_NAME_LENGTH* = SQL_MAX_COLUMN_NAME_LEN
  SQL_MAX_CURSOR_NAME_LEN* = 31
  SQL_MAXIMUM_CURSOR_NAME_LENGTH* = SQL_MAX_CURSOR_NAME_LEN
  SQL_MAX_SCHEMA_NAME_LEN* = 32
  SQL_MAXIMUM_SCHEMA_NAME_LENGTH* = SQL_MAX_SCHEMA_NAME_LEN
  SQL_MAX_CATALOG_NAME_LEN* = 34
  SQL_MAXIMUM_CATALOG_NAME_LENGTH* = SQL_MAX_CATALOG_NAME_LEN
  SQL_MAX_TABLE_NAME_LEN* = 35
  SQL_SCROLL_CONCURRENCY* = 43
  SQL_TXN_CAPABLE* = 46
  SQL_TRANSACTION_CAPABLE* = SQL_TXN_CAPABLE
  SQL_USER_NAME* = 47
  SQL_TXN_ISOLATION_OPTION* = 72
  SQL_TRANSACTION_ISOLATION_OPTION* = SQL_TXN_ISOLATION_OPTION
  SQL_INTEGRITY* = 73
  SQL_GETDATA_EXTENSIONS* = 81
  SQL_NULL_COLLATION* = 85
  SQL_ALTER_TABLE* = 86
  SQL_ORDER_BY_COLUMNS_IN_SELECT* = 90
  SQL_SPECIAL_CHARACTERS* = 94
  SQL_MAX_COLUMNS_IN_GROUP_BY* = 97
  SQL_MAXIMUM_COLUMNS_IN_GROUP_BY* = SQL_MAX_COLUMNS_IN_GROUP_BY
  SQL_MAX_COLUMNS_IN_INDEX* = 98
  SQL_MAXIMUM_COLUMNS_IN_INDEX* = SQL_MAX_COLUMNS_IN_INDEX
  SQL_MAX_COLUMNS_IN_ORDER_BY* = 99
  SQL_MAXIMUM_COLUMNS_IN_ORDER_BY* = SQL_MAX_COLUMNS_IN_ORDER_BY
  SQL_MAX_COLUMNS_IN_SELECT* = 100
  SQL_MAXIMUM_COLUMNS_IN_SELECT* = SQL_MAX_COLUMNS_IN_SELECT
  SQL_MAX_COLUMNS_IN_TABLE* = 101
  SQL_MAX_INDEX_SIZE* = 102
  SQL_MAXIMUM_INDEX_SIZE* = SQL_MAX_INDEX_SIZE
  SQL_MAX_ROW_SIZE* = 104
  SQL_MAXIMUM_ROW_SIZE* = SQL_MAX_ROW_SIZE
  SQL_MAX_STATEMENT_LEN* = 105
  SQL_MAXIMUM_STATEMENT_LENGTH* = SQL_MAX_STATEMENT_LEN
  SQL_MAX_TABLES_IN_SELECT* = 106
  SQL_MAXIMUM_TABLES_IN_SELECT* = SQL_MAX_TABLES_IN_SELECT
  SQL_MAX_USER_NAME_LEN* = 107
  SQL_MAXIMUM_USER_NAME_LENGTH* = SQL_MAX_USER_NAME_LEN
  SQL_OJ_CAPABILITIES* = 115
  SQL_OUTER_JOIN_CAPABILITIES* = SQL_OJ_CAPABILITIES
  SQL_XOPEN_CLI_YEAR* = 10000
  SQL_CURSOR_SENSITIVITY* = 10001
  SQL_DESCRIBE_PARAMETER* = 10002
  SQL_CATALOG_NAME* = 10003
  SQL_COLLATION_SEQ* = 10004
  SQL_MAX_IDENTIFIER_LEN* = 10005
  SQL_MAXIMUM_IDENTIFIER_LENGTH* = SQL_MAX_IDENTIFIER_LEN
  SQL_AT_ADD_COLUMN* = 0x00000001
  SQL_AT_DROP_COLUMN* = 0x00000002
  SQL_AT_ADD_CONSTRAINT* = 0x00000008
  SQL_AM_NONE* = 0
  SQL_AM_CONNECTION* = 1
  SQL_AM_STATEMENT* = 2
  SQL_CB_DELETE* = 0
  SQL_CB_CLOSE* = 1
  SQL_CB_PRESERVE* = 2
  SQL_FD_FETCH_NEXT* = 0x00000001
  SQL_FD_FETCH_FIRST* = 0x00000002
  SQL_FD_FETCH_LAST* = 0x00000004
  SQL_FD_FETCH_PRIOR* = 0x00000008
  SQL_FD_FETCH_ABSOLUTE* = 0x00000010
  SQL_FD_FETCH_RELATIVE* = 0x00000020
  SQL_GD_ANY_COLUMN* = 0x00000001
  SQL_GD_ANY_ORDER* = 0x00000002
  SQL_IC_UPPER* = 1
  SQL_IC_LOWER* = 2
  SQL_IC_SENSITIVE* = 3
  SQL_IC_MIXED* = 4
  SQL_OJ_LEFT* = 0x00000001
  SQL_OJ_RIGHT* = 0x00000002
  SQL_OJ_FULL* = 0x00000004
  SQL_OJ_NESTED* = 0x00000008
  SQL_OJ_NOT_ORDERED* = 0x00000010
  SQL_OJ_INNER* = 0x00000020
  SQL_OJ_ALL_COMPARISON_OPS* = 0x00000040
  SQL_SCCO_READ_ONLY* = 0x00000001
  SQL_SCCO_LOCK* = 0x00000002
  SQL_SCCO_OPT_ROWVER* = 0x00000004
  SQL_SCCO_OPT_VALUES* = 0x00000008
  SQL_TC_NONE* = 0
  SQL_TC_DML* = 1
  SQL_TC_ALL* = 2
  SQL_TC_DDL_COMMIT* = 3
  SQL_TC_DDL_IGNORE* = 4
  SQL_TXN_READ_UNCOMMITTED* = 0x00000001
  SQL_TRANSACTION_READ_UNCOMMITTED* = SQL_TXN_READ_UNCOMMITTED
  SQL_TXN_READ_COMMITTED* = 0x00000002
  SQL_TRANSACTION_READ_COMMITTED* = SQL_TXN_READ_COMMITTED
  SQL_TXN_REPEATABLE_READ* = 0x00000004
  SQL_TRANSACTION_REPEATABLE_READ* = SQL_TXN_REPEATABLE_READ
  SQL_TXN_SERIALIZABLE* = 0x00000008
  SQL_TRANSACTION_SERIALIZABLE* = SQL_TXN_SERIALIZABLE
  SQL_NC_HIGH* = 0
  SQL_NC_LOW* = 1
  SQL_SPEC_MAJOR* = 3
  SQL_SPEC_MINOR* = 52
  SQL_SPEC_STRING* = "03.52"
  SQL_SQLSTATE_SIZE* = 5
  SQL_MAX_DSN_LENGTH* = 32
  SQL_MAX_OPTION_STRING_LENGTH* = 256
  SQL_HANDLE_SENV* = 5
  SQL_ATTR_ODBC_VERSION* = 200
  SQL_ATTR_CONNECTION_POOLING* = 201
  SQL_ATTR_CP_MATCH* = 202
  SQL_CP_OFF* = 0
  SQL_CP_ONE_PER_DRIVER* = 1
  SQL_CP_ONE_PER_HENV* = 2
  SQL_CP_DEFAULT* = SQL_CP_OFF
  SQL_CP_STRICT_MATCH* = 0
  SQL_CP_RELAXED_MATCH* = 1
  SQL_CP_MATCH_DEFAULT* = SQL_CP_STRICT_MATCH
  SQL_OV_ODBC2* = 2
  SQL_OV_ODBC3* = 3
  SQL_ACCESS_MODE* = 101
  SQL_AUTOCOMMIT* = 102
  SQL_LOGIN_TIMEOUT* = 103
  SQL_OPT_TRACE* = 104
  SQL_OPT_TRACEFILE* = 105
  SQL_TRANSLATE_DLL* = 106
  SQL_TRANSLATE_OPTION* = 107
  SQL_TXN_ISOLATION* = 108
  SQL_CURRENT_QUALIFIER* = 109
  SQL_ODBC_CURSORS* = 110
  SQL_QUIET_MODE* = 111
  SQL_PACKET_SIZE* = 112
  SQL_ATTR_ACCESS_MODE* = SQL_ACCESS_MODE
  SQL_ATTR_AUTOCOMMIT* = SQL_AUTOCOMMIT
  SQL_ATTR_CONNECTION_TIMEOUT* = 113
  SQL_ATTR_CURRENT_CATALOG* = SQL_CURRENT_QUALIFIER
  SQL_ATTR_DISCONNECT_BEHAVIOR* = 114
  SQL_ATTR_ENLIST_IN_DTC* = 1207
  SQL_ATTR_ENLIST_IN_XA* = 1208
  SQL_ATTR_LOGIN_TIMEOUT* = SQL_LOGIN_TIMEOUT
  SQL_ATTR_ODBC_CURSORS* = SQL_ODBC_CURSORS
  SQL_ATTR_PACKET_SIZE* = SQL_PACKET_SIZE
  SQL_ATTR_QUIET_MODE* = SQL_QUIET_MODE
  SQL_ATTR_TRACE* = SQL_OPT_TRACE
  SQL_ATTR_TRACEFILE* = SQL_OPT_TRACEFILE
  SQL_ATTR_TRANSLATE_LIB* = SQL_TRANSLATE_DLL
  SQL_ATTR_TRANSLATE_OPTION* = SQL_TRANSLATE_OPTION
  SQL_ATTR_TXN_ISOLATION* = SQL_TXN_ISOLATION
  SQL_ATTR_CONNECTION_DEAD* = 1209
  SQL_ATTR_ANSI_APP* = 115
  SQL_MODE_READ_WRITE* = 0
  SQL_MODE_READ_ONLY* = 1
  SQL_MODE_DEFAULT* = SQL_MODE_READ_WRITE
  SQL_AUTOCOMMIT_OFF* = 0
  SQL_AUTOCOMMIT_ON* = 1
  SQL_AUTOCOMMIT_DEFAULT* = SQL_AUTOCOMMIT_ON
  SQL_LOGIN_TIMEOUT_DEFAULT* = 15
  SQL_OPT_TRACE_OFF* = 0
  SQL_OPT_TRACE_ON* = 1
  SQL_OPT_TRACE_DEFAULT* = SQL_OPT_TRACE_OFF
  SQL_OPT_TRACE_FILE_DEFAULT* = "\\SQL.LOG"
  SQL_CUR_USE_IF_NEEDED* = 0
  SQL_CUR_USE_ODBC* = 1
  SQL_CUR_USE_DRIVER* = 2
  SQL_CUR_DEFAULT* = SQL_CUR_USE_DRIVER
  SQL_DB_RETURN_TO_POOL* = 0
  SQL_DB_DISCONNECT* = 1
  SQL_DB_DEFAULT* = SQL_DB_RETURN_TO_POOL
  SQL_DTC_DONE* = 0
  SQL_CD_TRUE* = 1
  SQL_CD_FALSE* = 0
  SQL_AA_TRUE* = 1
  SQL_AA_FALSE* = 0
  SQL_QUERY_TIMEOUT* = 0
  SQL_MAX_ROWS* = 1
  SQL_NOSCAN* = 2
  SQL_MAX_LENGTH* = 3
  SQL_ASYNC_ENABLE* = 4
  SQL_BIND_TYPE* = 5
  SQL_CURSOR_TYPE* = 6
  SQL_CONCURRENCY* = 7
  SQL_KEYSET_SIZE* = 8
  SQL_ROWSET_SIZE* = 9
  SQL_SIMULATE_CURSOR* = 10
  SQL_RETRIEVE_DATA* = 11
  SQL_USE_BOOKMARKS* = 12
  SQL_GET_BOOKMARK* = 13
  SQL_ROW_NUMBER* = 14
  SQL_ATTR_ASYNC_ENABLE* = 4
  SQL_ATTR_CONCURRENCY* = SQL_CONCURRENCY
  SQL_ATTR_CURSOR_TYPE* = SQL_CURSOR_TYPE
  SQL_ATTR_ENABLE_AUTO_IPD* = 15
  SQL_ATTR_FETCH_BOOKMARK_PTR* = 16
  SQL_ATTR_KEYSET_SIZE* = SQL_KEYSET_SIZE
  SQL_ATTR_MAX_LENGTH* = SQL_MAX_LENGTH
  SQL_ATTR_MAX_ROWS* = SQL_MAX_ROWS
  SQL_ATTR_NOSCAN* = SQL_NOSCAN
  SQL_ATTR_PARAM_BIND_OFFSET_PTR* = 17
  SQL_ATTR_PARAM_BIND_TYPE* = 18
  SQL_ATTR_PARAM_OPERATION_PTR* = 19
  SQL_ATTR_PARAM_STATUS_PTR* = 20
  SQL_ATTR_PARAMS_PROCESSED_PTR* = 21
  SQL_ATTR_PARAMSET_SIZE* = 22
  SQL_ATTR_QUERY_TIMEOUT* = SQL_QUERY_TIMEOUT
  SQL_ATTR_RETRIEVE_DATA* = SQL_RETRIEVE_DATA
  SQL_ATTR_ROW_BIND_OFFSET_PTR* = 23
  SQL_ATTR_ROW_BIND_TYPE* = SQL_BIND_TYPE
  SQL_ATTR_ROW_NUMBER* = SQL_ROW_NUMBER
  SQL_ATTR_ROW_OPERATION_PTR* = 24
  SQL_ATTR_ROW_STATUS_PTR* = 25
  SQL_ATTR_ROWS_FETCHED_PTR* = 26
  SQL_ATTR_ROW_ARRAY_SIZE* = 27
  SQL_ATTR_SIMULATE_CURSOR* = SQL_SIMULATE_CURSOR
  SQL_ATTR_USE_BOOKMARKS* = SQL_USE_BOOKMARKS
  SQL_LIKE_ONLY* = 1
  SQL_COL_PRED_CHAR* = SQL_LIKE_ONLY
  SQL_ALL_EXCEPT_LIKE* = 2
  SQL_COL_PRED_BASIC* = SQL_ALL_EXCEPT_LIKE
  SQL_IS_POINTER* = -4
  SQL_IS_UINTEGER* = -5
  SQL_IS_INTEGER* = -6
  SQL_IS_USMALLINT* = -7
  SQL_IS_SMALLINT* = -8
  SQL_PARAM_BIND_BY_COLUMN* = 0
  SQL_PARAM_BIND_TYPE_DEFAULT* = SQL_PARAM_BIND_BY_COLUMN
  SQL_QUERY_TIMEOUT_DEFAULT* = 0
  SQL_MAX_ROWS_DEFAULT* = 0
  SQL_NOSCAN_OFF* = 0
  SQL_NOSCAN_ON* = 1
  SQL_NOSCAN_DEFAULT* = SQL_NOSCAN_OFF
  SQL_MAX_LENGTH_DEFAULT* = 0
  SQL_ASYNC_ENABLE_OFF* = 0
  SQL_ASYNC_ENABLE_ON* = 1
  SQL_ASYNC_ENABLE_DEFAULT* = SQL_ASYNC_ENABLE_OFF
  SQL_BIND_BY_COLUMN* = 0
  SQL_BIND_TYPE_DEFAULT* = SQL_BIND_BY_COLUMN
  SQL_CONCUR_READ_ONLY* = 1
  SQL_CONCUR_LOCK* = 2
  SQL_CONCUR_ROWVER* = 3
  SQL_CONCUR_VALUES* = 4
  SQL_CONCUR_DEFAULT* = SQL_CONCUR_READ_ONLY
  SQL_CURSOR_FORWARD_ONLY* = 0
  SQL_CURSOR_KEYSET_DRIVEN* = 1
  SQL_CURSOR_DYNAMIC* = 2
  SQL_CURSOR_STATIC* = 3
  SQL_CURSOR_TYPE_DEFAULT* = SQL_CURSOR_FORWARD_ONLY
  SQL_ROWSET_SIZE_DEFAULT* = 1
  SQL_KEYSET_SIZE_DEFAULT* = 0
  SQL_SC_NON_UNIQUE* = 0
  SQL_SC_TRY_UNIQUE* = 1
  SQL_SC_UNIQUE* = 2
  SQL_RD_OFF* = 0
  SQL_RD_ON* = 1
  SQL_RD_DEFAULT* = SQL_RD_ON
  SQL_UB_OFF* = 0
  SQL_UB_ON* = 01
  SQL_UB_DEFAULT* = SQL_UB_OFF
  SQL_UB_FIXED* = SQL_UB_ON
  SQL_UB_VARIABLE* = 2
  SQL_DESC_ARRAY_SIZE* = 20
  SQL_DESC_ARRAY_STATUS_PTR* = 21
  SQL_COLUMN_AUTO_INCREMENT* = 11
  SQL_DESC_AUTO_UNIQUE_VALUE* = SQL_COLUMN_AUTO_INCREMENT
  SQL_DESC_BASE_COLUMN_NAME* = 22
  SQL_DESC_BASE_TABLE_NAME* = 23
  SQL_DESC_BIND_OFFSET_PTR* = 24
  SQL_DESC_BIND_TYPE* = 25
  SQL_COLUMN_CASE_SENSITIVE* = 12
  SQL_DESC_CASE_SENSITIVE* = SQL_COLUMN_CASE_SENSITIVE
  SQL_COLUMN_QUALIFIER_NAME* = 17
  SQL_DESC_CATALOG_NAME* = SQL_COLUMN_QUALIFIER_NAME
  SQL_COLUMN_TYPE* = 2
  SQL_DESC_CONCISE_TYPE* = SQL_COLUMN_TYPE
  SQL_DESC_DATETIME_INTERVAL_PRECISION* = 26
  SQL_COLUMN_DISPLAY_SIZE* = 6
  SQL_DESC_DISPLAY_SIZE* = SQL_COLUMN_DISPLAY_SIZE
  SQL_COLUMN_MONEY* = 9
  SQL_DESC_FIXED_PREC_SCALE* = SQL_COLUMN_MONEY
  SQL_COLUMN_LABEL* = 18
  SQL_DESC_LABEL* = SQL_COLUMN_LABEL
  SQL_DESC_LITERAL_PREFIX* = 27
  SQL_DESC_LITERAL_SUFFIX* = 28
  SQL_DESC_LOCAL_TYPE_NAME* = 29
  SQL_DESC_MAXIMUM_SCALE* = 30
  SQL_DESC_MINIMUM_SCALE* = 31
  SQL_DESC_NUM_PREC_RADIX* = 32
  SQL_DESC_PARAMETER_TYPE* = 33
  SQL_DESC_ROWS_PROCESSED_PTR* = 34
  SQL_COLUMN_OWNER_NAME* = 16
  SQL_DESC_SCHEMA_NAME* = SQL_COLUMN_OWNER_NAME
  SQL_COLUMN_SEARCHABLE* = 13
  SQL_DESC_SEARCHABLE* = SQL_COLUMN_SEARCHABLE
  SQL_COLUMN_TYPE_NAME* = 14
  SQL_DESC_TYPE_NAME* = SQL_COLUMN_TYPE_NAME
  SQL_COLUMN_TABLE_NAME* = 15
  SQL_DESC_TABLE_NAME* = SQL_COLUMN_TABLE_NAME
  SQL_COLUMN_UNSIGNED* = 8
  SQL_DESC_UNSIGNED* = SQL_COLUMN_UNSIGNED
  SQL_COLUMN_UPDATABLE* = 10
  SQL_DESC_UPDATABLE* = SQL_COLUMN_UPDATABLE
  SQL_DIAG_CURSOR_ROW_COUNT* = -1249
  SQL_DIAG_ROW_NUMBER* = -1248
  SQL_DIAG_COLUMN_NUMBER* = -1247
  SQL_DATE* = 9
  SQL_INTERVAL* = 10
  SQL_TIME* = 10
  SQL_TIMESTAMP* = 11
  SQL_LONGVARCHAR* = -1
  SQL_BINARY* = -2
  SQL_VARBINARY* = -3
  SQL_LONGVARBINARY* = -4
  SQL_BIGINT* = -5
  SQL_TINYINT* = -6
  SQL_BIT* = -7
  SQL_GUID* = -11
  SQL_CODE_YEAR* = 1
  SQL_CODE_MONTH* = 2
  SQL_CODE_DAY* = 3
  SQL_CODE_HOUR* = 4
  SQL_CODE_MINUTE* = 5
  SQL_CODE_SECOND* = 6
  SQL_CODE_YEAR_TO_MONTH* = 7
  SQL_CODE_DAY_TO_HOUR* = 8
  SQL_CODE_DAY_TO_MINUTE* = 9
  SQL_CODE_DAY_TO_SECOND* = 10
  SQL_CODE_HOUR_TO_MINUTE* = 11
  SQL_CODE_HOUR_TO_SECOND* = 12
  SQL_CODE_MINUTE_TO_SECOND* = 13
  SQL_INTERVAL_YEAR* = 100+SQL_CODE_YEAR
  SQL_INTERVAL_MONTH* = 100+SQL_CODE_MONTH
  SQL_INTERVAL_DAY* = 100+SQL_CODE_DAY
  SQL_INTERVAL_HOUR* = 100+SQL_CODE_HOUR
  SQL_INTERVAL_MINUTE* = 100+SQL_CODE_MINUTE
  SQL_INTERVAL_SECOND* = 100+SQL_CODE_SECOND
  SQL_INTERVAL_YEAR_TO_MONTH* = 100+SQL_CODE_YEAR_TO_MONTH
  SQL_INTERVAL_DAY_TO_HOUR* = 100+SQL_CODE_DAY_TO_HOUR
  SQL_INTERVAL_DAY_TO_MINUTE* = 100+SQL_CODE_DAY_TO_MINUTE
  SQL_INTERVAL_DAY_TO_SECOND* = 100+SQL_CODE_DAY_TO_SECOND
  SQL_INTERVAL_HOUR_TO_MINUTE* = 100+SQL_CODE_HOUR_TO_MINUTE
  SQL_INTERVAL_HOUR_TO_SECOND* = 100+SQL_CODE_HOUR_TO_SECOND
  SQL_INTERVAL_MINUTE_TO_SECOND* = 100+SQL_CODE_MINUTE_TO_SECOND
  SQL_WCHAR* = -8
  SQL_UNICODE* = SQL_WCHAR
  SQL_WVARCHAR* = -9
  SQL_UNICODE_VARCHAR* = SQL_WVARCHAR
  SQL_WLONGVARCHAR* = -10
  SQL_UNICODE_LONGVARCHAR* = SQL_WLONGVARCHAR
  SQL_UNICODE_CHAR* = SQL_WCHAR
  SQL_C_CHAR* = SQL_CHAR
  SQL_C_LONG* = SQL_INTEGER
  SQL_C_SHORT* = SQL_SMALLINT
  SQL_C_FLOAT* = SQL_REAL
  SQL_C_DOUBLE* = SQL_DOUBLE
  SQL_C_NUMERIC* = SQL_NUMERIC
  SQL_C_DEFAULT* = 99
  SQL_SIGNED_OFFSET* = -20
  SQL_UNSIGNED_OFFSET* = -22
  SQL_C_DATE* = SQL_DATE
  SQL_C_TIME* = SQL_TIME
  SQL_C_TIMESTAMP* = SQL_TIMESTAMP
  SQL_C_TYPE_DATE* = SQL_TYPE_DATE
  SQL_C_TYPE_TIME* = SQL_TYPE_TIME
  SQL_C_TYPE_TIMESTAMP* = SQL_TYPE_TIMESTAMP
  SQL_C_INTERVAL_YEAR* = SQL_INTERVAL_YEAR
  SQL_C_INTERVAL_MONTH* = SQL_INTERVAL_MONTH
  SQL_C_INTERVAL_DAY* = SQL_INTERVAL_DAY
  SQL_C_INTERVAL_HOUR* = SQL_INTERVAL_HOUR
  SQL_C_INTERVAL_MINUTE* = SQL_INTERVAL_MINUTE
  SQL_C_INTERVAL_SECOND* = SQL_INTERVAL_SECOND
  SQL_C_INTERVAL_YEAR_TO_MONTH* = SQL_INTERVAL_YEAR_TO_MONTH
  SQL_C_INTERVAL_DAY_TO_HOUR* = SQL_INTERVAL_DAY_TO_HOUR
  SQL_C_INTERVAL_DAY_TO_MINUTE* = SQL_INTERVAL_DAY_TO_MINUTE
  SQL_C_INTERVAL_DAY_TO_SECOND* = SQL_INTERVAL_DAY_TO_SECOND
  SQL_C_INTERVAL_HOUR_TO_MINUTE* = SQL_INTERVAL_HOUR_TO_MINUTE
  SQL_C_INTERVAL_HOUR_TO_SECOND* = SQL_INTERVAL_HOUR_TO_SECOND
  SQL_C_INTERVAL_MINUTE_TO_SECOND* = SQL_INTERVAL_MINUTE_TO_SECOND
  SQL_C_BINARY* = SQL_BINARY
  SQL_C_BIT* = SQL_BIT
  SQL_C_SBIGINT* = SQL_BIGINT+SQL_SIGNED_OFFSET
  SQL_C_UBIGINT* = SQL_BIGINT+SQL_UNSIGNED_OFFSET
  SQL_C_TINYINT* = SQL_TINYINT
  SQL_C_SLONG* = SQL_C_LONG+SQL_SIGNED_OFFSET
  SQL_C_SSHORT* = SQL_C_SHORT+SQL_SIGNED_OFFSET
  SQL_C_STINYINT* = SQL_TINYINT+SQL_SIGNED_OFFSET
  SQL_C_ULONG* = SQL_C_LONG+SQL_UNSIGNED_OFFSET
  SQL_C_USHORT* = SQL_C_SHORT+SQL_UNSIGNED_OFFSET
  SQL_C_UTINYINT* = SQL_TINYINT+SQL_UNSIGNED_OFFSET
  SQL_C_GUID* = SQL_GUID
  SQL_TYPE_NULL* = 0
  SQL_C_VARBOOKMARK* = SQL_C_BINARY
  SQL_NO_ROW_NUMBER* = -1
  SQL_NO_COLUMN_NUMBER* = -1
  SQL_ROW_NUMBER_UNKNOWN* = -2
  SQL_COLUMN_NUMBER_UNKNOWN* = -2
  SQL_DEFAULT_PARAM* = -5
  SQL_IGNORE* = -6
  SQL_COLUMN_IGNORE* = SQL_IGNORE
  SQL_LEN_DATA_AT_EXEC_OFFSET* = -100
  SQL_LEN_BINARY_ATTR_OFFSET* = -100
  SQL_PARAM_INPUT_OUTPUT* = 2
  SQL_PARAM_TYPE_DEFAULT* = SQL_PARAM_INPUT_OUTPUT
  SQL_SETPARAM_VALUE_MAX* = -1
  SQL_COLUMN_COUNT* = 0
  SQL_COLUMN_NAME* = 1
  SQL_COLUMN_LENGTH* = 3
  SQL_COLUMN_PRECISION* = 4
  SQL_COLUMN_SCALE* = 5
  SQL_COLUMN_NULLABLE* = 7
  SQL_COLATT_OPT_MAX* = SQL_COLUMN_LABEL
  SQL_COLATT_OPT_MIN* = SQL_COLUMN_COUNT
  SQL_ATTR_READONLY* = 0
  SQL_ATTR_WRITE* = 1
  SQL_ATTR_READWRITE_UNKNOWN* = 2
  SQL_UNSEARCHABLE* = 0
  SQL_SEARCHABLE* = 3
  SQL_PRED_SEARCHABLE* = SQL_SEARCHABLE
  SQL_NO_TOTAL* = -4
  SQL_API_SQLALLOCHANDLESTD* = 73
  SQL_API_SQLBULKOPERATIONS* = 24
  SQL_API_SQLBINDPARAMETER* = 72
  SQL_API_SQLBROWSECONNECT* = 55
  SQL_API_SQLCOLATTRIBUTES* = 6
  SQL_API_SQLCOLUMNPRIVILEGES* = 56
  SQL_API_SQLDESCRIBEPARAM* = 58
  SQL_API_SQLDRIVERCONNECT* = 41
  SQL_API_SQLDRIVERS* = 71
  SQL_API_SQLEXTENDEDFETCH* = 59
  SQL_API_SQLFOREIGNKEYS* = 60
  SQL_API_SQLMORERESULTS* = 61
  SQL_API_SQLNATIVESQL* = 62
  SQL_API_SQLNUMPARAMS* = 63
  SQL_API_SQLPARAMOPTIONS* = 64
  SQL_API_SQLPRIMARYKEYS* = 65
  SQL_API_SQLPROCEDURECOLUMNS* = 66
  SQL_API_SQLPROCEDURES* = 67
  SQL_API_SQLSETPOS* = 68
  SQL_API_SQLSETSCROLLOPTIONS* = 69
  SQL_API_SQLTABLEPRIVILEGES* = 70
  SQL_API_ALL_FUNCTIONS* = 0
  SQL_API_LOADBYORDINAL* = 199
  SQL_API_ODBC3_ALL_FUNCTIONS* = 999
  SQL_API_ODBC3_ALL_FUNCTIONS_SIZE* = 250
  SQL_INFO_FIRST* = 0
  SQL_ACTIVE_CONNECTIONS* = 0
  SQL_ACTIVE_STATEMENTS* = 1
  SQL_DRIVER_HDBC* = 3
  SQL_DRIVER_HENV* = 4
  SQL_DRIVER_HSTMT* = 5
  SQL_DRIVER_NAME* = 6
  SQL_DRIVER_VER* = 7
  SQL_ODBC_API_CONFORMANCE* = 9
  SQL_ODBC_VER* = 10
  SQL_ROW_UPDATES* = 11
  SQL_ODBC_SAG_CLI_CONFORMANCE* = 12
  SQL_ODBC_SQL_CONFORMANCE* = 15
  sqlProcedures* = 21
  SQL_CONCAT_NULL_BEHAVIOR* = 22
  SQL_CURSOR_ROLLBACK_BEHAVIOR* = 24
  SQL_EXPRESSIONS_IN_ORDERBY* = 27
  SQL_MAX_OWNER_NAME_LEN* = 32
  SQL_MAX_PROCEDURE_NAME_LEN* = 33
  SQL_MAX_QUALIFIER_NAME_LEN* = 34
  SQL_MULT_RESULT_SETS* = 36
  SQL_MULTIPLE_ACTIVE_TXN* = 37
  SQL_OUTER_JOINS* = 38
  SQL_OWNER_TERM* = 39
  SQL_PROCEDURE_TERM* = 40
  SQL_QUALIFIER_NAME_SEPARATOR* = 41
  SQL_QUALIFIER_TERM* = 42
  SQL_SCROLL_OPTIONS* = 44
  SQL_TABLE_TERM* = 45
  SQL_CONVERT_FUNCTIONS* = 48
  SQL_NUMERIC_FUNCTIONS* = 49
  SQL_STRING_FUNCTIONS* = 50
  SQL_SYSTEM_FUNCTIONS* = 51
  SQL_TIMEDATE_FUNCTIONS* = 52
  SQL_CONVERT_BIGINT* = 53
  SQL_CONVERT_BINARY* = 54
  SQL_CONVERT_BIT* = 55
  SQL_CONVERT_CHAR* = 56
  SQL_CONVERT_DATE* = 57
  SQL_CONVERT_DECIMAL* = 58
  SQL_CONVERT_DOUBLE* = 59
  SQL_CONVERT_FLOAT* = 60
  SQL_CONVERT_INTEGER* = 61
  SQL_CONVERT_LONGVARCHAR* = 62
  SQL_CONVERT_NUMERIC* = 63
  SQL_CONVERT_REAL* = 64
  SQL_CONVERT_SMALLINT* = 65
  SQL_CONVERT_TIME* = 66
  SQL_CONVERT_TIMESTAMP* = 67
  SQL_CONVERT_TINYINT* = 68
  SQL_CONVERT_VARBINARY* = 69
  SQL_CONVERT_VARCHAR* = 70
  SQL_CONVERT_LONGVARBINARY* = 71
  SQL_ODBC_SQL_OPT_IEF* = 73
  SQL_CORRELATION_NAME* = 74
  SQL_NON_NULLABLE_COLUMNS* = 75
  SQL_DRIVER_HLIB* = 76
  SQL_DRIVER_ODBC_VER* = 77
  SQL_LOCK_TYPES* = 78
  SQL_POS_OPERATIONS* = 79
  SQL_POSITIONED_STATEMENTS* = 80
  SQL_BOOKMARK_PERSISTENCE* = 82
  SQL_STATIC_SENSITIVITY* = 83
  SQL_FILE_USAGE* = 84
  SQL_COLUMN_ALIAS* = 87
  SQL_GROUP_BY* = 88
  SQL_KEYWORDS* = 89
  SQL_OWNER_USAGE* = 91
  SQL_QUALIFIER_USAGE* = 92
  SQL_QUOTED_IDENTIFIER_CASE* = 93
  SQL_SUBQUERIES* = 95
  SQL_UNION* = 96
  SQL_MAX_ROW_SIZE_INCLUDES_LONG* = 103
  SQL_MAX_CHAR_LITERAL_LEN* = 108
  SQL_TIMEDATE_ADD_INTERVALS* = 109
  SQL_TIMEDATE_DIFF_INTERVALS* = 110
  SQL_NEED_LONG_DATA_LEN* = 111
  SQL_MAX_BINARY_LITERAL_LEN* = 112
  SQL_LIKE_ESCAPE_CLAUSE* = 113
  SQL_QUALIFIER_LOCATION* = 114
  SQL_ACTIVE_ENVIRONMENTS* = 116
  SQL_ALTER_DOMAIN* = 117
  SQL_SQL_CONFORMANCE* = 118
  SQL_DATETIME_LITERALS* = 119
  SQL_ASYNC_MODE* = 10021
  SQL_BATCH_ROW_COUNT* = 120
  SQL_BATCH_SUPPORT* = 121
  SQL_CATALOG_LOCATION* = SQL_QUALIFIER_LOCATION
  SQL_CATALOG_NAME_SEPARATOR* = SQL_QUALIFIER_NAME_SEPARATOR
  SQL_CATALOG_TERM* = SQL_QUALIFIER_TERM
  SQL_CATALOG_USAGE* = SQL_QUALIFIER_USAGE
  SQL_CONVERT_WCHAR* = 122
  SQL_CONVERT_INTERVAL_DAY_TIME* = 123
  SQL_CONVERT_INTERVAL_YEAR_MONTH* = 124
  SQL_CONVERT_WLONGVARCHAR* = 125
  SQL_CONVERT_WVARCHAR* = 126
  SQL_CREATE_ASSERTION* = 127
  SQL_CREATE_CHARACTER_SET* = 128
  SQL_CREATE_COLLATION* = 129
  SQL_CREATE_DOMAIN* = 130
  SQL_CREATE_SCHEMA* = 131
  SQL_CREATE_TABLE* = 132
  SQL_CREATE_TRANSLATION* = 133
  SQL_CREATE_VIEW* = 134
  SQL_DRIVER_HDESC* = 135
  SQL_DROP_ASSERTION* = 136
  SQL_DROP_CHARACTER_SET* = 137
  SQL_DROP_COLLATION* = 138
  SQL_DROP_DOMAIN* = 139
  SQL_DROP_SCHEMA* = 140
  SQL_DROP_TABLE* = 141
  SQL_DROP_TRANSLATION* = 142
  SQL_DROP_VIEW* = 143
  SQL_DYNAMIC_CURSOR_ATTRIBUTES1* = 144
  SQL_DYNAMIC_CURSOR_ATTRIBUTES2* = 145
  SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1* = 146
  SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2* = 147
  SQL_INDEX_KEYWORDS* = 148
  SQL_INFO_SCHEMA_VIEWS* = 149
  SQL_KEYSET_CURSOR_ATTRIBUTES1* = 150
  SQL_KEYSET_CURSOR_ATTRIBUTES2* = 151
  SQL_MAX_ASYNC_CONCURRENT_STATEMENTS* = 10022
  SQL_ODBC_INTERFACE_CONFORMANCE* = 152
  SQL_PARAM_ARRAY_ROW_COUNTS* = 153
  SQL_PARAM_ARRAY_SELECTS* = 154
  SQL_SCHEMA_TERM* = SQL_OWNER_TERM
  SQL_SCHEMA_USAGE* = SQL_OWNER_USAGE
  SQL_SQL92_DATETIME_FUNCTIONS* = 155
  SQL_SQL92_FOREIGN_KEY_DELETE_RULE* = 156
  SQL_SQL92_FOREIGN_KEY_UPDATE_RULE* = 157
  SQL_SQL92_GRANT* = 158
  SQL_SQL92_NUMERIC_VALUE_FUNCTIONS* = 159
  SQL_SQL92_PREDICATES* = 160
  SQL_SQL92_RELATIONAL_JOIN_OPERATORS* = 161
  SQL_SQL92_REVOKE* = 162
  SQL_SQL92_ROW_VALUE_CONSTRUCTOR* = 163
  SQL_SQL92_STRING_FUNCTIONS* = 164
  SQL_SQL92_VALUE_EXPRESSIONS* = 165
  SQL_STANDARD_CLI_CONFORMANCE* = 166
  SQL_STATIC_CURSOR_ATTRIBUTES1* = 167
  SQL_STATIC_CURSOR_ATTRIBUTES2* = 168
  SQL_AGGREGATE_FUNCTIONS* = 169
  SQL_DDL_INDEX* = 170
  SQL_DM_VER* = 171
  SQL_INSERT_STATEMENT* = 172
  SQL_CONVERT_GUID* = 173
  SQL_UNION_STATEMENT* = SQL_UNION
  SQL_DTC_TRANSITION_COST* = 1750
  SQL_AT_ADD_COLUMN_SINGLE* = 0x00000020
  SQL_AT_ADD_COLUMN_DEFAULT* = 0x00000040
  SQL_AT_ADD_COLUMN_COLLATION* = 0x00000080
  SQL_AT_SET_COLUMN_DEFAULT* = 0x00000100
  SQL_AT_DROP_COLUMN_DEFAULT* = 0x00000200
  SQL_AT_DROP_COLUMN_CASCADE* = 0x00000400
  SQL_AT_DROP_COLUMN_RESTRICT* = 0x00000800
  SQL_AT_ADD_TABLE_CONSTRAINT* = 0x00001000
  SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE* = 0x00002000
  SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT* = 0x00004000
  SQL_AT_CONSTRAINT_NAME_DEFINITION* = 0x00008000
  SQL_AT_CONSTRAINT_INITIALLY_DEFERRED* = 0x00010000
  SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE* = 0x00020000
  SQL_AT_CONSTRAINT_DEFERRABLE* = 0x00040000
  SQL_AT_CONSTRAINT_NON_DEFERRABLE* = 0x00080000
  SQL_CVT_CHAR* = 0x00000001
  SQL_CVT_NUMERIC* = 0x00000002
  SQL_CVT_DECIMAL* = 0x00000004
  SQL_CVT_INTEGER* = 0x00000008
  SQL_CVT_SMALLINT* = 0x00000010
  SQL_CVT_FLOAT* = 0x00000020
  SQL_CVT_REAL* = 0x00000040
  SQL_CVT_DOUBLE* = 0x00000080
  SQL_CVT_VARCHAR* = 0x00000100
  SQL_CVT_LONGVARCHAR* = 0x00000200
  SQL_CVT_BINARY* = 0x00000400
  SQL_CVT_VARBINARY* = 0x00000800
  SQL_CVT_BIT* = 0x00001000
  SQL_CVT_TINYINT* = 0x00002000
  SQL_CVT_BIGINT* = 0x00004000
  SQL_CVT_DATE* = 0x00008000
  SQL_CVT_TIME* = 0x00010000
  SQL_CVT_TIMESTAMP* = 0x00020000
  SQL_CVT_LONGVARBINARY* = 0x00040000
  SQL_CVT_INTERVAL_YEAR_MONTH* = 0x00080000
  SQL_CVT_INTERVAL_DAY_TIME* = 0x00100000
  SQL_CVT_WCHAR* = 0x00200000
  SQL_CVT_WLONGVARCHAR* = 0x00400000
  SQL_CVT_WVARCHAR* = 0x00800000
  SQL_CVT_GUID* = 0x01000000
  SQL_FN_CVT_CONVERT* = 0x00000001
  SQL_FN_CVT_CAST* = 0x00000002
  SQL_FN_STR_CONCAT* = 0x00000001
  SQL_FN_STR_INSERT* = 0x00000002
  SQL_FN_STR_LEFT* = 0x00000004
  SQL_FN_STR_LTRIM* = 0x00000008
  SQL_FN_STR_LENGTH* = 0x00000010
  SQL_FN_STR_LOCATE* = 0x00000020
  SQL_FN_STR_LCASE* = 0x00000040
  SQL_FN_STR_REPEAT* = 0x00000080
  SQL_FN_STR_REPLACE* = 0x00000100
  SQL_FN_STR_RIGHT* = 0x00000200
  SQL_FN_STR_RTRIM* = 0x00000400
  SQL_FN_STR_SUBSTRING* = 0x00000800
  SQL_FN_STR_UCASE* = 0x00001000
  SQL_FN_STR_ASCII* = 0x00002000
  SQL_FN_STR_CHAR* = 0x00004000
  SQL_FN_STR_DIFFERENCE* = 0x00008000
  SQL_FN_STR_LOCATE_2* = 0x00010000
  SQL_FN_STR_SOUNDEX* = 0x00020000
  SQL_FN_STR_SPACE* = 0x00040000
  SQL_FN_STR_BIT_LENGTH* = 0x00080000
  SQL_FN_STR_CHAR_LENGTH* = 0x00100000
  SQL_FN_STR_CHARACTER_LENGTH* = 0x00200000
  SQL_FN_STR_OCTET_LENGTH* = 0x00400000
  SQL_FN_STR_POSITION* = 0x00800000
  SQL_SSF_CONVERT* = 0x00000001
  SQL_SSF_LOWER* = 0x00000002
  SQL_SSF_UPPER* = 0x00000004
  SQL_SSF_SUBSTRING* = 0x00000008
  SQL_SSF_TRANSLATE* = 0x00000010
  SQL_SSF_TRIM_BOTH* = 0x00000020
  SQL_SSF_TRIM_LEADING* = 0x00000040
  SQL_SSF_TRIM_TRAILING* = 0x00000080
  SQL_FN_NUM_ABS* = 0x00000001
  SQL_FN_NUM_ACOS* = 0x00000002
  SQL_FN_NUM_ASIN* = 0x00000004
  SQL_FN_NUM_ATAN* = 0x00000008
  SQL_FN_NUM_ATAN2* = 0x00000010
  SQL_FN_NUM_CEILING* = 0x00000020
  SQL_FN_NUM_COS* = 0x00000040
  SQL_FN_NUM_COT* = 0x00000080
  SQL_FN_NUM_EXP* = 0x00000100
  SQL_FN_NUM_FLOOR* = 0x00000200
  SQL_FN_NUM_LOG* = 0x00000400
  SQL_FN_NUM_MOD* = 0x00000800
  SQL_FN_NUM_SIGN* = 0x00001000
  SQL_FN_NUM_SIN* = 0x00002000
  SQL_FN_NUM_SQRT* = 0x00004000
  SQL_FN_NUM_TAN* = 0x00008000
  SQL_FN_NUM_PI* = 0x00010000
  SQL_FN_NUM_RAND* = 0x00020000
  SQL_FN_NUM_DEGREES* = 0x00040000
  SQL_FN_NUM_LOG10* = 0x00080000
  SQL_FN_NUM_POWER* = 0x00100000
  SQL_FN_NUM_RADIANS* = 0x00200000
  SQL_FN_NUM_ROUND* = 0x00400000
  SQL_FN_NUM_TRUNCATE* = 0x00800000
  SQL_SNVF_BIT_LENGTH* = 0x00000001
  SQL_SNVF_CHAR_LENGTH* = 0x00000002
  SQL_SNVF_CHARACTER_LENGTH* = 0x00000004
  SQL_SNVF_EXTRACT* = 0x00000008
  SQL_SNVF_OCTET_LENGTH* = 0x00000010
  SQL_SNVF_POSITION* = 0x00000020
  SQL_FN_TD_NOW* = 0x00000001
  SQL_FN_TD_CURDATE* = 0x00000002
  SQL_FN_TD_DAYOFMONTH* = 0x00000004
  SQL_FN_TD_DAYOFWEEK* = 0x00000008
  SQL_FN_TD_DAYOFYEAR* = 0x00000010
  SQL_FN_TD_MONTH* = 0x00000020
  SQL_FN_TD_QUARTER* = 0x00000040
  SQL_FN_TD_WEEK* = 0x00000080
  SQL_FN_TD_YEAR* = 0x00000100
  SQL_FN_TD_CURTIME* = 0x00000200
  SQL_FN_TD_HOUR* = 0x00000400
  SQL_FN_TD_MINUTE* = 0x00000800
  SQL_FN_TD_SECOND* = 0x00001000
  SQL_FN_TD_TIMESTAMPADD* = 0x00002000
  SQL_FN_TD_TIMESTAMPDIFF* = 0x00004000
  SQL_FN_TD_DAYNAME* = 0x00008000
  SQL_FN_TD_MONTHNAME* = 0x00010000
  SQL_FN_TD_CURRENT_DATE* = 0x00020000
  SQL_FN_TD_CURRENT_TIME* = 0x00040000
  SQL_FN_TD_CURRENT_TIMESTAMP* = 0x00080000
  SQL_FN_TD_EXTRACT* = 0x00100000
  SQL_SDF_CURRENT_DATE* = 0x00000001
  SQL_SDF_CURRENT_TIME* = 0x00000002
  SQL_SDF_CURRENT_TIMESTAMP* = 0x00000004
  SQL_FN_SYS_USERNAME* = 0x00000001
  SQL_FN_SYS_DBNAME* = 0x00000002
  SQL_FN_SYS_IFNULL* = 0x00000004
  SQL_FN_TSI_FRAC_SECOND* = 0x00000001
  SQL_FN_TSI_SECOND* = 0x00000002
  SQL_FN_TSI_MINUTE* = 0x00000004
  SQL_FN_TSI_HOUR* = 0x00000008
  SQL_FN_TSI_DAY* = 0x00000010
  SQL_FN_TSI_WEEK* = 0x00000020
  SQL_FN_TSI_MONTH* = 0x00000040
  SQL_FN_TSI_QUARTER* = 0x00000080
  SQL_FN_TSI_YEAR* = 0x00000100
  SQL_CA1_NEXT* = 0x00000001
  SQL_CA1_ABSOLUTE* = 0x00000002
  SQL_CA1_RELATIVE* = 0x00000004
  SQL_CA1_BOOKMARK* = 0x00000008
  SQL_CA1_LOCK_NO_CHANGE* = 0x00000040
  SQL_CA1_LOCK_EXCLUSIVE* = 0x00000080
  SQL_CA1_LOCK_UNLOCK* = 0x00000100
  SQL_CA1_POS_POSITION* = 0x00000200
  SQL_CA1_POS_UPDATE* = 0x00000400
  SQL_CA1_POS_DELETE* = 0x00000800
  SQL_CA1_POS_REFRESH* = 0x00001000
  SQL_CA1_POSITIONED_UPDATE* = 0x00002000
  SQL_CA1_POSITIONED_DELETE* = 0x00004000
  SQL_CA1_SELECT_FOR_UPDATE* = 0x00008000
  SQL_CA1_BULK_ADD* = 0x00010000
  SQL_CA1_BULK_UPDATE_BY_BOOKMARK* = 0x00020000
  SQL_CA1_BULK_DELETE_BY_BOOKMARK* = 0x00040000
  SQL_CA1_BULK_FETCH_BY_BOOKMARK* = 0x00080000
  SQL_CA2_READ_ONLY_CONCURRENCY* = 0x00000001
  SQL_CA2_LOCK_CONCURRENCY* = 0x00000002
  SQL_CA2_OPT_ROWVER_CONCURRENCY* = 0x00000004
  SQL_CA2_OPT_VALUES_CONCURRENCY* = 0x00000008
  SQL_CA2_SENSITIVITY_ADDITIONS* = 0x00000010
  SQL_CA2_SENSITIVITY_DELETIONS* = 0x00000020
  SQL_CA2_SENSITIVITY_UPDATES* = 0x00000040
  SQL_CA2_MAX_ROWS_SELECT* = 0x00000080
  SQL_CA2_MAX_ROWS_INSERT* = 0x00000100
  SQL_CA2_MAX_ROWS_DELETE* = 0x00000200
  SQL_CA2_MAX_ROWS_UPDATE* = 0x00000400
  SQL_CA2_MAX_ROWS_CATALOG* = 0x00000800
  SQL_CA2_MAX_ROWS_AFFECTS_ALL* = SQL_CA2_MAX_ROWS_SELECT or SQL_CA2_MAX_ROWS_INSERT or SQL_CA2_MAX_ROWS_DELETE or SQL_CA2_MAX_ROWS_UPDATE or SQL_CA2_MAX_ROWS_CATALOG
  SQL_CA2_CRC_EXACT* = 0x00001000
  SQL_CA2_CRC_APPROXIMATE* = 0x00002000
  SQL_CA2_SIMULATE_NON_UNIQUE* = 0x00004000
  SQL_CA2_SIMULATE_TRY_UNIQUE* = 0x00008000
  SQL_CA2_SIMULATE_UNIQUE* = 0x00010000
  SQL_OAC_NONE* = 0x0000
  SQL_OAC_LEVEL1* = 0x0001
  SQL_OAC_LEVEL2* = 0x0002
  SQL_OSCC_NOT_COMPLIANT* = 0x0000
  SQL_OSCC_COMPLIANT* = 0x0001
  SQL_OSC_MINIMUM* = 0x0000
  SQL_OSC_CORE* = 0x0001
  SQL_OSC_EXTENDED* = 0x0002
  SQL_CB_NULL* = 0x0000
  SQL_CB_NON_NULL* = 0x0001
  SQL_SO_FORWARD_ONLY* = 0x00000001
  SQL_SO_KEYSET_DRIVEN* = 0x00000002
  SQL_SO_DYNAMIC* = 0x00000004
  SQL_SO_MIXED* = 0x00000008
  SQL_SO_STATIC* = 0x00000010
  SQL_FD_FETCH_BOOKMARK* = 0x00000080
  SQL_CN_NONE* = 0x0000
  SQL_CN_DIFFERENT* = 0x0001
  SQL_CN_ANY* = 0x0002
  SQL_NNC_NULL* = 0x0000
  SQL_NNC_NON_NULL* = 0x0001
  SQL_NC_START* = 0x0002
  SQL_NC_END* = 0x0004
  SQL_FILE_NOT_SUPPORTED* = 0x0000
  SQL_FILE_TABLE* = 0x0001
  SQL_FILE_QUALIFIER* = 0x0002
  SQL_FILE_CATALOG* = SQL_FILE_QUALIFIER
  SQL_GD_BLOCK* = 0x00000004
  SQL_GD_BOUND* = 0x00000008
  SQL_PS_POSITIONED_DELETE* = 0x00000001
  SQL_PS_POSITIONED_UPDATE* = 0x00000002
  SQL_PS_SELECT_FOR_UPDATE* = 0x00000004
  SQL_GB_NOT_SUPPORTED* = 0x0000
  SQL_GB_GROUP_BY_EQUALS_SELECT* = 0x0001
  SQL_GB_GROUP_BY_CONTAINS_SELECT* = 0x0002
  SQL_GB_NO_RELATION* = 0x0003
  SQL_GB_COLLATE* = 0x0004
  SQL_OU_DML_STATEMENTS* = 0x00000001
  SQL_OU_PROCEDURE_INVOCATION* = 0x00000002
  SQL_OU_TABLE_DEFINITION* = 0x00000004
  SQL_OU_INDEX_DEFINITION* = 0x00000008
  SQL_OU_PRIVILEGE_DEFINITION* = 0x00000010
  SQL_SU_DML_STATEMENTS* = SQL_OU_DML_STATEMENTS
  SQL_SU_PROCEDURE_INVOCATION* = SQL_OU_PROCEDURE_INVOCATION
  SQL_SU_TABLE_DEFINITION* = SQL_OU_TABLE_DEFINITION
  SQL_SU_INDEX_DEFINITION* = SQL_OU_INDEX_DEFINITION
  SQL_SU_PRIVILEGE_DEFINITION* = SQL_OU_PRIVILEGE_DEFINITION
  SQL_QU_DML_STATEMENTS* = 0x00000001
  SQL_QU_PROCEDURE_INVOCATION* = 0x00000002
  SQL_QU_TABLE_DEFINITION* = 0x00000004
  SQL_QU_INDEX_DEFINITION* = 0x00000008
  SQL_QU_PRIVILEGE_DEFINITION* = 0x00000010
  SQL_CU_DML_STATEMENTS* = SQL_QU_DML_STATEMENTS
  SQL_CU_PROCEDURE_INVOCATION* = SQL_QU_PROCEDURE_INVOCATION
  SQL_CU_TABLE_DEFINITION* = SQL_QU_TABLE_DEFINITION
  SQL_CU_INDEX_DEFINITION* = SQL_QU_INDEX_DEFINITION
  SQL_CU_PRIVILEGE_DEFINITION* = SQL_QU_PRIVILEGE_DEFINITION
  SQL_SQ_COMPARISON* = 0x00000001
  SQL_SQ_EXISTS* = 0x00000002
  SQL_SQ_IN* = 0x00000004
  SQL_SQ_QUANTIFIED* = 0x00000008
  SQL_SQ_CORRELATED_SUBQUERIES* = 0x00000010
  SQL_U_UNION* = 0x00000001
  SQL_U_UNION_ALL* = 0x00000002
  SQL_BP_CLOSE* = 0x00000001
  SQL_BP_DELETE* = 0x00000002
  SQL_BP_DROP* = 0x00000004
  SQL_BP_TRANSACTION* = 0x00000008
  SQL_BP_UPDATE* = 0x00000010
  SQL_BP_OTHER_HSTMT* = 0x00000020
  SQL_BP_SCROLL* = 0x00000040
  SQL_SS_ADDITIONS* = 0x00000001
  SQL_SS_DELETIONS* = 0x00000002
  SQL_SS_UPDATES* = 0x00000004
  SQL_CV_CREATE_VIEW* = 0x00000001
  SQL_CV_CHECK_OPTION* = 0x00000002
  SQL_CV_CASCADED* = 0x00000004
  SQL_CV_LOCAL* = 0x00000008
  SQL_LCK_NO_CHANGE* = 0x00000001
  SQL_LCK_EXCLUSIVE* = 0x00000002
  SQL_LCK_UNLOCK* = 0x00000004
  SQL_POS_POSITION* = 0x00000001
  SQL_POS_REFRESH* = 0x00000002
  SQL_POS_UPDATE* = 0x00000004
  SQL_POS_DELETE* = 0x00000008
  SQL_POS_ADD* = 0x00000010
  SQL_QL_START* = 0x0001
  SQL_QL_END* = 0x0002
  SQL_AF_AVG* = 0x00000001
  SQL_AF_COUNT* = 0x00000002
  SQL_AF_MAX* = 0x00000004
  SQL_AF_MIN* = 0x00000008
  SQL_AF_SUM* = 0x00000010
  SQL_AF_DISTINCT* = 0x00000020
  SQL_AF_ALL* = 0x00000040
  SQL_SC_SQL92_ENTRY* = 0x00000001
  SQL_SC_FIPS127_2_TRANSITIONAL* = 0x00000002
  SQL_SC_SQL92_INTERMEDIATE* = 0x00000004
  SQL_SC_SQL92_FULL* = 0x00000008
  SQL_DL_SQL92_DATE* = 0x00000001
  SQL_DL_SQL92_TIME* = 0x00000002
  SQL_DL_SQL92_TIMESTAMP* = 0x00000004
  SQL_DL_SQL92_INTERVAL_YEAR* = 0x00000008
  SQL_DL_SQL92_INTERVAL_MONTH* = 0x00000010
  SQL_DL_SQL92_INTERVAL_DAY* = 0x00000020
  SQL_DL_SQL92_INTERVAL_HOUR* = 0x00000040
  SQL_DL_SQL92_INTERVAL_MINUTE* = 0x00000080
  SQL_DL_SQL92_INTERVAL_SECOND* = 0x00000100
  SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH* = 0x00000200
  SQL_DL_SQL92_INTERVAL_DAY_TO_HOUR* = 0x00000400
  SQL_DL_SQL92_INTERVAL_DAY_TO_MINUTE* = 0x00000800
  SQL_DL_SQL92_INTERVAL_DAY_TO_SECOND* = 0x00001000
  SQL_DL_SQL92_INTERVAL_HOUR_TO_MINUTE* = 0x00002000
  SQL_DL_SQL92_INTERVAL_HOUR_TO_SECOND* = 0x00004000
  SQL_DL_SQL92_INTERVAL_MINUTE_TO_SECOND* = 0x00008000
  SQL_CL_START* = SQL_QL_START
  SQL_CL_END* = SQL_QL_END
  SQL_BRC_PROCEDURES* = 0x0000001
  SQL_BRC_EXPLICIT* = 0x0000002
  SQL_BRC_ROLLED_UP* = 0x0000004
  SQL_BS_SELECT_EXPLICIT* = 0x00000001
  SQL_BS_ROW_COUNT_EXPLICIT* = 0x00000002
  SQL_BS_SELECT_PROC* = 0x00000004
  SQL_BS_ROW_COUNT_PROC* = 0x00000008
  SQL_PARC_BATCH* = 1
  SQL_PARC_NO_BATCH* = 2
  SQL_PAS_BATCH* = 1
  SQL_PAS_NO_BATCH* = 2
  SQL_PAS_NO_SELECT* = 3
  SQL_IK_NONE* = 0x00000000
  SQL_IK_ASC* = 0x00000001
  SQL_IK_DESC* = 0x00000002
  SQL_IK_ALL* = SQL_IK_ASC or SQL_IK_DESC
  SQL_ISV_ASSERTIONS* = 0x00000001
  SQL_ISV_CHARACTER_SETS* = 0x00000002
  SQL_ISV_CHECK_CONSTRAINTS* = 0x00000004
  SQL_ISV_COLLATIONS* = 0x00000008
  SQL_ISV_COLUMN_DOMAIN_USAGE* = 0x00000010
  SQL_ISV_COLUMN_PRIVILEGES* = 0x00000020
  SQL_ISV_COLUMNS* = 0x00000040
  SQL_ISV_CONSTRAINT_COLUMN_USAGE* = 0x00000080
  SQL_ISV_CONSTRAINT_TABLE_USAGE* = 0x00000100
  SQL_ISV_DOMAIN_CONSTRAINTS* = 0x00000200
  SQL_ISV_DOMAINS* = 0x00000400
  SQL_ISV_KEY_COLUMN_USAGE* = 0x00000800
  SQL_ISV_REFERENTIAL_CONSTRAINTS* = 0x00001000
  SQL_ISV_SCHEMATA* = 0x00002000
  SQL_ISV_SQL_LANGUAGES* = 0x00004000
  SQL_ISV_TABLE_CONSTRAINTS* = 0x00008000
  SQL_ISV_TABLE_PRIVILEGES* = 0x00010000
  SQL_ISV_TABLES* = 0x00020000
  SQL_ISV_TRANSLATIONS* = 0x00040000
  SQL_ISV_USAGE_PRIVILEGES* = 0x00080000
  SQL_ISV_VIEW_COLUMN_USAGE* = 0x00100000
  SQL_ISV_VIEW_TABLE_USAGE* = 0x00200000
  SQL_ISV_VIEWS* = 0x00400000
  SQL_AD_CONSTRAINT_NAME_DEFINITION* = 0x00000001
  SQL_AD_ADD_DOMAIN_CONSTRAINT* = 0x00000002
  SQL_AD_DROP_DOMAIN_CONSTRAINT* = 0x00000004
  SQL_AD_ADD_DOMAIN_DEFAULT* = 0x00000008
  SQL_AD_DROP_DOMAIN_DEFAULT* = 0x00000010
  SQL_AD_ADD_CONSTRAINT_INITIALLY_DEFERRED* = 0x00000020
  SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE* = 0x00000040
  SQL_AD_ADD_CONSTRAINT_DEFERRABLE* = 0x00000080
  SQL_AD_ADD_CONSTRAINT_NON_DEFERRABLE* = 0x00000100
  SQL_CS_CREATE_SCHEMA* = 0x00000001
  SQL_CS_AUTHORIZATION* = 0x00000002
  SQL_CS_DEFAULT_CHARACTER_SET* = 0x00000004
  SQL_CTR_CREATE_TRANSLATION* = 0x00000001
  SQL_CA_CREATE_ASSERTION* = 0x00000001
  SQL_CA_CONSTRAINT_INITIALLY_DEFERRED* = 0x00000010
  SQL_CA_CONSTRAINT_INITIALLY_IMMEDIATE* = 0x00000020
  SQL_CA_CONSTRAINT_DEFERRABLE* = 0x00000040
  SQL_CA_CONSTRAINT_NON_DEFERRABLE* = 0x00000080
  SQL_CCS_CREATE_CHARACTER_SET* = 0x00000001
  SQL_CCS_COLLATE_CLAUSE* = 0x00000002
  SQL_CCS_LIMITED_COLLATION* = 0x00000004
  SQL_CCOL_CREATE_COLLATION* = 0x00000001
  SQL_CDO_CREATE_DOMAIN* = 0x00000001
  SQL_CDO_DEFAULT* = 0x00000002
  SQL_CDO_CONSTRAINT* = 0x00000004
  SQL_CDO_COLLATION* = 0x00000008
  SQL_CDO_CONSTRAINT_NAME_DEFINITION* = 0x00000010
  SQL_CDO_CONSTRAINT_INITIALLY_DEFERRED* = 0x00000020
  SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE* = 0x00000040
  SQL_CDO_CONSTRAINT_DEFERRABLE* = 0x00000080
  SQL_CDO_CONSTRAINT_NON_DEFERRABLE* = 0x00000100
  SQL_CT_CREATE_TABLE* = 0x00000001
  SQL_CT_COMMIT_PRESERVE* = 0x00000002
  SQL_CT_COMMIT_DELETE* = 0x00000004
  SQL_CT_GLOBAL_TEMPORARY* = 0x00000008
  SQL_CT_LOCAL_TEMPORARY* = 0x00000010
  SQL_CT_CONSTRAINT_INITIALLY_DEFERRED* = 0x00000020
  SQL_CT_CONSTRAINT_INITIALLY_IMMEDIATE* = 0x00000040
  SQL_CT_CONSTRAINT_DEFERRABLE* = 0x00000080
  SQL_CT_CONSTRAINT_NON_DEFERRABLE* = 0x00000100
  SQL_CT_COLUMN_CONSTRAINT* = 0x00000200
  SQL_CT_COLUMN_DEFAULT* = 0x00000400
  SQL_CT_COLUMN_COLLATION* = 0x00000800
  SQL_CT_TABLE_CONSTRAINT* = 0x00001000
  SQL_CT_CONSTRAINT_NAME_DEFINITION* = 0x00002000
  SQL_DI_CREATE_INDEX* = 0x00000001
  SQL_DI_DROP_INDEX* = 0x00000002
  SQL_DC_DROP_COLLATION* = 0x00000001
  SQL_DD_DROP_DOMAIN* = 0x00000001
  SQL_DD_RESTRICT* = 0x00000002
  SQL_DD_CASCADE* = 0x00000004
  SQL_DS_DROP_SCHEMA* = 0x00000001
  SQL_DS_RESTRICT* = 0x00000002
  SQL_DS_CASCADE* = 0x00000004
  SQL_DCS_DROP_CHARACTER_SET* = 0x00000001
  SQL_DA_DROP_ASSERTION* = 0x00000001
  SQL_DT_DROP_TABLE* = 0x00000001
  SQL_DT_RESTRICT* = 0x00000002
  SQL_DT_CASCADE* = 0x00000004
  SQL_DTR_DROP_TRANSLATION* = 0x00000001
  SQL_DV_DROP_VIEW* = 0x00000001
  SQL_DV_RESTRICT* = 0x00000002
  SQL_DV_CASCADE* = 0x00000004
  SQL_IS_INSERT_LITERALS* = 0x00000001
  SQL_IS_INSERT_SEARCHED* = 0x00000002
  SQL_IS_SELECT_INTO* = 0x00000004
  SQL_OIC_CORE* = 1
  SQL_OIC_LEVEL1* = 2
  SQL_OIC_LEVEL2* = 3
  SQL_SFKD_CASCADE* = 0x00000001
  SQL_SFKD_NO_ACTION* = 0x00000002
  SQL_SFKD_SET_DEFAULT* = 0x00000004
  SQL_SFKD_SET_NULL* = 0x00000008
  SQL_SFKU_CASCADE* = 0x00000001
  SQL_SFKU_NO_ACTION* = 0x00000002
  SQL_SFKU_SET_DEFAULT* = 0x00000004
  SQL_SFKU_SET_NULL* = 0x00000008
  SQL_SG_USAGE_ON_DOMAIN* = 0x00000001
  SQL_SG_USAGE_ON_CHARACTER_SET* = 0x00000002
  SQL_SG_USAGE_ON_COLLATION* = 0x00000004
  SQL_SG_USAGE_ON_TRANSLATION* = 0x00000008
  SQL_SG_WITH_GRANT_OPTION* = 0x00000010
  SQL_SG_DELETE_TABLE* = 0x00000020
  SQL_SG_INSERT_TABLE* = 0x00000040
  SQL_SG_INSERT_COLUMN* = 0x00000080
  SQL_SG_REFERENCES_TABLE* = 0x00000100
  SQL_SG_REFERENCES_COLUMN* = 0x00000200
  SQL_SG_SELECT_TABLE* = 0x00000400
  SQL_SG_UPDATE_TABLE* = 0x00000800
  SQL_SG_UPDATE_COLUMN* = 0x00001000
  SQL_SP_EXISTS* = 0x00000001
  SQL_SP_ISNOTNULL* = 0x00000002
  SQL_SP_ISNULL* = 0x00000004
  SQL_SP_MATCH_FULL* = 0x00000008
  SQL_SP_MATCH_PARTIAL* = 0x00000010
  SQL_SP_MATCH_UNIQUE_FULL* = 0x00000020
  SQL_SP_MATCH_UNIQUE_PARTIAL* = 0x00000040
  SQL_SP_OVERLAPS* = 0x00000080
  SQL_SP_UNIQUE* = 0x00000100
  SQL_SP_LIKE* = 0x00000200
  SQL_SP_IN* = 0x00000400
  SQL_SP_BETWEEN* = 0x00000800
  SQL_SP_COMPARISON* = 0x00001000
  SQL_SP_QUANTIFIED_COMPARISON* = 0x00002000
  SQL_SRJO_CORRESPONDING_CLAUSE* = 0x00000001
  SQL_SRJO_CROSS_JOIN* = 0x00000002
  SQL_SRJO_EXCEPT_JOIN* = 0x00000004
  SQL_SRJO_FULL_OUTER_JOIN* = 0x00000008
  SQL_SRJO_INNER_JOIN* = 0x00000010
  SQL_SRJO_INTERSECT_JOIN* = 0x00000020
  SQL_SRJO_LEFT_OUTER_JOIN* = 0x00000040
  SQL_SRJO_NATURAL_JOIN* = 0x00000080
  SQL_SRJO_RIGHT_OUTER_JOIN* = 0x00000100
  SQL_SRJO_UNION_JOIN* = 0x00000200
  SQL_SR_USAGE_ON_DOMAIN* = 0x00000001
  SQL_SR_USAGE_ON_CHARACTER_SET* = 0x00000002
  SQL_SR_USAGE_ON_COLLATION* = 0x00000004
  SQL_SR_USAGE_ON_TRANSLATION* = 0x00000008
  SQL_SR_GRANT_OPTION_FOR* = 0x00000010
  SQL_SR_CASCADE* = 0x00000020
  SQL_SR_RESTRICT* = 0x00000040
  SQL_SR_DELETE_TABLE* = 0x00000080
  SQL_SR_INSERT_TABLE* = 0x00000100
  SQL_SR_INSERT_COLUMN* = 0x00000200
  SQL_SR_REFERENCES_TABLE* = 0x00000400
  SQL_SR_REFERENCES_COLUMN* = 0x00000800
  SQL_SR_SELECT_TABLE* = 0x00001000
  SQL_SR_UPDATE_TABLE* = 0x00002000
  SQL_SR_UPDATE_COLUMN* = 0x00004000
  SQL_SRVC_VALUE_EXPRESSION* = 0x00000001
  SQL_SRVC_NULL* = 0x00000002
  SQL_SRVC_DEFAULT* = 0x00000004
  SQL_SRVC_ROW_SUBQUERY* = 0x00000008
  SQL_SVE_CASE* = 0x00000001
  SQL_SVE_CAST* = 0x00000002
  SQL_SVE_COALESCE* = 0x00000004
  SQL_SVE_NULLIF* = 0x00000008
  SQL_SCC_XOPEN_CLI_VERSION1* = 0x00000001
  SQL_SCC_ISO92_CLI* = 0x00000002
  SQL_US_UNION* = SQL_U_UNION
  SQL_US_UNION_ALL* = SQL_U_UNION_ALL
  SQL_DTC_ENLIST_EXPENSIVE* = 0x00000001
  SQL_DTC_UNENLIST_EXPENSIVE* = 0x00000002
  SQL_FETCH_FIRST_USER* = 31
  SQL_FETCH_FIRST_SYSTEM* = 32
  SQL_ENTIRE_ROWSET* = 0
  SQL_POSITION* = 0
  SQL_REFRESH* = 1
  SQL_UPDATE* = 2
  SQL_DELETE* = 3
  SQL_ADD* = 4
  SQL_SETPOS_MAX_OPTION_VALUE* = SQL_ADD
  SQL_UPDATE_BY_BOOKMARK* = 5
  SQL_DELETE_BY_BOOKMARK* = 6
  SQL_FETCH_BY_BOOKMARK* = 7
  SQL_LOCK_NO_CHANGE* = 0
  SQL_LOCK_EXCLUSIVE* = 1
  SQL_LOCK_UNLOCK* = 2
  SQL_SETPOS_MAX_LOCK_VALUE* = SQL_LOCK_UNLOCK
  SQL_BEST_ROWID* = 1
  SQL_ROWVER* = 2
  SQL_PC_NOT_PSEUDO* = 1
  SQL_QUICK* = 0
  SQL_ENSURE* = 1
  SQL_TABLE_STAT* = 0
  SQL_ALL_CATALOGS* = "%"
  SQL_ALL_SCHEMAS* = "%"
  SQL_ALL_TABLE_TYPES* = "%"
  SQL_DRIVER_NOPROMPT* = 0
  SQL_DRIVER_COMPLETE* = 1
  SQL_DRIVER_PROMPT* = 2
  SQL_DRIVER_COMPLETE_REQUIRED* = 3
  SQL_FETCH_BOOKMARK* = 8
  SQL_ROW_SUCCESS* = 0
  SQL_ROW_DELETED* = 1
  SQL_ROW_UPDATED* = 2
  SQL_ROW_NOROW* = 3
  SQL_ROW_ADDED* = 4
  SQL_ROW_ERROR* = 5
  SQL_ROW_SUCCESS_WITH_INFO* = 6
  SQL_ROW_PROCEED* = 0
  SQL_ROW_IGNORE* = 1
  SQL_PARAM_SUCCESS* = 0
  SQL_PARAM_SUCCESS_WITH_INFO* = 6
  SQL_PARAM_ERROR* = 5
  SQL_PARAM_UNUSED* = 7
  SQL_PARAM_DIAG_UNAVAILABLE* = 1
  SQL_PARAM_PROCEED* = 0
  SQL_PARAM_IGNORE* = 1
  SQL_CASCADE* = 0
  SQL_RESTRICT* = 1
  SQL_SET_NULL* = 2
  SQL_NO_ACTION* = 3
  SQL_SET_DEFAULT* = 4
  SQL_INITIALLY_DEFERRED* = 5
  SQL_INITIALLY_IMMEDIATE* = 6
  SQL_NOT_DEFERRABLE* = 7
  SQL_PARAM_TYPE_UNKNOWN* = 0
  SQL_PARAM_INPUT* = 1
  SQL_RESULT_COL* = 3
  SQL_PARAM_OUTPUT* = 4
  SQL_RETURN_VALUE* = 5
  SQL_PT_UNKNOWN* = 0
  SQL_PT_PROCEDURE* = 1
  SQL_PT_FUNCTION* = 2
  SQL_YEAR* = SQL_CODE_YEAR
  SQL_MONTH* = SQL_CODE_MONTH
  SQL_DAY* = SQL_CODE_DAY
  SQL_HOUR* = SQL_CODE_HOUR
  SQL_MINUTE* = SQL_CODE_MINUTE
  SQL_SECOND* = SQL_CODE_SECOND
  SQL_YEAR_TO_MONTH* = SQL_CODE_YEAR_TO_MONTH
  SQL_DAY_TO_HOUR* = SQL_CODE_DAY_TO_HOUR
  SQL_DAY_TO_MINUTE* = SQL_CODE_DAY_TO_MINUTE
  SQL_DAY_TO_SECOND* = SQL_CODE_DAY_TO_SECOND
  SQL_HOUR_TO_MINUTE* = SQL_CODE_HOUR_TO_MINUTE
  SQL_HOUR_TO_SECOND* = SQL_CODE_HOUR_TO_SECOND
  SQL_MINUTE_TO_SECOND* = SQL_CODE_MINUTE_TO_SECOND
  SQL_DATABASE_NAME* = 16
  SQL_FD_FETCH_PREV* = SQL_FD_FETCH_PRIOR
  SQL_FETCH_PREV* = SQL_FETCH_PRIOR
  SQL_CONCUR_TIMESTAMP* = SQL_CONCUR_ROWVER
  SQL_SCCO_OPT_TIMESTAMP* = SQL_SCCO_OPT_ROWVER
  SQL_CC_DELETE* = SQL_CB_DELETE
  SQL_CR_DELETE* = SQL_CB_DELETE
  SQL_CC_CLOSE* = SQL_CB_CLOSE
  SQL_CR_CLOSE* = SQL_CB_CLOSE
  SQL_CC_PRESERVE* = SQL_CB_PRESERVE
  SQL_CR_PRESERVE* = SQL_CB_PRESERVE
  SQL_SCROLL_FORWARD_ONLY* = 0
  SQL_SCROLL_KEYSET_DRIVEN* = -1
  SQL_SCROLL_DYNAMIC* = -2
  SQL_SCROLL_STATIC* = -3
  traceVersion* = 1000
  TRACE_ON* = 0x00000001
  TRACE_VS_EVENT_ON* = 0x00000002
  ODBC_VS_FLAG_UNICODE_ARG* = 0x00000001
  ODBC_VS_FLAG_UNICODE_COR* = 0x00000002
  ODBC_VS_FLAG_RETCODE* = 0x00000004
  ODBC_VS_FLAG_STOP* = 0x00000008
  SQL_C_WCHAR* = SQL_WCHAR
  SQL_SQLSTATE_SIZEW* = 10
  ODBC_ADD_DSN* = 1
  ODBC_CONFIG_DSN* = 2
  ODBC_REMOVE_DSN* = 3
  ODBC_ADD_SYS_DSN* = 4
  ODBC_CONFIG_SYS_DSN* = 5
  ODBC_REMOVE_SYS_DSN* = 6
  ODBC_REMOVE_DEFAULT_DSN* = 7
  ODBC_INSTALL_INQUIRY* = 1
  ODBC_INSTALL_COMPLETE* = 2
  ODBC_INSTALL_DRIVER* = 1
  ODBC_REMOVE_DRIVER* = 2
  ODBC_CONFIG_DRIVER* = 3
  ODBC_CONFIG_DRIVER_MAX* = 100
  ODBC_BOTH_DSN* = 0
  ODBC_USER_DSN* = 1
  ODBC_SYSTEM_DSN* = 2
  ODBC_ERROR_GENERAL_ERR* = 1
  ODBC_ERROR_INVALID_BUFF_LEN* = 2
  ODBC_ERROR_INVALID_HWND* = 3
  ODBC_ERROR_INVALID_STR* = 4
  ODBC_ERROR_INVALID_REQUEST_TYPE* = 5
  ODBC_ERROR_COMPONENT_NOT_FOUND* = 6
  ODBC_ERROR_INVALID_NAME* = 7
  ODBC_ERROR_INVALID_KEYWORD_VALUE* = 8
  ODBC_ERROR_INVALID_DSN* = 9
  ODBC_ERROR_INVALID_INF* = 10
  ODBC_ERROR_REQUEST_FAILED* = 11
  ODBC_ERROR_INVALID_PATH* = 12
  ODBC_ERROR_LOAD_LIB_FAILED* = 13
  ODBC_ERROR_INVALID_PARAM_SEQUENCE* = 14
  ODBC_ERROR_INVALID_LOG_FILE* = 15
  ODBC_ERROR_USER_CANCELED* = 16
  ODBC_ERROR_USAGE_UPDATE_FAILED* = 17
  ODBC_ERROR_CREATE_DSN_FAILED* = 18
  ODBC_ERROR_WRITING_SYSINFO_FAILED* = 19
  ODBC_ERROR_REMOVE_DSN_FAILED* = 20
  ODBC_ERROR_OUT_OF_MEM* = 21
  ODBC_ERROR_OUTPUT_STRING_TRUNCATED* = 22
  SQL_ODBC_KEYWORDS* = "ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHAR_LENGTH,CHARACTER,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PASCAL,PLI,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWSSCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCA,SQLCODE,SQLERROR,SQLSTATE,SQLWARNING,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE"
type
  TSQL_YEAR_MONTH_STRUCT* {.pure.} = object
    year*: TSQLUINTEGER
    month*: TSQLUINTEGER
  TSQL_DAY_SECOND_STRUCT* {.pure.} = object
    day*: TSQLUINTEGER
    hour*: TSQLUINTEGER
    minute*: TSQLUINTEGER
    second*: TSQLUINTEGER
    fraction*: TSQLUINTEGER
  SQL_INTERVAL_STRUCT_intval* {.pure, union.} = object
    year_month*: TSQL_YEAR_MONTH_STRUCT
    day_second*: TSQL_DAY_SECOND_STRUCT
  TSQL_INTERVAL_STRUCT* {.pure.} = object
    interval_type*: TSQLINTERVAL
    interval_sign*: TSQLSMALLINT
    intval*: SQL_INTERVAL_STRUCT_intval
  TSQL_NUMERIC_STRUCT* {.pure.} = object
    precision*: TSQLCHAR
    scale*: TSQLSCHAR
    sign*: TSQLCHAR
    val*: array[SQL_MAX_NUMERIC_LEN, TSQLCHAR]
proc SQLAllocConnect*(EnvironmentHandle: TSQLHENV, ConnectionHandle: ptr TSQLHDBC): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLAllocEnv*(EnvironmentHandle: ptr TSQLHENV): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLAllocHandle*(HandleType: TSQLSMALLINT, InputHandle: TSQLHANDLE, OutputHandle: ptr TSQLHANDLE): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLAllocStmt*(ConnectionHandle: TSQLHDBC, StatementHandle: ptr TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBindCol*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, TargetType: TSQLSMALLINT, TargetValue: TSQLPOINTER, BufferLength: TSQLLEN, StrLen_or_Ind: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBindParam*(StatementHandle: TSQLHSTMT, ParameterNumber: TSQLUSMALLINT, ValueType: TSQLSMALLINT, ParameterType: TSQLSMALLINT, LengthPrecision: TSQLULEN, ParameterScale: TSQLSMALLINT, ParameterValue: TSQLPOINTER, StrLen_or_Ind: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLCancel*(StatementHandle: TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLCloseCursor*(StatementHandle: TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLCopyDesc*(SourceDescHandle: TSQLHDESC, TargetDescHandle: TSQLHDESC): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDisconnect*(ConnectionHandle: TSQLHDBC): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLEndTran*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, CompletionType: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLExecute*(StatementHandle: TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFetch*(StatementHandle: TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFetchScroll*(StatementHandle: TSQLHSTMT, FetchOrientation: TSQLSMALLINT, FetchOffset: TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFreeConnect*(ConnectionHandle: TSQLHDBC): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFreeEnv*(EnvironmentHandle: TSQLHENV): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFreeHandle*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLFreeStmt*(StatementHandle: TSQLHSTMT, Option: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetData*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, TargetType: TSQLSMALLINT, TargetValue: TSQLPOINTER, BufferLength: TSQLLEN, StrLen_or_Ind: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetEnvAttr*(EnvironmentHandle: TSQLHENV, Attribute: TSQLINTEGER, Value: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLength: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetFunctions*(ConnectionHandle: TSQLHDBC, FunctionId: TSQLUSMALLINT, Supported: ptr TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetStmtOption*(StatementHandle: TSQLHSTMT, Option: TSQLUSMALLINT, Value: TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLNumResultCols*(StatementHandle: TSQLHSTMT, ColumnCount: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLParamData*(StatementHandle: TSQLHSTMT, Value: ptr TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLPutData*(StatementHandle: TSQLHSTMT, Data: TSQLPOINTER, StrLen_or_Ind: TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLRowCount*(StatementHandle: TSQLHSTMT, RowCount: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetDescRec*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, Type: TSQLSMALLINT, SubType: TSQLSMALLINT, Length: TSQLLEN, Precision: TSQLSMALLINT, Scale: TSQLSMALLINT, Data: TSQLPOINTER, StringLength: ptr TSQLLEN, Indicator: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetEnvAttr*(EnvironmentHandle: TSQLHENV, Attribute: TSQLINTEGER, Value: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetParam*(StatementHandle: TSQLHSTMT, ParameterNumber: TSQLUSMALLINT, ValueType: TSQLSMALLINT, ParameterType: TSQLSMALLINT, LengthPrecision: TSQLULEN, ParameterScale: TSQLSMALLINT, ParameterValue: TSQLPOINTER, StrLen_or_Ind: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetStmtOption*(StatementHandle: TSQLHSTMT, Option: TSQLUSMALLINT, Value: TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLTransact*(EnvironmentHandle: TSQLHENV, ConnectionHandle: TSQLHDBC, CompletionType: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBulkOperations*(StatementHandle: TSQLHSTMT, Operation: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDescribeParam*(StatementHandle: TSQLHSTMT, ParameterNumber: TSQLUSMALLINT, DataTypePtr: ptr TSQLSMALLINT, ParameterSizePtr: ptr TSQLULEN, DecimalDigitsPtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLExtendedFetch*(StatementHandle: TSQLHSTMT, FetchOrientation: TSQLUSMALLINT, FetchOffset: TSQLLEN, RowCountPtr: ptr TSQLULEN, RowStatusArray: ptr TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLMoreResults*(StatementHandle: TSQLHSTMT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLNumParams*(StatementHandle: TSQLHSTMT, ParameterCountPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLParamOptions*(hstmt: TSQLHSTMT, crow: TSQLULEN, pirow: ptr TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
when winimCpu64:
  type
    TSQLSETPOSIROW* = UINT64
when winimCpu32:
  type
    TSQLSETPOSIROW* = TSQLUSMALLINT
proc SQLSetPos*(StatementHandle: TSQLHSTMT, RowNumber: TSQLSETPOSIROW, Operation: TSQLUSMALLINT, LockType: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBindParameter*(StatementHandle: TSQLHSTMT, ParameterNumber: TSQLUSMALLINT, InputOutputType: TSQLSMALLINT, ValueType: TSQLSMALLINT, ParameterType: TSQLSMALLINT, ColumnSize: TSQLULEN, DecimalDigits: TSQLSMALLINT, ParameterValuePtr: TSQLPOINTER, BufferLength: TSQLLEN, StrLen_or_IndPtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLAllocHandleStd*(fHandleType: TSQLSMALLINT, hInput: TSQLHANDLE, phOutput: ptr TSQLHANDLE): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetScrollOptions*(hstmt: TSQLHSTMT, fConcurrency: TSQLUSMALLINT, crowKeyset: TSQLLEN, crowRowset: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc TraceOpenLogFile*(P1: LPWSTR, P2: LPWSTR, P3: DWORD): RETCODE {.winapi, stdcall, dynlib: "odbctrac", importc.}
proc TraceCloseLogFile*(): RETCODE {.winapi, stdcall, dynlib: "odbctrac", importc.}
proc TraceReturn*(P1: RETCODE, P2: RETCODE): VOID {.winapi, stdcall, dynlib: "odbctrac", importc.}
proc TraceVersion*(): DWORD {.winapi, stdcall, dynlib: "odbctrac", importc.}
proc TraceVSControl*(P1: DWORD): RETCODE {.winapi, stdcall, dynlib: "odbctrac", importc.}
proc ODBCSetTryWaitValue*(dwValue: DWORD): WINBOOL {.winapi, stdcall, dynlib: "odbc32", importc.}
proc ODBCGetTryWaitValue*(): DWORD {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColAttributeW*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColAttributesW*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLConnectW*(ConnectionHandle: TSQLHDBC, ServerName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, UserName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, Authentication: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDescribeColW*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, ColumnName: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT, DataTypePtr: ptr TSQLSMALLINT, ColumnSizePtr: ptr TSQLULEN, DecimalDigitsPtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLErrorW*(EnvironmentHandle: TSQLHENV, ConnectionHandle: TSQLHDBC, StatementHandle: TSQLHSTMT, Sqlstate: ptr TSQLWCHAR, NativeError: ptr TSQLINTEGER, MessageText: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, TextLength: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLExecDirectW*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLWCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetConnectAttrW*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetCursorNameW*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetDescFieldW*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, Value: TSQLPOINTER, BufferLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDescFieldW*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDescRecW*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, Name: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, TypePtr: ptr TSQLSMALLINT, SubTypePtr: ptr TSQLSMALLINT, LengthPtr: ptr TSQLLEN, PrecisionPtr: ptr TSQLSMALLINT, ScalePtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDiagFieldW*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, DiagIdentifier: TSQLSMALLINT, DiagInfoPtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDiagRecW*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, SQLState: ptr TSQLWCHAR, NativeErrorPtr: ptr TSQLINTEGER, MessageText: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, TextLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLPrepareW*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLWCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetConnectAttrW*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetCursorNameW*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLWCHAR, NameLength: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColumnsW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetConnectOptionW*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetInfoW*(ConnectionHandle: TSQLHDBC, InfoType: TSQLUSMALLINT, InfoValuePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetTypeInfoW*(StatementHandle: TSQLHSTMT, DataType: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetConnectOptionW*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSpecialColumnsW*(StatementHandle: TSQLHSTMT, IdentifierType: TSQLUSMALLINT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, Scope: TSQLUSMALLINT, Nullable: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLStatisticsW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, Unique: TSQLUSMALLINT, Reserved: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLTablesW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, TableType: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDataSourcesW*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, ServerName: ptr TSQLWCHAR, BufferLength1: TSQLSMALLINT, NameLength1Ptr: ptr TSQLSMALLINT, Description: ptr TSQLWCHAR, BufferLength2: TSQLSMALLINT, NameLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDriverConnectW*(ConnectionHandle: TSQLHDBC, WindowHandle: TSQLHWND, InConnectionString: ptr TSQLWCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT, DriverCompletion: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBrowseConnectW*(ConnectionHandle: TSQLHDBC, InConnectionString: ptr TSQLWCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColumnPrivilegesW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetStmtAttrW*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetStmtAttrW*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLForeignKeysW*(StatementHandle: TSQLHSTMT, PKCatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, PKSchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, PKTableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, FKCatalogName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT, FKSchemaName: ptr TSQLWCHAR, NameLength5: TSQLSMALLINT, FKTableName: ptr TSQLWCHAR, NameLength6: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLNativeSqlW*(ConnectionHandle: TSQLHDBC, InStatementText: ptr TSQLWCHAR, TextLength1: TSQLINTEGER, OutStatementText: ptr TSQLWCHAR, BufferLength: TSQLINTEGER, TextLength2Ptr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLPrimaryKeysW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLProcedureColumnsW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLProceduresW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLTablePrivilegesW*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDriversW*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, DriverDescription: ptr TSQLWCHAR, BufferLength1: TSQLSMALLINT, DescriptionLengthPtr: ptr TSQLSMALLINT, DriverAttributes: ptr TSQLWCHAR, BufferLength2: TSQLSMALLINT, AttributesLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColAttributeA*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColAttributesA*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLConnectA*(ConnectionHandle: TSQLHDBC, ServerName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, UserName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, Authentication: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDescribeColA*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, ColumnName: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT, DataTypePtr: ptr TSQLSMALLINT, ColumnSizePtr: ptr TSQLUINTEGER, DecimalDigitsPtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLErrorA*(EnvironmentHandle: TSQLHENV, ConnectionHandle: TSQLHDBC, StatementHandle: TSQLHSTMT, Sqlstate: ptr TSQLCHAR, NativeError: ptr TSQLINTEGER, MessageText: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, TextLength: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLExecDirectA*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetConnectAttrA*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetCursorNameA*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDescFieldA*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDescRecA*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, Name: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, TypePtr: ptr TSQLSMALLINT, SubTypePtr: ptr TSQLSMALLINT, LengthPtr: ptr TSQLINTEGER, PrecisionPtr: ptr TSQLSMALLINT, ScalePtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDiagFieldA*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, DiagIdentifier: TSQLSMALLINT, DiagInfoPtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetDiagRecA*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, SQLState: ptr TSQLCHAR, NativeErrorPtr: ptr TSQLINTEGER, MessageText: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, TextLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetStmtAttrA*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetTypeInfoA*(StatementHandle: TSQLHSTMT, DataTyoe: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLPrepareA*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetConnectAttrA*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetCursorNameA*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLCHAR, NameLength: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColumnsA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetConnectOptionA*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLGetInfoA*(ConnectionHandle: TSQLHDBC, InfoType: TSQLUSMALLINT, InfoValuePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSetConnectOptionA*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLSpecialColumnsA*(StatementHandle: TSQLHSTMT, IdentifierType: TSQLUSMALLINT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, Scope: TSQLUSMALLINT, Nullable: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLStatisticsA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, Unique: TSQLUSMALLINT, Reserved: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLTablesA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, TableType: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDataSourcesA*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, ServerName: ptr TSQLCHAR, BufferLength1: TSQLSMALLINT, NameLength1Ptr: ptr TSQLSMALLINT, Description: ptr TSQLCHAR, BufferLength2: TSQLSMALLINT, NameLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDriverConnectA*(ConnectionHandle: TSQLHDBC, WindowHandle: TSQLHWND, InConnectionString: ptr TSQLCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT, DriverCompletion: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLBrowseConnectA*(ConnectionHandle: TSQLHDBC, InConnectionString: ptr TSQLCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLColumnPrivilegesA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLForeignKeysA*(StatementHandle: TSQLHSTMT, PKCatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, PKSchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, PKTableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, FKCatalogName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT, FKSchemaName: ptr TSQLCHAR, NameLength5: TSQLSMALLINT, FKTableName: ptr TSQLCHAR, NameLength6: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLNativeSqlA*(ConnectionHandle: TSQLHDBC, InStatementText: ptr TSQLCHAR, TextLength1: TSQLINTEGER, OutStatementText: ptr TSQLCHAR, BufferLength: TSQLINTEGER, TextLength2Ptr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLPrimaryKeysA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLProcedureColumnsA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLProceduresA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLTablePrivilegesA*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLDriversA*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, DriverDescription: ptr TSQLCHAR, BufferLength1: TSQLSMALLINT, DescriptionLengthPtr: ptr TSQLSMALLINT, DriverAttributes: ptr TSQLCHAR, BufferLength2: TSQLSMALLINT, AttributesLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc.}
proc SQLInstallODBC*(hwndParent: HWND, lpszInfFile: LPCSTR, lpszSrcPath: LPCSTR, lpszDrivers: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLManageDataSources*(hwndParent: HWND): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLCreateDataSource*(hwndParent: HWND, lpszDSN: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetTranslator*(hwnd: HWND, lpszName: LPSTR, cbNameMax: WORD, pcbNameOut: ptr WORD, lpszPath: LPSTR, cbPathMax: WORD, pcbPathOut: ptr WORD, pvOption: ptr DWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriver*(lpszInfFile: LPCSTR, lpszDriver: LPCSTR, lpszPath: LPSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriverManager*(lpszPath: LPSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetInstalledDrivers*(lpszBuf: LPSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetAvailableDrivers*(lpszInfFile: LPCSTR, lpszBuf: LPSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLConfigDataSource*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCSTR, lpszAttributes: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDefaultDataSource*(): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWriteDSNToIni*(lpszDSN: LPCSTR, lpszDriver: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDSNFromIni*(lpszDSN: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLValidDSN*(lpszDSN: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWritePrivateProfileString*(lpszSection: LPCSTR, lpszEntry: LPCSTR, lpszString: LPCSTR, lpszFilename: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetPrivateProfileString*(lpszSection: LPCSTR, lpszEntry: LPCSTR, lpszDefault: LPCSTR, lpszRetBuffer: LPSTR, cbRetBuffer: int32, lpszFilename: LPCSTR): int32 {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDriverManager*(lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallTranslator*(lpszInfFile: LPCSTR, lpszTranslator: LPCSTR, lpszPathIn: LPCSTR, lpszPathOut: LPSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveTranslator*(lpszTranslator: LPCSTR, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDriver*(lpszDriver: LPCSTR, fRemoveDSN: WINBOOL, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLConfigDriver*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCSTR, lpszArgs: LPCSTR, lpszMsg: LPSTR, cbMsgMax: WORD, pcbMsgOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallerError*(iError: WORD, pfErrorCode: ptr DWORD, lpszErrorMsg: LPSTR, cbErrorMsgMax: WORD, pcbErrorMsg: ptr WORD): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLPostInstallerError*(dwErrorCode: DWORD, lpszErrMsg: LPCSTR): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWriteFileDSN*(lpszFileName: LPCSTR, lpszAppName: LPCSTR, lpszKeyName: LPCSTR, lpszString: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLReadFileDSN*(lpszFileName: LPCSTR, lpszAppName: LPCSTR, lpszKeyName: LPCSTR, lpszString: LPSTR, cbString: WORD, pcbString: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriverEx*(lpszDriver: LPCSTR, lpszPathIn: LPCSTR, lpszPathOut: LPSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallTranslatorEx*(lpszTranslator: LPCSTR, lpszPathIn: LPCSTR, lpszPathOut: LPSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetConfigMode*(pwConfigMode: ptr UWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLSetConfigMode*(wConfigMode: UWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallODBCW*(hwndParent: HWND, lpszInfFile: LPCWSTR, lpszSrcPath: LPCWSTR, lpszDrivers: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLCreateDataSourceW*(hwndParent: HWND, lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetTranslatorW*(hwnd: HWND, lpszName: LPWSTR, cbNameMax: WORD, pcbNameOut: ptr WORD, lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD, pvOption: ptr DWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriverW*(lpszInfFile: LPCWSTR, lpszDriver: LPCWSTR, lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriverManagerW*(lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetInstalledDriversW*(lpszBuf: LPWSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetAvailableDriversW*(lpszInfFile: LPCWSTR, lpszBuf: LPWSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLConfigDataSourceW*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCWSTR, lpszAttributes: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWriteDSNToIniW*(lpszDSN: LPCWSTR, lpszDriver: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDSNFromIniW*(lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLValidDSNW*(lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWritePrivateProfileStringW*(lpszSection: LPCWSTR, lpszEntry: LPCWSTR, lpszString: LPCWSTR, lpszFilename: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLGetPrivateProfileStringW*(lpszSection: LPCWSTR, lpszEntry: LPCWSTR, lpszDefault: LPCWSTR, lpszRetBuffer: LPWSTR, cbRetBuffer: int32, lpszFilename: LPCWSTR): int32 {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallTranslatorW*(lpszInfFile: LPCWSTR, lpszTranslator: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveTranslatorW*(lpszTranslator: LPCWSTR, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLRemoveDriverW*(lpszDriver: LPCWSTR, fRemoveDSN: WINBOOL, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLConfigDriverW*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCWSTR, lpszArgs: LPCWSTR, lpszMsg: LPWSTR, cbMsgMax: WORD, pcbMsgOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallerErrorW*(iError: WORD, pfErrorCode: ptr DWORD, lpszErrorMsg: LPWSTR, cbErrorMsgMax: WORD, pcbErrorMsg: ptr WORD): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLPostInstallerErrorW*(dwErrorCode: DWORD, lpszErrorMsg: LPCWSTR): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLWriteFileDSNW*(lpszFileName: LPCWSTR, lpszAppName: LPCWSTR, lpszKeyName: LPCWSTR, lpszString: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLReadFileDSNW*(lpszFileName: LPCWSTR, lpszAppName: LPCWSTR, lpszKeyName: LPCWSTR, lpszString: LPWSTR, cbString: WORD, pcbString: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallDriverExW*(lpszDriver: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLInstallTranslatorExW*(lpszTranslator: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc.}
proc SQLAllocHandle*(fHandleType: TSQLSMALLINT, hInput: TSQLHANDLE, phOutput: ptr TSQLHANDLE): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLAllocHandleStd".}
proc `wszArg=`*(self: var ODBC_VS_ARGS, x: ptr WCHAR) {.inline.} = self.union1.wszArg = x
proc wszArg*(self: ODBC_VS_ARGS): ptr WCHAR {.inline.} = self.union1.wszArg
proc wszArg*(self: var ODBC_VS_ARGS): var ptr WCHAR {.inline.} = self.union1.wszArg
proc `szArg=`*(self: var ODBC_VS_ARGS, x: ptr CHAR) {.inline.} = self.union1.szArg = x
proc szArg*(self: ODBC_VS_ARGS): ptr CHAR {.inline.} = self.union1.szArg
proc szArg*(self: var ODBC_VS_ARGS): var ptr CHAR {.inline.} = self.union1.szArg
proc `wszCorrelation=`*(self: var ODBC_VS_ARGS, x: ptr WCHAR) {.inline.} = self.union2.wszCorrelation = x
proc wszCorrelation*(self: ODBC_VS_ARGS): ptr WCHAR {.inline.} = self.union2.wszCorrelation
proc wszCorrelation*(self: var ODBC_VS_ARGS): var ptr WCHAR {.inline.} = self.union2.wszCorrelation
proc `szCorrelation=`*(self: var ODBC_VS_ARGS, x: ptr CHAR) {.inline.} = self.union2.szCorrelation = x
proc szCorrelation*(self: ODBC_VS_ARGS): ptr CHAR {.inline.} = self.union2.szCorrelation
proc szCorrelation*(self: var ODBC_VS_ARGS): var ptr CHAR {.inline.} = self.union2.szCorrelation
when winimUnicode:
  type
    TSQLTCHAR* = TSQLWCHAR
  const
    SQL_C_TCHAR* = SQL_C_WCHAR
  proc SQLColAttribute*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColAttributeW".}
  proc SQLColAttributes*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColAttributesW".}
  proc SQLConnect*(ConnectionHandle: TSQLHDBC, ServerName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, UserName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, Authentication: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLConnectW".}
  proc SQLDescribeCol*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, ColumnName: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT, DataTypePtr: ptr TSQLSMALLINT, ColumnSizePtr: ptr TSQLULEN, DecimalDigitsPtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDescribeColW".}
  proc SQLError*(EnvironmentHandle: TSQLHENV, ConnectionHandle: TSQLHDBC, StatementHandle: TSQLHSTMT, Sqlstate: ptr TSQLWCHAR, NativeError: ptr TSQLINTEGER, MessageText: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, TextLength: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLErrorW".}
  proc SQLExecDirect*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLWCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLExecDirectW".}
  proc SQLGetConnectAttr*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetConnectAttrW".}
  proc SQLGetCursorName*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetCursorNameW".}
  proc SQLGetDescField*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDescFieldW".}
  proc SQLGetDescRec*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, Name: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, TypePtr: ptr TSQLSMALLINT, SubTypePtr: ptr TSQLSMALLINT, LengthPtr: ptr TSQLLEN, PrecisionPtr: ptr TSQLSMALLINT, ScalePtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDescRecW".}
  proc SQLGetDiagField*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, DiagIdentifier: TSQLSMALLINT, DiagInfoPtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDiagFieldW".}
  proc SQLGetDiagRec*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, SQLState: ptr TSQLWCHAR, NativeErrorPtr: ptr TSQLINTEGER, MessageText: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, TextLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDiagRecW".}
  proc SQLPrepare*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLWCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLPrepareW".}
  proc SQLSetConnectAttr*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetConnectAttrW".}
  proc SQLSetCursorName*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLWCHAR, NameLength: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetCursorNameW".}
  proc SQLSetDescField*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, Value: TSQLPOINTER, BufferLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetDescFieldW".}
  proc SQLSetStmtAttr*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetStmtAttrW".}
  proc SQLGetStmtAttr*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetStmtAttrW".}
  proc SQLColumns*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColumnsW".}
  proc SQLGetConnectOption*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetConnectOptionW".}
  proc SQLGetInfo*(ConnectionHandle: TSQLHDBC, InfoType: TSQLUSMALLINT, InfoValuePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetInfoW".}
  proc SQLGetTypeInfo*(StatementHandle: TSQLHSTMT, DataType: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetTypeInfoW".}
  proc SQLSetConnectOption*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetConnectOptionW".}
  proc SQLSpecialColumns*(StatementHandle: TSQLHSTMT, IdentifierType: TSQLUSMALLINT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, Scope: TSQLUSMALLINT, Nullable: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSpecialColumnsW".}
  proc SQLStatistics*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, Unique: TSQLUSMALLINT, Reserved: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLStatisticsW".}
  proc SQLTables*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, TableType: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLTablesW".}
  proc SQLDataSources*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, ServerName: ptr TSQLWCHAR, BufferLength1: TSQLSMALLINT, NameLength1Ptr: ptr TSQLSMALLINT, Description: ptr TSQLWCHAR, BufferLength2: TSQLSMALLINT, NameLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDataSourcesW".}
  proc SQLDriverConnect*(ConnectionHandle: TSQLHDBC, WindowHandle: TSQLHWND, InConnectionString: ptr TSQLWCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT, DriverCompletion: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDriverConnectW".}
  proc SQLBrowseConnect*(ConnectionHandle: TSQLHDBC, InConnectionString: ptr TSQLWCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLWCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLBrowseConnectW".}
  proc SQLColumnPrivileges*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColumnPrivilegesW".}
  proc SQLForeignKeys*(StatementHandle: TSQLHSTMT, PKCatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, PKSchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, PKTableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, FKCatalogName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT, FKSchemaName: ptr TSQLWCHAR, NameLength5: TSQLSMALLINT, FKTableName: ptr TSQLWCHAR, NameLength6: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLForeignKeysW".}
  proc SQLNativeSql*(ConnectionHandle: TSQLHDBC, InStatementText: ptr TSQLWCHAR, TextLength1: TSQLINTEGER, OutStatementText: ptr TSQLWCHAR, BufferLength: TSQLINTEGER, TextLength2Ptr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLNativeSqlW".}
  proc SQLPrimaryKeys*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLPrimaryKeysW".}
  proc SQLProcedureColumns*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLWCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLProcedureColumnsW".}
  proc SQLProcedures*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLProceduresW".}
  proc SQLTablePrivileges*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLWCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLWCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLWCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLTablePrivilegesW".}
  proc SQLDrivers*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, DriverDescription: ptr TSQLWCHAR, BufferLength1: TSQLSMALLINT, DescriptionLengthPtr: ptr TSQLSMALLINT, DriverAttributes: ptr TSQLWCHAR, BufferLength2: TSQLSMALLINT, AttributesLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDriversW".}
  proc SQLInstallODBC*(hwndParent: HWND, lpszInfFile: LPCWSTR, lpszSrcPath: LPCWSTR, lpszDrivers: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallODBCW".}
  proc SQLCreateDataSource*(hwndParent: HWND, lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLCreateDataSourceW".}
  proc SQLGetTranslator*(hwnd: HWND, lpszName: LPWSTR, cbNameMax: WORD, pcbNameOut: ptr WORD, lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD, pvOption: ptr DWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLGetTranslatorW".}
  proc SQLInstallDriver*(lpszInfFile: LPCWSTR, lpszDriver: LPCWSTR, lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallDriverW".}
  proc SQLInstallDriverManager*(lpszPath: LPWSTR, cbPathMax: WORD, pcbPathOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallDriverManagerW".}
  proc SQLGetInstalledDrivers*(lpszBuf: LPWSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLGetInstalledDriversW".}
  proc SQLGetAvailableDrivers*(lpszInfFile: LPCWSTR, lpszBuf: LPWSTR, cbBufMax: WORD, pcbBufOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLGetAvailableDriversW".}
  proc SQLConfigDataSource*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCWSTR, lpszAttributes: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLConfigDataSourceW".}
  proc SQLWriteDSNToIni*(lpszDSN: LPCWSTR, lpszDriver: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLWriteDSNToIniW".}
  proc SQLRemoveDSNFromIni*(lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLRemoveDSNFromIniW".}
  proc SQLValidDSN*(lpszDSN: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLValidDSNW".}
  proc SQLWritePrivateProfileString*(lpszSection: LPCWSTR, lpszEntry: LPCWSTR, lpszString: LPCWSTR, lpszFilename: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLWritePrivateProfileStringW".}
  proc SQLGetPrivateProfileString*(lpszSection: LPCWSTR, lpszEntry: LPCWSTR, lpszDefault: LPCWSTR, lpszRetBuffer: LPWSTR, cbRetBuffer: int32, lpszFilename: LPCWSTR): int32 {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLGetPrivateProfileStringW".}
  proc SQLInstallTranslator*(lpszInfFile: LPCWSTR, lpszTranslator: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallTranslatorW".}
  proc SQLRemoveTranslator*(lpszTranslator: LPCWSTR, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLRemoveTranslatorW".}
  proc SQLRemoveDriver*(lpszDriver: LPCWSTR, fRemoveDSN: WINBOOL, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLRemoveDriverW".}
  proc SQLConfigDriver*(hwndParent: HWND, fRequest: WORD, lpszDriver: LPCWSTR, lpszArgs: LPCWSTR, lpszMsg: LPWSTR, cbMsgMax: WORD, pcbMsgOut: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLConfigDriverW".}
  proc SQLInstallerError*(iError: WORD, pfErrorCode: ptr DWORD, lpszErrorMsg: LPWSTR, cbErrorMsgMax: WORD, pcbErrorMsg: ptr WORD): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallerErrorW".}
  proc SQLPostInstallerError*(dwErrorCode: DWORD, lpszErrorMsg: LPCWSTR): TSQLRETURN {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLPostInstallerErrorW".}
  proc SQLReadFileDSN*(lpszFileName: LPCWSTR, lpszAppName: LPCWSTR, lpszKeyName: LPCWSTR, lpszString: LPWSTR, cbString: WORD, pcbString: ptr WORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLReadFileDSNW".}
  proc SQLWriteFileDSN*(lpszFileName: LPCWSTR, lpszAppName: LPCWSTR, lpszKeyName: LPCWSTR, lpszString: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLWriteFileDSNW".}
  proc SQLInstallDriverEx*(lpszDriver: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallDriverExW".}
  proc SQLInstallTranslatorEx*(lpszTranslator: LPCWSTR, lpszPathIn: LPCWSTR, lpszPathOut: LPWSTR, cbPathOutMax: WORD, pcbPathOut: ptr WORD, fRequest: WORD, lpdwUsageCount: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "odbccp32", importc: "SQLInstallTranslatorExW".}
when winimAnsi:
  type
    TSQLTCHAR* = TSQLCHAR
  const
    SQL_C_TCHAR* = SQL_C_CHAR
  proc SQLColAttribute*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColAttributeA".}
  proc SQLColumns*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColumnsA".}
  proc SQLConnect*(ConnectionHandle: TSQLHDBC, ServerName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, UserName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, Authentication: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLConnectA".}
  proc SQLDataSources*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, ServerName: ptr TSQLCHAR, BufferLength1: TSQLSMALLINT, NameLength1Ptr: ptr TSQLSMALLINT, Description: ptr TSQLCHAR, BufferLength2: TSQLSMALLINT, NameLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDataSourcesA".}
  proc SQLDescribeCol*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, ColumnName: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT, DataTypePtr: ptr TSQLSMALLINT, ColumnSizePtr: ptr TSQLULEN, DecimalDigitsPtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDescribeColA".}
  proc SQLError*(EnvironmentHandle: TSQLHENV, ConnectionHandle: TSQLHDBC, StatementHandle: TSQLHSTMT, Sqlstate: ptr TSQLCHAR, NativeError: ptr TSQLINTEGER, MessageText: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, TextLength: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLErrorA".}
  proc SQLExecDirect*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLExecDirectA".}
  proc SQLGetConnectAttr*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetConnectAttrA".}
  proc SQLGetConnectOption*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLPOINTER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetConnectOptionA".}
  proc SQLGetCursorName*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, NameLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetCursorNameA".}
  proc SQLGetDescField*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDescFieldA".}
  proc SQLGetDescRec*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, Name: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, TypePtr: ptr TSQLSMALLINT, SubTypePtr: ptr TSQLSMALLINT, LengthPtr: ptr TSQLLEN, PrecisionPtr: ptr TSQLSMALLINT, ScalePtr: ptr TSQLSMALLINT, NullablePtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDescRecA".}
  proc SQLGetDiagField*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, DiagIdentifier: TSQLSMALLINT, DiagInfoPtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDiagFieldA".}
  proc SQLGetDiagRec*(HandleType: TSQLSMALLINT, Handle: TSQLHANDLE, RecNumber: TSQLSMALLINT, SQLState: ptr TSQLCHAR, NativeErrorPtr: ptr TSQLINTEGER, MessageText: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, TextLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetDiagRecA".}
  proc SQLGetInfo*(ConnectionHandle: TSQLHDBC, InfoType: TSQLUSMALLINT, InfoValuePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetInfoA".}
  proc SQLGetStmtAttr*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, BufferLength: TSQLINTEGER, StringLengthPtr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetStmtAttrA".}
  proc SQLGetTypeInfo*(StatementHandle: TSQLHSTMT, DataType: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLGetTypeInfoA".}
  proc SQLPrepare*(StatementHandle: TSQLHSTMT, StatementText: ptr TSQLCHAR, TextLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLPrepareA".}
  proc SQLSetConnectAttr*(ConnectionHandle: TSQLHDBC, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetConnectAttrA".}
  proc SQLSetConnectOption*(ConnectionHandle: TSQLHDBC, Option: TSQLUSMALLINT, Value: TSQLULEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetConnectOptionA".}
  proc SQLSetCursorName*(StatementHandle: TSQLHSTMT, CursorName: ptr TSQLCHAR, NameLength: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetCursorNameA".}
  proc SQLSetDescField*(DescriptorHandle: TSQLHDESC, RecNumber: TSQLSMALLINT, FieldIdentifier: TSQLSMALLINT, Value: TSQLPOINTER, BufferLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetDescFieldA".}
  proc SQLSetStmtAttr*(StatementHandle: TSQLHSTMT, Attribute: TSQLINTEGER, ValuePtr: TSQLPOINTER, StringLength: TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSetStmtAttrA".}
  proc SQLSpecialColumns*(StatementHandle: TSQLHSTMT, IdentifierType: TSQLUSMALLINT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, Scope: TSQLUSMALLINT, Nullable: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLSpecialColumnsA".}
  proc SQLStatistics*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, Unique: TSQLUSMALLINT, Reserved: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLStatisticsA".}
  proc SQLTables*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, TableType: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLTablesA".}
  proc SQLDriverConnect*(ConnectionHandle: TSQLHDBC, WindowHandle: TSQLHWND, InConnectionString: ptr TSQLCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT, DriverCompletion: TSQLUSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDriverConnectA".}
  proc SQLBrowseConnect*(ConnectionHandle: TSQLHDBC, InConnectionString: ptr TSQLCHAR, StringLength1: TSQLSMALLINT, OutConnectionString: ptr TSQLCHAR, BufferLength: TSQLSMALLINT, StringLength2Ptr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLBrowseConnectA".}
  proc SQLColAttributes*(StatementHandle: TSQLHSTMT, ColumnNumber: TSQLUSMALLINT, FieldIdentifier: TSQLUSMALLINT, CharacterAttributePtr: TSQLPOINTER, BufferLength: TSQLSMALLINT, StringLengthPtr: ptr TSQLSMALLINT, NumericAttributePtr: ptr TSQLLEN): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColAttributesA".}
  proc SQLColumnPrivileges*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLColumnPrivilegesA".}
  proc SQLForeignKeys*(StatementHandle: TSQLHSTMT, PKCatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, PKSchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, PKTableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, FKCatalogName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT, FKSchemaName: ptr TSQLCHAR, NameLength5: TSQLSMALLINT, FKTableName: ptr TSQLCHAR, NameLength6: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLForeignKeysA".}
  proc SQLNativeSql*(ConnectionHandle: TSQLHDBC, InStatementText: ptr TSQLCHAR, TextLength1: TSQLINTEGER, OutStatementText: ptr TSQLCHAR, BufferLength: TSQLINTEGER, TextLength2Ptr: ptr TSQLINTEGER): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLNativeSqlA".}
  proc SQLPrimaryKeys*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLPrimaryKeysA".}
  proc SQLProcedureColumns*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT, ColumnName: ptr TSQLCHAR, NameLength4: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLProcedureColumnsA".}
  proc SQLProcedures*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, ProcName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLProceduresA".}
  proc SQLTablePrivileges*(StatementHandle: TSQLHSTMT, CatalogName: ptr TSQLCHAR, NameLength1: TSQLSMALLINT, SchemaName: ptr TSQLCHAR, NameLength2: TSQLSMALLINT, TableName: ptr TSQLCHAR, NameLength3: TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLTablePrivilegesA".}
  proc SQLDrivers*(EnvironmentHandle: TSQLHENV, Direction: TSQLUSMALLINT, DriverDescription: ptr TSQLCHAR, BufferLength1: TSQLSMALLINT, DescriptionLengthPtr: ptr TSQLSMALLINT, DriverAttributes: ptr TSQLCHAR, BufferLength2: TSQLSMALLINT, AttributesLengthPtr: ptr TSQLSMALLINT): TSQLRETURN {.winapi, stdcall, dynlib: "odbc32", importc: "SQLDriversA".}
when winimCpu64:
  const
    SQL_C_BOOKMARK* = SQL_C_UBIGINT
when winimCpu32:
  const
    SQL_C_BOOKMARK* = SQL_C_ULONG
