11\. Container With Most Water

Medium

You are given an integer array `height` of length `n`. There are `n` vertical lines drawn such that the two endpoints of the <code>i<sup>th</sup></code> line are `(i, 0)` and `(i, height[i])`.

Find two lines that together with the x-axis form a container, such that the container contains the most water.

Return _the maximum amount of water a container can store_.

**Notice** that you may not slant the container.

**Example 1:**

![](https://s3-lc-upload.s3.amazonaws.com/uploads/2018/07/17/question_11.jpg)

**Input:** height = [1,8,6,2,5,4,8,3,7]

**Output:** 49

**Explanation:** The above vertical lines are represented by array [1,8,6,2,5,4,8,3,7]. In this case, the max area of water (blue section) the container can contain is 49. 

**Example 2:**

**Input:** height = [1,1]

**Output:** 1 

**Constraints:**

*   `n == height.length`
*   <code>2 <= n <= 10<sup>5</sup></code>
*   <code>0 <= height[i] <= 10<sup>4</sup></code>

To solve the Container With Most Water problem in Java using a `Solution` class, we'll follow these steps:

1. Define a `Solution` class with a method named `maxArea` that takes an array of integers `height` as input and returns the maximum area of water that can be contained.
2. Initialize two pointers, `left` pointing to the start of the array and `right` pointing to the end of the array.
3. Initialize a variable `maxArea` to store the maximum area encountered so far, initially set to 0.
4. Iterate while `left` is less than `right`.
5. Calculate the current area using the formula: `(right - left) * min(height[left], height[right])`.
6. Update `maxArea` if the current area is greater than `maxArea`.
7. Move the pointer pointing to the smaller height towards the other pointer. If `height[left] < height[right]`, increment `left`, otherwise decrement `right`.
8. Continue the iteration until `left` becomes greater than or equal to `right`.
9. Return `maxArea`.

Here's the implementation:

```java
public class Solution {
    public int maxArea(int[] height) {
        int left = 0;
        int right = height.length - 1;
        int maxArea = 0;

        while (left < right) {
            int currentArea = (right - left) * Math.min(height[left], height[right]);
            maxArea = Math.max(maxArea, currentArea);

            if (height[left] < height[right]) {
                left++;
            } else {
                right--;
            }
        }

        return maxArea;
    }

    public static void main(String[] args) {
        Solution solution = new Solution();

        // Test cases
        int[] height1 = {1, 8, 6, 2, 5, 4, 8, 3, 7};
        System.out.println("Example 1 Output: " + solution.maxArea(height1));

        int[] height2 = {1, 1};
        System.out.println("Example 2 Output: " + solution.maxArea(height2));

        int[] height3 = {4, 3, 2, 1, 4};
        System.out.println("Example 3 Output: " + solution.maxArea(height3));

        int[] height4 = {1, 2, 1};
        System.out.println("Example 4 Output: " + solution.maxArea(height4));
    }
}
```

This implementation provides a solution to the Container With Most Water problem in Java.
