import { FormContainer } from '@/components/form-container';
import { Form } from '@/components/ui/form';
import { zodResolver } from '@hookform/resolvers/zod';
import { memo } from 'react';
import { useForm } from 'react-hook-form';
import { z } from 'zod';
import { FormWrapper } from '../../components/form-wrapper';
import { EmailFormPartialSchema, EmailFormWidgets } from '../../email-form';
import { useValues } from '../use-values';
import { useWatchFormChange } from '../use-watch-change';

function EmailForm() {
  const values = useValues();

  const FormSchema = z.object(EmailFormPartialSchema);

  const form = useForm<z.infer<typeof FormSchema>>({
    defaultValues: values,
    resolver: zodResolver(FormSchema),
  });

  useWatchFormChange(form);

  return (
    <Form {...form}>
      <FormWrapper>
        <FormContainer>
          <EmailFormWidgets></EmailFormWidgets>
        </FormContainer>
      </FormWrapper>
    </Form>
  );
}

export default memo(EmailForm);
