---
sidebar_position: 25
slug: /execute_sql
---

# Execute SQL tool

A tool that execute SQL queries on a specified relational database.

---

The **Execute SQL** tool enables you to connect to a relational database and run SQL queries, whether entered directly or generated by the system’s Text2SQL capability via an **Agent** component. 

## Prerequisites

- A database instance properly configured and running.
- The database must be one of the following types:
  - MySQL
  - PostgreSQL
  - MariaDB
  - Microsoft SQL Server

## Examples

You can pair an **Agent** component with the **Execute SQL** tool, with the **Agent** generating SQL statements and the **Execute SQL** tool handling database connection and query execution. An example of this setup can be found in the **SQL Assistant** Agent template shown below:

![](https://raw.githubusercontent.com/infiniflow/ragflow-docs/main/images/exeSQL.jpg)

## Configurations

### SQL statement

This text input field allows you to write static SQL queries, such as `SELECT * FROM my_table`, and dynamic SQL queries using variables.

:::tip NOTE
Click **(x)** or type `/` to insert variables.
:::

For dynamic SQL queries, you can include variables in your SQL queries, such as `SELECT * FROM /sys.query`; if an **Agent** component is paired with the **Execute SQL** tool to generate SQL tasks (see the [Examples](#examples) section), you can directly insert that **Agent**'s output, `content`, into this field.

### Database type

The supported database type. Currently the following database types are available:

- MySQL
- PostreSQL
- MariaDB
- Microsoft SQL Server (Myssql)

### Database

Appears only when you select **Split** as method.

### Username

The username with access privileges to the database.

### Host

The IP address of the database server.

### Port

The port number on which the database server is listening.

### Password

The password for the database user.

### Max records

The maximum number of records returned by the SQL query to control response size and improve efficiency. Defaults to `1024`.

### Output

The **Execute SQL** tool provides two output variables:

- `formalized_content`: A string. If you reference this variable in a **Message** component, the returned records are displayed as a table.
- `json`: An object array. If you reference this variable in a **Message** component, the returned records will be presented as key-value pairs.