﻿using System;
using System.IO;

namespace GroupDocs.Signature.Examples.CSharp.AdvancedUsage
{
    using GroupDocs.Signature;
    using GroupDocs.Signature.Options;

    public class GeneratePreviewAdvanced
    {
        /// <summary>
        /// Generate document pages preview with using HideSignature feature
        /// </summary>
        public static void Run()
        {
            Console.WriteLine("\n--------------------------------------------------------------------------------------------------------------------");
            Console.WriteLine("[Example Advanced Usage] # GeneratePreviewAdvanced : Generate document pages preview with using HideSignature feature\n");

            // The path to the documents directory.
            string filePath = Constants.SAMPLE_SIGNED_MULTI;

            using (Signature signature = new Signature(filePath))
            {
                // create preview options object
                PreviewOptions previewOption = new PreviewOptions(GeneratePreviewAdvanced.CreatePageStream, GeneratePreviewAdvanced.ReleasePageStream)
                {
                    PreviewFormat = PreviewOptions.PreviewFormats.JPEG,
                    // set property to hide all known signatures
                    HideSignatures = true
                };
                // generate preview
                signature.GeneratePreview(previewOption);
            }
        }

        //Since 23.09 there is possibility to use extended preview page data
        private static Stream CreatePageStream(PreviewPageData pageData)
        {
            string imageFilePath = Path.Combine(Constants.OutputPath, "GeneratePreviewHideSignatures",
                $"{pageData.FileName}-page-{pageData.PageNumber}.{pageData.PreviewFormat.ToString().ToLower()}");
            string folder = Path.GetDirectoryName(imageFilePath);
            if (!Directory.Exists(folder))
            {
                Directory.CreateDirectory(folder);
            }
            return new FileStream(imageFilePath, FileMode.Create);
        }

        //Since 23.09 there is possibility to use extended preview page data
        private static void ReleasePageStream(PreviewPageData pageData, Stream pageStream)
        {
            pageStream.Dispose();
            string imageFilePath = Path.Combine(Constants.OutputPath, "GeneratePreviewHideSignatures", 
                $"{pageData.FileName}-page-{pageData.PageNumber}.{pageData.PreviewFormat.ToString().ToLower()}");
            Console.WriteLine($"Image file {imageFilePath} is ready for preview");
        }
    }
}