#!/bin/sh
# Copyright 2009 The Go Authors. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.

# Generate Go code listing error values (ENAMETOOLONG etc)
# for Native Client.

echo '// mkerrors_nacl.sh' "$@"
echo '// MACHINE GENERATED BY THE COMMAND ABOVE; DO NOT EDIT'
echo
echo 'package syscall'
echo
echo 'const ('
perl -n -e '
	if(/#define\s+NACL_ABI_(\S*)\s+([0-9]+)/) {
		print "\t$1 = $2;\n"
	}
' $1
echo '	ENACL = 99;	/* otherwise unused */'
echo ')'
echo
echo
echo '// Error table'
echo 'var errors = [...]string {'
perl -n -e '
	if(/#define\s+NACL_ABI_(\S*)\s+([0-9]+)\s+\/\* (.*) \*\//) {
		$err = $1;
		$text = $3;
		if($text =~ /^[A-Z][a-z]/) {
			# lowercase first letter: Bad -> bad, but STREAM -> STREAM.
			$l = substr($text, 0, 1);
			$rest = substr($text, 1);
			$l =~ y/A-Z/a-z/;
			$text = $l . $rest;
		}
		print "\t$err: \"$text\",\n";
	}
' $1
echo '	ENACL: "not supported by native client",'
echo '}'
