"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtensionJustify = exports.getVersion = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const slash2_1 = __importDefault(require("slash2"));
const packagePath = slash2_1.default(path_1.default.join(__dirname, '../', 'package.json'));
/**
 * Get package version.
 *
 * @export getVersion
 * @returns {string}
 */
function getVersion() {
    const packageInfo = JSON.parse(fs_1.default.readFileSync(packagePath, 'utf8'));
    return (packageInfo && packageInfo.version) || 'invalid version!';
}
exports.getVersion = getVersion;
exports.ExtensionJustify = {
    '.ts': 'typescript',
    '.jsx': 'javascript',
    '.js': 'javascript',
    '.tsx': 'typescript',
};
//# sourceMappingURL=utils.js.map