export interface Regexes {
    singleLineComment: RegExp;
    multiLineCommentOpen?: RegExp;
    multiLineCommentOpenStart?: RegExp;
    multiLineCommentClose?: RegExp;
    multiLineCommentCloseEnd?: RegExp;
    multiLineCommentOpenAndClose?: RegExp;
}
/**
 * detecte program language through file extension
 *
 * @export
 * @class LanguageDetector
 */
export declare class Languages {
    extensionMap: {
        [key: string]: string;
    };
    /**
     * Creates an instance of Detector.
     */
    constructor();
    /**
     * load language before detecting
     */
    private loadExtensionMap;
    /**
     * Retrieve the regular expressions for a given language.
     * This is incomplete, but covers most of the languages we
     * see in the wild.
     *
     * @param language the language to retrieve regexes for
     */
    getRegexes(language: string): Regexes;
    /**
     * return extension map
     */
    getExtensionMap(): {
        [key: string]: string;
    };
    /**
     * get file type through a path
     */
    getType(path: string): string;
}
