"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const slash2_1 = __importDefault(require("slash2"));
const fs_extra_1 = __importDefault(require("fs-extra"));
const directory_1 = require("./directory");
const file_1 = require("./file");
var directory_2 = require("./directory");
Object.defineProperty(exports, "LocDir", { enumerable: true, get: function () { return directory_2.LocDir; } });
var file_2 = require("./file");
Object.defineProperty(exports, "LocFile", { enumerable: true, get: function () { return file_2.LocFile; } });
const loc = async (fileOrDir) => {
    const stat = await fs_extra_1.default.stat(slash2_1.default(fileOrDir));
    if (stat.isFile()) {
        const locFile = new file_1.LocFile(slash2_1.default(fileOrDir));
        const info = await locFile.getFileInfo();
        const filePath = locFile.path;
        return {
            info: info.lines,
            files: [filePath],
            languages: { [info.languages]: { ...info.lines, sum: 1 } },
        };
    }
    const locDir = new directory_1.LocDir({ cwd: slash2_1.default(fileOrDir) });
    return locDir.loadInfo();
};
exports.default = loc;
//# sourceMappingURL=index.js.map