/**
 * detect file info
 */
export interface LineInfo {
    total: number;
    code: number;
    comment: number;
}
export interface FileInfo {
    name: string;
    languages: string;
    size: number;
    lines: LineInfo;
}
/**
 * Collect language info for a single file
 */
export declare class LocFile {
    private debug;
    path: string;
    private rawPath;
    private languages;
    /**
     * Creates an instance of LocFile.
     */
    constructor(rawPath: string, debug?: boolean);
    private filterData;
    /**
     * Get file info when LocFile init
     */
    getFileInfo(data?: string): Promise<FileInfo>;
    getFileInfoByContent(name: string, data: string): FileInfo;
}
