import { LineInfo } from './file';
export interface LocDirOptions {
    cwd?: string;
    include?: string[] | string;
    exclude?: string[] | string;
    analysisLanguages?: string[];
}
export interface LocResult {
    files: string[];
    info: LineInfo;
    languages: {
        [key: string]: LineInfo & {
            sum: number;
        };
    };
}
/**
 * Collect the info of a directory.
 */
export declare class LocDir {
    private cwd;
    private include;
    private exclude;
    private analysisLanguages?;
    private allLanguages;
    constructor(options: LocDirOptions);
    /**
     * Calculate directory info.
     */
    loadInfo(): Promise<LocResult>;
    /**
     * Ignore analyzing this file if analysis languages are specified
     * and this language is not one of them.
     */
    private ignoreLanguage;
}
