#!/usr/bin/env node
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = __importDefault(require("chalk"));
const commander_1 = __importDefault(require("commander"));
const directory_1 = require("./directory");
const file_1 = require("./file");
const utils_1 = require("./utils");
commander_1.default
    .version(utils_1.getVersion(), '-v')
    .command('file <path>')
    .description('count lines of code in a file')
    .action(async (pathPattern) => {
    try {
        const info = await new file_1.LocFile(pathPattern).getFileInfo();
        // eslint-disable-next-line no-console
        console.log(chalk_1.default.cyan(`
        path: \t\t${pathPattern}
        language: \t${info.languages}
        total lines: \t${String(info.lines.total)}
        code lines: \t${String(info.lines.code)}
        comment lines: \t${String(info.lines.comment)}
      `));
    }
    catch (e) {
        console.error(e);
        console.error(e.stacl);
    }
});
const formatInfo = (info, languages) => `
  \ttotal lines: \t${String(info.total)}
  \tcode lines: \t${String(info.code)}
  \tcomment lines: \t${String(info.comment)}
  \t--------------------${Object.keys(languages)
    .map((key) => {
    const languageInfo = languages[key];
    return `\n\t${key.padEnd(10)} \t file count:${String(languageInfo.sum)} \ttotal:${String(languageInfo.total)}  \tcomment:${String(languageInfo.comment)}  \tcode:${String(languageInfo.code)}`;
})
    .join('')}`;
commander_1.default.arguments('<cmd> [env]').action(async (cmd) => {
    try {
        const { info, languages } = await new directory_1.LocDir({
            include: cmd,
        }).loadInfo();
        // eslint-disable-next-line no-console
        console.log(chalk_1.default.cyan(formatInfo(info, languages)));
    }
    catch (e) {
        console.error(e);
        console.error(e.stacl);
    }
});
commander_1.default.parse(process.argv);
//# sourceMappingURL=cli.js.map