/**
 * @fileoverview Blah
 * @author El
 */
"use strict";

//------------------------------------------------------------------------------
// Requirements
//------------------------------------------------------------------------------

var rule = require("../../../lib/no-async-foreach"),

    RuleTester = require("eslint").RuleTester;


//------------------------------------------------------------------------------
// Tests
//------------------------------------------------------------------------------

const ERROR_MSG = 'No async function in forEachs';

var ruleTester = new RuleTester();
ruleTester.run("no-async-foreach", rule, {

    valid: [
        {
            code: "[].forEach(() => {})",
            parserOptions: { ecmaVersion: 8 }
        },
        {
            code: "[].forEach(function() {})",
            parserOptions: { ecmaVersion: 8 }
        }
    ],

    invalid: [
        {
            code: "[].forEach(async () => {});",
            parserOptions: { ecmaVersion: 8 },
            errors: [{
                message: ERROR_MSG,
            }]
        },
        {
            code: "[].forEach(async function() {});",
            parserOptions: { ecmaVersion: 8 },
            errors: [{
                message: ERROR_MSG,
            }]
        }
    ]
});
