/**
 * @fileoverview Blah
 * @author El
 */
"use strict";

//------------------------------------------------------------------------------
// Rule Definition
//------------------------------------------------------------------------------

module.exports = {
    create: function(context) {
        
            return {
                ExpressionStatement: function(node) {
                    const { callee } = node.expression
                    if (!callee || !callee.property || !callee.property.name) return;
                    if (callee.property.name === "forEach") {
                    const functionArguments = node.expression.arguments.find(n => {
                        return n.type === 'ArrowFunctionExpression' || n.type === 'FunctionExpression'
                    })
                    if(functionArguments){
                        if (functionArguments.async) {
                            context.report(node, "No async function in forEachs");	
                        }
                    }
                    }
                    
                }
                };
            }
        
        
}