/// <reference types="node" />
import { OctokitResponse } from "../OctokitResponse";
import { RequestHeaders } from "../RequestHeaders";
import { RequestRequestOptions } from "../RequestRequestOptions";
declare type RequiredPreview<T> = {
    mediaType: {
        previews: [T, ...string[]];
    };
};
export interface Endpoints {
    /**
     * @see https://developer.github.com/v3/apps/#delete-an-installation-for-the-authenticated-app
     */
    "DELETE /app/installations/:installation_id": {
        parameters: AppsDeleteInstallationEndpoint;
        request: AppsDeleteInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#unsuspend-an-app-installation
     */
    "DELETE /app/installations/:installation_id/suspended": {
        parameters: AppsUnsuspendInstallationEndpoint;
        request: AppsUnsuspendInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-authorization
     */
    "DELETE /applications/:client_id/grant": {
        parameters: AppsDeleteAuthorizationEndpoint;
        request: AppsDeleteAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-a-grant-for-an-application
     */
    "DELETE /applications/:client_id/grants/:access_token": {
        parameters: AppsRevokeGrantForApplicationEndpoint;
        request: AppsRevokeGrantForApplicationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
     */
    "DELETE /applications/:client_id/token": {
        parameters: AppsDeleteTokenEndpoint;
        request: AppsDeleteTokenRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-an-authorization-for-an-application
     */
    "DELETE /applications/:client_id/tokens/:access_token": {
        parameters: AppsRevokeAuthorizationForApplicationEndpoint;
        request: AppsRevokeAuthorizationForApplicationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#delete-a-grant
     */
    "DELETE /applications/grants/:grant_id": {
        parameters: OauthAuthorizationsDeleteGrantEndpoint;
        request: OauthAuthorizationsDeleteGrantRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#delete-an-authorization
     */
    "DELETE /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsDeleteAuthorizationEndpoint;
        request: OauthAuthorizationsDeleteAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#delete-a-self-hosted-runner-group-from-an-enterprise
     */
    "DELETE /enterprises/:enterprise/actions/runner-groups/:runner_group_id": {
        parameters: EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseEndpoint;
        request: EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
     */
    "DELETE /enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations/:org_id": {
        parameters: EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint;
        request: EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#remove-a-self-hosted-runner-from-a-group-for-an-enterprise
     */
    "DELETE /enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners/:runner_id": {
        parameters: EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseEndpoint;
        request: EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#delete-self-hosted-runner-from-an-enterprise
     */
    "DELETE /enterprises/:enterprise/actions/runners/:runner_id": {
        parameters: EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseEndpoint;
        request: EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#delete-a-gist
     */
    "DELETE /gists/:gist_id": {
        parameters: GistsDeleteEndpoint;
        request: GistsDeleteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#delete-a-gist-comment
     */
    "DELETE /gists/:gist_id/comments/:comment_id": {
        parameters: GistsDeleteCommentEndpoint;
        request: GistsDeleteCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#unstar-a-gist
     */
    "DELETE /gists/:gist_id/star": {
        parameters: GistsUnstarEndpoint;
        request: GistsUnstarRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#revoke-an-installation-access-token
     */
    "DELETE /installation/token": {
        parameters: AppsRevokeInstallationAccessTokenEndpoint;
        request: AppsRevokeInstallationAccessTokenRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#delete-a-thread-subscription
     */
    "DELETE /notifications/threads/:thread_id/subscription": {
        parameters: ActivityDeleteThreadSubscriptionEndpoint;
        request: ActivityDeleteThreadSubscriptionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#delete-a-self-hosted-runner-group-from-an-organization
     */
    "DELETE /orgs/:org/actions/runner-groups/:runner_group_id": {
        parameters: ActionsDeleteSelfHostedRunnerGroupFromOrgEndpoint;
        request: ActionsDeleteSelfHostedRunnerGroupFromOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization
     */
    "DELETE /orgs/:org/actions/runner-groups/:runner_group_id/repositories/:repository_id": {
        parameters: ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgEndpoint;
        request: ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#remove-a-self-hosted-runner-from-a-group-for-an-organization
     */
    "DELETE /orgs/:org/actions/runner-groups/:runner_group_id/runners/:runner_id": {
        parameters: ActionsRemoveSelfHostedRunnerFromGroupForOrgEndpoint;
        request: ActionsRemoveSelfHostedRunnerFromGroupForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-an-organization
     */
    "DELETE /orgs/:org/actions/runners/:runner_id": {
        parameters: ActionsDeleteSelfHostedRunnerFromOrgEndpoint;
        request: ActionsDeleteSelfHostedRunnerFromOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#delete-an-organization-secret
     */
    "DELETE /orgs/:org/actions/secrets/:secret_name": {
        parameters: ActionsDeleteOrgSecretEndpoint;
        request: ActionsDeleteOrgSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#remove-selected-repository-from-an-organization-secret
     */
    "DELETE /orgs/:org/actions/secrets/:secret_name/repositories/:repository_id": {
        parameters: ActionsRemoveSelectedRepoFromOrgSecretEndpoint;
        request: ActionsRemoveSelectedRepoFromOrgSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#unblock-a-user-from-an-organization
     */
    "DELETE /orgs/:org/blocks/:username": {
        parameters: OrgsUnblockUserEndpoint;
        request: OrgsUnblockUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#remove-a-saml-sso-authorization-for-an-organization
     */
    "DELETE /orgs/:org/credential-authorizations/:credential_id": {
        parameters: OrgsRemoveSamlSsoAuthorizationEndpoint;
        request: OrgsRemoveSamlSsoAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#delete-an-organization-webhook
     */
    "DELETE /orgs/:org/hooks/:hook_id": {
        parameters: OrgsDeleteWebhookEndpoint;
        request: OrgsDeleteWebhookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#remove-interaction-restrictions-for-an-organization
     */
    "DELETE /orgs/:org/interaction-limits": {
        parameters: InteractionsRemoveRestrictionsForOrgEndpoint;
        request: InteractionsRemoveRestrictionsForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#remove-an-organization-member
     */
    "DELETE /orgs/:org/members/:username": {
        parameters: OrgsRemoveMemberEndpoint;
        request: OrgsRemoveMemberRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#remove-organization-membership-for-a-user
     */
    "DELETE /orgs/:org/memberships/:username": {
        parameters: OrgsRemoveMembershipForUserEndpoint;
        request: OrgsRemoveMembershipForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#delete-an-organization-migration-archive
     */
    "DELETE /orgs/:org/migrations/:migration_id/archive": {
        parameters: MigrationsDeleteArchiveForOrgEndpoint;
        request: MigrationsDeleteArchiveForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#unlock-an-organization-repository
     */
    "DELETE /orgs/:org/migrations/:migration_id/repos/:repo_name/lock": {
        parameters: MigrationsUnlockRepoForOrgEndpoint;
        request: MigrationsUnlockRepoForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#remove-outside-collaborator-from-an-organization
     */
    "DELETE /orgs/:org/outside_collaborators/:username": {
        parameters: OrgsRemoveOutsideCollaboratorEndpoint;
        request: OrgsRemoveOutsideCollaboratorRequestOptions;
        response: OctokitResponse<OrgsRemoveOutsideCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#remove-public-organization-membership-for-the-authenticated-user
     */
    "DELETE /orgs/:org/public_members/:username": {
        parameters: OrgsRemovePublicMembershipForAuthenticatedUserEndpoint;
        request: OrgsRemovePublicMembershipForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#delete-a-team
     */
    "DELETE /orgs/:org/teams/:team_slug": {
        parameters: TeamsDeleteInOrgEndpoint;
        request: TeamsDeleteInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsDeleteDiscussionInOrgEndpoint;
        request: TeamsDeleteDiscussionInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-discussion-comment
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsDeleteDiscussionCommentInOrgEndpoint;
        request: TeamsDeleteDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-team-discussion-comment-reaction
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForTeamDiscussionCommentEndpoint;
        request: ReactionsDeleteForTeamDiscussionCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-team-discussion-reaction
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForTeamDiscussionEndpoint;
        request: ReactionsDeleteForTeamDiscussionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-membership-for-a-user
     */
    "DELETE /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsRemoveMembershipForUserInOrgEndpoint;
        request: TeamsRemoveMembershipForUserInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-a-project-from-a-team
     */
    "DELETE /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsRemoveProjectInOrgEndpoint;
        request: TeamsRemoveProjectInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-a-repository-from-a-team
     */
    "DELETE /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsRemoveRepoInOrgEndpoint;
        request: TeamsRemoveRepoInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#delete-a-project
     */
    "DELETE /projects/:project_id": {
        parameters: ProjectsDeleteEndpoint;
        request: ProjectsDeleteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#remove-project-collaborator
     */
    "DELETE /projects/:project_id/collaborators/:username": {
        parameters: ProjectsRemoveCollaboratorEndpoint;
        request: ProjectsRemoveCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#delete-a-project-column
     */
    "DELETE /projects/columns/:column_id": {
        parameters: ProjectsDeleteColumnEndpoint;
        request: ProjectsDeleteColumnRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#delete-a-project-card
     */
    "DELETE /projects/columns/cards/:card_id": {
        parameters: ProjectsDeleteCardEndpoint;
        request: ProjectsDeleteCardRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-reaction-legacy
     */
    "DELETE /reactions/:reaction_id": {
        parameters: ReactionsDeleteLegacyEndpoint;
        request: ReactionsDeleteLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#delete-a-repository
     */
    "DELETE /repos/:owner/:repo": {
        parameters: ReposDeleteEndpoint;
        request: ReposDeleteRequestOptions;
        response: OctokitResponse<ReposDeleteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#delete-an-artifact
     */
    "DELETE /repos/:owner/:repo/actions/artifacts/:artifact_id": {
        parameters: ActionsDeleteArtifactEndpoint;
        request: ActionsDeleteArtifactRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-a-repository
     */
    "DELETE /repos/:owner/:repo/actions/runners/:runner_id": {
        parameters: ActionsDeleteSelfHostedRunnerFromRepoEndpoint;
        request: ActionsDeleteSelfHostedRunnerFromRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#delete-a-workflow-run
     */
    "DELETE /repos/:owner/:repo/actions/runs/:run_id": {
        parameters: ActionsDeleteWorkflowRunEndpoint;
        request: ActionsDeleteWorkflowRunRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#delete-workflow-run-logs
     */
    "DELETE /repos/:owner/:repo/actions/runs/:run_id/logs": {
        parameters: ActionsDeleteWorkflowRunLogsEndpoint;
        request: ActionsDeleteWorkflowRunLogsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#delete-a-repository-secret
     */
    "DELETE /repos/:owner/:repo/actions/secrets/:secret_name": {
        parameters: ActionsDeleteRepoSecretEndpoint;
        request: ActionsDeleteRepoSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#disable-automated-security-fixes
     */
    "DELETE /repos/:owner/:repo/automated-security-fixes": {
        parameters: ReposDisableAutomatedSecurityFixesEndpoint;
        request: ReposDisableAutomatedSecurityFixesRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#delete-branch-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposDeleteBranchProtectionEndpoint;
        request: ReposDeleteBranchProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#delete-admin-branch-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposDeleteAdminBranchProtectionEndpoint;
        request: ReposDeleteAdminBranchProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#delete-pull-request-review-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposDeletePullRequestReviewProtectionEndpoint;
        request: ReposDeletePullRequestReviewProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#delete-commit-signature-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposDeleteCommitSignatureProtectionEndpoint;
        request: ReposDeleteCommitSignatureProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-status-check-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposRemoveStatusCheckProtectionEndpoint;
        request: ReposRemoveStatusCheckProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-status-check-contexts
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposRemoveStatusCheckContextsEndpoint;
        request: ReposRemoveStatusCheckContextsRequestOptions;
        response: OctokitResponse<ReposRemoveStatusCheckContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#delete-access-restrictions
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions": {
        parameters: ReposDeleteAccessRestrictionsEndpoint;
        request: ReposDeleteAccessRestrictionsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-app-access-restrictions
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposRemoveAppAccessRestrictionsEndpoint;
        request: ReposRemoveAppAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveAppAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-team-access-restrictions
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposRemoveTeamAccessRestrictionsEndpoint;
        request: ReposRemoveTeamAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveTeamAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-user-access-restrictions
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposRemoveUserAccessRestrictionsEndpoint;
        request: ReposRemoveUserAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveUserAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#remove-a-repository-collaborator
     */
    "DELETE /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposRemoveCollaboratorEndpoint;
        request: ReposRemoveCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#delete-a-commit-comment
     */
    "DELETE /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposDeleteCommitCommentEndpoint;
        request: ReposDeleteCommitCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-commit-comment-reaction
     */
    "DELETE /repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForCommitCommentEndpoint;
        request: ReactionsDeleteForCommitCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#delete-a-file
     */
    "DELETE /repos/:owner/:repo/contents/:path": {
        parameters: ReposDeleteFileEndpoint;
        request: ReposDeleteFileRequestOptions;
        response: OctokitResponse<ReposDeleteFileResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#delete-a-deployment
     */
    "DELETE /repos/:owner/:repo/deployments/:deployment_id": {
        parameters: ReposDeleteDeploymentEndpoint;
        request: ReposDeleteDeploymentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#delete-a-reference
     */
    "DELETE /repos/:owner/:repo/git/refs/:ref": {
        parameters: GitDeleteRefEndpoint;
        request: GitDeleteRefRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#delete-a-repository-webhook
     */
    "DELETE /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposDeleteWebhookEndpoint;
        request: ReposDeleteWebhookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#cancel-an-import
     */
    "DELETE /repos/:owner/:repo/import": {
        parameters: MigrationsCancelImportEndpoint;
        request: MigrationsCancelImportRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#remove-interaction-restrictions-for-a-repository
     */
    "DELETE /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsRemoveRestrictionsForRepoEndpoint;
        request: InteractionsRemoveRestrictionsForRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#delete-a-repository-invitation
     */
    "DELETE /repos/:owner/:repo/invitations/:invitation_id": {
        parameters: ReposDeleteInvitationEndpoint;
        request: ReposDeleteInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#remove-assignees-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/assignees": {
        parameters: IssuesRemoveAssigneesEndpoint;
        request: IssuesRemoveAssigneesRequestOptions;
        response: OctokitResponse<IssuesRemoveAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#remove-all-labels-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesRemoveAllLabelsEndpoint;
        request: IssuesRemoveAllLabelsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#remove-a-label-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/labels/:name": {
        parameters: IssuesRemoveLabelEndpoint;
        request: IssuesRemoveLabelRequestOptions;
        response: OctokitResponse<IssuesRemoveLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#unlock-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/lock": {
        parameters: IssuesUnlockEndpoint;
        request: IssuesUnlockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-an-issue-reaction
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForIssueEndpoint;
        request: ReactionsDeleteForIssueRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#delete-an-issue-comment
     */
    "DELETE /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesDeleteCommentEndpoint;
        request: IssuesDeleteCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-an-issue-comment-reaction
     */
    "DELETE /repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForIssueCommentEndpoint;
        request: ReactionsDeleteForIssueCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#delete-a-deploy-key
     */
    "DELETE /repos/:owner/:repo/keys/:key_id": {
        parameters: ReposDeleteDeployKeyEndpoint;
        request: ReposDeleteDeployKeyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#delete-a-label
     */
    "DELETE /repos/:owner/:repo/labels/:name": {
        parameters: IssuesDeleteLabelEndpoint;
        request: IssuesDeleteLabelRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#delete-a-milestone
     */
    "DELETE /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesDeleteMilestoneEndpoint;
        request: IssuesDeleteMilestoneRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#delete-a-github-pages-site
     */
    "DELETE /repos/:owner/:repo/pages": {
        parameters: ReposDeletePagesSiteEndpoint;
        request: ReposDeletePagesSiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#remove-requested-reviewers-from-a-pull-request
     */
    "DELETE /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsRemoveRequestedReviewersEndpoint;
        request: PullsRemoveRequestedReviewersRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#delete-a-pending-review-for-a-pull-request
     */
    "DELETE /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsDeletePendingReviewEndpoint;
        request: PullsDeletePendingReviewRequestOptions;
        response: OctokitResponse<PullsDeletePendingReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#delete-a-review-comment-for-a-pull-request
     */
    "DELETE /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsDeleteReviewCommentEndpoint;
        request: PullsDeleteReviewCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-pull-request-comment-reaction
     */
    "DELETE /repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForPullRequestCommentEndpoint;
        request: ReactionsDeleteForPullRequestCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#delete-a-release
     */
    "DELETE /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposDeleteReleaseEndpoint;
        request: ReposDeleteReleaseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#delete-a-release-asset
     */
    "DELETE /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposDeleteReleaseAssetEndpoint;
        request: ReposDeleteReleaseAssetRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription
     */
    "DELETE /repos/:owner/:repo/subscription": {
        parameters: ActivityDeleteRepoSubscriptionEndpoint;
        request: ActivityDeleteRepoSubscriptionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#disable-vulnerability-alerts
     */
    "DELETE /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposDisableVulnerabilityAlertsEndpoint;
        request: ReposDisableVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#delete-a-scim-group-from-an-enterprise
     */
    "DELETE /scim/v2/enterprises/:enterprise/Groups/:scim_group_id": {
        parameters: EnterpriseAdminDeleteScimGroupFromEnterpriseEndpoint;
        request: EnterpriseAdminDeleteScimGroupFromEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#delete-a-scim-user-from-an-enterprise
     */
    "DELETE /scim/v2/enterprises/:enterprise/Users/:scim_user_id": {
        parameters: EnterpriseAdminDeleteUserFromEnterpriseEndpoint;
        request: EnterpriseAdminDeleteUserFromEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#delete-a-scim-user-from-an-organization
     */
    "DELETE /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimDeleteUserFromOrgEndpoint;
        request: ScimDeleteUserFromOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#delete-a-team-legacy
     */
    "DELETE /teams/:team_id": {
        parameters: TeamsDeleteLegacyEndpoint;
        request: TeamsDeleteLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion-legacy
     */
    "DELETE /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsDeleteDiscussionLegacyEndpoint;
        request: TeamsDeleteDiscussionLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-discussion-comment-legacy
     */
    "DELETE /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsDeleteDiscussionCommentLegacyEndpoint;
        request: TeamsDeleteDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-member-legacy
     */
    "DELETE /teams/:team_id/members/:username": {
        parameters: TeamsRemoveMemberLegacyEndpoint;
        request: TeamsRemoveMemberLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-membership-for-a-user-legacy
     */
    "DELETE /teams/:team_id/memberships/:username": {
        parameters: TeamsRemoveMembershipForUserLegacyEndpoint;
        request: TeamsRemoveMembershipForUserLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-a-project-from-a-team-legacy
     */
    "DELETE /teams/:team_id/projects/:project_id": {
        parameters: TeamsRemoveProjectLegacyEndpoint;
        request: TeamsRemoveProjectLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-a-repository-from-a-team-legacy
     */
    "DELETE /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsRemoveRepoLegacyEndpoint;
        request: TeamsRemoveRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#unblock-a-user
     */
    "DELETE /user/blocks/:username": {
        parameters: UsersUnblockEndpoint;
        request: UsersUnblockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#delete-an-email-address-for-the-authenticated-user
     */
    "DELETE /user/emails": {
        parameters: UsersDeleteEmailForAuthenticatedEndpoint;
        request: UsersDeleteEmailForAuthenticatedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#unfollow-a-user
     */
    "DELETE /user/following/:username": {
        parameters: UsersUnfollowEndpoint;
        request: UsersUnfollowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#delete-a-gpg-key-for-the-authenticated-user
     */
    "DELETE /user/gpg_keys/:gpg_key_id": {
        parameters: UsersDeleteGpgKeyForAuthenticatedEndpoint;
        request: UsersDeleteGpgKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#remove-a-repository-from-an-app-installation
     */
    "DELETE /user/installations/:installation_id/repositories/:repository_id": {
        parameters: AppsRemoveRepoFromInstallationEndpoint;
        request: AppsRemoveRepoFromInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#delete-a-public-ssh-key-for-the-authenticated-user
     */
    "DELETE /user/keys/:key_id": {
        parameters: UsersDeletePublicSshKeyForAuthenticatedEndpoint;
        request: UsersDeletePublicSshKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#delete-a-user-migration-archive
     */
    "DELETE /user/migrations/:migration_id/archive": {
        parameters: MigrationsDeleteArchiveForAuthenticatedUserEndpoint;
        request: MigrationsDeleteArchiveForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#unlock-a-user-repository
     */
    "DELETE /user/migrations/:migration_id/repos/:repo_name/lock": {
        parameters: MigrationsUnlockRepoForAuthenticatedUserEndpoint;
        request: MigrationsUnlockRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#decline-a-repository-invitation
     */
    "DELETE /user/repository_invitations/:invitation_id": {
        parameters: ReposDeclineInvitationEndpoint;
        request: ReposDeclineInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#unstar-a-repository-for-the-authenticated-user
     */
    "DELETE /user/starred/:owner/:repo": {
        parameters: ActivityUnstarRepoForAuthenticatedUserEndpoint;
        request: ActivityUnstarRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-the-authenticated-app
     */
    "GET /app": {
        parameters: AppsGetAuthenticatedEndpoint;
        request: AppsGetAuthenticatedRequestOptions;
        response: OctokitResponse<AppsGetAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#list-installations-for-the-authenticated-app
     */
    "GET /app/installations": {
        parameters: AppsListInstallationsEndpoint;
        request: AppsListInstallationsRequestOptions;
        response: OctokitResponse<AppsListInstallationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-an-installation-for-the-authenticated-app
     */
    "GET /app/installations/:installation_id": {
        parameters: AppsGetInstallationEndpoint;
        request: AppsGetInstallationRequestOptions;
        response: OctokitResponse<AppsGetInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#check-an-authorization
     */
    "GET /applications/:client_id/tokens/:access_token": {
        parameters: AppsCheckAuthorizationEndpoint;
        request: AppsCheckAuthorizationRequestOptions;
        response: OctokitResponse<AppsCheckAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#list-your-grants
     */
    "GET /applications/grants": {
        parameters: OauthAuthorizationsListGrantsEndpoint;
        request: OauthAuthorizationsListGrantsRequestOptions;
        response: OctokitResponse<OauthAuthorizationsListGrantsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-grant
     */
    "GET /applications/grants/:grant_id": {
        parameters: OauthAuthorizationsGetGrantEndpoint;
        request: OauthAuthorizationsGetGrantRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetGrantResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-an-app
     */
    "GET /apps/:app_slug": {
        parameters: AppsGetBySlugEndpoint;
        request: AppsGetBySlugRequestOptions;
        response: OctokitResponse<AppsGetBySlugResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#list-your-authorizations
     */
    "GET /authorizations": {
        parameters: OauthAuthorizationsListAuthorizationsEndpoint;
        request: OauthAuthorizationsListAuthorizationsRequestOptions;
        response: OctokitResponse<OauthAuthorizationsListAuthorizationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-authorization
     */
    "GET /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsGetAuthorizationEndpoint;
        request: OauthAuthorizationsGetAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#get-all-codes-of-conduct
     */
    "GET /codes_of_conduct": {
        parameters: CodesOfConductGetAllCodesOfConductEndpoint;
        request: CodesOfConductGetAllCodesOfConductRequestOptions;
        response: OctokitResponse<CodesOfConductGetAllCodesOfConductResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#get-a-code-of-conduct
     */
    "GET /codes_of_conduct/:key": {
        parameters: CodesOfConductGetConductCodeEndpoint;
        request: CodesOfConductGetConductCodeRequestOptions;
        response: OctokitResponse<CodesOfConductGetConductCodeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/emojis/#get-emojis
     */
    "GET /emojis": {
        parameters: EmojisGetEndpoint;
        request: EmojisGetRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#list-self-hosted-runner-groups-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runner-groups": {
        parameters: EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseEndpoint;
        request: EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#get-a-self-hosted-runner-group-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runner-groups/:runner_group_id": {
        parameters: EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseEndpoint;
        request: EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#list-organization-access-to-a-self-hosted-runner-group-in-a-enterprise
     */
    "GET /enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations": {
        parameters: EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint;
        request: EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#list-self-hosted-runners-in-a-group-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners": {
        parameters: EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseEndpoint;
        request: EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#list-self-hosted-runners-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runners": {
        parameters: EnterpriseAdminListSelfHostedRunnersForEnterpriseEndpoint;
        request: EnterpriseAdminListSelfHostedRunnersForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListSelfHostedRunnersForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#get-a-self-hosted-runner-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runners/:runner_id": {
        parameters: EnterpriseAdminGetSelfHostedRunnerForEnterpriseEndpoint;
        request: EnterpriseAdminGetSelfHostedRunnerForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetSelfHostedRunnerForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#list-runner-applications-for-an-enterprise
     */
    "GET /enterprises/:enterprise/actions/runners/downloads": {
        parameters: EnterpriseAdminListRunnerApplicationsForEnterpriseEndpoint;
        request: EnterpriseAdminListRunnerApplicationsForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListRunnerApplicationsForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-github-actions-billing-for-an-enterprise
     */
    "GET /enterprises/:enterprise/settings/billing/actions": {
        parameters: EnterpriseAdminGetGithubActionsBillingGheEndpoint;
        request: EnterpriseAdminGetGithubActionsBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetGithubActionsBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-github-packages-billing-for-an-enterprise
     */
    "GET /enterprises/:enterprise/settings/billing/packages": {
        parameters: EnterpriseAdminGetGithubPackagesBillingGheEndpoint;
        request: EnterpriseAdminGetGithubPackagesBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetGithubPackagesBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-shared-storage-billing-for-an-enterprise
     */
    "GET /enterprises/:enterprise/settings/billing/shared-storage": {
        parameters: EnterpriseAdminGetSharedStorageBillingGheEndpoint;
        request: EnterpriseAdminGetSharedStorageBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetSharedStorageBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-github-actions-billing-for-an-enterprise
     * @deprecated "enterprise_id" is deprecated, use "enterprise" instead
     */
    "GET /enterprises/:enterprise_id/settings/billing/actions": {
        parameters: EnterpriseAdminGetGithubActionsBillingGheDeprecatedEnterpriseIdEndpoint;
        request: EnterpriseAdminGetGithubActionsBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetGithubActionsBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-github-packages-billing-for-an-enterprise
     * @deprecated "enterprise_id" is deprecated, use "enterprise" instead
     */
    "GET /enterprises/:enterprise_id/settings/billing/packages": {
        parameters: EnterpriseAdminGetGithubPackagesBillingGheDeprecatedEnterpriseIdEndpoint;
        request: EnterpriseAdminGetGithubPackagesBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetGithubPackagesBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/billing/#get-shared-storage-billing-for-an-enterprise
     * @deprecated "enterprise_id" is deprecated, use "enterprise" instead
     */
    "GET /enterprises/:enterprise_id/settings/billing/shared-storage": {
        parameters: EnterpriseAdminGetSharedStorageBillingGheDeprecatedEnterpriseIdEndpoint;
        request: EnterpriseAdminGetSharedStorageBillingGheRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetSharedStorageBillingGheResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events
     */
    "GET /events": {
        parameters: ActivityListPublicEventsEndpoint;
        request: ActivityListPublicEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/feeds/#get-feeds
     */
    "GET /feeds": {
        parameters: ActivityGetFeedsEndpoint;
        request: ActivityGetFeedsRequestOptions;
        response: OctokitResponse<ActivityGetFeedsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gists-for-the-authenticated-user
     */
    "GET /gists": {
        parameters: GistsListEndpoint;
        request: GistsListRequestOptions;
        response: OctokitResponse<GistsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#get-a-gist
     */
    "GET /gists/:gist_id": {
        parameters: GistsGetEndpoint;
        request: GistsGetRequestOptions;
        response: OctokitResponse<GistsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#get-a-gist-revision
     */
    "GET /gists/:gist_id/:sha": {
        parameters: GistsGetRevisionEndpoint;
        request: GistsGetRevisionRequestOptions;
        response: OctokitResponse<GistsGetRevisionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#list-gist-comments
     */
    "GET /gists/:gist_id/comments": {
        parameters: GistsListCommentsEndpoint;
        request: GistsListCommentsRequestOptions;
        response: OctokitResponse<GistsListCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#get-a-gist-comment
     */
    "GET /gists/:gist_id/comments/:comment_id": {
        parameters: GistsGetCommentEndpoint;
        request: GistsGetCommentRequestOptions;
        response: OctokitResponse<GistsGetCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gist-commits
     */
    "GET /gists/:gist_id/commits": {
        parameters: GistsListCommitsEndpoint;
        request: GistsListCommitsRequestOptions;
        response: OctokitResponse<GistsListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gist-forks
     */
    "GET /gists/:gist_id/forks": {
        parameters: GistsListForksEndpoint;
        request: GistsListForksRequestOptions;
        response: OctokitResponse<GistsListForksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#check-if-a-gist-is-starred
     */
    "GET /gists/:gist_id/star": {
        parameters: GistsCheckIsStarredEndpoint;
        request: GistsCheckIsStarredRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-public-gists
     */
    "GET /gists/public": {
        parameters: GistsListPublicEndpoint;
        request: GistsListPublicRequestOptions;
        response: OctokitResponse<GistsListPublicResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-starred-gists
     */
    "GET /gists/starred": {
        parameters: GistsListStarredEndpoint;
        request: GistsListStarredRequestOptions;
        response: OctokitResponse<GistsListStarredResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gitignore/#get-all-gitignore-templates
     */
    "GET /gitignore/templates": {
        parameters: GitignoreGetAllTemplatesEndpoint;
        request: GitignoreGetAllTemplatesRequestOptions;
        response: OctokitResponse<GitignoreGetAllTemplatesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gitignore/#get-a-gitignore-template
     */
    "GET /gitignore/templates/:name": {
        parameters: GitignoreGetTemplateEndpoint;
        request: GitignoreGetTemplateRequestOptions;
        response: OctokitResponse<GitignoreGetTemplateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-app-installation
     */
    "GET /installation/repositories": {
        parameters: AppsListReposAccessibleToInstallationEndpoint;
        request: AppsListReposAccessibleToInstallationRequestOptions;
        response: OctokitResponse<AppsListReposAccessibleToInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-issues-assigned-to-the-authenticated-user
     */
    "GET /issues": {
        parameters: IssuesListEndpoint;
        request: IssuesListRequestOptions;
        response: OctokitResponse<IssuesListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#get-all-commonly-used-licenses
     */
    "GET /licenses": {
        parameters: LicensesGetAllCommonlyUsedEndpoint;
        request: LicensesGetAllCommonlyUsedRequestOptions;
        response: OctokitResponse<LicensesGetAllCommonlyUsedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#get-a-license
     */
    "GET /licenses/:license": {
        parameters: LicensesGetEndpoint;
        request: LicensesGetRequestOptions;
        response: OctokitResponse<LicensesGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account
     */
    "GET /marketplace_listing/accounts/:account_id": {
        parameters: AppsGetSubscriptionPlanForAccountEndpoint;
        request: AppsGetSubscriptionPlanForAccountRequestOptions;
        response: OctokitResponse<AppsGetSubscriptionPlanForAccountResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-plans
     */
    "GET /marketplace_listing/plans": {
        parameters: AppsListPlansEndpoint;
        request: AppsListPlansRequestOptions;
        response: OctokitResponse<AppsListPlansResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan
     */
    "GET /marketplace_listing/plans/:plan_id/accounts": {
        parameters: AppsListAccountsForPlanEndpoint;
        request: AppsListAccountsForPlanRequestOptions;
        response: OctokitResponse<AppsListAccountsForPlanResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account-stubbed
     */
    "GET /marketplace_listing/stubbed/accounts/:account_id": {
        parameters: AppsGetSubscriptionPlanForAccountStubbedEndpoint;
        request: AppsGetSubscriptionPlanForAccountStubbedRequestOptions;
        response: OctokitResponse<AppsGetSubscriptionPlanForAccountStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-plans-stubbed
     */
    "GET /marketplace_listing/stubbed/plans": {
        parameters: AppsListPlansStubbedEndpoint;
        request: AppsListPlansStubbedRequestOptions;
        response: OctokitResponse<AppsListPlansStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan-stubbed
     */
    "GET /marketplace_listing/stubbed/plans/:plan_id/accounts": {
        parameters: AppsListAccountsForPlanStubbedEndpoint;
        request: AppsListAccountsForPlanStubbedRequestOptions;
        response: OctokitResponse<AppsListAccountsForPlanStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/meta/#get-github-meta-information
     */
    "GET /meta": {
        parameters: MetaGetEndpoint;
        request: MetaGetRequestOptions;
        response: OctokitResponse<MetaGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-network-of-repositories
     */
    "GET /networks/:owner/:repo/events": {
        parameters: ActivityListPublicEventsForRepoNetworkEndpoint;
        request: ActivityListPublicEventsForRepoNetworkRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#list-notifications-for-the-authenticated-user
     */
    "GET /notifications": {
        parameters: ActivityListNotificationsForAuthenticatedUserEndpoint;
        request: ActivityListNotificationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListNotificationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#get-a-thread
     */
    "GET /notifications/threads/:thread_id": {
        parameters: ActivityGetThreadEndpoint;
        request: ActivityGetThreadRequestOptions;
        response: OctokitResponse<ActivityGetThreadResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#get-a-thread-subscription-for-the-authenticated-user
     */
    "GET /notifications/threads/:thread_id/subscription": {
        parameters: ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint;
        request: ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityGetThreadSubscriptionForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-organizations
     */
    "GET /organizations": {
        parameters: OrgsListEndpoint;
        request: OrgsListRequestOptions;
        response: OctokitResponse<OrgsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#get-an-organization
     */
    "GET /orgs/:org": {
        parameters: OrgsGetEndpoint;
        request: OrgsGetRequestOptions;
        response: OctokitResponse<OrgsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#list-self-hosted-runner-groups-for-an-organization
     */
    "GET /orgs/:org/actions/runner-groups": {
        parameters: ActionsListSelfHostedRunnerGroupsForOrgEndpoint;
        request: ActionsListSelfHostedRunnerGroupsForOrgRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnerGroupsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#get-a-self-hosted-runner-group-for-an-organization
     */
    "GET /orgs/:org/actions/runner-groups/:runner_group_id": {
        parameters: ActionsGetSelfHostedRunnerGroupForOrgEndpoint;
        request: ActionsGetSelfHostedRunnerGroupForOrgRequestOptions;
        response: OctokitResponse<ActionsGetSelfHostedRunnerGroupForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#list-repository-access-to-a-self-hosted-runner-group-in-an-organization
     */
    "GET /orgs/:org/actions/runner-groups/:runner_group_id/repositories": {
        parameters: ActionsListRepoAccessToSelfHostedRunnerGroupInOrgEndpoint;
        request: ActionsListRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions;
        response: OctokitResponse<ActionsListRepoAccessToSelfHostedRunnerGroupInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#list-self-hosted-runners-in-a-group-for-an-organization
     */
    "GET /orgs/:org/actions/runner-groups/:runner_group_id/runners": {
        parameters: ActionsListSelfHostedRunnersInGroupForOrgEndpoint;
        request: ActionsListSelfHostedRunnersInGroupForOrgRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnersInGroupForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-an-organization
     */
    "GET /orgs/:org/actions/runners": {
        parameters: ActionsListSelfHostedRunnersForOrgEndpoint;
        request: ActionsListSelfHostedRunnersForOrgRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnersForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-an-organization
     */
    "GET /orgs/:org/actions/runners/:runner_id": {
        parameters: ActionsGetSelfHostedRunnerForOrgEndpoint;
        request: ActionsGetSelfHostedRunnerForOrgRequestOptions;
        response: OctokitResponse<ActionsGetSelfHostedRunnerForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-an-organization
     */
    "GET /orgs/:org/actions/runners/downloads": {
        parameters: ActionsListRunnerApplicationsForOrgEndpoint;
        request: ActionsListRunnerApplicationsForOrgRequestOptions;
        response: OctokitResponse<ActionsListRunnerApplicationsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#list-organization-secrets
     */
    "GET /orgs/:org/actions/secrets": {
        parameters: ActionsListOrgSecretsEndpoint;
        request: ActionsListOrgSecretsRequestOptions;
        response: OctokitResponse<ActionsListOrgSecretsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-an-organization-secret
     */
    "GET /orgs/:org/actions/secrets/:secret_name": {
        parameters: ActionsGetOrgSecretEndpoint;
        request: ActionsGetOrgSecretRequestOptions;
        response: OctokitResponse<ActionsGetOrgSecretResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#list-selected-repositories-for-an-organization-secret
     */
    "GET /orgs/:org/actions/secrets/:secret_name/repositories": {
        parameters: ActionsListSelectedReposForOrgSecretEndpoint;
        request: ActionsListSelectedReposForOrgSecretRequestOptions;
        response: OctokitResponse<ActionsListSelectedReposForOrgSecretResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-an-organization-public-key
     */
    "GET /orgs/:org/actions/secrets/public-key": {
        parameters: ActionsGetOrgPublicKeyEndpoint;
        request: ActionsGetOrgPublicKeyRequestOptions;
        response: OctokitResponse<ActionsGetOrgPublicKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#list-users-blocked-by-an-organization
     */
    "GET /orgs/:org/blocks": {
        parameters: OrgsListBlockedUsersEndpoint;
        request: OrgsListBlockedUsersRequestOptions;
        response: OctokitResponse<OrgsListBlockedUsersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#check-if-a-user-is-blocked-by-an-organization
     */
    "GET /orgs/:org/blocks/:username": {
        parameters: OrgsCheckBlockedUserEndpoint;
        request: OrgsCheckBlockedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-saml-sso-authorizations-for-an-organization
     */
    "GET /orgs/:org/credential-authorizations": {
        parameters: OrgsListSamlSsoAuthorizationsEndpoint;
        request: OrgsListSamlSsoAuthorizationsRequestOptions;
        response: OctokitResponse<OrgsListSamlSsoAuthorizationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-organization-events
     */
    "GET /orgs/:org/events": {
        parameters: ActivityListPublicOrgEventsEndpoint;
        request: ActivityListPublicOrgEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#list-organization-webhooks
     */
    "GET /orgs/:org/hooks": {
        parameters: OrgsListWebhooksEndpoint;
        request: OrgsListWebhooksRequestOptions;
        response: OctokitResponse<OrgsListWebhooksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#get-an-organization-webhook
     */
    "GET /orgs/:org/hooks/:hook_id": {
        parameters: OrgsGetWebhookEndpoint;
        request: OrgsGetWebhookRequestOptions;
        response: OctokitResponse<OrgsGetWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-an-organization-installation-for-the-authenticated-app
     */
    "GET /orgs/:org/installation": {
        parameters: AppsGetOrgInstallationEndpoint;
        request: AppsGetOrgInstallationRequestOptions;
        response: OctokitResponse<AppsGetOrgInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-app-installations-for-an-organization
     */
    "GET /orgs/:org/installations": {
        parameters: OrgsListAppInstallationsEndpoint;
        request: OrgsListAppInstallationsRequestOptions;
        response: OctokitResponse<OrgsListAppInstallationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#get-interaction-restrictions-for-an-organization
     */
    "GET /orgs/:org/interaction-limits": {
        parameters: InteractionsGetRestrictionsForOrgEndpoint;
        request: InteractionsGetRestrictionsForOrgRequestOptions;
        response: OctokitResponse<InteractionsGetRestrictionsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-pending-organization-invitations
     */
    "GET /orgs/:org/invitations": {
        parameters: OrgsListPendingInvitationsEndpoint;
        request: OrgsListPendingInvitationsRequestOptions;
        response: OctokitResponse<OrgsListPendingInvitationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-organization-invitation-teams
     */
    "GET /orgs/:org/invitations/:invitation_id/teams": {
        parameters: OrgsListInvitationTeamsEndpoint;
        request: OrgsListInvitationTeamsRequestOptions;
        response: OctokitResponse<OrgsListInvitationTeamsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-organization-issues-assigned-to-the-authenticated-user
     */
    "GET /orgs/:org/issues": {
        parameters: IssuesListForOrgEndpoint;
        request: IssuesListForOrgRequestOptions;
        response: OctokitResponse<IssuesListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-organization-members
     */
    "GET /orgs/:org/members": {
        parameters: OrgsListMembersEndpoint;
        request: OrgsListMembersRequestOptions;
        response: OctokitResponse<OrgsListMembersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#check-organization-membership-for-a-user
     */
    "GET /orgs/:org/members/:username": {
        parameters: OrgsCheckMembershipForUserEndpoint;
        request: OrgsCheckMembershipForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#get-organization-membership-for-a-user
     */
    "GET /orgs/:org/memberships/:username": {
        parameters: OrgsGetMembershipForUserEndpoint;
        request: OrgsGetMembershipForUserRequestOptions;
        response: OctokitResponse<OrgsGetMembershipForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#list-organization-migrations
     */
    "GET /orgs/:org/migrations": {
        parameters: MigrationsListForOrgEndpoint;
        request: MigrationsListForOrgRequestOptions;
        response: OctokitResponse<MigrationsListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#get-an-organization-migration-status
     */
    "GET /orgs/:org/migrations/:migration_id": {
        parameters: MigrationsGetStatusForOrgEndpoint;
        request: MigrationsGetStatusForOrgRequestOptions;
        response: OctokitResponse<MigrationsGetStatusForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#download-an-organization-migration-archive
     */
    "GET /orgs/:org/migrations/:migration_id/archive": {
        parameters: MigrationsDownloadArchiveForOrgEndpoint;
        request: MigrationsDownloadArchiveForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#list-repositories-in-an-organization-migration
     */
    "GET /orgs/:org/migrations/:migration_id/repositories": {
        parameters: MigrationsListReposForOrgEndpoint;
        request: MigrationsListReposForOrgRequestOptions;
        response: OctokitResponse<MigrationsListReposForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#list-outside-collaborators-for-an-organization
     */
    "GET /orgs/:org/outside_collaborators": {
        parameters: OrgsListOutsideCollaboratorsEndpoint;
        request: OrgsListOutsideCollaboratorsRequestOptions;
        response: OctokitResponse<OrgsListOutsideCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-organization-projects
     */
    "GET /orgs/:org/projects": {
        parameters: ProjectsListForOrgEndpoint;
        request: ProjectsListForOrgRequestOptions;
        response: OctokitResponse<ProjectsListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-public-organization-members
     */
    "GET /orgs/:org/public_members": {
        parameters: OrgsListPublicMembersEndpoint;
        request: OrgsListPublicMembersRequestOptions;
        response: OctokitResponse<OrgsListPublicMembersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#check-public-organization-membership-for-a-user
     */
    "GET /orgs/:org/public_members/:username": {
        parameters: OrgsCheckPublicMembershipForUserEndpoint;
        request: OrgsCheckPublicMembershipForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-organization-repositories
     */
    "GET /orgs/:org/repos": {
        parameters: ReposListForOrgEndpoint;
        request: ReposListForOrgRequestOptions;
        response: OctokitResponse<ReposListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-github-actions-billing-for-an-organization
     */
    "GET /orgs/:org/settings/billing/actions": {
        parameters: BillingGetGithubActionsBillingOrgEndpoint;
        request: BillingGetGithubActionsBillingOrgRequestOptions;
        response: OctokitResponse<BillingGetGithubActionsBillingOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-github-packages-billing-for-an-organization
     */
    "GET /orgs/:org/settings/billing/packages": {
        parameters: BillingGetGithubPackagesBillingOrgEndpoint;
        request: BillingGetGithubPackagesBillingOrgRequestOptions;
        response: OctokitResponse<BillingGetGithubPackagesBillingOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-shared-storage-billing-for-an-organization
     */
    "GET /orgs/:org/settings/billing/shared-storage": {
        parameters: BillingGetSharedStorageBillingOrgEndpoint;
        request: BillingGetSharedStorageBillingOrgRequestOptions;
        response: OctokitResponse<BillingGetSharedStorageBillingOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-an-organization
     */
    "GET /orgs/:org/team-sync/groups": {
        parameters: TeamsListIdPGroupsForOrgEndpoint;
        request: TeamsListIdPGroupsForOrgRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-teams
     */
    "GET /orgs/:org/teams": {
        parameters: TeamsListEndpoint;
        request: TeamsListRequestOptions;
        response: OctokitResponse<TeamsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#get-a-team-by-name
     */
    "GET /orgs/:org/teams/:team_slug": {
        parameters: TeamsGetByNameEndpoint;
        request: TeamsGetByNameRequestOptions;
        response: OctokitResponse<TeamsGetByNameResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#list-discussions
     */
    "GET /orgs/:org/teams/:team_slug/discussions": {
        parameters: TeamsListDiscussionsInOrgEndpoint;
        request: TeamsListDiscussionsInOrgRequestOptions;
        response: OctokitResponse<TeamsListDiscussionsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#get-a-discussion
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsGetDiscussionInOrgEndpoint;
        request: TeamsGetDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#list-discussion-comments
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
        parameters: TeamsListDiscussionCommentsInOrgEndpoint;
        request: TeamsListDiscussionCommentsInOrgRequestOptions;
        response: OctokitResponse<TeamsListDiscussionCommentsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-discussion-comment
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsGetDiscussionCommentInOrgEndpoint;
        request: TeamsGetDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsListForTeamDiscussionCommentInOrgEndpoint;
        request: ReactionsListForTeamDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
        parameters: ReactionsListForTeamDiscussionInOrgEndpoint;
        request: ReactionsListForTeamDiscussionInOrgRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations
     */
    "GET /orgs/:org/teams/:team_slug/invitations": {
        parameters: TeamsListPendingInvitationsInOrgEndpoint;
        request: TeamsListPendingInvitationsInOrgRequestOptions;
        response: OctokitResponse<TeamsListPendingInvitationsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-team-members
     */
    "GET /orgs/:org/teams/:team_slug/members": {
        parameters: TeamsListMembersInOrgEndpoint;
        request: TeamsListMembersInOrgRequestOptions;
        response: OctokitResponse<TeamsListMembersInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-membership-for-a-user
     */
    "GET /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsGetMembershipForUserInOrgEndpoint;
        request: TeamsGetMembershipForUserInOrgRequestOptions;
        response: OctokitResponse<TeamsGetMembershipForUserInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-projects
     */
    "GET /orgs/:org/teams/:team_slug/projects": {
        parameters: TeamsListProjectsInOrgEndpoint;
        request: TeamsListProjectsInOrgRequestOptions;
        response: OctokitResponse<TeamsListProjectsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-team-permissions-for-a-project
     */
    "GET /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsCheckPermissionsForProjectInOrgEndpoint;
        request: TeamsCheckPermissionsForProjectInOrgRequestOptions;
        response: OctokitResponse<TeamsCheckPermissionsForProjectInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-repositories
     */
    "GET /orgs/:org/teams/:team_slug/repos": {
        parameters: TeamsListReposInOrgEndpoint;
        request: TeamsListReposInOrgRequestOptions;
        response: OctokitResponse<TeamsListReposInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-team-permissions-for-a-repository
     */
    "GET /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsCheckPermissionsForRepoInOrgEndpoint;
        request: TeamsCheckPermissionsForRepoInOrgRequestOptions;
        response: OctokitResponse<TeamsCheckPermissionsForRepoInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team
     */
    "GET /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
        parameters: TeamsListIdPGroupsInOrgEndpoint;
        request: TeamsListIdPGroupsInOrgRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-child-teams
     */
    "GET /orgs/:org/teams/:team_slug/teams": {
        parameters: TeamsListChildInOrgEndpoint;
        request: TeamsListChildInOrgRequestOptions;
        response: OctokitResponse<TeamsListChildInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#get-a-project
     */
    "GET /projects/:project_id": {
        parameters: ProjectsGetEndpoint;
        request: ProjectsGetRequestOptions;
        response: OctokitResponse<ProjectsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#list-project-collaborators
     */
    "GET /projects/:project_id/collaborators": {
        parameters: ProjectsListCollaboratorsEndpoint;
        request: ProjectsListCollaboratorsRequestOptions;
        response: OctokitResponse<ProjectsListCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#get-project-permission-for-a-user
     */
    "GET /projects/:project_id/collaborators/:username/permission": {
        parameters: ProjectsGetPermissionForUserEndpoint;
        request: ProjectsGetPermissionForUserRequestOptions;
        response: OctokitResponse<ProjectsGetPermissionForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#list-project-columns
     */
    "GET /projects/:project_id/columns": {
        parameters: ProjectsListColumnsEndpoint;
        request: ProjectsListColumnsRequestOptions;
        response: OctokitResponse<ProjectsListColumnsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#get-a-project-column
     */
    "GET /projects/columns/:column_id": {
        parameters: ProjectsGetColumnEndpoint;
        request: ProjectsGetColumnRequestOptions;
        response: OctokitResponse<ProjectsGetColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#list-project-cards
     */
    "GET /projects/columns/:column_id/cards": {
        parameters: ProjectsListCardsEndpoint;
        request: ProjectsListCardsRequestOptions;
        response: OctokitResponse<ProjectsListCardsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#get-a-project-card
     */
    "GET /projects/columns/cards/:card_id": {
        parameters: ProjectsGetCardEndpoint;
        request: ProjectsGetCardRequestOptions;
        response: OctokitResponse<ProjectsGetCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/rate_limit/#get-rate-limit-status-for-the-authenticated-user
     */
    "GET /rate_limit": {
        parameters: RateLimitGetEndpoint;
        request: RateLimitGetRequestOptions;
        response: OctokitResponse<RateLimitGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#get-a-repository
     */
    "GET /repos/:owner/:repo": {
        parameters: ReposGetEndpoint;
        request: ReposGetRequestOptions;
        response: OctokitResponse<ReposGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#download-a-repository-archive
     */
    "GET /repos/:owner/:repo/:archive_format/:ref": {
        parameters: ReposDownloadArchiveEndpoint;
        request: ReposDownloadArchiveRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#list-artifacts-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/artifacts": {
        parameters: ActionsListArtifactsForRepoEndpoint;
        request: ActionsListArtifactsForRepoRequestOptions;
        response: OctokitResponse<ActionsListArtifactsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#get-an-artifact
     */
    "GET /repos/:owner/:repo/actions/artifacts/:artifact_id": {
        parameters: ActionsGetArtifactEndpoint;
        request: ActionsGetArtifactRequestOptions;
        response: OctokitResponse<ActionsGetArtifactResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#download-an-artifact
     */
    "GET /repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format": {
        parameters: ActionsDownloadArtifactEndpoint;
        request: ActionsDownloadArtifactRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#get-a-job-for-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/jobs/:job_id": {
        parameters: ActionsGetJobForWorkflowRunEndpoint;
        request: ActionsGetJobForWorkflowRunRequestOptions;
        response: OctokitResponse<ActionsGetJobForWorkflowRunResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#download-job-logs-for-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/jobs/:job_id/logs": {
        parameters: ActionsDownloadJobLogsForWorkflowRunEndpoint;
        request: ActionsDownloadJobLogsForWorkflowRunRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners": {
        parameters: ActionsListSelfHostedRunnersForRepoEndpoint;
        request: ActionsListSelfHostedRunnersForRepoRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnersForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners/:runner_id": {
        parameters: ActionsGetSelfHostedRunnerForRepoEndpoint;
        request: ActionsGetSelfHostedRunnerForRepoRequestOptions;
        response: OctokitResponse<ActionsGetSelfHostedRunnerForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners/downloads": {
        parameters: ActionsListRunnerApplicationsForRepoEndpoint;
        request: ActionsListRunnerApplicationsForRepoRequestOptions;
        response: OctokitResponse<ActionsListRunnerApplicationsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runs": {
        parameters: ActionsListWorkflowRunsForRepoEndpoint;
        request: ActionsListWorkflowRunsForRepoRequestOptions;
        response: OctokitResponse<ActionsListWorkflowRunsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#get-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id": {
        parameters: ActionsGetWorkflowRunEndpoint;
        request: ActionsGetWorkflowRunRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowRunResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#list-workflow-run-artifacts
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/artifacts": {
        parameters: ActionsListWorkflowRunArtifactsEndpoint;
        request: ActionsListWorkflowRunArtifactsRequestOptions;
        response: OctokitResponse<ActionsListWorkflowRunArtifactsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#list-jobs-for-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/jobs": {
        parameters: ActionsListJobsForWorkflowRunEndpoint;
        request: ActionsListJobsForWorkflowRunRequestOptions;
        response: OctokitResponse<ActionsListJobsForWorkflowRunResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#download-workflow-run-logs
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/logs": {
        parameters: ActionsDownloadWorkflowRunLogsEndpoint;
        request: ActionsDownloadWorkflowRunLogsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#get-workflow-run-usage
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/timing": {
        parameters: ActionsGetWorkflowRunUsageEndpoint;
        request: ActionsGetWorkflowRunUsageRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowRunUsageResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#list-repository-secrets
     */
    "GET /repos/:owner/:repo/actions/secrets": {
        parameters: ActionsListRepoSecretsEndpoint;
        request: ActionsListRepoSecretsRequestOptions;
        response: OctokitResponse<ActionsListRepoSecretsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-a-repository-secret
     */
    "GET /repos/:owner/:repo/actions/secrets/:secret_name": {
        parameters: ActionsGetRepoSecretEndpoint;
        request: ActionsGetRepoSecretRequestOptions;
        response: OctokitResponse<ActionsGetRepoSecretResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-a-repository-public-key
     */
    "GET /repos/:owner/:repo/actions/secrets/public-key": {
        parameters: ActionsGetRepoPublicKeyEndpoint;
        request: ActionsGetRepoPublicKeyRequestOptions;
        response: OctokitResponse<ActionsGetRepoPublicKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#list-repository-workflows
     */
    "GET /repos/:owner/:repo/actions/workflows": {
        parameters: ActionsListRepoWorkflowsEndpoint;
        request: ActionsListRepoWorkflowsRequestOptions;
        response: OctokitResponse<ActionsListRepoWorkflowsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#get-a-workflow
     */
    "GET /repos/:owner/:repo/actions/workflows/:workflow_id": {
        parameters: ActionsGetWorkflowEndpoint;
        request: ActionsGetWorkflowRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs
     */
    "GET /repos/:owner/:repo/actions/workflows/:workflow_id/runs": {
        parameters: ActionsListWorkflowRunsEndpoint;
        request: ActionsListWorkflowRunsRequestOptions;
        response: OctokitResponse<ActionsListWorkflowRunsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#get-workflow-usage
     */
    "GET /repos/:owner/:repo/actions/workflows/:workflow_id/timing": {
        parameters: ActionsGetWorkflowUsageEndpoint;
        request: ActionsGetWorkflowUsageRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowUsageResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#list-assignees
     */
    "GET /repos/:owner/:repo/assignees": {
        parameters: IssuesListAssigneesEndpoint;
        request: IssuesListAssigneesRequestOptions;
        response: OctokitResponse<IssuesListAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#check-if-a-user-can-be-assigned
     */
    "GET /repos/:owner/:repo/assignees/:assignee": {
        parameters: IssuesCheckUserCanBeAssignedEndpoint;
        request: IssuesCheckUserCanBeAssignedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-branches
     */
    "GET /repos/:owner/:repo/branches": {
        parameters: ReposListBranchesEndpoint;
        request: ReposListBranchesRequestOptions;
        response: OctokitResponse<ReposListBranchesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-a-branch
     */
    "GET /repos/:owner/:repo/branches/:branch": {
        parameters: ReposGetBranchEndpoint;
        request: ReposGetBranchRequestOptions;
        response: OctokitResponse<ReposGetBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-branch-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposGetBranchProtectionEndpoint;
        request: ReposGetBranchProtectionRequestOptions;
        response: OctokitResponse<ReposGetBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-admin-branch-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposGetAdminBranchProtectionEndpoint;
        request: ReposGetAdminBranchProtectionRequestOptions;
        response: OctokitResponse<ReposGetAdminBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-pull-request-review-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposGetPullRequestReviewProtectionEndpoint;
        request: ReposGetPullRequestReviewProtectionRequestOptions;
        response: OctokitResponse<ReposGetPullRequestReviewProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-commit-signature-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposGetCommitSignatureProtectionEndpoint;
        request: ReposGetCommitSignatureProtectionRequestOptions;
        response: OctokitResponse<ReposGetCommitSignatureProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-status-checks-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposGetStatusChecksProtectionEndpoint;
        request: ReposGetStatusChecksProtectionRequestOptions;
        response: OctokitResponse<ReposGetStatusChecksProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-all-status-check-contexts
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposGetAllStatusCheckContextsEndpoint;
        request: ReposGetAllStatusCheckContextsRequestOptions;
        response: OctokitResponse<ReposGetAllStatusCheckContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-access-restrictions
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions": {
        parameters: ReposGetAccessRestrictionsEndpoint;
        request: ReposGetAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposGetAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-apps-with-access-to-the-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposGetAppsWithAccessToProtectedBranchEndpoint;
        request: ReposGetAppsWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetAppsWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-teams-with-access-to-the-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposGetTeamsWithAccessToProtectedBranchEndpoint;
        request: ReposGetTeamsWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetTeamsWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-users-with-access-to-the-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposGetUsersWithAccessToProtectedBranchEndpoint;
        request: ReposGetUsersWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetUsersWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#get-a-check-run
     */
    "GET /repos/:owner/:repo/check-runs/:check_run_id": {
        parameters: ChecksGetEndpoint;
        request: ChecksGetRequestOptions;
        response: OctokitResponse<ChecksGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-run-annotations
     */
    "GET /repos/:owner/:repo/check-runs/:check_run_id/annotations": {
        parameters: ChecksListAnnotationsEndpoint;
        request: ChecksListAnnotationsRequestOptions;
        response: OctokitResponse<ChecksListAnnotationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#get-a-check-suite
     */
    "GET /repos/:owner/:repo/check-suites/:check_suite_id": {
        parameters: ChecksGetSuiteEndpoint;
        request: ChecksGetSuiteRequestOptions;
        response: OctokitResponse<ChecksGetSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-runs-in-a-check-suite
     */
    "GET /repos/:owner/:repo/check-suites/:check_suite_id/check-runs": {
        parameters: ChecksListForSuiteEndpoint;
        request: ChecksListForSuiteRequestOptions;
        response: OctokitResponse<ChecksListForSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#list-code-scanning-alerts-for-a-repository
     */
    "GET /repos/:owner/:repo/code-scanning/alerts": {
        parameters: CodeScanningListAlertsForRepoEndpoint;
        request: CodeScanningListAlertsForRepoRequestOptions;
        response: OctokitResponse<CodeScanningListAlertsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#get-a-code-scanning-alert
     * @deprecated "alert_id" is deprecated, use "alert_number" instead
     */
    "GET /repos/:owner/:repo/code-scanning/alerts/:alert_id": {
        parameters: CodeScanningGetAlertDeprecatedAlertIdEndpoint;
        request: CodeScanningGetAlertRequestOptions;
        response: OctokitResponse<CodeScanningGetAlertResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#get-a-code-scanning-alert
     */
    "GET /repos/:owner/:repo/code-scanning/alerts/:alert_number": {
        parameters: CodeScanningGetAlertEndpoint;
        request: CodeScanningGetAlertRequestOptions;
        response: OctokitResponse<CodeScanningGetAlertResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#list-recent-analyses
     */
    "GET /repos/:owner/:repo/code-scanning/analyses": {
        parameters: CodeScanningListRecentAnalysesEndpoint;
        request: CodeScanningListRecentAnalysesRequestOptions;
        response: OctokitResponse<CodeScanningListRecentAnalysesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#list-repository-collaborators
     */
    "GET /repos/:owner/:repo/collaborators": {
        parameters: ReposListCollaboratorsEndpoint;
        request: ReposListCollaboratorsRequestOptions;
        response: OctokitResponse<ReposListCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#check-if-a-user-is-a-repository-collaborator
     */
    "GET /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposCheckCollaboratorEndpoint;
        request: ReposCheckCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#get-repository-permissions-for-a-user
     */
    "GET /repos/:owner/:repo/collaborators/:username/permission": {
        parameters: ReposGetCollaboratorPermissionLevelEndpoint;
        request: ReposGetCollaboratorPermissionLevelRequestOptions;
        response: OctokitResponse<ReposGetCollaboratorPermissionLevelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#list-commit-comments-for-a-repository
     */
    "GET /repos/:owner/:repo/comments": {
        parameters: ReposListCommitCommentsForRepoEndpoint;
        request: ReposListCommitCommentsForRepoRequestOptions;
        response: OctokitResponse<ReposListCommitCommentsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#get-a-commit-comment
     */
    "GET /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposGetCommitCommentEndpoint;
        request: ReposGetCommitCommentRequestOptions;
        response: OctokitResponse<ReposGetCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-commit-comment
     */
    "GET /repos/:owner/:repo/comments/:comment_id/reactions": {
        parameters: ReactionsListForCommitCommentEndpoint;
        request: ReactionsListForCommitCommentRequestOptions;
        response: OctokitResponse<ReactionsListForCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-commits
     */
    "GET /repos/:owner/:repo/commits": {
        parameters: ReposListCommitsEndpoint;
        request: ReposListCommitsRequestOptions;
        response: OctokitResponse<ReposListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-branches-for-head-commit
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/branches-where-head": {
        parameters: ReposListBranchesForHeadCommitEndpoint;
        request: ReposListBranchesForHeadCommitRequestOptions;
        response: OctokitResponse<ReposListBranchesForHeadCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#list-commit-comments
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/comments": {
        parameters: ReposListCommentsForCommitEndpoint;
        request: ReposListCommentsForCommitRequestOptions;
        response: OctokitResponse<ReposListCommentsForCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-pull-requests-associated-with-a-commit
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/pulls": {
        parameters: ReposListPullRequestsAssociatedWithCommitEndpoint;
        request: ReposListPullRequestsAssociatedWithCommitRequestOptions;
        response: OctokitResponse<ReposListPullRequestsAssociatedWithCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#get-a-commit
     */
    "GET /repos/:owner/:repo/commits/:ref": {
        parameters: ReposGetCommitEndpoint;
        request: ReposGetCommitRequestOptions;
        response: OctokitResponse<ReposGetCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-runs-for-a-git-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/check-runs": {
        parameters: ChecksListForRefEndpoint;
        request: ChecksListForRefRequestOptions;
        response: OctokitResponse<ChecksListForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#list-check-suites-for-a-git-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/check-suites": {
        parameters: ChecksListSuitesForRefEndpoint;
        request: ChecksListSuitesForRefRequestOptions;
        response: OctokitResponse<ChecksListSuitesForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#get-the-combined-status-for-a-specific-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/status": {
        parameters: ReposGetCombinedStatusForRefEndpoint;
        request: ReposGetCombinedStatusForRefRequestOptions;
        response: OctokitResponse<ReposGetCombinedStatusForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#list-commit-statuses-for-a-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/statuses": {
        parameters: ReposListCommitStatusesForRefEndpoint;
        request: ReposListCommitStatusesForRefRequestOptions;
        response: OctokitResponse<ReposListCommitStatusesForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#get-the-code-of-conduct-for-a-repository
     */
    "GET /repos/:owner/:repo/community/code_of_conduct": {
        parameters: CodesOfConductGetForRepoEndpoint;
        request: CodesOfConductGetForRepoRequestOptions;
        response: OctokitResponse<CodesOfConductGetForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/community/#get-community-profile-metrics
     */
    "GET /repos/:owner/:repo/community/profile": {
        parameters: ReposGetCommunityProfileMetricsEndpoint;
        request: ReposGetCommunityProfileMetricsRequestOptions;
        response: OctokitResponse<ReposGetCommunityProfileMetricsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#compare-two-commits
     */
    "GET /repos/:owner/:repo/compare/:base...:head": {
        parameters: ReposCompareCommitsEndpoint;
        request: ReposCompareCommitsRequestOptions;
        response: OctokitResponse<ReposCompareCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#get-repository-content
     */
    "GET /repos/:owner/:repo/contents/:path": {
        parameters: ReposGetContentEndpoint;
        request: ReposGetContentRequestOptions;
        response: OctokitResponse<ReposGetContentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repository-contributors
     */
    "GET /repos/:owner/:repo/contributors": {
        parameters: ReposListContributorsEndpoint;
        request: ReposListContributorsRequestOptions;
        response: OctokitResponse<ReposListContributorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#list-deployments
     */
    "GET /repos/:owner/:repo/deployments": {
        parameters: ReposListDeploymentsEndpoint;
        request: ReposListDeploymentsRequestOptions;
        response: OctokitResponse<ReposListDeploymentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#get-a-deployment
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id": {
        parameters: ReposGetDeploymentEndpoint;
        request: ReposGetDeploymentRequestOptions;
        response: OctokitResponse<ReposGetDeploymentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#list-deployment-statuses
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id/statuses": {
        parameters: ReposListDeploymentStatusesEndpoint;
        request: ReposListDeploymentStatusesRequestOptions;
        response: OctokitResponse<ReposListDeploymentStatusesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#get-a-deployment-status
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id": {
        parameters: ReposGetDeploymentStatusEndpoint;
        request: ReposGetDeploymentStatusRequestOptions;
        response: OctokitResponse<ReposGetDeploymentStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-repository-events
     */
    "GET /repos/:owner/:repo/events": {
        parameters: ActivityListRepoEventsEndpoint;
        request: ActivityListRepoEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/forks/#list-forks
     */
    "GET /repos/:owner/:repo/forks": {
        parameters: ReposListForksEndpoint;
        request: ReposListForksRequestOptions;
        response: OctokitResponse<ReposListForksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/blobs/#get-a-blob
     */
    "GET /repos/:owner/:repo/git/blobs/:file_sha": {
        parameters: GitGetBlobEndpoint;
        request: GitGetBlobRequestOptions;
        response: OctokitResponse<GitGetBlobResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/commits/#get-a-commit
     */
    "GET /repos/:owner/:repo/git/commits/:commit_sha": {
        parameters: GitGetCommitEndpoint;
        request: GitGetCommitRequestOptions;
        response: OctokitResponse<GitGetCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#list-matching-references
     */
    "GET /repos/:owner/:repo/git/matching-refs/:ref": {
        parameters: GitListMatchingRefsEndpoint;
        request: GitListMatchingRefsRequestOptions;
        response: OctokitResponse<GitListMatchingRefsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#get-a-reference
     */
    "GET /repos/:owner/:repo/git/ref/:ref": {
        parameters: GitGetRefEndpoint;
        request: GitGetRefRequestOptions;
        response: OctokitResponse<GitGetRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/tags/#get-a-tag
     */
    "GET /repos/:owner/:repo/git/tags/:tag_sha": {
        parameters: GitGetTagEndpoint;
        request: GitGetTagRequestOptions;
        response: OctokitResponse<GitGetTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/trees/#get-a-tree
     */
    "GET /repos/:owner/:repo/git/trees/:tree_sha": {
        parameters: GitGetTreeEndpoint;
        request: GitGetTreeRequestOptions;
        response: OctokitResponse<GitGetTreeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#list-repository-webhooks
     */
    "GET /repos/:owner/:repo/hooks": {
        parameters: ReposListWebhooksEndpoint;
        request: ReposListWebhooksRequestOptions;
        response: OctokitResponse<ReposListWebhooksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#get-a-repository-webhook
     */
    "GET /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposGetWebhookEndpoint;
        request: ReposGetWebhookRequestOptions;
        response: OctokitResponse<ReposGetWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-an-import-status
     */
    "GET /repos/:owner/:repo/import": {
        parameters: MigrationsGetImportStatusEndpoint;
        request: MigrationsGetImportStatusRequestOptions;
        response: OctokitResponse<MigrationsGetImportStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-commit-authors
     */
    "GET /repos/:owner/:repo/import/authors": {
        parameters: MigrationsGetCommitAuthorsEndpoint;
        request: MigrationsGetCommitAuthorsRequestOptions;
        response: OctokitResponse<MigrationsGetCommitAuthorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-large-files
     */
    "GET /repos/:owner/:repo/import/large_files": {
        parameters: MigrationsGetLargeFilesEndpoint;
        request: MigrationsGetLargeFilesRequestOptions;
        response: OctokitResponse<MigrationsGetLargeFilesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-a-repository-installation-for-the-authenticated-app
     */
    "GET /repos/:owner/:repo/installation": {
        parameters: AppsGetRepoInstallationEndpoint;
        request: AppsGetRepoInstallationRequestOptions;
        response: OctokitResponse<AppsGetRepoInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#get-interaction-restrictions-for-a-repository
     */
    "GET /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsGetRestrictionsForRepoEndpoint;
        request: InteractionsGetRestrictionsForRepoRequestOptions;
        response: OctokitResponse<InteractionsGetRestrictionsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#list-repository-invitations
     */
    "GET /repos/:owner/:repo/invitations": {
        parameters: ReposListInvitationsEndpoint;
        request: ReposListInvitationsRequestOptions;
        response: OctokitResponse<ReposListInvitationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-repository-issues
     */
    "GET /repos/:owner/:repo/issues": {
        parameters: IssuesListForRepoEndpoint;
        request: IssuesListForRepoRequestOptions;
        response: OctokitResponse<IssuesListForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#get-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number": {
        parameters: IssuesGetEndpoint;
        request: IssuesGetRequestOptions;
        response: OctokitResponse<IssuesGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#list-issue-comments
     */
    "GET /repos/:owner/:repo/issues/:issue_number/comments": {
        parameters: IssuesListCommentsEndpoint;
        request: IssuesListCommentsRequestOptions;
        response: OctokitResponse<IssuesListCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#list-issue-events
     */
    "GET /repos/:owner/:repo/issues/:issue_number/events": {
        parameters: IssuesListEventsEndpoint;
        request: IssuesListEventsRequestOptions;
        response: OctokitResponse<IssuesListEventsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#list-labels-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesListLabelsOnIssueEndpoint;
        request: IssuesListLabelsOnIssueRequestOptions;
        response: OctokitResponse<IssuesListLabelsOnIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/reactions": {
        parameters: ReactionsListForIssueEndpoint;
        request: ReactionsListForIssueRequestOptions;
        response: OctokitResponse<ReactionsListForIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/timeline/#list-timeline-events-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/timeline": {
        parameters: IssuesListEventsForTimelineEndpoint;
        request: IssuesListEventsForTimelineRequestOptions;
        response: OctokitResponse<IssuesListEventsForTimelineResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#list-issue-comments-for-a-repository
     */
    "GET /repos/:owner/:repo/issues/comments": {
        parameters: IssuesListCommentsForRepoEndpoint;
        request: IssuesListCommentsForRepoRequestOptions;
        response: OctokitResponse<IssuesListCommentsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#get-an-issue-comment
     */
    "GET /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesGetCommentEndpoint;
        request: IssuesGetCommentRequestOptions;
        response: OctokitResponse<IssuesGetCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue-comment
     */
    "GET /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
        parameters: ReactionsListForIssueCommentEndpoint;
        request: ReactionsListForIssueCommentRequestOptions;
        response: OctokitResponse<ReactionsListForIssueCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#list-issue-events-for-a-repository
     */
    "GET /repos/:owner/:repo/issues/events": {
        parameters: IssuesListEventsForRepoEndpoint;
        request: IssuesListEventsForRepoRequestOptions;
        response: OctokitResponse<IssuesListEventsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#get-an-issue-event
     */
    "GET /repos/:owner/:repo/issues/events/:event_id": {
        parameters: IssuesGetEventEndpoint;
        request: IssuesGetEventRequestOptions;
        response: OctokitResponse<IssuesGetEventResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#list-deploy-keys
     */
    "GET /repos/:owner/:repo/keys": {
        parameters: ReposListDeployKeysEndpoint;
        request: ReposListDeployKeysRequestOptions;
        response: OctokitResponse<ReposListDeployKeysResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#get-a-deploy-key
     */
    "GET /repos/:owner/:repo/keys/:key_id": {
        parameters: ReposGetDeployKeyEndpoint;
        request: ReposGetDeployKeyRequestOptions;
        response: OctokitResponse<ReposGetDeployKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#list-labels-for-a-repository
     */
    "GET /repos/:owner/:repo/labels": {
        parameters: IssuesListLabelsForRepoEndpoint;
        request: IssuesListLabelsForRepoRequestOptions;
        response: OctokitResponse<IssuesListLabelsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#get-a-label
     */
    "GET /repos/:owner/:repo/labels/:name": {
        parameters: IssuesGetLabelEndpoint;
        request: IssuesGetLabelRequestOptions;
        response: OctokitResponse<IssuesGetLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repository-languages
     */
    "GET /repos/:owner/:repo/languages": {
        parameters: ReposListLanguagesEndpoint;
        request: ReposListLanguagesRequestOptions;
        response: OctokitResponse<ReposListLanguagesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#get-the-license-for-a-repository
     */
    "GET /repos/:owner/:repo/license": {
        parameters: LicensesGetForRepoEndpoint;
        request: LicensesGetForRepoRequestOptions;
        response: OctokitResponse<LicensesGetForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#list-milestones
     */
    "GET /repos/:owner/:repo/milestones": {
        parameters: IssuesListMilestonesEndpoint;
        request: IssuesListMilestonesRequestOptions;
        response: OctokitResponse<IssuesListMilestonesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#get-a-milestone
     */
    "GET /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesGetMilestoneEndpoint;
        request: IssuesGetMilestoneRequestOptions;
        response: OctokitResponse<IssuesGetMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#list-labels-for-issues-in-a-milestone
     */
    "GET /repos/:owner/:repo/milestones/:milestone_number/labels": {
        parameters: IssuesListLabelsForMilestoneEndpoint;
        request: IssuesListLabelsForMilestoneRequestOptions;
        response: OctokitResponse<IssuesListLabelsForMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#list-repository-notifications-for-the-authenticated-user
     */
    "GET /repos/:owner/:repo/notifications": {
        parameters: ActivityListRepoNotificationsForAuthenticatedUserEndpoint;
        request: ActivityListRepoNotificationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListRepoNotificationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-a-github-pages-site
     */
    "GET /repos/:owner/:repo/pages": {
        parameters: ReposGetPagesEndpoint;
        request: ReposGetPagesRequestOptions;
        response: OctokitResponse<ReposGetPagesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#list-github-pages-builds
     */
    "GET /repos/:owner/:repo/pages/builds": {
        parameters: ReposListPagesBuildsEndpoint;
        request: ReposListPagesBuildsRequestOptions;
        response: OctokitResponse<ReposListPagesBuildsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-github-pages-build
     */
    "GET /repos/:owner/:repo/pages/builds/:build_id": {
        parameters: ReposGetPagesBuildEndpoint;
        request: ReposGetPagesBuildRequestOptions;
        response: OctokitResponse<ReposGetPagesBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-latest-pages-build
     */
    "GET /repos/:owner/:repo/pages/builds/latest": {
        parameters: ReposGetLatestPagesBuildEndpoint;
        request: ReposGetLatestPagesBuildRequestOptions;
        response: OctokitResponse<ReposGetLatestPagesBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-repository-projects
     */
    "GET /repos/:owner/:repo/projects": {
        parameters: ProjectsListForRepoEndpoint;
        request: ProjectsListForRepoRequestOptions;
        response: OctokitResponse<ProjectsListForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-pull-requests
     */
    "GET /repos/:owner/:repo/pulls": {
        parameters: PullsListEndpoint;
        request: PullsListRequestOptions;
        response: OctokitResponse<PullsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#get-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number": {
        parameters: PullsGetEndpoint;
        request: PullsGetRequestOptions;
        response: OctokitResponse<PullsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#list-review-comments-on-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/comments": {
        parameters: PullsListReviewCommentsEndpoint;
        request: PullsListReviewCommentsRequestOptions;
        response: OctokitResponse<PullsListReviewCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-commits-on-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/commits": {
        parameters: PullsListCommitsEndpoint;
        request: PullsListCommitsRequestOptions;
        response: OctokitResponse<PullsListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-pull-requests-files
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/files": {
        parameters: PullsListFilesEndpoint;
        request: PullsListFilesRequestOptions;
        response: OctokitResponse<PullsListFilesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#check-if-a-pull-request-has-been-merged
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/merge": {
        parameters: PullsCheckIfMergedEndpoint;
        request: PullsCheckIfMergedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#list-requested-reviewers-for-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsListRequestedReviewersEndpoint;
        request: PullsListRequestedReviewersRequestOptions;
        response: OctokitResponse<PullsListRequestedReviewersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#list-reviews-for-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews": {
        parameters: PullsListReviewsEndpoint;
        request: PullsListReviewsRequestOptions;
        response: OctokitResponse<PullsListReviewsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#get-a-review-for-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsGetReviewEndpoint;
        request: PullsGetReviewRequestOptions;
        response: OctokitResponse<PullsGetReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#list-comments-for-a-pull-request-review
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments": {
        parameters: PullsListCommentsForReviewEndpoint;
        request: PullsListCommentsForReviewRequestOptions;
        response: OctokitResponse<PullsListCommentsForReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#list-review-comments-in-a-repository
     */
    "GET /repos/:owner/:repo/pulls/comments": {
        parameters: PullsListReviewCommentsForRepoEndpoint;
        request: PullsListReviewCommentsForRepoRequestOptions;
        response: OctokitResponse<PullsListReviewCommentsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#get-a-review-comment-for-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsGetReviewCommentEndpoint;
        request: PullsGetReviewCommentRequestOptions;
        response: OctokitResponse<PullsGetReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-pull-request-review-comment
     */
    "GET /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
        parameters: ReactionsListForPullRequestReviewCommentEndpoint;
        request: ReactionsListForPullRequestReviewCommentRequestOptions;
        response: OctokitResponse<ReactionsListForPullRequestReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#get-a-repository-readme
     */
    "GET /repos/:owner/:repo/readme": {
        parameters: ReposGetReadmeEndpoint;
        request: ReposGetReadmeRequestOptions;
        response: OctokitResponse<ReposGetReadmeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#list-releases
     */
    "GET /repos/:owner/:repo/releases": {
        parameters: ReposListReleasesEndpoint;
        request: ReposListReleasesRequestOptions;
        response: OctokitResponse<ReposListReleasesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-release
     */
    "GET /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposGetReleaseEndpoint;
        request: ReposGetReleaseRequestOptions;
        response: OctokitResponse<ReposGetReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#list-release-assets
     */
    "GET /repos/:owner/:repo/releases/:release_id/assets": {
        parameters: ReposListReleaseAssetsEndpoint;
        request: ReposListReleaseAssetsRequestOptions;
        response: OctokitResponse<ReposListReleaseAssetsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-release-asset
     */
    "GET /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposGetReleaseAssetEndpoint;
        request: ReposGetReleaseAssetRequestOptions;
        response: OctokitResponse<ReposGetReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-the-latest-release
     */
    "GET /repos/:owner/:repo/releases/latest": {
        parameters: ReposGetLatestReleaseEndpoint;
        request: ReposGetLatestReleaseRequestOptions;
        response: OctokitResponse<ReposGetLatestReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-release-by-tag-name
     */
    "GET /repos/:owner/:repo/releases/tags/:tag": {
        parameters: ReposGetReleaseByTagEndpoint;
        request: ReposGetReleaseByTagRequestOptions;
        response: OctokitResponse<ReposGetReleaseByTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-stargazers
     */
    "GET /repos/:owner/:repo/stargazers": {
        parameters: ActivityListStargazersForRepoEndpoint;
        request: ActivityListStargazersForRepoRequestOptions;
        response: OctokitResponse<ActivityListStargazersForRepoResponseData | ActivityListStargazersForRepoResponse200Data>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-weekly-commit-activity
     */
    "GET /repos/:owner/:repo/stats/code_frequency": {
        parameters: ReposGetCodeFrequencyStatsEndpoint;
        request: ReposGetCodeFrequencyStatsRequestOptions;
        response: OctokitResponse<ReposGetCodeFrequencyStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-last-year-of-commit-activity
     */
    "GET /repos/:owner/:repo/stats/commit_activity": {
        parameters: ReposGetCommitActivityStatsEndpoint;
        request: ReposGetCommitActivityStatsRequestOptions;
        response: OctokitResponse<ReposGetCommitActivityStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-all-contributor-commit-activity
     */
    "GET /repos/:owner/:repo/stats/contributors": {
        parameters: ReposGetContributorsStatsEndpoint;
        request: ReposGetContributorsStatsRequestOptions;
        response: OctokitResponse<ReposGetContributorsStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-weekly-commit-count
     */
    "GET /repos/:owner/:repo/stats/participation": {
        parameters: ReposGetParticipationStatsEndpoint;
        request: ReposGetParticipationStatsRequestOptions;
        response: OctokitResponse<ReposGetParticipationStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-hourly-commit-count-for-each-day
     */
    "GET /repos/:owner/:repo/stats/punch_card": {
        parameters: ReposGetPunchCardStatsEndpoint;
        request: ReposGetPunchCardStatsRequestOptions;
        response: OctokitResponse<ReposGetPunchCardStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-watchers
     */
    "GET /repos/:owner/:repo/subscribers": {
        parameters: ActivityListWatchersForRepoEndpoint;
        request: ActivityListWatchersForRepoRequestOptions;
        response: OctokitResponse<ActivityListWatchersForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#get-a-repository-subscription
     */
    "GET /repos/:owner/:repo/subscription": {
        parameters: ActivityGetRepoSubscriptionEndpoint;
        request: ActivityGetRepoSubscriptionRequestOptions;
        response: OctokitResponse<ActivityGetRepoSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repository-tags
     */
    "GET /repos/:owner/:repo/tags": {
        parameters: ReposListTagsEndpoint;
        request: ReposListTagsRequestOptions;
        response: OctokitResponse<ReposListTagsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repository-teams
     */
    "GET /repos/:owner/:repo/teams": {
        parameters: ReposListTeamsEndpoint;
        request: ReposListTeamsRequestOptions;
        response: OctokitResponse<ReposListTeamsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#get-all-repository-topics
     */
    "GET /repos/:owner/:repo/topics": {
        parameters: ReposGetAllTopicsEndpoint;
        request: ReposGetAllTopicsRequestOptions;
        response: OctokitResponse<ReposGetAllTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#get-repository-clones
     */
    "GET /repos/:owner/:repo/traffic/clones": {
        parameters: ReposGetClonesEndpoint;
        request: ReposGetClonesRequestOptions;
        response: OctokitResponse<ReposGetClonesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#get-top-referral-paths
     */
    "GET /repos/:owner/:repo/traffic/popular/paths": {
        parameters: ReposGetTopPathsEndpoint;
        request: ReposGetTopPathsRequestOptions;
        response: OctokitResponse<ReposGetTopPathsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#get-top-referral-sources
     */
    "GET /repos/:owner/:repo/traffic/popular/referrers": {
        parameters: ReposGetTopReferrersEndpoint;
        request: ReposGetTopReferrersRequestOptions;
        response: OctokitResponse<ReposGetTopReferrersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#get-page-views
     */
    "GET /repos/:owner/:repo/traffic/views": {
        parameters: ReposGetViewsEndpoint;
        request: ReposGetViewsRequestOptions;
        response: OctokitResponse<ReposGetViewsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#check-if-vulnerability-alerts-are-enabled-for-a-repository
     */
    "GET /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposCheckVulnerabilityAlertsEndpoint;
        request: ReposCheckVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-public-repositories
     */
    "GET /repositories": {
        parameters: ReposListPublicEndpoint;
        request: ReposListPublicRequestOptions;
        response: OctokitResponse<ReposListPublicResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#list-provisioned-scim groups-for-an-enterprise
     */
    "GET /scim/v2/enterprises/:enterprise/Groups": {
        parameters: EnterpriseAdminListProvisionedGroupsEnterpriseEndpoint;
        request: EnterpriseAdminListProvisionedGroupsEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListProvisionedGroupsEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#get-scim-provisioning-information-for-an-enterprise group
     */
    "GET /scim/v2/enterprises/:enterprise/Groups/:scim_group_id": {
        parameters: EnterpriseAdminGetProvisioningInformationForEnterpriseGroupEndpoint;
        request: EnterpriseAdminGetProvisioningInformationForEnterpriseGroupRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetProvisioningInformationForEnterpriseGroupResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#list-scim-provisioned-identities-for-an-enterprise
     */
    "GET /scim/v2/enterprises/:enterprise/Users": {
        parameters: EnterpriseAdminListProvisionedIdentitiesEnterpriseEndpoint;
        request: EnterpriseAdminListProvisionedIdentitiesEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminListProvisionedIdentitiesEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#get-scim-provisioning-information-for-an-enterprise-user
     */
    "GET /scim/v2/enterprises/:enterprise/Users/:scim_user_id": {
        parameters: EnterpriseAdminGetProvisioningInformationForEnterpriseUserEndpoint;
        request: EnterpriseAdminGetProvisioningInformationForEnterpriseUserRequestOptions;
        response: OctokitResponse<EnterpriseAdminGetProvisioningInformationForEnterpriseUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#list-scim-provisioned-identities
     */
    "GET /scim/v2/organizations/:org/Users": {
        parameters: ScimListProvisionedIdentitiesEndpoint;
        request: ScimListProvisionedIdentitiesRequestOptions;
        response: OctokitResponse<ScimListProvisionedIdentitiesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#get-scim-provisioning-information-for-a-user
     */
    "GET /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimGetProvisioningInformationForUserEndpoint;
        request: ScimGetProvisioningInformationForUserRequestOptions;
        response: OctokitResponse<ScimGetProvisioningInformationForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-code
     */
    "GET /search/code": {
        parameters: SearchCodeEndpoint;
        request: SearchCodeRequestOptions;
        response: OctokitResponse<SearchCodeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-commits
     */
    "GET /search/commits": {
        parameters: SearchCommitsEndpoint;
        request: SearchCommitsRequestOptions;
        response: OctokitResponse<SearchCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-issues-and-pull-requests
     */
    "GET /search/issues": {
        parameters: SearchIssuesAndPullRequestsEndpoint;
        request: SearchIssuesAndPullRequestsRequestOptions;
        response: OctokitResponse<SearchIssuesAndPullRequestsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-labels
     */
    "GET /search/labels": {
        parameters: SearchLabelsEndpoint;
        request: SearchLabelsRequestOptions;
        response: OctokitResponse<SearchLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-repositories
     */
    "GET /search/repositories": {
        parameters: SearchReposEndpoint;
        request: SearchReposRequestOptions;
        response: OctokitResponse<SearchReposResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-topics
     */
    "GET /search/topics": {
        parameters: SearchTopicsEndpoint;
        request: SearchTopicsRequestOptions;
        response: OctokitResponse<SearchTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-users
     */
    "GET /search/users": {
        parameters: SearchUsersEndpoint;
        request: SearchUsersRequestOptions;
        response: OctokitResponse<SearchUsersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#get-a-team-legacy
     */
    "GET /teams/:team_id": {
        parameters: TeamsGetLegacyEndpoint;
        request: TeamsGetLegacyRequestOptions;
        response: OctokitResponse<TeamsGetLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#list-discussions-legacy
     */
    "GET /teams/:team_id/discussions": {
        parameters: TeamsListDiscussionsLegacyEndpoint;
        request: TeamsListDiscussionsLegacyRequestOptions;
        response: OctokitResponse<TeamsListDiscussionsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#get-a-discussion-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsGetDiscussionLegacyEndpoint;
        request: TeamsGetDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#list-discussion-comments-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments": {
        parameters: TeamsListDiscussionCommentsLegacyEndpoint;
        request: TeamsListDiscussionCommentsLegacyRequestOptions;
        response: OctokitResponse<TeamsListDiscussionCommentsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-discussion-comment-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsGetDiscussionCommentLegacyEndpoint;
        request: TeamsGetDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsListForTeamDiscussionCommentLegacyEndpoint;
        request: ReactionsListForTeamDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/reactions": {
        parameters: ReactionsListForTeamDiscussionLegacyEndpoint;
        request: ReactionsListForTeamDiscussionLegacyRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations-legacy
     */
    "GET /teams/:team_id/invitations": {
        parameters: TeamsListPendingInvitationsLegacyEndpoint;
        request: TeamsListPendingInvitationsLegacyRequestOptions;
        response: OctokitResponse<TeamsListPendingInvitationsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-team-members-legacy
     */
    "GET /teams/:team_id/members": {
        parameters: TeamsListMembersLegacyEndpoint;
        request: TeamsListMembersLegacyRequestOptions;
        response: OctokitResponse<TeamsListMembersLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-member-legacy
     */
    "GET /teams/:team_id/members/:username": {
        parameters: TeamsGetMemberLegacyEndpoint;
        request: TeamsGetMemberLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-membership-for-a-user-legacy
     */
    "GET /teams/:team_id/memberships/:username": {
        parameters: TeamsGetMembershipForUserLegacyEndpoint;
        request: TeamsGetMembershipForUserLegacyRequestOptions;
        response: OctokitResponse<TeamsGetMembershipForUserLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-projects-legacy
     */
    "GET /teams/:team_id/projects": {
        parameters: TeamsListProjectsLegacyEndpoint;
        request: TeamsListProjectsLegacyRequestOptions;
        response: OctokitResponse<TeamsListProjectsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-team-permissions-for-a-project-legacy
     */
    "GET /teams/:team_id/projects/:project_id": {
        parameters: TeamsCheckPermissionsForProjectLegacyEndpoint;
        request: TeamsCheckPermissionsForProjectLegacyRequestOptions;
        response: OctokitResponse<TeamsCheckPermissionsForProjectLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-repositories-legacy
     */
    "GET /teams/:team_id/repos": {
        parameters: TeamsListReposLegacyEndpoint;
        request: TeamsListReposLegacyRequestOptions;
        response: OctokitResponse<TeamsListReposLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-team-permissions-for-a-repository-legacy
     */
    "GET /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsCheckPermissionsForRepoLegacyEndpoint;
        request: TeamsCheckPermissionsForRepoLegacyRequestOptions;
        response: OctokitResponse<TeamsCheckPermissionsForRepoLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team-legacy
     */
    "GET /teams/:team_id/team-sync/group-mappings": {
        parameters: TeamsListIdPGroupsForLegacyEndpoint;
        request: TeamsListIdPGroupsForLegacyRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsForLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-child-teams-legacy
     */
    "GET /teams/:team_id/teams": {
        parameters: TeamsListChildLegacyEndpoint;
        request: TeamsListChildLegacyRequestOptions;
        response: OctokitResponse<TeamsListChildLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-the-authenticated-user
     */
    "GET /user": {
        parameters: UsersGetAuthenticatedEndpoint;
        request: UsersGetAuthenticatedRequestOptions;
        response: OctokitResponse<UsersGetAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#list-users-blocked-by-the-authenticated-user
     */
    "GET /user/blocks": {
        parameters: UsersListBlockedByAuthenticatedEndpoint;
        request: UsersListBlockedByAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListBlockedByAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#check-if-a-user-is-blocked-by-the-authenticated-user
     */
    "GET /user/blocks/:username": {
        parameters: UsersCheckBlockedEndpoint;
        request: UsersCheckBlockedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#list-email-addresses-for-the-authenticated-user
     */
    "GET /user/emails": {
        parameters: UsersListEmailsForAuthenticatedEndpoint;
        request: UsersListEmailsForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListEmailsForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-followers-of-the-authenticated-user
     */
    "GET /user/followers": {
        parameters: UsersListFollowersForAuthenticatedUserEndpoint;
        request: UsersListFollowersForAuthenticatedUserRequestOptions;
        response: OctokitResponse<UsersListFollowersForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-the-people-the-authenticated-user-follows
     */
    "GET /user/following": {
        parameters: UsersListFollowedByAuthenticatedEndpoint;
        request: UsersListFollowedByAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListFollowedByAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#check-if-a-person-is-followed-by-the-authenticated-user
     */
    "GET /user/following/:username": {
        parameters: UsersCheckPersonIsFollowedByAuthenticatedEndpoint;
        request: UsersCheckPersonIsFollowedByAuthenticatedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#list-gpg-keys-for-the-authenticated-user
     */
    "GET /user/gpg_keys": {
        parameters: UsersListGpgKeysForAuthenticatedEndpoint;
        request: UsersListGpgKeysForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListGpgKeysForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#get-a-gpg-key-for-the-authenticated-user
     */
    "GET /user/gpg_keys/:gpg_key_id": {
        parameters: UsersGetGpgKeyForAuthenticatedEndpoint;
        request: UsersGetGpgKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersGetGpgKeyForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-app-installations-accessible-to-the-user-access-token
     */
    "GET /user/installations": {
        parameters: AppsListInstallationsForAuthenticatedUserEndpoint;
        request: AppsListInstallationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListInstallationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-user-access-token
     */
    "GET /user/installations/:installation_id/repositories": {
        parameters: AppsListInstallationReposForAuthenticatedUserEndpoint;
        request: AppsListInstallationReposForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListInstallationReposForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-user-account-issues-assigned-to-the-authenticated-user
     */
    "GET /user/issues": {
        parameters: IssuesListForAuthenticatedUserEndpoint;
        request: IssuesListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<IssuesListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#list-public-ssh-keys-for-the-authenticated-user
     */
    "GET /user/keys": {
        parameters: UsersListPublicSshKeysForAuthenticatedEndpoint;
        request: UsersListPublicSshKeysForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListPublicSshKeysForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#get-a-public-ssh-key-for-the-authenticated-user
     */
    "GET /user/keys/:key_id": {
        parameters: UsersGetPublicSshKeyForAuthenticatedEndpoint;
        request: UsersGetPublicSshKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersGetPublicSshKeyForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user
     */
    "GET /user/marketplace_purchases": {
        parameters: AppsListSubscriptionsForAuthenticatedUserEndpoint;
        request: AppsListSubscriptionsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListSubscriptionsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user-stubbed
     */
    "GET /user/marketplace_purchases/stubbed": {
        parameters: AppsListSubscriptionsForAuthenticatedUserStubbedEndpoint;
        request: AppsListSubscriptionsForAuthenticatedUserStubbedRequestOptions;
        response: OctokitResponse<AppsListSubscriptionsForAuthenticatedUserStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-organization-memberships-for-the-authenticated-user
     */
    "GET /user/memberships/orgs": {
        parameters: OrgsListMembershipsForAuthenticatedUserEndpoint;
        request: OrgsListMembershipsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsListMembershipsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#get-an-organization-membership-for-the-authenticated-user
     */
    "GET /user/memberships/orgs/:org": {
        parameters: OrgsGetMembershipForAuthenticatedUserEndpoint;
        request: OrgsGetMembershipForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsGetMembershipForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#list-user-migrations
     */
    "GET /user/migrations": {
        parameters: MigrationsListForAuthenticatedUserEndpoint;
        request: MigrationsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#get-a-user-migration-status
     */
    "GET /user/migrations/:migration_id": {
        parameters: MigrationsGetStatusForAuthenticatedUserEndpoint;
        request: MigrationsGetStatusForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsGetStatusForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#download-a-user-migration-archive
     */
    "GET /user/migrations/:migration_id/archive": {
        parameters: MigrationsGetArchiveForAuthenticatedUserEndpoint;
        request: MigrationsGetArchiveForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#list-repositories-for-a-user-migration
     */
    "GET /user/migrations/:migration_id/repositories": {
        parameters: MigrationsListReposForUserEndpoint;
        request: MigrationsListReposForUserRequestOptions;
        response: OctokitResponse<MigrationsListReposForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-organizations-for-the-authenticated-user
     */
    "GET /user/orgs": {
        parameters: OrgsListForAuthenticatedUserEndpoint;
        request: OrgsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#list-public-email-addresses-for-the-authenticated-user
     */
    "GET /user/public_emails": {
        parameters: UsersListPublicEmailsForAuthenticatedEndpoint;
        request: UsersListPublicEmailsForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListPublicEmailsForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repositories-for-the-authenticated-user
     */
    "GET /user/repos": {
        parameters: ReposListForAuthenticatedUserEndpoint;
        request: ReposListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#list-repository-invitations-for-the-authenticated-user
     */
    "GET /user/repository_invitations": {
        parameters: ReposListInvitationsForAuthenticatedUserEndpoint;
        request: ReposListInvitationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ReposListInvitationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-the-authenticated-user
     */
    "GET /user/starred": {
        parameters: ActivityListReposStarredByAuthenticatedUserEndpoint;
        request: ActivityListReposStarredByAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListReposStarredByAuthenticatedUserResponseData | ActivityListReposStarredByAuthenticatedUserResponse200Data>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#check-if-a-repository-is-starred-by-the-authenticated-user
     */
    "GET /user/starred/:owner/:repo": {
        parameters: ActivityCheckRepoIsStarredByAuthenticatedUserEndpoint;
        request: ActivityCheckRepoIsStarredByAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-the-authenticated-user
     */
    "GET /user/subscriptions": {
        parameters: ActivityListWatchedReposForAuthenticatedUserEndpoint;
        request: ActivityListWatchedReposForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListWatchedReposForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-teams-for-the-authenticated-user
     */
    "GET /user/teams": {
        parameters: TeamsListForAuthenticatedUserEndpoint;
        request: TeamsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<TeamsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#list-users
     */
    "GET /users": {
        parameters: UsersListEndpoint;
        request: UsersListRequestOptions;
        response: OctokitResponse<UsersListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-a-user
     */
    "GET /users/:username": {
        parameters: UsersGetByUsernameEndpoint;
        request: UsersGetByUsernameRequestOptions;
        response: OctokitResponse<UsersGetByUsernameResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-events-for-the-authenticated-user
     */
    "GET /users/:username/events": {
        parameters: ActivityListEventsForAuthenticatedUserEndpoint;
        request: ActivityListEventsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-organization-events-for-the-authenticated-user
     */
    "GET /users/:username/events/orgs/:org": {
        parameters: ActivityListOrgEventsForAuthenticatedUserEndpoint;
        request: ActivityListOrgEventsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-user
     */
    "GET /users/:username/events/public": {
        parameters: ActivityListPublicEventsForUserEndpoint;
        request: ActivityListPublicEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-followers-of-a-user
     */
    "GET /users/:username/followers": {
        parameters: UsersListFollowersForUserEndpoint;
        request: UsersListFollowersForUserRequestOptions;
        response: OctokitResponse<UsersListFollowersForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-the-people-a-user-follows
     */
    "GET /users/:username/following": {
        parameters: UsersListFollowingForUserEndpoint;
        request: UsersListFollowingForUserRequestOptions;
        response: OctokitResponse<UsersListFollowingForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#check-if-a-user-follows-another-user
     */
    "GET /users/:username/following/:target_user": {
        parameters: UsersCheckFollowingForUserEndpoint;
        request: UsersCheckFollowingForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gists-for-a-user
     */
    "GET /users/:username/gists": {
        parameters: GistsListForUserEndpoint;
        request: GistsListForUserRequestOptions;
        response: OctokitResponse<GistsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#list-gpg-keys-for-a-user
     */
    "GET /users/:username/gpg_keys": {
        parameters: UsersListGpgKeysForUserEndpoint;
        request: UsersListGpgKeysForUserRequestOptions;
        response: OctokitResponse<UsersListGpgKeysForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-contextual-information-for-a-user
     */
    "GET /users/:username/hovercard": {
        parameters: UsersGetContextForUserEndpoint;
        request: UsersGetContextForUserRequestOptions;
        response: OctokitResponse<UsersGetContextForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-a-user-installation-for-the-authenticated-app
     */
    "GET /users/:username/installation": {
        parameters: AppsGetUserInstallationEndpoint;
        request: AppsGetUserInstallationRequestOptions;
        response: OctokitResponse<AppsGetUserInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#list-public-keys-for-a-user
     */
    "GET /users/:username/keys": {
        parameters: UsersListPublicKeysForUserEndpoint;
        request: UsersListPublicKeysForUserRequestOptions;
        response: OctokitResponse<UsersListPublicKeysForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-organizations-for-a-user
     */
    "GET /users/:username/orgs": {
        parameters: OrgsListForUserEndpoint;
        request: OrgsListForUserRequestOptions;
        response: OctokitResponse<OrgsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-user-projects
     */
    "GET /users/:username/projects": {
        parameters: ProjectsListForUserEndpoint;
        request: ProjectsListForUserRequestOptions;
        response: OctokitResponse<ProjectsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-events-received-by-the-authenticated-user
     */
    "GET /users/:username/received_events": {
        parameters: ActivityListReceivedEventsForUserEndpoint;
        request: ActivityListReceivedEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-received-by-a-user
     */
    "GET /users/:username/received_events/public": {
        parameters: ActivityListReceivedPublicEventsForUserEndpoint;
        request: ActivityListReceivedPublicEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repositories-for-a-user
     */
    "GET /users/:username/repos": {
        parameters: ReposListForUserEndpoint;
        request: ReposListForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-github-actions-billing-for-a-user
     */
    "GET /users/:username/settings/billing/actions": {
        parameters: BillingGetGithubActionsBillingUserEndpoint;
        request: BillingGetGithubActionsBillingUserRequestOptions;
        response: OctokitResponse<BillingGetGithubActionsBillingUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-github-packages-billing-for-a-user
     */
    "GET /users/:username/settings/billing/packages": {
        parameters: BillingGetGithubPackagesBillingUserEndpoint;
        request: BillingGetGithubPackagesBillingUserRequestOptions;
        response: OctokitResponse<BillingGetGithubPackagesBillingUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/billing/#get-shared-storage-billing-for-a-user
     */
    "GET /users/:username/settings/billing/shared-storage": {
        parameters: BillingGetSharedStorageBillingUserEndpoint;
        request: BillingGetSharedStorageBillingUserRequestOptions;
        response: OctokitResponse<BillingGetSharedStorageBillingUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-a-user
     */
    "GET /users/:username/starred": {
        parameters: ActivityListReposStarredByUserEndpoint;
        request: ActivityListReposStarredByUserRequestOptions;
        response: OctokitResponse<ActivityListReposStarredByUserResponseData | ActivityListReposStarredByUserResponse200Data>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-a-user
     */
    "GET /users/:username/subscriptions": {
        parameters: ActivityListReposWatchedByUserEndpoint;
        request: ActivityListReposWatchedByUserRequestOptions;
        response: OctokitResponse<ActivityListReposWatchedByUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#reset-a-token
     */
    "PATCH /applications/:client_id/token": {
        parameters: AppsResetTokenEndpoint;
        request: AppsResetTokenRequestOptions;
        response: OctokitResponse<AppsResetTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#update-an-existing-authorization
     */
    "PATCH /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsUpdateAuthorizationEndpoint;
        request: OauthAuthorizationsUpdateAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsUpdateAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#update-a-self-hosted-runner-group-for-an-enterprise
     */
    "PATCH /enterprises/:enterprise/actions/runner-groups/:runner_group_id": {
        parameters: EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseEndpoint;
        request: EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#update-a-gist
     */
    "PATCH /gists/:gist_id": {
        parameters: GistsUpdateEndpoint;
        request: GistsUpdateRequestOptions;
        response: OctokitResponse<GistsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#update-a-gist-comment
     */
    "PATCH /gists/:gist_id/comments/:comment_id": {
        parameters: GistsUpdateCommentEndpoint;
        request: GistsUpdateCommentRequestOptions;
        response: OctokitResponse<GistsUpdateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-a-thread-as-read
     */
    "PATCH /notifications/threads/:thread_id": {
        parameters: ActivityMarkThreadAsReadEndpoint;
        request: ActivityMarkThreadAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#update-an-organization
     */
    "PATCH /orgs/:org": {
        parameters: OrgsUpdateEndpoint;
        request: OrgsUpdateRequestOptions;
        response: OctokitResponse<OrgsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#update-a-self-hosted-runner-group-for-an-organization
     */
    "PATCH /orgs/:org/actions/runner-groups/:runner_group_id": {
        parameters: ActionsUpdateSelfHostedRunnerGroupForOrgEndpoint;
        request: ActionsUpdateSelfHostedRunnerGroupForOrgRequestOptions;
        response: OctokitResponse<ActionsUpdateSelfHostedRunnerGroupForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#update-an-organization-webhook
     */
    "PATCH /orgs/:org/hooks/:hook_id": {
        parameters: OrgsUpdateWebhookEndpoint;
        request: OrgsUpdateWebhookRequestOptions;
        response: OctokitResponse<OrgsUpdateWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#update-a-team
     */
    "PATCH /orgs/:org/teams/:team_slug": {
        parameters: TeamsUpdateInOrgEndpoint;
        request: TeamsUpdateInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#update-a-discussion
     */
    "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsUpdateDiscussionInOrgEndpoint;
        request: TeamsUpdateDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#update-a-discussion-comment
     */
    "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsUpdateDiscussionCommentInOrgEndpoint;
        request: TeamsUpdateDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections
     */
    "PATCH /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
        parameters: TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint;
        request: TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#update-a-project
     */
    "PATCH /projects/:project_id": {
        parameters: ProjectsUpdateEndpoint;
        request: ProjectsUpdateRequestOptions;
        response: OctokitResponse<ProjectsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#update-a-project-column
     */
    "PATCH /projects/columns/:column_id": {
        parameters: ProjectsUpdateColumnEndpoint;
        request: ProjectsUpdateColumnRequestOptions;
        response: OctokitResponse<ProjectsUpdateColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#update-a-project-card
     */
    "PATCH /projects/columns/cards/:card_id": {
        parameters: ProjectsUpdateCardEndpoint;
        request: ProjectsUpdateCardRequestOptions;
        response: OctokitResponse<ProjectsUpdateCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#update-a-repository
     */
    "PATCH /repos/:owner/:repo": {
        parameters: ReposUpdateEndpoint;
        request: ReposUpdateRequestOptions;
        response: OctokitResponse<ReposUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-pull-request-review-protection
     */
    "PATCH /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposUpdatePullRequestReviewProtectionEndpoint;
        request: ReposUpdatePullRequestReviewProtectionRequestOptions;
        response: OctokitResponse<ReposUpdatePullRequestReviewProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-status-check-potection
     */
    "PATCH /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposUpdateStatusCheckPotectionEndpoint;
        request: ReposUpdateStatusCheckPotectionRequestOptions;
        response: OctokitResponse<ReposUpdateStatusCheckPotectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#update-a-check-run
     */
    "PATCH /repos/:owner/:repo/check-runs/:check_run_id": {
        parameters: ChecksUpdateEndpoint;
        request: ChecksUpdateRequestOptions;
        response: OctokitResponse<ChecksUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#update-repository-preferences-for-check-suites
     */
    "PATCH /repos/:owner/:repo/check-suites/preferences": {
        parameters: ChecksSetSuitesPreferencesEndpoint;
        request: ChecksSetSuitesPreferencesRequestOptions;
        response: OctokitResponse<ChecksSetSuitesPreferencesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#upload-a-code-scanning-alert
     */
    "PATCH /repos/:owner/:repo/code-scanning/alerts/:alert_number": {
        parameters: CodeScanningUpdateAlertEndpoint;
        request: CodeScanningUpdateAlertRequestOptions;
        response: OctokitResponse<CodeScanningUpdateAlertResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#update-a-commit-comment
     */
    "PATCH /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposUpdateCommitCommentEndpoint;
        request: ReposUpdateCommitCommentRequestOptions;
        response: OctokitResponse<ReposUpdateCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#update-a-reference
     */
    "PATCH /repos/:owner/:repo/git/refs/:ref": {
        parameters: GitUpdateRefEndpoint;
        request: GitUpdateRefRequestOptions;
        response: OctokitResponse<GitUpdateRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#update-a-repository-webhook
     */
    "PATCH /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposUpdateWebhookEndpoint;
        request: ReposUpdateWebhookRequestOptions;
        response: OctokitResponse<ReposUpdateWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#update-an-import
     */
    "PATCH /repos/:owner/:repo/import": {
        parameters: MigrationsUpdateImportEndpoint;
        request: MigrationsUpdateImportRequestOptions;
        response: OctokitResponse<MigrationsUpdateImportResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#map-a-commit-author
     */
    "PATCH /repos/:owner/:repo/import/authors/:author_id": {
        parameters: MigrationsMapCommitAuthorEndpoint;
        request: MigrationsMapCommitAuthorRequestOptions;
        response: OctokitResponse<MigrationsMapCommitAuthorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#update-git-lfs-preference
     */
    "PATCH /repos/:owner/:repo/import/lfs": {
        parameters: MigrationsSetLfsPreferenceEndpoint;
        request: MigrationsSetLfsPreferenceRequestOptions;
        response: OctokitResponse<MigrationsSetLfsPreferenceResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#update-a-repository-invitation
     */
    "PATCH /repos/:owner/:repo/invitations/:invitation_id": {
        parameters: ReposUpdateInvitationEndpoint;
        request: ReposUpdateInvitationRequestOptions;
        response: OctokitResponse<ReposUpdateInvitationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#update-an-issue
     */
    "PATCH /repos/:owner/:repo/issues/:issue_number": {
        parameters: IssuesUpdateEndpoint;
        request: IssuesUpdateRequestOptions;
        response: OctokitResponse<IssuesUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#update-an-issue-comment
     */
    "PATCH /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesUpdateCommentEndpoint;
        request: IssuesUpdateCommentRequestOptions;
        response: OctokitResponse<IssuesUpdateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#update-a-label
     */
    "PATCH /repos/:owner/:repo/labels/:name": {
        parameters: IssuesUpdateLabelEndpoint;
        request: IssuesUpdateLabelRequestOptions;
        response: OctokitResponse<IssuesUpdateLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#update-a-milestone
     */
    "PATCH /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesUpdateMilestoneEndpoint;
        request: IssuesUpdateMilestoneRequestOptions;
        response: OctokitResponse<IssuesUpdateMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#update-a-pull-request
     */
    "PATCH /repos/:owner/:repo/pulls/:pull_number": {
        parameters: PullsUpdateEndpoint;
        request: PullsUpdateRequestOptions;
        response: OctokitResponse<PullsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#update-a-review-comment-for-a-pull-request
     */
    "PATCH /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsUpdateReviewCommentEndpoint;
        request: PullsUpdateReviewCommentRequestOptions;
        response: OctokitResponse<PullsUpdateReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#update-a-release
     */
    "PATCH /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposUpdateReleaseEndpoint;
        request: ReposUpdateReleaseRequestOptions;
        response: OctokitResponse<ReposUpdateReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#update-a-release-asset
     */
    "PATCH /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposUpdateReleaseAssetEndpoint;
        request: ReposUpdateReleaseAssetRequestOptions;
        response: OctokitResponse<ReposUpdateReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#update-an-attribute-for-a-scim-enterprise-group
     */
    "PATCH /scim/v2/enterprises/:enterprise/Groups/:scim_group_id": {
        parameters: EnterpriseAdminUpdateAttributeForEnterpriseGroupEndpoint;
        request: EnterpriseAdminUpdateAttributeForEnterpriseGroupRequestOptions;
        response: OctokitResponse<EnterpriseAdminUpdateAttributeForEnterpriseGroupResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#update-an-attribute-for-a-scim-enterprise-user
     */
    "PATCH /scim/v2/enterprises/:enterprise/Users/:scim_user_id": {
        parameters: EnterpriseAdminUpdateAttributeForEnterpriseUserEndpoint;
        request: EnterpriseAdminUpdateAttributeForEnterpriseUserRequestOptions;
        response: OctokitResponse<EnterpriseAdminUpdateAttributeForEnterpriseUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#update-an-attribute-for-a-scim-user
     */
    "PATCH /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimUpdateAttributeForUserEndpoint;
        request: ScimUpdateAttributeForUserRequestOptions;
        response: OctokitResponse<ScimUpdateAttributeForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#update-a-team-legacy
     */
    "PATCH /teams/:team_id": {
        parameters: TeamsUpdateLegacyEndpoint;
        request: TeamsUpdateLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#update-a-discussion-legacy
     */
    "PATCH /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsUpdateDiscussionLegacyEndpoint;
        request: TeamsUpdateDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#update-a-discussion-comment-legacy
     */
    "PATCH /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsUpdateDiscussionCommentLegacyEndpoint;
        request: TeamsUpdateDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections-legacy
     */
    "PATCH /teams/:team_id/team-sync/group-mappings": {
        parameters: TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint;
        request: TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#update-the-authenticated-user
     */
    "PATCH /user": {
        parameters: UsersUpdateAuthenticatedEndpoint;
        request: UsersUpdateAuthenticatedRequestOptions;
        response: OctokitResponse<UsersUpdateAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#set-primary-email-visibility-for-the-authenticated-user
     */
    "PATCH /user/email/visibility": {
        parameters: UsersSetPrimaryEmailVisibilityForAuthenticatedEndpoint;
        request: UsersSetPrimaryEmailVisibilityForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersSetPrimaryEmailVisibilityForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#update-an-organization-membership-for-the-authenticated-user
     */
    "PATCH /user/memberships/orgs/:org": {
        parameters: OrgsUpdateMembershipForAuthenticatedUserEndpoint;
        request: OrgsUpdateMembershipForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsUpdateMembershipForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#accept-a-repository-invitation
     */
    "PATCH /user/repository_invitations/:invitation_id": {
        parameters: ReposAcceptInvitationEndpoint;
        request: ReposAcceptInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#create-a-github-app-from-a-manifest
     */
    "POST /app-manifests/:code/conversions": {
        parameters: AppsCreateFromManifestEndpoint;
        request: AppsCreateFromManifestRequestOptions;
        response: OctokitResponse<AppsCreateFromManifestResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#create-an-installation-access-token-for-an-app
     */
    "POST /app/installations/:installation_id/access_tokens": {
        parameters: AppsCreateInstallationAccessTokenEndpoint;
        request: AppsCreateInstallationAccessTokenRequestOptions;
        response: OctokitResponse<AppsCreateInstallationAccessTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#check-a-token
     */
    "POST /applications/:client_id/token": {
        parameters: AppsCheckTokenEndpoint;
        request: AppsCheckTokenRequestOptions;
        response: OctokitResponse<AppsCheckTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#reset-an-authorization
     */
    "POST /applications/:client_id/tokens/:access_token": {
        parameters: AppsResetAuthorizationEndpoint;
        request: AppsResetAuthorizationRequestOptions;
        response: OctokitResponse<AppsResetAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization
     */
    "POST /authorizations": {
        parameters: OauthAuthorizationsCreateAuthorizationEndpoint;
        request: OauthAuthorizationsCreateAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsCreateAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#create-a-content-attachment
     */
    "POST /content_references/:content_reference_id/attachments": {
        parameters: AppsCreateContentAttachmentEndpoint;
        request: AppsCreateContentAttachmentRequestOptions;
        response: OctokitResponse<AppsCreateContentAttachmentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#create-self-hosted-runner-group-for-an-enterprise
     */
    "POST /enterprises/:enterprise/actions/runner-groups": {
        parameters: EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseEndpoint;
        request: EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#create-a-registration-token-for-an-enterprise
     */
    "POST /enterprises/:enterprise/actions/runners/registration-token": {
        parameters: EnterpriseAdminCreateRegistrationTokenForEnterpriseEndpoint;
        request: EnterpriseAdminCreateRegistrationTokenForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminCreateRegistrationTokenForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#create-a-remove-token-for-an-enterprise
     */
    "POST /enterprises/:enterprise/actions/runners/remove-token": {
        parameters: EnterpriseAdminCreateRemoveTokenForEnterpriseEndpoint;
        request: EnterpriseAdminCreateRemoveTokenForEnterpriseRequestOptions;
        response: OctokitResponse<EnterpriseAdminCreateRemoveTokenForEnterpriseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#create-a-gist
     */
    "POST /gists": {
        parameters: GistsCreateEndpoint;
        request: GistsCreateRequestOptions;
        response: OctokitResponse<GistsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#create-a-gist-comment
     */
    "POST /gists/:gist_id/comments": {
        parameters: GistsCreateCommentEndpoint;
        request: GistsCreateCommentRequestOptions;
        response: OctokitResponse<GistsCreateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#fork-a-gist
     */
    "POST /gists/:gist_id/forks": {
        parameters: GistsForkEndpoint;
        request: GistsForkRequestOptions;
        response: OctokitResponse<GistsForkResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/markdown/#render-a-markdown-document
     */
    "POST /markdown": {
        parameters: MarkdownRenderEndpoint;
        request: MarkdownRenderRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/markdown/#render-a-markdown-document-in-raw-mode
     */
    "POST /markdown/raw": {
        parameters: MarkdownRenderRawEndpoint;
        request: MarkdownRenderRawRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#create-a-self-hosted-runner-group-for-an-organization
     */
    "POST /orgs/:org/actions/runner-groups": {
        parameters: ActionsCreateSelfHostedRunnerGroupForOrgEndpoint;
        request: ActionsCreateSelfHostedRunnerGroupForOrgRequestOptions;
        response: OctokitResponse<ActionsCreateSelfHostedRunnerGroupForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-an-organization
     */
    "POST /orgs/:org/actions/runners/registration-token": {
        parameters: ActionsCreateRegistrationTokenForOrgEndpoint;
        request: ActionsCreateRegistrationTokenForOrgRequestOptions;
        response: OctokitResponse<ActionsCreateRegistrationTokenForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-an-organization
     */
    "POST /orgs/:org/actions/runners/remove-token": {
        parameters: ActionsCreateRemoveTokenForOrgEndpoint;
        request: ActionsCreateRemoveTokenForOrgRequestOptions;
        response: OctokitResponse<ActionsCreateRemoveTokenForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#create-an-organization-webhook
     */
    "POST /orgs/:org/hooks": {
        parameters: OrgsCreateWebhookEndpoint;
        request: OrgsCreateWebhookRequestOptions;
        response: OctokitResponse<OrgsCreateWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#ping-an-organization-webhook
     */
    "POST /orgs/:org/hooks/:hook_id/pings": {
        parameters: OrgsPingWebhookEndpoint;
        request: OrgsPingWebhookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#create-an-organization-invitation
     */
    "POST /orgs/:org/invitations": {
        parameters: OrgsCreateInvitationEndpoint;
        request: OrgsCreateInvitationRequestOptions;
        response: OctokitResponse<OrgsCreateInvitationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#start-an-organization-migration
     */
    "POST /orgs/:org/migrations": {
        parameters: MigrationsStartForOrgEndpoint;
        request: MigrationsStartForOrgRequestOptions;
        response: OctokitResponse<MigrationsStartForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-an-organization-project
     */
    "POST /orgs/:org/projects": {
        parameters: ProjectsCreateForOrgEndpoint;
        request: ProjectsCreateForOrgRequestOptions;
        response: OctokitResponse<ProjectsCreateForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-an-organization-repository
     */
    "POST /orgs/:org/repos": {
        parameters: ReposCreateInOrgEndpoint;
        request: ReposCreateInOrgRequestOptions;
        response: OctokitResponse<ReposCreateInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#create-a-team
     */
    "POST /orgs/:org/teams": {
        parameters: TeamsCreateEndpoint;
        request: TeamsCreateRequestOptions;
        response: OctokitResponse<TeamsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion
     */
    "POST /orgs/:org/teams/:team_slug/discussions": {
        parameters: TeamsCreateDiscussionInOrgEndpoint;
        request: TeamsCreateDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-discussion-comment
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
        parameters: TeamsCreateDiscussionCommentInOrgEndpoint;
        request: TeamsCreateDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionCommentInOrgEndpoint;
        request: ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionInOrgEndpoint;
        request: ReactionsCreateForTeamDiscussionInOrgRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#create-a-project-column
     */
    "POST /projects/:project_id/columns": {
        parameters: ProjectsCreateColumnEndpoint;
        request: ProjectsCreateColumnRequestOptions;
        response: OctokitResponse<ProjectsCreateColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#create-a-project-card
     */
    "POST /projects/columns/:column_id/cards": {
        parameters: ProjectsCreateCardEndpoint;
        request: ProjectsCreateCardRequestOptions;
        response: OctokitResponse<ProjectsCreateCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#move-a-project-column
     */
    "POST /projects/columns/:column_id/moves": {
        parameters: ProjectsMoveColumnEndpoint;
        request: ProjectsMoveColumnRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#move-a-project-card
     */
    "POST /projects/columns/cards/:card_id/moves": {
        parameters: ProjectsMoveCardEndpoint;
        request: ProjectsMoveCardRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-a-repository
     */
    "POST /repos/:owner/:repo/actions/runners/registration-token": {
        parameters: ActionsCreateRegistrationTokenForRepoEndpoint;
        request: ActionsCreateRegistrationTokenForRepoRequestOptions;
        response: OctokitResponse<ActionsCreateRegistrationTokenForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-a-repository
     */
    "POST /repos/:owner/:repo/actions/runners/remove-token": {
        parameters: ActionsCreateRemoveTokenForRepoEndpoint;
        request: ActionsCreateRemoveTokenForRepoRequestOptions;
        response: OctokitResponse<ActionsCreateRemoveTokenForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#cancel-a-workflow-run
     */
    "POST /repos/:owner/:repo/actions/runs/:run_id/cancel": {
        parameters: ActionsCancelWorkflowRunEndpoint;
        request: ActionsCancelWorkflowRunRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#re-run-a-workflow
     */
    "POST /repos/:owner/:repo/actions/runs/:run_id/rerun": {
        parameters: ActionsReRunWorkflowEndpoint;
        request: ActionsReRunWorkflowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#create-a-workflow-dispatch-event
     */
    "POST /repos/:owner/:repo/actions/workflows/:workflow_id/dispatches": {
        parameters: ActionsCreateWorkflowDispatchEndpoint;
        request: ActionsCreateWorkflowDispatchRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#set-admin-branch-protection
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposSetAdminBranchProtectionEndpoint;
        request: ReposSetAdminBranchProtectionRequestOptions;
        response: OctokitResponse<ReposSetAdminBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#create-commit-signature-protection
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposCreateCommitSignatureProtectionEndpoint;
        request: ReposCreateCommitSignatureProtectionRequestOptions;
        response: OctokitResponse<ReposCreateCommitSignatureProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-status-check-contexts
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposAddStatusCheckContextsEndpoint;
        request: ReposAddStatusCheckContextsRequestOptions;
        response: OctokitResponse<ReposAddStatusCheckContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-app-access-restrictions
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposAddAppAccessRestrictionsEndpoint;
        request: ReposAddAppAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddAppAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-team-access-restrictions
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposAddTeamAccessRestrictionsEndpoint;
        request: ReposAddTeamAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddTeamAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-user-access-restrictions
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposAddUserAccessRestrictionsEndpoint;
        request: ReposAddUserAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddUserAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#create-a-check-run
     */
    "POST /repos/:owner/:repo/check-runs": {
        parameters: ChecksCreateEndpoint;
        request: ChecksCreateRequestOptions;
        response: OctokitResponse<ChecksCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#create-a-check-suite
     */
    "POST /repos/:owner/:repo/check-suites": {
        parameters: ChecksCreateSuiteEndpoint;
        request: ChecksCreateSuiteRequestOptions;
        response: OctokitResponse<ChecksCreateSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#rerequest-a-check-suite
     */
    "POST /repos/:owner/:repo/check-suites/:check_suite_id/rerequest": {
        parameters: ChecksRerequestSuiteEndpoint;
        request: ChecksRerequestSuiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#upload-a-sarif-analysis
     */
    "POST /repos/:owner/:repo/code-scanning/sarifs": {
        parameters: CodeScanningUploadSarifEndpoint;
        request: CodeScanningUploadSarifRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-commit-comment
     */
    "POST /repos/:owner/:repo/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForCommitCommentEndpoint;
        request: ReactionsCreateForCommitCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#create-a-commit-comment
     */
    "POST /repos/:owner/:repo/commits/:commit_sha/comments": {
        parameters: ReposCreateCommitCommentEndpoint;
        request: ReposCreateCommitCommentRequestOptions;
        response: OctokitResponse<ReposCreateCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment
     */
    "POST /repos/:owner/:repo/deployments": {
        parameters: ReposCreateDeploymentEndpoint;
        request: ReposCreateDeploymentRequestOptions;
        response: OctokitResponse<ReposCreateDeploymentResponseData | ReposCreateDeploymentResponse202Data | ReposCreateDeploymentResponse409Data>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment-status
     */
    "POST /repos/:owner/:repo/deployments/:deployment_id/statuses": {
        parameters: ReposCreateDeploymentStatusEndpoint;
        request: ReposCreateDeploymentStatusRequestOptions;
        response: OctokitResponse<ReposCreateDeploymentStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-dispatch-event
     */
    "POST /repos/:owner/:repo/dispatches": {
        parameters: ReposCreateDispatchEventEndpoint;
        request: ReposCreateDispatchEventRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/forks/#create-a-fork
     */
    "POST /repos/:owner/:repo/forks": {
        parameters: ReposCreateForkEndpoint;
        request: ReposCreateForkRequestOptions;
        response: OctokitResponse<ReposCreateForkResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/blobs/#create-a-blob
     */
    "POST /repos/:owner/:repo/git/blobs": {
        parameters: GitCreateBlobEndpoint;
        request: GitCreateBlobRequestOptions;
        response: OctokitResponse<GitCreateBlobResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/commits/#create-a-commit
     */
    "POST /repos/:owner/:repo/git/commits": {
        parameters: GitCreateCommitEndpoint;
        request: GitCreateCommitRequestOptions;
        response: OctokitResponse<GitCreateCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#create-a-reference
     */
    "POST /repos/:owner/:repo/git/refs": {
        parameters: GitCreateRefEndpoint;
        request: GitCreateRefRequestOptions;
        response: OctokitResponse<GitCreateRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/tags/#create-a-tag-object
     */
    "POST /repos/:owner/:repo/git/tags": {
        parameters: GitCreateTagEndpoint;
        request: GitCreateTagRequestOptions;
        response: OctokitResponse<GitCreateTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/trees/#create-a-tree
     */
    "POST /repos/:owner/:repo/git/trees": {
        parameters: GitCreateTreeEndpoint;
        request: GitCreateTreeRequestOptions;
        response: OctokitResponse<GitCreateTreeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#create-a-repository-webhook
     */
    "POST /repos/:owner/:repo/hooks": {
        parameters: ReposCreateWebhookEndpoint;
        request: ReposCreateWebhookRequestOptions;
        response: OctokitResponse<ReposCreateWebhookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#ping-a-repository-webhook
     */
    "POST /repos/:owner/:repo/hooks/:hook_id/pings": {
        parameters: ReposPingWebhookEndpoint;
        request: ReposPingWebhookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#test-the-push-repository-webhook
     */
    "POST /repos/:owner/:repo/hooks/:hook_id/tests": {
        parameters: ReposTestPushWebhookEndpoint;
        request: ReposTestPushWebhookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#create-an-issue
     */
    "POST /repos/:owner/:repo/issues": {
        parameters: IssuesCreateEndpoint;
        request: IssuesCreateRequestOptions;
        response: OctokitResponse<IssuesCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#add-assignees-to-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/assignees": {
        parameters: IssuesAddAssigneesEndpoint;
        request: IssuesAddAssigneesRequestOptions;
        response: OctokitResponse<IssuesAddAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#create-an-issue-comment
     */
    "POST /repos/:owner/:repo/issues/:issue_number/comments": {
        parameters: IssuesCreateCommentEndpoint;
        request: IssuesCreateCommentRequestOptions;
        response: OctokitResponse<IssuesCreateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#add-labels-to-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesAddLabelsEndpoint;
        request: IssuesAddLabelsRequestOptions;
        response: OctokitResponse<IssuesAddLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/reactions": {
        parameters: ReactionsCreateForIssueEndpoint;
        request: ReactionsCreateForIssueRequestOptions;
        response: OctokitResponse<ReactionsCreateForIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue-comment
     */
    "POST /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForIssueCommentEndpoint;
        request: ReactionsCreateForIssueCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForIssueCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#create-a-deploy-key
     */
    "POST /repos/:owner/:repo/keys": {
        parameters: ReposCreateDeployKeyEndpoint;
        request: ReposCreateDeployKeyRequestOptions;
        response: OctokitResponse<ReposCreateDeployKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#create-a-label
     */
    "POST /repos/:owner/:repo/labels": {
        parameters: IssuesCreateLabelEndpoint;
        request: IssuesCreateLabelRequestOptions;
        response: OctokitResponse<IssuesCreateLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/merging/#merge-a-branch
     */
    "POST /repos/:owner/:repo/merges": {
        parameters: ReposMergeEndpoint;
        request: ReposMergeRequestOptions;
        response: OctokitResponse<ReposMergeResponseData | ReposMergeResponse404Data | ReposMergeResponse409Data>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#create-a-milestone
     */
    "POST /repos/:owner/:repo/milestones": {
        parameters: IssuesCreateMilestoneEndpoint;
        request: IssuesCreateMilestoneRequestOptions;
        response: OctokitResponse<IssuesCreateMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#create-a-github-pages-site
     */
    "POST /repos/:owner/:repo/pages": {
        parameters: ReposCreatePagesSiteEndpoint;
        request: ReposCreatePagesSiteRequestOptions;
        response: OctokitResponse<ReposCreatePagesSiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#request-a-github-pages-build
     */
    "POST /repos/:owner/:repo/pages/builds": {
        parameters: ReposRequestPagesBuildEndpoint;
        request: ReposRequestPagesBuildRequestOptions;
        response: OctokitResponse<ReposRequestPagesBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-a-repository-project
     */
    "POST /repos/:owner/:repo/projects": {
        parameters: ProjectsCreateForRepoEndpoint;
        request: ProjectsCreateForRepoRequestOptions;
        response: OctokitResponse<ProjectsCreateForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#create-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls": {
        parameters: PullsCreateEndpoint;
        request: PullsCreateRequestOptions;
        response: OctokitResponse<PullsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#create-a-review-comment-for-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/comments": {
        parameters: PullsCreateReviewCommentEndpoint;
        request: PullsCreateReviewCommentRequestOptions;
        response: OctokitResponse<PullsCreateReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#create-a-reply-for-a-review-comment
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies": {
        parameters: PullsCreateReplyForReviewCommentEndpoint;
        request: PullsCreateReplyForReviewCommentRequestOptions;
        response: OctokitResponse<PullsCreateReplyForReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#request-reviewers-for-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsRequestReviewersEndpoint;
        request: PullsRequestReviewersRequestOptions;
        response: OctokitResponse<PullsRequestReviewersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#create-a-review-for-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/reviews": {
        parameters: PullsCreateReviewEndpoint;
        request: PullsCreateReviewRequestOptions;
        response: OctokitResponse<PullsCreateReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#submit-a-review-for-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events": {
        parameters: PullsSubmitReviewEndpoint;
        request: PullsSubmitReviewRequestOptions;
        response: OctokitResponse<PullsSubmitReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-pull-request-review-comment
     */
    "POST /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForPullRequestReviewCommentEndpoint;
        request: ReactionsCreateForPullRequestReviewCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForPullRequestReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#create-a-release
     */
    "POST /repos/:owner/:repo/releases": {
        parameters: ReposCreateReleaseEndpoint;
        request: ReposCreateReleaseRequestOptions;
        response: OctokitResponse<ReposCreateReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#upload-a-release-asset
     */
    "POST /repos/:owner/:repo/releases/:release_id/assets{?name,label}": {
        parameters: ReposUploadReleaseAssetEndpoint;
        request: ReposUploadReleaseAssetRequestOptions;
        response: OctokitResponse<ReposUploadReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#create-a-commit-status
     */
    "POST /repos/:owner/:repo/statuses/:sha": {
        parameters: ReposCreateCommitStatusEndpoint;
        request: ReposCreateCommitStatusRequestOptions;
        response: OctokitResponse<ReposCreateCommitStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#transfer-a-repository
     */
    "POST /repos/:owner/:repo/transfer": {
        parameters: ReposTransferEndpoint;
        request: ReposTransferRequestOptions;
        response: OctokitResponse<ReposTransferResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-using-a-template
     */
    "POST /repos/:template_owner/:template_repo/generate": {
        parameters: ReposCreateUsingTemplateEndpoint;
        request: ReposCreateUsingTemplateRequestOptions;
        response: OctokitResponse<ReposCreateUsingTemplateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#provision-a-scim-enterprise-group-and-invite-users
     */
    "POST /scim/v2/enterprises/:enterprise/Groups": {
        parameters: EnterpriseAdminProvisionAndInviteEnterpriseGroupEndpoint;
        request: EnterpriseAdminProvisionAndInviteEnterpriseGroupRequestOptions;
        response: OctokitResponse<EnterpriseAdminProvisionAndInviteEnterpriseGroupResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#provision-and-invite-a-scim-enterprise-user
     */
    "POST /scim/v2/enterprises/:enterprise/Users": {
        parameters: EnterpriseAdminProvisionAndInviteEnterpriseUserEndpoint;
        request: EnterpriseAdminProvisionAndInviteEnterpriseUserRequestOptions;
        response: OctokitResponse<EnterpriseAdminProvisionAndInviteEnterpriseUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#provision-and-invite-a-scim-user
     */
    "POST /scim/v2/organizations/:org/Users": {
        parameters: ScimProvisionAndInviteUserEndpoint;
        request: ScimProvisionAndInviteUserRequestOptions;
        response: OctokitResponse<ScimProvisionAndInviteUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion-legacy
     */
    "POST /teams/:team_id/discussions": {
        parameters: TeamsCreateDiscussionLegacyEndpoint;
        request: TeamsCreateDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-discussion-comment-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/comments": {
        parameters: TeamsCreateDiscussionCommentLegacyEndpoint;
        request: TeamsCreateDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionCommentLegacyEndpoint;
        request: ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionLegacyEndpoint;
        request: ReactionsCreateForTeamDiscussionLegacyRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#add-an-email-address-for-the-authenticated-user
     */
    "POST /user/emails": {
        parameters: UsersAddEmailForAuthenticatedEndpoint;
        request: UsersAddEmailForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersAddEmailForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#create-a-gpg-key-for-the-authenticated-user
     */
    "POST /user/gpg_keys": {
        parameters: UsersCreateGpgKeyForAuthenticatedEndpoint;
        request: UsersCreateGpgKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersCreateGpgKeyForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#create-a-public-ssh-key-for-the-authenticated-user
     */
    "POST /user/keys": {
        parameters: UsersCreatePublicSshKeyForAuthenticatedEndpoint;
        request: UsersCreatePublicSshKeyForAuthenticatedRequestOptions;
        response: OctokitResponse<UsersCreatePublicSshKeyForAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#start-a-user-migration
     */
    "POST /user/migrations": {
        parameters: MigrationsStartForAuthenticatedUserEndpoint;
        request: MigrationsStartForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsStartForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-a-user-project
     */
    "POST /user/projects": {
        parameters: ProjectsCreateForAuthenticatedUserEndpoint;
        request: ProjectsCreateForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ProjectsCreateForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-for-the-authenticated-user
     */
    "POST /user/repos": {
        parameters: ReposCreateForAuthenticatedUserEndpoint;
        request: ReposCreateForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ReposCreateForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#suspend-an-app-installation
     */
    "PUT /app/installations/:installation_id/suspended": {
        parameters: AppsSuspendInstallationEndpoint;
        request: AppsSuspendInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app
     */
    "PUT /authorizations/clients/:client_id": {
        parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint;
        request: OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData | OauthAuthorizationsGetOrCreateAuthorizationForAppResponse201Data>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint
     */
    "PUT /authorizations/clients/:client_id/:fingerprint": {
        parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint;
        request: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData | OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponse201Data>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#set-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
     */
    "PUT /enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations": {
        parameters: EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint;
        request: EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
     */
    "PUT /enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations/:org_id": {
        parameters: EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint;
        request: EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#set-self-hosted-runners-in-a-group-for-an-enterprise
     */
    "PUT /enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners": {
        parameters: EnterpriseAdminSetSelfHostedInGroupForEnterpriseEndpoint;
        request: EnterpriseAdminSetSelfHostedInGroupForEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/actions/#add-a-self-hosted-runner-to-a-group-for-an-enterprise
     */
    "PUT /enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners/:runner_id": {
        parameters: EnterpriseAdminAddSelfHostedRunnerToRunnerGroupForEnterpriseEndpoint;
        request: EnterpriseAdminAddSelfHostedRunnerToRunnerGroupForEnterpriseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#star-a-gist
     */
    "PUT /gists/:gist_id/star": {
        parameters: GistsStarEndpoint;
        request: GistsStarRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-notifications-as-read
     */
    "PUT /notifications": {
        parameters: ActivityMarkNotificationsAsReadEndpoint;
        request: ActivityMarkNotificationsAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#set-a-thread-subscription
     */
    "PUT /notifications/threads/:thread_id/subscription": {
        parameters: ActivitySetThreadSubscriptionEndpoint;
        request: ActivitySetThreadSubscriptionRequestOptions;
        response: OctokitResponse<ActivitySetThreadSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#set-repository-access-to-a-self-hosted-runner-group-in-an-organization
     */
    "PUT /orgs/:org/actions/runner-groups/:runner_group_id/repositories": {
        parameters: ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgEndpoint;
        request: ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#add-repository-acess-to-a-self-hosted-runner-group-in-an-organization
     */
    "PUT /orgs/:org/actions/runner-groups/:runner_group_id/repositories/:repository_id": {
        parameters: ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgEndpoint;
        request: ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/sef-hosted-runner-groups/#set-self-hosted-runners-in-a-group-for-an-organization
     */
    "PUT /orgs/:org/actions/runner-groups/:runner_group_id/runners": {
        parameters: ActionsSetSelfHostedRunnersInGroupForOrgEndpoint;
        request: ActionsSetSelfHostedRunnersInGroupForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runner-groups/#add-a-self-hosted-runner-to-a-group-for-an-organization
     */
    "PUT /orgs/:org/actions/runner-groups/:runner_group_id/runners/:runner_id": {
        parameters: ActionsAddSelfHostedRunnerToGroupForOrgEndpoint;
        request: ActionsAddSelfHostedRunnerToGroupForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#create-or-update-an-organization-secret
     */
    "PUT /orgs/:org/actions/secrets/:secret_name": {
        parameters: ActionsCreateOrUpdateOrgSecretEndpoint;
        request: ActionsCreateOrUpdateOrgSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#set-selected-repositories-for-an-organization-secret
     */
    "PUT /orgs/:org/actions/secrets/:secret_name/repositories": {
        parameters: ActionsSetSelectedReposForOrgSecretEndpoint;
        request: ActionsSetSelectedReposForOrgSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#add-selected-repository-to-an-organization-secret
     */
    "PUT /orgs/:org/actions/secrets/:secret_name/repositories/:repository_id": {
        parameters: ActionsAddSelectedRepoToOrgSecretEndpoint;
        request: ActionsAddSelectedRepoToOrgSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#block-a-user-from-an-organization
     */
    "PUT /orgs/:org/blocks/:username": {
        parameters: OrgsBlockUserEndpoint;
        request: OrgsBlockUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#set-interaction-restrictions-for-an-organization
     */
    "PUT /orgs/:org/interaction-limits": {
        parameters: InteractionsSetRestrictionsForOrgEndpoint;
        request: InteractionsSetRestrictionsForOrgRequestOptions;
        response: OctokitResponse<InteractionsSetRestrictionsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#set-organization-membership-for-a-user
     */
    "PUT /orgs/:org/memberships/:username": {
        parameters: OrgsSetMembershipForUserEndpoint;
        request: OrgsSetMembershipForUserRequestOptions;
        response: OctokitResponse<OrgsSetMembershipForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#convert-an-organization-member-to-outside-collaborator
     */
    "PUT /orgs/:org/outside_collaborators/:username": {
        parameters: OrgsConvertMemberToOutsideCollaboratorEndpoint;
        request: OrgsConvertMemberToOutsideCollaboratorRequestOptions;
        response: OctokitResponse<OrgsConvertMemberToOutsideCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#set-public-organization-membership-for-the-authenticated-user
     */
    "PUT /orgs/:org/public_members/:username": {
        parameters: OrgsSetPublicMembershipForAuthenticatedUserEndpoint;
        request: OrgsSetPublicMembershipForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership-for-a-user
     */
    "PUT /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsAddOrUpdateMembershipForUserInOrgEndpoint;
        request: TeamsAddOrUpdateMembershipForUserInOrgRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateMembershipForUserInOrgResponseData | TeamsAddOrUpdateMembershipForUserInOrgResponse422Data>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-project-permissions
     */
    "PUT /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsAddOrUpdateProjectPermissionsInOrgEndpoint;
        request: TeamsAddOrUpdateProjectPermissionsInOrgRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateProjectPermissionsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-repository-permissions
     */
    "PUT /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsAddOrUpdateRepoPermissionsInOrgEndpoint;
        request: TeamsAddOrUpdateRepoPermissionsInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#add-project-collaborator
     */
    "PUT /projects/:project_id/collaborators/:username": {
        parameters: ProjectsAddCollaboratorEndpoint;
        request: ProjectsAddCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#create-or-update-a-repository-secret
     */
    "PUT /repos/:owner/:repo/actions/secrets/:secret_name": {
        parameters: ActionsCreateOrUpdateRepoSecretEndpoint;
        request: ActionsCreateOrUpdateRepoSecretRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#enable-automated-security-fixes
     */
    "PUT /repos/:owner/:repo/automated-security-fixes": {
        parameters: ReposEnableAutomatedSecurityFixesEndpoint;
        request: ReposEnableAutomatedSecurityFixesRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-branch-protection
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposUpdateBranchProtectionEndpoint;
        request: ReposUpdateBranchProtectionRequestOptions;
        response: OctokitResponse<ReposUpdateBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#set-status-check-contexts
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposSetStatusCheckContextsEndpoint;
        request: ReposSetStatusCheckContextsRequestOptions;
        response: OctokitResponse<ReposSetStatusCheckContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#set-app-access-restrictions
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposSetAppAccessRestrictionsEndpoint;
        request: ReposSetAppAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposSetAppAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#set-team-access-restrictions
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposSetTeamAccessRestrictionsEndpoint;
        request: ReposSetTeamAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposSetTeamAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#set-user-access-restrictions
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposSetUserAccessRestrictionsEndpoint;
        request: ReposSetUserAccessRestrictionsRequestOptions;
        response: OctokitResponse<ReposSetUserAccessRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#add-a-repository-collaborator
     */
    "PUT /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposAddCollaboratorEndpoint;
        request: ReposAddCollaboratorRequestOptions;
        response: OctokitResponse<ReposAddCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#create-or-update-file-contents
     */
    "PUT /repos/:owner/:repo/contents/:path": {
        parameters: ReposCreateOrUpdateFileContentsEndpoint;
        request: ReposCreateOrUpdateFileContentsRequestOptions;
        response: OctokitResponse<ReposCreateOrUpdateFileContentsResponseData | ReposCreateOrUpdateFileContentsResponse201Data>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#start-an-import
     */
    "PUT /repos/:owner/:repo/import": {
        parameters: MigrationsStartImportEndpoint;
        request: MigrationsStartImportRequestOptions;
        response: OctokitResponse<MigrationsStartImportResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#set-interaction-restrictions-for-a-repository
     */
    "PUT /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsSetRestrictionsForRepoEndpoint;
        request: InteractionsSetRestrictionsForRepoRequestOptions;
        response: OctokitResponse<InteractionsSetRestrictionsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#set-labels-for-an-issue
     */
    "PUT /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesSetLabelsEndpoint;
        request: IssuesSetLabelsRequestOptions;
        response: OctokitResponse<IssuesSetLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#lock-an-issue
     */
    "PUT /repos/:owner/:repo/issues/:issue_number/lock": {
        parameters: IssuesLockEndpoint;
        request: IssuesLockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-repository-notifications-as-read
     */
    "PUT /repos/:owner/:repo/notifications": {
        parameters: ActivityMarkRepoNotificationsAsReadEndpoint;
        request: ActivityMarkRepoNotificationsAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#update-information-about-a-github-pages-site
     */
    "PUT /repos/:owner/:repo/pages": {
        parameters: ReposUpdateInformationAboutPagesSiteEndpoint;
        request: ReposUpdateInformationAboutPagesSiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#merge-a-pull-request
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/merge": {
        parameters: PullsMergeEndpoint;
        request: PullsMergeRequestOptions;
        response: OctokitResponse<PullsMergeResponseData | PullsMergeResponse405Data | PullsMergeResponse409Data>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#update-a-review-for-a-pull-request
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsUpdateReviewEndpoint;
        request: PullsUpdateReviewRequestOptions;
        response: OctokitResponse<PullsUpdateReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#dismiss-a-review-for-a-pull-request
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals": {
        parameters: PullsDismissReviewEndpoint;
        request: PullsDismissReviewRequestOptions;
        response: OctokitResponse<PullsDismissReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#update-a-pull-request-branch
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/update-branch": {
        parameters: PullsUpdateBranchEndpoint;
        request: PullsUpdateBranchRequestOptions;
        response: OctokitResponse<PullsUpdateBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#set-a-repository-subscription
     */
    "PUT /repos/:owner/:repo/subscription": {
        parameters: ActivitySetRepoSubscriptionEndpoint;
        request: ActivitySetRepoSubscriptionRequestOptions;
        response: OctokitResponse<ActivitySetRepoSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#replace-all-repository-topics
     */
    "PUT /repos/:owner/:repo/topics": {
        parameters: ReposReplaceAllTopicsEndpoint;
        request: ReposReplaceAllTopicsRequestOptions;
        response: OctokitResponse<ReposReplaceAllTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#enable-vulnerability-alerts
     */
    "PUT /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposEnableVulnerabilityAlertsEndpoint;
        request: ReposEnableVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#set-scim-information-for-a-provisioned-enterprise-group
     */
    "PUT /scim/v2/enterprises/:enterprise/Groups/:scim_group_id": {
        parameters: EnterpriseAdminSetInformationForProvisionedEnterpriseGroupEndpoint;
        request: EnterpriseAdminSetInformationForProvisionedEnterpriseGroupRequestOptions;
        response: OctokitResponse<EnterpriseAdminSetInformationForProvisionedEnterpriseGroupResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/enterprise-admin/scim/#set-scim-information-for-a-provisioned-enterprise-user
     */
    "PUT /scim/v2/enterprises/:enterprise/Users/:scim_user_id": {
        parameters: EnterpriseAdminSetInformationForProvisionedEnterpriseUserEndpoint;
        request: EnterpriseAdminSetInformationForProvisionedEnterpriseUserRequestOptions;
        response: OctokitResponse<EnterpriseAdminSetInformationForProvisionedEnterpriseUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#set-scim-information-for-a-provisioned-user
     */
    "PUT /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimSetInformationForProvisionedUserEndpoint;
        request: ScimSetInformationForProvisionedUserRequestOptions;
        response: OctokitResponse<ScimSetInformationForProvisionedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-team-member-legacy
     */
    "PUT /teams/:team_id/members/:username": {
        parameters: TeamsAddMemberLegacyEndpoint;
        request: TeamsAddMemberLegacyRequestOptions;
        response: OctokitResponse<TeamsAddMemberLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership-for-a-user-legacy
     */
    "PUT /teams/:team_id/memberships/:username": {
        parameters: TeamsAddOrUpdateMembershipForUserLegacyEndpoint;
        request: TeamsAddOrUpdateMembershipForUserLegacyRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateMembershipForUserLegacyResponseData | TeamsAddOrUpdateMembershipForUserLegacyResponse422Data>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-project-permissions-legacy
     */
    "PUT /teams/:team_id/projects/:project_id": {
        parameters: TeamsAddOrUpdateProjectPermissionsLegacyEndpoint;
        request: TeamsAddOrUpdateProjectPermissionsLegacyRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateProjectPermissionsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-repository-permissions-legacy
     */
    "PUT /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsAddOrUpdateRepoPermissionsLegacyEndpoint;
        request: TeamsAddOrUpdateRepoPermissionsLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#block-a-user
     */
    "PUT /user/blocks/:username": {
        parameters: UsersBlockEndpoint;
        request: UsersBlockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#follow-a-user
     */
    "PUT /user/following/:username": {
        parameters: UsersFollowEndpoint;
        request: UsersFollowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#add-a-repository-to-an-app-installation
     */
    "PUT /user/installations/:installation_id/repositories/:repository_id": {
        parameters: AppsAddRepoToInstallationEndpoint;
        request: AppsAddRepoToInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#star-a-repository-for-the-authenticated-user
     */
    "PUT /user/starred/:owner/:repo": {
        parameters: ActivityStarRepoForAuthenticatedUserEndpoint;
        request: ActivityStarRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
}
declare type ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    repository_id: number;
};
declare type ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsAddSelectedRepoToOrgSecretEndpoint = {
    org: string;
    secret_name: string;
    repository_id: number;
};
declare type ActionsAddSelectedRepoToOrgSecretRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/secrets/:secret_name/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsAddSelfHostedRunnerToGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsAddSelfHostedRunnerToGroupForOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCancelWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsCancelWorkflowRunRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runs/:run_id/cancel";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateOrUpdateOrgSecretEndpoint = {
    org: string;
    secret_name: string;
    /**
     * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://developer.github.com/v3/actions/secrets/#get-an-organization-public-key) endpoint.
     */
    encrypted_value?: string;
    /**
     * ID of the key you used to encrypt the secret.
     */
    key_id?: string;
    /**
     * Configures the access that repositories have to the organization secret. Can be one of:
     * \- `all` - All repositories in an organization can access the secret.
     * \- `private` - Private repositories in an organization can access the secret.
     * \- `selected` - Only specific repositories can access the secret.
     */
    visibility?: "all" | "private" | "selected";
    /**
     * An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://developer.github.com/v3/actions/secrets/#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://developer.github.com/v3/actions/secrets/#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://developer.github.com/v3/actions/secrets/#remove-selected-repository-from-an-organization-secret) endpoints.
     */
    selected_repository_ids?: number[];
};
declare type ActionsCreateOrUpdateOrgSecretRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateOrUpdateRepoSecretEndpoint = {
    owner: string;
    repo: string;
    secret_name: string;
    /**
     * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://developer.github.com/v3/actions/secrets/#get-a-repository-public-key) endpoint.
     */
    encrypted_value?: string;
    /**
     * ID of the key you used to encrypt the secret.
     */
    key_id?: string;
};
declare type ActionsCreateOrUpdateRepoSecretRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateRegistrationTokenForOrgEndpoint = {
    org: string;
};
declare type ActionsCreateRegistrationTokenForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/actions/runners/registration-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsCreateRegistrationTokenForOrgResponseData {
    token: string;
    expires_at: string;
}
declare type ActionsCreateRegistrationTokenForRepoEndpoint = {
    owner: string;
    repo: string;
};
declare type ActionsCreateRegistrationTokenForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runners/registration-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsCreateRegistrationTokenForRepoResponseData {
    token: string;
    expires_at: string;
}
declare type ActionsCreateRemoveTokenForOrgEndpoint = {
    org: string;
};
declare type ActionsCreateRemoveTokenForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/actions/runners/remove-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsCreateRemoveTokenForOrgResponseData {
    token: string;
    expires_at: string;
}
declare type ActionsCreateRemoveTokenForRepoEndpoint = {
    owner: string;
    repo: string;
};
declare type ActionsCreateRemoveTokenForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runners/remove-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsCreateRemoveTokenForRepoResponseData {
    token: string;
    expires_at: string;
}
declare type ActionsCreateSelfHostedRunnerGroupForOrgEndpoint = {
    org: string;
    /**
     * Name of the runner group.
     */
    name: string;
    /**
     * Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories. Can be one of: `all`, `selected`, or `private`.
     */
    visibility?: "selected" | "all" | "private";
    /**
     * List of repository IDs that can access the runner group.
     */
    selected_repository_ids?: number[];
    /**
     * List of runner IDs to add to the runner group.
     */
    runners?: number[];
};
declare type ActionsCreateSelfHostedRunnerGroupForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/actions/runner-groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsCreateSelfHostedRunnerGroupForOrgResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_repositories_url: string;
    runners_url: string;
    inherited: boolean;
}
declare type ActionsCreateWorkflowDispatchEndpoint = {
    owner: string;
    repo: string;
    workflow_id: number;
    /**
     * The reference of the workflow run. The reference can be a branch, tag, or a commit SHA.
     */
    ref: string;
    /**
     * Input keys and values configured in the workflow file. The maximum number of properties is 10.
     */
    inputs?: ActionsCreateWorkflowDispatchParamsInputs;
};
declare type ActionsCreateWorkflowDispatchRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id/dispatches";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteArtifactEndpoint = {
    owner: string;
    repo: string;
    artifact_id: number;
};
declare type ActionsDeleteArtifactRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteOrgSecretEndpoint = {
    org: string;
    secret_name: string;
};
declare type ActionsDeleteOrgSecretRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteRepoSecretEndpoint = {
    owner: string;
    repo: string;
    secret_name: string;
};
declare type ActionsDeleteRepoSecretRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteSelfHostedRunnerFromOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsDeleteSelfHostedRunnerFromOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteSelfHostedRunnerFromRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsDeleteSelfHostedRunnerFromRepoRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteSelfHostedRunnerGroupFromOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
};
declare type ActionsDeleteSelfHostedRunnerGroupFromOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsDeleteWorkflowRunRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/runs/:run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteWorkflowRunLogsEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsDeleteWorkflowRunLogsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDownloadArtifactEndpoint = {
    owner: string;
    repo: string;
    artifact_id: number;
    archive_format: string;
};
declare type ActionsDownloadArtifactRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDownloadJobLogsForWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    job_id: number;
};
declare type ActionsDownloadJobLogsForWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/jobs/:job_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDownloadWorkflowRunLogsEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsDownloadWorkflowRunLogsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetArtifactEndpoint = {
    owner: string;
    repo: string;
    artifact_id: number;
};
declare type ActionsGetArtifactRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetArtifactResponseData {
    id: number;
    node_id: string;
    name: string;
    size_in_bytes: number;
    url: string;
    archive_download_url: string;
    expired: boolean;
    created_at: string;
    expires_at: string;
}
declare type ActionsGetJobForWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    job_id: number;
};
declare type ActionsGetJobForWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/jobs/:job_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetJobForWorkflowRunResponseData {
    id: number;
    run_id: number;
    run_url: string;
    node_id: string;
    head_sha: string;
    url: string;
    html_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    name: string;
    steps: {
        name: string;
        status: string;
        conclusion: string;
        number: number;
        started_at: string;
        completed_at: string;
    }[];
    check_run_url: string;
}
declare type ActionsGetOrgPublicKeyEndpoint = {
    org: string;
};
declare type ActionsGetOrgPublicKeyRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/secrets/public-key";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetOrgPublicKeyResponseData {
    key_id: string;
    key: string;
}
declare type ActionsGetOrgSecretEndpoint = {
    org: string;
    secret_name: string;
};
declare type ActionsGetOrgSecretRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetOrgSecretResponseData {
    name: string;
    created_at: string;
    updated_at: string;
    visibility: string;
    selected_repositories_url: string;
}
declare type ActionsGetRepoPublicKeyEndpoint = {
    owner: string;
    repo: string;
};
declare type ActionsGetRepoPublicKeyRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets/public-key";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetRepoPublicKeyResponseData {
    key_id: string;
    key: string;
}
declare type ActionsGetRepoSecretEndpoint = {
    owner: string;
    repo: string;
    secret_name: string;
};
declare type ActionsGetRepoSecretRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets/:secret_name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetRepoSecretResponseData {
    name: string;
    created_at: string;
    updated_at: string;
}
declare type ActionsGetSelfHostedRunnerForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsGetSelfHostedRunnerForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetSelfHostedRunnerForOrgResponseData {
    id: number;
    name: string;
    os: string;
    status: string;
    busy: boolean;
    labels: {
        /**
         * Unique identifier of the label.
         */
        id: number;
        /**
         * Name of the label.
         */
        name: string;
        /**
         * The type of label. Read-only labels are applied automatically when the runner is configured.
         */
        type: "read-only" | "custom";
    }[];
}
declare type ActionsGetSelfHostedRunnerForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsGetSelfHostedRunnerForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetSelfHostedRunnerForRepoResponseData {
    id: number;
    name: string;
    os: string;
    status: string;
    busy: boolean;
    labels: {
        /**
         * Unique identifier of the label.
         */
        id: number;
        /**
         * Name of the label.
         */
        name: string;
        /**
         * The type of label. Read-only labels are applied automatically when the runner is configured.
         */
        type: "read-only" | "custom";
    }[];
}
declare type ActionsGetSelfHostedRunnerGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
};
declare type ActionsGetSelfHostedRunnerGroupForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetSelfHostedRunnerGroupForOrgResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_repositories_url: string;
    runners_url: string;
    inherited: boolean;
}
declare type ActionsGetWorkflowEndpoint = {
    owner: string;
    repo: string;
    workflow_id: number;
};
declare type ActionsGetWorkflowRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetWorkflowResponseData {
    id: number;
    node_id: string;
    name: string;
    path: string;
    state: string;
    created_at: string;
    updated_at: string;
    url: string;
    html_url: string;
    badge_url: string;
}
declare type ActionsGetWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsGetWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetWorkflowRunResponseData {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    run_number: number;
    event: string;
    status: string;
    conclusion: string;
    workflow_id: number;
    url: string;
    html_url: string;
    pull_requests: unknown[];
    created_at: string;
    updated_at: string;
    jobs_url: string;
    logs_url: string;
    check_suite_url: string;
    artifacts_url: string;
    cancel_url: string;
    rerun_url: string;
    workflow_url: string;
    head_commit: {
        id: string;
        tree_id: string;
        message: string;
        timestamp: string;
        author: {
            name: string;
            email: string;
        };
        committer: {
            name: string;
            email: string;
        };
    };
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    head_repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        private: boolean;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        forks_url: string;
        keys_url: string;
        collaborators_url: string;
        teams_url: string;
        hooks_url: string;
        issue_events_url: string;
        events_url: string;
        assignees_url: string;
        branches_url: string;
        tags_url: string;
        blobs_url: string;
        git_tags_url: string;
        git_refs_url: string;
        trees_url: string;
        statuses_url: string;
        languages_url: string;
        stargazers_url: string;
        contributors_url: string;
        subscribers_url: string;
        subscription_url: string;
        commits_url: string;
        git_commits_url: string;
        comments_url: string;
        issue_comment_url: string;
        contents_url: string;
        compare_url: string;
        merges_url: string;
        archive_url: string;
        downloads_url: string;
        issues_url: string;
        pulls_url: string;
        milestones_url: string;
        notifications_url: string;
        labels_url: string;
        releases_url: string;
        deployments_url: string;
    };
}
declare type ActionsGetWorkflowRunUsageEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsGetWorkflowRunUsageRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/timing";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetWorkflowRunUsageResponseData {
    billable: {
        UBUNTU: {
            total_ms: number;
            jobs: number;
        };
        MACOS: {
            total_ms: number;
            jobs: number;
        };
        WINDOWS: {
            total_ms: number;
            jobs: number;
        };
    };
    run_duration_ms: number;
}
declare type ActionsGetWorkflowUsageEndpoint = {
    owner: string;
    repo: string;
    workflow_id: number;
};
declare type ActionsGetWorkflowUsageRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id/timing";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsGetWorkflowUsageResponseData {
    billable: {
        UBUNTU: {
            total_ms: number;
        };
        MACOS: {
            total_ms: number;
        };
        WINDOWS: {
            total_ms: number;
        };
    };
}
declare type ActionsListArtifactsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListArtifactsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListArtifactsForRepoResponseData {
    total_count: number;
    artifacts: {
        id: number;
        node_id: string;
        name: string;
        size_in_bytes: number;
        url: string;
        archive_download_url: string;
        expired: boolean;
        created_at: string;
        expires_at: string;
    }[];
}
declare type ActionsListJobsForWorkflowRunEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
    /**
     * Filters jobs by their `completed_at` timestamp. Can be one of:
     * \* `latest`: Returns jobs from the most recent execution of the workflow run.
     * \* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListJobsForWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/jobs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListJobsForWorkflowRunResponseData {
    total_count: number;
    jobs: {
        id: number;
        run_id: number;
        run_url: string;
        node_id: string;
        head_sha: string;
        url: string;
        html_url: string;
        status: string;
        conclusion: string;
        started_at: string;
        completed_at: string;
        name: string;
        steps: {
            name: string;
            status: string;
            conclusion: string;
            number: number;
            started_at: string;
            completed_at: string;
        }[];
        check_run_url: string;
    }[];
}
declare type ActionsListOrgSecretsEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListOrgSecretsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/secrets";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListOrgSecretsResponseData {
    total_count: number;
    secrets: {
        name: string;
        created_at: string;
        updated_at: string;
        visibility: string;
        selected_repositories_url: string;
    }[];
}
declare type ActionsListRepoAccessToSelfHostedRunnerGroupInOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
};
declare type ActionsListRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListRepoAccessToSelfHostedRunnerGroupInOrgResponseData {
    total_count: number;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
}
declare type ActionsListRepoSecretsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListRepoSecretsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListRepoSecretsResponseData {
    total_count: number;
    secrets: {
        name: string;
        created_at: string;
        updated_at: string;
    }[];
}
declare type ActionsListRepoWorkflowsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListRepoWorkflowsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListRepoWorkflowsResponseData {
    total_count: number;
    workflows: {
        id: number;
        node_id: string;
        name: string;
        path: string;
        state: string;
        created_at: string;
        updated_at: string;
        url: string;
        html_url: string;
        badge_url: string;
    }[];
}
declare type ActionsListRunnerApplicationsForOrgEndpoint = {
    org: string;
};
declare type ActionsListRunnerApplicationsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActionsListRunnerApplicationsForOrgResponseData = {
    os: string;
    architecture: string;
    download_url: string;
    filename: string;
}[];
declare type ActionsListRunnerApplicationsForRepoEndpoint = {
    owner: string;
    repo: string;
};
declare type ActionsListRunnerApplicationsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActionsListRunnerApplicationsForRepoResponseData = {
    os: string;
    architecture: string;
    download_url: string;
    filename: string;
}[];
declare type ActionsListSelectedReposForOrgSecretEndpoint = {
    org: string;
    secret_name: string;
};
declare type ActionsListSelectedReposForOrgSecretRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/secrets/:secret_name/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListSelectedReposForOrgSecretResponseData {
    total_count: number;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    }[];
}
declare type ActionsListSelfHostedRunnerGroupsForOrgEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnerGroupsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runner-groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListSelfHostedRunnerGroupsForOrgResponseData {
    total_count: number;
    runner_groups: {
        id: number;
        name: string;
        visibility: string;
        default: boolean;
        selected_repositories_url: string;
        runners_url: string;
        inherited: boolean;
    }[];
}
declare type ActionsListSelfHostedRunnersForOrgEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnersForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListSelfHostedRunnersForOrgResponseData {
    total_count: number;
    runners: {
        id: number;
        name: string;
        os: string;
        status: string;
        busy: boolean;
        labels: {
            /**
             * Unique identifier of the label.
             */
            id: number;
            /**
             * Name of the label.
             */
            name: string;
            /**
             * The type of label. Read-only labels are applied automatically when the runner is configured.
             */
            type: "read-only" | "custom";
        }[];
    }[];
}
declare type ActionsListSelfHostedRunnersForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListSelfHostedRunnersForRepoResponseData {
    total_count: number;
    runners: {
        id: number;
        name: string;
        os: string;
        status: string;
        busy: boolean;
        labels: {
            /**
             * Unique identifier of the label.
             */
            id: number;
            /**
             * Name of the label.
             */
            name: string;
            /**
             * The type of label. Read-only labels are applied automatically when the runner is configured.
             */
            type: "read-only" | "custom";
        }[];
    }[];
}
declare type ActionsListSelfHostedRunnersInGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnersInGroupForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListSelfHostedRunnersInGroupForOrgResponseData {
    total_count: number;
    runners: {
        id: number;
        name: string;
        os: string;
        status: string;
        busy: boolean;
        labels: {
            /**
             * Unique identifier of the label.
             */
            id: number;
            /**
             * Name of the label.
             */
            name: string;
            /**
             * The type of label. Read-only labels are applied automatically when the runner is configured.
             */
            type: "read-only" | "custom";
        }[];
    }[];
}
declare type ActionsListWorkflowRunArtifactsEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListWorkflowRunArtifactsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/artifacts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListWorkflowRunArtifactsResponseData {
    total_count: number;
    artifacts: {
        id: number;
        node_id: string;
        name: string;
        size_in_bytes: number;
        url: string;
        archive_download_url: string;
        expired: boolean;
        created_at: string;
        expires_at: string;
    }[];
}
declare type ActionsListWorkflowRunsEndpoint = {
    owner: string;
    repo: string;
    workflow_id: number;
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://docs.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)."
     */
    event?: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListWorkflowRunsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id/runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListWorkflowRunsResponseData {
    total_count: number;
    workflow_runs: {
        id: number;
        node_id: string;
        head_branch: string;
        head_sha: string;
        run_number: number;
        event: string;
        status: string;
        conclusion: string;
        workflow_id: number;
        url: string;
        html_url: string;
        pull_requests: unknown[];
        created_at: string;
        updated_at: string;
        jobs_url: string;
        logs_url: string;
        check_suite_url: string;
        artifacts_url: string;
        cancel_url: string;
        rerun_url: string;
        workflow_url: string;
        head_commit: {
            id: string;
            tree_id: string;
            message: string;
            timestamp: string;
            author: {
                name: string;
                email: string;
            };
            committer: {
                name: string;
                email: string;
            };
        };
        repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
        };
        head_repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            private: boolean;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            forks_url: string;
            keys_url: string;
            collaborators_url: string;
            teams_url: string;
            hooks_url: string;
            issue_events_url: string;
            events_url: string;
            assignees_url: string;
            branches_url: string;
            tags_url: string;
            blobs_url: string;
            git_tags_url: string;
            git_refs_url: string;
            trees_url: string;
            statuses_url: string;
            languages_url: string;
            stargazers_url: string;
            contributors_url: string;
            subscribers_url: string;
            subscription_url: string;
            commits_url: string;
            git_commits_url: string;
            comments_url: string;
            issue_comment_url: string;
            contents_url: string;
            compare_url: string;
            merges_url: string;
            archive_url: string;
            downloads_url: string;
            issues_url: string;
            pulls_url: string;
            milestones_url: string;
            notifications_url: string;
            labels_url: string;
            releases_url: string;
            deployments_url: string;
        };
    }[];
}
declare type ActionsListWorkflowRunsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://docs.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)."
     */
    event?: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListWorkflowRunsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsListWorkflowRunsForRepoResponseData {
    total_count: number;
    workflow_runs: {
        id: number;
        node_id: string;
        head_branch: string;
        head_sha: string;
        run_number: number;
        event: string;
        status: string;
        conclusion: string;
        workflow_id: number;
        url: string;
        html_url: string;
        pull_requests: unknown[];
        created_at: string;
        updated_at: string;
        jobs_url: string;
        logs_url: string;
        check_suite_url: string;
        artifacts_url: string;
        cancel_url: string;
        rerun_url: string;
        workflow_url: string;
        head_commit: {
            id: string;
            tree_id: string;
            message: string;
            timestamp: string;
            author: {
                name: string;
                email: string;
            };
            committer: {
                name: string;
                email: string;
            };
        };
        repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
        };
        head_repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            private: boolean;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            forks_url: string;
            keys_url: string;
            collaborators_url: string;
            teams_url: string;
            hooks_url: string;
            issue_events_url: string;
            events_url: string;
            assignees_url: string;
            branches_url: string;
            tags_url: string;
            blobs_url: string;
            git_tags_url: string;
            git_refs_url: string;
            trees_url: string;
            statuses_url: string;
            languages_url: string;
            stargazers_url: string;
            contributors_url: string;
            subscribers_url: string;
            subscription_url: string;
            commits_url: string;
            git_commits_url: string;
            comments_url: string;
            issue_comment_url: string;
            contents_url: string;
            compare_url: string;
            merges_url: string;
            archive_url: string;
            downloads_url: string;
            issues_url: string;
            pulls_url: string;
            milestones_url: string;
            notifications_url: string;
            labels_url: string;
            releases_url: string;
            deployments_url: string;
        };
    }[];
}
declare type ActionsReRunWorkflowEndpoint = {
    owner: string;
    repo: string;
    run_id: number;
};
declare type ActionsReRunWorkflowRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runs/:run_id/rerun";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    repository_id: number;
};
declare type ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsRemoveSelectedRepoFromOrgSecretEndpoint = {
    org: string;
    secret_name: string;
    repository_id: number;
};
declare type ActionsRemoveSelectedRepoFromOrgSecretRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/secrets/:secret_name/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsRemoveSelfHostedRunnerFromGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type ActionsRemoveSelfHostedRunnerFromGroupForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * List of repository IDs that can access the runner group.
     */
    selected_repository_ids: number[];
};
declare type ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsSetSelectedReposForOrgSecretEndpoint = {
    org: string;
    secret_name: string;
    /**
     * An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://developer.github.com/v3/actions/secrets/#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://developer.github.com/v3/actions/secrets/#remove-selected-repository-from-an-organization-secret) endpoints.
     */
    selected_repository_ids?: number[];
};
declare type ActionsSetSelectedReposForOrgSecretRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/secrets/:secret_name/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsSetSelfHostedRunnersInGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * List of runner IDs to add to the runner group.
     */
    runners: number[];
};
declare type ActionsSetSelfHostedRunnersInGroupForOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsUpdateSelfHostedRunnerGroupForOrgEndpoint = {
    org: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Name of the runner group.
     */
    name?: string;
    /**
     * Visibility of a runner group. You can select all repositories, select individual repositories, or all private repositories. Can be one of: `all`, `selected`, or `private`.
     */
    visibility?: "selected" | "all" | "private";
};
declare type ActionsUpdateSelfHostedRunnerGroupForOrgRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActionsUpdateSelfHostedRunnerGroupForOrgResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_repositories_url: string;
    runners_url: string;
    inherited: boolean;
}
declare type ActivityCheckRepoIsStarredByAuthenticatedUserEndpoint = {
    owner: string;
    repo: string;
};
declare type ActivityCheckRepoIsStarredByAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/starred/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityDeleteRepoSubscriptionEndpoint = {
    owner: string;
    repo: string;
};
declare type ActivityDeleteRepoSubscriptionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityDeleteThreadSubscriptionEndpoint = {
    thread_id: number;
};
declare type ActivityDeleteThreadSubscriptionRequestOptions = {
    method: "DELETE";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetFeedsEndpoint = {};
declare type ActivityGetFeedsRequestOptions = {
    method: "GET";
    url: "/feeds";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivityGetFeedsResponseData {
    timeline_url: string;
    user_url: string;
    current_user_public_url: string;
    current_user_url: string;
    current_user_actor_url: string;
    current_user_organization_url: string;
    current_user_organization_urls: string[];
    security_advisories_url: string;
    _links: {
        timeline: {
            href: string;
            type: string;
        };
        user: {
            href: string;
            type: string;
        };
        current_user_public: {
            href: string;
            type: string;
        };
        current_user: {
            href: string;
            type: string;
        };
        current_user_actor: {
            href: string;
            type: string;
        };
        current_user_organization: {
            href: string;
            type: string;
        };
        current_user_organizations: {
            href: string;
            type: string;
        }[];
        security_advisories: {
            href: string;
            type: string;
        };
    };
}
declare type ActivityGetRepoSubscriptionEndpoint = {
    owner: string;
    repo: string;
};
declare type ActivityGetRepoSubscriptionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivityGetRepoSubscriptionResponseData {
    subscribed: boolean;
    ignored: boolean;
    reason: string;
    created_at: string;
    url: string;
    repository_url: string;
}
declare type ActivityGetThreadEndpoint = {
    thread_id: number;
};
declare type ActivityGetThreadRequestOptions = {
    method: "GET";
    url: "/notifications/threads/:thread_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivityGetThreadResponseData {
    id: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
    };
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
}
declare type ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint = {
    thread_id: number;
};
declare type ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivityGetThreadSubscriptionForAuthenticatedUserResponseData {
    subscribed: boolean;
    ignored: boolean;
    reason: string;
    created_at: string;
    url: string;
    thread_url: string;
}
declare type ActivityListEventsForAuthenticatedUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListEventsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/users/:username/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListNotificationsForAuthenticatedUserEndpoint = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListNotificationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListNotificationsForAuthenticatedUserResponseData = {
    id: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
    };
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
}[];
declare type ActivityListOrgEventsForAuthenticatedUserEndpoint = {
    username: string;
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListOrgEventsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/users/:username/events/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicEventsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicEventsRequestOptions = {
    method: "GET";
    url: "/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicEventsForRepoNetworkEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicEventsForRepoNetworkRequestOptions = {
    method: "GET";
    url: "/networks/:owner/:repo/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicEventsForUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicEventsForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/events/public";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicOrgEventsEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicOrgEventsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListReceivedEventsForUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListReceivedEventsForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/received_events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListReceivedPublicEventsForUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListReceivedPublicEventsForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/received_events/public";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListRepoEventsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListRepoEventsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserEndpoint = {
    owner: string;
    repo: string;
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListRepoNotificationsForAuthenticatedUserResponseData = {
    id: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
    };
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
}[];
declare type ActivityListReposStarredByAuthenticatedUserEndpoint = {
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListReposStarredByAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/starred";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListReposStarredByAuthenticatedUserResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}[];
export declare type ActivityListReposStarredByAuthenticatedUserResponse200Data = {
    starred_at: string;
    repo: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}[];
declare type ActivityListReposStarredByUserEndpoint = {
    username: string;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListReposStarredByUserRequestOptions = {
    method: "GET";
    url: "/users/:username/starred";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListReposStarredByUserResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}[];
export declare type ActivityListReposStarredByUserResponse200Data = {
    starred_at: string;
    repo: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}[];
declare type ActivityListReposWatchedByUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListReposWatchedByUserRequestOptions = {
    method: "GET";
    url: "/users/:username/subscriptions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListReposWatchedByUserResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type ActivityListStargazersForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListStargazersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stargazers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListStargazersForRepoResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
export declare type ActivityListStargazersForRepoResponse200Data = {
    starred_at: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}[];
declare type ActivityListWatchedReposForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListWatchedReposForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/subscriptions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListWatchedReposForAuthenticatedUserResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type ActivityListWatchersForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListWatchersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/subscribers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ActivityListWatchersForRepoResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type ActivityMarkNotificationsAsReadEndpoint = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
};
declare type ActivityMarkNotificationsAsReadRequestOptions = {
    method: "PUT";
    url: "/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityMarkRepoNotificationsAsReadEndpoint = {
    owner: string;
    repo: string;
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
};
declare type ActivityMarkRepoNotificationsAsReadRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityMarkThreadAsReadEndpoint = {
    thread_id: number;
};
declare type ActivityMarkThreadAsReadRequestOptions = {
    method: "PATCH";
    url: "/notifications/threads/:thread_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivitySetRepoSubscriptionEndpoint = {
    owner: string;
    repo: string;
    /**
     * Determines if notifications should be received from this repository.
     */
    subscribed?: boolean;
    /**
     * Determines if all notifications should be blocked from this repository.
     */
    ignored?: boolean;
};
declare type ActivitySetRepoSubscriptionRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivitySetRepoSubscriptionResponseData {
    subscribed: boolean;
    ignored: boolean;
    reason: string;
    created_at: string;
    url: string;
    repository_url: string;
}
declare type ActivitySetThreadSubscriptionEndpoint = {
    thread_id: number;
    /**
     * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
     */
    ignored?: boolean;
};
declare type ActivitySetThreadSubscriptionRequestOptions = {
    method: "PUT";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ActivitySetThreadSubscriptionResponseData {
    subscribed: boolean;
    ignored: boolean;
    reason: string;
    created_at: string;
    url: string;
    thread_url: string;
}
declare type ActivityStarRepoForAuthenticatedUserEndpoint = {
    owner: string;
    repo: string;
};
declare type ActivityStarRepoForAuthenticatedUserRequestOptions = {
    method: "PUT";
    url: "/user/starred/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityUnstarRepoForAuthenticatedUserEndpoint = {
    owner: string;
    repo: string;
};
declare type ActivityUnstarRepoForAuthenticatedUserRequestOptions = {
    method: "DELETE";
    url: "/user/starred/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsAddRepoToInstallationEndpoint = {
    installation_id: number;
    repository_id: number;
};
declare type AppsAddRepoToInstallationRequestOptions = {
    method: "PUT";
    url: "/user/installations/:installation_id/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCheckAuthorizationEndpoint = {
    client_id: string;
    access_token: string;
};
declare type AppsCheckAuthorizationRequestOptions = {
    method: "GET";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsCheckAuthorizationResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type AppsCheckTokenEndpoint = {
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsCheckTokenRequestOptions = {
    method: "POST";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsCheckTokenResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type AppsCreateContentAttachmentEndpoint = {
    content_reference_id: number;
    /**
     * The title of the content attachment displayed in the body or comment of an issue or pull request.
     */
    title: string;
    /**
     * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
     */
    body: string;
} & RequiredPreview<"corsair">;
declare type AppsCreateContentAttachmentRequestOptions = {
    method: "POST";
    url: "/content_references/:content_reference_id/attachments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsCreateContentAttachmentResponseData {
    id: number;
    title: string;
    body: string;
}
declare type AppsCreateFromManifestEndpoint = {
    code: string;
};
declare type AppsCreateFromManifestRequestOptions = {
    method: "POST";
    url: "/app-manifests/:code/conversions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsCreateFromManifestResponseData {
    id: number;
    node_id: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    client_id: string;
    client_secret: string;
    webhook_secret: string;
    pem: string;
}
declare type AppsCreateInstallationAccessTokenEndpoint = {
    installation_id: number;
    /**
     * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories accessible to the app installation](https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-app-installation)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
     */
    repository_ids?: number[];
    /**
     * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
     */
    permissions?: AppsCreateInstallationAccessTokenParamsPermissions;
};
declare type AppsCreateInstallationAccessTokenRequestOptions = {
    method: "POST";
    url: "/app/installations/:installation_id/access_tokens";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsCreateInstallationAccessTokenResponseData {
    token: string;
    expires_at: string;
    permissions: {
        issues: string;
        contents: string;
    };
    repository_selection: "all" | "selected";
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
}
declare type AppsDeleteAuthorizationEndpoint = {
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsDeleteAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/grant";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsDeleteInstallationEndpoint = {
    installation_id: number;
};
declare type AppsDeleteInstallationRequestOptions = {
    method: "DELETE";
    url: "/app/installations/:installation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsDeleteTokenEndpoint = {
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsDeleteTokenRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetAuthenticatedEndpoint = {};
declare type AppsGetAuthenticatedRequestOptions = {
    method: "GET";
    url: "/app";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetAuthenticatedResponseData {
    id: number;
    slug: string;
    node_id: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: {
        metadata: string;
        contents: string;
        issues: string;
        single_file: string;
    };
    events: string[];
    installations_count: number;
}
declare type AppsGetBySlugEndpoint = {
    app_slug: string;
};
declare type AppsGetBySlugRequestOptions = {
    method: "GET";
    url: "/apps/:app_slug";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetBySlugResponseData {
    id: number;
    slug: string;
    node_id: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: {
        metadata: string;
        contents: string;
        issues: string;
        single_file: string;
    };
    events: string[];
}
declare type AppsGetInstallationEndpoint = {
    installation_id: number;
};
declare type AppsGetInstallationRequestOptions = {
    method: "GET";
    url: "/app/installations/:installation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetInstallationResponseData {
    id: number;
    account: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: {
        checks: string;
        metadata: string;
        contents: string;
    };
    events: string[];
    single_file_name: string;
    repository_selection: "all" | "selected";
}
declare type AppsGetOrgInstallationEndpoint = {
    org: string;
};
declare type AppsGetOrgInstallationRequestOptions = {
    method: "GET";
    url: "/orgs/:org/installation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetOrgInstallationResponseData {
    id: number;
    account: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    repository_selection: "all" | "selected";
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: {
        checks: string;
        metadata: string;
        contents: string;
    };
    events: string[];
    created_at: string;
    updated_at: string;
    single_file_name: string;
}
declare type AppsGetRepoInstallationEndpoint = {
    owner: string;
    repo: string;
};
declare type AppsGetRepoInstallationRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/installation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetRepoInstallationResponseData {
    id: number;
    account: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    repository_selection: "all" | "selected";
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: {
        checks: string;
        metadata: string;
        contents: string;
    };
    events: string[];
    created_at: string;
    updated_at: string;
    single_file_name: string;
}
declare type AppsGetSubscriptionPlanForAccountEndpoint = {
    account_id: number;
};
declare type AppsGetSubscriptionPlanForAccountRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/accounts/:account_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetSubscriptionPlanForAccountResponseData {
    url: string;
    type: string;
    id: number;
    login: string;
    email: string;
    organization_billing_email: string;
    marketplace_pending_change: {
        effective_date: string;
        unit_count: number;
        id: number;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            state: string;
            unit_name: string;
            bullets: string[];
        };
    };
    marketplace_purchase: {
        billing_cycle: string;
        next_billing_date: string;
        unit_count: number;
        on_free_trial: boolean;
        free_trial_ends_on: string;
        updated_at: string;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            unit_name: string;
            state: string;
            bullets: string[];
        };
    };
}
declare type AppsGetSubscriptionPlanForAccountStubbedEndpoint = {
    account_id: number;
};
declare type AppsGetSubscriptionPlanForAccountStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/accounts/:account_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetSubscriptionPlanForAccountStubbedResponseData {
    url: string;
    type: string;
    id: number;
    login: string;
    email: string;
    organization_billing_email: string;
    marketplace_pending_change: {
        effective_date: string;
        unit_count: number;
        id: number;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            state: string;
            unit_name: string;
            bullets: string[];
        };
    };
    marketplace_purchase: {
        billing_cycle: string;
        next_billing_date: string;
        unit_count: number;
        on_free_trial: boolean;
        free_trial_ends_on: string;
        updated_at: string;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            unit_name: string;
            state: string;
            bullets: string[];
        };
    };
}
declare type AppsGetUserInstallationEndpoint = {
    username: string;
};
declare type AppsGetUserInstallationRequestOptions = {
    method: "GET";
    url: "/users/:username/installation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsGetUserInstallationResponseData {
    id: number;
    account: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    repository_selection: "all" | "selected";
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: {
        checks: string;
        metadata: string;
        contents: string;
    };
    events: string[];
    created_at: string;
    updated_at: string;
    single_file_name: string;
}
declare type AppsListAccountsForPlanEndpoint = {
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListAccountsForPlanRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/plans/:plan_id/accounts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListAccountsForPlanResponseData = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: string;
    organization_billing_email: string;
    marketplace_pending_change: {
        effective_date: string;
        unit_count: number;
        id: number;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            state: string;
            unit_name: string;
            bullets: string[];
        };
    };
    marketplace_purchase: {
        billing_cycle: string;
        next_billing_date: string;
        unit_count: number;
        on_free_trial: boolean;
        free_trial_ends_on: string;
        updated_at: string;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            unit_name: string;
            state: string;
            bullets: string[];
        };
    };
}[];
declare type AppsListAccountsForPlanStubbedEndpoint = {
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListAccountsForPlanStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/plans/:plan_id/accounts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListAccountsForPlanStubbedResponseData = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: string;
    organization_billing_email: string;
    marketplace_pending_change: {
        effective_date: string;
        unit_count: number;
        id: number;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            state: string;
            unit_name: string;
            bullets: string[];
        };
    };
    marketplace_purchase: {
        billing_cycle: string;
        next_billing_date: string;
        unit_count: number;
        on_free_trial: boolean;
        free_trial_ends_on: string;
        updated_at: string;
        plan: {
            url: string;
            accounts_url: string;
            id: number;
            number: number;
            name: string;
            description: string;
            monthly_price_in_cents: number;
            yearly_price_in_cents: number;
            price_model: string;
            has_free_trial: boolean;
            unit_name: string;
            state: string;
            bullets: string[];
        };
    };
}[];
declare type AppsListInstallationReposForAuthenticatedUserEndpoint = {
    installation_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListInstallationReposForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/installations/:installation_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsListInstallationReposForAuthenticatedUserResponseData {
    total_count: number;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
}
declare type AppsListInstallationsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListInstallationsRequestOptions = {
    method: "GET";
    url: "/app/installations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListInstallationsResponseData = {
    id: number;
    account: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: {
        checks: string;
        metadata: string;
        contents: string;
    };
    events: string[];
    single_file_name: string;
    repository_selection: "all" | "selected";
}[];
declare type AppsListInstallationsForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListInstallationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/installations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsListInstallationsForAuthenticatedUserResponseData {
    total_count: number;
    installations: {
        id: number;
        account: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
            gravatar_id: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        access_tokens_url: string;
        repositories_url: string;
        html_url: string;
        app_id: number;
        target_id: number;
        target_type: string;
        permissions: {
            checks: string;
            metadata: string;
            contents: string;
        };
        events: string[];
        single_file_name: string;
    }[];
}
declare type AppsListPlansEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListPlansRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/plans";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListPlansResponseData = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: string;
    state: string;
    bullets: string[];
}[];
declare type AppsListPlansStubbedEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListPlansStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/plans";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListPlansStubbedResponseData = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: string;
    state: string;
    bullets: string[];
}[];
declare type AppsListReposAccessibleToInstallationEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListReposAccessibleToInstallationRequestOptions = {
    method: "GET";
    url: "/installation/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsListReposAccessibleToInstallationResponseData {
    total_count: number;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
}
declare type AppsListSubscriptionsForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListSubscriptionsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/marketplace_purchases";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListSubscriptionsForAuthenticatedUserResponseData = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: number;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    account: {
        login: string;
        id: number;
        url: string;
        email: string;
        organization_billing_email: string;
        type: string;
    };
    plan: {
        url: string;
        accounts_url: string;
        id: number;
        number: number;
        name: string;
        description: string;
        monthly_price_in_cents: number;
        yearly_price_in_cents: number;
        price_model: string;
        has_free_trial: boolean;
        unit_name: string;
        state: string;
        bullets: string[];
    };
}[];
declare type AppsListSubscriptionsForAuthenticatedUserStubbedEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListSubscriptionsForAuthenticatedUserStubbedRequestOptions = {
    method: "GET";
    url: "/user/marketplace_purchases/stubbed";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type AppsListSubscriptionsForAuthenticatedUserStubbedResponseData = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: number;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    account: {
        login: string;
        id: number;
        url: string;
        email: string;
        organization_billing_email: string;
        type: string;
    };
    plan: {
        url: string;
        accounts_url: string;
        id: number;
        number: number;
        name: string;
        description: string;
        monthly_price_in_cents: number;
        yearly_price_in_cents: number;
        price_model: string;
        has_free_trial: boolean;
        unit_name: string;
        state: string;
        bullets: string[];
    };
}[];
declare type AppsRemoveRepoFromInstallationEndpoint = {
    installation_id: number;
    repository_id: number;
};
declare type AppsRemoveRepoFromInstallationRequestOptions = {
    method: "DELETE";
    url: "/user/installations/:installation_id/repositories/:repository_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsResetAuthorizationEndpoint = {
    client_id: string;
    access_token: string;
};
declare type AppsResetAuthorizationRequestOptions = {
    method: "POST";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsResetAuthorizationResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type AppsResetTokenEndpoint = {
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsResetTokenRequestOptions = {
    method: "PATCH";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface AppsResetTokenResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type AppsRevokeAuthorizationForApplicationEndpoint = {
    client_id: string;
    access_token: string;
};
declare type AppsRevokeAuthorizationForApplicationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsRevokeGrantForApplicationEndpoint = {
    client_id: string;
    access_token: string;
};
declare type AppsRevokeGrantForApplicationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/grants/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsRevokeInstallationAccessTokenEndpoint = {};
declare type AppsRevokeInstallationAccessTokenRequestOptions = {
    method: "DELETE";
    url: "/installation/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsSuspendInstallationEndpoint = {
    installation_id: number;
};
declare type AppsSuspendInstallationRequestOptions = {
    method: "PUT";
    url: "/app/installations/:installation_id/suspended";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsUnsuspendInstallationEndpoint = {
    installation_id: number;
};
declare type AppsUnsuspendInstallationRequestOptions = {
    method: "DELETE";
    url: "/app/installations/:installation_id/suspended";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type BillingGetGithubActionsBillingOrgEndpoint = {
    org: string;
};
declare type BillingGetGithubActionsBillingOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/settings/billing/actions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetGithubActionsBillingOrgResponseData {
    /**
     * The sum of the free and paid GitHub Actions minutes used.
     */
    total_minutes_used: number;
    /**
     * The total paid GitHub Actions minutes used.
     */
    total_paid_minutes_used: number;
    /**
     * The amount of free GitHub Actions minutes available.
     */
    included_minutes: number;
    minutes_used_breakdown: {
        /**
         * Total minutes used on Ubuntu runner machines.
         */
        UBUNTU: number;
        /**
         * Total minutes used on macOS runner machines.
         */
        MACOS: number;
        /**
         * Total minutes used on Windows runner machines.
         */
        WINDOWS: number;
    };
}
declare type BillingGetGithubActionsBillingUserEndpoint = {
    username: string;
};
declare type BillingGetGithubActionsBillingUserRequestOptions = {
    method: "GET";
    url: "/users/:username/settings/billing/actions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetGithubActionsBillingUserResponseData {
    /**
     * The sum of the free and paid GitHub Actions minutes used.
     */
    total_minutes_used: number;
    /**
     * The total paid GitHub Actions minutes used.
     */
    total_paid_minutes_used: number;
    /**
     * The amount of free GitHub Actions minutes available.
     */
    included_minutes: number;
    minutes_used_breakdown: {
        /**
         * Total minutes used on Ubuntu runner machines.
         */
        UBUNTU: number;
        /**
         * Total minutes used on macOS runner machines.
         */
        MACOS: number;
        /**
         * Total minutes used on Windows runner machines.
         */
        WINDOWS: number;
    };
}
declare type BillingGetGithubPackagesBillingOrgEndpoint = {
    org: string;
};
declare type BillingGetGithubPackagesBillingOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/settings/billing/packages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetGithubPackagesBillingOrgResponseData {
    /**
     * Sum of the free and paid storage space (GB) for GitHuub Packages.
     */
    total_gigabytes_bandwidth_used: number;
    /**
     * Total paid storage space (GB) for GitHuub Packages.
     */
    total_paid_gigabytes_bandwidth_used: number;
    /**
     * Free storage space (GB) for GitHub Packages.
     */
    included_gigabytes_bandwidth: number;
}
declare type BillingGetGithubPackagesBillingUserEndpoint = {
    username: string;
};
declare type BillingGetGithubPackagesBillingUserRequestOptions = {
    method: "GET";
    url: "/users/:username/settings/billing/packages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetGithubPackagesBillingUserResponseData {
    /**
     * Sum of the free and paid storage space (GB) for GitHuub Packages.
     */
    total_gigabytes_bandwidth_used: number;
    /**
     * Total paid storage space (GB) for GitHuub Packages.
     */
    total_paid_gigabytes_bandwidth_used: number;
    /**
     * Free storage space (GB) for GitHub Packages.
     */
    included_gigabytes_bandwidth: number;
}
declare type BillingGetSharedStorageBillingOrgEndpoint = {
    org: string;
};
declare type BillingGetSharedStorageBillingOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/settings/billing/shared-storage";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetSharedStorageBillingOrgResponseData {
    /**
     * Numbers of days left in billing cycle.
     */
    days_left_in_billing_cycle: number;
    /**
     * Estimated storage space (GB) used in billing cycle.
     */
    estimated_paid_storage_for_month: number;
    /**
     * Estimated sum of free and paid storage space (GB) used in billing cycle.
     */
    estimated_storage_for_month: number;
}
declare type BillingGetSharedStorageBillingUserEndpoint = {
    username: string;
};
declare type BillingGetSharedStorageBillingUserRequestOptions = {
    method: "GET";
    url: "/users/:username/settings/billing/shared-storage";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface BillingGetSharedStorageBillingUserResponseData {
    /**
     * Numbers of days left in billing cycle.
     */
    days_left_in_billing_cycle: number;
    /**
     * Estimated storage space (GB) used in billing cycle.
     */
    estimated_paid_storage_for_month: number;
    /**
     * Estimated sum of free and paid storage space (GB) used in billing cycle.
     */
    estimated_storage_for_month: number;
}
declare type ChecksCreateEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name: string;
    /**
     * The SHA of the commit.
     */
    head_sha: string;
    /**
     * The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "skipped" | "timed_out" | "action_required";
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
     */
    output?: ChecksCreateParamsOutput;
    /**
     * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/webhooks/event-payloads/#check_run) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksCreateParamsActions[];
} & RequiredPreview<"antiope">;
declare type ChecksCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksCreateResponseData {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: {
        title: string;
        summary: string;
        annotations_url: string;
        annotations_count: number;
        text: string;
    };
    name: string;
    check_suite: {
        id: number;
    };
    app: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    };
    pull_requests: {
        url: string;
        id: number;
        number: number;
        head: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
        base: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
    }[];
}
declare type ChecksCreateSuiteEndpoint = {
    owner: string;
    repo: string;
    /**
     * The sha of the head commit.
     */
    head_sha: string;
} & RequiredPreview<"antiope">;
declare type ChecksCreateSuiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-suites";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksCreateSuiteResponseData {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: unknown[];
    app: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    };
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}
declare type ChecksGetEndpoint = {
    owner: string;
    repo: string;
    check_run_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-runs/:check_run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksGetResponseData {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: {
        title: string;
        summary: string;
        text: string;
        annotations_count: number;
        annotations_url: string;
    };
    name: string;
    check_suite: {
        id: number;
    };
    app: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    };
    pull_requests: {
        url: string;
        id: number;
        number: number;
        head: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
        base: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
    }[];
}
declare type ChecksGetSuiteEndpoint = {
    owner: string;
    repo: string;
    check_suite_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksGetSuiteRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksGetSuiteResponseData {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: unknown[];
    app: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    };
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}
declare type ChecksListAnnotationsEndpoint = {
    owner: string;
    repo: string;
    check_run_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListAnnotationsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-runs/:check_run_id/annotations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ChecksListAnnotationsResponseData = {
    path: string;
    start_line: number;
    end_line: number;
    start_column: number;
    end_column: number;
    annotation_level: string;
    title: string;
    message: string;
    raw_details: string;
}[];
declare type ChecksListForRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksListForRefResponseData {
    total_count: number;
    check_runs: {
        id: number;
        head_sha: string;
        node_id: string;
        external_id: string;
        url: string;
        html_url: string;
        details_url: string;
        status: string;
        conclusion: string;
        started_at: string;
        completed_at: string;
        output: {
            title: string;
            summary: string;
            text: string;
            annotations_count: number;
            annotations_url: string;
        };
        name: string;
        check_suite: {
            id: number;
        };
        app: {
            id: number;
            slug: string;
            node_id: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                url: string;
                repos_url: string;
                events_url: string;
                hooks_url: string;
                issues_url: string;
                members_url: string;
                public_members_url: string;
                avatar_url: string;
                description: string;
            };
            name: string;
            description: string;
            external_url: string;
            html_url: string;
            created_at: string;
            updated_at: string;
            permissions: {
                metadata: string;
                contents: string;
                issues: string;
                single_file: string;
            };
            events: string[];
        };
        pull_requests: {
            url: string;
            id: number;
            number: number;
            head: {
                ref: string;
                sha: string;
                repo: {
                    id: number;
                    url: string;
                    name: string;
                };
            };
            base: {
                ref: string;
                sha: string;
                repo: {
                    id: number;
                    url: string;
                    name: string;
                };
            };
        }[];
    }[];
}
declare type ChecksListForSuiteEndpoint = {
    owner: string;
    repo: string;
    check_suite_id: number;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListForSuiteRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksListForSuiteResponseData {
    total_count: number;
    check_runs: {
        id: number;
        head_sha: string;
        node_id: string;
        external_id: string;
        url: string;
        html_url: string;
        details_url: string;
        status: string;
        conclusion: string;
        started_at: string;
        completed_at: string;
        output: {
            title: string;
            summary: string;
            text: string;
            annotations_count: number;
            annotations_url: string;
        };
        name: string;
        check_suite: {
            id: number;
        };
        app: {
            id: number;
            slug: string;
            node_id: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                url: string;
                repos_url: string;
                events_url: string;
                hooks_url: string;
                issues_url: string;
                members_url: string;
                public_members_url: string;
                avatar_url: string;
                description: string;
            };
            name: string;
            description: string;
            external_url: string;
            html_url: string;
            created_at: string;
            updated_at: string;
            permissions: {
                metadata: string;
                contents: string;
                issues: string;
                single_file: string;
            };
            events: string[];
        };
        pull_requests: {
            url: string;
            id: number;
            number: number;
            head: {
                ref: string;
                sha: string;
                repo: {
                    id: number;
                    url: string;
                    name: string;
                };
            };
            base: {
                ref: string;
                sha: string;
                repo: {
                    id: number;
                    url: string;
                    name: string;
                };
            };
        }[];
    }[];
}
declare type ChecksListSuitesForRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
    /**
     * Filters check suites by GitHub App `id`.
     */
    app_id?: number;
    /**
     * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
     */
    check_name?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListSuitesForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/check-suites";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksListSuitesForRefResponseData {
    total_count: number;
    check_suites: {
        id: number;
        node_id: string;
        head_branch: string;
        head_sha: string;
        status: string;
        conclusion: string;
        url: string;
        before: string;
        after: string;
        pull_requests: unknown[];
        app: {
            id: number;
            slug: string;
            node_id: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                url: string;
                repos_url: string;
                events_url: string;
                hooks_url: string;
                issues_url: string;
                members_url: string;
                public_members_url: string;
                avatar_url: string;
                description: string;
            };
            name: string;
            description: string;
            external_url: string;
            html_url: string;
            created_at: string;
            updated_at: string;
            permissions: {
                metadata: string;
                contents: string;
                issues: string;
                single_file: string;
            };
            events: string[];
        };
        repository: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    }[];
}
declare type ChecksRerequestSuiteEndpoint = {
    owner: string;
    repo: string;
    check_suite_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksRerequestSuiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id/rerequest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksSetSuitesPreferencesEndpoint = {
    owner: string;
    repo: string;
    /**
     * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
     */
    auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
} & RequiredPreview<"antiope">;
declare type ChecksSetSuitesPreferencesRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/check-suites/preferences";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksSetSuitesPreferencesResponseData {
    preferences: {
        auto_trigger_checks: {
            app_id: number;
            setting: boolean;
        }[];
    };
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}
declare type ChecksUpdateEndpoint = {
    owner: string;
    repo: string;
    check_run_id: number;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name?: string;
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "skipped" | "timed_out" | "action_required";
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
     */
    output?: ChecksUpdateParamsOutput;
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksUpdateParamsActions[];
} & RequiredPreview<"antiope">;
declare type ChecksUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/check-runs/:check_run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ChecksUpdateResponseData {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: {
        title: string;
        summary: string;
        text: string;
        annotations_count: number;
        annotations_url: string;
    };
    name: string;
    check_suite: {
        id: number;
    };
    app: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    };
    pull_requests: {
        url: string;
        id: number;
        number: number;
        head: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
        base: {
            ref: string;
            sha: string;
            repo: {
                id: number;
                url: string;
                name: string;
            };
        };
    }[];
}
declare type CodeScanningGetAlertEndpoint = {
    owner: string;
    repo: string;
    /**
     * The code scanning alert number.
     */
    alert_number?: number;
};
declare type CodeScanningGetAlertRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/code-scanning/alerts/:alert_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface CodeScanningGetAlertResponseData {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: unknown[];
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed" | "fixed";
    dismissed_by: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
        [k: string]: unknown;
    } | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    /**
     * **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ("false positive" | "won't fix" | "used in tests") | null;
    rule: {
        /**
         * A unique identifier for the rule used to detect the alert.
         */
        id: string;
        /**
         * The severity of the alert.
         */
        severity: "none" | "note" | "warning" | "error";
        /**
         * A short description of the rule used to detect the alert.
         */
        description: string;
    };
    tool: {
        /**
         * The name of the tool used to generate the code scanning analysis alert.
         */
        name: string;
        /**
         * The version of the tool used to detect the alert.
         */
        version: string;
    };
}
declare type CodeScanningGetAlertDeprecatedAlertIdEndpoint = {
    owner: string;
    repo: string;
    /**
     * The code scanning alert number.
     *  @deprecated "alert_id" is deprecated. Use "alert_number" instead
     */
    alert_id?: number;
};
declare type CodeScanningListAlertsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Set to `open`, `fixed`, or `dismissed` to list code scanning alerts in a specific state.
     */
    state?: "open" | "dismissed" | "fixed";
    /**
     * Set a full Git reference to list alerts for a specific branch. The `ref` must be formatted as `refs/heads/<branch name>`.
     */
    ref?: string;
};
declare type CodeScanningListAlertsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/code-scanning/alerts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type CodeScanningListAlertsForRepoResponseData = {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed" | "fixed";
    dismissed_by: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
        [k: string]: unknown;
    } | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    /**
     * **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ("false positive" | "won't fix" | "used in tests") | null;
    rule: {
        /**
         * A unique identifier for the rule used to detect the alert.
         */
        id: string;
        /**
         * The severity of the alert.
         */
        severity: "none" | "note" | "warning" | "error";
        /**
         * A short description of the rule used to detect the alert.
         */
        description: string;
    };
    tool: {
        /**
         * The name of the tool used to generate the code scanning analysis alert.
         */
        name: string;
        /**
         * The version of the tool used to detect the alert.
         */
        version: string;
    };
}[];
declare type CodeScanningListRecentAnalysesEndpoint = {
    owner: string;
    repo: string;
    /**
     * Set a full Git reference to list alerts for a specific branch. The `ref` must be formatted as `refs/heads/<branch name>`.
     */
    ref?: string;
    /**
     * Set a single code scanning tool name to filter alerts by tool.
     */
    tool_name?: string;
};
declare type CodeScanningListRecentAnalysesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/code-scanning/analyses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type CodeScanningListRecentAnalysesResponseData = {
    /**
     * The commit SHA of the code scanning analysis file.
     */
    commit_sha: string;
    /**
     * The full Git reference of the code scanning analysis file, formatted as `refs/heads/<branch name>`.
     */
    ref: string;
    /**
     * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
     */
    analysis_key: string;
    /**
     * The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    created_at: string;
    /**
     * The name of the tool used to generate the code scanning analysis alert.
     */
    tool_name: string;
    error: string;
    /**
     * Identifies the variable values associated with the environment in which this analysis was performed.
     */
    environment: string;
}[];
declare type CodeScanningUpdateAlertEndpoint = {
    owner: string;
    repo: string;
    /**
     * The code scanning alert number.
     */
    alert_number?: number;
    /**
     * Sets the state of the code scanning alert. Can be one of `open` or `dismissed`. You must provide `dismissed_reason` when you set the state to `dismissed`.
     */
    state: "open" | "dismissed";
    /**
     * **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason?: string | null;
};
declare type CodeScanningUpdateAlertRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/code-scanning/alerts/:alert_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface CodeScanningUpdateAlertResponseData {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: unknown[];
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed" | "fixed";
    dismissed_by: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
        [k: string]: unknown;
    } | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    /**
     * **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ("false positive" | "won't fix" | "used in tests") | null;
    rule: {
        /**
         * A unique identifier for the rule used to detect the alert.
         */
        id: string;
        /**
         * The severity of the alert.
         */
        severity: "none" | "note" | "warning" | "error";
        /**
         * A short description of the rule used to detect the alert.
         */
        description: string;
    };
    tool: {
        /**
         * The name of the tool used to generate the code scanning analysis alert.
         */
        name: string;
        /**
         * The version of the tool used to detect the alert.
         */
        version: string;
    };
}
declare type CodeScanningUploadSarifEndpoint = {
    owner: string;
    repo: string;
    /**
     * The commit SHA of the code scanning analysis file.
     */
    commit_sha: string;
    /**
     * The full Git reference of the code scanning analysis file, formatted as `refs/heads/<branch name>`.
     */
    ref: string;
    /**
     * A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string.
     */
    sarif: string;
    /**
     * The base directory used in the analysis, as it appears in the SARIF file.
     * This property is used to convert file paths from absolute to relative, so that alerts can be mapped to their correct location in the repository.
     */
    checkout_uri?: string;
    /**
     * The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The name of the tool used to generate the code scanning analysis alert.
     */
    tool_name: string;
};
declare type CodeScanningUploadSarifRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/code-scanning/sarifs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodesOfConductGetAllCodesOfConductEndpoint = {} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetAllCodesOfConductRequestOptions = {
    method: "GET";
    url: "/codes_of_conduct";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type CodesOfConductGetAllCodesOfConductResponseData = {
    key: string;
    name: string;
    url: string;
}[];
declare type CodesOfConductGetConductCodeEndpoint = {
    key: string;
} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetConductCodeRequestOptions = {
    method: "GET";
    url: "/codes_of_conduct/:key";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface CodesOfConductGetConductCodeResponseData {
    key: string;
    name: string;
    url: string;
    body: string;
}
declare type CodesOfConductGetForRepoEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/community/code_of_conduct";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface CodesOfConductGetForRepoResponseData {
    key: string;
    name: string;
    url: string;
    body: string;
}
declare type EmojisGetEndpoint = {};
declare type EmojisGetRequestOptions = {
    method: "GET";
    url: "/emojis";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of an organization.
     */
    org_id: number;
};
declare type EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions = {
    method: "PUT";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations/:org_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminAddSelfHostedRunnerToRunnerGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type EnterpriseAdminAddSelfHostedRunnerToRunnerGroupForEnterpriseRequestOptions = {
    method: "PUT";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminCreateRegistrationTokenForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminCreateRegistrationTokenForEnterpriseRequestOptions = {
    method: "POST";
    url: "/enterprises/:enterprise/actions/runners/registration-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminCreateRegistrationTokenForEnterpriseResponseData {
    token: string;
    expires_at: string;
}
declare type EnterpriseAdminCreateRemoveTokenForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminCreateRemoveTokenForEnterpriseRequestOptions = {
    method: "POST";
    url: "/enterprises/:enterprise/actions/runners/remove-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminCreateRemoveTokenForEnterpriseResponseData {
    token: string;
    expires_at: string;
}
declare type EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Name of the runner group.
     */
    name: string;
    /**
     * Visibility of a runner group. You can select all organizations or select individual organization. Can be one of: `all` or `selected`
     */
    visibility?: "selected" | "all";
    /**
     * List of organization IDs that can access the runner group.
     */
    selected_organization_ids?: number[];
    /**
     * List of runner IDs to add to the runner group.
     */
    runners?: number[];
};
declare type EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseRequestOptions = {
    method: "POST";
    url: "/enterprises/:enterprise/actions/runner-groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_organizations_url: string;
    runners_url: string;
}
declare type EnterpriseAdminDeleteScimGroupFromEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_group_id: string;
};
declare type EnterpriseAdminDeleteScimGroupFromEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/scim/v2/enterprises/:enterprise/Groups/:scim_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/enterprises/:enterprise/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
};
declare type EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminDeleteUserFromEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_user_id: string;
};
declare type EnterpriseAdminDeleteUserFromEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/scim/v2/enterprises/:enterprise/Users/:scim_user_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminGetGithubActionsBillingGheEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminGetGithubActionsBillingGheRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/settings/billing/actions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetGithubActionsBillingGheResponseData {
    /**
     * The sum of the free and paid GitHub Actions minutes used.
     */
    total_minutes_used: number;
    /**
     * The total paid GitHub Actions minutes used.
     */
    total_paid_minutes_used: number;
    /**
     * The amount of free GitHub Actions minutes available.
     */
    included_minutes: number;
    minutes_used_breakdown: {
        /**
         * Total minutes used on Ubuntu runner machines.
         */
        UBUNTU: number;
        /**
         * Total minutes used on macOS runner machines.
         */
        MACOS: number;
        /**
         * Total minutes used on Windows runner machines.
         */
        WINDOWS: number;
    };
}
declare type EnterpriseAdminGetGithubActionsBillingGheDeprecatedEnterpriseIdEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     *  @deprecated "enterprise_id" is deprecated. Use "enterprise" instead
     */
    enterprise_id?: string;
};
declare type EnterpriseAdminGetGithubPackagesBillingGheEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminGetGithubPackagesBillingGheRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/settings/billing/packages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetGithubPackagesBillingGheResponseData {
    /**
     * Sum of the free and paid storage space (GB) for GitHuub Packages.
     */
    total_gigabytes_bandwidth_used: number;
    /**
     * Total paid storage space (GB) for GitHuub Packages.
     */
    total_paid_gigabytes_bandwidth_used: number;
    /**
     * Free storage space (GB) for GitHub Packages.
     */
    included_gigabytes_bandwidth: number;
}
declare type EnterpriseAdminGetGithubPackagesBillingGheDeprecatedEnterpriseIdEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     *  @deprecated "enterprise_id" is deprecated. Use "enterprise" instead
     */
    enterprise_id?: string;
};
declare type EnterpriseAdminGetProvisioningInformationForEnterpriseGroupEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_group_id: string;
};
declare type EnterpriseAdminGetProvisioningInformationForEnterpriseGroupRequestOptions = {
    method: "GET";
    url: "/scim/v2/enterprises/:enterprise/Groups/:scim_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetProvisioningInformationForEnterpriseGroupResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    displayName: string;
    members: {
        value: string;
        $ref: string;
        display: string;
    }[];
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminGetProvisioningInformationForEnterpriseUserEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_user_id: string;
};
declare type EnterpriseAdminGetProvisioningInformationForEnterpriseUserRequestOptions = {
    method: "GET";
    url: "/scim/v2/enterprises/:enterprise/Users/:scim_user_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetProvisioningInformationForEnterpriseUserResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    userName: string;
    name: {
        givenName: string;
        familyName: string;
    };
    emails: {
        value: string;
        type: string;
        primary: boolean;
    }[];
    groups: {
        value: string;
    }[];
    active: boolean;
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminGetSelfHostedRunnerForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type EnterpriseAdminGetSelfHostedRunnerForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetSelfHostedRunnerForEnterpriseResponseData {
    id: number;
    name: string;
    os: string;
    status: string;
    busy: boolean;
    labels: {
        /**
         * Unique identifier of the label.
         */
        id: number;
        /**
         * Name of the label.
         */
        name: string;
        /**
         * The type of label. Read-only labels are applied automatically when the runner is configured.
         */
        type: "read-only" | "custom";
    }[];
}
declare type EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
};
declare type EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_organizations_url: string;
    runners_url: string;
}
declare type EnterpriseAdminGetSharedStorageBillingGheEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminGetSharedStorageBillingGheRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/settings/billing/shared-storage";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminGetSharedStorageBillingGheResponseData {
    /**
     * Numbers of days left in billing cycle.
     */
    days_left_in_billing_cycle: number;
    /**
     * Estimated storage space (GB) used in billing cycle.
     */
    estimated_paid_storage_for_month: number;
    /**
     * Estimated sum of free and paid storage space (GB) used in billing cycle.
     */
    estimated_storage_for_month: number;
}
declare type EnterpriseAdminGetSharedStorageBillingGheDeprecatedEnterpriseIdEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     *  @deprecated "enterprise_id" is deprecated. Use "enterprise" instead
     */
    enterprise_id?: string;
};
declare type EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponseData {
    total_count: number;
    organizations: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    }[];
}
declare type EnterpriseAdminListProvisionedGroupsEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Used for pagination: the index of the first result to return.
     */
    startIndex?: number;
    /**
     * Used for pagination: the number of results to return.
     */
    count?: number;
};
declare type EnterpriseAdminListProvisionedGroupsEnterpriseRequestOptions = {
    method: "GET";
    url: "/scim/v2/enterprises/:enterprise/Groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListProvisionedGroupsEnterpriseResponseData {
    schemas: string[];
    totalResults: number;
    itemsPerPage: number;
    startIndex: number;
    Resources: {
        schemas: string[];
        id: string;
        externalId: string;
        displayName: string;
        members: {
            value: string;
            $ref: string;
            display: string;
        }[];
        meta: {
            resourceType: string;
            created: string;
            lastModified: string;
            location: string;
        };
    }[];
}
declare type EnterpriseAdminListProvisionedIdentitiesEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Used for pagination: the index of the first result to return.
     */
    startIndex?: number;
    /**
     * Used for pagination: the number of results to return.
     */
    count?: number;
};
declare type EnterpriseAdminListProvisionedIdentitiesEnterpriseRequestOptions = {
    method: "GET";
    url: "/scim/v2/enterprises/:enterprise/Users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListProvisionedIdentitiesEnterpriseResponseData {
    schemas: string[];
    totalResults: number;
    itemsPerPage: number;
    startIndex: number;
    Resources: {
        schemas: string[];
        id: string;
        externalId: string;
        userName: string;
        name: {
            givenName: string;
            familyName: string;
        };
        emails: {
            value: string;
            primary: boolean;
            type: string;
        }[];
        groups: {
            value: string;
        }[];
        active: boolean;
        meta: {
            resourceType: string;
            created: string;
            lastModified: string;
            location: string;
        };
    }[];
}
declare type EnterpriseAdminListRunnerApplicationsForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
};
declare type EnterpriseAdminListRunnerApplicationsForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runners/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type EnterpriseAdminListRunnerApplicationsForEnterpriseResponseData = {
    os: string;
    architecture: string;
    download_url: string;
    filename: string;
}[];
declare type EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runner-groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseResponseData {
    total_count: number;
    runner_groups: {
        id: number;
        name: string;
        visibility: string;
        default: boolean;
        selected_organizations_url: string;
        runners_url: string;
    }[];
}
declare type EnterpriseAdminListSelfHostedRunnersForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type EnterpriseAdminListSelfHostedRunnersForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListSelfHostedRunnersForEnterpriseResponseData {
    total_count: number;
    runners: {
        id: number;
        name: string;
        os: string;
        status: string;
        busy: boolean;
        labels: {
            /**
             * Unique identifier of the label.
             */
            id: number;
            /**
             * Name of the label.
             */
            name: string;
            /**
             * The type of label. Read-only labels are applied automatically when the runner is configured.
             */
            type: "read-only" | "custom";
        }[];
    }[];
}
declare type EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseRequestOptions = {
    method: "GET";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseResponseData {
    total_count: number;
    runners: {
        id: number;
        name: string;
        os: string;
        status: string;
        busy: boolean;
        labels: {
            /**
             * Unique identifier of the label.
             */
            id: number;
            /**
             * Name of the label.
             */
            name: string;
            /**
             * The type of label. Read-only labels are applied automatically when the runner is configured.
             */
            type: "read-only" | "custom";
        }[];
    }[];
}
declare type EnterpriseAdminProvisionAndInviteEnterpriseGroupEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * The name of the SCIM group. This must match the GitHub organization that the group maps to.
     */
    displayName: string;
    members?: EnterpriseAdminProvisionAndInviteEnterpriseGroupParamsMembers[];
};
declare type EnterpriseAdminProvisionAndInviteEnterpriseGroupRequestOptions = {
    method: "POST";
    url: "/scim/v2/enterprises/:enterprise/Groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminProvisionAndInviteEnterpriseGroupResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    displayName: string;
    members: {
        value: string;
        $ref: string;
        display: string;
    }[];
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminProvisionAndInviteEnterpriseUserEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * The username for the user.
     */
    userName: string;
    name: EnterpriseAdminProvisionAndInviteEnterpriseUserParamsName;
    /**
     * List of user emails.
     */
    emails: EnterpriseAdminProvisionAndInviteEnterpriseUserParamsEmails[];
    /**
     * List of SCIM group IDs the user is a member of.
     */
    groups?: EnterpriseAdminProvisionAndInviteEnterpriseUserParamsGroups[];
};
declare type EnterpriseAdminProvisionAndInviteEnterpriseUserRequestOptions = {
    method: "POST";
    url: "/scim/v2/enterprises/:enterprise/Users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminProvisionAndInviteEnterpriseUserResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    userName: string;
    name: {
        givenName: string;
        familyName: string;
    };
    emails: {
        value: string;
        type: string;
        primary: boolean;
    }[];
    groups: {
        value: string;
    }[];
    active: boolean;
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of an organization.
     */
    org_id: number;
};
declare type EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations/:org_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
};
declare type EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseRequestOptions = {
    method: "DELETE";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminSetInformationForProvisionedEnterpriseGroupEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_group_id: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * The name of the SCIM group. This must match the GitHub organization that the group maps to.
     */
    displayName: string;
    members?: EnterpriseAdminSetInformationForProvisionedEnterpriseGroupParamsMembers[];
};
declare type EnterpriseAdminSetInformationForProvisionedEnterpriseGroupRequestOptions = {
    method: "PUT";
    url: "/scim/v2/enterprises/:enterprise/Groups/:scim_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminSetInformationForProvisionedEnterpriseGroupResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    displayName: string;
    members: {
        value: string;
        $ref: string;
        display: string;
    }[];
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminSetInformationForProvisionedEnterpriseUserEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_user_id: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * The username for the user.
     */
    userName: string;
    name: EnterpriseAdminSetInformationForProvisionedEnterpriseUserParamsName;
    /**
     * List of user emails.
     */
    emails: EnterpriseAdminSetInformationForProvisionedEnterpriseUserParamsEmails[];
    /**
     * List of SCIM group IDs the user is a member of.
     */
    groups?: EnterpriseAdminSetInformationForProvisionedEnterpriseUserParamsGroups[];
};
declare type EnterpriseAdminSetInformationForProvisionedEnterpriseUserRequestOptions = {
    method: "PUT";
    url: "/scim/v2/enterprises/:enterprise/Users/:scim_user_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminSetInformationForProvisionedEnterpriseUserResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    userName: string;
    name: {
        givenName: string;
        familyName: string;
    };
    emails: {
        value: string;
        type: string;
        primary: boolean;
    }[];
    groups: {
        value: string;
    }[];
    active: boolean;
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * List of organization IDs that can access the runner group.
     */
    selected_organization_ids: number[];
};
declare type EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseRequestOptions = {
    method: "PUT";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/organizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminSetSelfHostedInGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * List of runner IDs to add to the runner group.
     */
    runners: number[];
};
declare type EnterpriseAdminSetSelfHostedInGroupForEnterpriseRequestOptions = {
    method: "PUT";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type EnterpriseAdminUpdateAttributeForEnterpriseGroupEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_group_id: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     */
    Operations: EnterpriseAdminUpdateAttributeForEnterpriseGroupParamsOperations[];
};
declare type EnterpriseAdminUpdateAttributeForEnterpriseGroupRequestOptions = {
    method: "PATCH";
    url: "/scim/v2/enterprises/:enterprise/Groups/:scim_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminUpdateAttributeForEnterpriseGroupResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    displayName: string;
    members: {
        value: string;
        $ref: string;
        display: string;
    }[];
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminUpdateAttributeForEnterpriseUserEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_user_id: string;
    /**
     * The SCIM schema URIs.
     */
    schemas: string[];
    /**
     * Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     */
    Operations: EnterpriseAdminUpdateAttributeForEnterpriseUserParamsOperations[];
};
declare type EnterpriseAdminUpdateAttributeForEnterpriseUserRequestOptions = {
    method: "PATCH";
    url: "/scim/v2/enterprises/:enterprise/Users/:scim_user_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminUpdateAttributeForEnterpriseUserResponseData {
    schemas: string[];
    id: string;
    externalId: string;
    userName: string;
    name: {
        givenName: string;
        familyName: string;
    };
    emails: {
        value: string;
        type: string;
        primary: boolean;
    }[];
    groups: {
        value: string;
    }[];
    active: boolean;
    meta: {
        resourceType: string;
        created: string;
        lastModified: string;
        location: string;
    };
}
declare type EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseEndpoint = {
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Name of the runner group.
     */
    name?: string;
    /**
     * Visibility of a runner group. You can select all organizations or select individual organizations. Can be one of: `all` or `selected`
     */
    visibility?: "selected" | "all";
};
declare type EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseRequestOptions = {
    method: "PATCH";
    url: "/enterprises/:enterprise/actions/runner-groups/:runner_group_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseResponseData {
    id: number;
    name: string;
    visibility: string;
    default: boolean;
    selected_organizations_url: string;
    runners_url: string;
}
declare type GistsCheckIsStarredEndpoint = {
    gist_id: string;
};
declare type GistsCheckIsStarredRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsCreateEndpoint = {
    /**
     * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
     */
    files: GistsCreateParamsFiles;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * When `true`, the gist will be public and available for anyone to see.
     */
    public?: boolean;
};
declare type GistsCreateRequestOptions = {
    method: "POST";
    url: "/gists";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsCreateResponseData {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            truncated?: boolean;
            content?: string;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
    forks: {
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        url: string;
        id: string;
        created_at: string;
        updated_at: string;
    }[];
    history: {
        url: string;
        version: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        change_status: {
            deletions: number;
            additions: number;
            total: number;
        };
        committed_at: string;
    }[];
}
declare type GistsCreateCommentEndpoint = {
    gist_id: string;
    /**
     * The comment text.
     */
    body: string;
};
declare type GistsCreateCommentRequestOptions = {
    method: "POST";
    url: "/gists/:gist_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsCreateCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type GistsDeleteEndpoint = {
    gist_id: string;
};
declare type GistsDeleteRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsDeleteCommentEndpoint = {
    gist_id: string;
    comment_id: number;
};
declare type GistsDeleteCommentRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsForkEndpoint = {
    gist_id: string;
};
declare type GistsForkRequestOptions = {
    method: "POST";
    url: "/gists/:gist_id/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsForkResponseData {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
}
declare type GistsGetEndpoint = {
    gist_id: string;
};
declare type GistsGetRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsGetResponseData {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            truncated?: boolean;
            content?: string;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
    forks: {
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        url: string;
        id: string;
        created_at: string;
        updated_at: string;
    }[];
    history: {
        url: string;
        version: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        change_status: {
            deletions: number;
            additions: number;
            total: number;
        };
        committed_at: string;
    }[];
}
declare type GistsGetCommentEndpoint = {
    gist_id: string;
    comment_id: number;
};
declare type GistsGetCommentRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsGetCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type GistsGetRevisionEndpoint = {
    gist_id: string;
    sha: string;
};
declare type GistsGetRevisionRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/:sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsGetRevisionResponseData {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            truncated?: boolean;
            content?: string;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
    forks: {
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        url: string;
        id: string;
        created_at: string;
        updated_at: string;
    }[];
    history: {
        url: string;
        version: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        change_status: {
            deletions: number;
            additions: number;
            total: number;
        };
        committed_at: string;
    }[];
}
declare type GistsListEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListRequestOptions = {
    method: "GET";
    url: "/gists";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
}[];
declare type GistsListCommentsEndpoint = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListCommentsRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListCommentsResponseData = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type GistsListCommitsEndpoint = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListCommitsRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListCommitsResponseData = {
    url: string;
    version: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    change_status: {
        deletions: number;
        additions: number;
        total: number;
    };
    committed_at: string;
}[];
declare type GistsListForUserEndpoint = {
    username: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/gists";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListForUserResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
}[];
declare type GistsListForksEndpoint = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListForksRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListForksResponseData = {
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
}[];
declare type GistsListPublicEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListPublicRequestOptions = {
    method: "GET";
    url: "/gists/public";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListPublicResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
}[];
declare type GistsListStarredEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListStarredRequestOptions = {
    method: "GET";
    url: "/gists/starred";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GistsListStarredResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
}[];
declare type GistsStarEndpoint = {
    gist_id: string;
};
declare type GistsStarRequestOptions = {
    method: "PUT";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsUnstarEndpoint = {
    gist_id: string;
};
declare type GistsUnstarRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsUpdateEndpoint = {
    gist_id: string;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content that make up this gist.
     */
    files?: GistsUpdateParamsFiles;
};
declare type GistsUpdateRequestOptions = {
    method: "PATCH";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsUpdateResponseData {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: {
        [k: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
            truncated?: boolean;
            content?: string;
            [k: string]: unknown;
        };
    };
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: string;
    comments_url: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    truncated: boolean;
    forks: {
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        url: string;
        id: string;
        created_at: string;
        updated_at: string;
    }[];
    history: {
        url: string;
        version: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        change_status: {
            deletions: number;
            additions: number;
            total: number;
        };
        committed_at: string;
    }[];
}
declare type GistsUpdateCommentEndpoint = {
    gist_id: string;
    comment_id: number;
    /**
     * The comment text.
     */
    body: string;
};
declare type GistsUpdateCommentRequestOptions = {
    method: "PATCH";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GistsUpdateCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type GitCreateBlobEndpoint = {
    owner: string;
    repo: string;
    /**
     * The new blob's content.
     */
    content: string;
    /**
     * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
     */
    encoding?: string;
};
declare type GitCreateBlobRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/blobs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitCreateBlobResponseData {
    url: string;
    sha: string;
}
declare type GitCreateCommitEndpoint = {
    owner: string;
    repo: string;
    /**
     * The commit message
     */
    message: string;
    /**
     * The SHA of the tree object this commit points to
     */
    tree: string;
    /**
     * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
     */
    parents: string[];
    /**
     * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
     */
    author?: GitCreateCommitParamsAuthor;
    /**
     * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
     */
    committer?: GitCreateCommitParamsCommitter;
    /**
     * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
     */
    signature?: string;
};
declare type GitCreateCommitRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitCreateCommitResponseData {
    sha: string;
    node_id: string;
    url: string;
    author: {
        date: string;
        name: string;
        email: string;
    };
    committer: {
        date: string;
        name: string;
        email: string;
    };
    message: string;
    tree: {
        url: string;
        sha: string;
    };
    parents: {
        url: string;
        sha: string;
    }[];
    verification: {
        verified: boolean;
        reason: string;
        signature: string;
        payload: string;
    };
}
declare type GitCreateRefEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
     */
    ref: string;
    /**
     * The SHA1 value for this reference.
     */
    sha: string;
};
declare type GitCreateRefRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/refs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitCreateRefResponseData {
    ref: string;
    node_id: string;
    url: string;
    object: {
        type: string;
        sha: string;
        url: string;
    };
}
declare type GitCreateTagEndpoint = {
    owner: string;
    repo: string;
    /**
     * The tag's name. This is typically a version (e.g., "v0.0.1").
     */
    tag: string;
    /**
     * The tag message.
     */
    message: string;
    /**
     * The SHA of the git object this is tagging.
     */
    object: string;
    /**
     * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
     */
    type: "commit" | "tree" | "blob";
    /**
     * An object with information about the individual creating the tag.
     */
    tagger?: GitCreateTagParamsTagger;
};
declare type GitCreateTagRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/tags";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitCreateTagResponseData {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: {
        name: string;
        email: string;
        date: string;
    };
    object: {
        type: string;
        sha: string;
        url: string;
    };
    verification: {
        verified: boolean;
        reason: string;
        signature: string;
        payload: string;
    };
}
declare type GitCreateTreeEndpoint = {
    owner: string;
    repo: string;
    /**
     * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
     */
    tree: GitCreateTreeParamsTree[];
    /**
     * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
     */
    base_tree?: string;
};
declare type GitCreateTreeRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/trees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitCreateTreeResponseData {
    sha: string;
    url: string;
    tree: {
        path: string;
        mode: string;
        type: string;
        size: number;
        sha: string;
        url: string;
    }[];
}
declare type GitDeleteRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
};
declare type GitDeleteRefRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/git/refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetBlobEndpoint = {
    owner: string;
    repo: string;
    file_sha: string;
};
declare type GitGetBlobRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/blobs/:file_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitGetBlobResponseData {
    content: string;
    encoding: string;
    url: string;
    sha: string;
    size: number;
}
declare type GitGetCommitEndpoint = {
    owner: string;
    repo: string;
    commit_sha: string;
};
declare type GitGetCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/commits/:commit_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitGetCommitResponseData {
    sha: string;
    node_id: string;
    url: string;
    author: {
        date: string;
        name: string;
        email: string;
    };
    committer: {
        date: string;
        name: string;
        email: string;
    };
    message: string;
    tree: {
        url: string;
        sha: string;
    };
    parents: {
        url: string;
        sha: string;
    }[];
    verification: {
        verified: boolean;
        reason: string;
        signature: string;
        payload: string;
    };
}
declare type GitGetRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
};
declare type GitGetRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/ref/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitGetRefResponseData {
    ref: string;
    node_id: string;
    url: string;
    object: {
        type: string;
        sha: string;
        url: string;
    };
}
declare type GitGetTagEndpoint = {
    owner: string;
    repo: string;
    tag_sha: string;
};
declare type GitGetTagRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/tags/:tag_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitGetTagResponseData {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: {
        name: string;
        email: string;
        date: string;
    };
    object: {
        type: string;
        sha: string;
        url: string;
    };
    verification: {
        verified: boolean;
        reason: string;
        signature: string;
        payload: string;
    };
}
declare type GitGetTreeEndpoint = {
    owner: string;
    repo: string;
    tree_sha: string;
    /**
     * Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `"true"`, and `"false"`. Omit this parameter to prevent recursively returning objects or subtrees.
     */
    recursive?: string;
};
declare type GitGetTreeRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/trees/:tree_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitGetTreeResponseData {
    sha: string;
    url: string;
    tree: {
        path: string;
        mode: string;
        type: string;
        size: number;
        sha: string;
        url: string;
    }[];
    truncated: boolean;
}
declare type GitListMatchingRefsEndpoint = {
    owner: string;
    repo: string;
    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GitListMatchingRefsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/matching-refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GitListMatchingRefsResponseData = {
    ref: string;
    node_id: string;
    url: string;
    object: {
        type: string;
        sha: string;
        url: string;
    };
}[];
declare type GitUpdateRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
    /**
     * The SHA1 value to set this reference to
     */
    sha: string;
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
     */
    force?: boolean;
};
declare type GitUpdateRefRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/git/refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitUpdateRefResponseData {
    ref: string;
    node_id: string;
    url: string;
    object: {
        type: string;
        sha: string;
        url: string;
    };
}
declare type GitignoreGetAllTemplatesEndpoint = {};
declare type GitignoreGetAllTemplatesRequestOptions = {
    method: "GET";
    url: "/gitignore/templates";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type GitignoreGetAllTemplatesResponseData = string[];
declare type GitignoreGetTemplateEndpoint = {
    name: string;
};
declare type GitignoreGetTemplateRequestOptions = {
    method: "GET";
    url: "/gitignore/templates/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface GitignoreGetTemplateResponseData {
    name: string;
    source: string;
}
declare type InteractionsGetRestrictionsForOrgEndpoint = {
    org: string;
} & RequiredPreview<"sombra">;
declare type InteractionsGetRestrictionsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface InteractionsGetRestrictionsForOrgResponseData {
    limit: string;
    origin: string;
    expires_at: string;
}
declare type InteractionsGetRestrictionsForRepoEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"sombra">;
declare type InteractionsGetRestrictionsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface InteractionsGetRestrictionsForRepoResponseData {
    limit: string;
    origin: string;
    expires_at: string;
}
declare type InteractionsRemoveRestrictionsForOrgEndpoint = {
    org: string;
} & RequiredPreview<"sombra">;
declare type InteractionsRemoveRestrictionsForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsRemoveRestrictionsForRepoEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"sombra">;
declare type InteractionsRemoveRestrictionsForRepoRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsSetRestrictionsForOrgEndpoint = {
    org: string;
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;
declare type InteractionsSetRestrictionsForOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface InteractionsSetRestrictionsForOrgResponseData {
    limit: string;
    origin: string;
    expires_at: string;
}
declare type InteractionsSetRestrictionsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;
declare type InteractionsSetRestrictionsForRepoRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface InteractionsSetRestrictionsForRepoResponseData {
    limit: string;
    origin: string;
    expires_at: string;
}
declare type IssuesAddAssigneesEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
};
declare type IssuesAddAssigneesRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesAddAssigneesResponseData {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
}
declare type IssuesAddLabelsEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
};
declare type IssuesAddLabelsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesAddLabelsResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesCheckUserCanBeAssignedEndpoint = {
    owner: string;
    repo: string;
    assignee: string;
};
declare type IssuesCheckUserCanBeAssignedRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/assignees/:assignee";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesCreateEndpoint = {
    owner: string;
    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
     */
    assignee?: string;
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
};
declare type IssuesCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesCreateResponseData {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    closed_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type IssuesCreateCommentEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The contents of the comment.
     */
    body: string;
};
declare type IssuesCreateCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesCreateCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type IssuesCreateLabelEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color: string;
    /**
     * A short description of the label.
     */
    description?: string;
};
declare type IssuesCreateLabelRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesCreateLabelResponseData {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}
declare type IssuesCreateMilestoneEndpoint = {
    owner: string;
    repo: string;
    /**
     * The title of the milestone.
     */
    title: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
};
declare type IssuesCreateMilestoneRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/milestones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesCreateMilestoneResponseData {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
}
declare type IssuesDeleteCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type IssuesDeleteCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesDeleteLabelEndpoint = {
    owner: string;
    repo: string;
    name: string;
};
declare type IssuesDeleteLabelRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesDeleteMilestoneEndpoint = {
    owner: string;
    repo: string;
    milestone_number: number;
};
declare type IssuesDeleteMilestoneRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
};
declare type IssuesGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesGetResponseData {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    closed_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type IssuesGetCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type IssuesGetCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesGetCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type IssuesGetEventEndpoint = {
    owner: string;
    repo: string;
    event_id: number;
};
declare type IssuesGetEventRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/events/:event_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesGetEventResponseData {
    id: number;
    node_id: string;
    url: string;
    actor: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: {
        id: number;
        node_id: string;
        url: string;
        repository_url: string;
        labels_url: string;
        comments_url: string;
        events_url: string;
        html_url: string;
        number: number;
        state: string;
        title: string;
        body: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        labels: {
            id: number;
            node_id: string;
            url: string;
            name: string;
            description: string;
            color: string;
            default: boolean;
        }[];
        assignee: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        assignees: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        }[];
        milestone: {
            url: string;
            html_url: string;
            labels_url: string;
            id: number;
            node_id: string;
            number: number;
            state: string;
            title: string;
            description: string;
            creator: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            open_issues: number;
            closed_issues: number;
            created_at: string;
            updated_at: string;
            closed_at: string;
            due_on: string;
        };
        locked: boolean;
        active_lock_reason: string;
        comments: number;
        pull_request: {
            url: string;
            html_url: string;
            diff_url: string;
            patch_url: string;
        };
        closed_at: string;
        created_at: string;
        updated_at: string;
    };
}
declare type IssuesGetLabelEndpoint = {
    owner: string;
    repo: string;
    name: string;
};
declare type IssuesGetLabelRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesGetLabelResponseData {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}
declare type IssuesGetMilestoneEndpoint = {
    owner: string;
    repo: string;
    milestone_number: number;
};
declare type IssuesGetMilestoneRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesGetMilestoneResponseData {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
}
declare type IssuesListEndpoint = {
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListRequestOptions = {
    method: "GET";
    url: "/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}[];
declare type IssuesListAssigneesEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListAssigneesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListAssigneesResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type IssuesListCommentsEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListCommentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListCommentsResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type IssuesListCommentsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Either `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * Either `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListCommentsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListCommentsForRepoResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type IssuesListEventsEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListEventsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListEventsResponseData = {
    id: number;
    node_id: string;
    url: string;
    actor: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
}[];
declare type IssuesListEventsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListEventsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListEventsForRepoResponseData = {
    id: number;
    node_id: string;
    url: string;
    actor: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: {
        id: number;
        node_id: string;
        url: string;
        repository_url: string;
        labels_url: string;
        comments_url: string;
        events_url: string;
        html_url: string;
        number: number;
        state: string;
        title: string;
        body: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        labels: {
            id: number;
            node_id: string;
            url: string;
            name: string;
            description: string;
            color: string;
            default: boolean;
        }[];
        assignee: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        assignees: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        }[];
        milestone: {
            url: string;
            html_url: string;
            labels_url: string;
            id: number;
            node_id: string;
            number: number;
            state: string;
            title: string;
            description: string;
            creator: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            open_issues: number;
            closed_issues: number;
            created_at: string;
            updated_at: string;
            closed_at: string;
            due_on: string;
        };
        locked: boolean;
        active_lock_reason: string;
        comments: number;
        pull_request: {
            url: string;
            html_url: string;
            diff_url: string;
            patch_url: string;
        };
        closed_at: string;
        created_at: string;
        updated_at: string;
    };
}[];
declare type IssuesListEventsForTimelineEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"mockingbird">;
declare type IssuesListEventsForTimelineRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/timeline";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListEventsForTimelineResponseData = {
    id: number;
    node_id: string;
    url: string;
    actor: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
}[];
declare type IssuesListForAuthenticatedUserEndpoint = {
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListForAuthenticatedUserResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}[];
declare type IssuesListForOrgEndpoint = {
    org: string;
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListForOrgResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
}[];
declare type IssuesListForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
     */
    milestone?: string;
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
     */
    assignee?: string;
    /**
     * The user that created the issue.
     */
    creator?: string;
    /**
     * A user that's mentioned in the issue.
     */
    mentioned?: string;
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListForRepoResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
}[];
declare type IssuesListLabelsForMilestoneEndpoint = {
    owner: string;
    repo: string;
    milestone_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsForMilestoneRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones/:milestone_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListLabelsForMilestoneResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesListLabelsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListLabelsForRepoResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesListLabelsOnIssueEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsOnIssueRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListLabelsOnIssueResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesListMilestonesEndpoint = {
    owner: string;
    repo: string;
    /**
     * The state of the milestone. Either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * What to sort results by. Either `due_on` or `completeness`.
     */
    sort?: "due_on" | "completeness";
    /**
     * The direction of the sort. Either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListMilestonesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesListMilestonesResponseData = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
}[];
declare type IssuesLockEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
};
declare type IssuesLockRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/issues/:issue_number/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesRemoveAllLabelsEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
};
declare type IssuesRemoveAllLabelsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesRemoveAssigneesEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
};
declare type IssuesRemoveAssigneesRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesRemoveAssigneesResponseData {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
}
declare type IssuesRemoveLabelEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    name: string;
};
declare type IssuesRemoveLabelRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesRemoveLabelResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesSetLabelsEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
};
declare type IssuesSetLabelsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type IssuesSetLabelsResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}[];
declare type IssuesUnlockEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
};
declare type IssuesUnlockRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUpdateEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The title of the issue.
     */
    title?: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. **This field is deprecated.**
     */
    assignee?: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
};
declare type IssuesUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/issues/:issue_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesUpdateResponseData {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: {
        url: string;
        html_url: string;
        diff_url: string;
        patch_url: string;
    };
    closed_at: string;
    created_at: string;
    updated_at: string;
    closed_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type IssuesUpdateCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * The contents of the comment.
     */
    body: string;
};
declare type IssuesUpdateCommentRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesUpdateCommentResponseData {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type IssuesUpdateLabelEndpoint = {
    owner: string;
    repo: string;
    name: string;
    /**
     * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    new_name?: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color?: string;
    /**
     * A short description of the label.
     */
    description?: string;
};
declare type IssuesUpdateLabelRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesUpdateLabelResponseData {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
}
declare type IssuesUpdateMilestoneEndpoint = {
    owner: string;
    repo: string;
    milestone_number: number;
    /**
     * The title of the milestone.
     */
    title?: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
};
declare type IssuesUpdateMilestoneRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface IssuesUpdateMilestoneResponseData {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
}
declare type LicensesGetEndpoint = {
    license: string;
};
declare type LicensesGetRequestOptions = {
    method: "GET";
    url: "/licenses/:license";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface LicensesGetResponseData {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
    html_url: string;
    description: string;
    implementation: string;
    permissions: string[];
    conditions: string[];
    limitations: string[];
    body: string;
    featured: boolean;
}
declare type LicensesGetAllCommonlyUsedEndpoint = {};
declare type LicensesGetAllCommonlyUsedRequestOptions = {
    method: "GET";
    url: "/licenses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type LicensesGetAllCommonlyUsedResponseData = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
}[];
declare type LicensesGetForRepoEndpoint = {
    owner: string;
    repo: string;
};
declare type LicensesGetForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/license";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface LicensesGetForRepoResponseData {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    content: string;
    encoding: string;
    _links: {
        self: string;
        git: string;
        html: string;
    };
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}
declare type MarkdownRenderEndpoint = {
    /**
     * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
     */
    text: string;
    /**
     * The rendering mode. Can be either:
     * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
     * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
     */
    mode?: "markdown" | "gfm";
    /**
     * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
     */
    context?: string;
};
declare type MarkdownRenderRequestOptions = {
    method: "POST";
    url: "/markdown";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MarkdownRenderRawEndpoint = {
    /**
     * data parameter
     */
    data: string;
} & {
    headers: {
        "content-type": "text/plain; charset=utf-8";
    };
};
declare type MarkdownRenderRawRequestOptions = {
    method: "POST";
    url: "/markdown/raw";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MetaGetEndpoint = {};
declare type MetaGetRequestOptions = {
    method: "GET";
    url: "/meta";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MetaGetResponseData {
    verifiable_password_authentication: boolean;
    ssh_key_fingerprints: {
        MD5_RSA: string;
        MD5_DSA: string;
        SHA256_RSA: string;
        SHA256_DSA: string;
    };
    hooks: string[];
    web: string[];
    api: string[];
    git: string[];
    pages: string[];
    importer: string[];
}
declare type MigrationsCancelImportEndpoint = {
    owner: string;
    repo: string;
};
declare type MigrationsCancelImportRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsDeleteArchiveForAuthenticatedUserEndpoint = {
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsDeleteArchiveForAuthenticatedUserRequestOptions = {
    method: "DELETE";
    url: "/user/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsDeleteArchiveForOrgEndpoint = {
    org: string;
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsDeleteArchiveForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsDownloadArchiveForOrgEndpoint = {
    org: string;
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsDownloadArchiveForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetArchiveForAuthenticatedUserEndpoint = {
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsGetArchiveForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetCommitAuthorsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
     */
    since?: string;
};
declare type MigrationsGetCommitAuthorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import/authors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsGetCommitAuthorsResponseData = {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
}[];
declare type MigrationsGetImportStatusEndpoint = {
    owner: string;
    repo: string;
};
declare type MigrationsGetImportStatusRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsGetImportStatusResponseData {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
}
declare type MigrationsGetLargeFilesEndpoint = {
    owner: string;
    repo: string;
};
declare type MigrationsGetLargeFilesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import/large_files";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsGetLargeFilesResponseData = {
    ref_name: string;
    path: string;
    oid: string;
    size: number;
}[];
declare type MigrationsGetStatusForAuthenticatedUserEndpoint = {
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsGetStatusForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/migrations/:migration_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsGetStatusForAuthenticatedUserResponseData {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}
declare type MigrationsGetStatusForOrgEndpoint = {
    org: string;
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsGetStatusForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsGetStatusForOrgResponseData {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}
declare type MigrationsListForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsListForAuthenticatedUserResponseData = {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}[];
declare type MigrationsListForOrgEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsListForOrgResponseData = {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}[];
declare type MigrationsListReposForOrgEndpoint = {
    org: string;
    migration_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListReposForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsListReposForOrgResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type MigrationsListReposForUserEndpoint = {
    migration_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListReposForUserRequestOptions = {
    method: "GET";
    url: "/user/migrations/:migration_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type MigrationsListReposForUserResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type MigrationsMapCommitAuthorEndpoint = {
    owner: string;
    repo: string;
    author_id: number;
    /**
     * The new Git author email.
     */
    email?: string;
    /**
     * The new Git author name.
     */
    name?: string;
};
declare type MigrationsMapCommitAuthorRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import/authors/:author_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsMapCommitAuthorResponseData {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
}
declare type MigrationsSetLfsPreferenceEndpoint = {
    owner: string;
    repo: string;
    /**
     * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
     */
    use_lfs: "opt_in" | "opt_out";
};
declare type MigrationsSetLfsPreferenceRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import/lfs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsSetLfsPreferenceResponseData {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
}
declare type MigrationsStartForAuthenticatedUserEndpoint = {
    /**
     * An array of repositories to include in the migration.
     */
    repositories: string[];
    /**
     * Locks the `repositories` to prevent changes during the migration when set to `true`.
     */
    lock_repositories?: boolean;
    /**
     * Does not include attachments uploaded to GitHub.com in the migration data when set to `true`. Excluding attachments will reduce the migration archive file size.
     */
    exclude_attachments?: boolean;
};
declare type MigrationsStartForAuthenticatedUserRequestOptions = {
    method: "POST";
    url: "/user/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsStartForAuthenticatedUserResponseData {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}
declare type MigrationsStartForOrgEndpoint = {
    org: string;
    /**
     * A list of arrays indicating which repositories should be migrated.
     */
    repositories: string[];
    /**
     * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
     */
    lock_repositories?: boolean;
    /**
     * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
     */
    exclude_attachments?: boolean;
};
declare type MigrationsStartForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsStartForOrgResponseData {
    id: number;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    }[];
    url: string;
    created_at: string;
    updated_at: string;
}
declare type MigrationsStartImportEndpoint = {
    owner: string;
    repo: string;
    /**
     * The URL of the originating repository.
     */
    vcs_url: string;
    /**
     * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
     */
    vcs?: "subversion" | "git" | "mercurial" | "tfvc";
    /**
     * If authentication is required, the username to provide to `vcs_url`.
     */
    vcs_username?: string;
    /**
     * If authentication is required, the password to provide to `vcs_url`.
     */
    vcs_password?: string;
    /**
     * For a tfvc import, the name of the project that is being imported.
     */
    tfvc_project?: string;
};
declare type MigrationsStartImportRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsStartImportResponseData {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    percent: number;
    commit_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
    tfvc_project: string;
}
declare type MigrationsUnlockRepoForAuthenticatedUserEndpoint = {
    migration_id: number;
    repo_name: string;
} & RequiredPreview<"wyandotte">;
declare type MigrationsUnlockRepoForAuthenticatedUserRequestOptions = {
    method: "DELETE";
    url: "/user/migrations/:migration_id/repos/:repo_name/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsUnlockRepoForOrgEndpoint = {
    org: string;
    migration_id: number;
    repo_name: string;
} & RequiredPreview<"wyandotte">;
declare type MigrationsUnlockRepoForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/migrations/:migration_id/repos/:repo_name/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsUpdateImportEndpoint = {
    owner: string;
    repo: string;
    /**
     * The username to provide to the originating repository.
     */
    vcs_username?: string;
    /**
     * The password to provide to the originating repository.
     */
    vcs_password?: string;
};
declare type MigrationsUpdateImportRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface MigrationsUpdateImportResponseData {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    percent: number;
    commit_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
    tfvc_project: string;
}
declare type OauthAuthorizationsCreateAuthorizationEndpoint = {
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * The 20 character OAuth app client key for which to create the token.
     */
    client_id?: string;
    /**
     * The 40 character OAuth app client secret for which to create the token.
     */
    client_secret?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsCreateAuthorizationRequestOptions = {
    method: "POST";
    url: "/authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsCreateAuthorizationResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
declare type OauthAuthorizationsDeleteAuthorizationEndpoint = {
    authorization_id: number;
};
declare type OauthAuthorizationsDeleteAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsDeleteGrantEndpoint = {
    grant_id: number;
};
declare type OauthAuthorizationsDeleteGrantRequestOptions = {
    method: "DELETE";
    url: "/applications/grants/:grant_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsGetAuthorizationEndpoint = {
    authorization_id: number;
};
declare type OauthAuthorizationsGetAuthorizationRequestOptions = {
    method: "GET";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsGetAuthorizationResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
declare type OauthAuthorizationsGetGrantEndpoint = {
    grant_id: number;
};
declare type OauthAuthorizationsGetGrantRequestOptions = {
    method: "GET";
    url: "/applications/grants/:grant_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsGetGrantResponseData {
    id: number;
    url: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    created_at: string;
    updated_at: string;
    scopes: string[];
}
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions = {
    method: "PUT";
    url: "/authorizations/clients/:client_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
export interface OauthAuthorizationsGetOrCreateAuthorizationForAppResponse201Data {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint = {
    client_id: string;
    fingerprint: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions = {
    method: "PUT";
    url: "/authorizations/clients/:client_id/:fingerprint";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
export interface OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponse201Data {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
declare type OauthAuthorizationsListAuthorizationsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OauthAuthorizationsListAuthorizationsRequestOptions = {
    method: "GET";
    url: "/authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OauthAuthorizationsListAuthorizationsResponseData = {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}[];
declare type OauthAuthorizationsListGrantsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OauthAuthorizationsListGrantsRequestOptions = {
    method: "GET";
    url: "/applications/grants";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OauthAuthorizationsListGrantsResponseData = {
    id: number;
    url: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    created_at: string;
    updated_at: string;
    scopes: string[];
}[];
declare type OauthAuthorizationsUpdateAuthorizationEndpoint = {
    authorization_id: number;
    /**
     * Replaces the authorization scopes with these.
     */
    scopes?: string[];
    /**
     * A list of scopes to add to this authorization.
     */
    add_scopes?: string[];
    /**
     * A list of scopes to remove from this authorization.
     */
    remove_scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsUpdateAuthorizationRequestOptions = {
    method: "PATCH";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OauthAuthorizationsUpdateAuthorizationResponseData {
    id: number;
    url: string;
    scopes: string[];
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: {
        url: string;
        name: string;
        client_id: string;
    };
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
}
declare type OrgsBlockUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsBlockUserRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsCheckBlockedUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsCheckBlockedUserRequestOptions = {
    method: "GET";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsCheckMembershipForUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsCheckMembershipForUserRequestOptions = {
    method: "GET";
    url: "/orgs/:org/members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsCheckPublicMembershipForUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsCheckPublicMembershipForUserRequestOptions = {
    method: "GET";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsConvertMemberToOutsideCollaboratorEndpoint = {
    org: string;
    username: string;
};
declare type OrgsConvertMemberToOutsideCollaboratorRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/outside_collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsConvertMemberToOutsideCollaboratorResponseData {
    message: string;
    documentation_url: string;
}
declare type OrgsCreateInvitationEndpoint = {
    org: string;
    /**
     * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
     */
    invitee_id?: number;
    /**
     * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
     */
    email?: string;
    /**
     * Specify role for new member. Can be one of:
     * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
     * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
     * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
     */
    role?: "admin" | "direct_member" | "billing_manager";
    /**
     * Specify IDs for the teams you want to invite new members to.
     */
    team_ids?: number[];
};
declare type OrgsCreateInvitationRequestOptions = {
    method: "POST";
    url: "/orgs/:org/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsCreateInvitationResponseData {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    team_count: number;
    invitation_team_url: string;
}
declare type OrgsCreateWebhookEndpoint = {
    org: string;
    /**
     * Must be passed as "web".
     */
    name: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
     */
    config: OrgsCreateWebhookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/webhooks/event-payloads) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type OrgsCreateWebhookRequestOptions = {
    method: "POST";
    url: "/orgs/:org/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsCreateWebhookResponseData {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: string[];
    active: boolean;
    config: {
        url: string;
        content_type: string;
    };
    updated_at: string;
    created_at: string;
}
declare type OrgsDeleteWebhookEndpoint = {
    org: string;
    hook_id: number;
};
declare type OrgsDeleteWebhookRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsGetEndpoint = {
    org: string;
};
declare type OrgsGetRequestOptions = {
    method: "GET";
    url: "/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsGetResponseData {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    twitter_username: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    billing_email: string;
    plan: {
        name: string;
        space: number;
        private_repos: number;
        seats: number;
        filled_seats: number;
    };
    default_repository_permission: string;
    members_can_create_repositories: boolean;
    two_factor_requirement_enabled: boolean;
    members_allowed_repository_creation_type: string;
    members_can_create_public_repositories: boolean;
    members_can_create_private_repositories: boolean;
    members_can_create_internal_repositories: boolean;
}
declare type OrgsGetMembershipForAuthenticatedUserEndpoint = {
    org: string;
};
declare type OrgsGetMembershipForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/memberships/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsGetMembershipForAuthenticatedUserResponseData {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type OrgsGetMembershipForUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsGetMembershipForUserRequestOptions = {
    method: "GET";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsGetMembershipForUserResponseData {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type OrgsGetWebhookEndpoint = {
    org: string;
    hook_id: number;
};
declare type OrgsGetWebhookRequestOptions = {
    method: "GET";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsGetWebhookResponseData {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: string[];
    active: boolean;
    config: {
        url: string;
        content_type: string;
    };
    updated_at: string;
    created_at: string;
}
declare type OrgsListEndpoint = {
    /**
     * The integer ID of the last organization that you've seen.
     */
    since?: number;
};
declare type OrgsListRequestOptions = {
    method: "GET";
    url: "/organizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListResponseData = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
}[];
declare type OrgsListAppInstallationsEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListAppInstallationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/installations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsListAppInstallationsResponseData {
    total_count: number;
    installations: {
        id: number;
        account: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repository_selection: "all" | "selected";
        access_tokens_url: string;
        repositories_url: string;
        html_url: string;
        app_id: number;
        target_id: number;
        target_type: string;
        permissions: {
            deployments: string;
            metadata: string;
            pull_requests: string;
            statuses: string;
        };
        events: string[];
        created_at: string;
        updated_at: string;
        single_file_name: string;
    }[];
}
declare type OrgsListBlockedUsersEndpoint = {
    org: string;
};
declare type OrgsListBlockedUsersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/blocks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListBlockedUsersResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type OrgsListForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/orgs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListForAuthenticatedUserResponseData = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
}[];
declare type OrgsListForUserEndpoint = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/orgs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListForUserResponseData = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
}[];
declare type OrgsListInvitationTeamsEndpoint = {
    org: string;
    invitation_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListInvitationTeamsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/invitations/:invitation_id/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListInvitationTeamsResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: {
        [k: string]: unknown;
    };
}[];
declare type OrgsListMembersEndpoint = {
    org: string;
    /**
     * Filter members returned in the list. Can be one of:
     * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
     * \* `all` - All members the authenticated user can see.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Filter members returned by their role. Can be one of:
     * \* `all` - All members of the organization, regardless of role.
     * \* `admin` - Organization owners.
     * \* `member` - Non-owner organization members.
     */
    role?: "all" | "admin" | "member";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListMembersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/members";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListMembersResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type OrgsListMembershipsForAuthenticatedUserEndpoint = {
    /**
     * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
     */
    state?: "active" | "pending";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListMembershipsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/memberships/orgs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListMembershipsForAuthenticatedUserResponseData = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}[];
declare type OrgsListOutsideCollaboratorsEndpoint = {
    org: string;
    /**
     * Filter the list of outside collaborators. Can be one of:
     * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
     * \* `all`: All outside collaborators.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListOutsideCollaboratorsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/outside_collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListOutsideCollaboratorsResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type OrgsListPendingInvitationsEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListPendingInvitationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListPendingInvitationsResponseData = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    team_count: number;
    invitation_team_url: string;
}[];
declare type OrgsListPublicMembersEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListPublicMembersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/public_members";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListPublicMembersResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type OrgsListSamlSsoAuthorizationsEndpoint = {
    org: string;
};
declare type OrgsListSamlSsoAuthorizationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/credential-authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListSamlSsoAuthorizationsResponseData = {
    login: string;
    credential_id: string;
    credential_type: string;
    token_last_eight: string;
    credential_authorized_at: string;
    scopes: string[];
}[];
declare type OrgsListWebhooksEndpoint = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListWebhooksRequestOptions = {
    method: "GET";
    url: "/orgs/:org/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type OrgsListWebhooksResponseData = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: string[];
    active: boolean;
    config: {
        url: string;
        content_type: string;
    };
    updated_at: string;
    created_at: string;
}[];
declare type OrgsPingWebhookEndpoint = {
    org: string;
    hook_id: number;
};
declare type OrgsPingWebhookRequestOptions = {
    method: "POST";
    url: "/orgs/:org/hooks/:hook_id/pings";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveMemberEndpoint = {
    org: string;
    username: string;
};
declare type OrgsRemoveMemberRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveMembershipForUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsRemoveMembershipForUserRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveOutsideCollaboratorEndpoint = {
    org: string;
    username: string;
};
declare type OrgsRemoveOutsideCollaboratorRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/outside_collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsRemoveOutsideCollaboratorResponseData {
    message: string;
    documentation_url: string;
}
declare type OrgsRemovePublicMembershipForAuthenticatedUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsRemovePublicMembershipForAuthenticatedUserRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveSamlSsoAuthorizationEndpoint = {
    org: string;
    credential_id: number;
};
declare type OrgsRemoveSamlSsoAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/credential-authorizations/:credential_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsSetMembershipForUserEndpoint = {
    org: string;
    username: string;
    /**
     * The role to give the user in the organization. Can be one of:
     * \* `admin` - The user will become an owner of the organization.
     * \* `member` - The user will become a non-owner member of the organization.
     */
    role?: "admin" | "member";
};
declare type OrgsSetMembershipForUserRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsSetMembershipForUserResponseData {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type OrgsSetPublicMembershipForAuthenticatedUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsSetPublicMembershipForAuthenticatedUserRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsUnblockUserEndpoint = {
    org: string;
    username: string;
};
declare type OrgsUnblockUserRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsUpdateEndpoint = {
    org: string;
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * The Twitter username of the company.
     */
    twitter_username?: string;
    /**
     * The location.
     */
    location?: string;
    /**
     * The shorthand name of the company.
     */
    name?: string;
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)".
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)".
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)".
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Specifies which types of repositories non-admin organization members can create. Can be one of:
     * \* `all` - all organization members can create public and private repositories.
     * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
     * \* `none` - only admin members can create repositories.
     * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
     */
    members_allowed_repository_creation_type?: "all" | "private" | "none";
};
declare type OrgsUpdateRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsUpdateResponseData {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    twitter_username: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    billing_email: string;
    plan: {
        name: string;
        space: number;
        private_repos: number;
        seats: number;
        filled_seats: number;
    };
    default_repository_permission: string;
    members_can_create_repositories: boolean;
    two_factor_requirement_enabled: boolean;
    members_allowed_repository_creation_type: string;
    members_can_create_public_repositories: boolean;
    members_can_create_private_repositories: boolean;
    members_can_create_internal_repositories: boolean;
}
declare type OrgsUpdateMembershipForAuthenticatedUserEndpoint = {
    org: string;
    /**
     * The state that the membership should be in. Only `"active"` will be accepted.
     */
    state: "active";
};
declare type OrgsUpdateMembershipForAuthenticatedUserRequestOptions = {
    method: "PATCH";
    url: "/user/memberships/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsUpdateMembershipForAuthenticatedUserResponseData {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type OrgsUpdateWebhookEndpoint = {
    org: string;
    hook_id: number;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
     */
    config?: OrgsUpdateWebhookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/webhooks/event-payloads) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type OrgsUpdateWebhookRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface OrgsUpdateWebhookResponseData {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: string[];
    active: boolean;
    config: {
        url: string;
        content_type: string;
    };
    updated_at: string;
    created_at: string;
}
declare type ProjectsAddCollaboratorEndpoint = {
    project_id: number;
    username: string;
    /**
     * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
     * \* `read` - can read, but not write to or administer this project.
     * \* `write` - can read and write, but not administer this project.
     * \* `admin` - can read, write and administer this project.
     */
    permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;
declare type ProjectsAddCollaboratorRequestOptions = {
    method: "PUT";
    url: "/projects/:project_id/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsCreateCardEndpoint = {
    column_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
     */
    note?: string;
    /**
     * The issue or pull request id you want to associate with this card. You can use the [List repository issues](https://developer.github.com/v3/issues/#list-repository-issues) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
     * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
     */
    content_id?: number;
    /**
     * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
     */
    content_type?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateCardRequestOptions = {
    method: "POST";
    url: "/projects/columns/:column_id/cards";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsCreateCardResponseData {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
}
declare type ProjectsCreateColumnEndpoint = {
    project_id: number;
    /**
     * The name of the column.
     */
    name: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateColumnRequestOptions = {
    method: "POST";
    url: "/projects/:project_id/columns";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsCreateColumnResponseData {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
}
declare type ProjectsCreateForAuthenticatedUserEndpoint = {
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The description of the project.
     */
    body?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateForAuthenticatedUserRequestOptions = {
    method: "POST";
    url: "/user/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsCreateForAuthenticatedUserResponseData {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ProjectsCreateForOrgEndpoint = {
    org: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The description of the project.
     */
    body?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsCreateForOrgResponseData {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ProjectsCreateForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The description of the project.
     */
    body?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsCreateForRepoResponseData {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ProjectsDeleteEndpoint = {
    project_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteRequestOptions = {
    method: "DELETE";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsDeleteCardEndpoint = {
    card_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteCardRequestOptions = {
    method: "DELETE";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsDeleteColumnEndpoint = {
    column_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteColumnRequestOptions = {
    method: "DELETE";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetEndpoint = {
    project_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetRequestOptions = {
    method: "GET";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsGetResponseData {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ProjectsGetCardEndpoint = {
    card_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetCardRequestOptions = {
    method: "GET";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsGetCardResponseData {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
}
declare type ProjectsGetColumnEndpoint = {
    column_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetColumnRequestOptions = {
    method: "GET";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsGetColumnResponseData {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
}
declare type ProjectsGetPermissionForUserEndpoint = {
    project_id: number;
    username: string;
} & RequiredPreview<"inertia">;
declare type ProjectsGetPermissionForUserRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/collaborators/:username/permission";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsGetPermissionForUserResponseData {
    permission: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type ProjectsListCardsEndpoint = {
    column_id: number;
    /**
     * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
     */
    archived_state?: "all" | "archived" | "not_archived";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListCardsRequestOptions = {
    method: "GET";
    url: "/projects/columns/:column_id/cards";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListCardsResponseData = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
}[];
declare type ProjectsListCollaboratorsEndpoint = {
    project_id: number;
    /**
     * Filters the collaborators by their affiliation. Can be one of:
     * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
     * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListCollaboratorsRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListCollaboratorsResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type ProjectsListColumnsEndpoint = {
    project_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListColumnsRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/columns";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListColumnsResponseData = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
}[];
declare type ProjectsListForOrgEndpoint = {
    org: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListForOrgResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type ProjectsListForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListForRepoResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type ProjectsListForUserEndpoint = {
    username: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ProjectsListForUserResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type ProjectsMoveCardEndpoint = {
    card_id: number;
    /**
     * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
     */
    position: string;
    /**
     * The `id` value of a column in the same project.
     */
    column_id?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsMoveCardRequestOptions = {
    method: "POST";
    url: "/projects/columns/cards/:card_id/moves";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsMoveColumnEndpoint = {
    column_id: number;
    /**
     * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
     */
    position: string;
} & RequiredPreview<"inertia">;
declare type ProjectsMoveColumnRequestOptions = {
    method: "POST";
    url: "/projects/columns/:column_id/moves";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsRemoveCollaboratorEndpoint = {
    project_id: number;
    username: string;
} & RequiredPreview<"inertia">;
declare type ProjectsRemoveCollaboratorRequestOptions = {
    method: "DELETE";
    url: "/projects/:project_id/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsUpdateEndpoint = {
    project_id: number;
    /**
     * The name of the project.
     */
    name?: string;
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * State of the project. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project permissions](https://developer.github.com/v3/teams/#add-or-update-team-project-permissions) or [Add project collaborator](https://developer.github.com/v3/projects/collaborators/#add-project-collaborator).
     *
     * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
     *
     * Can be one of:
     * \* `read` - Organization members can read, but not write to or administer this project.
     * \* `write` - Organization members can read and write, but not administer this project.
     * \* `admin` - Organization members can read, write and administer this project.
     * \* `none` - Organization members can only see this project if it is public.
     */
    organization_permission?: string;
    /**
     * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
     *
     * Can be one of:
     * \* `false` - Anyone can see the project.
     * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
     */
    private?: boolean;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateRequestOptions = {
    method: "PATCH";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsUpdateResponseData {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ProjectsUpdateCardEndpoint = {
    card_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
     */
    note?: string;
    /**
     * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
     */
    archived?: boolean;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateCardRequestOptions = {
    method: "PATCH";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsUpdateCardResponseData {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
}
declare type ProjectsUpdateColumnEndpoint = {
    column_id: number;
    /**
     * The new name of the column.
     */
    name: string;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateColumnRequestOptions = {
    method: "PATCH";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ProjectsUpdateColumnResponseData {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
}
declare type PullsCheckIfMergedEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
};
declare type PullsCheckIfMergedRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/merge";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateEndpoint = {
    owner: string;
    repo: string;
    /**
     * The title of the new pull request.
     */
    title: string;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    /**
     * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://docs.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
     */
    draft?: boolean;
};
declare type PullsCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsCreateResponseData {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_reviewers: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    head: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    base: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        issue: {
            href: string;
        };
        comments: {
            href: string;
        };
        review_comments: {
            href: string;
        };
        review_comment: {
            href: string;
        };
        commits: {
            href: string;
        };
        statuses: {
            href: string;
        };
    };
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
}
declare type PullsCreateReplyForReviewCommentEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    comment_id: number;
    /**
     * The text of the review comment.
     */
    body: string;
};
declare type PullsCreateReplyForReviewCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsCreateReplyForReviewCommentResponseData {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}
declare type PullsCreateReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-review-for-a-pull-request) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
};
declare type PullsCreateReviewRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsCreateReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}
declare type PullsCreateReviewCommentEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://docs.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)".
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)".
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)". See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
declare type PullsCreateReviewCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsCreateReviewCommentResponseData {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}
declare type PullsDeletePendingReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
};
declare type PullsDeletePendingReviewRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsDeletePendingReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    commit_id: string;
}
declare type PullsDeleteReviewCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type PullsDeleteReviewCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsDismissReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
    /**
     * The message for the pull request review dismissal
     */
    message: string;
};
declare type PullsDismissReviewRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsDismissReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}
declare type PullsGetEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
};
declare type PullsGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsGetResponseData {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_reviewers: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    head: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    base: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        issue: {
            href: string;
        };
        comments: {
            href: string;
        };
        review_comments: {
            href: string;
        };
        review_comment: {
            href: string;
        };
        commits: {
            href: string;
        };
        statuses: {
            href: string;
        };
    };
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
}
declare type PullsGetReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
};
declare type PullsGetReviewRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsGetReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}
declare type PullsGetReviewCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type PullsGetReviewCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsGetReviewCommentResponseData {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}
declare type PullsListEndpoint = {
    owner: string;
    repo: string;
    /**
     * Either `open`, `closed`, or `all` to filter by state.
     */
    state?: "open" | "closed" | "all";
    /**
     * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
     */
    head?: string;
    /**
     * Filter pulls by base branch name. Example: `gh-pages`.
     */
    base?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
     */
    sort?: "created" | "updated" | "popularity" | "long-running";
    /**
     * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListResponseData = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_reviewers: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    head: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    base: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        issue: {
            href: string;
        };
        comments: {
            href: string;
        };
        review_comments: {
            href: string;
        };
        review_comment: {
            href: string;
        };
        commits: {
            href: string;
        };
        statuses: {
            href: string;
        };
    };
    author_association: string;
    draft: boolean;
}[];
declare type PullsListCommentsForReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListCommentsForReviewRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListCommentsForReviewResponseData = {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
}[];
declare type PullsListCommitsEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListCommitsResponseData = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: {
        url: string;
        author: {
            name: string;
            email: string;
            date: string;
        };
        committer: {
            name: string;
            email: string;
            date: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        comment_count: number;
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    committer: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    parents: {
        url: string;
        sha: string;
    }[];
}[];
declare type PullsListFilesEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListFilesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/files";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListFilesResponseData = {
    sha: string;
    filename: string;
    status: string;
    additions: number;
    deletions: number;
    changes: number;
    blob_url: string;
    raw_url: string;
    contents_url: string;
    patch: string;
}[];
declare type PullsListRequestedReviewersEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListRequestedReviewersRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsListRequestedReviewersResponseData {
    users: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
}
declare type PullsListReviewCommentsEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListReviewCommentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListReviewCommentsResponseData = {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}[];
declare type PullsListReviewCommentsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListReviewCommentsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListReviewCommentsForRepoResponseData = {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}[];
declare type PullsListReviewsEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListReviewsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type PullsListReviewsResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}[];
declare type PullsMergeEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
};
declare type PullsMergeRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/merge";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsMergeResponseData {
    sha: string;
    merged: boolean;
    message: string;
}
export interface PullsMergeResponse405Data {
    message: string;
    documentation_url: string;
}
export interface PullsMergeResponse409Data {
    message: string;
    documentation_url: string;
}
declare type PullsRemoveRequestedReviewersEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
};
declare type PullsRemoveRequestedReviewersRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsRequestReviewersEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
};
declare type PullsRequestReviewersRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsRequestReviewersResponseData {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_reviewers: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    head: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    base: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        issue: {
            href: string;
        };
        comments: {
            href: string;
        };
        review_comments: {
            href: string;
        };
        review_comment: {
            href: string;
        };
        commits: {
            href: string;
        };
        statuses: {
            href: string;
        };
    };
    author_association: string;
    draft: boolean;
}
declare type PullsSubmitReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
};
declare type PullsSubmitReviewRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsSubmitReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}
declare type PullsUpdateEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * The title of the pull request.
     */
    title?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
};
declare type PullsUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/pulls/:pull_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsUpdateResponseData {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
    }[];
    milestone: {
        url: string;
        html_url: string;
        labels_url: string;
        id: number;
        node_id: string;
        number: number;
        state: string;
        title: string;
        description: string;
        creator: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        open_issues: number;
        closed_issues: number;
        created_at: string;
        updated_at: string;
        closed_at: string;
        due_on: string;
    };
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assignees: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_reviewers: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    requested_teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    head: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    base: {
        label: string;
        ref: string;
        sha: string;
        user: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        repo: {
            id: number;
            node_id: string;
            name: string;
            full_name: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            };
            private: boolean;
            html_url: string;
            description: string;
            fork: boolean;
            url: string;
            archive_url: string;
            assignees_url: string;
            blobs_url: string;
            branches_url: string;
            collaborators_url: string;
            comments_url: string;
            commits_url: string;
            compare_url: string;
            contents_url: string;
            contributors_url: string;
            deployments_url: string;
            downloads_url: string;
            events_url: string;
            forks_url: string;
            git_commits_url: string;
            git_refs_url: string;
            git_tags_url: string;
            git_url: string;
            issue_comment_url: string;
            issue_events_url: string;
            issues_url: string;
            keys_url: string;
            labels_url: string;
            languages_url: string;
            merges_url: string;
            milestones_url: string;
            notifications_url: string;
            pulls_url: string;
            releases_url: string;
            ssh_url: string;
            stargazers_url: string;
            statuses_url: string;
            subscribers_url: string;
            subscription_url: string;
            tags_url: string;
            teams_url: string;
            trees_url: string;
            clone_url: string;
            mirror_url: string;
            hooks_url: string;
            svn_url: string;
            homepage: string;
            language: string;
            forks_count: number;
            stargazers_count: number;
            watchers_count: number;
            size: number;
            default_branch: string;
            open_issues_count: number;
            is_template: boolean;
            topics: string[];
            has_issues: boolean;
            has_projects: boolean;
            has_wiki: boolean;
            has_pages: boolean;
            has_downloads: boolean;
            archived: boolean;
            disabled: boolean;
            visibility: string;
            pushed_at: string;
            created_at: string;
            updated_at: string;
            permissions: {
                admin: boolean;
                push: boolean;
                pull: boolean;
            };
            allow_rebase_merge: boolean;
            template_repository: {
                [k: string]: unknown;
            };
            temp_clone_token: string;
            allow_squash_merge: boolean;
            delete_branch_on_merge: boolean;
            allow_merge_commit: boolean;
            subscribers_count: number;
            network_count: number;
        };
    };
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        issue: {
            href: string;
        };
        comments: {
            href: string;
        };
        review_comments: {
            href: string;
        };
        review_comment: {
            href: string;
        };
        commits: {
            href: string;
        };
        statuses: {
            href: string;
        };
    };
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
}
declare type PullsUpdateBranchEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    /**
     * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits](https://developer.github.com/v3/repos/commits/#list-commits)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
     */
    expected_head_sha?: string;
} & RequiredPreview<"lydian">;
declare type PullsUpdateBranchRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/update-branch";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsUpdateBranchResponseData {
    message: string;
    url: string;
}
declare type PullsUpdateReviewEndpoint = {
    owner: string;
    repo: string;
    pull_number: number;
    review_id: number;
    /**
     * The body text of the pull request review.
     */
    body: string;
};
declare type PullsUpdateReviewRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsUpdateReviewResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: {
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    submitted_at: string;
    commit_id: string;
}
declare type PullsUpdateReviewCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * The text of the reply to the review comment.
     */
    body: string;
};
declare type PullsUpdateReviewCommentRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface PullsUpdateReviewCommentResponseData {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: {
        self: {
            href: string;
        };
        html: {
            href: string;
        };
        pull_request: {
            href: string;
        };
    };
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
}
declare type RateLimitGetEndpoint = {};
declare type RateLimitGetRequestOptions = {
    method: "GET";
    url: "/rate_limit";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface RateLimitGetResponseData {
    resources: {
        core: {
            limit: number;
            remaining: number;
            reset: number;
        };
        search: {
            limit: number;
            remaining: number;
            reset: number;
        };
        graphql: {
            limit: number;
            remaining: number;
            reset: number;
        };
        integration_manifest: {
            limit: number;
            remaining: number;
            reset: number;
        };
    };
    rate: {
        limit: number;
        remaining: number;
        reset: number;
    };
}
declare type ReactionsCreateForCommitCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForCommitCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForCommitCommentResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForIssueEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForIssueRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForIssueResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForIssueCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForIssueCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForIssueCommentResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForPullRequestReviewCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForPullRequestReviewCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForPullRequestReviewCommentResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForTeamDiscussionCommentInOrgEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForTeamDiscussionCommentInOrgResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForTeamDiscussionCommentLegacyEndpoint = {
    team_id: number;
    discussion_number: number;
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions = {
    method: "POST";
    url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForTeamDiscussionCommentLegacyResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForTeamDiscussionInOrgEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForTeamDiscussionInOrgResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsCreateForTeamDiscussionLegacyEndpoint = {
    team_id: number;
    discussion_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionLegacyRequestOptions = {
    method: "POST";
    url: "/teams/:team_id/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReactionsCreateForTeamDiscussionLegacyResponseData {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}
declare type ReactionsDeleteForCommitCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForCommitCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteForIssueEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForIssueRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteForIssueCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForIssueCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteForPullRequestCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForPullRequestCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteForTeamDiscussionEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForTeamDiscussionRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteForTeamDiscussionCommentEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    comment_number: number;
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForTeamDiscussionCommentRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsDeleteLegacyEndpoint = {
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteLegacyRequestOptions = {
    method: "DELETE";
    url: "/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForCommitCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForCommitCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForCommitCommentResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForIssueEndpoint = {
    owner: string;
    repo: string;
    issue_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForIssueRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForIssueResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForIssueCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForIssueCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForIssueCommentResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForPullRequestReviewCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForPullRequestReviewCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForPullRequestReviewCommentResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForTeamDiscussionCommentInOrgEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionCommentInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForTeamDiscussionCommentInOrgResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForTeamDiscussionCommentLegacyEndpoint = {
    team_id: number;
    discussion_number: number;
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionCommentLegacyRequestOptions = {
    method: "GET";
    url: "/teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForTeamDiscussionCommentLegacyResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForTeamDiscussionInOrgEndpoint = {
    org: string;
    team_slug: string;
    discussion_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForTeamDiscussionInOrgResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReactionsListForTeamDiscussionLegacyEndpoint = {
    team_id: number;
    discussion_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionLegacyRequestOptions = {
    method: "GET";
    url: "/teams/:team_id/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReactionsListForTeamDiscussionLegacyResponseData = {
    id: number;
    node_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    content: string;
    created_at: string;
}[];
declare type ReposAcceptInvitationEndpoint = {
    invitation_id: number;
};
declare type ReposAcceptInvitationRequestOptions = {
    method: "PATCH";
    url: "/user/repository_invitations/:invitation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddAppAccessRestrictionsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
    /**
     * apps parameter
     */
    apps: string[];
};
declare type ReposAddAppAccessRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposAddAppAccessRestrictionsResponseData = {
    id: number;
    slug: string;
    node_id: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: {
        metadata: string;
        contents: string;
        issues: string;
        single_file: string;
    };
    events: string[];
}[];
declare type ReposAddCollaboratorEndpoint = {
    owner: string;
    repo: string;
    username: string;
    /**
     * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
     * \* `pull` - can pull, but not push to or administer this repository.
     * \* `push` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push and administer this repository.
     * \* `maintain` - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.
     * \* `triage` - Recommended for contributors who need to proactively manage issues and pull requests without write access.
     */
    permission?: "pull" | "push" | "admin" | "maintain" | "triage";
};
declare type ReposAddCollaboratorRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposAddCollaboratorResponseData {
    id: number;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    invitee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    inviter: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
}
declare type ReposAddStatusCheckContextsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
    /**
     * contexts parameter
     */
    contexts: string[];
};
declare type ReposAddStatusCheckContextsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposAddStatusCheckContextsResponseData = string[];
declare type ReposAddTeamAccessRestrictionsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
    /**
     * teams parameter
     */
    teams: string[];
};
declare type ReposAddTeamAccessRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposAddTeamAccessRestrictionsResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: {
        [k: string]: unknown;
    };
}[];
declare type ReposAddUserAccessRestrictionsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
    /**
     * users parameter
     */
    users: string[];
};
declare type ReposAddUserAccessRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposAddUserAccessRestrictionsResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type ReposCheckCollaboratorEndpoint = {
    owner: string;
    repo: string;
    username: string;
};
declare type ReposCheckCollaboratorRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCheckVulnerabilityAlertsEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"dorian">;
declare type ReposCheckVulnerabilityAlertsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/vulnerability-alerts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCompareCommitsEndpoint = {
    owner: string;
    repo: string;
    base: string;
    head: string;
};
declare type ReposCompareCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/compare/:base...:head";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCompareCommitsResponseData {
    url: string;
    html_url: string;
    permalink_url: string;
    diff_url: string;
    patch_url: string;
    base_commit: {
        url: string;
        sha: string;
        node_id: string;
        html_url: string;
        comments_url: string;
        commit: {
            url: string;
            author: {
                name: string;
                email: string;
                date: string;
            };
            committer: {
                name: string;
                email: string;
                date: string;
            };
            message: string;
            tree: {
                url: string;
                sha: string;
            };
            comment_count: number;
            verification: {
                verified: boolean;
                reason: string;
                signature: string;
                payload: string;
            };
        };
        author: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        committer: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        parents: {
            url: string;
            sha: string;
        }[];
    };
    merge_base_commit: {
        url: string;
        sha: string;
        node_id: string;
        html_url: string;
        comments_url: string;
        commit: {
            url: string;
            author: {
                name: string;
                email: string;
                date: string;
            };
            committer: {
                name: string;
                email: string;
                date: string;
            };
            message: string;
            tree: {
                url: string;
                sha: string;
            };
            comment_count: number;
            verification: {
                verified: boolean;
                reason: string;
                signature: string;
                payload: string;
            };
        };
        author: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        committer: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        parents: {
            url: string;
            sha: string;
        }[];
    };
    status: string;
    ahead_by: number;
    behind_by: number;
    total_commits: number;
    commits: {
        url: string;
        sha: string;
        node_id: string;
        html_url: string;
        comments_url: string;
        commit: {
            url: string;
            author: {
                name: string;
                email: string;
                date: string;
            };
            committer: {
                name: string;
                email: string;
                date: string;
            };
            message: string;
            tree: {
                url: string;
                sha: string;
            };
            comment_count: number;
            verification: {
                verified: boolean;
                reason: string;
                signature: string;
                payload: string;
            };
        };
        author: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        committer: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        parents: {
            url: string;
            sha: string;
        }[];
    }[];
    files: {
        sha: string;
        filename: string;
        status: string;
        additions: number;
        deletions: number;
        changes: number;
        blob_url: string;
        raw_url: string;
        contents_url: string;
        patch: string;
    }[];
}
declare type ReposCreateCommitCommentEndpoint = {
    owner: string;
    repo: string;
    commit_sha: string;
    /**
     * The contents of the comment.
     */
    body: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    /**
     * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
     */
    line?: number | null;
};
declare type ReposCreateCommitCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/commits/:commit_sha/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateCommitCommentResponseData {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ReposCreateCommitSignatureProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposCreateCommitSignatureProtectionRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateCommitSignatureProtectionResponseData {
    url: string;
    enabled: boolean;
}
declare type ReposCreateCommitStatusEndpoint = {
    owner: string;
    repo: string;
    sha: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
     */
    state: "error" | "failure" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
     * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
     * `http://ci.example.com/user/repo/build/sha`
     */
    target_url?: string;
    /**
     * A short description of the status.
     */
    description?: string;
    /**
     * A string label to differentiate this status from the status of other systems.
     */
    context?: string;
};
declare type ReposCreateCommitStatusRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/statuses/:sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateCommitStatusResponseData {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type ReposCreateDeployKeyEndpoint = {
    owner: string;
    repo: string;
    /**
     * A name for the key.
     */
    title?: string;
    /**
     * The contents of the key.
     */
    key: string;
    /**
     * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
     *
     * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://docs.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://docs.github.com/articles/permission-levels-for-a-user-account-repository/)."
     */
    read_only?: boolean;
};
declare type ReposCreateDeployKeyRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/keys";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateDeployKeyResponseData {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
}
declare type ReposCreateDeploymentEndpoint = {
    owner: string;
    repo: string;
    /**
     * The ref to deploy. This can be a branch, tag, or SHA.
     */
    ref: string;
    /**
     * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
     */
    auto_merge?: boolean;
    /**
     * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
     */
    required_contexts?: string[];
    /**
     * JSON payload with extra information about the deployment.
     */
    payload?: any;
    /**
     * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
     */
    environment?: string;
    /**
     * Short description of the deployment.
     */
    description?: string;
    /**
     * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    transient_environment?: boolean;
    /**
     * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    production_environment?: boolean;
};
declare type ReposCreateDeploymentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/deployments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateDeploymentResponseData {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: {
        deploy: string;
    };
    original_environment: string;
    environment: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
}
export interface ReposCreateDeploymentResponse202Data {
    message: string;
}
export interface ReposCreateDeploymentResponse409Data {
    message: string;
}
declare type ReposCreateDeploymentStatusEndpoint = {
    owner: string;
    repo: string;
    deployment_id: number;
    /**
     * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type. When you set a transient deployment to `inactive`, the deployment will be shown as `destroyed` in GitHub.
     */
    state: "error" | "failure" | "inactive" | "in_progress" | "queued" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
     */
    target_url?: string;
    /**
     * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    log_url?: string;
    /**
     * A short description of the status. The maximum description length is 140 characters.
     */
    description?: string;
    /**
     * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    environment?: "production" | "staging" | "qa";
    /**
     * Sets the URL for accessing your environment. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    environment_url?: string;
    /**
     * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
     * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    auto_inactive?: boolean;
};
declare type ReposCreateDeploymentStatusRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateDeploymentStatusResponseData {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
}
declare type ReposCreateDispatchEventEndpoint = {
    owner: string;
    repo: string;
    /**
     * **Required:** A custom webhook event name.
     */
    event_type: string;
    /**
     * JSON payload with extra information about the webhook event that your action or worklow may use.
     */
    client_payload?: ReposCreateDispatchEventParamsClientPayload;
};
declare type ReposCreateDispatchEventRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/dispatches";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateForAuthenticatedUserEndpoint = {
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one.
     */
    private?: boolean;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://docs.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)".
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://docs.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
};
declare type ReposCreateForAuthenticatedUserRequestOptions = {
    method: "POST";
    url: "/user/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateForAuthenticatedUserResponseData {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}
declare type ReposCreateForkEndpoint = {
    owner: string;
    repo: string;
    /**
     * Optional parameter to specify the organization name if forking into an organization.
     */
    organization?: string;
};
declare type ReposCreateForkRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateForkResponseData {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}
declare type ReposCreateInOrgEndpoint = {
    org: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one.
     */
    private?: boolean;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)".
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://docs.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
};
declare type ReposCreateInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateInOrgResponseData {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}
declare type ReposCreateOrUpdateFileContentsEndpoint = {
    owner: string;
    repo: string;
    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateOrUpdateFileContentsParamsCommitter;
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateOrUpdateFileContentsParamsAuthor;
};
declare type ReposCreateOrUpdateFileContentsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateOrUpdateFileContentsResponseData {
    content: {
        name: string;
        path: string;
        sha: string;
        size: number;
        url: string;
        html_url: string;
        git_url: string;
        download_url: string;
        type: string;
        _links: {
            self: string;
            git: string;
            html: string;
        };
    };
    commit: {
        sha: string;
        node_id: string;
        url: string;
        html_url: string;
        author: {
            date: string;
            name: string;
            email: string;
        };
        committer: {
            date: string;
            name: string;
            email: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        parents: {
            url: string;
            html_url: string;
            sha: string;
        }[];
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
}
export interface ReposCreateOrUpdateFileContentsResponse201Data {
    content: {
        name: string;
        path: string;
        sha: string;
        size: number;
        url: string;
        html_url: string;
        git_url: string;
        download_url: string;
        type: string;
        _links: {
            self: string;
            git: string;
            html: string;
        };
    };
    commit: {
        sha: string;
        node_id: string;
        url: string;
        html_url: string;
        author: {
            date: string;
            name: string;
            email: string;
        };
        committer: {
            date: string;
            name: string;
            email: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        parents: {
            url: string;
            html_url: string;
            sha: string;
        }[];
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
}
declare type ReposCreatePagesSiteEndpoint = {
    owner: string;
    repo: string;
    /**
     * The source branch and directory used to publish your Pages site.
     */
    source: ReposCreatePagesSiteParamsSource;
} & RequiredPreview<"switcheroo">;
declare type ReposCreatePagesSiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreatePagesSiteResponseData {
    url: string;
    status: string;
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: {
        branch: string;
        directory: string;
    };
}
declare type ReposCreateReleaseEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the tag.
     */
    tag_name: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
    /**
     * The name of the release.
     */
    name?: string;
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` to create a draft (unpublished) release, `false` to create a published one.
     */
    draft?: boolean;
    /**
     * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
     */
    prerelease?: boolean;
};
declare type ReposCreateReleaseRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/releases";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateReleaseResponseData {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assets: unknown[];
}
declare type ReposCreateUsingTemplateEndpoint = {
    template_owner: string;
    template_repo: string;
    /**
     * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
     */
    owner?: string;
    /**
     * The name of the new repository.
     */
    name: string;
    /**
     * A short description of the new repository.
     */
    description?: string;
    /**
     * Either `true` to create a new private repository or `false` to create a new public one.
     */
    private?: boolean;
} & RequiredPreview<"baptiste">;
declare type ReposCreateUsingTemplateRequestOptions = {
    method: "POST";
    url: "/repos/:template_owner/:template_repo/generate";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateUsingTemplateResponseData {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
}
declare type ReposCreateWebhookEndpoint = {
    owner: string;
    repo: string;
    /**
     * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
     */
    name?: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config: ReposCreateWebhookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/webhooks/event-payloads) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type ReposCreateWebhookRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposCreateWebhookResponseData {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: string[];
    config: {
        content_type: string;
        insecure_ssl: string;
        url: string;
    };
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: {
        code: string;
        status: string;
        message: string;
    };
}
declare type ReposDeclineInvitationEndpoint = {
    invitation_id: number;
};
declare type ReposDeclineInvitationRequestOptions = {
    method: "DELETE";
    url: "/user/repository_invitations/:invitation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposDeleteRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposDeleteResponseData {
    message: string;
    documentation_url: string;
}
declare type ReposDeleteAccessRestrictionsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposDeleteAccessRestrictionsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteAdminBranchProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposDeleteAdminBranchProtectionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteBranchProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposDeleteBranchProtectionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteCommitCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type ReposDeleteCommitCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteCommitSignatureProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposDeleteCommitSignatureProtectionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteDeployKeyEndpoint = {
    owner: string;
    repo: string;
    key_id: number;
};
declare type ReposDeleteDeployKeyRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/keys/:key_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteDeploymentEndpoint = {
    owner: string;
    repo: string;
    deployment_id: number;
};
declare type ReposDeleteDeploymentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/deployments/:deployment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteFileEndpoint = {
    owner: string;
    repo: string;
    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * object containing information about the committer.
     */
    committer?: ReposDeleteFileParamsCommitter;
    /**
     * object containing information about the author.
     */
    author?: ReposDeleteFileParamsAuthor;
};
declare type ReposDeleteFileRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposDeleteFileResponseData {
    content: {
        [k: string]: unknown;
    };
    commit: {
        sha: string;
        node_id: string;
        url: string;
        html_url: string;
        author: {
            date: string;
            name: string;
            email: string;
        };
        committer: {
            date: string;
            name: string;
            email: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        parents: {
            url: string;
            html_url: string;
            sha: string;
        }[];
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
}
declare type ReposDeleteInvitationEndpoint = {
    owner: string;
    repo: string;
    invitation_id: number;
};
declare type ReposDeleteInvitationRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/invitations/:invitation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeletePagesSiteEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"switcheroo">;
declare type ReposDeletePagesSiteRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeletePullRequestReviewProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposDeletePullRequestReviewProtectionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteReleaseEndpoint = {
    owner: string;
    repo: string;
    release_id: number;
};
declare type ReposDeleteReleaseRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/releases/:release_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteReleaseAssetEndpoint = {
    owner: string;
    repo: string;
    asset_id: number;
};
declare type ReposDeleteReleaseAssetRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/releases/assets/:asset_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteWebhookEndpoint = {
    owner: string;
    repo: string;
    hook_id: number;
};
declare type ReposDeleteWebhookRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDisableAutomatedSecurityFixesEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"london">;
declare type ReposDisableAutomatedSecurityFixesRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/automated-security-fixes";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDisableVulnerabilityAlertsEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"dorian">;
declare type ReposDisableVulnerabilityAlertsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/vulnerability-alerts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDownloadArchiveEndpoint = {
    owner: string;
    repo: string;
    archive_format: string;
    ref: string;
};
declare type ReposDownloadArchiveRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/:archive_format/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposEnableAutomatedSecurityFixesEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"london">;
declare type ReposEnableAutomatedSecurityFixesRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/automated-security-fixes";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposEnableVulnerabilityAlertsEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"dorian">;
declare type ReposEnableVulnerabilityAlertsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/vulnerability-alerts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetResponseData {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        pull: boolean;
        triage: boolean;
        push: boolean;
        maintain: boolean;
        admin: boolean;
    };
    allow_rebase_merge: boolean;
    template_repository: string;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    delete_branch_on_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
    organization: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    parent: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
    source: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
        clone_url: string;
        mirror_url: string;
        hooks_url: string;
        svn_url: string;
        homepage: string;
        language: string;
        forks_count: number;
        stargazers_count: number;
        watchers_count: number;
        size: number;
        default_branch: string;
        open_issues_count: number;
        is_template: boolean;
        topics: string[];
        has_issues: boolean;
        has_projects: boolean;
        has_wiki: boolean;
        has_pages: boolean;
        has_downloads: boolean;
        archived: boolean;
        disabled: boolean;
        visibility: string;
        pushed_at: string;
        created_at: string;
        updated_at: string;
        permissions: {
            admin: boolean;
            push: boolean;
            pull: boolean;
        };
        allow_rebase_merge: boolean;
        template_repository: {
            [k: string]: unknown;
        };
        temp_clone_token: string;
        allow_squash_merge: boolean;
        delete_branch_on_merge: boolean;
        allow_merge_commit: boolean;
        subscribers_count: number;
        network_count: number;
    };
    code_of_conduct: {
        name: string;
        key: string;
        url: string;
        html_url: string;
    };
}
declare type ReposGetAccessRestrictionsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetAccessRestrictionsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetAccessRestrictionsResponseData {
    url: string;
    users_url: string;
    teams_url: string;
    apps_url: string;
    users: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    }[];
    teams: {
        id: number;
        node_id: string;
        url: string;
        html_url: string;
        name: string;
        slug: string;
        description: string;
        privacy: string;
        permission: string;
        members_url: string;
        repositories_url: string;
        parent: {
            [k: string]: unknown;
        };
    }[];
    apps: {
        id: number;
        slug: string;
        node_id: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            url: string;
            repos_url: string;
            events_url: string;
            hooks_url: string;
            issues_url: string;
            members_url: string;
            public_members_url: string;
            avatar_url: string;
            description: string;
        };
        name: string;
        description: string;
        external_url: string;
        html_url: string;
        created_at: string;
        updated_at: string;
        permissions: {
            metadata: string;
            contents: string;
            issues: string;
            single_file: string;
        };
        events: string[];
    }[];
}
declare type ReposGetAdminBranchProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetAdminBranchProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetAdminBranchProtectionResponseData {
    url: string;
    enabled: boolean;
}
declare type ReposGetAllStatusCheckContextsEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetAllStatusCheckContextsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetAllStatusCheckContextsResponseData = string[];
declare type ReposGetAllTopicsEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"mercy">;
declare type ReposGetAllTopicsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/topics";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetAllTopicsResponseData {
    names: string[];
}
declare type ReposGetAppsWithAccessToProtectedBranchEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetAppsWithAccessToProtectedBranchResponseData = {
    id: number;
    slug: string;
    node_id: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        url: string;
        repos_url: string;
        events_url: string;
        hooks_url: string;
        issues_url: string;
        members_url: string;
        public_members_url: string;
        avatar_url: string;
        description: string;
    };
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: {
        metadata: string;
        contents: string;
        issues: string;
        single_file: string;
    };
    events: string[];
}[];
declare type ReposGetBranchEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetBranchResponseData {
    name: string;
    commit: {
        sha: string;
        node_id: string;
        commit: {
            author: {
                name: string;
                date: string;
                email: string;
            };
            url: string;
            message: string;
            tree: {
                sha: string;
                url: string;
            };
            committer: {
                name: string;
                date: string;
                email: string;
            };
            verification: {
                verified: boolean;
                reason: string;
                signature: string;
                payload: string;
            };
        };
        author: {
            gravatar_id: string;
            avatar_url: string;
            url: string;
            id: number;
            login: string;
        };
        parents: {
            sha: string;
            url: string;
        }[];
        url: string;
        committer: {
            gravatar_id: string;
            avatar_url: string;
            url: string;
            id: number;
            login: string;
        };
    };
    _links: {
        html: string;
        self: string;
    };
    protected: boolean;
    protection: {
        enabled: boolean;
        required_status_checks: {
            enforcement_level: string;
            contexts: string[];
        };
    };
    protection_url: string;
}
declare type ReposGetBranchProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetBranchProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetBranchProtectionResponseData {
    url: string;
    required_status_checks: {
        url: string;
        strict: boolean;
        contexts: string[];
        contexts_url: string;
    };
    enforce_admins: {
        url: string;
        enabled: boolean;
    };
    required_pull_request_reviews: {
        url: string;
        dismissal_restrictions: {
            url: string;
            users_url: string;
            teams_url: string;
            users: {
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
            }[];
            teams: {
                id: number;
                node_id: string;
                url: string;
                html_url: string;
                name: string;
                slug: string;
                description: string;
                privacy: string;
                permission: string;
                members_url: string;
                repositories_url: string;
                parent: {
                    [k: string]: unknown;
                };
            }[];
        };
        dismiss_stale_reviews: boolean;
        require_code_owner_reviews: boolean;
        required_approving_review_count: number;
    };
    restrictions: {
        url: string;
        users_url: string;
        teams_url: string;
        apps_url: string;
        users: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        }[];
        teams: {
            id: number;
            node_id: string;
            url: string;
            html_url: string;
            name: string;
            slug: string;
            description: string;
            privacy: string;
            permission: string;
            members_url: string;
            repositories_url: string;
            parent: {
                [k: string]: unknown;
            };
        }[];
        apps: {
            id: number;
            slug: string;
            node_id: string;
            owner: {
                login: string;
                id: number;
                node_id: string;
                url: string;
                repos_url: string;
                events_url: string;
                hooks_url: string;
                issues_url: string;
                members_url: string;
                public_members_url: string;
                avatar_url: string;
                description: string;
            };
            name: string;
            description: string;
            external_url: string;
            html_url: string;
            created_at: string;
            updated_at: string;
            permissions: {
                metadata: string;
                contents: string;
                issues: string;
                single_file: string;
            };
            events: string[];
        }[];
    };
    required_linear_history: {
        enabled: boolean;
    };
    allow_force_pushes: {
        enabled: boolean;
    };
    allow_deletions: {
        enabled: boolean;
    };
}
declare type ReposGetClonesEndpoint = {
    owner: string;
    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
};
declare type ReposGetClonesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/clones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetClonesResponseData {
    count: number;
    uniques: number;
    clones: {
        timestamp: string;
        count: number;
        uniques: number;
    }[];
}
declare type ReposGetCodeFrequencyStatsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetCodeFrequencyStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/code_frequency";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetCodeFrequencyStatsResponseData = number[][];
declare type ReposGetCollaboratorPermissionLevelEndpoint = {
    owner: string;
    repo: string;
    username: string;
};
declare type ReposGetCollaboratorPermissionLevelRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators/:username/permission";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCollaboratorPermissionLevelResponseData {
    permission: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type ReposGetCombinedStatusForRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
};
declare type ReposGetCombinedStatusForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/status";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCombinedStatusForRefResponseData {
    state: string;
    statuses: {
        url: string;
        avatar_url: string;
        id: number;
        node_id: string;
        state: string;
        description: string;
        target_url: string;
        context: string;
        created_at: string;
        updated_at: string;
    }[];
    sha: string;
    total_count: number;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    commit_url: string;
    url: string;
}
declare type ReposGetCommitEndpoint = {
    owner: string;
    repo: string;
    ref: string;
};
declare type ReposGetCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCommitResponseData {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: {
        url: string;
        author: {
            name: string;
            email: string;
            date: string;
        };
        committer: {
            name: string;
            email: string;
            date: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        comment_count: number;
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    committer: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    parents: {
        url: string;
        sha: string;
    }[];
    stats: {
        additions: number;
        deletions: number;
        total: number;
    };
    files: {
        filename: string;
        additions: number;
        deletions: number;
        changes: number;
        status: string;
        raw_url: string;
        blob_url: string;
        patch: string;
    }[];
}
declare type ReposGetCommitActivityStatsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetCommitActivityStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/commit_activity";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetCommitActivityStatsResponseData = {
    days: number[];
    total: number;
    week: number;
}[];
declare type ReposGetCommitCommentEndpoint = {
    owner: string;
    repo: string;
    comment_id: number;
};
declare type ReposGetCommitCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCommitCommentResponseData {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}
declare type ReposGetCommitSignatureProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposGetCommitSignatureProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCommitSignatureProtectionResponseData {
    url: string;
    enabled: boolean;
}
declare type ReposGetCommunityProfileMetricsEndpoint = {
    owner: string;
    repo: string;
} & RequiredPreview<"black-panther">;
declare type ReposGetCommunityProfileMetricsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/community/profile";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetCommunityProfileMetricsResponseData {
    health_percentage: number;
    description: string;
    documentation: boolean;
    files: {
        code_of_conduct: {
            name: string;
            key: string;
            url: string;
            html_url: string;
        };
        contributing: {
            url: string;
            html_url: string;
        };
        issue_template: {
            url: string;
            html_url: string;
        };
        pull_request_template: {
            url: string;
            html_url: string;
        };
        license: {
            name: string;
            key: string;
            spdx_id: string;
            url: string;
            html_url: string;
        };
        readme: {
            url: string;
            html_url: string;
        };
    };
    updated_at: string;
}
declare type ReposGetContentEndpoint = {
    owner: string;
    repo: string;
    path: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
};
declare type ReposGetContentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetContentResponseData {
    type: string;
    encoding: string;
    size: number;
    name: string;
    path: string;
    content: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string;
    target: string;
    submodule_git_url: string;
    _links: {
        git: string;
        self: string;
        html: string;
    };
}
declare type ReposGetContributorsStatsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetContributorsStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/contributors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetContributorsStatsResponseData = {
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    total: number;
    weeks: {
        w: string;
        a: number;
        d: number;
        c: number;
    }[];
}[];
declare type ReposGetDeployKeyEndpoint = {
    owner: string;
    repo: string;
    key_id: number;
};
declare type ReposGetDeployKeyRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/keys/:key_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetDeployKeyResponseData {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
}
declare type ReposGetDeploymentEndpoint = {
    owner: string;
    repo: string;
    deployment_id: number;
};
declare type ReposGetDeploymentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetDeploymentResponseData {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: {
        deploy: string;
    };
    original_environment: string;
    environment: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
}
declare type ReposGetDeploymentStatusEndpoint = {
    owner: string;
    repo: string;
    deployment_id: number;
    status_id: number;
};
declare type ReposGetDeploymentStatusRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetDeploymentStatusResponseData {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
}
declare type ReposGetLatestPagesBuildEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetLatestPagesBuildRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds/latest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetLatestPagesBuildResponseData {
    url: string;
    status: string;
    error: {
        message: string;
    };
    pusher: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
}
declare type ReposGetLatestReleaseEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetLatestReleaseRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/latest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetLatestReleaseResponseData {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assets: {
        url: string;
        browser_download_url: string;
        id: number;
        node_id: string;
        name: string;
        label: string;
        state: string;
        content_type: string;
        size: number;
        download_count: number;
        created_at: string;
        updated_at: string;
        uploader: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
    }[];
}
declare type ReposGetPagesEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetPagesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetPagesResponseData {
    url: string;
    status: string;
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: {
        branch: string;
        directory: string;
    };
}
declare type ReposGetPagesBuildEndpoint = {
    owner: string;
    repo: string;
    build_id: number;
};
declare type ReposGetPagesBuildRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds/:build_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetPagesBuildResponseData {
    url: string;
    status: string;
    error: {
        message: string;
    };
    pusher: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
}
declare type ReposGetParticipationStatsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetParticipationStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/participation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetParticipationStatsResponseData {
    all: number[];
    owner: number[];
}
declare type ReposGetPullRequestReviewProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetPullRequestReviewProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetPullRequestReviewProtectionResponseData {
    url: string;
    dismissal_restrictions: {
        url: string;
        users_url: string;
        teams_url: string;
        users: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        }[];
        teams: {
            id: number;
            node_id: string;
            url: string;
            html_url: string;
            name: string;
            slug: string;
            description: string;
            privacy: string;
            permission: string;
            members_url: string;
            repositories_url: string;
            parent: {
                [k: string]: unknown;
            };
        }[];
    };
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
}
declare type ReposGetPunchCardStatsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetPunchCardStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/punch_card";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetPunchCardStatsResponseData = number[][];
declare type ReposGetReadmeEndpoint = {
    owner: string;
    repo: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
};
declare type ReposGetReadmeRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/readme";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetReadmeResponseData {
    type: string;
    encoding: string;
    size: number;
    name: string;
    path: string;
    content: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string;
    target: string;
    submodule_git_url: string;
    _links: {
        git: string;
        self: string;
        html: string;
    };
}
declare type ReposGetReleaseEndpoint = {
    owner: string;
    repo: string;
    release_id: number;
};
declare type ReposGetReleaseRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/:release_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetReleaseResponseData {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assets: {
        url: string;
        browser_download_url: string;
        id: number;
        node_id: string;
        name: string;
        label: string;
        state: string;
        content_type: string;
        size: number;
        download_count: number;
        created_at: string;
        updated_at: string;
        uploader: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
    }[];
}
declare type ReposGetReleaseAssetEndpoint = {
    owner: string;
    repo: string;
    asset_id: number;
};
declare type ReposGetReleaseAssetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/assets/:asset_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetReleaseAssetResponseData {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}
declare type ReposGetReleaseByTagEndpoint = {
    owner: string;
    repo: string;
    tag: string;
};
declare type ReposGetReleaseByTagRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/tags/:tag";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetReleaseByTagResponseData {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    assets: {
        url: string;
        browser_download_url: string;
        id: number;
        node_id: string;
        name: string;
        label: string;
        state: string;
        content_type: string;
        size: number;
        download_count: number;
        created_at: string;
        updated_at: string;
        uploader: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
    }[];
}
declare type ReposGetStatusChecksProtectionEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetStatusChecksProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetStatusChecksProtectionResponseData {
    url: string;
    strict: boolean;
    contexts: string[];
    contexts_url: string;
}
declare type ReposGetTeamsWithAccessToProtectedBranchEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetTeamsWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetTeamsWithAccessToProtectedBranchResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: {
        [k: string]: unknown;
    };
}[];
declare type ReposGetTopPathsEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetTopPathsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/popular/paths";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetTopPathsResponseData = {
    path: string;
    title: string;
    count: number;
    uniques: number;
}[];
declare type ReposGetTopReferrersEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposGetTopReferrersRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/popular/referrers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetTopReferrersResponseData = {
    referrer: string;
    count: number;
    uniques: number;
}[];
declare type ReposGetUsersWithAccessToProtectedBranchEndpoint = {
    owner: string;
    repo: string;
    branch: string;
};
declare type ReposGetUsersWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposGetUsersWithAccessToProtectedBranchResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
}[];
declare type ReposGetViewsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
};
declare type ReposGetViewsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/views";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetViewsResponseData {
    count: number;
    uniques: number;
    views: {
        timestamp: string;
        count: number;
        uniques: number;
    }[];
}
declare type ReposGetWebhookEndpoint = {
    owner: string;
    repo: string;
    hook_id: number;
};
declare type ReposGetWebhookRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposGetWebhookResponseData {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: string[];
    config: {
        content_type: string;
        insecure_ssl: string;
        url: string;
    };
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: {
        code: string;
        status: string;
        message: string;
    };
}
declare type ReposListBranchesEndpoint = {
    owner: string;
    repo: string;
    /**
     * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
     */
    protected?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListBranchesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListBranchesResponseData = {
    name: string;
    commit: {
        sha: string;
        url: string;
    };
    protected: boolean;
    protection: {
        enabled: boolean;
        required_status_checks: {
            enforcement_level: string;
            contexts: string[];
        };
    };
    protection_url: string;
}[];
declare type ReposListBranchesForHeadCommitEndpoint = {
    owner: string;
    repo: string;
    commit_sha: string;
} & RequiredPreview<"groot">;
declare type ReposListBranchesForHeadCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:commit_sha/branches-where-head";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListBranchesForHeadCommitResponseData = {
    name: string;
    commit: {
        sha: string;
        url: string;
    };
    protected: boolean;
}[];
declare type ReposListCollaboratorsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Filter collaborators returned by their affiliation. Can be one of:
     * \* `outside`: All outside collaborators of an organization-owned repository.
     * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCollaboratorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListCollaboratorsResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    permissions: {
        pull: boolean;
        push: boolean;
        admin: boolean;
    };
}[];
declare type ReposListCommentsForCommitEndpoint = {
    owner: string;
    repo: string;
    commit_sha: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommentsForCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:commit_sha/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListCommentsForCommitResponseData = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type ReposListCommitCommentsForRepoEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommitCommentsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListCommitCommentsForRepoResponseData = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
}[];
declare type ReposListCommitStatusesForRefEndpoint = {
    owner: string;
    repo: string;
    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommitStatusesForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListCommitStatusesForRefResponseData = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
}[];
declare type ReposListCommitsEndpoint = {
    owner: string;
    repo: string;
    /**
     * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
     */
    sha?: string;
    /**
     * Only commits containing this file path will be returned.
     */
    path?: string;
    /**
     * GitHub login or email address by which to filter by commit author.
     */
    author?: string;
    /**
     * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    until?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListCommitsResponseData = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: {
        url: string;
        author: {
            name: string;
            email: string;
            date: string;
        };
        committer: {
            name: string;
            email: string;
            date: string;
        };
        message: string;
        tree: {
            url: string;
            sha: string;
        };
        comment_count: number;
        verification: {
            verified: boolean;
            reason: string;
            signature: string;
            payload: string;
        };
    };
    author: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    committer: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    parents: {
        url: string;
        sha: string;
    }[];
}[];
declare type ReposListContributorsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Set to `1` or `true` to include anonymous contributors in results.
     */
    anon?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListContributorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/contributors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListContributorsResponseData = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    contributions: number;
}[];
declare type ReposListDeployKeysEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeployKeysRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/keys";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListDeployKeysResponseData = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
}[];
declare type ReposListDeploymentStatusesEndpoint = {
    owner: string;
    repo: string;
    deployment_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeploymentStatusesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListDeploymentStatusesResponseData = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
}[];
declare type ReposListDeploymentsEndpoint = {
    owner: string;
    repo: string;
    /**
     * The SHA recorded at creation time.
     */
    sha?: string;
    /**
     * The name of the ref. This can be a branch, tag, or SHA.
     */
    ref?: string;
    /**
     * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * The name of the environment that was deployed to (e.g., `staging` or `production`).
     */
    environment?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeploymentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListDeploymentsResponseData = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: {
        deploy: string;
    };
    original_environment: string;
    environment: string;
    description: string;
    creator: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
}[];
declare type ReposListForAuthenticatedUserEndpoint = {
    /**
     * Can be one of `all`, `public`, or `private`.
     */
    visibility?: "all" | "public" | "private";
    /**
     * Comma-separated list of values. Can include:
     * \* `owner`: Repositories that are owned by the authenticated user.
     * \* `collaborator`: Repositories that the user has been added to as a collaborator.
     * \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
     */
    affiliation?: string;
    /**
     * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`
     *
     * Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
     */
    type?: "all" | "owner" | "public" | "private" | "member";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForOrgEndpoint = {
    org: string;
    /**
     * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`.
     */
    type?: "all" | "public" | "private" | "forks" | "sources" | "member" | "internal";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListForOrgResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type ReposListForUserEndpoint = {
    username: string;
    /**
     * Can be one of `all`, `owner`, `member`.
     */
    type?: "all" | "owner" | "member";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForUserRequestOptions = {
    method: "GET";
    url: "/users/:username/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForksEndpoint = {
    owner: string;
    repo: string;
    /**
     * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
     */
    sort?: "newest" | "oldest" | "stargazers";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForksRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListForksResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: string;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: string[];
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: {
        admin: boolean;
        push: boolean;
        pull: boolean;
    };
    template_repository: {
        [k: string]: unknown;
    };
    temp_clone_token: string;
    delete_branch_on_merge: boolean;
    subscribers_count: number;
    network_count: number;
    license: {
        key: string;
        name: string;
        spdx_id: string;
        url: string;
        node_id: string;
    };
}[];
declare type ReposListInvitationsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListInvitationsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListInvitationsResponseData = {
    id: number;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    invitee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    inviter: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
}[];
declare type ReposListInvitationsForAuthenticatedUserEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListInvitationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/user/repository_invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListInvitationsForAuthenticatedUserResponseData = {
    id: number;
    repository: {
        id: number;
        node_id: string;
        name: string;
        full_name: string;
        owner: {
            login: string;
            id: number;
            node_id: string;
            avatar_url: string;
            gravatar_id: string;
            url: string;
            html_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            starred_url: string;
            subscriptions_url: string;
            organizations_url: string;
            repos_url: string;
            events_url: string;
            received_events_url: string;
            type: string;
            site_admin: boolean;
        };
        private: boolean;
        html_url: string;
        description: string;
        fork: boolean;
        url: string;
        archive_url: string;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        deployments_url: string;
        downloads_url: string;
        events_url: string;
        forks_url: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        languages_url: string;
        merges_url: string;
        milestones_url: string;
        notifications_url: string;
        pulls_url: string;
        releases_url: string;
        ssh_url: string;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        tags_url: string;
        teams_url: string;
        trees_url: string;
    };
    invitee: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    inviter: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
}[];
declare type ReposListLanguagesEndpoint = {
    owner: string;
    repo: string;
};
declare type ReposListLanguagesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/languages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export interface ReposListLanguagesResponseData {
    C: number;
    Python: number;
}
declare type ReposListPagesBuildsEndpoint = {
    owner: string;
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListPagesBuildsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListPagesBuildsResponseData = {
    url: string;
    status: string;
    error: {
        message: string;
    };
    pusher: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
}[];
declare type ReposListPublicEndpoint = {
    /**
     * The integer ID of the last repository that you've seen.
     */
    since?: number;
};
declare type ReposListPublicRequestOptions = {
    method: "GET";
    url: "/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
export declare type ReposListPublicResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: {
        login: string;
        id: number;
        node_id: string;
        avatar_url: string;
        gravatar_id: string;
        url: string;
        html_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        starred_url: string;
        subscriptions_url: string;
        organizations_url: string;
        repos_url: string;
        events_url: string;
        received_events_url: string;
        type: string;
        site_admin: boolean;
    };
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
