"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.safeWhich = exports.isWindows = void 0;
const fs = require("fs");
const path = require("path");
exports.isWindows = process.platform === "win32";
const pathSeparator = exports.isWindows ? ";" : ":";
const defaultPathExt = exports.isWindows ? [".com", ".exe", ".bat", ".cmd"] : [""];
async function safeWhich(program) {
    if (program.includes("/") || (program.includes("\\") && exports.isWindows)) {
        // If the path contains slashes it's either absolute or relative and should not be searched for.
        return program;
    }
    let pathValue = process.env.PATH;
    if (pathValue === undefined) {
        throw new Error(`Could not resolve program ${program} because no PATH environment variable was set.`);
    }
    let searchPaths = pathValue.split(pathSeparator);
    let pathExts = defaultPathExt;
    if (exports.isWindows && process.env.PATHEXT !== undefined) {
        pathExts = process.env.PATHEXT.split(pathSeparator);
    }
    for (let searchPath of searchPaths) {
        for (let pathExt of pathExts) {
            let completePath = path.join(searchPath, program + pathExt);
            try {
                await fs.promises.access(completePath, fs.constants.X_OK);
                return completePath;
            }
            catch (err) {
                if (err.code !== "ENOENT") {
                    throw err;
                }
            }
        }
    }
    throw new Error(`Could not find program ${program} on PATH.`);
}
exports.safeWhich = safeWhich;
//# sourceMappingURL=index.js.map