# Contributing

We welcome both issue reports and pull requests! Please follow these guidelines to help maintainers respond effectively.

## Issues

- **Before opening a new issue:**
  - Use the search tool to check for existing issues or feature requests.
  - Review existing issues and provide feedback or react to them.
  - Use English for all communications — it is the language all maintainers read and write.
  - For questions, configuration or deployment problems, please use the [Discussions Forum](https://github.com/gin-gonic/gin/discussions).
  - For bug reports involving sensitive security issues, email <appleboy.tw@gmail.com> instead of posting publicly.

- **Reporting a bug:**
  - Please provide a clear description of your issue, and a minimal reproducible code example if possible.
  - Include the Gin version (or commit reference), Go version, and operating system.
  - Indicate whether you can reproduce the bug and describe steps to do so.
  - Attach relevant logs per [Logging Documentation](https://docs.gitea.com/administration/logging-config#collecting-logs-for-help).

- **Feature requests:**
  - Before opening a request, check that a similar idea hasn’t already been suggested.
  - Clearly describe your proposed feature and its benefits.

_For API Documentation, User Guides, and more, see:_

- [Go.dev API Documentation](https://pkg.go.dev/github.com/gin-gonic/gin)
- [Gin User Guides](https://gin-gonic.com/)
- [Discussions Forum](https://github.com/gin-gonic/gin/discussions)

## Pull Requests

Please ensure your pull request meets the following requirements:

- Open your pull request against the `master` branch.
- Your pull request should have no more than two commits — squash them if necessary.
- All tests pass in available continuous integration systems (e.g., GitHub Actions).
- Add or modify tests to cover your code changes.
- If your pull request introduces a new feature, document it in [`docs/doc.md`](docs/doc.md), not in the README.
- Follow the checklist in the [Pull Request Template](.github/PULL_REQUEST_TEMPLATE.md:1).

Thank you for contributing!
