//
//  MockedPropertyMacro+MacroError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockedPropertyMacro {

    /// An error generated by ``MockedPropertyMacro``.
    enum MacroError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that the `@_MockedProperty` macro can only be
        /// applied to property declarations.
        case canOnlyBeAppliedToPropertyDeclarations

        /// An error indicating that the `@_MockedProperty` macro can only be
        /// applied to single-binding property declarations.
        case canOnlyBeAppliedToSingleBindingPropertyDeclarations

        /// An error indicating that the `@_MockedProperty` macro was not passed
        /// any arguments.
        case noArguments

        /// An error indicating that the `@_MockedProperty` macro was unable to
        /// parse the provided `propertyType` argument.
        case unableToParsePropertyTypeArgument

        /// An error indicating that the `@_MockedProperty` macro was unable to
        /// parse the provided `mockName` argument.
        case unableToParseMockNameArgument

        /// An error indicating that the `@_MockedProperty` macro was unable to
        /// parse the provided `isMockAnActor` argument.
        case unableToParseIsMockAnActorArgument

        /// An error indicating that the `@_MockedProperty` macro was unable to
        /// parse the property binding's name.
        case unableToParsePropertyBindingName

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .canOnlyBeAppliedToPropertyDeclarations:
                "@_MockedProperty can only be applied to property declarations."
            case .canOnlyBeAppliedToSingleBindingPropertyDeclarations:
                "@_MockedProperty can only be applied to single-binding property declarations."
            case .noArguments:
                "@_MockedProperty was not passed any arguments."
            case .unableToParsePropertyTypeArgument:
                "@_MockedProperty was unable to parse the provided `propertyType` argument."
            case .unableToParseMockNameArgument:
                "@_MockedProperty was unable to parse the provided `mockName` argument."
            case .unableToParseIsMockAnActorArgument:
                "@_MockedProperty was unable to parse the provided `isMockAnActor` argument."
            case .unableToParsePropertyBindingName:
                "@_MockedProperty was unable to parse the property binding's name."
            }
        }
    }
}
