//
//  MockedMacro+MacroError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockedMacro {

    /// An error generated by ``MockedMacro``.
    public enum MacroError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that the `@Mocked` macro can only be applied to
        /// protocol declarations.
        case canOnlyBeAppliedToProtocols

        /// An error indicating that the `@Mocked` macro was unable to parse a
        /// property binding's name.
        case unableToParsePropertyBindingName

        // MARK: Properties

        /// The description of the error.
        public var description: String {
            switch self {
            case .canOnlyBeAppliedToProtocols:
                "@Mocked can only be applied to protocols."
            case .unableToParsePropertyBindingName:
                "@Mocked was unable to parse a property binding name."
            }
        }
    }
}
