//
//  MockCompilationCondition+ParsingError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockCompilationCondition {

    /// A parsing error generated by ``MockCompilationCondition``.
    enum ParsingError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that ``MockCompilationCondition`` was unable to
        /// parse a valid instance from the provided macro argument.
        case unableToParseCompilationCondition

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .unableToParseCompilationCondition:
                "Unable to parse compilation condition."
            }
        }
    }
}
