//
//  MockedPropertyType+ParsingError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockedPropertyType {

    /// A parsing error generated by ``MockedPropertyType``.
    enum ParsingError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that ``MockedPropertyType`` was unable to parse
        /// a valid instance from the provided macro argument.
        case unableToParsePropertyType

        /// An error indicating that ``MockedPropertyType`` was unable to parse
        /// a valid async effect specifier.
        case unableToParseAsyncEffectSpecifier

        /// An error indicating that ``MockedPropertyType`` was unable to parse
        /// a valid throws effect specifier.
        case unableToParseThrowsEffectSpecifier

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .unableToParsePropertyType:
                "Unable to parse property type."
            case .unableToParseAsyncEffectSpecifier:
                "Unable to parse async effect specifier."
            case .unableToParseThrowsEffectSpecifier:
                "Unable to parse throws effect specifier."
            }
        }
    }
}
