//
//  MockSendableConformance+ParsingError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockSendableConformance {

    /// A parsing error generated by ``MockSendableConformance``.
    enum ParsingError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that ``MockSendableConformance`` was unable to
        /// parse a valid instance from the provided macro argument.
        case unableToParseSendableConformance

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .unableToParseSendableConformance:
                "Unable to parse Sendable conformance."
            }
        }
    }
}
