//
//  MockedMethodMacro+MacroError.swift
//
//  Copyright © 2025 Fetch.
//

import Foundation

extension MockedMethodMacro {

    /// An error generated by ``MockedMethodMacro``.
    enum MacroError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that the `@_MockedMethod` macro can only be
        /// applied to method declarations.
        case canOnlyBeAppliedToMethodDeclarations

        /// An error indicating that the `@_MockedMethod` macro was not passed
        /// any arguments.
        case noArguments

        /// An error indicating that the `@_MockedMethod` macro was unable to
        /// parse the provided `mockName` argument.
        case unableToParseMockNameArgument

        /// An error indicating that the `@_MockedMethod` macro was unable to
        /// parse the provided `isMockAnActor` argument.
        case unableToParseIsMockAnActorArgument

        /// An error indicating that the `@_MockedMethod` macro was unable to
        /// parse the provided `mockMethodName` argument.
        case unableToParseMockMethodName

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .canOnlyBeAppliedToMethodDeclarations:
                "@_MockedMethod can only be applied to method declarations."
            case .noArguments:
                "@_MockedMethod was not passed any arguments."
            case .unableToParseMockNameArgument:
                "@_MockedMethod was unable to parse the provided `mockName` argument."
            case .unableToParseIsMockAnActorArgument:
                "@_MockedMethod was unable to parse the provided `isMockAnActor` argument."
            case .unableToParseMockMethodName:
                "@_MockedMethod was unable to parse the provided `mockMethodName` argument."
            }
        }
    }
}
