//
//  MockedMembersMacro+MacroError.swift
//
//  Copyright © 2025 Fetch.
//

import SwiftSyntax

extension MockedMembersMacro {

    /// An error generated by ``MockedMembersMacro``.
    enum MacroError: CaseIterable, CustomStringConvertible, Error {

        // MARK: Cases

        /// An error indicating that the `@MockedMembers` macro can only be
        /// applied to class and actor declarations.
        case canOnlyBeAppliedToClassesAndActors

        /// An error indicating that the `@MockedMembers` macro was unable to
        /// determine a property's property type.
        case unableToDeterminePropertyType

        // MARK: Properties

        /// The description of the error.
        var description: String {
            switch self {
            case .canOnlyBeAppliedToClassesAndActors:
                "@MockedMembers can only be applied to classes and actors."
            case .unableToDeterminePropertyType:
                "@MockedMembers was unable to determine a property's property type."
            }
        }
    }
}
