## 📝 Summary

<!-- 
Please provide a brief summary of your changes along with any relevant context.
Include any screenshots, logs, or terminal output you think would be helpful to reviewers.
-->

## 🛠️ Type of Change

<!-- Check all that apply. -->

- [ ] Bug fix (change that fixes an issue)
- [ ] New feature (change that adds functionality)
- [ ] Breaking change (bug fix or feature that is not backwards compatible)
- [ ] Documentation (DocC, API docs, markdown files, templates, etc.)
- [ ] Testing (new tests, updated tests, etc.)
- [ ] Refactoring or code formatting (no logic changes)
- [ ] Updating dependencies (Swift packages, Homebrew, etc.)
- [ ] CI/CD (change to automated workflows)

## 🧪 How Has This Been Tested?

<!-- 
Please describe the tests you've run to verify your changes.
If fixing a bug, please describe the steps to reproduce the bug.
Include any screenshots, logs, or terminal output you think would be helpful to reviewers.
-->

## 🔗 Related PRs or Issues <!-- Delete section if not applicable -->

<!--
To automatically close an issue when this PR is merged, please include one of the following:
  - Fixes #<issue-number>
  - Closes #<issue-number>
  - Resolves #<issue-number>
-->

<!--
Please link any related PRs, for example:
  - Unblocks #<pr-number>
  - Duplicates #<pr-number>
  - Depends on #<pr-number>
  - Relates to #<pr-number>
-->

## ✅ Checklist

<!-- Confirm that you've completed the following steps. -->

- [ ] I have added relevant tests
- [ ] I have verified all tests pass
- [ ] I have formatted my code using `SwiftFormat`
- [ ] I have updated documentation (if needed)
- [ ] I have added the appropriate label to my PR
- [ ] I have read the [contributing guidelines](https://github.com/fetch-rewards/swift-mocking/blob/main/CONTRIBUTING.md)
- [ ] I agree to follow this project's [Code of Conduct](https://github.com/fetch-rewards/swift-mocking/blob/main/CODE_OF_CONDUCT.md)
