#!/usr/bin/python
"""
US State Birthday Holidays.

US State Birthdays

Copyright (c) 2015 Kauinoa

License: MIT
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of
the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
from __future__ import unicode_literals
from datetime import date
from . import util


def get_georgia_state_birthday(year):
    """Get Georgia State Birthday (Jan 2 1788)."""

    return date(year, util.JAN, 2)


def get_alaska_state_birthday(year):
    """Get Alaska State Birthday (Jan 3 1959)."""

    return date(year, util.JAN, 3)


def get_utah_state_birthday(year):
    """Get Utah State Birthday (Jan 4 1896)."""

    return date(year, util.JAN, 4)


def get_new_mexico_state_birthday(year):
    """Get New Mexico State Birthday (Jan 6 1912)."""

    return date(year, util.JAN, 6)


def get_connecticut_state_birthday(year):
    """Get Connecticut State Birthday (Jan 9 1788)."""

    return date(year, util.JAN, 9)


def get_michigan_state_birthday(year):
    """Get Michigan State Birthday (Jan 26 1837)."""

    return date(year, util.JAN, 26)


def get_kansas_state_birthday(year):
    """Get Kansas State Birthday (Jan 29 1861)."""

    return date(year, util.JAN, 29)


def get_massachusetts_state_birthday(year):
    """Get Massachusetts State Birthday (Feb 6 1788)."""

    return date(year, util.FEB, 6)


def get_oregon_state_birthday(year):
    """Get Oregon State Birthday (Feb 14 1859)."""

    return date(year, util.FEB, 14)


def get_arizona_state_birthday(year):
    """Get Arizona State Birthday (Feb 14 1912)."""

    return date(year, util.FEB, 14)


def get_ohio_state_birthday(year):
    """Get Ohio State Birthday (Feb 19 1803)."""

    return date(year, util.FEB, 19)


def get_nebraska_state_birthday(year):
    """Get Nebraska State Birthday (March 1 1867)."""

    return date(year, util.MAR, 1)


def get_florida_state_birthday(year):
    """Get Florida State Birthday (March 3 1845)."""

    return date(year, util.MAR, 3)


def get_vermont_state_birthday(year):
    """Get Vermont State Birthday (March 4 1791)."""

    return date(year, util.MAR, 4)


def get_maine_state_birthday(year):
    """Get Maine State Birthday (March 15 1820)."""

    return date(year, util.MAR, 1)


def get_maryland_state_birthday(year):
    """Get Maryland State Birthday (April 28 1788)."""

    return date(year, util.APR, 2)


def get_louisiana_state_birthday(year):
    """Get Louisiana State Birthday (April 30 1812)."""

    return date(year, util.APR, 3)


def get_minnesota_state_birthday(year):
    """Get Minnesota State Birthday (May 11 1858)."""

    return date(year, util.MAY, 11)


def get_south_carolina_state_birthday(year):
    """Get South Carolina State Birthday (May 23 1788)."""

    return date(year, util.MAY, 23)


def get_rhode_island_state_birthday(year):
    """Get Rhode Island State Birthday (May 29 1790)."""

    return date(year, util.MAY, 29)


def get_wisconsin_state_birthday(year):
    """Get Wisconsin State Birthday (May 29 1848)."""

    return date(year, util.MAY, 29)


def get_kentucky_state_birthday(year):
    """Get Kentucky State Birthday (June 1 1792)."""

    return date(year, util.JUN, 1)


def get_tennessee_state_birthday(year):
    """Get Tennessee State Birthday (June 1 1796)."""

    return date(year, util.JUN, 1)


def get_arkansas_state_birthday(year):
    """Get Arkansas State Birthday (June 15 1836)."""

    return date(year, util.JUN, 15)


def get_west_virginia_state_birthday(year):
    """Get West Virginia State Birthday (June 20 1863)."""

    return date(year, util.JUN, 20)


def get_new_hampshire_state_birthday(year):
    """Get New Hampshire State Birthday (June 21 1788)."""

    return date(year, util.JUN, 21)


def get_virginia_state_birthday(year):
    """Get Virginia State Birthday (June 25 1788)."""

    return date(year, util.JUN, 25)


def get_idaho_state_birthday(year):
    """Get Idaho State Birthday (July 3 1890)."""

    return date(year, util.JUL, 3)


def get_wyoming_state_birthday(year):
    """Get Wyoming State Birthday (July 10 1890)."""

    return date(year, util.JUL, 10)


def get_new_york_state_birthday(year):
    """Get New York State Birthday (July 26 1788)."""

    return date(year, util.JUL, 26)


def get_colorado_state_birthday(year):
    """Get Colorado State Birthday (Aug 1 1876)."""

    return date(year, util.AUG, 1)


def get_missouri_state_birthday(year):
    """Get Missouri State Birthday (Aug 10 1821)."""

    return date(year, util.AUG, 10)


def get_hawaii_state_birthday(year):
    """Get Hawaii State Birthday (Aug 21 1959)."""

    return date(year, util.AUG, 21)


def get_california_state_birthday(year):
    """Get California State Birthday (Sept 9 1850)."""

    return date(year, util.SEP, 9)


def get_nevada_state_birthday(year):
    """Get Nevada State Birthday (Oct 31 1864)."""

    return date(year, util.OCT, 31)


def get_north_dakota_state_birthday(year):
    """Get North Dakota State Birthday (Nov 2 1889)."""

    return date(year, util.NOV, 2)


def get_south_dakota_state_birthday(year):
    """Get South Dakota State Birthday (Nov 2 1889)."""

    return date(year, util.NOV, 2)


def get_montana_state_birthday(year):
    """Get Montana State Birthday (Nov 8 1889)."""

    return date(year, util.NOV, 8)


def get_washington_state_birthday(year):
    """Get Washington State Birthday (Nov 11 1889)."""

    return date(year, util.NOV, 11)


def get_oklahoma_state_birthday(year):
    """Get Oklahoma State Birthday (Nov 16 1907)."""

    return date(year, util.NOV, 16)


def get_north_carolina_state_birthday(year):
    """Get North Carolina State Birthday (Nov 21 1789)."""

    return date(year, util.NOV, 21)


def get_illinois_state_birthday(year):
    """Get Illinois State Birthday (Dec 3 1818)."""

    return date(year, util.DEC, 3)


def get_delaware_state_birthday(year):
    """Get Delaware State Birthday (Dec 7 1787)."""

    return date(year, util.DEC, 7)


def get_mississippi_state_birthday(year):
    """Get Mississippi State Birthday (Dec 10 1817)."""

    return date(year, util.DEC, 10)


def get_indiana_state_birthday(year):
    """Get Indiana State Birthday (Dec 11 1816)."""

    return date(year, util.DEC, 11)


def get_pennsylvania_state_birthday(year):
    """Get Pennsylvania State Birthday (Dec 12 1787)."""

    return date(year, util.DEC, 12)


def get_alabama_state_birthday(year):
    """Get Alabama State Birthday (Dec 14 1819)."""

    return date(year, util.DEC, 14)


def get_new_jersey_state_birthday(year):
    """Get New Jersey State Birthday (Dec 18 1787)."""

    return date(year, util.DEC, 18)


def get_iowa_state_birthday(year):
    """Get Iowa State Birthday (Dec 28 1846)."""

    return date(year, util.DEC, 28)


def get_texas_state_birthday(year):
    """Get Texas State Birthday (Dec 29 1845)."""

    return date(year, util.DEC, 29)


holidays = {
    "Georgia State Birthday (Jan 2 1788)": get_georgia_state_birthday,
    "Alaska State Birthday (Jan 3 1959)": get_alaska_state_birthday,
    "Utah State Birthday (Jan 4 1896)": get_utah_state_birthday,
    "New Mexico State Birthday (Jan 6 1912)": get_new_mexico_state_birthday,
    "Connecticut State Birthday (Jan 9 1788)": get_connecticut_state_birthday,
    "Michigan State Birthday (Jan 26 1837)": get_michigan_state_birthday,
    "Kansas State Birthday (Jan 29 1861)": get_kansas_state_birthday,
    "Massachusetts State Birthday (Feb 6 1788)": get_massachusetts_state_birthday,
    "Oregon State Birthday (Feb 14 1859)": get_oregon_state_birthday,
    "Arizona State Birthday (Feb 14 1912)": get_arizona_state_birthday,
    "Ohio State Birthday (Feb 19 1803)": get_ohio_state_birthday,
    "Nebraska State Birthday (March 1 1867)": get_nebraska_state_birthday,
    "Florida State Birthday (March 3 1845)": get_florida_state_birthday,
    "Vermont State Birthday (March 4 1791)": get_vermont_state_birthday,
    "Maine State Birthday (March 15 1820)": get_maine_state_birthday,
    "Maryland State Birthday (April 28 1788)": get_maryland_state_birthday,
    "Louisiana State Birthday (April 30 1812)": get_louisiana_state_birthday,
    "Minnesota State Birthday (May 11 1858)": get_minnesota_state_birthday,
    "South Carolina State Birthday (May 23 1788)": get_south_carolina_state_birthday,
    "Rhode Island State Birthday (May 29 1790)": get_rhode_island_state_birthday,
    "Wisconsin State Birthday (May 29 1848)": get_wisconsin_state_birthday,
    "Kentucky State Birthday (June 1 1792)": get_kentucky_state_birthday,
    "Tennessee State Birthday (June 1 1796)": get_tennessee_state_birthday,
    "Arkansas State Birthday (June 15 1836)": get_arkansas_state_birthday,
    "West Virginia State Birthday (June 20 1863)": get_west_virginia_state_birthday,
    "New Hampshire State Birthday (June 21 1788)": get_new_hampshire_state_birthday,
    "Virginia State Birthday (June 25 1788)": get_virginia_state_birthday,
    "Idaho State Birthday (July 3 1890)": get_idaho_state_birthday,
    "Wyoming State Birthday (July 10 1890)": get_wyoming_state_birthday,
    "New York State Birthday (July 26 1788)": get_new_york_state_birthday,
    "Colorado State Birthday (Aug 1 1876)": get_colorado_state_birthday,
    "Missouri State Birthday (Aug 10 1821)": get_missouri_state_birthday,
    "Hawaii State Birthday (Aug 21 1959)": get_hawaii_state_birthday,
    "California State Birthday (Sept 9 1850)": get_california_state_birthday,
    "Nevada State Birthday (Oct 31 1864)": get_nevada_state_birthday,
    "North Dakota State Birthday (Nov 2 1889)": get_north_dakota_state_birthday,
    "South Dakota State Birthday (Nov 2 1889)": get_south_dakota_state_birthday,
    "Montana State Birthday (Nov 8 1889)": get_montana_state_birthday,
    "Washington State Birthday (Nov 11 1889)": get_washington_state_birthday,
    "Oklahoma State Birthday (Nov 16 1907)": get_oklahoma_state_birthday,
    "North Carolina State Birthday (Nov 21 1789)": get_north_carolina_state_birthday,
    "Illinois State Birthday (Dec 3 1818)": get_illinois_state_birthday,
    "Delaware State Birthday (Dec 7 1787)": get_delaware_state_birthday,
    "Mississippi State Birthday (Dec 10 1817)": get_mississippi_state_birthday,
    "Indiana State Birthday (Dec 11 1816)": get_indiana_state_birthday,
    "Pennsylvania State Birthday (Dec 12 1787)": get_pennsylvania_state_birthday,
    "Alabama State Birthday (Dec 14 1819)": get_alabama_state_birthday,
    "New Jersey State Birthday (Dec 18 1787)": get_new_jersey_state_birthday,
    "Iowa State Birthday (Dec 28 1846)": get_iowa_state_birthday,
    "Texas State Birthday (Dec 29 1845)": get_texas_state_birthday,
}
