
if((CMAKE_SYSTEM_PROCESSOR MATCHES "i[3456]86") OR (CMAKE_SYSTEM_PROCESSOR MATCHES "x86_64") OR (CMAKE_SYSTEM_PROCESSOR MATCHES "[aA][mM][dD]64"))
	set(TARGET_ARCH_FAMILY_X86 1)
	if (CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(TARGET_ARCH_X64 1)
		set(TARGET_ARCH_NAME "x86-64")
	elseif (CMAKE_SIZEOF_VOID_P EQUAL 4)
		set(TARGET_ARCH_X86 1)
		set(TARGET_ARCH_NAME "x86")
	endif()
elseif((CMAKE_SYSTEM_PROCESSOR MATCHES "armv[0-9]+") OR (CMAKE_SYSTEM_PROCESSOR MATCHES "aarch64"))
	set(TARGET_ARCH_FAMILY_ARM 1)
	if (CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(TARGET_ARCH_ARM64 1)
		set(TARGET_ARCH_NAME "arm64")
	elseif (CMAKE_SIZEOF_VOID_P EQUAL 4)
		set(TARGET_ARCH_ARM32 1)
		set(TARGET_ARCH_NAME "arm32")
	endif()
else()
	message(FATAL_ERROR "Unsupported Architecture: ${CMAKE_SYSTEM_PROCESSOR}")
endif()
