// !!! autogenerated; do not edit !!!



describe("Grammar Tests", function() {
  var grammar = null;
  beforeEach(function() {
    waitsForPromise(function() {
      return atom.packages.activatePackage("gel")
    });
    runs(function() {
      grammar = atom.grammars.grammarForScopeName("source.edgeql")
    });
  });


  it("test/edgeql/builtins01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("cal\ncfg\nenc\next\nfts\nmath\npg\nstd\nsys")
      expect(tokens[0][0].value).toBe("cal");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[1][0].value).toBe("cfg");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[2][0].value).toBe("enc");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[3][0].value).toBe("ext");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[4][0].value).toBe("fts");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[5][0].value).toBe("math");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[6][0].value).toBe("pg");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[7][0].value).toBe("std");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[8][0].value).toBe("sys");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
    });

  it("test/edgeql/builtins02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("len()\narray_agg()\narray_unpack()\nre_match()\nre_test()\ncount()\nsum()\nrandom()\nuuid_generate_v1mc()\nall()\nany()\nbounded_above()\nbounded_below()\nrange_unpack()\nmultirange_unpack()\nmath::acos()")
      expect(tokens[0][0].value).toBe("len");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[0][1].value).toBe("(");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[0][2].value).toBe(")");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[1][0].value).toBe("array_agg");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[1][1].value).toBe("(");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[1][2].value).toBe(")");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[2][0].value).toBe("array_unpack");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[2][1].value).toBe("(");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[2][2].value).toBe(")");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[3][0].value).toBe("re_match");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[3][1].value).toBe("(");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[3][2].value).toBe(")");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[4][0].value).toBe("re_test");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[4][1].value).toBe("(");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[4][2].value).toBe(")");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[5][0].value).toBe("count");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[5][1].value).toBe("(");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[5][2].value).toBe(")");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[6][0].value).toBe("sum");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[6][1].value).toBe("(");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[6][2].value).toBe(")");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[7][0].value).toBe("random");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[7][1].value).toBe("(");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[7][2].value).toBe(")");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[8][0].value).toBe("uuid_generate_v1mc");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[8][1].value).toBe("(");
      expect(tokens[8][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[8][2].value).toBe(")");
      expect(tokens[8][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[9][0].value).toBe("all");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[9][1].value).toBe("(");
      expect(tokens[9][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[9][2].value).toBe(")");
      expect(tokens[9][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[10][0].value).toBe("any");
      expect(tokens[10][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[10][1].value).toBe("(");
      expect(tokens[10][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[10][2].value).toBe(")");
      expect(tokens[10][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[11][0].value).toBe("bounded_above");
      expect(tokens[11][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[11][1].value).toBe("(");
      expect(tokens[11][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[11][2].value).toBe(")");
      expect(tokens[11][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[12][0].value).toBe("bounded_below");
      expect(tokens[12][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[12][1].value).toBe("(");
      expect(tokens[12][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[12][2].value).toBe(")");
      expect(tokens[12][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[13][0].value).toBe("range_unpack");
      expect(tokens[13][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[13][1].value).toBe("(");
      expect(tokens[13][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[13][2].value).toBe(")");
      expect(tokens[13][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[14][0].value).toBe("multirange_unpack");
      expect(tokens[14][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[14][1].value).toBe("(");
      expect(tokens[14][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[14][2].value).toBe(")");
      expect(tokens[14][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[15][0].value).toBe("math");
      expect(tokens[15][0].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[15][1].value).toBe("::");
      expect(tokens[15][1].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[15][2].value).toBe("acos");
      expect(tokens[15][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[15][3].value).toBe("(");
      expect(tokens[15][3].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[15][4].value).toBe(")");
      expect(tokens[15][4].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
    });

  it("test/edgeql/builtins03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("std::constraint\nmax_value\none_of\nexpression\nmin_value\nregexp\nexclusive\nenum<'aaa', 'bbb'>\nrange<int64>\nmultirange<int64>")
      expect(tokens[0][0].value).toBe("std");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][1].value).toBe("::");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][2].value).toBe("constraint");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[1][0].value).toBe("max_value");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[2][0].value).toBe("one_of");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[3][0].value).toBe("expression");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[4][0].value).toBe("min_value");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[5][0].value).toBe("regexp");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[6][0].value).toBe("exclusive");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[7][0].value).toBe("enum");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[7][1].value).toBe("<");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[7][2].value).toBe("'");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[7][3].value).toBe("aaa");
      expect(tokens[7][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[7][4].value).toBe("'");
      expect(tokens[7][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[7][5].value).toBe(", ");
      expect(tokens[7][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][6].value).toBe("'");
      expect(tokens[7][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[7][7].value).toBe("bbb");
      expect(tokens[7][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[7][8].value).toBe("'");
      expect(tokens[7][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[7][9].value).toBe(">");
      expect(tokens[7][9].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[8][0].value).toBe("range");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[8][1].value).toBe("<");
      expect(tokens[8][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[8][2].value).toBe("int64");
      expect(tokens[8][2].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[8][3].value).toBe(">");
      expect(tokens[8][3].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[9][0].value).toBe("multirange");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[9][1].value).toBe("<");
      expect(tokens[9][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[9][2].value).toBe("int64");
      expect(tokens[9][2].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[9][3].value).toBe(">");
      expect(tokens[9][3].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
    });

  it("test/edgeql/bytes01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("b'this is a bytestring'\nb'this is a \"bytestring\"'\nb'this is a \\'bytestring\\''\nb'this is a \\\"bytestring\\\"'\nb'this \\n is \\\\ a \\xbb bytestring'\nb'this is a bad \\xqq \\a bytestring я'\nb'this is a bad bytestring \\\n'")
      expect(tokens[0][0].value).toBe("b");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[0][1].value).toBe("'");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][2].value).toBe("this is a bytestring");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[0][3].value).toBe("'");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("b");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[1][1].value).toBe("'");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][2].value).toBe("this is a \"bytestring\"");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[1][3].value).toBe("'");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("b");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[2][1].value).toBe("'");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][2].value).toBe("this is a ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[2][3].value).toBe("\\'");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][4].value).toBe("bytestring");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[2][5].value).toBe("\\'");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][6].value).toBe("'");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("b");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[3][1].value).toBe("'");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][2].value).toBe("this is a ");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[3][3].value).toBe("\\\"");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][4].value).toBe("bytestring");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[3][5].value).toBe("\\\"");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][6].value).toBe("'");
      expect(tokens[3][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[4][0].value).toBe("b");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[4][1].value).toBe("'");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][2].value).toBe("this ");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][3].value).toBe("\\n");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][4].value).toBe(" is ");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][5].value).toBe("\\\\");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][6].value).toBe(" a ");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][7].value).toBe("\\xbb");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][8].value).toBe(" bytestring");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][9].value).toBe("'");
      expect(tokens[4][9].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[5][0].value).toBe("b");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[5][1].value).toBe("'");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[5][2].value).toBe("this is a bad ");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][3].value).toBe("\\xqq");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][4].value).toBe(" ");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][5].value).toBe("\\a");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][6].value).toBe(" bytestring ");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][7].value).toBe("я");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][8].value).toBe("'");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[6][0].value).toBe("b");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[6][1].value).toBe("'");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[6][2].value).toBe("this is a bad bytestring ");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[6][3].value).toBe("\\");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[6][4].value).toBe("");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[7][0].value).toBe("'");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/bytes02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("b\"this is a bytestring\"\nb\"this is a 'bytestring'\"\nb\"this is a \\'bytestring\\'\"\nb\"this is a \\\"bytestring\\\"\"\nb\"this \\n is \\\\ a \\xbb bytestring\"\nb\"this is a bad \\xqq \\a bytestring я\"\nb\"this is a bad bytestring \\\n\"")
      expect(tokens[0][0].value).toBe("b");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[0][1].value).toBe("\"");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][2].value).toBe("this is a bytestring");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[0][3].value).toBe("\"");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("b");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[1][1].value).toBe("\"");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][2].value).toBe("this is a 'bytestring'");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[1][3].value).toBe("\"");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("b");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[2][1].value).toBe("\"");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][2].value).toBe("this is a ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[2][3].value).toBe("\\'");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][4].value).toBe("bytestring");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[2][5].value).toBe("\\'");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][6].value).toBe("\"");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("b");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[3][1].value).toBe("\"");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][2].value).toBe("this is a ");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[3][3].value).toBe("\\\"");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][4].value).toBe("bytestring");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[3][5].value).toBe("\\\"");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][6].value).toBe("\"");
      expect(tokens[3][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[4][0].value).toBe("b");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[4][1].value).toBe("\"");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][2].value).toBe("this ");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][3].value).toBe("\\n");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][4].value).toBe(" is ");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][5].value).toBe("\\\\");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][6].value).toBe(" a ");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][7].value).toBe("\\xbb");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[4][8].value).toBe(" bytestring");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[4][9].value).toBe("\"");
      expect(tokens[4][9].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[5][0].value).toBe("b");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[5][1].value).toBe("\"");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[5][2].value).toBe("this is a bad ");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][3].value).toBe("\\xqq");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][4].value).toBe(" ");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][5].value).toBe("\\a");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][6].value).toBe(" bytestring ");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[5][7].value).toBe("я");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[5][8].value).toBe("\"");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[6][0].value).toBe("b");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","storage.type.string.edgeql"]);
      expect(tokens[6][1].value).toBe("\"");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[6][2].value).toBe("this is a bad bytestring ");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[6][3].value).toBe("\\");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","invalid.illegal.bytes.edgeql"]);
      expect(tokens[6][4].value).toBe("");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql"]);
      expect(tokens[7][0].value).toBe("\"");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","string.quoted.bytes.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/cast01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT NOT <bool>Foo.baz;")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("NOT");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("<");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","keyword.operator.cast.begin.edgeql"]);
      expect(tokens[0][5].value).toBe("bool");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","meta.typecast.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][6].value).toBe(">");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","keyword.operator.cast.end.edgeql"]);
      expect(tokens[0][7].value).toBe("Foo.baz");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][8].value).toBe(";");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/cast02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT Foo.bar LIKE <str>Foo.baz;")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" Foo.bar ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("LIKE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("<");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","keyword.operator.cast.begin.edgeql"]);
      expect(tokens[0][5].value).toBe("str");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","meta.typecast.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][6].value).toBe(">");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","keyword.operator.cast.end.edgeql"]);
      expect(tokens[0][7].value).toBe("Foo.baz");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][8].value).toBe(";");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/cast03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT Foo.bar LIMIT <int64>'42';")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" Foo.bar ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("LIMIT");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("<");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","keyword.operator.cast.begin.edgeql"]);
      expect(tokens[0][5].value).toBe("int64");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","meta.typecast.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][6].value).toBe(">");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","keyword.operator.cast.end.edgeql"]);
      expect(tokens[0][7].value).toBe("'");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("42");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[0][9].value).toBe("'");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[0][10].value).toBe(";");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/cast04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT Foo.bar OFFSET <int64>'42';")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" Foo.bar ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("OFFSET");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("<");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","keyword.operator.cast.begin.edgeql"]);
      expect(tokens[0][5].value).toBe("int64");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","meta.typecast.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][6].value).toBe(">");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","keyword.operator.cast.end.edgeql"]);
      expect(tokens[0][7].value).toBe("'");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("42");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[0][9].value).toBe("'");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[0][10].value).toBe(";");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/create01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CreatE CONSTRAINT std::regexp EXTENDING std::constraint {\n    SET errmessage := 'invalid {subject}';\n    SET expr := re_test(subject, $0);\n};")
      expect(tokens[0][0].value).toBe("CreatE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("CONSTRAINT");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("std");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("regexp");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[0][7].value).toBe(" ");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][8].value).toBe("EXTENDING");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][9].value).toBe(" ");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][10].value).toBe("std");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][11].value).toBe("::");
      expect(tokens[0][11].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][12].value).toBe("constraint");
      expect(tokens[0][12].scopes).toEqual(["source.edgeql","support.function.constraint.builtin.edgeql"]);
      expect(tokens[0][13].value).toBe(" ");
      expect(tokens[0][13].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][14].value).toBe("{");
      expect(tokens[0][14].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("SET");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][2].value).toBe(" errmessage ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe(":=");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[1][4].value).toBe(" ");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][5].value).toBe("'");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][6].value).toBe("invalid {subject}");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][7].value).toBe("'");
      expect(tokens[1][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][8].value).toBe(";");
      expect(tokens[1][8].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[2][0].value).toBe("    ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("SET");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][2].value).toBe(" expr ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][3].value).toBe(":=");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][4].value).toBe(" ");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][5].value).toBe("re_test");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[2][6].value).toBe("(");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[2][7].value).toBe("subject");
      expect(tokens[2][7].scopes).toEqual(["source.edgeql","meta.function-call.edgeql"]);
      expect(tokens[2][8].value).toBe(",");
      expect(tokens[2][8].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.separator.arguments.edgeql"]);
      expect(tokens[2][9].value).toBe(" ");
      expect(tokens[2][9].scopes).toEqual(["source.edgeql","meta.function-call.edgeql"]);
      expect(tokens[2][10].value).toBe("$");
      expect(tokens[2][10].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[2][11].value).toBe("0");
      expect(tokens[2][11].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[2][12].value).toBe(")");
      expect(tokens[2][12].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[2][13].value).toBe(";");
      expect(tokens[2][13].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[3][0].value).toBe("}");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[3][1].value).toBe(";");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/create02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE AGGREGATE std::array_agg(SET OF std::anytype) -> array<std::anytype>\n    FROM SQL AGGREGATE 'array_agg';")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("AGGREGATE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("std");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("array_agg");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[0][7].value).toBe("(");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("SET");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][9].value).toBe(" ");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][10].value).toBe("OF");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][11].value).toBe(" ");
      expect(tokens[0][11].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][12].value).toBe("std");
      expect(tokens[0][12].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][13].value).toBe("::");
      expect(tokens[0][13].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][14].value).toBe("anytype");
      expect(tokens[0][14].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][15].value).toBe(")");
      expect(tokens[0][15].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[0][16].value).toBe(" ");
      expect(tokens[0][16].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][17].value).toBe("->");
      expect(tokens[0][17].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][18].value).toBe(" ");
      expect(tokens[0][18].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][19].value).toBe("array");
      expect(tokens[0][19].scopes).toEqual(["source.edgeql","storage.type.edgeql"]);
      expect(tokens[0][20].value).toBe("<");
      expect(tokens[0][20].scopes).toEqual(["source.edgeql","storage.type.placeholder.begin.edgeql"]);
      expect(tokens[0][21].value).toBe("std");
      expect(tokens[0][21].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][22].value).toBe("::");
      expect(tokens[0][22].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][23].value).toBe("anytype");
      expect(tokens[0][23].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][24].value).toBe(">");
      expect(tokens[0][24].scopes).toEqual(["source.edgeql","storage.type.placeholder.end.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("FROM");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][2].value).toBe(" SQL ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("AGGREGATE");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][4].value).toBe(" ");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][5].value).toBe("'");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][6].value).toBe("array_agg");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][7].value).toBe("'");
      expect(tokens[1][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][8].value).toBe(";");
      expect(tokens[1][8].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/create03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE FUNCTION std::len(array<std::anytype>) -> std::int64\n    FROM SQL $$\n        SELECT array_length($1, 1)::bigint\n    $$;\narray<std::anytype>  # back to edgeql")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("FUNCTION");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("std");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("len");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[0][7].value).toBe("(");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("array");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","storage.type.edgeql"]);
      expect(tokens[0][9].value).toBe("<");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql","storage.type.placeholder.begin.edgeql"]);
      expect(tokens[0][10].value).toBe("std");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][11].value).toBe("::");
      expect(tokens[0][11].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][12].value).toBe("anytype");
      expect(tokens[0][12].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][13].value).toBe(">");
      expect(tokens[0][13].scopes).toEqual(["source.edgeql","storage.type.placeholder.end.edgeql"]);
      expect(tokens[0][14].value).toBe(")");
      expect(tokens[0][14].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[0][15].value).toBe(" ");
      expect(tokens[0][15].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][16].value).toBe("->");
      expect(tokens[0][16].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][17].value).toBe(" ");
      expect(tokens[0][17].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][18].value).toBe("std");
      expect(tokens[0][18].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][19].value).toBe("::");
      expect(tokens[0][19].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][20].value).toBe("int64");
      expect(tokens[0][20].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("FROM");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][2].value).toBe(" SQL ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("$$");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][0].value).toBe("        SELECT array_length($1, 1)::bigint");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("    ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe("$$");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][2].value).toBe(";");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[4][0].value).toBe("array");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","storage.type.edgeql"]);
      expect(tokens[4][1].value).toBe("<");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","storage.type.placeholder.begin.edgeql"]);
      expect(tokens[4][2].value).toBe("std");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[4][3].value).toBe("::");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][4].value).toBe("anytype");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[4][5].value).toBe(">");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","storage.type.placeholder.end.edgeql"]);
      expect(tokens[4][6].value).toBe("  ");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][7].value).toBe("#");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql","comment.line.number-sign.edgeql","punctuation.definition.comment.edgeql"]);
      expect(tokens[4][8].value).toBe(" back to edgeql");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql","comment.line.number-sign.edgeql"]);
    });

  it("test/edgeql/create04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE FUNCTION std::len(array<std::anytype>) -> std::int64\n    FROm Sql $a$\n        SELECT array_length($1, 1)::bigint\n    $a$;\narray<std::anytype>  # back to edgeql")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("FUNCTION");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("std");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("len");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[0][7].value).toBe("(");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("array");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","storage.type.edgeql"]);
      expect(tokens[0][9].value).toBe("<");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql","storage.type.placeholder.begin.edgeql"]);
      expect(tokens[0][10].value).toBe("std");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][11].value).toBe("::");
      expect(tokens[0][11].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][12].value).toBe("anytype");
      expect(tokens[0][12].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][13].value).toBe(">");
      expect(tokens[0][13].scopes).toEqual(["source.edgeql","storage.type.placeholder.end.edgeql"]);
      expect(tokens[0][14].value).toBe(")");
      expect(tokens[0][14].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[0][15].value).toBe(" ");
      expect(tokens[0][15].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][16].value).toBe("->");
      expect(tokens[0][16].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][17].value).toBe(" ");
      expect(tokens[0][17].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][18].value).toBe("std");
      expect(tokens[0][18].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][19].value).toBe("::");
      expect(tokens[0][19].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][20].value).toBe("int64");
      expect(tokens[0][20].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("FROm");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][2].value).toBe(" Sql ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("$a$");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][0].value).toBe("        SELECT array_length($1, 1)::bigint");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("    ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe("$a$");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][2].value).toBe(";");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[4][0].value).toBe("array");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","storage.type.edgeql"]);
      expect(tokens[4][1].value).toBe("<");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","storage.type.placeholder.begin.edgeql"]);
      expect(tokens[4][2].value).toBe("std");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[4][3].value).toBe("::");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][4].value).toBe("anytype");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[4][5].value).toBe(">");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","storage.type.placeholder.end.edgeql"]);
      expect(tokens[4][6].value).toBe("  ");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][7].value).toBe("#");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql","comment.line.number-sign.edgeql","punctuation.definition.comment.edgeql"]);
      expect(tokens[4][8].value).toBe(" back to edgeql");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql","comment.line.number-sign.edgeql"]);
    });

  it("test/edgeql/create05.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE FUNCTION test::my_edgeql_func2(std::str)\n        -> sys::Concept\n    FROM EdgeQL $$\n        SELECT\n            sys::Concept\n        FILTER sys::Concept.name = $1\n    $$;")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("FUNCTION");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("test");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("my_edgeql_func2");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][7].value).toBe("(");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[0][8].value).toBe("std");
      expect(tokens[0][8].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][9].value).toBe("::");
      expect(tokens[0][9].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][10].value).toBe("str");
      expect(tokens[0][10].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[0][11].value).toBe(")");
      expect(tokens[0][11].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[1][0].value).toBe("        ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("->");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][2].value).toBe(" ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("sys");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[1][4].value).toBe("::");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[1][5].value).toBe("Concept");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("    ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("FROM");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][2].value).toBe(" EdgeQL ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][3].value).toBe("$$");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][0].value).toBe("        ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe("SELECT");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][0].value).toBe("            ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("sys");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[4][2].value).toBe("::");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][3].value).toBe("Concept");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][0].value).toBe("        ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("FILTER");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][2].value).toBe(" ");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][3].value).toBe("sys");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[5][4].value).toBe("::");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[5][5].value).toBe("Concept.name ");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][6].value).toBe("=");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[5][7].value).toBe(" ");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][8].value).toBe("$");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[5][9].value).toBe("1");
      expect(tokens[5][9].scopes).toEqual(["source.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[6][0].value).toBe("    ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe("$$");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[6][2].value).toBe(";");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/ddl_function01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE FUNCTION test::call1(\n    s: str,\n    VARIADIC a: int64,\n    NAMED ONLY suffix: str = '-suf',\n) -> std::str\n    FROM EdgeQL $$\n        SELECT 'foo';\n    $$;")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("FUNCTION");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("test");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("call1");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][7].value).toBe("(");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][0].value).toBe("    s");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe(":");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[1][2].value).toBe(" ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("str");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[1][4].value).toBe(",");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[2][0].value).toBe("    ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("VARIADIC");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][2].value).toBe(" a");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][3].value).toBe(":");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[2][4].value).toBe(" ");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][5].value).toBe("int64");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[2][6].value).toBe(",");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("    ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe("NAMED ONLY");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][2].value).toBe(" suffix");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][3].value).toBe(":");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[3][4].value).toBe(" ");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][5].value).toBe("str");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[3][6].value).toBe(" ");
      expect(tokens[3][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][7].value).toBe("=");
      expect(tokens[3][7].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[3][8].value).toBe(" ");
      expect(tokens[3][8].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][9].value).toBe("'");
      expect(tokens[3][9].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][10].value).toBe("-suf");
      expect(tokens[3][10].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][11].value).toBe("'");
      expect(tokens[3][11].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][12].value).toBe(",");
      expect(tokens[3][12].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[4][0].value).toBe(")");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[4][1].value).toBe(" ");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][2].value).toBe("->");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][3].value).toBe(" ");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][4].value).toBe("std");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[4][5].value).toBe("::");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][6].value).toBe("str");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[5][0].value).toBe("    ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("FROM");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][2].value).toBe(" EdgeQL ");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][3].value).toBe("$$");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[6][0].value).toBe("        ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe("SELECT");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[6][2].value).toBe(" ");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][3].value).toBe("'");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[6][4].value).toBe("foo");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[6][5].value).toBe("'");
      expect(tokens[6][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[6][6].value).toBe(";");
      expect(tokens[6][6].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[7][0].value).toBe("    ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe("$$");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[7][2].value).toBe(";");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/delete01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("DELETE test::DeleteTest;")
      expect(tokens[0][0].value).toBe("DELETE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" test");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("::");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][3].value).toBe("DeleteTest");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe(";");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/delete02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nDELETE (SELECT DeleteTest\n        FILTER DeleteTest.name = 'bad name');")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("DELETE");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("(");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][3].value).toBe("SELECT");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][4].value).toBe(" DeleteTest");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("        ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("FILTER");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][2].value).toBe(" DeleteTest.name ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][3].value).toBe("=");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][4].value).toBe(" ");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][5].value).toBe("'");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][6].value).toBe("bad name");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][7].value).toBe("'");
      expect(tokens[2][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][8].value).toBe(")");
      expect(tokens[2][8].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][9].value).toBe(";");
      expect(tokens[2][9].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/for01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nFOR C IN {Card}\nUNION (C.name, Card.name);")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("FOR");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" C ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("IN");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("{");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][5].value).toBe("Card");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][6].value).toBe("}");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][0].value).toBe("UNION");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe("(");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][3].value).toBe("C.name");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe(",");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[2][5].value).toBe(" Card.name");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][6].value).toBe(")");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][7].value).toBe(";");
      expect(tokens[2][7].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/for02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nFOR X IN {Card.name, User.name}\nUNION X\nFILTER Card.element = 'Air';")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("FOR");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" X ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("IN");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("{");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][5].value).toBe("Card.name");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][6].value).toBe(",");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[1][7].value).toBe(" User.name");
      expect(tokens[1][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][8].value).toBe("}");
      expect(tokens[1][8].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][0].value).toBe("UNION");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" X");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("FILTER");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(" Card.element ");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][2].value).toBe("=");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[3][3].value).toBe(" ");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][4].value).toBe("'");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][5].value).toBe("Air");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][6].value).toBe("'");
      expect(tokens[3][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][7].value).toBe(";");
      expect(tokens[3][7].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/group01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nGROUP User\nUSING _ := User.name\nBY _\nINTO User\nUNION count(User.<owner);")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("GROUP");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" User");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("USING");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" _ ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(":=");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][3].value).toBe(" User.name");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("BY");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(" _");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][0].value).toBe("INTO");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][1].value).toBe(" User");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][0].value).toBe("UNION");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][1].value).toBe(" ");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][2].value).toBe("count");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[5][3].value).toBe("(");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[5][4].value).toBe("User");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","meta.function-call.edgeql"]);
      expect(tokens[5][5].value).toBe(".<");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[5][6].value).toBe("owner");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql","meta.function-call.edgeql"]);
      expect(tokens[5][7].value).toBe(")");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[5][8].value).toBe(";");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/group02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nGROUP Issue\nUSING B :=  Issue.status.name\nBY B\nINTO Issue\nUNION _ := (\n    sum := sum(<int64>Issue.number),\n    status := B,\n)\nFILTER\n    _.sum > 5\nORDER BY\n    B;")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("GROUP");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" Issue");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("USING");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" B ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(":=");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][3].value).toBe("  Issue.status.name");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("BY");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(" B");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][0].value).toBe("INTO");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][1].value).toBe(" Issue");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][0].value).toBe("UNION");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][1].value).toBe(" _ ");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][2].value).toBe(":=");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[5][3].value).toBe(" ");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][4].value).toBe("(");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[6][0].value).toBe("    sum ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe(":=");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][2].value).toBe(" ");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][3].value).toBe("sum");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.function.builtin.edgeql"]);
      expect(tokens[6][4].value).toBe("(");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.begin.edgeql"]);
      expect(tokens[6][5].value).toBe("<");
      expect(tokens[6][5].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][6].value).toBe("int64");
      expect(tokens[6][6].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[6][7].value).toBe(">");
      expect(tokens[6][7].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][8].value).toBe("Issue.number");
      expect(tokens[6][8].scopes).toEqual(["source.edgeql","meta.function-call.edgeql"]);
      expect(tokens[6][9].value).toBe(")");
      expect(tokens[6][9].scopes).toEqual(["source.edgeql","meta.function-call.edgeql","punctuation.definition.arguments.end.edgeql"]);
      expect(tokens[6][10].value).toBe(",");
      expect(tokens[6][10].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[7][0].value).toBe("    status ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe(":=");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[7][2].value).toBe(" B");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][3].value).toBe(",");
      expect(tokens[7][3].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[8][0].value).toBe(")");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[9][0].value).toBe("FILTER");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[10][0].value).toBe("    _.sum ");
      expect(tokens[10][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[10][1].value).toBe(">");
      expect(tokens[10][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[10][2].value).toBe(" ");
      expect(tokens[10][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[10][3].value).toBe("5");
      expect(tokens[10][3].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[11][0].value).toBe("ORDER");
      expect(tokens[11][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[11][1].value).toBe(" ");
      expect(tokens[11][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[11][2].value).toBe("BY");
      expect(tokens[11][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[12][0].value).toBe("    B");
      expect(tokens[12][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[12][1].value).toBe(";");
      expect(tokens[12][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/ident01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("INSERT std::delete_pointer;")
      expect(tokens[0][0].value).toBe("INSERT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("std");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][3].value).toBe("::");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][4].value).toBe("delete_pointer");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][5].value).toBe(";");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/ident02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE TYPE std::delete_pointer;")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("TYPE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("std");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","support.other.module.builtin.edgeql"]);
      expect(tokens[0][5].value).toBe("::");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][6].value).toBe("delete_pointer");
      expect(tokens[0][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][7].value).toBe(";");
      expect(tokens[0][7].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/insert01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("INSERT test::Subordinate {\n    name := 'subtest 1'\n};")
      expect(tokens[0][0].value).toBe("INSERT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" test");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("::");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][3].value).toBe("Subordinate ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("{");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("name ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe(":=");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("'");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][5].value).toBe("subtest 1");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][6].value).toBe("'");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("}");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][1].value).toBe(";");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/insert02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("INSERT test::InsertTest {\n    name := 'insert nested',\n    l2 := 0,\n    subordinates := (\n        SELECT test::Subordinate\n        FILTER test::Subordinate.name LIKE 'subtest%'\n    )\n};")
      expect(tokens[0][0].value).toBe("INSERT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" test");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("::");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][3].value).toBe("InsertTest ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("{");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("name ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe(":=");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("'");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][5].value).toBe("insert nested");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][6].value).toBe("'");
      expect(tokens[1][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][7].value).toBe(",");
      expect(tokens[1][7].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[2][0].value).toBe("    l2 ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe(":=");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][2].value).toBe(" ");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][3].value).toBe("0");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[2][4].value).toBe(",");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("    subordinates ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(":=");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[3][2].value).toBe(" ");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][3].value).toBe("(");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[4][0].value).toBe("        ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("SELECT");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][2].value).toBe(" test");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][3].value).toBe("::");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][4].value).toBe("Subordinate");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][0].value).toBe("        ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("FILTER");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][2].value).toBe(" test");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][3].value).toBe("::");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[5][4].value).toBe("Subordinate.name ");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][5].value).toBe("LIKE");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][6].value).toBe(" ");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][7].value).toBe("'");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[5][8].value).toBe("subtest%");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[5][9].value).toBe("'");
      expect(tokens[5][9].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[6][0].value).toBe("    ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe(")");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][0].value).toBe("}");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][1].value).toBe(";");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/insert03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nINSERT InsertTest {\n    name := 'insert nested 2',\n    l2 := 0,\n    subordinates := (\n        SELECT Subordinate {\n            @comment := (SELECT 'comment ' + Subordinate.name)\n        }\n        FILTER Subordinate.name IN {'subtest 3', 'subtest 4'}\n    )\n};")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("INSERT");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" InsertTest ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("{");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("    ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("name ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(":=");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][3].value).toBe(" ");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe("'");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][5].value).toBe("insert nested 2");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][6].value).toBe("'");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][7].value).toBe(",");
      expect(tokens[2][7].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("    l2 ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(":=");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[3][2].value).toBe(" ");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][3].value).toBe("0");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[3][4].value).toBe(",");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[4][0].value).toBe("    subordinates ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe(":=");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[4][2].value).toBe(" ");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][3].value).toBe("(");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][0].value).toBe("        ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("SELECT");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][2].value).toBe(" Subordinate ");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][3].value).toBe("{");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[6][0].value).toBe("            ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe("@");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","support.other.linkproperty.edgeql"]);
      expect(tokens[6][2].value).toBe("comment");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","support.other.linkproperty.edgeql"]);
      expect(tokens[6][3].value).toBe(" ");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][4].value).toBe(":=");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][5].value).toBe(" ");
      expect(tokens[6][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][6].value).toBe("(");
      expect(tokens[6][6].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[6][7].value).toBe("SELECT");
      expect(tokens[6][7].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[6][8].value).toBe(" ");
      expect(tokens[6][8].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][9].value).toBe("'");
      expect(tokens[6][9].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[6][10].value).toBe("comment ");
      expect(tokens[6][10].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[6][11].value).toBe("'");
      expect(tokens[6][11].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[6][12].value).toBe(" ");
      expect(tokens[6][12].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][13].value).toBe("+");
      expect(tokens[6][13].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][14].value).toBe(" Subordinate.name");
      expect(tokens[6][14].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][15].value).toBe(")");
      expect(tokens[6][15].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][0].value).toBe("        ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe("}");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[8][0].value).toBe("        ");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][1].value).toBe("FILTER");
      expect(tokens[8][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[8][2].value).toBe(" Subordinate.name ");
      expect(tokens[8][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][3].value).toBe("IN");
      expect(tokens[8][3].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[8][4].value).toBe(" ");
      expect(tokens[8][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][5].value).toBe("{");
      expect(tokens[8][5].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[8][6].value).toBe("'");
      expect(tokens[8][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[8][7].value).toBe("subtest 3");
      expect(tokens[8][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[8][8].value).toBe("'");
      expect(tokens[8][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[8][9].value).toBe(",");
      expect(tokens[8][9].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[8][10].value).toBe(" ");
      expect(tokens[8][10].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][11].value).toBe("'");
      expect(tokens[8][11].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[8][12].value).toBe("subtest 4");
      expect(tokens[8][12].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[8][13].value).toBe("'");
      expect(tokens[8][13].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[8][14].value).toBe("}");
      expect(tokens[8][14].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[9][0].value).toBe("    ");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[9][1].value).toBe(")");
      expect(tokens[9][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[10][0].value).toBe("}");
      expect(tokens[10][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[10][1].value).toBe(";");
      expect(tokens[10][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/keywords01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("FALSE\nEMPTY\nTRUE")
      expect(tokens[0][0].value).toBe("FALSE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","constant.language.boolean.false.edgeql"]);
      expect(tokens[1][0].value).toBe("EMPTY");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","constant.language.empty.edgeql"]);
      expect(tokens[2][0].value).toBe("TRUE");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","constant.language.boolean.true.edgeql"]);
    });

  it("test/edgeql/keywords02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("FOR;\nSELECT;\nGROUP;\nINSERT;\nUPDATE;\nDELETE;")
      expect(tokens[0][0].value).toBe("FOR");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(";");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[1][0].value).toBe("SELECT");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(";");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[2][0].value).toBe("GROUP");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(";");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[3][0].value).toBe("INSERT");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(";");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[4][0].value).toBe("UPDATE");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][1].value).toBe(";");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[5][0].value).toBe("DELETE");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][1].value).toBe(";");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/keywords03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("ABSTRACT\nADMINISTER\nAFTER\nAS\nASC\nANNOTATION\nBEFORE\nBRANCH\nBY\nCARDINALITY\nCONSTRAINT\nDATABASE\nDEFAULT\nDEFERRED\nDELEGATED\nDESC\nFINAL\nFIRST\nFROM\nINDEX\nINTERSECT\nINTO\nLAST\nLINK\nMIGRATION\nNAMED ONLY\nOF\nON\nONLY\nOVERLOADED\nPROPERTY\nRENAME\nRESTRICT\nROLE\nSCALAR\nSCHEMA\nSOURCE\nTARGET\nTHEN\nTO\nTRANSACTION\nTYPE\nUSING\nVIEW\nAGGREGATE\nALL\nALTER\nAND\nCOMMIT\nCOMMITTED\nCREATE\nDELETE\nDETACHED\nDISTINCT\nDROP\nEACH\nELSE\nEXCEPT\nEXISTS\nEXPLAIN\nEXTENDING\nFILTER\nFOR\nFUNCTION\nFUTURE\nGET\nGROUP\nIF\nILIKE\nIN\nINSERT\nINTROSPECT\nIS\nLIKE\nLIMIT\nMODULE\nNOT\nOFFSET\nOPTIONAL\nOR\nORDER\nOVER\nPARTITION\nREQUIRED\nREWRITE\nROLLBACK\nSELECT\nSET\nSTART\nTEMPLATE\nTRIGGER\nTYPEOF\nUNION\nUPDATE\nVARIADIC\nWITH")
      expect(tokens[0][0].value).toBe("ABSTRACT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][0].value).toBe("ADMINISTER");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][0].value).toBe("AFTER");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][0].value).toBe("AS");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][0].value).toBe("ASC");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][0].value).toBe("ANNOTATION");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[6][0].value).toBe("BEFORE");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[7][0].value).toBe("BRANCH");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[8][0].value).toBe("BY");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[9][0].value).toBe("CARDINALITY");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[10][0].value).toBe("CONSTRAINT");
      expect(tokens[10][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[11][0].value).toBe("DATABASE");
      expect(tokens[11][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[12][0].value).toBe("DEFAULT");
      expect(tokens[12][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[13][0].value).toBe("DEFERRED");
      expect(tokens[13][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[14][0].value).toBe("DELEGATED");
      expect(tokens[14][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[15][0].value).toBe("DESC");
      expect(tokens[15][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[16][0].value).toBe("FINAL");
      expect(tokens[16][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[17][0].value).toBe("FIRST");
      expect(tokens[17][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[18][0].value).toBe("FROM");
      expect(tokens[18][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[19][0].value).toBe("INDEX");
      expect(tokens[19][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[20][0].value).toBe("INTERSECT");
      expect(tokens[20][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[21][0].value).toBe("INTO");
      expect(tokens[21][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[22][0].value).toBe("LAST");
      expect(tokens[22][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[23][0].value).toBe("LINK");
      expect(tokens[23][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[24][0].value).toBe("MIGRATION");
      expect(tokens[24][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[25][0].value).toBe("NAMED ONLY");
      expect(tokens[25][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[26][0].value).toBe("OF");
      expect(tokens[26][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[27][0].value).toBe("ON");
      expect(tokens[27][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[28][0].value).toBe("ONLY");
      expect(tokens[28][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[29][0].value).toBe("OVERLOADED");
      expect(tokens[29][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[30][0].value).toBe("PROPERTY");
      expect(tokens[30][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[31][0].value).toBe("RENAME");
      expect(tokens[31][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[32][0].value).toBe("RESTRICT");
      expect(tokens[32][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[33][0].value).toBe("ROLE");
      expect(tokens[33][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[34][0].value).toBe("SCALAR");
      expect(tokens[34][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[35][0].value).toBe("SCHEMA");
      expect(tokens[35][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[36][0].value).toBe("SOURCE");
      expect(tokens[36][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[37][0].value).toBe("TARGET");
      expect(tokens[37][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[38][0].value).toBe("THEN");
      expect(tokens[38][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[39][0].value).toBe("TO");
      expect(tokens[39][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[40][0].value).toBe("TRANSACTION");
      expect(tokens[40][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[41][0].value).toBe("TYPE");
      expect(tokens[41][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[42][0].value).toBe("USING");
      expect(tokens[42][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[43][0].value).toBe("VIEW");
      expect(tokens[43][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[44][0].value).toBe("AGGREGATE");
      expect(tokens[44][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[45][0].value).toBe("ALL");
      expect(tokens[45][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[46][0].value).toBe("ALTER");
      expect(tokens[46][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[47][0].value).toBe("AND");
      expect(tokens[47][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[48][0].value).toBe("COMMIT");
      expect(tokens[48][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[49][0].value).toBe("COMMITTED");
      expect(tokens[49][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[50][0].value).toBe("CREATE");
      expect(tokens[50][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[51][0].value).toBe("DELETE");
      expect(tokens[51][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[52][0].value).toBe("DETACHED");
      expect(tokens[52][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[53][0].value).toBe("DISTINCT");
      expect(tokens[53][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[54][0].value).toBe("DROP");
      expect(tokens[54][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[55][0].value).toBe("EACH");
      expect(tokens[55][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[56][0].value).toBe("ELSE");
      expect(tokens[56][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[57][0].value).toBe("EXCEPT");
      expect(tokens[57][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[58][0].value).toBe("EXISTS");
      expect(tokens[58][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[59][0].value).toBe("EXPLAIN");
      expect(tokens[59][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[60][0].value).toBe("EXTENDING");
      expect(tokens[60][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[61][0].value).toBe("FILTER");
      expect(tokens[61][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[62][0].value).toBe("FOR");
      expect(tokens[62][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[63][0].value).toBe("FUNCTION");
      expect(tokens[63][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[64][0].value).toBe("FUTURE");
      expect(tokens[64][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[65][0].value).toBe("GET");
      expect(tokens[65][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[66][0].value).toBe("GROUP");
      expect(tokens[66][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[67][0].value).toBe("IF");
      expect(tokens[67][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[68][0].value).toBe("ILIKE");
      expect(tokens[68][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[69][0].value).toBe("IN");
      expect(tokens[69][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[70][0].value).toBe("INSERT");
      expect(tokens[70][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[71][0].value).toBe("INTROSPECT");
      expect(tokens[71][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[72][0].value).toBe("IS");
      expect(tokens[72][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[73][0].value).toBe("LIKE");
      expect(tokens[73][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[74][0].value).toBe("LIMIT");
      expect(tokens[74][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[75][0].value).toBe("MODULE");
      expect(tokens[75][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[76][0].value).toBe("NOT");
      expect(tokens[76][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[77][0].value).toBe("OFFSET");
      expect(tokens[77][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[78][0].value).toBe("OPTIONAL");
      expect(tokens[78][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[79][0].value).toBe("OR");
      expect(tokens[79][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[80][0].value).toBe("ORDER");
      expect(tokens[80][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[81][0].value).toBe("OVER");
      expect(tokens[81][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[82][0].value).toBe("PARTITION");
      expect(tokens[82][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[83][0].value).toBe("REQUIRED");
      expect(tokens[83][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[84][0].value).toBe("REWRITE");
      expect(tokens[84][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[85][0].value).toBe("ROLLBACK");
      expect(tokens[85][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[86][0].value).toBe("SELECT");
      expect(tokens[86][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[87][0].value).toBe("SET");
      expect(tokens[87][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[88][0].value).toBe("START");
      expect(tokens[88][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[89][0].value).toBe("TEMPLATE");
      expect(tokens[89][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[90][0].value).toBe("TRIGGER");
      expect(tokens[90][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[91][0].value).toBe("TYPEOF");
      expect(tokens[91][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[92][0].value).toBe("UNION");
      expect(tokens[92][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[93][0].value).toBe("UPDATE");
      expect(tokens[93][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[94][0].value).toBe("VARIADIC");
      expect(tokens[94][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[95][0].value).toBe("WITH");
      expect(tokens[95][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
    });

  it("test/edgeql/keywords04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("__source__\n__subject__\n__type__\n__default__")
      expect(tokens[0][0].value).toBe("__source__");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","support.other.link.builtin.edgeql"]);
      expect(tokens[1][0].value).toBe("__subject__");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","support.other.link.builtin.edgeql"]);
      expect(tokens[2][0].value).toBe("__type__");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","support.other.link.builtin.edgeql"]);
      expect(tokens[3][0].value).toBe("__default__");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","support.other.link.builtin.edgeql"]);
    });

  it("test/edgeql/names01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE DATABASE mytestdb;\nCREATE DATABASE `mytestdb`;\nCREATE DATABASE `SET`;\nCREATE DATABASE `CREATE`;")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("DATABASE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" mytestdb");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe(";");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[1][0].value).toBe("CREATE");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("DATABASE");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("`mytestdb`");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[1][5].value).toBe(";");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[2][0].value).toBe("CREATE");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe("DATABASE");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][3].value).toBe(" ");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe("`SET`");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[2][5].value).toBe(";");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[3][0].value).toBe("CREATE");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(" ");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][2].value).toBe("DATABASE");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][3].value).toBe(" ");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][4].value).toBe("`CREATE`");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[3][5].value).toBe(";");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/names02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("CREATE DATABASE `mytest\\\"db\\\"`;\nCREATE DATABASE `mytest\\'db\\'`;\nCREATE DATABASE `some.db`;")
      expect(tokens[0][0].value).toBe("CREATE");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("DATABASE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" ");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][4].value).toBe("`mytest\\\"db\\\"`");
      expect(tokens[0][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[0][5].value).toBe(";");
      expect(tokens[0][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[1][0].value).toBe("CREATE");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" ");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("DATABASE");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("`mytest\\'db\\'`");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[1][5].value).toBe(";");
      expect(tokens[1][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
      expect(tokens[2][0].value).toBe("CREATE");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe("DATABASE");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][3].value).toBe(" ");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe("`some.db`");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[2][5].value).toBe(";");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/names03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("foo::std\nFoo.std\nFoo.<std\nFoo.>std\nfoo::select\nFoo.select\nFoo.<select\nFoo.>select")
      expect(tokens[0][0].value).toBe("foo");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][1].value).toBe("::");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[0][2].value).toBe("std");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("Foo.std");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("Foo");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe(".<");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[2][2].value).toBe("std");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][0].value).toBe("Foo");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(".>");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[3][2].value).toBe("std");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][0].value).toBe("foo");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("::");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[4][2].value).toBe("select");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][0].value).toBe("Foo.select");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][0].value).toBe("Foo");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe(".<");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[6][2].value).toBe("select");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][0].value).toBe("Foo");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe(".>");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[7][2].value).toBe("select");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql"]);
    });

  it("test/edgeql/number01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("123\n123_456\n1_2_3_4_5_6")
      expect(tokens[0][0].value).toBe("123");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[1][0].value).toBe("123_456");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[2][0].value).toBe("1_2_3_4_5_6");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
    });

  it("test/edgeql/number02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("123.456\n0.456\n.01234\n123e5\n123e-5\n123.456e+5\n0.456e-5")
      expect(tokens[0][0].value).toBe("123.456");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[1][0].value).toBe("0.456");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[2][0].value).toBe(".01234");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[3][0].value).toBe("123");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[3][1].value).toBe("e");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql","storage.type.number.edgeql"]);
      expect(tokens[3][2].value).toBe("5");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[4][0].value).toBe("123");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[4][1].value).toBe("e-");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql","storage.type.number.edgeql"]);
      expect(tokens[4][2].value).toBe("5");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[5][0].value).toBe("123.456");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[5][1].value).toBe("e+");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql","storage.type.number.edgeql"]);
      expect(tokens[5][2].value).toBe("5");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[6][0].value).toBe("0.456");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
      expect(tokens[6][1].value).toBe("e-");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql","storage.type.number.edgeql"]);
      expect(tokens[6][2].value).toBe("5");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","constant.numeric.float.edgeql"]);
    });

  it("test/edgeql/number03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("123n\n123_456n\n1_2_3_4_5_6n")
      expect(tokens[0][0].value).toBe("123");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[0][1].value).toBe("n");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[1][0].value).toBe("123_456");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[1][1].value).toBe("n");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[2][0].value).toBe("1_2_3_4_5_6");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[2][1].value).toBe("n");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
    });

  it("test/edgeql/number04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("123.456n\n0.456n\n.01234n\n123e5n\n123e-5n\n123.456e+5n\n0.456e-5n")
      expect(tokens[0][0].value).toBe("123.456");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[0][1].value).toBe("n");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[1][0].value).toBe("0.456");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[1][1].value).toBe("n");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[2][0].value).toBe(".01234");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[2][1].value).toBe("n");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[3][0].value).toBe("123");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[3][1].value).toBe("e");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[3][2].value).toBe("5");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[3][3].value).toBe("n");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[4][0].value).toBe("123");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[4][1].value).toBe("e-");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[4][2].value).toBe("5");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[4][3].value).toBe("n");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[5][0].value).toBe("123.456");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[5][1].value).toBe("e+");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[5][2].value).toBe("5");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[5][3].value).toBe("n");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[6][0].value).toBe("0.456");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[6][1].value).toBe("e-");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
      expect(tokens[6][2].value).toBe("5");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql"]);
      expect(tokens[6][3].value).toBe("n");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","constant.numeric.decimal.edgeql","storage.type.number.edgeql"]);
    });

  it("test/edgeql/select01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT\n    test::NamedObject {\n        abc,\n        defd,\n        name: {\n            @lang\n        }\n    }\nFILTER\n    test::`NamedObject`.name = 'Test';")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][0].value).toBe("    test");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("::");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[1][2].value).toBe("NamedObject ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("{");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("        ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("abc");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(",");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("        defd");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(",");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[4][0].value).toBe("        name");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe(":");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[4][2].value).toBe(" ");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][3].value).toBe("{");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][0].value).toBe("            ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("@");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","support.other.linkproperty.edgeql"]);
      expect(tokens[5][2].value).toBe("lang");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","support.other.linkproperty.edgeql"]);
      expect(tokens[6][0].value).toBe("        ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe("}");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][0].value).toBe("    ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe("}");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[8][0].value).toBe("FILTER");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[9][0].value).toBe("    test");
      expect(tokens[9][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[9][1].value).toBe("::");
      expect(tokens[9][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[9][2].value).toBe("`NamedObject`");
      expect(tokens[9][2].scopes).toEqual(["source.edgeql","string.interpolated.edgeql"]);
      expect(tokens[9][3].value).toBe(".name ");
      expect(tokens[9][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[9][4].value).toBe("=");
      expect(tokens[9][4].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[9][5].value).toBe(" ");
      expect(tokens[9][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[9][6].value).toBe("'");
      expect(tokens[9][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[9][7].value).toBe("Test");
      expect(tokens[9][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[9][8].value).toBe("'");
      expect(tokens[9][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[9][9].value).toBe(";");
      expect(tokens[9][9].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/select02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT\n    test::User {\n        id,\n    }\nFILTER\n    ((test::User).score = $val)")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][0].value).toBe("    test");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("::");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[1][2].value).toBe("User ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("{");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("        ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("id");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(",");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("    ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe("}");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[4][0].value).toBe("FILTER");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[5][0].value).toBe("    ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("(");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][2].value).toBe("(");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][3].value).toBe("test");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][4].value).toBe("::");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[5][5].value).toBe("User");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][6].value).toBe(")");
      expect(tokens[5][6].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[5][7].value).toBe(".score ");
      expect(tokens[5][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][8].value).toBe("=");
      expect(tokens[5][8].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[5][9].value).toBe(" ");
      expect(tokens[5][9].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][10].value).toBe("$");
      expect(tokens[5][10].scopes).toEqual(["source.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[5][11].value).toBe("val");
      expect(tokens[5][11].scopes).toEqual(["source.edgeql","constant.language.variable.edgeql"]);
      expect(tokens[5][12].value).toBe(")");
      expect(tokens[5][12].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
    });

  it("test/edgeql/select03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT\n    mod2::Person {\n        id,\n        name,\n        groups: {\n            id,\n            name,\n        }\n    }")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][0].value).toBe("    mod2");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("::");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","keyword.operator.namespace.edgeql"]);
      expect(tokens[1][2].value).toBe("Person ");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][3].value).toBe("{");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("        ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("id");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(",");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("        name");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(",");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[4][0].value).toBe("        groups");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe(":");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[4][2].value).toBe(" ");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][3].value).toBe("{");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][0].value).toBe("            ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("id");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][2].value).toBe(",");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[6][0].value).toBe("            name");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe(",");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[7][0].value).toBe("        ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe("}");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[8][0].value).toBe("    ");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][1].value).toBe("}");
      expect(tokens[8][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
    });

  it("test/edgeql/select04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("SELECT Foo {\n    bar: {\n        baz := (SELECT Doo {foo}),\n        spam,\n    },\n    back_foo := Foo.<foo,\n    ham,\n};")
      expect(tokens[0][0].value).toBe("SELECT");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" Foo ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("{");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[1][0].value).toBe("    ");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][1].value).toBe("bar");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe(":");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","punctuation.declaration.delimiter.edgeql"]);
      expect(tokens[1][3].value).toBe(" ");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][4].value).toBe("{");
      expect(tokens[1][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("        ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("baz ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(":=");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][3].value).toBe(" ");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe("(");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][5].value).toBe("SELECT");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][6].value).toBe(" Doo ");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][7].value).toBe("{");
      expect(tokens[2][7].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][8].value).toBe("foo");
      expect(tokens[2][8].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][9].value).toBe("}");
      expect(tokens[2][9].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][10].value).toBe(")");
      expect(tokens[2][10].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[2][11].value).toBe(",");
      expect(tokens[2][11].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("        spam");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(",");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[4][0].value).toBe("    ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("}");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[4][2].value).toBe(",");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[5][0].value).toBe("    back_foo ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe(":=");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[5][2].value).toBe(" Foo");
      expect(tokens[5][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][3].value).toBe(".<");
      expect(tokens[5][3].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[5][4].value).toBe("foo");
      expect(tokens[5][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][5].value).toBe(",");
      expect(tokens[5][5].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[6][0].value).toBe("    ham");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe(",");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[7][0].value).toBe("}");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][1].value).toBe(";");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/select05.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nSELECT User{\n    name,\n    owner_of := (\n        SELECT User.<owner[IS Issue] {\n            number\n        } FILTER <int64>(.number) < 3\n    ),\n} FILTER User.name = 'Elvis';")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("SELECT");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" User");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][2].value).toBe("{");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[2][0].value).toBe("    ");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][1].value).toBe("name");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe(",");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[3][0].value).toBe("    owner_of ");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][1].value).toBe(":=");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[3][2].value).toBe(" ");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][3].value).toBe("(");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[4][0].value).toBe("        ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("SELECT");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][2].value).toBe(" User");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][3].value).toBe(".<");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","keyword.operator.navigation.edgeql"]);
      expect(tokens[4][4].value).toBe("owner");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][5].value).toBe("[");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[4][6].value).toBe("IS");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][7].value).toBe(" Issue");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][8].value).toBe("]");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[4][9].value).toBe(" ");
      expect(tokens[4][9].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][10].value).toBe("{");
      expect(tokens[4][10].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[5][0].value).toBe("            ");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[5][1].value).toBe("number");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][0].value).toBe("        ");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][1].value).toBe("}");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[6][2].value).toBe(" ");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][3].value).toBe("FILTER");
      expect(tokens[6][3].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[6][4].value).toBe(" ");
      expect(tokens[6][4].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][5].value).toBe("<");
      expect(tokens[6][5].scopes).toEqual(["source.edgeql","keyword.operator.cast.begin.edgeql"]);
      expect(tokens[6][6].value).toBe("int64");
      expect(tokens[6][6].scopes).toEqual(["source.edgeql","meta.typecast.edgeql","support.type.builtin.edgeql"]);
      expect(tokens[6][7].value).toBe(">");
      expect(tokens[6][7].scopes).toEqual(["source.edgeql","keyword.operator.cast.end.edgeql"]);
      expect(tokens[6][8].value).toBe("(");
      expect(tokens[6][8].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[6][9].value).toBe(".number");
      expect(tokens[6][9].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][10].value).toBe(")");
      expect(tokens[6][10].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[6][11].value).toBe(" ");
      expect(tokens[6][11].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][12].value).toBe("<");
      expect(tokens[6][12].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[6][13].value).toBe(" ");
      expect(tokens[6][13].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][14].value).toBe("3");
      expect(tokens[6][14].scopes).toEqual(["source.edgeql","constant.numeric.integer.edgeql"]);
      expect(tokens[7][0].value).toBe("    ");
      expect(tokens[7][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[7][1].value).toBe(")");
      expect(tokens[7][1].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[7][2].value).toBe(",");
      expect(tokens[7][2].scopes).toEqual(["source.edgeql","punctuation.separator.element.edgeql"]);
      expect(tokens[8][0].value).toBe("}");
      expect(tokens[8][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[8][1].value).toBe(" ");
      expect(tokens[8][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][2].value).toBe("FILTER");
      expect(tokens[8][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[8][3].value).toBe(" User.name ");
      expect(tokens[8][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][4].value).toBe("=");
      expect(tokens[8][4].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[8][5].value).toBe(" ");
      expect(tokens[8][5].scopes).toEqual(["source.edgeql"]);
      expect(tokens[8][6].value).toBe("'");
      expect(tokens[8][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[8][7].value).toBe("Elvis");
      expect(tokens[8][7].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[8][8].value).toBe("'");
      expect(tokens[8][8].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[8][9].value).toBe(";");
      expect(tokens[8][9].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });

  it("test/edgeql/string01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("'this is a string'\n'this is a \"string\"'\n'this is a \\'string\\''\n'this is a \\\"string\\\"'\n'this is \\a string'")
      expect(tokens[0][0].value).toBe("'");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][1].value).toBe("this is a string");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[0][2].value).toBe("'");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("'");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][1].value).toBe("this is a \"string\"");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][2].value).toBe("'");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("'");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][1].value).toBe("this is a ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][2].value).toBe("\\'");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][3].value).toBe("string");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][4].value).toBe("\\'");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][5].value).toBe("'");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("'");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][1].value).toBe("this is a ");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][2].value).toBe("\\\"");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][3].value).toBe("string");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][4].value).toBe("\\\"");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][5].value).toBe("'");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[4][0].value).toBe("'");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][1].value).toBe("this is ");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[4][2].value).toBe("\\a");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","invalid.illegal.escapes.edgeql"]);
      expect(tokens[4][3].value).toBe(" string");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[4][4].value).toBe("'");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/string02.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("\"this is a string\"\n\"this is a 'string'\"\n\"this is a \\'string\\'\"\n\"this is a \\\"string\\\"\"\n\"this is \\a string\"")
      expect(tokens[0][0].value).toBe("\"");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][1].value).toBe("this is a string");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[0][2].value).toBe("\"");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("\"");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][1].value).toBe("this is a 'string'");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[1][2].value).toBe("\"");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("\"");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][1].value).toBe("this is a ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][2].value).toBe("\\'");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][3].value).toBe("string");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][4].value).toBe("\\'");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[2][5].value).toBe("\"");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("\"");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][1].value).toBe("this is a ");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][2].value).toBe("\\\"");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][3].value).toBe("string");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[3][4].value).toBe("\\\"");
      expect(tokens[3][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","constant.character.escape.edgeql"]);
      expect(tokens[3][5].value).toBe("\"");
      expect(tokens[3][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[4][0].value).toBe("\"");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][1].value).toBe("this is ");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[4][2].value).toBe("\\a");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","string.quoted.edgeql","invalid.illegal.escapes.edgeql"]);
      expect(tokens[4][3].value).toBe(" string");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[4][4].value).toBe("\"");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/string03.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("$$this is a string$$\n\n$a$this is a \"string\"$a$\n\n$w__2$this is a \\'string\\'$w__2$\n\n$q123$this is a \\\"string\\\"$q123$")
      expect(tokens[0][0].value).toBe("$$");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][1].value).toBe("this is a string");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.dollar.edgeql"]);
      expect(tokens[0][2].value).toBe("$$");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("$a$");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][1].value).toBe("this is a \"string\"");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.dollar.edgeql"]);
      expect(tokens[2][2].value).toBe("$a$");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][0].value).toBe("$w__2$");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][1].value).toBe("this is a \\'string\\'");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql","string.dollar.edgeql"]);
      expect(tokens[4][2].value).toBe("$w__2$");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[5][0].value).toBe("");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[6][0].value).toBe("$q123$");
      expect(tokens[6][0].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[6][1].value).toBe("this is a \\\"string\\\"");
      expect(tokens[6][1].scopes).toEqual(["source.edgeql","string.dollar.edgeql"]);
      expect(tokens[6][2].value).toBe("$q123$");
      expect(tokens[6][2].scopes).toEqual(["source.edgeql","string.dollar.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/string04.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("r'this is a raw string'\nr'this is a raw \"string\"'\nr'this is a raw \\rstring\\r'\nr'this is a raw \\rstring\\r'")
      expect(tokens[0][0].value).toBe("r");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[0][1].value).toBe("'");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][2].value).toBe("this is a raw string");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[0][3].value).toBe("'");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("r");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[1][1].value).toBe("'");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][2].value).toBe("this is a raw \"string\"");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[1][3].value).toBe("'");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("r");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[2][1].value).toBe("'");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][2].value).toBe("this is a raw \\rstring\\r");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[2][3].value).toBe("'");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("r");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[3][1].value).toBe("'");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][2].value).toBe("this is a raw \\rstring\\r");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[3][3].value).toBe("'");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/string05.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("r\"this is a raw string\"\nr\"this is a raw 'string'\"\nr\"this is a raw \\rstring\\r\"\nr\"this is a raw \\rstring\\r\"")
      expect(tokens[0][0].value).toBe("r");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[0][1].value).toBe("\"");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[0][2].value).toBe("this is a raw string");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[0][3].value).toBe("\"");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[1][0].value).toBe("r");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[1][1].value).toBe("\"");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[1][2].value).toBe("this is a raw 'string'");
      expect(tokens[1][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[1][3].value).toBe("\"");
      expect(tokens[1][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[2][0].value).toBe("r");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[2][1].value).toBe("\"");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][2].value).toBe("this is a raw \\rstring\\r");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[2][3].value).toBe("\"");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("r");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","storage.type.string.edgeql"]);
      expect(tokens[3][1].value).toBe("\"");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[3][2].value).toBe("this is a raw \\rstring\\r");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql"]);
      expect(tokens[3][3].value).toBe("\"");
      expect(tokens[3][3].scopes).toEqual(["source.edgeql","string.quoted.raw.edgeql","punctuation.definition.string.end.edgeql"]);
    });

  it("test/edgeql/update01.edgeql", 
    function() {
      tokens = grammar.tokenizeLines("WITH MODULE test\nUPDATE UpdateTest\nFILTER UpdateTest.name = 'update-test1'\nSET {\n    status := (SELECT Status FILTER Status.name = 'Closed')\n};")
      expect(tokens[0][0].value).toBe("WITH");
      expect(tokens[0][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][1].value).toBe(" ");
      expect(tokens[0][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[0][2].value).toBe("MODULE");
      expect(tokens[0][2].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[0][3].value).toBe(" test");
      expect(tokens[0][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[1][0].value).toBe("UPDATE");
      expect(tokens[1][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[1][1].value).toBe(" UpdateTest");
      expect(tokens[1][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][0].value).toBe("FILTER");
      expect(tokens[2][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[2][1].value).toBe(" UpdateTest.name ");
      expect(tokens[2][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][2].value).toBe("=");
      expect(tokens[2][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[2][3].value).toBe(" ");
      expect(tokens[2][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[2][4].value).toBe("'");
      expect(tokens[2][4].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[2][5].value).toBe("update-test1");
      expect(tokens[2][5].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[2][6].value).toBe("'");
      expect(tokens[2][6].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[3][0].value).toBe("SET");
      expect(tokens[3][0].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[3][1].value).toBe(" ");
      expect(tokens[3][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[3][2].value).toBe("{");
      expect(tokens[3][2].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[4][0].value).toBe("    ");
      expect(tokens[4][0].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][1].value).toBe("status ");
      expect(tokens[4][1].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][2].value).toBe(":=");
      expect(tokens[4][2].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[4][3].value).toBe(" ");
      expect(tokens[4][3].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][4].value).toBe("(");
      expect(tokens[4][4].scopes).toEqual(["source.edgeql","punctuation.parenthesis.begin.edgeql"]);
      expect(tokens[4][5].value).toBe("SELECT");
      expect(tokens[4][5].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][6].value).toBe(" Status ");
      expect(tokens[4][6].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][7].value).toBe("FILTER");
      expect(tokens[4][7].scopes).toEqual(["source.edgeql","keyword.declaration.edgeql"]);
      expect(tokens[4][8].value).toBe(" Status.name ");
      expect(tokens[4][8].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][9].value).toBe("=");
      expect(tokens[4][9].scopes).toEqual(["source.edgeql","keyword.operator.edgeql"]);
      expect(tokens[4][10].value).toBe(" ");
      expect(tokens[4][10].scopes).toEqual(["source.edgeql"]);
      expect(tokens[4][11].value).toBe("'");
      expect(tokens[4][11].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.begin.edgeql"]);
      expect(tokens[4][12].value).toBe("Closed");
      expect(tokens[4][12].scopes).toEqual(["source.edgeql","string.quoted.edgeql"]);
      expect(tokens[4][13].value).toBe("'");
      expect(tokens[4][13].scopes).toEqual(["source.edgeql","string.quoted.edgeql","punctuation.definition.string.end.edgeql"]);
      expect(tokens[4][14].value).toBe(")");
      expect(tokens[4][14].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[5][0].value).toBe("}");
      expect(tokens[5][0].scopes).toEqual(["source.edgeql","punctuation.parenthesis.end.edgeql"]);
      expect(tokens[5][1].value).toBe(";");
      expect(tokens[5][1].scopes).toEqual(["source.edgeql","punctuation.statement.delimiter.edgeql"]);
    });
});

