{
 * This unit was generated automatically. It incorporates a selection of source
 * code taken from the Code Snippets Database at
 * https://github.com/delphidabbler/code-snippets.
 * 
 * The unit is copyright  2005-2025 by Peter Johnson & Contributors and is
 * licensed under the MIT License (https://opensource.org/licenses/MIT).
 * 
 * Generated on : Sat, 05 Apr 2025 12:14:56 GMT.
 * Generated by : DelphiDabbler CodeSnip Release 4.24.0.
 * 
 * The latest version of CodeSnip is available from the CodeSnip GitHub project
 * at https://github.com/delphidabbler/codesnip.
}

unit UStringCatSnippets;

{$IFNDEF FPC}
  {$IFDEF CONDITIONALEXPRESSIONS}
    {$IF CompilerVersion >= 24.00}
      {$LEGACYIFEND ON}
    {$IFEND}
    {$IF CompilerVersion >= 14.00}
      {$WARN SYMBOL_PLATFORM OFF}
      {$WARN SYMBOL_DEPRECATED OFF}
      {$WARN SYMBOL_LIBRARY OFF}
    {$IFEND}
    {$IF CompilerVersion >= 15.00}
      {$WARN UNSAFE_TYPE OFF}
      {$WARN UNSAFE_CAST OFF}
      {$WARN UNSAFE_CODE OFF}
    {$IFEND}
    {$IF CompilerVersion >= 20.00}
      {$WARN EXPLICIT_STRING_CAST OFF}
      {$WARN IMPLICIT_STRING_CAST OFF}
    {$IFEND}
  {$ENDIF}
{$ENDIF}

interface

uses
  SysUtils, Classes, StrUtils;

{
  Checks if the string Value contains a valid numeric value and returns True if
  so or False if not.
  If AllowFloat is true then Value may contain a floating point number,
  otherwise it must be an integer. If TrimWhiteSpace is True any white space
  surrounding Value is trimmed before testing.
}
function IsNumeric(Value: string; const AllowFloat: Boolean;
  const TrimWhiteSpace: Boolean = True): Boolean;

{
  Splits the string StrToParse into segments separated by Delimiter and stores
  each segment in turn in string list Words, replacing any existing content.
}
procedure ParseStr(const StrToParse: string; const Delimiter: Char; 
  const Words: Classes.TStringList);

{
  Returns a random string from the given non-empty string list.
  An EArgumentException exception is raised if the string list is empty.
}
function RandomString(const SL: Classes.TStrings): string; overload;

{
  Returns the reverse of the given string.
}
function ReverseStr(S: string): string;

{
  Returns the reverse of the given string.
}
function ReverseStrR(const S: string): string;

{
  Splits the string AText into segments separated by Delimiter and creates and
  returns a string list containing the segments.
  The caller is responsible for freeing the returnd string list object.
}
function SplitString(const AText, ADelimiter: string): Classes.TStringList;

{
  Strips all accelerator ('&') characters from the given string and returns the
  resulting string.
}
function StripAccelChars(const S: string): string;

implementation

{
  Checks if the string Value contains a valid numeric value and returns True if
  so or False if not.
  If AllowFloat is true then Value may contain a floating point number,
  otherwise it must be an integer. If TrimWhiteSpace is True any white space
  surrounding Value is trimmed before testing.
}
function IsNumeric(Value: string; const AllowFloat: Boolean;
  const TrimWhiteSpace: Boolean = True): Boolean;
var
  ValueInt: Int64;      // dummy integer value
  ValueFloat: Extended; // dummy float value
begin
  if TrimWhiteSpace then
    Value := SysUtils.Trim(Value);
  // Check for valid integer
  Result := SysUtils.TryStrToInt64(Value, ValueInt);
  if not Result and AllowFloat then
    // Wasn't valid as integer, try float
    Result := SysUtils.TryStrToFloat(Value, ValueFloat);
end;

{
  Splits the string StrToParse into segments separated by Delimiter and stores
  each segment in turn in string list Words, replacing any existing content.
}
procedure ParseStr(const StrToParse: string; const Delimiter: Char; 
  const Words: Classes.TStringList);
var
  TmpInStr: string;
begin
  TmpInStr := StrToParse;
  Words.Clear;
  if Length(TmpInStr) > 0 then
  begin
    while Pos(Delimiter, TmpInStr) > 0 do
    begin
      Words.Append(Copy(TmpInStr, 1, Pos(Delimiter, TmpInStr) - 1));
      Delete(TmpInStr, 1, Pos(Delimiter, TmpInStr));
    end;
    Words.Append(TmpInStr);
  end;
end;

{
  Returns a random string from the given non-empty string list.
  An EArgumentException exception is raised if the string list is empty.
}
function RandomString(const SL: Classes.TStrings): string; overload;
begin
  if SL.Count = 0 then
    raise SysUtils.EArgumentException.Create(
      'RandomString called with empty string list'
    );
  Result := SL[Random(SL.Count)];
end;

{
  Returns the reverse of the given string.
}
function ReverseStr(S: string): string;
begin
  Result := SysUtils.EmptyStr;
  while System.Length(S) > 0 do
  begin
    Result := Result + StrUtils.RightStr(S, 1);
    S := StrUtils.LeftStr(S, Pred(System.Length(S)));
  end;
end;

{
  Returns the reverse of the given string.
}
function ReverseStrR(const S: string): string;
begin
  if SysUtils.AnsiSameText(S, SysUtils.EmptyStr) or (System.Length(S) = 1) then
    Result := S
  else
    Result := StrUtils.RightStr(S, 1)
      + ReverseStrR(StrUtils.LeftStr(S, System.Length(S) - 1))
end;

{
  Splits the string AText into segments separated by Delimiter and creates and
  returns a string list containing the segments.
  The caller is responsible for freeing the returnd string list object.
}
function SplitString(const AText, ADelimiter: string): Classes.TStringList;
var
  LTxt, LTmp: string;
begin
  Result := TStringList.Create;
  LTxt := AText;
  while Pos(ADelimiter, LTxt) > 0 do
  begin
    LTmp := Copy(LTxt, 1, Pos(ADelimiter, LTxt) - 1);
    Result.Add(LTmp);
    LTxt := SysUtils.StringReplace(LTxt, LTmp + ADelimiter, '', []);
  end;
  if (LTxt <> '') then
    Result.Add(LTxt);
end;

{
  Strips all accelerator ('&') characters from the given string and returns the
  resulting string.
}
function StripAccelChars(const S: string): string;
begin
  Result := SysUtils.StringReplace(
    S, '&', SysUtils.EmptyStr, [SysUtils.rfReplaceAll]
  );
end;

end.
