{
 * This unit was generated automatically. It incorporates a selection of source
 * code taken from the Code Snippets Database at
 * https://github.com/delphidabbler/code-snippets.
 * 
 * The unit is copyright  2005-2025 by Peter Johnson & Contributors and is
 * licensed under the MIT License (https://opensource.org/licenses/MIT).
 * 
 * Generated on : Sat, 18 Jan 2025 10:35:45 GMT.
 * Generated by : DelphiDabbler CodeSnip Release 4.24.0.
 * 
 * The latest version of CodeSnip is available from the CodeSnip GitHub project
 * at https://github.com/delphidabbler/codesnip.
}

unit UMathsCatSnippets;

interface

uses
  SysUtils, Generics.Defaults, Generics.Collections, Math, Types, Windows;

{
  Encapsulates a point with double precision floating point coordinates.
}
type
  TPointF = record
    X, Y: Double;  // x and y coordinates
  end;

{
  Checks if all the digits of the given integer are different to each other.
}
function AllDigitsDifferent(N: Int64): Boolean;

{
  Checks if all the digits of the given integer are the same.
}
function AllDigitsSame(N: Int64): Boolean;

{
  Returns the arithmetic mean of an array of Cardinal values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Cardinal): Double; overload;

{
  Returns the arithmetic mean of an array of Double values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Double): Double; overload;

{
  Returns the arithmetic mean of an array of Integer values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Integer): Double; overload;

{
  Returns the sum of all Cardinal elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Cardinal): Cardinal; overload;

{
  Returns the sum of all Double floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Double): Double; overload;

{
  Returns the sum of all Extended floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Extended): Extended; overload;

{
  Returns the sum of all Int64 elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Int64): Int64; overload;

{
  Returns the sum of all Integer elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Integer): Integer; overload;

{
  Returns the sum of all Single floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Single): Single; overload;

{
  Returns the sum of all UInt64 elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of UInt64): UInt64; overload;

{
  Calculates the number of occurrences of each unique element of array A. An
  array of TPair<Integer,Cardinal> values is returned, where the Key field of
  each TPair element is the integer and the Value field is the number of times
  the integer occurs in A. The returned array is sorted on the Key field.
  Raises EArgumentException if A is empty.
}
function CountOccurrences(const A: array of Integer):
  System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;

{
  Converts the given decimal to a fraction. The numerator and denominator are
  passed out as floating point numbers in FractionNumerator and
  FractionDenominator respectively.
  AccuracyFactor determines how accurate the conversion is to be.
}
procedure DecimalToFraction(Decimal: Extended; out FractionNumerator: Extended;
  out FractionDenominator: Extended; const AccuracyFactor: Extended);

{
  Counts the number of digits in the given integer.
}
function DigitCount(AInteger: Int64): Integer;

{
  Counts the number of digits in the given integer.
}
function DigitCount2(const AValue: Int64): Integer;

{
  Returns the number of digits in integer N when expressed in base Base.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitCountBase(N: Int64; const Base: Byte): Cardinal;

{
  Counts the number of digits in the given integer using recursion.
}
function DigitCountR(AValue: Int64): Integer;

{
  Calculates the sum of all the digits of integer N in base Base where each
  digit is raised to the power Exponent. The returned value has the same sign as
  N.
  If the result is too large to be represented as an Int64 value then an
  EOverflow exception is raised.
  Bases up to 255 are supported. If Base <= 2 then an EArgumentException
  exception is raised.
}
function DigitPowerSum(N: Integer; const Base: Byte; const Exponent: Byte):
  Int64;

{
  Returns an array containing the digits of integer N when expressed in base
  Base. The array is ordered with the least significant digit first.
  The returned array contains the decimal value of the digit, for e.g. the hex
  symbol F is represented by an array element containing the value 15.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitsOf(N: Int64; const Base: Byte): SysUtils.TBytes;

{
  Returns the sum of the digits from the given integer, using recursion.
}
function DigitSum(AValue: Int64): Integer;

{
  Calculates the sum of all the digits of integer N when epxressed in base Base.
  The returned value has the same sign as N.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitSumBase(N: Int64; const Base: Byte): Integer;

{
  Calculates the distance between two given points with double precision
  floating point valued coordinates.
}
function DistanceBetweenPoints(const P1, P2: TPointF): Extended; overload;

{
  Calculates the distance between two points with integer valued co-ordinates.
}
function DistanceBetweenPoints(const P1, P2: Types.TPoint): Extended; overload;

{
  Calculates the factorial of the given number.
}
function Factorial(N: Byte): Int64;

{
  Determines the greatest common divisor of two given non-zero integers.
}
function GCD(A, B: Integer): Integer;

{
  Determines the greatest common divisor of two given non-zero integers.
}
function GCD2(const A, B: Integer): Integer;

{
  Returns the geometric mean of an array of positive Cardinal values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Cardinal): Double; overload;

{
  Returns the geometric mean of an array of positive Double values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Double): Double; overload;

{
  Returns the geometric mean of an array of positive Integer values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Integer): Double; overload;

{
  Returns the harmonic mean of an array of positive Cardinal values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Cardinal): Double; overload;

{
  Returns the harmonic mean of an array of positive Double values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Double): Double; overload;

{
  Returns the harmonic mean of an array of positive Integer values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Integer): Double; overload;

{
  Checks if the given array of integers A has a mode and returns True if so.
  Raises EArgumentException if A has fewer than two elements.
}
function HasMode(const A: array of Integer): Boolean;

{
  Checks if the absolute value of integer N is a narcissistic number in base
  Base.
  Bases up to 255 are supported. If Base <= 2 then an EArgumentException
  exception is raised. An EOverflow exception may be raised for large numbers
  and bases.
}
function IsNarcissistic(N: Integer; const Base: Byte = 10): Boolean;

{
  Checks if the absolute value of integer N is palindromic in base Base.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function IsPalindromic(const N: Int64; const Base: Byte = 10): Boolean;

{
  Checks if the given number is prime.
}
function IsPrime(N: Integer): Boolean;

{
  Checks if the given number is prime.
}
function IsPrime2(Val: Integer): Boolean;

{
  Checks if the given rectangle is normalized, i.e. Left <= Right and Top <=
  Bottom.
}
function IsRectNormal(const R: Windows.TRect): Boolean;

{
  Returns the least common divisor of two given non-zero integers.
}
function LCD(A, B: Integer): Integer;

{
  Returns the logarithmic mean of two positive floating point values, X and Y.
  Raises EArgumentException if either X or Y is not positive.
}
function LogarithmicMean(const X, Y: Double): Double;

{
  Returns the logarithm of the sum of the exponentials of the given array of
  floating pointing point numbers.
  An EArgumentException exception is raised if the array is empty.
}
function LSE(const A: array of Double): Double;

{
  Returns the maximum value contained in the given array of double precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Double): Double; overload;

{
  Returns the maximum value contained in the given array of extended precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Extended): Extended; overload;

{
  Returns the maximum value contained in the given array of 64 bit integer
  values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Int64): Int64; overload;

{
  Returns the maximum value contained in the given array of integer values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Integer): Integer; overload;

{
  Returns the maximum value contained in the given array of single precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Single): Single; overload;

{
  Returns the median of an array of floating point values.
  Raises an EArgumentException exception if the array is empty.
}
function Median(A: array of Double): Double; overload;

{
  Returns the median of an array of integer values.
  Raises an EArgumentException exception if the array is empty.
}
function Median(A: array of Integer): Double; overload;

{
  Returns the middle of three double precision floating point values.
}
function Mid(const A, B, C: Double): Double; overload;

{
  Returns the middle of three extended precision floating point values.
}
function Mid(const A, B, C: Extended): Extended; overload;

{
  Returns the middle of three 64 bit integer values.
}
function Mid(const A, B, C: Int64): Int64; overload;

{
  Returns the middle of three integer values.
}
function Mid(const A, B, C: Integer): Integer; overload;

{
  Returns the middle of three single precision floating point values.
}
function Mid(const A, B, C: Single): Single; overload;

{
  Finds the minimum and maximum values contained in the non-empty array, A, of
  double precision floating point values. MinValue and MaxValue are set to the
  minimum and maximum values, respectively.
  EArgumentException is raised if A is empty.
}
procedure MinMaxOfArray(const A: array of Double;
  out MinValue, MaxValue: Double); overload;

{
  Finds the minimum and maximum values contained in the non-empty Integer array
  A. MinValue and MaxValue are set to the minimum and maximum values,
  respectively.
  EArgumentException is raised if A is empty.
}
procedure MinMaxOfArray(const A: array of Integer;
  out MinValue, MaxValue: Integer); overload;

{
  Finds the minimum, middle and maximum values of three double precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Double; out Min, Mid, Max: Double); overload;

{
  Finds the minimum, middle and maximum values of three extended precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Extended; out Min, Mid, Max: Extended); 
  overload;

{
  Finds the minimum, middle and maximum values of three 64 bit integers, A, B
  and C and returns them in Min, Mid and Max respectively.
}
procedure MinMidMax(const A, B, C: Int64; out Min, Mid, Max: Int64); overload;

{
  Finds the minimum, middle and maximum values of three integers, A, B and C and
  returns them in Min, Mid and Max respectively.
}
procedure MinMidMax(const A, B, C: Integer; out Min, Mid, Max: Integer);
  overload;

{
  Finds the minimum, middle and maximum values of three single precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Single; out Min, Mid, Max: Single); overload;

{
  Returns the minimum value contained in the given array of double precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Double): Double; overload;

{
  Returns the minimum value contained in the given array of extended precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Extended): Extended; overload;

{
  Returns the minimum value contained in the given array of 64 bit integer
  values.
  The array must not be empty.
}
function MinOfArray(const A: array of Int64): Int64; overload;

{
  Returns the minimum value contained in the given array of integer values.
  The array must not be empty.
}
function MinOfArray(const A: array of Integer): Integer; overload;

{
  Returns the minimum value contained in the given array of single precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Single): Single; overload;

{
  Calculates the mode of array A of integer data. Returns an array containing
  the mode or modes of the data.
  If the data has a single mode, then a single element array containing the mode
  is returned. If the data is multi-modal then all the modes are returned. If
  all data items occur with equal frequency then an array of all unique data
  items is returned. The returned data is sorted in ascending order.
  Raises EArgumentException if A has fewer than two elements.
}
function Mode(const A: array of Integer): System.TArray<Integer>;

{
  Calculates the mode of array A of integer data. Returns an array containing
  the mode or modes of the data, if any.
  If the data has a single mode, then a single element array containing the mode
  is returned. If the data is multi-modal then all the modes are returned,
  sorted in ascending order. If all data items occur with equal frequency, and
  not all data items are the same, then there is no mode and an empty array is
  returned.
  Raises EArgumentException if A has fewer than two elements.
}
function ModeAlt(const A: array of Integer): System.TArray<Integer>;

{
  Returns the number of modes of integer array A.
  Raises EArgumentException if A has fewer than two elements.
}
function ModeCount(const A: array of Integer): Integer;

{
  Translates the give rectangle to the origin.
  The top and left co-ordinates are set to zero and the bottom and right
  co-ordinates are adjusted accordingly.
}
function MoveRectToOrigin(const R: Types.TRect): Types.TRect;

{
  Normalises the values in unsigned integer array A so that each value of A is
  mapped to a value in the range [0..1], where the total of all the values is 1.
  The relative weights of the values are preserved.
  An array of the same size as A is returned where each element contains the
  normalised value of the corresponding element of A.
  A must not be empty and must have at least one non-zero element.
  EArgumentException is raised if these conditions are not met.
}
function NormaliseByWeight(const A: array of Cardinal): Types.TDoubleDynArray;
  overload;

{
  Normalises the values in floating point array A so that each value of A is
  mapped to a value in the range [0..1], where the total of all the values is 1.
  The relative weights of the values are preserved.
  An array of the same size as A is returned where each element contains the
  normalised value of the corresponding element of A.
  A must not be empty. All elements of A must be >= 0, with at least one element
  > 0. EArgumentException is raised if these conditions are not met.
}
function NormaliseByWeight(const A: array of Double): Types.TDoubleDynArray;
  overload;

{
  Normalises the sign of the fraction with numerator Num and denominator Denom
  so that Num takes the sign of the fraction and Denom is non-negative.
}
procedure NormaliseFractionSign(var Num, Denom: Integer);

{
  Normalises the given rectangle so that Left <= Right and Top <= Bottom.
}
function NormalizeRect(const R: Windows.TRect): Windows.TRect;

{
  Raises integer value Base to non-negative integer power Exponent and returns
  the result.
}
function Pow(const Base: Int64; const Exponent: Byte): Int64;

{
  Returns the power mean of the elements of Cardinal array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty or if Lambda is zero.
}
function PowerMean(const A: array of Cardinal; const Lambda: Double): Double;
  overload;

{
  Returns the power mean of the elements of Double array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty, if any array element is
  negative or if Lambda is zero.
}
function PowerMean(const A: array of Double; const Lambda: Double): Double;
  overload;

{
  Returns the power mean of the elements of Integer array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty, if any array element is
  negative or if Lambda is zero.
}
function PowerMean(const A: array of Integer; const Lambda: Double): Double;
  overload;

{
  IEEE compliant function that raises real number X to the power N.
}
function PowN(const X: Extended; const N: Integer): Extended;

{
  Raises integer X to non-negative integer power N.
  If the result is too large to be represented as an Int64 value then an
  EOverflow exception is raised.
}
function PowNZN(const X: Integer; const N: Cardinal): Int64;

{
  Raises integer X to integer power N.
}
function PowNZZ(const X: Integer; const N: Integer): Extended;

{
  Returns the length of the range of values in non-empty Double array A.
  EArgumentException is raised if A is empty.
}
function RangeOf(const A: array of Double): Double; overload;

{
  Returns the length of the range of values in non-empty Integer array A.
  EArgumentException is raised if A is empty.
}
function RangeOf(const A: array of Integer): Cardinal; overload;

{
  Returns the area of the given rectangle.
}
function RectArea(const R: Windows.TRect): Int64;

{
  Returns the height of the given rectangle.
  The return value is always non-negative even if the rectangle is not
  normalized.
}
function RectHeight(const R: Windows.TRect): Integer;

{
  Returns the size of the given rectangle.
  The returned dimensions are always non-negative even if the rectangle is not
  normalized.
}
function RectSize(const R: Windows.TRect): Windows.TSize;

{
  Returns the width of the given rectangle.
  The return value is always non-negative even if the rectangle is not
  normalized.
}
function RectWidth(const R: Windows.TRect): Integer;

{
  Checks if the given integer contains only a single repeated digit.
}
function RepeatedDigits(N: Int64): Boolean;

{
  Rescales the elements of array A containing a range of Double values so that
  each value of A is mapped to a value in the range [0..1].
  An array of the same size as A is returned where each element contains the
  rescaled value of the corresponding element of A.
  A must not be empty and not all elements may be the same value.
  EArgumentException is raised if either condition is not met.
}
function RescaleRange(const A: array of Double): Types.TDoubleDynArray;
  overload;

{
  Rescales the elements of array A containing a range of Integer values so that
  each value of A is mapped to a value in the range [0..1].
  An array of the same size as A is returned where each element contains the
  rescaled value of the corresponding element of A.
  A must not be empty and not all elements may be the same value.
  EArgumentException is raised if either condition is not met.
}
function RescaleRange(const A: array of Integer): Types.TDoubleDynArray;
  overload;

{
  Resizes rectangle R to size NewSize, leaving the top-left position unchanged.
  Returns the resized rectangle.
}
function ResizeRect(const R: Types.TRect; const NewSize: Types.TSize):
  Types.TRect; overload;

{
  Resizes rectangle R to the width and height given by NewWidth and NewHeight,
  leaving the top-left position unchanged.
  Returns the resized rectangle.
}
function ResizeRect(const R: Types.TRect; const NewWidth, NewHeight: LongInt):
  Types.TRect; overload;

{
  Reverses the digits of integer AValue and returns the resulting value.
  AValue should be positive: zero is always returned for negative integers.
}
function ReverseNumber(AValue: Int64): Int64;

{
  Reverses the digits of the given integer, which must be non-negative, and
  returns the resulting value.
  Uses recursion.
}
function ReverseNumberR(AValue: Int64): Int64;

{
  Calculates the root mean square of the elements of Double floating point array
  A.
  Raises EArgumentException if A is empty.
}
function RMS(const A: array of Double): Double; overload;

{
  Calculates the root mean square of the elements of Integer array A.
  Raises EArgumentException if A is empty.
}
function RMS(const A: array of Integer): Double; overload;

{
  Performs an arithmetic right shift operation on the given value and returns
  the result. Value is shifted right by Shift bits.
  Shift must be in the range 0..31 and is adjusted if it is not.
}
function SAR(Value: LongInt; Shift: Byte): LongInt;

{
  Scales the given rectangle by the given scale factor and returns the scaled
  rectangle.
}
function ScaleRect(const ARect: Types.TRect; AScaling: Double): Types.TRect;

{
  Returns the sign of the given floating point value. Returns -1 if the value is
  positive, 0 if zero or +1 if negative.
}
function SignOfFloat(const Value: Extended): Integer;

{
  Returns the sign of the given integer. Returns -1 if the integer is positive,
  0 if zero or +1 if negative.
}
function SignOfInt(const Value: Int64): Integer;

{
  Simplifies the fraction with numerator Num and denominator Denom to its lowest
  terms.
  If the fraction is already in its lowest terms then Num and Denom are left
  unchanged.
}
procedure SimplifyFraction(var Num, Denom: Int64);

{
  Applies the softmax function to each element of floating point array A and
  normalizes them into a probability distribution proportional to the
  exponentials of the elements of A. The normalised values are returned as an
  array of the same size as A.
  An EArgumentException exception is raised if A is empty.
}
function SoftMax(const A: array of Double): Types.TDoubleDynArray;

{
  Stretches rectangle R by the given scaling factors and returns the result.
  The rectangle's width is scaled by ScalingX and its height by ScalingY.
  The top left corner of the rectangle is not changed.
}
function StretchRect(const R: Types.TRect; const ScalingX, ScalingY: Double):
  Types.TRect; overload;

{
  Stretches the rectangle R by scale factor Scaling and returns the result. Both
  width and height are stretched by the same scale factor.
  The top left corner is not changed.
}
function StretchRect(const R: Types.TRect; const Scaling: Double):
  Types.TRect; overload;

{
  Returns the sum of the natural logarithms of each Cardinal element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Cardinal): Extended; overload;

{
  Returns the sum of the natural logarithms of each Double floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Double): Double; overload;

{
  Returns the sum of the natural logarithms of each Extended floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Extended): Extended; overload;

{
  Returns the sum of the natural logarithms of each Int64 element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Int64): Extended; overload;

{
  Returns the sum of the natural logarithms of each Integer element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Integer): Extended; overload;

{
  Returns the sum of the natural logarithms of each Single floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Single): Single; overload;

{
  Returns the sum of the natural logarithms of each UInt64 element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of UInt64): Extended; overload;

{
  Calculates the sum of the reciprocal values of all elements of Cardinal array
  A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Cardinal): Double; overload;

{
  Calculates the sum of the reciprocal values of all elements of Double array A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Double): Double; overload;

{
  Calculates the sum of the reciprocal values of all elements of Integer array
  A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Integer): Double; overload;

{
  Calculates the statistical total sum of squares of the elements of Double
  array A.
  EArgumentException is raised if A is empty.
}
function TSS(const A: array of Double): Double; overload;

{
  Calculates the statistical total sum of squares of the elements of Integer
  array A.
  EArgumentException is raised if A is empty.
}
function TSS(const A: array of Integer): Double; overload;

{
  Calculates and returns the weighted average of the Cardinal elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted average of the Double elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted average of the Integer elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Cardinal values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Double values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Integer values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Cardinal values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Double values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Integer values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;

{
  Returns the weighted power mean of the elements of Cardinal array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero; Lambda must not be
  zero.
}
function WeightedPowerMean(const Values: array of Cardinal;
  const Weights: array of Double; const Lambda: Double): Double; overload;

{
  Returns the weighted power mean of the elements of Double array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; no element of Values may
  be negative; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero; Lambda must not be zero.
}
function WeightedPowerMean(const Values, Weights: array of Double;
  const Lambda: Double): Double; overload;

{
  Returns the weighted power mean of the elements of Integer array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; no element of Values may
  be negative; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero; Lambda must not be zero.
}
function WeightedPowerMean(const Values: array of Integer;
  const Weights: array of Double; const Lambda: Double): Double; overload;

{
  Calculates and returns the largest scaling that can be applied to a rectangle
  of width SrcWidth and height SrcHeight to fit it, without changing the aspect
  ratio, within a second rectangle of width DestWidth and height DestHeight.
}
function ZoomRatio(const DestWidth, DestHeight, SrcWidth, SrcHeight: Integer):
  Double; overload;

{
  Calculates and returns the largest scaling that can be applied to a rectangle
  of size SrcSize to fit it, without changing the aspect ratio, within a second
  rectangle of size DestSize.
}
function ZoomRatio(const DestSize, SrcSize: Types.TSize): Double; overload;

{
  Calculates and returns the largest scaling that can be applied to rectangle
  SrcRect to fit it, without changing the aspect ratio, within rectangle
  DestRect.
}
function ZoomRatio(const DestRect, SrcRect: Types.TRect): Double; overload;

implementation

procedure ExchangeInt(var I1, I2: Integer);
  forward;

{
  Checks if all the digits of the given integer are different to each other.
}
function AllDigitsDifferent(N: Int64): Boolean;
var
  UsedDigits: array[0..9] of Boolean; // records which digits have been used
  I: 0..9;  // loops through elements of UsedDigits
  M: 0..9;  // modulus after dividing by 10
begin
  N := Abs(N);
  Result := False;
  for I := 0 to 9 do
    UsedDigits[I] := False;
  while N > 0 do
  begin
    M := N mod 10;
    if UsedDigits[M] then
      Exit;
    UsedDigits[M] := True;
    N := N div 10;
  end;
  Result := True; // if we get here all digits are unique
end;

{
  Checks if all the digits of the given integer are the same.
}
function AllDigitsSame(N: Int64): Boolean;
var
  D: 0..9;  // sample digit from N
begin
  N := Abs(N);
  D := N mod 10;
  Result := False;
  while N > 0 do
  begin
    if N mod 10 <> D then
      Exit;
    N := N div 10;
  end;
  Result := True;
end;

{
  Returns the arithmetic mean of an array of Cardinal values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Cardinal): Double; overload;
var
  X: Cardinal;
begin
  if Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for X in A do
    Result := Result + X / Length(A);
end;

{
  Returns the arithmetic mean of an array of Double values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Double): Double; overload;
var
  X: Double;
begin
  if Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for X in A do
    Result := Result + X / Length(A);
end;

{
  Returns the arithmetic mean of an array of Integer values.
  EArgumentException is raised if the array is empty.
}
function ArithmeticMean(const A: array of Integer): Double; overload;
var
  X: Integer;
begin
  if Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for X in A do
    Result := Result + X / Length(A);
end;

{
  Returns the sum of all Cardinal elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Cardinal): Cardinal; overload;
var
  Elem: Cardinal;
begin
  Result := 0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all Double floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Double): Double; overload;
var
  Elem: Double;
begin
  Result := 0.0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all Extended floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Extended): Extended; overload;
var
  Elem: Extended;
begin
  Result := 0.0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all Int64 elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Int64): Int64; overload;
var
  Elem: Int64;
begin
  Result := 0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all Integer elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of Integer): Integer; overload;
var
  Elem: Integer;
begin
  Result := 0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all Single floating point elements of array A.
  0.0 is returned if the array is empty.
}
function ArraySum(const A: array of Single): Single; overload;
var
  Elem: Single;
begin
  Result := 0.0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Returns the sum of all UInt64 elements of array A.
  0 is returned if the array is empty.
}
function ArraySum(const A: array of UInt64): UInt64; overload;
var
  Elem: UInt64;
begin
  Result := 0;
  for Elem in A do
    Result := Result + Elem;
end;

{
  Calculates the number of occurrences of each unique element of array A. An
  array of TPair<Integer,Cardinal> values is returned, where the Key field of
  each TPair element is the integer and the Value field is the number of times
  the integer occurs in A. The returned array is sorted on the Key field.
  Raises EArgumentException if A is empty.
}
function CountOccurrences(const A: array of Integer):
  System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;
var
  OccurrenceMap: Generics.Collections.TDictionary<Integer,Cardinal>;
  Elem: Integer;
  OccurrencesOfX: Cardinal;

  procedure SortResult(
    var A: array of Generics.Collections.TPair<Integer,Cardinal>);
  begin
    Generics.Collections.TArray.Sort<
      Generics.Collections.TPair<Integer,Cardinal>
    >(
      A,
      Generics.Defaults.TDelegatedComparer<
        Generics.Collections.TPair<Integer,Cardinal>
      >.Create(
        function (
          const Left, Right: Generics.Collections.TPair<Integer,Cardinal>):
          Integer
        begin
          Result := Left.Key - Right.Key;
        end
      )
    );
  end;

begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  OccurrenceMap := Generics.Collections.TDictionary<Integer,Cardinal>.Create;
  try
    for Elem in A do
    begin
      if OccurrenceMap.TryGetValue(Elem, OccurrencesOfX) then
        System.Inc(OccurrencesOfX)
      else
        OccurrencesOfX := 1;
      OccurrenceMap.AddOrSetValue(Elem, OccurrencesOfX);
    end;
    Result := OccurrenceMap.ToArray;
    SortResult(Result);
  finally
    OccurrenceMap.Free;
  end;
end;

{
  Converts the given decimal to a fraction. The numerator and denominator are
  passed out as floating point numbers in FractionNumerator and
  FractionDenominator respectively.
  AccuracyFactor determines how accurate the conversion is to be.
}
procedure DecimalToFraction(Decimal: Extended; out FractionNumerator: Extended;
  out FractionDenominator: Extended; const AccuracyFactor: Extended);
var
  DecimalSign: Extended;
  Z: Extended;
  PreviousDenominator: Extended;
  ScratchValue: Extended;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sTooSmall = 'Decimal too small to convert to fraction';
  sTooLarge = 'Decimal too large to convert to fraction';
const
  LargestDecimal: Extended = 1.0E+19;
  SmallestDecimal: Extended = 1.0E-19;
begin
  if Decimal < 0.0 then
    DecimalSign := -1.0
  else
    DecimalSign := 1.0;
  Decimal := Abs(Decimal);
  if Math.SameValue(Decimal, Int(Decimal)) then
  begin
    FractionNumerator := Decimal * DecimalSign;
    FractionDenominator := 1.0;
    Exit;
  end;
  if (Decimal < SmallestDecimal) then // X = 0 already taken care of
    raise SysUtils.EConvertError.Create(sTooSmall);
  if (Decimal > LargestDecimal) then
    raise SysUtils.EConvertError.Create(sTooLarge);
  Z := Decimal;
  PreviousDenominator := 0.0;
  FractionDenominator := 1.0;
  repeat
    Z := 1.0 / (Z - Int(Z));
    ScratchValue := FractionDenominator;
    FractionDenominator := FractionDenominator * Int(Z) + PreviousDenominator;
    PreviousDenominator := ScratchValue;
    FractionNumerator := Int(Decimal * FractionDenominator + 0.5) // Rounding
  until
    (
      Abs(
        Decimal - (FractionNumerator / FractionDenominator)
      ) < AccuracyFactor
    )
    or (Z = Int(Z));
  FractionNumerator := DecimalSign * FractionNumerator;
end;

{
  Counts the number of digits in the given integer.
}
function DigitCount(AInteger: Int64): Integer;
begin
  if AInteger <> 0 then
  begin
    Result := 0;
    AInteger := Abs(AInteger);
    while AInteger > 0 do
    begin
      AInteger := AInteger div 10;
      Inc(Result);
    end;
  end
  else
    Result := 1;
end;

{
  Counts the number of digits in the given integer.
}
function DigitCount2(const AValue: Int64): Integer;
begin
  if AValue <> 0 then
    Result := Math.Floor(Math.Log10(Abs(AValue))) + 1
  else
    Result := 1;
end;

{
  Returns the number of digits in integer N when expressed in base Base.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitCountBase(N: Int64; const Base: Byte): Cardinal;
begin
  if Base < 2 then
    raise SysUtils.EArgumentException.Create(
      'Base must be in the range 2..255'
    );
  if N = 0 then
    Exit(1);
  N := Abs(N);
  Result := 0;
  repeat
    Inc(Result);
    N := N div Base;
  until N = 0;
end;

{
  Counts the number of digits in the given integer using recursion.
}
function DigitCountR(AValue: Int64): Integer;
begin
  if AValue mod 10 = AValue then
    Result := 1
  else
    Result := 1 + DigitCountR(AValue div 10)
end;

{
  Calculates the sum of all the digits of integer N in base Base where each
  digit is raised to the power Exponent. The returned value has the same sign as
  N.
  If the result is too large to be represented as an Int64 value then an
  EOverflow exception is raised.
  Bases up to 255 are supported. If Base <= 2 then an EArgumentException
  exception is raised.
}
function DigitPowerSum(N: Integer; const Base: Byte; const Exponent: Byte):
  Int64;
var
  SignOfN: Math.TValueSign;
  Digit: Integer;
  PowerDigit: Int64;
begin
  if Base < 2 then
    raise SysUtils.EArgumentException.Create(
      'Base must be in the range 2..255'
    );
  if N = 0 then
    Exit(0);
  SignOfN := Math.Sign(N);
  N := Abs(N);
  Result := 0;
  repeat
    Digit := N mod Base;
    PowerDigit := PowNZN(Digit, Exponent);
    if High(Int64) - PowerDigit < Abs(Result) then
      raise SysUtils.EOverflow.Create('Overflow calculating digit power sum');
    Result := Result + PowerDigit;
    N := N div Base;
  until N = 0;
  if SignOfN = Math.NegativeValue then
    Result := -1 * Result;
end;

{
  Returns an array containing the digits of integer N when expressed in base
  Base. The array is ordered with the least significant digit first.
  The returned array contains the decimal value of the digit, for e.g. the hex
  symbol F is represented by an array element containing the value 15.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitsOf(N: Int64; const Base: Byte): SysUtils.TBytes;
var
  Idx: Integer;
begin
  if Base < 2 then
    raise SysUtils.EArgumentException.Create(
      'Base must be in the range 2..255'
    );
  N := Abs(N);
  SetLength(Result, DigitCountBase(N, Base));
  if N > 0 then
  begin
    Idx := 0;
    repeat
      Result[Idx] := N mod Base;
      Inc(Idx);
      N := N div Base;
    until N = 0;
  end
  else
    Result[0] := 0;
end;

{
  Returns the sum of the digits from the given integer, using recursion.
}
function DigitSum(AValue: Int64): Integer;
begin
  if AValue mod 10 = AValue then
    Result := AValue
  else
    Result := (AValue mod 10) + DigitSum(AValue div 10)
end;

{
  Calculates the sum of all the digits of integer N when epxressed in base Base.
  The returned value has the same sign as N.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function DigitSumBase(N: Int64; const Base: Byte): Integer;
var
  SignOfN: Math.TValueSign;
begin
  if Base < 2 then
    raise SysUtils.EArgumentException.Create(
      'Base must be in the range 2..255'
    );
  if N = 0 then
    Exit(0);    
  SignOfN := Math.Sign(N);
  N := Abs(N);
  Result := 0;
  repeat
    Inc(Result, N mod Base);
    N := N div Base;
  until N = 0;
  if SignOfN = Math.NegativeValue then
    Result := -1 * Result;
end;

{
  Calculates the distance between two given points with double precision
  floating point valued coordinates.
}
function DistanceBetweenPoints(const P1, P2: TPointF): Extended; overload;
begin
  Result := Math.Hypot(P1.X - P2.X, P1.Y - P2.Y);
end;

{
  Calculates the distance between two points with integer valued co-ordinates.
}
function DistanceBetweenPoints(const P1, P2: Types.TPoint): Extended; overload;
begin
  Result := Math.Hypot(P1.X - P2.X, P1.Y - P2.Y);
end;

{
  Exchanges the values of two given integers.
}
procedure ExchangeInt(var I1, I2: Integer);
var
  Temp: Integer;  // temporary value used when exchanging values
begin
  Temp := I1;
  I1 := I2;
  I2 := Temp;
end;

{
  Calculates the factorial of the given number.
}
function Factorial(N: Byte): Int64;
var
  K: Integer; // loop control
begin
  Result := 1;
  if (N = 0) or (N = 1) then
    Exit;
  for K := 2 to N do
    Result := Result * K;
end;

{
  Determines the greatest common divisor of two given non-zero integers.
}
function GCD(A, B: Integer): Integer;
var
  Temp: Integer; // used in swapping A & B
begin
  while B <> 0 do
  begin
    Temp := B;
    B := A mod Temp;
    A := Temp;
  end;
  Result := Abs(A);
end;

{
  Determines the greatest common divisor of two given non-zero integers.
}
function GCD2(const A, B: Integer): Integer;
begin
  if B = 0 then
    Result := Abs(A)
  else
    Result := GCD2(B, A mod B);
end;

{
  Returns the geometric mean of an array of positive Cardinal values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Cardinal): Double; overload;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := System.Exp(SumOfLogs(A) / System.Length(A));
end;

{
  Returns the geometric mean of an array of positive Double values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Double): Double; overload;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := System.Exp(SumOfLogs(A) / System.Length(A));
end;

{
  Returns the geometric mean of an array of positive Integer values.
  EArgumentException is raised if the array is empty while
  EArgumentOutOfRangeException is raised if any array element is not positive.
}
function GeometricMean(const A: array of Integer): Double; overload;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := System.Exp(SumOfLogs(A) / System.Length(A));
end;

{
  Returns the harmonic mean of an array of positive Cardinal values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Cardinal): Double; overload;
begin
  Result := System.Length(A) / SumOfReciprocals(A);
end;

{
  Returns the harmonic mean of an array of positive Double values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Double): Double; overload;
begin
  Result := System.Length(A) / SumOfReciprocals(A);
end;

{
  Returns the harmonic mean of an array of positive Integer values.
  EArgumentException is raised if the array is empty or if any array element is
  not positive.
}
function HarmonicMean(const A: array of Integer): Double; overload;
begin
  Result := System.Length(A) / SumOfReciprocals(A);
end;

{
  Checks if the given array of integers A has a mode and returns True if so.
  Raises EArgumentException if A has fewer than two elements.
}
function HasMode(const A: array of Integer): Boolean;
var
  OccurrenceCounts: System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;
  KV: Generics.Collections.TPair<Integer,Cardinal>;
  MaxCount: Cardinal;
begin
  if System.Length(A) <= 1 then
    raise SysUtils.EArgumentException.Create(
      'At least two values required to calculate a mode'
    );
  Result := False;
  OccurrenceCounts := CountOccurrences(A);
  if System.Length(OccurrenceCounts) = 1 then
    // all data items have the same value: has mode
    Exit(True);
  MaxCount := 0;
  for KV in OccurrenceCounts do
    if KV.Value > MaxCount then
      MaxCount := KV.Value;
  for KV in OccurrenceCounts do
    if KV.Value < MaxCount then
      // at least one value is not the mode => mode exists
      Exit(True);
end;

{
  Checks if the absolute value of integer N is a narcissistic number in base
  Base.
  Bases up to 255 are supported. If Base <= 2 then an EArgumentException
  exception is raised. An EOverflow exception may be raised for large numbers
  and bases.
}
function IsNarcissistic(N: Integer; const Base: Byte = 10): Boolean;
var
  Sum: Int64;
begin
  N := Abs(N);
  Sum := DigitPowerSum(N, Base, DigitCountBase(N, Base));
  Result := N = Sum;
end;

{
  Checks if the absolute value of integer N is palindromic in base Base.
  Bases up to 255 are supported. If Base < 2 then an EArgumentException
  exception is raised.
}
function IsPalindromic(const N: Int64; const Base: Byte = 10): Boolean;
var
  Digits: SysUtils.TBytes;
  Idx: Integer;
  PartitionSize: Integer;
begin
  Digits := DigitsOf(N, Base); // raises exception for Base < 2
  Result := True;
  PartitionSize := Length(Digits) div 2;
  for Idx := 0 to Pred(PartitionSize) do
    if Digits[Idx] <> Digits[Length(Digits) - Idx - 1] then
      Exit(False);
end;

{
  Checks if the given number is prime.
}
function IsPrime(N: Integer): Boolean;
var
  Max: Integer;     // max divisor
  Divisor: Integer; // different divisors to try
begin
  Result := False;
  if N < 2 then
    Exit; // not a prime
  Result := True;
  if N = 2 then
    Exit; // 2 is prime
  if N mod 2 = 0 then
    Result := False; // even numbers > 2 are not prime
  Max := Trunc(Sqrt(N)) + 1;
  Divisor := 3;
  // test odd numbers
  while (Max > Divisor) and Result do
  begin
    if (N mod Divisor) = 0 then
      Result := False;
    Inc(Divisor, 2); // next odd number
  end;
end;

{
  Checks if the given number is prime.
}
function IsPrime2(Val: Integer): Boolean;
var
  X: Integer; // index
begin
  Result := (Val > 1);
  if Result then
  begin
    for X := (Val div 2) downto 2 do
    begin
      Result := Result and ((Val mod X) <> 0);
      if not Result then
    	Break;
    end;
  end;
end;

{
  Checks if the given rectangle is normalized, i.e. Left <= Right and Top <=
  Bottom.
}
function IsRectNormal(const R: Windows.TRect): Boolean;
begin
  Result := (R.Left <= R.Right) and (R.Top <= R.Bottom);
end;

{
  Returns the least common divisor of two given non-zero integers.
}
function LCD(A, B: Integer): Integer;
begin
  Result := Abs((A * B)) div GCD(A, B);
end;

{
  Returns the logarithmic mean of two positive floating point values, X and Y.
  Raises EArgumentException if either X or Y is not positive.
}
function LogarithmicMean(const X, Y: Double): Double;
begin
  if (X <= 0) or (Y <= 0) then
    raise SysUtils.EArgumentException.Create(
      'Parameters X & Y must both be positive'
    );
  if Math.SameValue(X, Y) then
    Result := X
  else
    Result := (Y - X) / (System.Ln(Y) - System.Ln(X));
end;

{
  Returns the logarithm of the sum of the exponentials of the given array of
  floating pointing point numbers.
  An EArgumentException exception is raised if the array is empty.
}
function LSE(const A: array of Double): Double;
var
  MaxElem: Double;
  Elem: Double;
  Sum: Double;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Empty array');
  // Using the centering "trick": see https://rpubs.com/FJRubio/LSE
  MaxElem := MaxOfArray(A);
  Sum := 0.0;
  for Elem in A do
    Sum := Sum + System.Exp(Elem - MaxElem);
  Result := System.Ln(Sum) + MaxElem;
end;

{
  Returns the maximum value contained in the given array of double precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Double): Double; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] > Result then
      Result := A[Idx];
end;

{
  Returns the maximum value contained in the given array of extended precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Extended): Extended; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] > Result then
      Result := A[Idx];
end;

{
  Returns the maximum value contained in the given array of 64 bit integer
  values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Int64): Int64; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] > Result then
      Result := A[Idx];
end;

{
  Returns the maximum value contained in the given array of integer values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Integer): Integer; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] > Result then
      Result := A[Idx];
end;

{
  Returns the maximum value contained in the given array of single precision
  floating point values.
  The array must not be empty.
}
function MaxOfArray(const A: array of Single): Single; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] > Result then
      Result := A[Idx];
end;

{
  Returns the median of an array of floating point values.
  Raises an EArgumentException exception if the array is empty.
}
function Median(A: array of Double): Double; overload;
var
  MiddleLo: Integer;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  // optimisations for array lengths 1 & 2 to avoid sorting
  if System.Length(A) = 1 then
    Exit(A[0]);
  if System.Length(A) = 2 then
    Exit((A[0] + A[1]) / 2.0);
  Generics.Collections.TArray.Sort<Double>(A); // using standard comparer
  MiddleLo := System.Length(A) div 2 - 1;
  if System.Odd(System.Length(A)) then
    Result := A[MiddleLo + 1]
  else
    Result := (A[MiddleLo] + A[MiddleLo + 1]) / 2.0;
end;

{
  Returns the median of an array of integer values.
  Raises an EArgumentException exception if the array is empty.
}
function Median(A: array of Integer): Double; overload;
var
  MiddleLo: Integer;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  // optimisations for array lengths 1 & 2 to avoid sorting
  if System.Length(A) = 1 then
    Exit(A[0]);
  if System.Length(A) = 2 then
    Exit((A[0] + A[1]) / 2);
  Generics.Collections.TArray.Sort<Integer>(A); // using standard comparer
  MiddleLo := System.Length(A) div 2 - 1;
  if System.Odd(Length(A)) then
    Result := A[MiddleLo + 1]
  else
    Result := (A[MiddleLo] + A[MiddleLo + 1]) / 2;
end;

{
  Returns the middle of three double precision floating point values.
}
function Mid(const A, B, C: Double): Double; overload;
begin
  Result := Math.Min(
    Math.Min(
      Math.Max(A, B), Math.Max(B, C)
    ),
    Math.Max(A, C)
  );
end;

{
  Returns the middle of three extended precision floating point values.
}
function Mid(const A, B, C: Extended): Extended; overload;
begin
  Result := Math.Min(
    Math.Min(
      Math.Max(A, B), Math.Max(B, C)
    ),
    Math.Max(A, C)
  );
end;

{
  Returns the middle of three 64 bit integer values.
}
function Mid(const A, B, C: Int64): Int64; overload;
begin
  Result := Math.Min(
    Math.Min(
      Math.Max(A, B), Math.Max(B, C)
    ),
    Math.Max(A, C)
  );
end;

{
  Returns the middle of three integer values.
}
function Mid(const A, B, C: Integer): Integer; overload;
begin
  Result := Math.Min(
    Math.Min(
      Math.Max(A, B), Math.Max(B, C)
    ),
    Math.Max(A, C)
  );
end;

{
  Returns the middle of three single precision floating point values.
}
function Mid(const A, B, C: Single): Single; overload;
begin
  Result := Math.Min(
    Math.Min(
      Math.Max(A, B), Math.Max(B, C)
    ),
    Math.Max(A, C)
  );
end;

{
  Finds the minimum and maximum values contained in the non-empty array, A, of
  double precision floating point values. MinValue and MaxValue are set to the
  minimum and maximum values, respectively.
  EArgumentException is raised if A is empty.
}
procedure MinMaxOfArray(const A: array of Double;
  out MinValue, MaxValue: Double); overload;
var
  Idx: Integer;
  Elem: Double;
begin
  if Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  MinValue := A[0];
  MaxValue := A[0];
  for Idx := 1 to Pred(Length(A)) do
  begin
    Elem := A[Idx];
    if Elem > MaxValue then
      MaxValue := Elem
    else if Elem < MinValue then
      MinValue := Elem;
  end;
end;

{
  Finds the minimum and maximum values contained in the non-empty Integer array
  A. MinValue and MaxValue are set to the minimum and maximum values,
  respectively.
  EArgumentException is raised if A is empty.
}
procedure MinMaxOfArray(const A: array of Integer;
  out MinValue, MaxValue: Integer); overload;
var
  Idx: Integer;
  Elem: Integer;
begin
  if Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  MinValue := A[0];
  MaxValue := A[0];
  for Idx := 1 to Pred(Length(A)) do
  begin
    Elem := A[Idx];
    if Elem > MaxValue then
      MaxValue := Elem
    else if Elem < MinValue then
      MinValue := Elem;
  end;
end;

{
  Finds the minimum, middle and maximum values of three double precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Double; out Min, Mid, Max: Double); overload;
var
  Temp: Double;
begin
  if A > B then
  begin
    Max := A;
    Min := B;
  end
  else
  begin
    Max := B;
    Min := A;
  end;
  if C > Max then
  begin
    Mid := Max;
    Max := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end
  else
  begin
    Mid := Min;
    Min := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end;
end;

{
  Finds the minimum, middle and maximum values of three extended precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Extended; out Min, Mid, Max: Extended); 
  overload;
var
  Temp: Extended;
begin
  if A > B then
  begin
    Max := A;
    Min := B;
  end
  else
  begin
    Max := B;
    Min := A;
  end;
  if C > Max then
  begin
    Mid := Max;
    Max := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end
  else
  begin
    Mid := Min;
    Min := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end;
end;

{
  Finds the minimum, middle and maximum values of three 64 bit integers, A, B
  and C and returns them in Min, Mid and Max respectively.
}
procedure MinMidMax(const A, B, C: Int64; out Min, Mid, Max: Int64); overload;
var
  Temp: Int64;
begin
  if A > B then
  begin
    Max := A;
    Min := B;
  end
  else
  begin
    Max := B;
    Min := A;
  end;
  if C > Max then
  begin
    Mid := Max;
    Max := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end
  else
  begin
    Mid := Min;
    Min := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end;
end;

{
  Finds the minimum, middle and maximum values of three integers, A, B and C and
  returns them in Min, Mid and Max respectively.
}
procedure MinMidMax(const A, B, C: Integer; out Min, Mid, Max: Integer);
  overload;
var
  Temp: Integer;
begin
  if A > B then
  begin
    Max := A;
    Min := B;
  end
  else
  begin
    Max := B;
    Min := A;
  end;
  if C > Max then
  begin
    Mid := Max;
    Max := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end
  else
  begin
    Mid := Min;
    Min := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end;
end;

{
  Finds the minimum, middle and maximum values of three single precision
  floating point numbers, A, B and C and returns them in Min, Mid and Max
  respectively.
}
procedure MinMidMax(const A, B, C: Single; out Min, Mid, Max: Single); overload;
var
  Temp: Single;
begin
  if A > B then
  begin
    Max := A;
    Min := B;
  end
  else
  begin
    Max := B;
    Min := A;
  end;
  if C > Max then
  begin
    Mid := Max;
    Max := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end
  else
  begin
    Mid := Min;
    Min := C;
    if Mid < Min then
    begin
      Temp := Mid;
      Mid := Min;
      Min := Temp;
    end;
  end;
end;

{
  Returns the minimum value contained in the given array of double precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Double): Double; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] < Result then
      Result := A[Idx];
end;

{
  Returns the minimum value contained in the given array of extended precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Extended): Extended; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] < Result then
      Result := A[Idx];
end;

{
  Returns the minimum value contained in the given array of 64 bit integer
  values.
  The array must not be empty.
}
function MinOfArray(const A: array of Int64): Int64; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] < Result then
      Result := A[Idx];
end;

{
  Returns the minimum value contained in the given array of integer values.
  The array must not be empty.
}
function MinOfArray(const A: array of Integer): Integer; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] < Result then
      Result := A[Idx];
end;

{
  Returns the minimum value contained in the given array of single precision
  floating point values.
  The array must not be empty.
}
function MinOfArray(const A: array of Single): Single; overload;
var
  Idx: Integer;
begin
  Assert(Length(A) > 0);
  Result := A[Low(A)];
  for Idx := Succ(Low(A)) to High(A) do
    if A[Idx] < Result then
      Result := A[Idx];
end;

{
  Calculates the mode of array A of integer data. Returns an array containing
  the mode or modes of the data.
  If the data has a single mode, then a single element array containing the mode
  is returned. If the data is multi-modal then all the modes are returned. If
  all data items occur with equal frequency then an array of all unique data
  items is returned. The returned data is sorted in ascending order.
  Raises EArgumentException if A has fewer than two elements.
}
function Mode(const A: array of Integer): System.TArray<Integer>;
var
  OccurrenceCounts: System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;
  Modes: Generics.Collections.TList<Integer>;
  KV: Generics.Collections.TPair<Integer,Cardinal>;
  MaxCount: Cardinal;
begin
  if System.Length(A) <= 1 then
    raise SysUtils.EArgumentException.Create(
      'At least two values required to calculate the mode'
    );
  MaxCount := 0;
  OccurrenceCounts := CountOccurrences(A);
  for KV in OccurrenceCounts do
    if KV.Value > MaxCount then
      MaxCount := KV.Value;
  Modes := Generics.Collections.TList<Integer>.Create;
  try
    for KV in OccurrenceCounts do
      if KV.Value = MaxCount then
        Modes.Add(KV.Key);
    Modes.Sort;
    Result := Modes.ToArray;
  finally
    Modes.Free;
  end;
end;

{
  Calculates the mode of array A of integer data. Returns an array containing
  the mode or modes of the data, if any.
  If the data has a single mode, then a single element array containing the mode
  is returned. If the data is multi-modal then all the modes are returned,
  sorted in ascending order. If all data items occur with equal frequency, and
  not all data items are the same, then there is no mode and an empty array is
  returned.
  Raises EArgumentException if A has fewer than two elements.
}
function ModeAlt(const A: array of Integer): System.TArray<Integer>;
var
  OccurrenceCounts: System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;
  Modes: Generics.Collections.TList<Integer>;
  KV: Generics.Collections.TPair<Integer,Cardinal>;
  MaxCount: Cardinal;
  HasMode: Boolean;
begin
  if System.Length(A) <= 1 then
    raise SysUtils.EArgumentException.Create(
      'At least two values required to calculate the mode'
    );
  OccurrenceCounts := CountOccurrences(A);
  if System.Length(OccurrenceCounts) = 1 then
    // all data items have the same value: result is the sole data value
    Exit(System.TArray<Integer>.Create(A[0]));
  MaxCount := 0;
  for KV in OccurrenceCounts do
    if KV.Value > MaxCount then
      MaxCount := KV.Value;
  Modes := Generics.Collections.TList<Integer>.Create;
  HasMode := False;
  try
    for KV in OccurrenceCounts do
      if KV.Value = MaxCount then
        Modes.Add(KV.Key)
      else
        HasMode := True;
    Modes.Sort;
    if HasMode then
      Result := Modes.ToArray
    else
      // the are >= 2 different data items, all of which occur with the same
      // frequency: return empty array
      System.SetLength(Result, 0);
  finally
    Modes.Free;
  end;
end;

{
  Returns the number of modes of integer array A.
  Raises EArgumentException if A has fewer than two elements.
}
function ModeCount(const A: array of Integer): Integer;
var
  OccurrenceCounts: System.TArray<Generics.Collections.TPair<Integer,Cardinal>>;
  KV: Generics.Collections.TPair<Integer,Cardinal>;
  MaxCount: Cardinal;
  HasMode: Boolean;
begin
  if System.Length(A) <= 1 then
    raise SysUtils.EArgumentException.Create(
      'At least two values required to calculate a mode'
    );
  OccurrenceCounts := CountOccurrences(A);
  if System.Length(OccurrenceCounts) = 1 then
    // all data items have the same value: has single mode
    Exit(1);
  MaxCount := 0;
  for KV in OccurrenceCounts do
    if KV.Value > MaxCount then
      MaxCount := KV.Value;
  Result := 0;
  HasMode := False;
  for KV in OccurrenceCounts do
    if KV.Value = MaxCount then
      System.Inc(Result)
    else
      HasMode := True;
  if not HasMode then
    Result := 0;
end;

{
  Translates the give rectangle to the origin.
  The top and left co-ordinates are set to zero and the bottom and right
  co-ordinates are adjusted accordingly.
}
function MoveRectToOrigin(const R: Types.TRect): Types.TRect;
begin
  Result := R;
  Types.OffsetRect(Result, -R.Left, -R.Top);
end;

{
  Normalises the values in unsigned integer array A so that each value of A is
  mapped to a value in the range [0..1], where the total of all the values is 1.
  The relative weights of the values are preserved.
  An array of the same size as A is returned where each element contains the
  normalised value of the corresponding element of A.
  A must not be empty and must have at least one non-zero element.
  EArgumentException is raised if these conditions are not met.
}
function NormaliseByWeight(const A: array of Cardinal): Types.TDoubleDynArray;
  overload;
var
  Weight: Cardinal;
  WeightSum: UInt64;
  Idx: Integer;
begin
  if (System.Length(A) = 0) then
    raise SysUtils.EArgumentException.Create('Array of weights is empty');
  WeightSum := 0;
  for Weight in A do
    WeightSum := WeightSum + Weight;
  if WeightSum = 0 then
    raise SysUtils.EArgumentException.Create('Sum of weights is zero');
  System.SetLength(Result, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Result[Idx] := A[Idx] / WeightSum;
end;

{
  Normalises the values in floating point array A so that each value of A is
  mapped to a value in the range [0..1], where the total of all the values is 1.
  The relative weights of the values are preserved.
  An array of the same size as A is returned where each element contains the
  normalised value of the corresponding element of A.
  A must not be empty. All elements of A must be >= 0, with at least one element
  > 0. EArgumentException is raised if these conditions are not met.
}
function NormaliseByWeight(const A: array of Double): Types.TDoubleDynArray;
  overload;
var
  Weight: Double;
  WeightSum: Double;
  Idx: Integer;
begin
  if (System.Length(A) = 0) then
    raise SysUtils.EArgumentException.Create('Array of weights is empty');
  WeightSum := 0.0;
  for Weight in A do
  begin
    if Math.Sign(Weight) = Math.NegativeValue then
      raise SysUtils.EArgumentException.Create(
        'All weights must be non-negative'
      );
    WeightSum := WeightSum + Weight;
  end;
  if Math.IsZero(WeightSum) then
    raise SysUtils.EArgumentException.Create('Sum of weights is zero');
  System.SetLength(Result, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Result[Idx] := A[Idx] / WeightSum;
end;

{
  Normalises the sign of the fraction with numerator Num and denominator Denom
  so that Num takes the sign of the fraction and Denom is non-negative.
}
procedure NormaliseFractionSign(var Num, Denom: Integer);
begin
  if Denom < 0 then
  begin
    Num := -Num;
    Denom := -Denom;
  end;
end;

{
  Normalises the given rectangle so that Left <= Right and Top <= Bottom.
}
function NormalizeRect(const R: Windows.TRect): Windows.TRect;
begin
  Result := R;
  if Result.Left > Result.Right then
    ExchangeInt(Result.Left, Result.Right);
  if Result.Top > Result.Bottom then
    ExchangeInt(Result.Top, Result.Bottom);
end;

{
  Raises integer value Base to non-negative integer power Exponent and returns
  the result.
}
function Pow(const Base: Int64; const Exponent: Byte): Int64;
var
  I: Byte;
begin
  Result := 1;
  for I := 1 to Exponent do
    Result := Result * Base;
end;

{
  Returns the power mean of the elements of Cardinal array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty or if Lambda is zero.
}
function PowerMean(const A: array of Cardinal; const Lambda: Double): Double;
  overload;
var
  Floats: Types.TDoubleDynArray;
  Idx: Integer;
begin
  System.SetLength(Floats, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Floats[Idx] := A[Idx];
  Result := PowerMean(Floats, Lambda);
end;

{
  Returns the power mean of the elements of Double array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty, if any array element is
  negative or if Lambda is zero.
}
function PowerMean(const A: array of Double; const Lambda: Double): Double;
  overload;
var
  Sum: Double;
  X: Double;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  if Math.IsZero(Lambda) then
    raise SysUtils.EArgumentException.Create('Lambda must not be zero');
  Sum := 0.0;
  for X in A do
  begin
    if Math.Sign(X) = NegativeValue then
      raise SysUtils.EArgumentException.Create(
        'All array elements must be non-negative'
      );
    if not Math.IsZero(X) then
      Sum := Sum + Math.Power(X, Lambda);
  end;
  Result := Math.Power(Sum / System.Length(A), 1 / Lambda);
end;

{
  Returns the power mean of the elements of Integer array Values, with exponent
  Lambda.
  An EArgumentException is raised if the array is empty, if any array element is
  negative or if Lambda is zero.
}
function PowerMean(const A: array of Integer; const Lambda: Double): Double;
  overload;
var
  Floats: Types.TDoubleDynArray;
  Idx: Integer;
begin
  System.SetLength(Floats, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Floats[Idx] := A[Idx];
  Result := PowerMean(Floats, Lambda);
end;

{
  IEEE compliant function that raises real number X to the power N.
}
function PowN(const X: Extended; const N: Integer): Extended;
var
  I: Integer;
begin
  if N = 0 then
    // IEEE: pown(x, 0) is 1, even when X is zero
    Exit(1.0);
  if Math.SameValue(1.0, X) then
    Exit(1.0);
  if Math.IsZero(X) then
  begin
    if N < 0 then
      raise SysUtils.EDivByZero.Create('PowN: Negative exponent for X = 0');
    Exit(0.0);
  end;
  Result := 1.0;
  for I := 1 to System.Abs(N) do
    Result := Result * X;
  if N < 0 then
    Result := 1 / Result;
end;

{
  Raises integer X to non-negative integer power N.
  If the result is too large to be represented as an Int64 value then an
  EOverflow exception is raised.
}
function PowNZN(const X: Integer; const N: Cardinal): Int64;
var
  I: Integer;
  OverflowGuard: Int64;
begin
  if N = 0 then
    // IEEE: pown(x, 0) is 1, even when X is zero
    Exit(1);
  if X = 0 then
    // pown(0, n) = 0, for all positive n
    Exit(0);
  OverflowGuard := High(Int64) div Abs(X);
  Result := 1;
  for I := 1 to N do
  begin
    if OverflowGuard < Abs(Result) then
      raise SysUtils.EOverflow.CreateFmt(
        'Overflow calculating %d to the power %d', [X, N]
      );
    Result := Result * X;
  end;
end;

{
  Raises integer X to integer power N.
}
function PowNZZ(const X: Integer; const N: Integer): Extended;
var
  I: Integer;
  ResultInt: Int64;
begin
  if N = 0 then
    Exit(1.0);
  if X = 1 then
    Exit(1.0);
  if X = 0 then
  begin
    if N < 0 then
      raise SysUtils.EDivByZero.Create('PowNZZ: Negative exponent for X = 0');
    Exit(0.0);
  end;
  ResultInt := 1;
  for I := 1 to System.Abs(N) do
    ResultInt := ResultInt * X;
  if N > 0 then
    Result := ResultInt
  else // N < 0
    Result := 1 / ResultInt;
end;

{
  Returns the length of the range of values in non-empty Double array A.
  EArgumentException is raised if A is empty.
}
function RangeOf(const A: array of Double): Double; overload;
var
  MinValue, MaxValue: Double;
begin
  MinMaxOfArray(A, MinValue, MaxValue); // exception raised if A is empty
  Result := MaxValue - MinValue;
  // Ensure that exactly zero is returned when MaxValue = MinValue
  if Math.IsZero(Result) then
    Result := 0.0;
end;

{
  Returns the length of the range of values in non-empty Integer array A.
  EArgumentException is raised if A is empty.
}
function RangeOf(const A: array of Integer): Cardinal; overload;
var
  MinValue, MaxValue: Integer;
begin
  MinMaxOfArray(A, MinValue, MaxValue); // exception raised if A is empty
  // MaxValue >= MinValue is guaranteed => Result >= 0
  Result := Cardinal(MaxValue - MinValue);
end;

{
  Returns the area of the given rectangle.
}
function RectArea(const R: Windows.TRect): Int64;
begin
  Result := Abs((R.Right - R.Left) * (R.Bottom - R.Top));
end;

{
  Returns the height of the given rectangle.
  The return value is always non-negative even if the rectangle is not
  normalized.
}
function RectHeight(const R: Windows.TRect): Integer;
begin
  Result := R.Bottom - R.Top;
  if Result < 0 then
    Result := -Result;
end;

{
  Returns the size of the given rectangle.
  The returned dimensions are always non-negative even if the rectangle is not
  normalized.
}
function RectSize(const R: Windows.TRect): Windows.TSize;
begin
  Result.cx := RectWidth(R);
  Result.cy := RectHeight(R);
end;

{
  Returns the width of the given rectangle.
  The return value is always non-negative even if the rectangle is not
  normalized.
}
function RectWidth(const R: Windows.TRect): Integer;
begin
  Result := R.Right - R.Left;
  if Result < 0 then
    Result := -Result;
end;

{
  Checks if the given integer contains only a single repeated digit.
}
function RepeatedDigits(N: Int64): Boolean;
begin
  N := Abs(N);
  if N > 0 then
    Result :=
      N = SysUtils.StrToInt64(
        StringOfChar(
          Char(48 + N mod 10),
          Succ(Math.Floor(Math.Log10(N)))
        )
      )
  else
    Result := True;
end;

{
  Rescales the elements of array A containing a range of Double values so that
  each value of A is mapped to a value in the range [0..1].
  An array of the same size as A is returned where each element contains the
  rescaled value of the corresponding element of A.
  A must not be empty and not all elements may be the same value.
  EArgumentException is raised if either condition is not met.
}
function RescaleRange(const A: array of Double): Types.TDoubleDynArray;
  overload;
var
  Min, Max, RangeLength: Double;
  Idx: Integer;
begin
  MinMaxOfArray(A, Min, Max); // raises exception if A is empty
  if Math.SameValue(Max, Min) then
    raise SysUtils.EArgumentException.Create('All array values are the same');
  System.SetLength(Result, System.Length(A));
  RangeLength := Max - Min;
  for Idx := 0 to Pred(System.Length(A)) do
    Result[Idx] := (A[Idx] - Min) / RangeLength;
end;

{
  Rescales the elements of array A containing a range of Integer values so that
  each value of A is mapped to a value in the range [0..1].
  An array of the same size as A is returned where each element contains the
  rescaled value of the corresponding element of A.
  A must not be empty and not all elements may be the same value.
  EArgumentException is raised if either condition is not met.
}
function RescaleRange(const A: array of Integer): Types.TDoubleDynArray;
  overload;
var
  Min, Max, RangeLength: Integer;
  Idx: Integer;
begin
  MinMaxOfArray(A, Min, Max); // raises exception if A is empty
  if Max = Min then
    raise SysUtils.EArgumentException.Create('All array values are the same');
  System.SetLength(Result, System.Length(A));
  RangeLength := Max - Min;
  for Idx := 0 to Pred(System.Length(A)) do
    Result[Idx] := (A[Idx] - Min) / RangeLength;
end;

{
  Resizes rectangle R to size NewSize, leaving the top-left position unchanged.
  Returns the resized rectangle.
}
function ResizeRect(const R: Types.TRect; const NewSize: Types.TSize):
  Types.TRect; overload;
begin
  Result := ResizeRect(R, NewSize.CX, NewSize.CY);
end;

{
  Resizes rectangle R to the width and height given by NewWidth and NewHeight,
  leaving the top-left position unchanged.
  Returns the resized rectangle.
}
function ResizeRect(const R: Types.TRect; const NewWidth, NewHeight: LongInt):
  Types.TRect; overload;
begin
  Result := Types.Bounds(R.Left, R.Top, NewWidth, NewHeight);
end;

{
  Reverses the digits of integer AValue and returns the resulting value.
  AValue should be positive: zero is always returned for negative integers.
}
function ReverseNumber(AValue: Int64): Int64;
begin
  Result := 0;
  while AValue > 0 do
  begin
    Result := (Result * 10) + (AValue mod 10);
    AValue := AValue div 10;
  end;
end;

{
  Reverses the digits of the given integer, which must be non-negative, and
  returns the resulting value.
  Uses recursion.
}
function ReverseNumberR(AValue: Int64): Int64;
begin
  Assert(AValue >= 0);
  if AValue mod 10 = AValue then
    Result := AValue
  else
    Result := ((AValue mod 10) * Trunc(IntPower(10, Trunc(Log10(AValue)))))
      + ReverseNumberR(AValue div 10)
end;

{
  Calculates the root mean square of the elements of Double floating point array
  A.
  Raises EArgumentException if A is empty.
}
function RMS(const A: array of Double): Double; overload;
var
  Squares: array of Double;
  Idx: Integer;
begin
  System.SetLength(Squares, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Squares[Idx] := A[Idx] * A[Idx];
  // Note: ArithmeticMean raises exception if A is empty
  Result := Math.Power(ArithmeticMean(Squares), 0.5);
end;

{
  Calculates the root mean square of the elements of Integer array A.
  Raises EArgumentException if A is empty.
}
function RMS(const A: array of Integer): Double; overload;
var
  Squares: array of Double;
  Idx: Integer;
  Elem: Double;
begin
  System.SetLength(Squares, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
  begin
    // convert Integer to Double before squaring to reduce change of overflow
    Elem := A[Idx];
    Squares[Idx] := Elem * Elem;
  end;
  // Note: ArithmeticMean raises exception if A is empty
  Result := Math.Power(ArithmeticMean(Squares), 0.5);
end;

{
  Performs an arithmetic right shift operation on the given value and returns
  the result. Value is shifted right by Shift bits.
  Shift must be in the range 0..31 and is adjusted if it is not.
}
function SAR(Value: LongInt; Shift: Byte): LongInt;
begin
  Shift := Shift and 31;
  if Shift = 0 then
  begin
    Result := Value;
    Exit;
  end;
  Result := LongInt(LongWord(Value) shr Shift);
  if Value < 0 then
    Result := LongInt(LongWord(Result) or ($FFFFFFFF shl (32 - Shift)));
end;

{
  Scales the given rectangle by the given scale factor and returns the scaled
  rectangle.
}
function ScaleRect(const ARect: Types.TRect; AScaling: Double): Types.TRect;
begin
  Result.Left := System.Round(ARect.Left * AScaling);
  Result.Top := System.Round(ARect.Top * AScaling);
  Result.Right := System.Round(ARect.Right * AScaling);
  Result.Bottom := System.Round(ARect.Bottom * AScaling);
end;

{
  Returns the sign of the given floating point value. Returns -1 if the value is
  positive, 0 if zero or +1 if negative.
}
function SignOfFloat(const Value: Extended): Integer;
begin
  if Value < 0.0 then
    Result := -1
  else if Value = 0.0 then
    Result := 0
  else
    Result := 1;
end;

{
  Returns the sign of the given integer. Returns -1 if the integer is positive,
  0 if zero or +1 if negative.
}
function SignOfInt(const Value: Int64): Integer;
begin
  if Value < 0 then
    Result := -1
  else if Value = 0 then
    Result := 0
  else
    Result := 1;
end;

{
  Simplifies the fraction with numerator Num and denominator Denom to its lowest
  terms.
  If the fraction is already in its lowest terms then Num and Denom are left
  unchanged.
}
procedure SimplifyFraction(var Num, Denom: Int64);
var
  CommonFactor: Int64;  // greatest common factor of Num and Denom
begin
  Assert(Denom <> 0);
  CommonFactor := Abs(GCD(Num, Denom));
  Num := Num div CommonFactor;
  Denom := Denom div CommonFactor;
end;

{
  Applies the softmax function to each element of floating point array A and
  normalizes them into a probability distribution proportional to the
  exponentials of the elements of A. The normalised values are returned as an
  array of the same size as A.
  An EArgumentException exception is raised if A is empty.
}
function SoftMax(const A: array of Double): Types.TDoubleDynArray;
var
  LSEOfA: Double;
  Idx: Integer;
begin
  LSEOfA := LSE(A); // raise EArgumentException if A is empty
  System.SetLength(Result, System.Length(A));
  for Idx := 0 to Pred(System.Length(A)) do
    Result[Idx] := System.Exp(A[Idx] - LSEOfA);
end;

{
  Stretches rectangle R by the given scaling factors and returns the result.
  The rectangle's width is scaled by ScalingX and its height by ScalingY.
  The top left corner of the rectangle is not changed.
}
function StretchRect(const R: Types.TRect; const ScalingX, ScalingY: Double):
  Types.TRect; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sErrorMsg = 'StretchRect(): Rectangle bottom or right out of bounds.';
var
  NewW, NewH: Double;  // stretched width and height of rectangle
begin
  NewW := (R.Right - R.Left) * ScalingX;
  NewH := (R.Bottom - R.Top) * ScalingY;
  if (Abs(NewW + R.Left) > High(LongInt))
    or (Abs(NewH + R.Top) > High(LongInt)) then
    raise SysUtils.EOverflow.Create(sErrorMsg);
  Result := Types.Bounds(R.Left, R.Top, System.Round(NewW), System.Round(NewH));
end;

{
  Stretches the rectangle R by scale factor Scaling and returns the result. Both
  width and height are stretched by the same scale factor.
  The top left corner is not changed.
}
function StretchRect(const R: Types.TRect; const Scaling: Double):
  Types.TRect; overload;
begin
  Result := StretchRect(R, Scaling, Scaling);
end;

{
  Returns the sum of the natural logarithms of each Cardinal element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Cardinal): Extended; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Cardinal;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Elem = 0 then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each Double floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Double): Double; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Double;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Math.Sign(Elem) <> Math.PositiveValue then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each Extended floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Extended): Extended; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Extended;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Math.Sign(Elem) <> Math.PositiveValue then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each Int64 element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Int64): Extended; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Int64;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Elem <= 0 then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each Integer element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of Integer): Extended; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Integer;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Elem <= 0 then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each Single floating point
  element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0.0 is returned if A is empty.
}
function SumOfLogs(const A: array of Single): Single; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: Single;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Math.Sign(Elem) <> Math.PositiveValue then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Returns the sum of the natural logarithms of each UInt64 element of array A.
  All elements of A must be positive. An exception is raised otherwise.
  0 is returned if A is empty.
}
function SumOfLogs(const A: array of UInt64): Extended; overload;
{$IFDEF FPC}
const
{$ELSE}
resourcestring
{$ENDIF}
  sNotPositive = 'All elements of array A must be > 0';
var
  Elem: UInt64;
begin
  Result := 0.0;
  for Elem in A do
  begin
    if Elem = 0 then
      raise SysUtils.EArgumentOutOfRangeException.Create(sNotPositive);
    Result := Result + System.Ln(Elem);
  end;
end;

{
  Calculates the sum of the reciprocal values of all elements of Cardinal array
  A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Cardinal): Double; overload;
var
  Elem: Cardinal;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for Elem in A do
  begin
    if Elem = 0 then
      raise SysUtils.EArgumentException.Create('Array values must be > 0');
    Result := Result + 1 / Elem;
  end;
end;

{
  Calculates the sum of the reciprocal values of all elements of Double array A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Double): Double; overload;
var
  Elem: Double;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for Elem in A do
  begin
    if Math.Sign(Elem) <> Math.PositiveValue then
      raise SysUtils.EArgumentException.Create('Array values must be > 0');
    Result := Result + 1 / Elem;
  end;
end;

{
  Calculates the sum of the reciprocal values of all elements of Integer array
  A.
  A must not be empty and all its elements must be positive. EArgumentException
  is raised if either of these conditions is not satisfied.
}
function SumOfReciprocals(const A: array of Integer): Double; overload;
var
  Elem: Integer;
begin
  if System.Length(A) = 0 then
    raise SysUtils.EArgumentException.Create('Array is empty');
  Result := 0.0;
  for Elem in A do
  begin
    if Elem <= 0 then
      raise SysUtils.EArgumentException.Create('Array values must be > 0');
    Result := Result + 1 / Elem;
  end;
end;

{
  Calculates the statistical total sum of squares of the elements of Double
  array A.
  EArgumentException is raised if A is empty.
}
function TSS(const A: array of Double): Double; overload;
var
  ElemOfA: Double;
  MeanOfA: Double;
begin
  // Note: ArithmeticMean raises an exception if A is empty
  MeanOfA := ArithmeticMean(A);
  Result := 0.0;
  for ElemOfA in A do
    Result := Result + System.Sqr(ElemOfA - MeanOfA);
end;

{
  Calculates the statistical total sum of squares of the elements of Integer
  array A.
  EArgumentException is raised if A is empty.
}
function TSS(const A: array of Integer): Double; overload;
var
  ElemOfA: Double;
  MeanOfA: Double;
begin
  // Note: ArithmeticMean raises an exception if A is empty
  MeanOfA := ArithmeticMean(A);
  Result := 0.0;
  for ElemOfA in A do
    Result := Result + System.Sqr(ElemOfA - MeanOfA);
end;

{
  Calculates and returns the weighted average of the Cardinal elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  DblVals: array of Double;
begin
  SetLength(DblVals, Length(Values));
  for Idx := Low(Values) to High(Values) do
    DblVals[Idx] := Values[Idx];
  Result := WeightedArithmeticMean(DblVals, Weights);
end;

{
  Calculates and returns the weighted average of the Double elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;
var
  WeightSum: Double;
  Weight: Double;
  Idx: Integer;
begin
  if Length(Values) = 0 then
    raise SysUtils.EArgumentException.Create('Array of values is empty');
  if Length(Values) <> Length(Weights) then
    raise SysUtils.EArgumentException.Create(
      'Number of values and number of weights must be the same'
    );
  WeightSum := 0.0;
  for Weight in Weights do
  begin
    if Math.Sign(Weight) = Math.NegativeValue then
      raise SysUtils.EArgumentException.Create('Weights must all be >= 0');
    WeightSum := WeightSum + Weight;
  end;
  if Math.IsZero(WeightSum) then
    raise SysUtils.EArgumentException.Create('All weights are 0');
  Result := 0.0;
  for Idx := Low(Values) to High(Values) do
    Result := Result + Weights[Idx] * Values[Idx] / WeightSum;
end;

{
  Calculates and returns the weighted average of the Integer elements of array
  Values where each element is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero.
}
function WeightedArithmeticMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  DblVals: array of Double;
begin
  SetLength(DblVals, Length(Values));
  for Idx := Low(Values) to High(Values) do
    DblVals[Idx] := Values[Idx];
  Result := WeightedArithmeticMean(DblVals, Weights);
end;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Cardinal values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  FloatValues: Types.TDoubleDynArray;
begin
  System.Setlength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedGeometricMean(FloatValues, Weights);
end;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Double values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;
var
  Sum: Double;
  Idx: Integer;
  NormalisedWeights: Types.TDoubleDynArray;
begin
  if System.Length(Values) = 0 then
    raise SysUtils.EArgumentException.Create('Array of values is empty');
  if System.Length(Values) <> System.Length(Weights) then
    raise SysUtils.EArgumentException.Create(
      'Number of values and number of weights must be the same'
    );
  NormalisedWeights := NormaliseByWeight(Weights);
  Sum := 0.0;
  for Idx := 0 to Pred(System.Length(Values)) do
    Sum := Sum + NormalisedWeights[Idx] * System.Ln(Values[Idx]);
  Result := System.Exp(Sum);
end;

{
  Calculates and returns the weighted geometric mean of the array Values of
  positive Integer values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedGeometricMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  FloatValues: Types.TDoubleDynArray;
begin
  System.Setlength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedGeometricMean(FloatValues, Weights);
end;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Cardinal values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Cardinal;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  FloatValues: Types.TDoubleDynArray;
begin
  System.Setlength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedHarmonicMean(FloatValues, Weights);
end;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Double values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Double;
  const Weights: array of Double): Double; overload;
var
  Sum: Double;
  Idx: Integer;
  NormalisedWeights: Types.TDoubleDynArray;
begin
  if System.Length(Values) = 0 then
    raise SysUtils.EArgumentException.Create('Array of values is empty');
  if System.Length(Values) <> System.Length(Weights) then
    raise SysUtils.EArgumentException.Create(
      'Number of values and number of weights must be the same'
    );
  NormalisedWeights := NormaliseByWeight(Weights);
  Sum := 0.0;
  for Idx := 0 to Pred(System.Length(Values)) do
    Sum := Sum + NormalisedWeights[Idx] / Values[Idx];
  Result := 1.0 / Sum;
end;

{
  Calculates and returns the weighted harmonic mean of the array Values of
  positive Integer values where each element is weighted by the corresponding
  element in the array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; all elements of Values
  must be positive; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero.
}
function WeightedHarmonicMean(const Values: array of Integer;
  const Weights: array of Double): Double; overload;
var
  Idx: Integer;
  FloatValues: Types.TDoubleDynArray;
begin
  System.Setlength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedHarmonicMean(FloatValues, Weights);
end;

{
  Returns the weighted power mean of the elements of Cardinal array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; Values & Weights must
  have the same number of elements; all elements of Weights must be
  non-negative, with at least one element being non-zero; Lambda must not be
  zero.
}
function WeightedPowerMean(const Values: array of Cardinal;
  const Weights: array of Double; const Lambda: Double): Double; overload;
var
  FloatValues: Types.TDoubleDynArray;
  Idx: Integer;
begin
  System.SetLength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedPowerMean(FloatValues, Weights, Lambda);
end;

{
  Returns the weighted power mean of the elements of Double array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; no element of Values may
  be negative; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero; Lambda must not be zero.
}
function WeightedPowerMean(const Values, Weights: array of Double;
  const Lambda: Double): Double; overload;
var
  NormalisedWeights: Types.TDoubleDynArray;
  PowerSum: Double;
  Idx: Integer;
  Value: Double;
  Weight: Double;
begin
  if System.Length(Values) = 0 then
    raise SysUtils.EArgumentException.Create('Array of values is empty');
  if System.Length(Values) <> System.Length(Weights) then
    raise SysUtils.EArgumentException.Create(
      'Number of values and number of weights must be the same'
    );
  if Math.IsZero(Lambda) then
    raise SysUtils.EArgumentException.Create('Lambda must not be zero');
  NormalisedWeights := NormaliseByWeight(Weights);
  PowerSum := 0.0;
  for Idx := 0 to Pred(System.Length(Values)) do
  begin
    Value := Values[Idx];
    Weight := NormalisedWeights[Idx];
    if Math.Sign(Value) = Math.NegativeValue then
      raise SysUtils.EArgumentException.Create(
        'All values must be non-negative'
      );
    if not Math.IsZero(Value) and not Math.IsZero(Weight) then
      PowerSum := PowerSum + Weight * Math.Power(Value, Lambda);
  end;
  if not Math.IsZero(PowerSum) then
    Result := Math.Power(PowerSum, 1 / Lambda)
  else
    Result := 0.0;
end;

{
  Returns the weighted power mean of the elements of Integer array Values, with
  exponent Lambda. Each term is weighted by the corresponding element in the
  array Weights.
  An EArgumentException exception is raised if any of the following
  pre-conditions are not met: Values must be non-empty; no element of Values may
  be negative; Values & Weights must have the same number of elements; all
  elements of Weights must be non-negative, with at least one element being
  non-zero; Lambda must not be zero.
}
function WeightedPowerMean(const Values: array of Integer;
  const Weights: array of Double; const Lambda: Double): Double; overload;
var
  FloatValues: Types.TDoubleDynArray;
  Idx: Integer;
begin
  System.SetLength(FloatValues, System.Length(Values));
  for Idx := 0 to Pred(System.Length(Values)) do
    FloatValues[Idx] := Values[Idx];
  Result := WeightedPowerMean(FloatValues, Weights, Lambda);
end;

{
  Calculates and returns the largest scaling that can be applied to a rectangle
  of width SrcWidth and height SrcHeight to fit it, without changing the aspect
  ratio, within a second rectangle of width DestWidth and height DestHeight.
}
function ZoomRatio(const DestWidth, DestHeight, SrcWidth, SrcHeight: Integer):
  Double; overload;
begin
  Result := Math.Min(DestWidth / SrcWidth, DestHeight / SrcHeight);
end;

{
  Calculates and returns the largest scaling that can be applied to a rectangle
  of size SrcSize to fit it, without changing the aspect ratio, within a second
  rectangle of size DestSize.
}
function ZoomRatio(const DestSize, SrcSize: Types.TSize): Double; overload;
begin
  Result := ZoomRatio(DestSize.cx, DestSize.cy, SrcSize.cx, SrcSize.cy);
end;

{
  Calculates and returns the largest scaling that can be applied to rectangle
  SrcRect to fit it, without changing the aspect ratio, within rectangle
  DestRect.
}
function ZoomRatio(const DestRect, SrcRect: Types.TRect): Double; overload;
begin
  Result := ZoomRatio(RectSize(DestRect), RectSize(SrcRect));
end;

end.
