# Contributing to vue3-extended-multiselect

Thank you for considering contributing! I welcome all forms of contributions, including:

- 🐛 Bug reports
- 🚀 Feature requests
- 📚 Documentation improvements
- 💻 Code contributions
- 🧪 Test cases
- 🔍 Code reviews

## Before You Start

1. **Read our [Code of Conduct](CODE_OF_CONDUCT.md)** — I enforce it strictly
2. **Check existing issues** — Avoid duplicates
3. **For large changes**, open an issue first to discuss

## Development Setup

### Prerequisites

- Node.js 18+
- npm 8+
- Git

### Development Setup

1. Fork the repository
2. Clone your fork
3. Install dependencies: `npm ci`
4. Create a feature branch

### Branch Naming

Common types:

- `feat/` — New features
- `fix/` — Bug fixes
- `docs/` — Documentation
- `chore/` — Maintenance tasks

Examples:

- `feat/new-component-prop`
- `fix/issue-123-null-check`
- `docs/update-readme`

### Commit Guidelines

- Use conventional commits format
- Reference issues with #issue-number
- Keep commits atomic

Example: `feat(diff): add new component prop "future-prop"`

### Pull Requests

1. Ensure tests pass (`npm run test:unit`)
2. Update documentation
3. Keep PRs focused on single feature/bug
4. Include test cases

**Description** should include:

- Purpose of changes
- Related issues (use `#123`)
- Testing performed
- Screenshots if applicable

## Thanks for contributing! ✨
