//
//  DemoAppearance.swift
//  Demo
//
//  Created by Daniel Saidi on 2020-12-07.
//  Copyright © 2020 Daniel Saidi. All rights reserved.
//

import Foundation
#if os(iOS)
import UIKit
#endif

final class DemoAppearance {
    
    private init() {}
    
    static func apply() {
        #if os(iOS)
        if #available(iOS 13.0, *) {
            let navbar = UINavigationBar.appearance()
            let navbarAppearance = UINavigationBarAppearance()
            navbarAppearance.configureWithOpaqueBackground()
            navbarAppearance.backgroundColor = .accent
            navbarAppearance.titleTextAttributes = titleAttributes
            navbarAppearance.largeTitleTextAttributes = largeTitleAttributes
            navbar.tintColor = .white
            navbar.standardAppearance = navbarAppearance
            navbar.scrollEdgeAppearance = navbarAppearance
        }
        #endif
    }
}

#if os(iOS)
private extension DemoAppearance {
    
    static var titleAttributes: [NSAttributedString.Key: Any] {
        [.font: UIFont(name: "Knewave-Regular", size: 20)!, .foregroundColor: UIColor.white, .shadow: shadow]
    }
    
    static var largeTitleAttributes: [NSAttributedString.Key: Any] {
        [.font: UIFont(name: "Knewave-Regular", size: 40)!, .foregroundColor: UIColor.white, .shadow: shadow]
    }
    
    static var shadow: NSShadow {
        let shadow = NSShadow()
        shadow.shadowBlurRadius = 5
        shadow.shadowColor = UIColor.clear
        return shadow
    }
}
#endif
