### CBadge

```jsx
import { CBadge } from '@coreui/vue'
// or
import CBadge from '@coreui/vue/src/components/badge/CBadge'
```

#### Props

| Prop name                                                        | Description                                                                                                                                                               | Type   | Values                                                                                                                                                                                                                                                                                                                                                                      | Default |
| ---------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------- |
| **as**                                                           | Component used for the root node. Either a string to use a HTML element or a component.                                                                                   | string | -                                                                                                                                                                                                                                                                                                                                                                           | 'span'  |
| **color**                                                        | Sets the color context of the component to one of CoreUI’s themed colors.                                                                                                 | string | `'primary'`, `'secondary'`, `'success'`, `'danger'`, `'warning'`, `'info'`, `'dark'`, `'light'`                                                                                                                                                                                                                                                                             | -       |
| **position**                                                     | Position badge in one of the corners of a link or button.                                                                                                                 | string | `'top-start'`, `'top-end'`, `'bottom-end'`, `'bottom-start'`                                                                                                                                                                                                                                                                                                                | -       |
| **shape**                                                        | Select the shape of the component.                                                                                                                                        | string | `'rounded'`, `'rounded-top'`, `'rounded-end'`, `'rounded-bottom'`, `'rounded-start'`, `'rounded-circle'`, `'rounded-pill'`, `'rounded-0'`, `'rounded-1'`, `'rounded-2'`, `'rounded-3'`                                                                                                                                                                                      | -       |
| **size**                                                         | Size the component small.                                                                                                                                                 | string | `'sm'`                                                                                                                                                                                                                                                                                                                                                                      | -       |
| **text-bg-color** <br><div class="badge bg-primary">5.0.0+</div> | Sets the component's color scheme to one of CoreUI's themed colors, ensuring the text color contrast adheres to the WCAG 4.5:1 contrast ratio standard for accessibility. | string | `'primary'`, `'secondary'`, `'success'`, `'danger'`, `'warning'`, `'info'`, `'dark'`, `'light'`                                                                                                                                                                                                                                                                             | -       |
| **text-color**                                                   | Sets the text color of the component to one of CoreUI’s themed colors.                                                                                                    | string | `'primary'`, `'secondary'`, `'success'`, `'danger'`, `'warning'`, `'info'`, `'dark'`, `'light'`, `'primary-emphasis'`, `'secondary-emphasis'`, `'success-emphasis'`, `'danger-emphasis'`, `'warning-emphasis'`, `'info-emphasis'`, `'light-emphasis'`, `'body'`, `'body-emphasis'`, `'body-secondary'`, `'body-tertiary'`, `'black'`, `'black-50'`, `'white'`, `'white-50'` | -       |
