---
title: Migration to v5
description: Track and review changes to the CoreUI for Vue.js components to help you migrate from v4 to v5.
---

CoreUI for Vue is the Vue.js version of CoreUI components library, so before read this migration guide, please check also [CoreUI 4 to 5 migration guide](https://coreui.io/docs/migration/v5/).

## Components

### CAlertHeading

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CAvatar

- Deprecated `textColor` values: `muted`, `high-emphasis`, `medium-emphasis`, `disabled`, `high-emphasis-inverse`, `medium-emphasis-inverse`, `disabled-inverse`.
- New `textColor` values: `primary-emphasis`, `secondary-emphasis`, `success-emphasis`, `danger-emphasis`, `warning-emphasis`, `info-emphasis`, `light-emphasis`, `body`, `body-emphasis`, `body-secondary`, `body-tertiary`, `black`, `black-50`, `white`, `white-50`.

### CBadge

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.
- Deprecated `textColor` values: `muted`, `high-emphasis`, `medium-emphasis`, `disabled`, `high-emphasis-inverse`, `medium-emphasis-inverse`, `disabled-inverse`.
- New `textColor` values: `primary-emphasis`, `secondary-emphasis`, `success-emphasis`, `danger-emphasis`, `warning-emphasis`, `info-emphasis`, `light-emphasis`, `body`, `body-emphasis`, `body-secondary`, `body-tertiary`, `black`, `black-50`, `white`, `white-50`.

### CButton

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCard

- Deprecated `textColor` values: `muted`, `high-emphasis`, `medium-emphasis`, `disabled`, `high-emphasis-inverse`, `medium-emphasis-inverse`, `disabled-inverse`.
- New `textColor` values: `primary-emphasis`, `secondary-emphasis`, `success-emphasis`, `danger-emphasis`, `warning-emphasis`, `info-emphasis`, `light-emphasis`, `body`, `body-emphasis`, `body-secondary`, `body-tertiary`, `black`, `black-50`, `white`, `white-50`.

### CCardHeader

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCardImage

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCardSubtitle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCardText

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCardTitle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CCloseButton

- Deprecated property `white`, use `dark` instead of.

### CDropdown

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CDropdownHeader

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CDropdownItem

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CDropdownItemPlain

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CDropdownMenu

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CDropdownToggle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CFormFeedback

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CFormText

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CHeaderBrand

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CHeaderNav

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CInputGroupText

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CLink

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CListGroup

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CListGroupItem

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CModalTitle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNav

- The `underline` variant has been changed to `underline-border`

### CNavbar

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNavbarBrand

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNavbarNav

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNavItem

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNavLink

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CNavTitle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### COffcanvasTitle

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CPaginationItem

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CPlaceholder

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CSidebar

- <span class="badge bg-danger">Breaking</span> Sidebar has a light color scheme by default, use `colorScheme="dark"` to make it dark.

### CSpinner

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.

### CToastClose

- <span class="badge bg-danger">Breaking</span> Renamed `component` property to `as`.
- Deprecated property `white`, use `dark` instead of.
