### CDropdown

```jsx
import { CDropdown } from '@coreui/vue'
// or
import CDropdown from '@coreui/vue/src/components/dropdown/CDropdown'
```

#### Props

| Prop name                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Type                                         | Values                                                                                                                                                                                        | Default        |
| ------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------- |
| **alignment**                                                      | Set aligment of dropdown menu.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | string \| Alignments                         | `{ 'start' \| 'end' \| { xs: 'start' \| 'end' } \| { sm: 'start' \| 'end' } \| { md: 'start' \| 'end' } \| { lg: 'start' \| 'end' } \| { xl: 'start' \| 'end'} \| { xxl: 'start' \| 'end'} }` | -              |
| **auto-close**                                                     | Configure the auto close behavior of the dropdown:<br>- `true` - the dropdown will be closed by clicking outside or inside the dropdown menu.<br>- `false` - the dropdown will be closed by clicking the toggle button and manually calling hide or toggle method. (Also will not be closed by pressing esc key)<br>- `'inside'` - the dropdown will be closed (only) by clicking inside the dropdown menu.<br>- `'outside'` - the dropdown will be closed (only) by clicking outside the dropdown menu. | boolean\|string                              | -                                                                                                                                                                                             | true           |
| **container** <br><div class="badge bg-primary">v5.0.0-rc.2+</div> | Appends the vue dropdown menu to a specific element. You can pass an HTML element or function that returns a single element. By default `document.body`.                                                                                                                                                                                                                                                                                                                                                 | HTMLElement \| (() => HTMLElement) \| string | -                                                                                                                                                                                             | 'body'         |
| **dark**                                                           | Sets a darker color scheme to match a dark navbar.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | boolean                                      | -                                                                                                                                                                                             | -              |
| **direction**                                                      | Sets a specified direction and location of the dropdown menu.                                                                                                                                                                                                                                                                                                                                                                                                                                            | string                                       | `'center'`, `'dropup'`, `'dropup-center'`, `'dropend'`, `'dropstart'`                                                                                                                         | -              |
| **disabled**                                                       | Toggle the disabled state for the component.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean                                      | -                                                                                                                                                                                             | -              |
| **offset** <br><div class="badge bg-primary">4.9.0+</div>          | Offset of the dropdown menu relative to its target.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | array                                        | -                                                                                                                                                                                             | [0, 2]         |
| **placement**                                                      | Describes the placement of your component after Popper.js has applied all the modifiers that may have flipped or altered the originally provided placement property.                                                                                                                                                                                                                                                                                                                                     | Placement                                    | `'auto'`, `'top-end'`, `'top'`, `'top-start'`, `'bottom-end'`, `'bottom'`, `'bottom-start'`, `'right-start'`, `'right'`, `'right-end'`, `'left-start'`, `'left'`, `'left-end'`                | 'bottom-start' |
| **popper**                                                         | If you want to disable dynamic positioning set this property to `true`.                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean                                      | -                                                                                                                                                                                             | true           |
| **teleport** <br><div class="badge bg-primary">v5.0.0-rc.2+</div>  | Generates dropdown menu using Teleport.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean                                      | -                                                                                                                                                                                             | false          |
| **trigger**                                                        | Sets which event handlers you’d like provided to your toggle prop. You can specify one trigger or an array of them.                                                                                                                                                                                                                                                                                                                                                                                      | Triggers                                     | -                                                                                                                                                                                             | 'click'        |
| **variant**                                                        | Set the dropdown variant to an btn-group, dropdown, input-group, and nav-item.                                                                                                                                                                                                                                                                                                                                                                                                                           | string                                       | `'btn-group'`, `'dropdown'`, `'input-group'`, `'nav-item'`                                                                                                                                    | 'btn-group'    |
| **visible**                                                        | Toggle the visibility of dropdown menu component.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean                                      | -                                                                                                                                                                                             | -              |

#### Events

| Event name | Description                                              | Properties |
| ---------- | -------------------------------------------------------- | ---------- |
| **hide**   | Callback fired when the component requests to be hidden. |
| **show**   | Callback fired when the component requests to be shown.  |
