module.exports = {
  parser: '@typescript-eslint/parser', // Specifies the ESLint parser
  parserOptions: {
    ecmaVersion: 2020, // Allows for the parsing of modern ECMAScript features
    sourceType: 'module', // Allows for the use of imports
    extraFileExtensions: ['.vue'],
  },
  extends: [
    'eslint:recommended',
    'plugin:vue/vue3-recommended',
    'plugin:prettier/recommended',
    'plugin:unicorn/recommended',
    '@vue/eslint-config-typescript/recommended',
    '@vue/eslint-config-prettier',
  ],
  rules: {
    'no-console': process.env.NODE_ENV === 'production' ? 'warn' : 'off',
    'no-debugger': process.env.NODE_ENV === 'production' ? 'warn' : 'off',
    'unicorn/filename-case': 'off',
    'unicorn/no-array-for-each': 'off',
    'unicorn/no-null': 'off',
    'unicorn/prefer-dom-node-append': 'off',
    'unicorn/prefer-export-from': 'off',
    'unicorn/prefer-query-selector': 'off',
    'unicorn/prevent-abbreviations': 'off',
    'vue/require-default-prop': 'off',
  },
  overrides: [
    {
      files: ['**/*.mjs'],
      env: {
        env: {
          browser: false,
          node: true,
        },
        parserOptions: {
          sourceType: 'module',
        },
      },
    },
    {
      files: ['**/__tests__/*.{j,t}s?(x)', '**/tests/unit/**/*.spec.{j,t}s?(x)'],
      env: {
        jest: true,
      },
    },
    {
      files: ['packages/docs/build/**'],
      env: {
        env: {
          browser: false,
          node: true,
        },
        parserOptions: {
          sourceType: 'script',
        },
        rules: {
          'no-console': 'off',
          strict: 'error',
        },
      },
    },
  ],
}
